/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.io.IOException;
import java.nio.channels.Channel;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.auth.pubkey.AbstractKeyPairIterator;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.auth.pubkey.KeyPairIdentity;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.util.helper.LazyIterablesConcatenator;
import org.apache.sshd.common.util.helper.LazyMatchingTypeIterator;

public class UserAuthPublicKeyIterator
extends AbstractKeyPairIterator<PublicKeyIdentity>
implements Channel {
    private final AtomicBoolean open = new AtomicBoolean(true);
    private Iterator<? extends PublicKeyIdentity> current;
    private SshAgent agent;

    public UserAuthPublicKeyIterator(ClientSession session, SignatureFactoriesManager signatureFactories) throws Exception {
        super(session);
        try {
            Iterable<KeyPairIdentity> sessionIds;
            ArrayList<Iterable<Object>> identities = new ArrayList<Iterable<Object>>(2);
            Iterable<KeyAgentIdentity> agentIds = this.initializeAgentIdentities(session);
            if (agentIds != null) {
                identities.add(agentIds);
            }
            if ((sessionIds = this.initializeSessionIdentities(session, signatureFactories)) != null) {
                identities.add(sessionIds);
            }
            if (identities.isEmpty()) {
                this.current = Collections.emptyIterator();
            } else {
                Iterable keys = LazyIterablesConcatenator.lazyConcatenateIterables(identities);
                this.current = LazyMatchingTypeIterator.lazySelectMatchingTypes(keys.iterator(), PublicKeyIdentity.class);
            }
        }
        catch (Exception e) {
            try {
                this.closeAgent();
            }
            catch (Exception err) {
                e.addSuppressed(err);
            }
            throw e;
        }
    }

    protected Iterable<KeyPairIdentity> initializeSessionIdentities(final ClientSession session, final SignatureFactoriesManager signatureFactories) {
        return new Iterable<KeyPairIdentity>(){
            private final String sessionId;
            private final AtomicReference<Iterable<KeyPair>> keysHolder;
            {
                this.sessionId = session.toString();
                this.keysHolder = new AtomicReference();
            }

            @Override
            public Iterator<KeyPairIdentity> iterator() {
                if (this.keysHolder.get() == null) {
                    try {
                        KeyIdentityProvider sessionKeysProvider = ClientSession.providerOf(session);
                        this.keysHolder.set(sessionKeysProvider.loadKeys((SessionContext)session));
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new IllegalArgumentException("Unexpected " + e.getClass().getSimpleName() + ") keys loading exception: " + e.getMessage(), e);
                    }
                }
                return new Iterator<KeyPairIdentity>(){
                    private final Iterator<KeyPair> keys;
                    {
                        Iterable sessionKeys = Objects.requireNonNull((Iterable)keysHolder.get(), "No session keys available");
                        this.keys = sessionKeys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keys.hasNext();
                    }

                    @Override
                    public KeyPairIdentity next() {
                        KeyPair kp = this.keys.next();
                        return new KeyPairIdentity(signatureFactories, session, kp);
                    }

                    public String toString() {
                        return KeyPairIdentity.class.getSimpleName() + "[iterator][" + sessionId + "]";
                    }
                };
            }

            public String toString() {
                return KeyPairIdentity.class.getSimpleName() + "[iterable][" + this.sessionId + "]";
            }
        };
    }

    protected Iterable<KeyAgentIdentity> initializeAgentIdentities(ClientSession session) throws IOException {
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No session factory manager");
        SshAgentFactory factory = manager.getAgentFactory();
        if (factory == null) {
            return null;
        }
        this.agent = factory.createClient(session, manager);
        if (this.agent == null) {
            return null;
        }
        return new Iterable<KeyAgentIdentity>(){
            private final Iterable<? extends Map.Entry<PublicKey, String>> agentIds;
            private final String agentId;
            {
                this.agentIds = UserAuthPublicKeyIterator.this.agent.getIdentities();
                this.agentId = UserAuthPublicKeyIterator.this.agent.toString();
            }

            @Override
            public Iterator<KeyAgentIdentity> iterator() {
                return new Iterator<KeyAgentIdentity>(){
                    private final Iterator<? extends Map.Entry<PublicKey, String>> iter;
                    {
                        this.iter = agentIds.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public KeyAgentIdentity next() {
                        Map.Entry<PublicKey, String> kp = this.iter.next();
                        return new KeyAgentIdentity(UserAuthPublicKeyIterator.this.agent, kp.getKey(), kp.getValue());
                    }

                    public String toString() {
                        return KeyAgentIdentity.class.getSimpleName() + "[iterator][" + agentId + "]";
                    }
                };
            }

            public String toString() {
                return KeyAgentIdentity.class.getSimpleName() + "[iterable][" + this.agentId + "]";
            }
        };
    }

    @Override
    public boolean hasNext() {
        if (!this.isOpen()) {
            return false;
        }
        return this.current.hasNext();
    }

    @Override
    public PublicKeyIdentity next() {
        if (!this.isOpen()) {
            throw new NoSuchElementException("Iterator is closed");
        }
        return this.current.next();
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.closeAgent();
        }
    }

    protected void closeAgent() throws IOException {
        if (this.agent != null) {
            try {
                this.agent.close();
            }
            finally {
                this.agent = null;
            }
        }
    }
}

