/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.visualvm.core.datasupport.Positionable;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.snapshot.SnapshotCategoriesListener;
import org.graalvm.visualvm.core.snapshot.SnapshotCategory;

public final class RegisteredSnapshotCategories {
    private static RegisteredSnapshotCategories sharedInstance;
    private final Set<SnapshotCategoriesListener> listeners = Collections.synchronizedSet(new HashSet());
    private final Set<SnapshotCategory<?>> categories = Collections.synchronizedSet(new HashSet());

    public static synchronized RegisteredSnapshotCategories sharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new RegisteredSnapshotCategories();
        }
        return sharedInstance;
    }

    public void addCategoriesListener(SnapshotCategoriesListener listener) {
        this.listeners.add(listener);
    }

    public void removeCategoriesListener(SnapshotCategoriesListener listener) {
        this.listeners.remove(listener);
    }

    public void registerCategory(SnapshotCategory category) {
        this.categories.add(category);
        this.fireCategoryRegistered(category);
    }

    public void unregisterCategory(SnapshotCategory category) {
        this.categories.remove(category);
        this.fireCategoryUnregistered(category);
    }

    public List<SnapshotCategory<? extends Snapshot>> getVisibleCategories() {
        ArrayList allCategories = new ArrayList(this.categories);
        ArrayList<SnapshotCategory<? extends Snapshot>> visibleCategories = new ArrayList<SnapshotCategory<? extends Snapshot>>();
        for (SnapshotCategory snapshotCategory : allCategories) {
            if (snapshotCategory.getPreferredPosition() == Integer.MIN_VALUE) continue;
            visibleCategories.add(snapshotCategory);
        }
        Collections.sort(visibleCategories, Positionable.COMPARATOR);
        return visibleCategories;
    }

    public List<SnapshotCategory> getOpenSnapshotCategories() {
        ArrayList allCategories = new ArrayList(this.categories);
        ArrayList<SnapshotCategory> openSnapshotCategories = new ArrayList<SnapshotCategory>();
        for (SnapshotCategory snapshotCategory : allCategories) {
            if (!snapshotCategory.supportsOpenSnapshot()) continue;
            openSnapshotCategories.add(snapshotCategory);
        }
        Collections.sort(openSnapshotCategories, Positionable.COMPARATOR);
        return openSnapshotCategories;
    }

    public List<SnapshotCategory> getAllCategories() {
        ArrayList<SnapshotCategory> allCategories = new ArrayList<SnapshotCategory>(this.categories);
        Collections.sort(allCategories, Positionable.COMPARATOR);
        return allCategories;
    }

    private void fireCategoryRegistered(SnapshotCategory category) {
        HashSet<SnapshotCategoriesListener> listenersSet = new HashSet<SnapshotCategoriesListener>(this.listeners);
        for (SnapshotCategoriesListener listener : listenersSet) {
            listener.categoryRegistered(category);
        }
    }

    private void fireCategoryUnregistered(SnapshotCategory category) {
        HashSet<SnapshotCategoriesListener> listenersSet = new HashSet<SnapshotCategoriesListener>(this.listeners);
        for (SnapshotCategoriesListener listener : listenersSet) {
            listener.categoryUnregistered(category);
        }
    }

    private RegisteredSnapshotCategories() {
    }
}

