/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.db.TableHistory;
import org.parosproxy.paros.db.paros.ParosAbstractTable;
import org.parosproxy.paros.extension.option.DatabaseParam;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class ParosTableHistory
extends ParosAbstractTable
implements TableHistory {
    private static final String TABLE_NAME = "HISTORY";
    private static final String HISTORYID = "HISTORYID";
    private static final String SESSIONID = "SESSIONID";
    private static final String HISTTYPE = "HISTTYPE";
    private static final String METHOD = "METHOD";
    private static final String URI = "URI";
    private static final String STATUSCODE = "STATUSCODE";
    private static final String TIMESENTMILLIS = "TIMESENTMILLIS";
    private static final String TIMEELAPSEDMILLIS = "TIMEELAPSEDMILLIS";
    private static final String REQHEADER = "REQHEADER";
    private static final String REQBODY = "REQBODY";
    private static final String RESHEADER = "RESHEADER";
    private static final String RESBODY = "RESBODY";
    private static final String TAG = "TAG";
    private static final String NOTE = "NOTE";
    private static final String RESPONSE_FROM_TARGET_HOST = "RESPONSEFROMTARGETHOST";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psDelete = null;
    private PreparedStatement psDeleteTemp = null;
    private PreparedStatement psContainsURI = null;
    private PreparedStatement psUpdateNote = null;
    private int lastInsertedIndex;
    private static boolean isExistStatusCode = false;
    private static final Logger log = LogManager.getLogger(ParosTableHistory.class);
    private boolean bodiesAsBytes;
    int configuredrequestbodysize = -1;
    int configuredresponsebodysize = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            DatabaseParam dbparams = new DatabaseParam();
            dbparams.load(Constant.getInstance().FILE_CONFIG);
            this.configuredrequestbodysize = dbparams.getRequestBodySize();
            this.configuredresponsebodysize = dbparams.getResponseBodySize();
            this.bodiesAsBytes = true;
            this.updateTable(conn);
            isExistStatusCode = DbUtils.hasColumn(conn, TABLE_NAME, STATUSCODE);
            this.psRead = conn.prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE HISTORYID = ?");
            this.psDelete = conn.prepareStatement("DELETE FROM HISTORY WHERE HISTORYID = ?");
            this.psDeleteTemp = conn.prepareStatement("DELETE FROM HISTORY WHERE HISTTYPE IN (?) LIMIT 1000");
            this.psContainsURI = conn.prepareStatement("SELECT TOP 1 HISTORYID FROM HISTORY WHERE URI = ? AND  METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND HISTTYPE = ?");
            this.psInsert = isExistStatusCode ? conn.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,TIMESENTMILLIS,TIMEELAPSEDMILLIS,METHOD,URI,REQHEADER,REQBODY,RESHEADER,RESBODY,TAG, STATUSCODE,NOTE, RESPONSEFROMTARGETHOST) VALUES (?, ? ,?, ?, ?, ?, ?, ? ,? , ?, ?, ?, ?, ?)") : conn.prepareStatement("INSERT INTO HISTORY (SESSIONID,HISTTYPE,TIMESENTMILLIS,TIMEELAPSEDMILLIS,METHOD,URI,REQHEADER,REQBODY,RESHEADER,RESBODY,TAG,NOTE, RESPONSEFROMTARGETHOST) VALUES (?, ? ,?, ?, ?, ?, ?, ? ,? , ? , ?, ?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psUpdateNote = conn.prepareStatement("UPDATE HISTORY SET NOTE = ? WHERE HISTORYID = ?");
            int currentIndex = 0;
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement("SELECT TOP 1 HISTORYID FROM HISTORY ORDER BY HISTORYID DESC");
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        currentIndex = rs.getInt(1);
                    }
                }
            }
            finally {
                block18: {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e) {
                            if (!log.isDebugEnabled()) break block18;
                            log.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            this.lastInsertedIndex = currentIndex;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private void updateTable(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasColumn(connection, TABLE_NAME, TAG)) {
                DbUtils.execute(connection, "ALTER TABLE HISTORY ADD COLUMN TAG VARCHAR(32768) DEFAULT ''");
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, NOTE)) {
                DbUtils.execute(connection, "ALTER TABLE HISTORY ADD COLUMN NOTE VARCHAR(1048576) DEFAULT ''");
            }
            if (DbUtils.getColumnType(connection, TABLE_NAME, REQBODY) != 61) {
                this.bodiesAsBytes = false;
            }
            if (!DbUtils.hasColumn(connection, TABLE_NAME, RESPONSE_FROM_TARGET_HOST)) {
                DbUtils.execute(connection, "ALTER TABLE HISTORY ADD COLUMN RESPONSEFROMTARGETHOST BOOLEAN DEFAULT FALSE");
                DbUtils.executeUpdate(connection, "UPDATE HISTORY SET RESPONSEFROMTARGETHOST = TRUE ");
            }
            int requestbodysizeindb = DbUtils.getColumnSize(connection, TABLE_NAME, REQBODY);
            int responsebodysizeindb = DbUtils.getColumnSize(connection, TABLE_NAME, RESBODY);
            try {
                if (requestbodysizeindb != this.configuredrequestbodysize && this.configuredrequestbodysize > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Extending table HISTORY request body length from " + requestbodysizeindb + " to " + this.configuredrequestbodysize);
                    }
                    DbUtils.execute(connection, "ALTER TABLE HISTORY ALTER COLUMN REQBODY VARBINARY(" + this.configuredrequestbodysize + ")");
                    if (log.isDebugEnabled()) {
                        log.debug("Completed extending table HISTORY request body length from " + requestbodysizeindb + " to " + this.configuredrequestbodysize);
                    }
                }
                if (responsebodysizeindb != this.configuredresponsebodysize && this.configuredresponsebodysize > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("Extending table HISTORY response body length from " + responsebodysizeindb + " to " + this.configuredresponsebodysize);
                    }
                    DbUtils.execute(connection, "ALTER TABLE HISTORY ALTER COLUMN RESBODY VARBINARY(" + this.configuredresponsebodysize + ")");
                    if (log.isDebugEnabled()) {
                        log.debug("Completed extending table HISTORY response body length from " + responsebodysizeindb + " to " + this.configuredresponsebodysize);
                    }
                }
            }
            catch (SQLException e) {
                log.error("An error occurred while modifying a column length on HISTORY");
                log.error("The 'Maximum Request Body Size' value in the Database Options needs to be set to at least " + requestbodysizeindb + " to avoid this error");
                log.error("The 'Maximum Response Body Size' value in the Database Options needs to be set to at least " + responsebodysizeindb + " to avoid this error");
                log.error("The SQL Exception was:", (Throwable)e);
                throw e;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordHistory read(int historyId) throws HttpMalformedHeaderException, DatabaseException {
        try {
            this.psRead.setInt(1, historyId);
            this.psRead.execute();
            RecordHistory result = null;
            try (ResultSet rs = this.psRead.getResultSet();){
                result = this.build(rs);
            }
            return result;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordHistory write(long sessionId, int histType, HttpMessage msg) throws HttpMalformedHeaderException, DatabaseException {
        try {
            String reqHeader = "";
            byte[] reqBody = new byte[]{};
            String resHeader = "";
            byte[] resBody = reqBody;
            String method = "";
            String uri = "";
            int statusCode = 0;
            String note = msg.getNote();
            if (!msg.getRequestHeader().isEmpty()) {
                reqHeader = msg.getRequestHeader().toString();
                reqBody = msg.getRequestBody().getBytes();
                method = msg.getRequestHeader().getMethod();
                uri = msg.getRequestHeader().getURI().toString();
            }
            if (!msg.getResponseHeader().isEmpty()) {
                resHeader = msg.getResponseHeader().toString();
                resBody = msg.getResponseBody().getBytes();
                statusCode = msg.getResponseHeader().getStatusCode();
            }
            return this.write(sessionId, histType, msg.getTimeSentMillis(), msg.getTimeElapsedMillis(), method, uri, statusCode, reqHeader, reqBody, resHeader, resBody, null, note, msg.isResponseFromTargetHost());
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private synchronized RecordHistory write(long sessionId, int histType, long timeSentMillis, int timeElapsedMillis, String method, String uri, int statusCode, String reqHeader, byte[] reqBody, String resHeader, byte[] resBody, String tag, String note, boolean responseFromTargetHost) throws HttpMalformedHeaderException, SQLException, DatabaseException {
        if (reqBody.length > this.configuredrequestbodysize) {
            throw new SQLException("The actual Request Body length " + reqBody.length + " is greater than the configured request body length " + this.configuredrequestbodysize);
        }
        if (resBody.length > this.configuredresponsebodysize) {
            throw new SQLException("The actual Response Body length " + resBody.length + " is greater than the configured response body length " + this.configuredresponsebodysize);
        }
        this.psInsert.setLong(1, sessionId);
        this.psInsert.setInt(2, histType);
        this.psInsert.setLong(3, timeSentMillis);
        this.psInsert.setInt(4, timeElapsedMillis);
        this.psInsert.setString(5, method);
        this.psInsert.setString(6, uri);
        this.psInsert.setString(7, reqHeader);
        if (this.bodiesAsBytes) {
            this.psInsert.setBytes(8, reqBody);
        } else {
            this.psInsert.setString(8, new String(reqBody, StandardCharsets.US_ASCII));
        }
        this.psInsert.setString(9, resHeader);
        if (this.bodiesAsBytes) {
            this.psInsert.setBytes(10, resBody);
        } else {
            this.psInsert.setString(10, new String(resBody, StandardCharsets.US_ASCII));
        }
        this.psInsert.setString(11, tag);
        int currentIdx = 12;
        if (isExistStatusCode) {
            this.psInsert.setInt(currentIdx, statusCode);
            ++currentIdx;
        }
        this.psInsert.setString(currentIdx, note);
        this.psInsert.setBoolean(++currentIdx, responseFromTargetHost);
        this.psInsert.executeUpdate();
        try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
            int id;
            rs.next();
            this.lastInsertedIndex = id = rs.getInt(1);
            RecordHistory recordHistory = this.read(id);
            return recordHistory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordHistory build(ResultSet rs) throws HttpMalformedHeaderException, SQLException {
        RecordHistory history = null;
        try {
            if (rs.next()) {
                byte[] resBody;
                byte[] reqBody;
                if (this.bodiesAsBytes) {
                    reqBody = rs.getBytes(REQBODY);
                    resBody = rs.getBytes(RESBODY);
                } else {
                    reqBody = rs.getString(REQBODY).getBytes();
                    resBody = rs.getString(RESBODY).getBytes();
                }
                history = new RecordHistory(rs.getInt(HISTORYID), rs.getInt(HISTTYPE), rs.getLong(SESSIONID), rs.getLong(TIMESENTMILLIS), rs.getInt(TIMEELAPSEDMILLIS), rs.getString(REQHEADER), reqBody, rs.getString(RESHEADER), resBody, rs.getString(TAG), rs.getString(NOTE), rs.getBoolean(RESPONSE_FROM_TARGET_HOST));
            }
        }
        finally {
            rs.close();
        }
        return history;
    }

    @Override
    public List<Integer> getHistoryIds(long sessionId) throws DatabaseException {
        return this.getHistoryIdsOfHistType(sessionId, null);
    }

    @Override
    public List<Integer> getHistoryIdsStartingAt(long sessionId, int startAtHistoryId) throws DatabaseException {
        return this.getHistoryIdsByParams(sessionId, startAtHistoryId, true, null);
    }

    @Override
    public List<Integer> getHistoryIdsOfHistType(long sessionId, int ... histTypes) throws DatabaseException {
        return this.getHistoryIdsByParams(sessionId, 0, true, histTypes);
    }

    @Override
    public List<Integer> getHistoryIdsOfHistTypeStartingAt(long sessionId, int startAtHistoryId, int ... histTypes) throws DatabaseException {
        return this.getHistoryIdsByParams(sessionId, startAtHistoryId, true, histTypes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Integer> getHistoryIdsByParams(long sessionId, int startAtHistoryId, boolean includeHistTypes, int ... histTypes) throws DatabaseException {
        try {
            boolean hasHistTypes = histTypes != null && histTypes.length > 0;
            int strLength = 121;
            StringBuilder strBuilder = new StringBuilder(121);
            strBuilder.append("SELECT ").append(HISTORYID);
            strBuilder.append(" FROM ").append(TABLE_NAME).append(" WHERE ").append(SESSIONID).append(" = ?");
            if (hasHistTypes) {
                strBuilder.append(" AND ").append(HISTTYPE);
                if (!includeHistTypes) {
                    strBuilder.append(" NOT");
                }
                strBuilder.append(" IN ( UNNEST(?) )");
            }
            if (startAtHistoryId > 0) {
                strBuilder.append(" AND ").append(HISTORYID).append(" >= ?");
            }
            strBuilder.append(" ORDER BY ").append(HISTORYID);
            try (PreparedStatement psReadSession = this.getConnection().prepareStatement(strBuilder.toString());){
                ArrayList<Integer> arrayList;
                block20: {
                    psReadSession.setLong(1, sessionId);
                    int parameterIndex = 2;
                    if (hasHistTypes) {
                        Array arrayHistTypes = this.getConnection().createArrayOf("INTEGER", ArrayUtils.toObject(histTypes));
                        psReadSession.setArray(parameterIndex++, arrayHistTypes);
                    }
                    if (startAtHistoryId > 0) {
                        psReadSession.setInt(parameterIndex++, startAtHistoryId);
                    }
                    ResultSet rs = psReadSession.executeQuery();
                    try {
                        ArrayList<Integer> ids = new ArrayList<Integer>();
                        while (rs.next()) {
                            ids.add(rs.getInt(HISTORYID));
                        }
                        ids.trimToSize();
                        arrayList = ids;
                        if (rs == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public List<Integer> getHistoryIdsExceptOfHistType(long sessionId, int ... histTypes) throws DatabaseException {
        return this.getHistoryIdsByParams(sessionId, 0, false, histTypes);
    }

    @Override
    public List<Integer> getHistoryIdsExceptOfHistTypeStartingAt(long sessionId, int startAtHistoryId, int ... histTypes) throws DatabaseException {
        return this.getHistoryIdsByParams(sessionId, startAtHistoryId, false, histTypes);
    }

    @Deprecated
    public Vector<Integer> getHistoryList(long sessionId, int histType) throws DatabaseException {
        return new Vector<Integer>(this.getHistoryIdsOfHistType(sessionId, histType));
    }

    @Deprecated
    public Vector<Integer> getHistoryList(long sessionId) throws DatabaseException {
        return new Vector<Integer>(this.getHistoryIds(sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getHistoryList(long sessionId, int histType, String filter, boolean isRequest) throws DatabaseException {
        try {
            PreparedStatement psReadSearch = this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE SESSIONID = ? AND HISTTYPE = ? ORDER BY HISTORYID");
            ResultSet rs = null;
            Vector<Integer> v = new Vector<Integer>();
            try {
                Pattern pattern = Pattern.compile(filter, 10);
                Matcher matcher = null;
                psReadSearch.setLong(1, sessionId);
                psReadSearch.setInt(2, histType);
                rs = psReadSearch.executeQuery();
                while (rs.next()) {
                    if (isRequest) {
                        matcher = pattern.matcher(rs.getString(REQHEADER));
                        if (matcher.find()) {
                            v.add(rs.getInt(HISTORYID));
                            continue;
                        }
                        matcher = pattern.matcher(rs.getString(REQBODY));
                        if (!matcher.find()) continue;
                        v.add(rs.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(rs.getString(RESHEADER));
                    if (matcher.find()) {
                        v.add(rs.getInt(HISTORYID));
                        continue;
                    }
                    matcher = pattern.matcher(rs.getString(RESBODY));
                    if (!matcher.find()) continue;
                    v.add(rs.getInt(HISTORYID));
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                psReadSearch.close();
            }
            return v;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void deleteHistorySession(long sessionId) throws DatabaseException {
        try (Statement stmt = this.getConnection().createStatement();){
            stmt.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + sessionId);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void deleteHistoryType(long sessionId, int historyType) throws DatabaseException {
        try (Statement stmt = this.getConnection().createStatement();){
            stmt.executeUpdate("DELETE FROM HISTORY WHERE SESSIONID = " + sessionId + " AND " + HISTTYPE + " = " + historyType);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void delete(int historyId) throws DatabaseException {
        try {
            this.psDelete.setInt(1, historyId);
            this.psDelete.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void delete(List<Integer> ids) throws DatabaseException {
        this.delete(ids, 1000);
    }

    @Override
    public synchronized void delete(List<Integer> ids, int batchSize) throws DatabaseException {
        try {
            if (ids == null) {
                throw new IllegalArgumentException("Parameter ids must not be null.");
            }
            if (batchSize <= 0) {
                throw new IllegalArgumentException("Parameter batchSize must be greater than zero.");
            }
            int count = 0;
            for (Integer id : ids) {
                this.psDelete.setInt(1, id);
                this.psDelete.addBatch();
                if (++count % batchSize != 0) continue;
                this.psDelete.executeBatch();
                count = 0;
            }
            if (count % batchSize != 0) {
                this.psDelete.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Deprecated
    public static void setHistoryTypeAsTemporary(int historyType) {
        HistoryReference.addTemporaryType(historyType);
    }

    @Deprecated
    public static void unsetHistoryTypeAsTemporary(int historyType) {
        HistoryReference.removeTemporaryType(historyType);
    }

    @Override
    public void deleteTemporary() throws DatabaseException {
        try {
            for (Integer type : HistoryReference.getTemporaryTypes()) {
                int result;
                do {
                    this.psDeleteTemp.setInt(1, type);
                } while ((result = this.psDeleteTemp.executeUpdate()) != 0);
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean containsURI(long sessionId, int historyType, String method, String uri, byte[] body) throws DatabaseException {
        try {
            this.psContainsURI.setString(1, uri);
            this.psContainsURI.setString(2, method);
            if (this.bodiesAsBytes) {
                this.psContainsURI.setBytes(3, body);
            } else {
                this.psContainsURI.setString(3, new String(body));
            }
            this.psContainsURI.setLong(4, sessionId);
            this.psContainsURI.setInt(5, historyType);
            try (ResultSet rs = this.psContainsURI.executeQuery();){
                if (!rs.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RecordHistory getHistoryCache(HistoryReference ref, HttpMessage reqMsg) throws DatabaseException, HttpMalformedHeaderException {
        try {
            PreparedStatement psReadCache = null;
            psReadCache = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND HISTORYID >= ? AND HISTORYID <= ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND HISTORYID >= ? AND HISTORYID <= ? AND SESSIONID = ?)");
            psReadCache.setString(1, reqMsg.getRequestHeader().getURI().toString());
            psReadCache.setString(2, reqMsg.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                psReadCache.setBytes(3, reqMsg.getRequestBody().getBytes());
            } else {
                psReadCache.setString(3, new String(reqMsg.getRequestBody().getBytes()));
            }
            psReadCache.setInt(4, ref.getHistoryId());
            psReadCache.setInt(5, ref.getHistoryId() + 200);
            psReadCache.setLong(6, ref.getSessionId());
            ResultSet rs = psReadCache.executeQuery();
            RecordHistory rec = null;
            try {
                do {
                    if ((rec = this.build(rs)) == null || !rec.getHttpMessage().equals(reqMsg) || rec.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory recordHistory = rec;
                    return recordHistory;
                } while (rec != null);
            }
            finally {
                try {
                    rs.close();
                    psReadCache.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            psReadCache = isExistStatusCode ? this.getConnection().prepareStatement("SELECT TOP 1 * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ? AND STATUSCODE != 304") : this.getConnection().prepareStatement("SELECT * FROM HISTORY WHERE URI = ? AND METHOD = ? AND REQBODY = ? AND SESSIONID = ?");
            psReadCache.setString(1, reqMsg.getRequestHeader().getURI().toString());
            psReadCache.setString(2, reqMsg.getRequestHeader().getMethod());
            if (this.bodiesAsBytes) {
                psReadCache.setBytes(3, reqMsg.getRequestBody().getBytes());
            } else {
                psReadCache.setString(3, new String(reqMsg.getRequestBody().getBytes()));
            }
            psReadCache.setLong(4, ref.getSessionId());
            rs = psReadCache.executeQuery();
            rec = null;
            try {
                do {
                    if ((rec = this.build(rs)) == null || !rec.getHttpMessage().equals(reqMsg) || rec.getHttpMessage().getResponseHeader().getStatusCode() == 304) continue;
                    RecordHistory e = rec;
                    return e;
                } while (rec != null);
                return null;
            }
            finally {
                try {
                    rs.close();
                    psReadCache.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void updateNote(int historyId, String note) throws DatabaseException {
        try {
            this.psUpdateNote.setString(1, note);
            this.psUpdateNote.setInt(2, historyId);
            this.psUpdateNote.execute();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public int lastIndex() {
        return this.lastInsertedIndex;
    }
}

