/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.message.connect.connack.mqtt3;

import com.hivemq.client.annotations.Immutable;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAck;
import com.hivemq.client.internal.mqtt.message.connect.connack.MqttConnAckRestrictions;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAck;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAck;
import com.hivemq.client.mqtt.mqtt5.message.connect.connack.Mqtt5ConnAckReasonCode;
import io.reactivex.functions.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Mqtt3ConnAckView
implements Mqtt3ConnAck {
    @NotNull
    public static final Function<Mqtt5ConnAck, Mqtt3ConnAck> MAPPER = Mqtt3ConnAckView::of;
    @NotNull
    private final MqttConnAck delegate;

    @NotNull
    public static MqttConnAck delegate(@NotNull Mqtt3ConnAckReturnCode returnCode, boolean sessionPresent) {
        return new MqttConnAck(Mqtt3ConnAckView.delegateReasonCode(returnCode), sessionPresent, -1L, -1, null, null, MqttConnAckRestrictions.DEFAULT, null, null, null, MqttUserPropertiesImpl.NO_USER_PROPERTIES);
    }

    @NotNull
    private static Mqtt5ConnAckReasonCode delegateReasonCode(@NotNull Mqtt3ConnAckReturnCode returnCode) {
        switch (returnCode) {
            case SUCCESS: {
                return Mqtt5ConnAckReasonCode.SUCCESS;
            }
            case UNSUPPORTED_PROTOCOL_VERSION: {
                return Mqtt5ConnAckReasonCode.UNSUPPORTED_PROTOCOL_VERSION;
            }
            case IDENTIFIER_REJECTED: {
                return Mqtt5ConnAckReasonCode.CLIENT_IDENTIFIER_NOT_VALID;
            }
            case SERVER_UNAVAILABLE: {
                return Mqtt5ConnAckReasonCode.SERVER_UNAVAILABLE;
            }
            case BAD_USER_NAME_OR_PASSWORD: {
                return Mqtt5ConnAckReasonCode.BAD_USER_NAME_OR_PASSWORD;
            }
            case NOT_AUTHORIZED: {
                return Mqtt5ConnAckReasonCode.NOT_AUTHORIZED;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    private static Mqtt3ConnAckReturnCode viewReasonCode(@NotNull Mqtt5ConnAckReasonCode reasonCode) {
        switch (reasonCode) {
            case SUCCESS: {
                return Mqtt3ConnAckReturnCode.SUCCESS;
            }
            case UNSUPPORTED_PROTOCOL_VERSION: {
                return Mqtt3ConnAckReturnCode.UNSUPPORTED_PROTOCOL_VERSION;
            }
            case CLIENT_IDENTIFIER_NOT_VALID: {
                return Mqtt3ConnAckReturnCode.IDENTIFIER_REJECTED;
            }
            case SERVER_UNAVAILABLE: {
                return Mqtt3ConnAckReturnCode.SERVER_UNAVAILABLE;
            }
            case BAD_USER_NAME_OR_PASSWORD: {
                return Mqtt3ConnAckReturnCode.BAD_USER_NAME_OR_PASSWORD;
            }
            case NOT_AUTHORIZED: {
                return Mqtt3ConnAckReturnCode.NOT_AUTHORIZED;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public static Mqtt3ConnAckView of(@NotNull Mqtt5ConnAck connAck) {
        return new Mqtt3ConnAckView((MqttConnAck)connAck);
    }

    @NotNull
    public static Mqtt3ConnAckView of(@NotNull MqttConnAck connAck) {
        return new Mqtt3ConnAckView(connAck);
    }

    private Mqtt3ConnAckView(@NotNull MqttConnAck delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public Mqtt3ConnAckReturnCode getReturnCode() {
        return Mqtt3ConnAckView.viewReasonCode((Mqtt5ConnAckReasonCode)this.delegate.getReasonCode());
    }

    @Override
    public boolean isSessionPresent() {
        return this.delegate.isSessionPresent();
    }

    @NotNull
    public MqttConnAck getDelegate() {
        return this.delegate;
    }

    @NotNull
    private String toAttributeString() {
        return "returnCode=" + this.getReturnCode() + ", sessionPresent=" + this.isSessionPresent();
    }

    @NotNull
    public String toString() {
        return "MqttConnAck{" + this.toAttributeString() + '}';
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mqtt3ConnAckView)) {
            return false;
        }
        Mqtt3ConnAckView that = (Mqtt3ConnAckView)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

