/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.flow.paginating;

import org.jfree.layouting.ChainingLayoutProcess;
import org.jfree.layouting.DefaultLayoutProcess;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.StateException;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.pageable.PageableOutputProcessor;
import org.jfree.layouting.util.IntList;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportDataFactoryException;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.flow.AbstractReportProcessor;
import org.jfree.report.flow.FlowController;
import org.jfree.report.flow.LibLayoutReportTarget;
import org.jfree.report.flow.ReportContext;
import org.jfree.report.flow.ReportJob;
import org.jfree.report.flow.ReportTarget;
import org.jfree.report.flow.ReportTargetState;
import org.jfree.report.flow.layoutprocessor.LayoutController;
import org.jfree.report.flow.layoutprocessor.LayoutControllerFactory;
import org.jfree.report.flow.paginating.PageState;
import org.jfree.report.flow.paginating.PageStateList;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class PaginatingReportProcessor
extends AbstractReportProcessor {
    private PageableOutputProcessor outputProcessor;
    private PageStateList stateList;
    private IntList physicalMapping;
    private IntList logicalMapping;
    private static final boolean ASSERTATION = true;

    protected PaginatingReportProcessor(PageableOutputProcessor pageableOutputProcessor) {
        this.outputProcessor = pageableOutputProcessor;
    }

    public PageableOutputProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected LibLayoutReportTarget createTarget(ReportJob reportJob) {
        if (this.outputProcessor == null) {
            throw new IllegalStateException("OutputProcessor is invalid.");
        }
        ChainingLayoutProcess chainingLayoutProcess = new ChainingLayoutProcess((LayoutProcess)new DefaultLayoutProcess((OutputProcessor)this.outputProcessor));
        ResourceManager resourceManager = reportJob.getReportStructureRoot().getResourceManager();
        ResourceKey resourceKey = reportJob.getReportStructureRoot().getBaseResource();
        return new LibLayoutReportTarget(reportJob, resourceKey, resourceManager, (LayoutProcess)chainingLayoutProcess);
    }

    protected void prepareReportProcessing(ReportJob reportJob) throws ReportDataFactoryException, DataSourceException, ReportProcessingException {
        if (reportJob == null) {
            throw new NullPointerException();
        }
        long l = System.currentTimeMillis();
        this.processReportRun(reportJob, this.createTarget(reportJob));
        if (!this.outputProcessor.isGlobalStateComputed()) {
            throw new ReportProcessingException("Pagination has not yet been finished.");
        }
        this.processPaginationRun(reportJob, this.createTarget(reportJob));
        if (!this.outputProcessor.isPaginationFinished()) {
            throw new ReportProcessingException("Pagination has not yet been finished.");
        }
        if (!this.outputProcessor.isContentGeneratable()) {
            throw new ReportProcessingException("Illegal State.");
        }
        long l2 = System.currentTimeMillis();
        System.out.println("Pagination-Time: " + (l2 - l));
    }

    protected PageStateList processPaginationRun(ReportJob reportJob, LibLayoutReportTarget libLayoutReportTarget) throws ReportDataFactoryException, DataSourceException, ReportProcessingException {
        if (reportJob == null) {
            throw new NullPointerException();
        }
        this.stateList = new PageStateList(this);
        this.physicalMapping = new IntList(40);
        this.logicalMapping = new IntList(20);
        ReportContext reportContext = this.createReportContext(reportJob, libLayoutReportTarget);
        LayoutControllerFactory layoutControllerFactory = reportContext.getLayoutControllerFactory();
        FlowController flowController = this.createFlowControler(reportContext, reportJob);
        LayoutController layoutController = layoutControllerFactory.create(flowController, reportJob.getReportStructureRoot(), null);
        try {
            int n;
            int n2;
            this.stateList.add(new PageState(libLayoutReportTarget.saveState(), layoutController, this.outputProcessor.getPageCursor()));
            int n3 = this.outputProcessor.getLogicalPageCount();
            int n4 = this.outputProcessor.getPhysicalPageCount();
            while (layoutController.isAdvanceable()) {
                layoutController = layoutController.advance(libLayoutReportTarget);
                libLayoutReportTarget.commit();
                while (!layoutController.isAdvanceable() && layoutController.getParent() != null) {
                    LayoutController layoutController2 = layoutController.getParent();
                    layoutController = layoutController2.join(layoutController.getFlowController());
                }
                if (!libLayoutReportTarget.isPagebreakEncountered()) continue;
                int n5 = this.outputProcessor.getLogicalPageCount();
                n2 = this.outputProcessor.getPhysicalPageCount();
                n = this.stateList.size() - 1;
                while (n4 < n2) {
                    this.physicalMapping.add(n);
                    ++n4;
                }
                while (n3 < n5) {
                    this.logicalMapping.add(n);
                    ++n3;
                }
                n3 = n5;
                n4 = n2;
                ReportTargetState reportTargetState = libLayoutReportTarget.saveState();
                PageState pageState = new PageState(reportTargetState, layoutController, this.outputProcessor.getPageCursor());
                this.stateList.add(pageState);
                ReportTarget reportTarget = reportTargetState.restore((OutputProcessor)this.outputProcessor);
                libLayoutReportTarget.resetPagebreakFlag();
            }
            int n6 = this.outputProcessor.getLogicalPageCount();
            n2 = this.outputProcessor.getPhysicalPageCount();
            n = this.stateList.size() - 1;
            while (n4 < n2) {
                this.physicalMapping.add(n);
                ++n4;
            }
            while (n3 < n6) {
                this.logicalMapping.add(n);
                ++n3;
            }
        }
        catch (StateException stateException) {
            throw new ReportProcessingException("Argh, Unable to save the state!");
        }
        DebugLog.log((Object)("After pagination we have " + this.stateList.size() + " states"));
        return this.stateList;
    }

    public boolean isPaginated() {
        return this.outputProcessor.isPaginationFinished();
    }

    protected PageState getLogicalPageState(int n) {
        return this.stateList.get(this.logicalMapping.get(n));
    }

    protected PageState getPhysicalPageState(int n) {
        return this.stateList.get(this.physicalMapping.get(n));
    }

    public PageState processPage(PageState pageState) throws StateException, ReportProcessingException, ReportDataFactoryException, DataSourceException {
        ReportTargetState reportTargetState = pageState.getTargetState();
        LibLayoutReportTarget libLayoutReportTarget = (LibLayoutReportTarget)reportTargetState.restore((OutputProcessor)this.outputProcessor);
        this.outputProcessor.setPageCursor(pageState.getPageCursor());
        LayoutController layoutController = pageState.getLayoutController();
        while (layoutController.isAdvanceable()) {
            Object object;
            layoutController = layoutController.advance(libLayoutReportTarget);
            libLayoutReportTarget.commit();
            while (!layoutController.isAdvanceable() && layoutController.getParent() != null) {
                object = layoutController.getParent();
                layoutController = object.join(layoutController.getFlowController());
            }
            if (!libLayoutReportTarget.isPagebreakEncountered()) continue;
            object = new PageState(libLayoutReportTarget.saveState(), layoutController, this.outputProcessor.getPageCursor());
            libLayoutReportTarget.resetPagebreakFlag();
            return object;
        }
        return null;
    }
}

