/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Operand;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class LimitTest
extends FreeColTestCase {
    public void testOperand() {
        UnitType carpenter = LimitTest.spec().getUnitType("model.unit.masterCarpenter");
        UnitType frigate = LimitTest.spec().getUnitType("model.unit.frigate");
        Operand operand = new Operand();
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.NONE), (Object)((Object)operand.getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.ScopeLevel.NONE), (Object)((Object)operand.getScopeLevel()));
        operand.setType("model.unit.frigate");
        LimitTest.assertTrue((boolean)operand.appliesTo(frigate));
        LimitTest.assertFalse((boolean)operand.appliesTo(carpenter));
    }

    public void testWagonTrainLimit() {
        Game game = LimitTest.getStandardGame();
        Map map = LimitTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Colony colony = this.getStandardColony(3);
        ServerBuilding armory = new ServerBuilding(LimitTest.getGame(), colony, LimitTest.spec().getBuildingType("model.building.armory"));
        colony.addBuilding(armory);
        UnitType wagonTrain = LimitTest.spec().getUnitType("model.unit.wagonTrain");
        UnitType artillery = LimitTest.spec().getUnitType("model.unit.artillery");
        Limit wagonTrainLimit = wagonTrain.getLimits().get(0);
        LimitTest.assertTrue((boolean)colony.canBuild(artillery));
        LimitTest.assertFalse((boolean)wagonTrainLimit.getLeftHandSide().appliesTo(artillery));
        LimitTest.assertTrue((boolean)wagonTrainLimit.evaluate(colony));
        LimitTest.assertTrue((boolean)colony.canBuild(wagonTrain));
        ServerUnit wagon = new ServerUnit(game, colony.getTile(), dutch, wagonTrain);
        LimitTest.assertNotNull((Object)wagon);
        LimitTest.assertEquals((Object)((Object)Colony.NoBuildReason.LIMIT_EXCEEDED), (Object)((Object)colony.getNoBuildReason(wagonTrain, null)));
        LimitTest.assertFalse((boolean)wagonTrainLimit.evaluate(colony));
        LimitTest.assertFalse((boolean)colony.canBuild(wagonTrain));
        LimitTest.assertTrue((boolean)colony.canBuild(artillery));
    }

    public void testIndependenceLimits() {
        Game game = LimitTest.getStandardGame();
        Map map = LimitTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Colony colony = this.getStandardColony(3);
        Event event = LimitTest.spec().getEvent("model.event.declareIndependence");
        LimitTest.assertNotNull((Object)event);
        LimitTest.assertNotNull(event.getLimits());
        LimitTest.assertTrue((boolean)LimitTest.spec().hasOption("model.option.lastColonialYear", IntegerOption.class));
        Limit rebelLimit = event.getLimit("model.limit.independence.rebels");
        Limit colonyLimit = event.getLimit("model.limit.independence.coastalColonies");
        Limit yearLimit = event.getLimit("model.limit.independence.year");
        LimitTest.assertNotNull((Object)rebelLimit);
        LimitTest.assertEquals((Object)((Object)Limit.Operator.GE), (Object)((Object)rebelLimit.getOperator()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.NONE), (Object)((Object)rebelLimit.getLeftHandSide().getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.ScopeLevel.PLAYER), (Object)((Object)rebelLimit.getLeftHandSide().getScopeLevel()));
        LimitTest.assertEquals((Object)0, (Object)rebelLimit.getLeftHandSide().getValue(dutch));
        LimitTest.assertEquals((Object)50, (Object)rebelLimit.getRightHandSide().getValue(dutch));
        LimitTest.assertFalse((boolean)rebelLimit.evaluate(dutch));
        LimitTest.assertNotNull((Object)colonyLimit);
        LimitTest.assertEquals((Object)((Object)Limit.Operator.GE), (Object)((Object)colonyLimit.getOperator()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.SETTLEMENTS), (Object)((Object)colonyLimit.getLeftHandSide().getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.ScopeLevel.PLAYER), (Object)((Object)colonyLimit.getLeftHandSide().getScopeLevel()));
        LimitTest.assertEquals((String)"isConnectedPort", (String)colonyLimit.getLeftHandSide().getMethodName());
        LimitTest.assertFalse((boolean)colony.isConnectedPort());
        LimitTest.assertEquals((Object)0, (Object)colonyLimit.getLeftHandSide().getValue(dutch));
        LimitTest.assertEquals((Object)1, (Object)colonyLimit.getRightHandSide().getValue(dutch));
        LimitTest.assertFalse((boolean)colonyLimit.evaluate(dutch));
        LimitTest.assertNotNull((Object)yearLimit);
        LimitTest.assertEquals((Object)((Object)Limit.Operator.LE), (Object)((Object)yearLimit.getOperator()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.YEAR), (Object)((Object)yearLimit.getLeftHandSide().getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.OPTION), (Object)((Object)yearLimit.getRightHandSide().getOperandType()));
        LimitTest.assertEquals((String)"model.option.lastColonialYear", (String)yearLimit.getRightHandSide().getType());
        LimitTest.assertEquals((Object)1492, (Object)yearLimit.getLeftHandSide().getValue(dutch));
        LimitTest.assertEquals((Object)1800, (Object)yearLimit.getRightHandSide().getValue(dutch));
        LimitTest.assertTrue((boolean)yearLimit.evaluate(dutch));
        colony.modifyLiberty(10000);
        colony.updateSoL();
        LimitTest.assertTrue((boolean)rebelLimit.evaluate(dutch));
        Tile tile = colony.getTile().getNeighbourOrNull(Direction.N);
        tile.setType(LimitTest.spec().getTileType("model.tile.ocean"));
        tile.setHighSeasCount(5);
        tile.setExplored(dutch, true);
        LimitTest.assertTrue((boolean)tile.isExploredBy(dutch));
        LimitTest.assertTrue((boolean)tile.isHighSeasConnected());
        LimitTest.assertTrue((!tile.isLand() ? 1 : 0) != 0);
        LimitTest.assertTrue((boolean)colony.isConnectedPort());
        LimitTest.assertTrue((boolean)colonyLimit.getLeftHandSide().appliesTo(colony));
        LimitTest.assertTrue((boolean)colonyLimit.evaluate(dutch));
        LimitTest.spec().setIntegerMinimum("model.option.lastColonialYear", 1300);
        LimitTest.spec().setInteger("model.option.lastColonialYear", 1300);
        LimitTest.assertFalse((boolean)yearLimit.evaluate(dutch));
    }

    public void testSuccessionLimits() {
        Game game = LimitTest.getStandardGame();
        Map map = LimitTest.getTestMap();
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Colony colony = this.getStandardColony(3);
        Event event = LimitTest.spec().getEvent("model.event.spanishSuccession");
        LimitTest.assertNotNull((Object)event);
        LimitTest.assertNotNull(event.getLimits());
        Limit weakestPlayerLimit = event.getLimit("model.limit.spanishSuccession.weakestPlayer");
        Limit strongestPlayerLimit = event.getLimit("model.limit.spanishSuccession.strongestPlayer");
        Limit yearLimit = event.getLimit("model.limit.spanishSuccession.year");
        LimitTest.assertNotNull((Object)strongestPlayerLimit);
        LimitTest.assertEquals((Object)((Object)Limit.Operator.GT), (Object)((Object)strongestPlayerLimit.getOperator()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.NONE), (Object)((Object)strongestPlayerLimit.getLeftHandSide().getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.ScopeLevel.PLAYER), (Object)((Object)strongestPlayerLimit.getLeftHandSide().getScopeLevel()));
        LimitTest.assertEquals((Object)0, (Object)strongestPlayerLimit.getLeftHandSide().getValue(dutch));
        LimitTest.assertEquals((Object)50, (Object)strongestPlayerLimit.getRightHandSide().getValue(dutch));
        LimitTest.assertFalse((boolean)strongestPlayerLimit.evaluate(dutch));
        LimitTest.assertNotNull((Object)weakestPlayerLimit);
        LimitTest.assertEquals((Object)((Object)Limit.Operator.LT), (Object)((Object)weakestPlayerLimit.getOperator()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.NONE), (Object)((Object)weakestPlayerLimit.getLeftHandSide().getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.ScopeLevel.PLAYER), (Object)((Object)weakestPlayerLimit.getLeftHandSide().getScopeLevel()));
        LimitTest.assertEquals((Object)0, (Object)weakestPlayerLimit.getLeftHandSide().getValue(dutch));
        LimitTest.assertEquals((Object)50, (Object)weakestPlayerLimit.getRightHandSide().getValue(dutch));
        LimitTest.assertTrue((boolean)weakestPlayerLimit.evaluate(dutch));
        LimitTest.assertNotNull((Object)yearLimit);
        LimitTest.assertEquals((Object)((Object)Limit.Operator.GE), (Object)((Object)yearLimit.getOperator()));
        LimitTest.assertEquals((Object)((Object)Operand.OperandType.YEAR), (Object)((Object)yearLimit.getLeftHandSide().getOperandType()));
        LimitTest.assertEquals((Object)((Object)Operand.ScopeLevel.GAME), (Object)((Object)yearLimit.getLeftHandSide().getScopeLevel()));
        LimitTest.assertEquals((Object)1492, (Object)yearLimit.getLeftHandSide().getValue(game));
        LimitTest.assertEquals((Object)1600, (Object)yearLimit.getRightHandSide().getValue());
        LimitTest.assertFalse((boolean)yearLimit.evaluate(game));
        colony.modifyLiberty(10000);
        colony.updateSoL();
        LimitTest.assertTrue((boolean)strongestPlayerLimit.evaluate(dutch));
        LimitTest.assertFalse((boolean)weakestPlayerLimit.evaluate(dutch));
    }
}

