/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.memory;

import org.graalvm.visualvm.lib.jfluid.results.DataManager;

public class ClassHistoryDataManager
extends DataManager {
    private int trackedClassID;
    private String trackedClassName;
    public long[] timeStamps;
    public int[] nTotalAllocObjects;
    public long[] totalAllocObjectsSize;
    public int[] nTrackedLiveObjects;
    public long[] trackedLiveObjectsSize;
    private int arrayBufferSize;
    private int currentArraysSize;
    private int itemCount;

    public ClassHistoryDataManager() {
        this(50);
    }

    public ClassHistoryDataManager(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
        this.reset();
    }

    public synchronized void setArrayBufferSize(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
    }

    public synchronized int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized int getTrackedClassID() {
        return this.trackedClassID;
    }

    public synchronized String getTrackedClassName() {
        return this.trackedClassName;
    }

    public synchronized boolean isTrackingClass() {
        return this.trackedClassName != null;
    }

    public synchronized void setupClass(int trackedClassID, String trackedClassName) {
        this.reset();
        this.trackedClassID = trackedClassID;
        this.trackedClassName = trackedClassName;
    }

    public synchronized void resetClass() {
        this.reset();
    }

    public synchronized void processData(int[] nTotalAllocObjects, long[] totalAllocObjectsSize) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = System.currentTimeMillis();
        this.nTotalAllocObjects[this.itemCount] = nTotalAllocObjects[this.trackedClassID];
        this.totalAllocObjectsSize[this.itemCount] = totalAllocObjectsSize[this.trackedClassID];
        ++this.itemCount;
        this.fireDataChanged();
    }

    public synchronized void processData(int[] nTotalAllocObjects, int[] nTrackedLiveObjects, long[] trackedLiveObjectsSize) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = System.currentTimeMillis();
        this.nTotalAllocObjects[this.itemCount] = nTotalAllocObjects[this.trackedClassID];
        this.nTrackedLiveObjects[this.itemCount] = nTrackedLiveObjects[this.trackedClassID];
        this.trackedLiveObjectsSize[this.itemCount] = trackedLiveObjectsSize[this.trackedClassID];
        ++this.itemCount;
        this.fireDataChanged();
    }

    private void reset() {
        this.itemCount = 0;
        this.trackedClassID = -1;
        this.trackedClassName = null;
        this.timeStamps = new long[this.arrayBufferSize];
        this.nTotalAllocObjects = new int[this.arrayBufferSize];
        this.totalAllocObjectsSize = new long[this.arrayBufferSize];
        this.nTrackedLiveObjects = new int[this.arrayBufferSize];
        this.trackedLiveObjectsSize = new long[this.arrayBufferSize];
        this.currentArraysSize = this.arrayBufferSize;
        this.fireDataReset();
    }

    private void checkArraysSize() {
        if (this.currentArraysSize == this.itemCount) {
            this.timeStamps = ClassHistoryDataManager.extendArray(this.timeStamps, this.arrayBufferSize);
            this.nTotalAllocObjects = ClassHistoryDataManager.extendArray(this.nTotalAllocObjects, this.arrayBufferSize);
            this.totalAllocObjectsSize = ClassHistoryDataManager.extendArray(this.totalAllocObjectsSize, this.arrayBufferSize);
            this.nTrackedLiveObjects = ClassHistoryDataManager.extendArray(this.nTrackedLiveObjects, this.arrayBufferSize);
            this.trackedLiveObjectsSize = ClassHistoryDataManager.extendArray(this.trackedLiveObjectsSize, this.arrayBufferSize);
            this.currentArraysSize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] array, int extraLength) {
        int originalLength = array.length;
        long[] newArray = new long[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }

    private static int[] extendArray(int[] array, int extraLength) {
        int originalLength = array.length;
        int[] newArray = new int[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }
}

