/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.openide.loaders.RuntimeCatalog;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

class XMLDataObjectImpl {
    XMLDataObjectImpl() {
    }

    static DocumentBuilder makeBuilder(boolean bl) throws IOException, SAXException {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(bl);
            documentBuilderFactory.setNamespaceAware(false);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            XMLDataObjectImpl.notifyFactoryErr(factoryConfigurationError, "javax.xml.parsers.DocumentBuilderFactory");
            throw factoryConfigurationError;
        }
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            SAXException sAXException = new SAXException("Configuration exception.");
            sAXException.initCause(parserConfigurationException);
            Exceptions.attachLocalizedMessage((Throwable)sAXException, (String)"Can not create a DOM builder!\nCheck javax.xml.parsers.DocumentBuilderFactory property and the builder library presence on classpath.");
            throw sAXException;
        }
        return documentBuilder;
    }

    @Deprecated
    static Parser makeParser(boolean bl) {
        try {
            return new XMLReaderAdapter(XMLUtil.createXMLReader((boolean)bl));
        }
        catch (SAXException sAXException) {
            XMLDataObjectImpl.notifyNewSAXParserEx(sAXException);
            return null;
        }
    }

    static XMLReader makeXMLReader(boolean bl, boolean bl2) {
        try {
            return XMLUtil.createXMLReader((boolean)bl, (boolean)bl2);
        }
        catch (SAXException sAXException) {
            XMLDataObjectImpl.notifyNewSAXParserEx(sAXException);
            return null;
        }
    }

    private static void notifyNewSAXParserEx(Exception exception) {
        Exceptions.attachLocalizedMessage((Throwable)exception, (String)"Can not create a SAX parser!\nCheck javax.xml.parsers.SAXParserFactory property features and the parser library presence on classpath.");
        Exceptions.printStackTrace((Throwable)exception);
    }

    private static void notifyFactoryErr(Error error, String string) {
        Exceptions.attachLocalizedMessage((Throwable)error, (String)("Can not create a factory!\nCheck " + string + "  property and the factory library presence on classpath."));
        Exceptions.printStackTrace((Throwable)error);
    }

    static synchronized void registerCatalogEntry(String string, String string2) {
        for (Object e : Lookup.getDefault().lookupAll(EntityCatalog.class)) {
            if (!(e instanceof RuntimeCatalog)) continue;
            ((RuntimeCatalog)((Object)e)).registerCatalogEntry(string, string2);
            return;
        }
        assert (false);
    }
}

