/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.diagnostics;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.platform.diagnostics.IMetricConsumer;
import com.jetbrains.rd.platform.diagnostics.MetricUnit;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.platform.util.estimators.P2QuantileEstimator;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\tH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/QuantileEstimatorConsumer;", "Lcom/jetbrains/rd/platform/diagnostics/IMetricConsumer;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "metricUnit", "Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "watchdogName", "", "quantile", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/diagnostic/Logger;Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;Ljava/lang/String;D)V", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getMetricUnit", "()Lcom/jetbrains/rd/platform/diagnostics/MetricUnit;", "getWatchdogName", "()Ljava/lang/String;", "getQuantile", "()D", "myEstimator", "Lcom/jetbrains/rd/platform/util/estimators/P2QuantileEstimator;", "consumeValue", "", "value", "comment", "Companion", "intellij.rd.platform"})
final class QuantileEstimatorConsumer
implements IMetricConsumer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Logger logger;
    @NotNull
    private final MetricUnit metricUnit;
    @NotNull
    private final String watchdogName;
    private final double quantile;
    @NotNull
    private final P2QuantileEstimator myEstimator;
    @NotNull
    private static final DecimalFormat format;

    public QuantileEstimatorConsumer(@NotNull Lifetime lifetime, @NotNull Logger logger, @NotNull MetricUnit metricUnit, @NotNull String watchdogName, double quantile) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)metricUnit), (String)"metricUnit");
        Intrinsics.checkNotNullParameter((Object)watchdogName, (String)"watchdogName");
        this.logger = logger;
        this.metricUnit = metricUnit;
        this.watchdogName = watchdogName;
        this.quantile = quantile;
        if (this.quantile < 0.0 || this.quantile > 1.0) {
            throw new IllegalArgumentException("quantile: " + this.quantile + " must be greater than or equal to 0 or less than or equal to 1");
        }
        this.myEstimator = new P2QuantileEstimator(this.quantile);
        lifetime.onTermination(() -> QuantileEstimatorConsumer._init_$lambda$0(this));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final MetricUnit getMetricUnit() {
        return this.metricUnit;
    }

    @NotNull
    public final String getWatchdogName() {
        return this.watchdogName;
    }

    public final double getQuantile() {
        return this.quantile;
    }

    @Override
    public void consumeValue(double value, @Nullable String comment) {
        this.myEstimator.addValue(value);
    }

    private static final Unit _init_$lambda$0(QuantileEstimatorConsumer this$0) {
        if (this$0.myEstimator.isEmpty()) {
            return Unit.INSTANCE;
        }
        double value = this$0.myEstimator.getQuantile();
        String pString = format.format(this$0.quantile * (double)100);
        StructuredLoggingKt.logMeasurement$default(this$0.logger, this$0.watchdogName + ".P" + pString, (long)value, this$0.metricUnit, null, 8, null);
        return Unit.INSTANCE;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols;
        Companion = new Companion(null);
        DecimalFormatSymbols $this$format_u24lambda_u241 = decimalFormatSymbols = new DecimalFormatSymbols();
        String string = "0.#";
        boolean bl = false;
        $this$format_u24lambda_u241.setDecimalSeparator('_');
        DecimalFormatSymbols decimalFormatSymbols2 = decimalFormatSymbols;
        String string2 = string;
        format = new DecimalFormat(string2, decimalFormatSymbols2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/platform/diagnostics/QuantileEstimatorConsumer$Companion;", "", "<init>", "()V", "format", "Ljava/text/DecimalFormat;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

