/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.arrays;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.ma.arrays.AbstractArrayItem;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ImmutableArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.z.IntSet;

public class SimpleArrayItem
extends AbstractArrayItem {
    public static final SimpleArrayItem EMPTY_ARRAY = new SimpleArrayItem(new ArrayList<GroundedValue>());
    private final List<GroundedValue> _members;
    private boolean knownToBeGrounded = false;

    public SimpleArrayItem(List<GroundedValue> members) {
        this._members = members;
    }

    public static SimpleArrayItem makeSimpleArrayItem(SequenceIterator input) throws XPathException {
        ArrayList<GroundedValue> members = new ArrayList<GroundedValue>();
        SequenceTool.supply(input, item -> {
            if (item.getClass().getName().equals("com.saxonica.functions.extfn.ArrayMemberValue")) {
                members.add((GroundedValue)((ObjectValue)item).getObject());
            } else {
                members.add(item);
            }
        });
        SimpleArrayItem result = new SimpleArrayItem(members);
        result.knownToBeGrounded = true;
        return result;
    }

    @Override
    public OperandRole[] getOperandRoles() {
        return new OperandRole[]{OperandRole.SINGLE_ATOMIC};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeGrounded() throws XPathException {
        if (!this.knownToBeGrounded) {
            SimpleArrayItem simpleArrayItem = this;
            synchronized (simpleArrayItem) {
                for (int i = 0; i < this._members.size(); ++i) {
                    this._members.set(i, ((Sequence)this._members.get(i)).materialize());
                }
                this.knownToBeGrounded = true;
            }
        }
    }

    @Override
    public AnnotationList getAnnotations() {
        return AnnotationList.EMPTY;
    }

    @Override
    public GroundedValue get(int index) {
        return this._members.get(index);
    }

    @Override
    public ArrayItem put(int index, GroundedValue newValue) {
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.put(index, newValue);
    }

    @Override
    public int arrayLength() {
        return this._members.size();
    }

    @Override
    public boolean isEmpty() {
        return this._members.isEmpty();
    }

    @Override
    public Iterable<GroundedValue> members() {
        return this._members;
    }

    @Override
    public ArrayItem removeSeveral(IntSet positions) {
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.removeSeveral(positions);
    }

    @Override
    public ArrayItem remove(int pos) {
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.remove(pos);
    }

    @Override
    public ArrayItem subArray(int start, int end) {
        return new SimpleArrayItem(this._members.subList(start, end));
    }

    @Override
    public ArrayItem insert(int position, GroundedValue member) {
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.insert(position, member);
    }

    @Override
    public ArrayItem concat(ArrayItem other) {
        ImmutableArrayItem a2 = new ImmutableArrayItem(this);
        return a2.concat(other);
    }

    public List<GroundedValue> getMembers() {
        return this._members;
    }

    @Override
    public String toShortString() {
        int size = this.getLength();
        if (size == 0) {
            return "[]";
        }
        if (size > 5) {
            return "[(:size " + size + ":)]";
        }
        StringBuilder buff = new StringBuilder(256);
        buff.append("[");
        for (GroundedValue entry : this.members()) {
            buff.append(Err.depictSequence(entry).toString().trim());
            buff.append(", ");
        }
        if (size == 1) {
            buff.append("]");
        } else {
            buff.setCharAt(buff.length() - 2, ']');
        }
        return buff.toString().trim();
    }
}

