/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.sql;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sql.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySQL
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String sql;
    private DatabaseMeta connection;
    private boolean useVariableSubstitution = false;
    private boolean sqlfromfile = false;
    private String sqlfilename;

    public JobEntrySQL(String n) {
        super(n, "");
        this.sql = null;
        this.connection = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.SQL);
    }

    public JobEntrySQL() {
        this("");
    }

    public JobEntrySQL(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntrySQL je = (JobEntrySQL)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useVariableSubstitution", (String)(this.useVariableSubstitution ? "T" : "F")));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sqlfromfile", (String)(this.sqlfromfile ? "T" : "F")));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sqlfilename", (String)this.sqlfilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.sql = XMLHandler.getTagValue((Node)entrynode, (String)"sql");
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            String sSubs = XMLHandler.getTagValue((Node)entrynode, (String)"useVariableSubstitution");
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            String ssql = XMLHandler.getTagValue((Node)entrynode, (String)"sqlfromfile");
            if (ssql != null && ssql.equalsIgnoreCase("T")) {
                this.sqlfromfile = true;
            }
            this.sqlfilename = XMLHandler.getTagValue((Node)entrynode, (String)"sqlfilename");
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'sql' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            String ssql;
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.sql = rep.getJobEntryAttributeString(id_jobentry, "sql");
            String sSubs = rep.getJobEntryAttributeString(id_jobentry, "useVariableSubstitution");
            if (sSubs != null && sSubs.equalsIgnoreCase("T")) {
                this.useVariableSubstitution = true;
            }
            if ((ssql = rep.getJobEntryAttributeString(id_jobentry, "sqlfromfile")) != null && ssql.equalsIgnoreCase("T")) {
                this.sqlfromfile = true;
            }
            this.sqlfilename = rep.getJobEntryAttributeString(id_jobentry, "sqlfilename");
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'sql' from the repository with id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "sql", this.sql);
            rep.saveJobEntryAttribute(id_job, this.getID(), "useVariableSubstitution", this.useVariableSubstitution ? "T" : "F");
            rep.saveJobEntryAttribute(id_job, this.getID(), "sqlfromfile", this.sqlfromfile ? "T" : "F");
            rep.saveJobEntryAttribute(id_job, this.getID(), "sqlfilename", this.sqlfilename);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'sql' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public String getSQLFilename() {
        return this.sqlfilename;
    }

    public void setSQLFilename(String sqlfilename) {
        this.sqlfilename = sqlfilename;
    }

    public boolean getUseVariableSubstitution() {
        return this.useVariableSubstitution;
    }

    public void setUseVariableSubstitution(boolean subs) {
        this.useVariableSubstitution = subs;
    }

    public void setSQLFromFile(boolean sqlfromfilein) {
        this.sqlfromfile = sqlfromfilein;
    }

    public boolean getSQLFromFile() {
        return this.sqlfromfile;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block24: {
            LogWriter log;
            block25: {
                log = LogWriter.getInstance();
                result = previousResult;
                if (this.connection == null) break block25;
                Database db = new Database(this.connection);
                FileObject SQLfile = null;
                db.shareVariablesWith((VariableSpace)this);
                try {
                    block23: {
                        db.connect();
                        if (this.sqlfromfile) {
                            if (this.sqlfilename == null) {
                                throw new KettleDatabaseException(Messages.getString("JobSQL.NoSQLFileSpecified"));
                            }
                            try {
                                String realfilename = this.environmentSubstitute(this.sqlfilename);
                                SQLfile = KettleVFS.getFileObject((String)realfilename);
                                if (!SQLfile.exists()) {
                                    log.logError(this.toString(), Messages.getString("JobSQL.SQLFileNotExist", realfilename), new Object[0]);
                                    throw new KettleDatabaseException(Messages.getString("JobSQL.SQLFileNotExist", realfilename));
                                }
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobSQL.SQLFileExists", realfilename), new Object[0]);
                                }
                                InputStream IS = KettleVFS.getInputStream((FileObject)SQLfile);
                                InputStreamReader BIS = new InputStreamReader(new BufferedInputStream(IS, 500));
                                StringBuffer lineStringBuffer = new StringBuffer(256);
                                lineStringBuffer.setLength(0);
                                BufferedReader buff = new BufferedReader(BIS);
                                String sLine = null;
                                String SFullLine = Const.CR;
                                while ((sLine = buff.readLine()) != null) {
                                    if (Const.isEmpty((String)sLine)) {
                                        SFullLine = SFullLine + Const.CR;
                                        continue;
                                    }
                                    SFullLine = SFullLine + Const.CR + sLine;
                                }
                                if (!Const.isEmpty((String)SFullLine)) {
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobSQL.Log.SQlStatement", SFullLine), new Object[0]);
                                    }
                                    db.execStatements(SFullLine);
                                }
                                break block23;
                            }
                            catch (Exception e) {
                                throw new KettleDatabaseException(Messages.getString("JobSQL.ErrorRunningSQLfromFile"), (Throwable)e);
                            }
                        }
                        String mySQL = null;
                        mySQL = this.useVariableSubstitution ? this.environmentSubstitute(this.sql) : this.sql;
                        db.execStatements(mySQL);
                    }
                    Object var17_19 = null;
                }
                catch (Throwable throwable) {
                    Object var17_21 = null;
                    db.disconnect();
                    if (SQLfile != null) {
                        try {
                            SQLfile.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                db.disconnect();
                if (SQLfile != null) {
                    try {
                        SQLfile.close();
                    }
                    catch (Exception e) {}
                }
                break block24;
                {
                    catch (KettleDatabaseException je) {
                        result.setNrErrors(1L);
                        log.logError(this.toString(), Messages.getString("JobSQL.ErrorRunJobEntry", je.getMessage()), new Object[0]);
                        Object var17_20 = null;
                        db.disconnect();
                        if (SQLfile != null) {
                            try {
                                SQLfile.close();
                            }
                            catch (Exception e) {}
                        }
                        break block24;
                    }
                }
            }
            result.setNrErrors(1L);
            log.logError(this.toString(), Messages.getString("JobSQL.NoDatabaseConnection"), new Object[0]);
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "SQL", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

