/* riemann/attribute.h -- Riemann C client library
 * SPDX-FileCopyrightText: 2013-2024 Gergely Nagy
 * SPDX-FileContributor: Gergely Nagy
 *
 * SPDX-License-Identifier: EUPL-1.2
 */

#pragma once

#include <riemann/proto/riemann.pb-c.h>

typedef Attribute riemann_attribute_t;

#ifdef __cplusplus
extern "C" {
#endif

riemann_attribute_t *riemann_attribute_new (void);
riemann_attribute_t *riemann_attribute_clone (const riemann_attribute_t *attrib);
riemann_attribute_t *riemann_attribute_create (const char *key,
                                               const char *value);
void riemann_attribute_free (riemann_attribute_t *attrib);

int riemann_attribute_set_key (riemann_attribute_t *attrib, const char *key);
int riemann_attribute_set_value (riemann_attribute_t *attrib, const char *value);
int riemann_attribute_set (riemann_attribute_t *attrib,
                           const char *key, const char *value);

#ifdef __cplusplus
}
#endif
