/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.singlebyte.ByteAddModification;
import java.util.Objects;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"subtrahend", "modificationFilter", "postModification"})
public class ByteSubtractModification
extends VariableModification<Byte> {
    private static final int MAX_SUBTRACT_MODIFIER = 16;
    private Byte subtrahend;

    public ByteSubtractModification() {
    }

    public ByteSubtractModification(Byte bi) {
        this.subtrahend = bi;
    }

    @Override
    protected Byte modifyImplementationHook(Byte input) {
        if (input == null) {
            input = 0;
        }
        return (byte)(input - this.subtrahend);
    }

    public Byte getSubtrahend() {
        return this.subtrahend;
    }

    public void setSubtrahend(Byte subtrahend) {
        this.subtrahend = subtrahend;
    }

    @Override
    public VariableModification<Byte> getModifiedCopy() {
        return new ByteAddModification((byte)(this.subtrahend + new Random().nextInt(16)));
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.subtrahend);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteSubtractModification other = (ByteSubtractModification)obj;
        return Objects.equals(this.subtrahend, other.subtrahend);
    }
}

