/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.SSL2HandshakeMessageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ClientHelloParser
extends SSL2HandshakeMessageParser<SSL2ClientHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SSL2ClientHelloParser(int pointer, byte[] message, ProtocolVersion version, Config config) {
        super(pointer, message, version, config);
    }

    @Override
    protected SSL2ClientHelloMessage parseMessageContent() {
        LOGGER.debug("Parsing SSL2ClientHello");
        SSL2ClientHelloMessage msg = new SSL2ClientHelloMessage();
        this.parseMessageLength(msg);
        this.parseType(msg);
        this.parseProtocolVersion(msg);
        this.parseCipherSuiteLength(msg);
        this.parseSessionIDLength(msg);
        this.parseChallengeLength(msg);
        this.parseCipherSuites(msg);
        this.parseSessionID(msg);
        this.parseChallenge(msg);
        return msg;
    }

    private void parseProtocolVersion(SSL2ClientHelloMessage msg) {
        msg.setProtocolVersion(this.parseByteArrayField(2));
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getProtocolVersion().getValue())));
    }

    private void parseCipherSuiteLength(SSL2ClientHelloMessage msg) {
        msg.setCipherSuiteLength(this.parseIntField(2));
        LOGGER.debug("CipherSuiteLength: " + msg.getCipherSuiteLength().getValue());
    }

    private void parseSessionIDLength(SSL2ClientHelloMessage msg) {
        msg.setSessionIDLength(this.parseIntField(2));
        LOGGER.debug("SessionIDLength: " + msg.getSessionIdLength().getValue());
    }

    private void parseChallengeLength(SSL2ClientHelloMessage msg) {
        msg.setChallengeLength(this.parseIntField(2));
        LOGGER.debug("ChallengeLength: " + msg.getChallengeLength().getValue());
    }

    private void parseCipherSuites(SSL2ClientHelloMessage msg) {
        msg.setCipherSuites(this.parseByteArrayField((Integer)msg.getCipherSuiteLength().getValue()));
        LOGGER.debug("ChipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getCipherSuites().getValue())));
    }

    private void parseSessionID(SSL2ClientHelloMessage msg) {
        msg.setSessionID(this.parseByteArrayField((Integer)msg.getSessionIdLength().getValue()));
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getSessionId().getValue())));
    }

    private void parseChallenge(SSL2ClientHelloMessage msg) {
        msg.setChallenge(this.parseByteArrayField((Integer)msg.getChallengeLength().getValue()));
        LOGGER.debug("Challenge: " + ArrayConverter.bytesToHexString((byte[])((byte[])msg.getChallenge().getValue())));
    }
}

