/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import java.util.HashMap;
import java.util.Map;

public enum ClientAuthenticationType {
    ANONYMOUS(0),
    CERTIFICATE_BASED(1),
    PSK(2);

    private byte value;
    private static final Map<Byte, ClientAuthenticationType> MAP;

    private ClientAuthenticationType(byte value) {
        this.value = value;
    }

    public static ClientAuthenticationType getClientAuthenticationType(byte value) {
        return MAP.get(value);
    }

    public byte getValue() {
        return this.value;
    }

    public byte[] getArrayValue() {
        return new byte[]{this.value};
    }

    static {
        MAP = new HashMap<Byte, ClientAuthenticationType>();
        for (ClientAuthenticationType c : ClientAuthenticationType.values()) {
            MAP.put(c.value, c);
        }
    }
}

