<?php
/**
 * RestoreService
 * PHP version 5
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * InfluxDB OSS API Service
 *
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.
 *
 * OpenAPI spec version: 2.0.0
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 3.3.4
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace InfluxDB2\Service;

use InfluxDB2\DefaultApi;
use InfluxDB2\HeaderSelector;
use InfluxDB2\ObjectSerializer;

/**
 * RestoreService Class Doc Comment
 *
 * @category Class
 * @package  InfluxDB2
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class RestoreService
{
    /**
     * @var DefaultApi
     */
    protected $defaultApi;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param DefaultApi $defaultApi
     * @param HeaderSelector  $selector
     */
    public function __construct(DefaultApi $defaultApi)
    {
        $this->defaultApi = $defaultApi;
        $this->headerSelector = new HeaderSelector();
    }


    /**
     * Operation postRestoreBucketID
     *
     * Overwrite storage metadata for a bucket with shard info from a backup.
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $body Database info serialized as protobuf. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return string|string
     */
    public function postRestoreBucketID($bucket_id, $body, $zap_trace_span = null, $content_type = 'application/octet-stream')
    {
        list($response) = $this->postRestoreBucketIDWithHttpInfo($bucket_id, $body, $zap_trace_span, $content_type);
        return $response;
    }

    /**
     * Operation postRestoreBucketIDWithHttpInfo
     *
     * Overwrite storage metadata for a bucket with shard info from a backup.
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $body Database info serialized as protobuf. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of string|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postRestoreBucketIDWithHttpInfo($bucket_id, $body, $zap_trace_span = null, $content_type = 'application/octet-stream')
    {
        $request = $this->postRestoreBucketIDRequest($bucket_id, $body, $zap_trace_span, $content_type);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = 'string';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postRestoreBucketID'
     *
     * @param  string $bucket_id The bucket ID. (required)
     * @param  string $body Database info serialized as protobuf. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postRestoreBucketIDRequest($bucket_id, $body, $zap_trace_span = null, $content_type = 'application/octet-stream')
    {
        // verify the required parameter 'bucket_id' is set
        if ($bucket_id === null || (is_array($bucket_id) && count($bucket_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_id when calling postRestoreBucketID'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postRestoreBucketID'
            );
        }

        $resourcePath = '/api/v2/restore/bucket/{bucketID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($bucket_id !== null) {
            $resourcePath = str_replace(
                '{' . 'bucketID' . '}',
                ObjectSerializer::toPathValue($bucket_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['text/plain']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postRestoreBucketMetadata
     *
     * Create a new bucket pre-seeded with shard info from a backup.
     *
     * @param  \InfluxDB2\Model\BucketMetadataManifest $bucket_metadata_manifest Metadata manifest for a bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\RestoredBucketMappings|string
     */
    public function postRestoreBucketMetadata($bucket_metadata_manifest, $zap_trace_span = null)
    {
        list($response) = $this->postRestoreBucketMetadataWithHttpInfo($bucket_metadata_manifest, $zap_trace_span);
        return $response;
    }

    /**
     * Operation postRestoreBucketMetadataWithHttpInfo
     *
     * Create a new bucket pre-seeded with shard info from a backup.
     *
     * @param  \InfluxDB2\Model\BucketMetadataManifest $bucket_metadata_manifest Metadata manifest for a bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\RestoredBucketMappings|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postRestoreBucketMetadataWithHttpInfo($bucket_metadata_manifest, $zap_trace_span = null)
    {
        $request = $this->postRestoreBucketMetadataRequest($bucket_metadata_manifest, $zap_trace_span);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\RestoredBucketMappings';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postRestoreBucketMetadata'
     *
     * @param  \InfluxDB2\Model\BucketMetadataManifest $bucket_metadata_manifest Metadata manifest for a bucket. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postRestoreBucketMetadataRequest($bucket_metadata_manifest, $zap_trace_span = null)
    {
        // verify the required parameter 'bucket_metadata_manifest' is set
        if ($bucket_metadata_manifest === null || (is_array($bucket_metadata_manifest) && count($bucket_metadata_manifest) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $bucket_metadata_manifest when calling postRestoreBucketMetadata'
            );
        }

        $resourcePath = '/api/v2/restore/bucketMetadata';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }


        // body params
        $_tempBody = null;
        if (isset($bucket_metadata_manifest)) {
            $_tempBody = $bucket_metadata_manifest;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postRestoreKV
     *
     * Overwrite the embedded KV store on the server with a backed-up snapshot.
     *
     * @param  \SplFileObject $body Full KV snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \InfluxDB2\Model\PostRestoreKVResponse|string
     */
    public function postRestoreKV($body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        list($response) = $this->postRestoreKVWithHttpInfo($body, $zap_trace_span, $content_encoding, $content_type);
        return $response;
    }

    /**
     * Operation postRestoreKVWithHttpInfo
     *
     * Overwrite the embedded KV store on the server with a backed-up snapshot.
     *
     * @param  \SplFileObject $body Full KV snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \InfluxDB2\Model\PostRestoreKVResponse|string, HTTP status code, HTTP response headers (array of strings)
     */
    public function postRestoreKVWithHttpInfo($body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        $request = $this->postRestoreKVRequest($body, $zap_trace_span, $content_encoding, $content_type);

        $response = $this->defaultApi->sendRequest($request);

        $returnType = '\InfluxDB2\Model\PostRestoreKVResponse';
        $responseBody = $response->getBody();
        if ($returnType === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = $responseBody->getContents();
        }

        return [
            ObjectSerializer::deserialize($content, $returnType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    /**
     * Create request for operation 'postRestoreKV'
     *
     * @param  \SplFileObject $body Full KV snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postRestoreKVRequest($body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postRestoreKV'
            );
        }

        $resourcePath = '/api/v2/restore/kv';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_encoding !== null) {
            $headerParams['Content-Encoding'] = ObjectSerializer::toHeaderValue($content_encoding);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['text/plain']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postRestoreSQL
     *
     * Overwrite the embedded SQL store on the server with a backed-up snapshot.
     *
     * @param  \SplFileObject $body Full SQL snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postRestoreSQL($body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        $this->postRestoreSQLWithHttpInfo($body, $zap_trace_span, $content_encoding, $content_type);
    }

    /**
     * Operation postRestoreSQLWithHttpInfo
     *
     * Overwrite the embedded SQL store on the server with a backed-up snapshot.
     *
     * @param  \SplFileObject $body Full SQL snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postRestoreSQLWithHttpInfo($body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        $request = $this->postRestoreSQLRequest($body, $zap_trace_span, $content_encoding, $content_type);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'postRestoreSQL'
     *
     * @param  \SplFileObject $body Full SQL snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postRestoreSQLRequest($body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postRestoreSQL'
            );
        }

        $resourcePath = '/api/v2/restore/sql';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_encoding !== null) {
            $headerParams['Content-Encoding'] = ObjectSerializer::toHeaderValue($content_encoding);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }


        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['text/plain']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

    /**
     * Operation postRestoreShardId
     *
     * Restore a TSM snapshot into a shard.
     *
     * @param  string $shard_id The shard ID. (required)
     * @param  \SplFileObject $body TSM snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function postRestoreShardId($shard_id, $body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        $this->postRestoreShardIdWithHttpInfo($shard_id, $body, $zap_trace_span, $content_encoding, $content_type);
    }

    /**
     * Operation postRestoreShardIdWithHttpInfo
     *
     * Restore a TSM snapshot into a shard.
     *
     * @param  string $shard_id The shard ID. (required)
     * @param  \SplFileObject $body TSM snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InfluxDB2\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function postRestoreShardIdWithHttpInfo($shard_id, $body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        $request = $this->postRestoreShardIdRequest($shard_id, $body, $zap_trace_span, $content_encoding, $content_type);

        $response = $this->defaultApi->sendRequest($request);

        return [null, $response->getStatusCode(), $response->getHeaders()];
    }

    /**
     * Create request for operation 'postRestoreShardId'
     *
     * @param  string $shard_id The shard ID. (required)
     * @param  \SplFileObject $body TSM snapshot. (required)
     * @param  string $zap_trace_span OpenTracing span context (optional)
     * @param  string $content_encoding The value tells InfluxDB what compression is applied to the line protocol in the request payload. To make an API request with a GZIP payload, send &#x60;Content-Encoding: gzip&#x60; as a request header. (optional, default to 'identity')
     * @param  string $content_type (optional, default to 'application/octet-stream')
     *
     * @throws \InvalidArgumentException
     * @return \Psr\Http\Message\RequestInterface
     */
    protected function postRestoreShardIdRequest($shard_id, $body, $zap_trace_span = null, $content_encoding = 'identity', $content_type = 'application/octet-stream')
    {
        // verify the required parameter 'shard_id' is set
        if ($shard_id === null || (is_array($shard_id) && count($shard_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $shard_id when calling postRestoreShardId'
            );
        }
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling postRestoreShardId'
            );
        }

        $resourcePath = '/api/v2/restore/shards/{shardID}';
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // header params
        if ($zap_trace_span !== null) {
            $headerParams['Zap-Trace-Span'] = ObjectSerializer::toHeaderValue($zap_trace_span);
        }
        // header params
        if ($content_encoding !== null) {
            $headerParams['Content-Encoding'] = ObjectSerializer::toHeaderValue($content_encoding);
        }
        // header params
        if ($content_type !== null) {
            $headerParams['Content-Type'] = ObjectSerializer::toHeaderValue($content_type);
        }

        // path params
        if ($shard_id !== null) {
            $resourcePath = str_replace(
                '{' . 'shardID' . '}',
                ObjectSerializer::toPathValue($shard_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['text/plain']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = json_encode(ObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        }

        $headers = array_merge(
            $headerParams,
            $headers
        );

        return $this->defaultApi->createRequest('POST', $resourcePath, $httpBody, $headers, $queryParams);
    }

}
