/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.exceptions;

import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.logging.text.TreeFormatter;

public class ComponentVerificationException
extends GradleException {
    private final ModuleComponentIdentifier component;
    private final Consumer<TreeFormatter> causeErrorFormatter;

    public ComponentVerificationException(String message, ModuleComponentIdentifier component) {
        super(message);
        this.component = component;
        this.causeErrorFormatter = null;
    }

    public ComponentVerificationException(ModuleComponentIdentifier component, Consumer<TreeFormatter> causeErrorFormatter) {
        this.component = component;
        this.causeErrorFormatter = causeErrorFormatter;
    }

    public String getMessage() {
        TreeFormatter treeFormatter = new TreeFormatter();
        treeFormatter.node(String.format("An error happened meanwhile verifying '%s:%s:%s':", this.component.getGroup(), this.component.getModule(), this.component.getVersion()));
        if (this.causeErrorFormatter != null) {
            treeFormatter.startChildren();
            this.causeErrorFormatter.accept(treeFormatter);
            treeFormatter.endChildren();
        }
        return treeFormatter.toString();
    }
}

