/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.DefaultBuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.services.AbstractBuildCacheControllerFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.vfs.FileSystemAccess;

public class LegacyBuildCacheControllerFactory
extends AbstractBuildCacheControllerFactory<DirectoryBuildCacheService> {
    private final TemporaryFileProvider temporaryFileProvider;
    private final BuildCacheEntryPacker packer;

    public LegacyBuildCacheControllerFactory(StartParameter startParameter, BuildOperationExecutor buildOperationExecutor, OriginMetadataFactory originMetadataFactory, FileSystemAccess fileSystemAccess, StringInterner stringInterner, TemporaryFileProvider temporaryFileProvider, BuildCacheEntryPacker packer) {
        super(startParameter, buildOperationExecutor, originMetadataFactory, fileSystemAccess, stringInterner);
        this.temporaryFileProvider = temporaryFileProvider;
        this.packer = packer;
    }

    @Override
    protected BuildCacheController doCreateController(@Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<DirectoryBuildCache, DirectoryBuildCacheService> localDescribedService, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<BuildCache, BuildCacheService> remoteDescribedService) {
        BuildCacheServicesConfiguration config = LegacyBuildCacheControllerFactory.toConfiguration(localDescribedService, remoteDescribedService);
        boolean logStackTraces = this.startParameter.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
        boolean emitDebugLogging = this.startParameter.isBuildCacheDebugLogging();
        return new DefaultBuildCacheController(config, this.buildOperationExecutor, this.temporaryFileProvider, logStackTraces, emitDebugLogging, !Boolean.getBoolean("org.gradle.unsafe.build-cache.remote-continue-on-error"), this.fileSystemAccess, this.packer, this.originMetadataFactory, this.stringInterner);
    }

    private static BuildCacheServicesConfiguration toConfiguration(@Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<DirectoryBuildCache, DirectoryBuildCacheService> local, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<BuildCache, BuildCacheService> remote) {
        boolean localPush = local != null && ((DirectoryBuildCache)local.config).isPush();
        boolean remotePush = remote != null && ((BuildCache)remote.config).isPush();
        return new BuildCacheServicesConfiguration(local != null ? (LocalBuildCacheService)local.service : null, localPush, remote != null ? (BuildCacheService)remote.service : null, remotePush);
    }
}

