/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.terminal.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import org.jetbrains.kotlin.org.jline.terminal.Attributes;
import org.jetbrains.kotlin.org.jline.terminal.Size;
import org.jetbrains.kotlin.org.jline.terminal.Terminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.AbstractTerminal;
import org.jetbrains.kotlin.org.jline.terminal.impl.ExecPty;
import org.jetbrains.kotlin.org.jline.utils.InputStreamReader;
import org.jetbrains.kotlin.org.jline.utils.NonBlockingReader;

public class LineDisciplineTerminal
extends AbstractTerminal {
    protected final OutputStream masterOutput;
    protected final OutputStream slaveInputPipe;
    protected final InputStream slaveInput;
    protected final NonBlockingReader slaveReader;
    protected final PrintWriter slaveWriter;
    protected final OutputStream slaveOutput;
    protected final Attributes attributes;
    protected final Size size;

    public LineDisciplineTerminal(String name2, String type2, OutputStream masterOutput, String encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name2, type2, signalHandler);
        PipedInputStream input = new PipedInputStream(1024);
        this.slaveInputPipe = new PipedOutputStream(input);
        this.slaveInput = new FilterInputStream(input){};
        this.slaveReader = new NonBlockingReader(this.getName(), new InputStreamReader(this.slaveInput, encoding));
        this.slaveOutput = new FilteringOutputStream();
        this.slaveWriter = new PrintWriter(new OutputStreamWriter(this.slaveOutput, encoding));
        this.masterOutput = masterOutput;
        this.attributes = ExecPty.doGetAttr("speed 9600 baud; 24 rows; 80 columns;\nlflags: icanon isig iexten echo echoe -echok echoke -echonl echoctl\n\t-echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n\t-extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel iutf8\n\t-ignbrk brkint -inpck -ignpar -parmrk\noflags: opost onlcr -oxtabs -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n\t-dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n\teol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\n\tmin = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\n\tstop = ^S; susp = ^Z; time = 0; werase = ^W;\n");
        this.size = new Size(160, 50);
        this.parseInfoCmp();
    }

    @Override
    public NonBlockingReader reader() {
        return this.slaveReader;
    }

    @Override
    public PrintWriter writer() {
        return this.slaveWriter;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attr = new Attributes();
        attr.copy(this.attributes);
        return attr;
    }

    @Override
    public void setAttributes(Attributes attr) {
        this.attributes.copy(attr);
    }

    @Override
    public Size getSize() {
        Size sz = new Size();
        sz.copy(this.size);
        return sz;
    }

    @Override
    public void setSize(Size sz) {
        this.size.copy(sz);
    }

    @Override
    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        this.echoSignal(signal);
        super.raise(signal);
    }

    public void processInputByte(int c) throws IOException {
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                this.raise(Terminal.Signal.INT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                this.raise(Terminal.Signal.QUIT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                this.raise(Terminal.Signal.TSTP);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                this.raise(Terminal.Signal.INFO);
            }
        }
        if (c == 13) {
            if (this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) {
                return;
            }
            if (this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                c = 10;
            }
        } else if (c == 10 && this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
            c = 13;
        }
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            this.processOutputByte(c);
            this.masterOutput.flush();
        }
        this.slaveInputPipe.write(c);
        this.slaveInputPipe.flush();
    }

    protected void processOutputByte(int c) throws IOException {
        if (this.attributes.getOutputFlag(Attributes.OutputFlag.OPOST) && c == 10 && this.attributes.getOutputFlag(Attributes.OutputFlag.ONLCR)) {
            this.masterOutput.write(13);
            this.masterOutput.write(10);
            return;
        }
        this.masterOutput.write(c);
    }

    @Override
    public void close() throws IOException {
        try {
            this.slaveReader.close();
        }
        finally {
            try {
                this.slaveInputPipe.close();
            }
            finally {
                this.slaveWriter.close();
            }
        }
    }

    private class FilteringOutputStream
    extends OutputStream {
        private FilteringOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            LineDisciplineTerminal.this.processOutputByte(b);
            this.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                LineDisciplineTerminal.this.processOutputByte(b[off + i]);
            }
            this.flush();
        }

        @Override
        public void flush() throws IOException {
            LineDisciplineTerminal.this.masterOutput.flush();
        }

        @Override
        public void close() throws IOException {
            LineDisciplineTerminal.this.masterOutput.close();
        }
    }
}

