/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls.jvm;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.BodyResolveComponents;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractConeCallConflictResolver;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponents;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractConeCallConflictResolver;", "specificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "inferenceComponents", "Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;", "transformerComponents", "Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/fir/resolve/inference/InferenceComponents;Lorg/jetbrains/kotlin/fir/resolve/BodyResolveComponents;)V", "areEquivalentTopLevelCallables", "", "first", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "firstCandidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "second", "secondCandidate", "chooseMaximallySpecificCandidates", "", "candidates", "discriminateAbstracts", "createFlatSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "call", "declaration", "filterOutEquivalentCalls", "", "java"})
@SourceDebugExtension(value={"SMAP\nConeEquivalentCallConflictResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,84:1\n34#2:85\n*S KotlinDebug\n*F\n+ 1 ConeEquivalentCallConflictResolver.kt\norg/jetbrains/kotlin/fir/resolve/calls/jvm/ConeEquivalentCallConflictResolver\n*L\n62#1:85\n*E\n"})
public final class ConeEquivalentCallConflictResolver
extends AbstractConeCallConflictResolver {
    public ConeEquivalentCallConflictResolver(@NotNull TypeSpecificityComparator specificityComparator, @NotNull InferenceComponents inferenceComponents, @NotNull BodyResolveComponents transformerComponents) {
        Intrinsics.checkNotNullParameter((Object)specificityComparator, (String)"specificityComparator");
        Intrinsics.checkNotNullParameter((Object)inferenceComponents, (String)"inferenceComponents");
        Intrinsics.checkNotNullParameter((Object)transformerComponents, (String)"transformerComponents");
        super(specificityComparator, inferenceComponents, transformerComponents);
    }

    @Override
    @NotNull
    public Set<Candidate> chooseMaximallySpecificCandidates(@NotNull Set<Candidate> candidates2, boolean discriminateAbstracts) {
        Intrinsics.checkNotNullParameter(candidates2, (String)"candidates");
        return this.filterOutEquivalentCalls((Collection<Candidate>)candidates2);
    }

    private final Set<Candidate> filterOutEquivalentCalls(Collection<Candidate> candidates2) {
        Set result2 = new LinkedHashSet();
        block0: for (Candidate myCandidate : candidates2) {
            Object me = myCandidate.getSymbol().getFir();
            if (me instanceof FirCallableDeclaration && ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)me).getSymbol()) == null) {
                for (Candidate otherCandidate : result2) {
                    Object other = otherCandidate.getSymbol().getFir();
                    if (!(other instanceof FirCallableDeclaration) || ClassMembersKt.containingClassLookupTag(((FirCallableDeclaration)other).getSymbol()) != null || !this.areEquivalentTopLevelCallables((FirCallableDeclaration)me, myCandidate, (FirCallableDeclaration)other, otherCandidate)) continue;
                    continue block0;
                }
            }
            ((Collection)result2).add(myCandidate);
        }
        return result2;
    }

    private final boolean areEquivalentTopLevelCallables(FirCallableDeclaration first, Candidate firstCandidate, FirCallableDeclaration second, Candidate secondCandidate) {
        FlatSignature<Candidate> secondSignature;
        FirPureAbstractElement firPureAbstractElement;
        if (!Intrinsics.areEqual((Object)first.getSymbol().getCallableId(), (Object)second.getSymbol().getCallableId())) {
            return false;
        }
        FirMemberDeclaration $this$isExpect$iv = first;
        boolean $i$f$isExpect = false;
        boolean bl = $this$isExpect$iv.getStatus().isExpect();
        $this$isExpect$iv = second;
        $i$f$isExpect = false;
        if (bl != $this$isExpect$iv.getStatus().isExpect()) {
            return false;
        }
        FirPureAbstractElement firPureAbstractElement2 = first.getReceiverParameter();
        if (!Intrinsics.areEqual((Object)(firPureAbstractElement2 != null && (firPureAbstractElement2 = firPureAbstractElement2.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement2) : null), (firPureAbstractElement = second.getReceiverParameter()) != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null ? FirTypeUtilsKt.getConeType((FirTypeRef)firPureAbstractElement) : null)) {
            return false;
        }
        if (first instanceof FirVariable != second instanceof FirVariable) {
            return false;
        }
        FlatSignature<Candidate> firstSignature = this.createFlatSignature(firstCandidate, first);
        return this.compareCallsByUsedArguments(firstSignature, secondSignature = this.createFlatSignature(secondCandidate, second), false, false) && this.compareCallsByUsedArguments(secondSignature, firstSignature, false, false);
    }

    private final FlatSignature<Candidate> createFlatSignature(Candidate call2, FirCallableDeclaration declaration) {
        FlatSignature<Candidate> flatSignature;
        FirCallableDeclaration firCallableDeclaration = declaration;
        if (firCallableDeclaration instanceof FirSimpleFunction) {
            flatSignature = this.createFlatSignature(call2, (FirSimpleFunction)declaration);
        } else if (firCallableDeclaration instanceof FirConstructor) {
            flatSignature = this.createFlatSignature(call2, (FirConstructor)declaration);
        } else if (firCallableDeclaration instanceof FirVariable) {
            flatSignature = this.createFlatSignature(call2, (FirVariable)declaration);
        } else {
            throw new IllegalStateException(("Not supported: " + declaration).toString());
        }
        return flatSignature;
    }
}

