complete -c pg_dumpall --no-files

# General options:
complete -c pg_dumpall -s f -l file -r -d "Output file name"
complete -c pg_dumpall -s v -l verbose -d "Verbose mode"
complete -c pg_dumpall -s V -l version -d "Output version information"
complete -c pg_dumpall -l lock-wait-timeout -x -d "Fail after waiting TIMEOUT for a table lock"
complete -c pg_dumpall -s '?' -l help -d "Show this help"

# Options controlling the output content:
complete -c pg_dumpall -s a -l data-only -d "Dump only the data, not the schema"
complete -c pg_dumpall -s c -l clean -d "Clean (drop) database objects before recreating"
complete -c pg_dumpall -s E -l encoding -x -d "Dump the data in encoding ENCODING"
complete -c pg_dumpall -s g -l globals-only -d "Dump only global objects, no databases"
complete -c pg_dumpall -s o -l oids -d "Include OIDs in dump"
complete -c pg_dumpall -s O -l no-owner -d "Skip restoration of object ownership"
complete -c pg_dumpall -s r -l roles-only -d "Dump only roles, no databases or tablespaces"
complete -c pg_dumpall -s s -l schema-only -d "Dump only the schema, no data"
complete -c pg_dumpall -s S -l superuser -x -d "Superuser user name to use in the dump"
complete -c pg_dumpall -s t -l tablespaces-only -d "Dump only tablespaces, no databases or roles"
complete -c pg_dumpall -s x -l no-privileges -d "Do not dump privileges (grant/revoke)"
complete -c pg_dumpall -l binary-upgrade -d "For use by upgrade utilities only"
complete -c pg_dumpall -l column-inserts -d "Dump data as INSERT commands with column names"
complete -c pg_dumpall -l disable-dollar-quoting -d "Disable dollar quoting, use SQL standard quoting"
complete -c pg_dumpall -l disable-triggers -d "Disable triggers during data-only restore"
complete -c pg_dumpall -l if-exists -d "Use IF EXISTS when dropping objects"
complete -c pg_dumpall -l inserts -d "Dump data as INSERT commands, rather than COPY"
complete -c pg_dumpall -l load-via-partition-root -d "Load partitions via the root table"
complete -c pg_dumpall -l no-comments -d "Do not dump comments"
complete -c pg_dumpall -l no-publications -d "Do not dump publications"
complete -c pg_dumpall -l no-role-passwords -d "Do not dump passwords for roles"
complete -c pg_dumpall -l no-security-labels -d "Do not dump security label assignments"
complete -c pg_dumpall -l no-subscriptions -d "Do not dump subscriptions"
complete -c pg_dumpall -l no-sync -d "Do not wait for changes to be written safely to disk"
complete -c pg_dumpall -l no-tablespaces -d "Do not dump tablespace assignments"
complete -c pg_dumpall -l no-unlogged-table-data -d "Do not dump unlogged table data"
complete -c pg_dumpall -l quote-all-identifiers -d "Quote all identifiers, even if not key words"
complete -c pg_dumpall -l use-set-session-authorization -d "Use SET SESSION AUTHORIZATION instead of ALTER OWNER"

# Connection options:
complete -c pg_dumpall -s d -l dbname -x -a '(__fish_complete_pg_database)' -d "Database to dump"
complete -c pg_dumpall -s h -l host -x -a '(__fish_print_hostnames)' -d "Database server host or socket directory"
complete -c pg_dumpall -s l -l database -x -a '(__fish_complete_pg_database)' -d "Alternative default database"
complete -c pg_dumpall -s p -l port -x -d "Database server port number"
complete -c pg_dumpall -s U -l username -x -a '(__fish_complete_pg_user)' -d "Connect as specified database user"
complete -c pg_dumpall -s w -l no-password -d "Never prompt for password"
complete -c pg_dumpall -s W -l password -d "Force password prompt (should happen automatically)"
complete -c pg_dumpall -l role -x -d "Do SET ROLE before dump"
