"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSqlRoute = registerSqlRoute;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerSqlRoute(server, service) {
  server.post({
    path: '/api/sql/sqlquery',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describeSQLQuery(request);
    return response.ok({
      body: retVal
    });
  });
  server.post({
    path: '/api/sql/pplquery',
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const retVal = await service.describePPLQuery(request);
    return response.ok({
      body: retVal
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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