"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestor = void 0;

var _wreck = _interopRequireDefault(require("@hapi/wreck"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const requestor = async function (requestType, url, wreckOptions) {
  const promise = _wreck.default.request(requestType, url, wreckOptions);

  const res = await promise;
  const body = await _wreck.default.read(res, wreckOptions);
  return body;
};

exports.requestor = requestor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndyZWNrX3JlcXVlc3RzLnRzIl0sIm5hbWVzIjpbInJlcXVlc3RvciIsInJlcXVlc3RUeXBlIiwidXJsIiwid3JlY2tPcHRpb25zIiwicHJvbWlzZSIsIldyZWNrIiwicmVxdWVzdCIsInJlcyIsImJvZHkiLCJyZWFkIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0E7Ozs7QUFMQTtBQUNBO0FBQ0E7QUFDQTtBQUtPLE1BQU1BLFNBQVMsR0FBRyxnQkFDdkJDLFdBRHVCLEVBRXZCQyxHQUZ1QixFQUd2QkMsWUFIdUIsRUFJdkI7QUFDQSxRQUFNQyxPQUFPLEdBQUdDLGVBQU1DLE9BQU4sQ0FBY0wsV0FBZCxFQUEyQkMsR0FBM0IsRUFBZ0NDLFlBQWhDLENBQWhCOztBQUNBLFFBQU1JLEdBQUcsR0FBRyxNQUFNSCxPQUFsQjtBQUNBLFFBQU1JLElBQUksR0FBRyxNQUFNSCxlQUFNSSxJQUFOLENBQVdGLEdBQVgsRUFBZ0JKLFlBQWhCLENBQW5CO0FBQ0EsU0FBT0ssSUFBUDtBQUNELENBVE0iLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCBXcmVjayBmcm9tICdAaGFwaS93cmVjayc7XG5pbXBvcnQgeyBvcHRpb25zVHlwZSB9IGZyb20gJy4uLy4uLy4uLy4uL2NvbW1vbi90eXBlcy9ub3RlYm9va3MnO1xuXG5leHBvcnQgY29uc3QgcmVxdWVzdG9yID0gYXN5bmMgZnVuY3Rpb24gKFxuICByZXF1ZXN0VHlwZTogc3RyaW5nLFxuICB1cmw6IHN0cmluZyxcbiAgd3JlY2tPcHRpb25zOiBvcHRpb25zVHlwZVxuKSB7XG4gIGNvbnN0IHByb21pc2UgPSBXcmVjay5yZXF1ZXN0KHJlcXVlc3RUeXBlLCB1cmwsIHdyZWNrT3B0aW9ucyk7XG4gIGNvbnN0IHJlcyA9IGF3YWl0IHByb21pc2U7XG4gIGNvbnN0IGJvZHkgPSBhd2FpdCBXcmVjay5yZWFkKHJlcywgd3JlY2tPcHRpb25zKTtcbiAgcmV0dXJuIGJvZHk7XG59O1xuIl19