"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLDataSource = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class PPLDataSource {
  constructor(pplDataSource, dataType) {
    this.pplDataSource = pplDataSource;
    this.dataType = dataType;

    _defineProperty(this, "addStatsMapping", () => {
      var _visData$metadata;

      const visData = this.pplDataSource;
      /**
       * Add vis mapping for runtime fields
       * json data structure added to response will be
       * [{
       *  agent: "mozilla",
       *  avg(bytes): 5756
       *  ...
       * }, {
       *  agent: "MSIE",
       *  avg(bytes): 5605
       *  ...
       * }, {
       *  agent: "chrome",
       *  avg(bytes): 5648
       *  ...
       * }]
       */

      const res = [];

      if (visData !== null && visData !== void 0 && (_visData$metadata = visData.metadata) !== null && _visData$metadata !== void 0 && _visData$metadata.fields) {
        const queriedFields = visData.metadata.fields;

        for (let i = 0; i < visData.size; i++) {
          const entry = {};
          queriedFields.map(field => {
            const statsDataSet = visData === null || visData === void 0 ? void 0 : visData.data;
            entry[field.name] = statsDataSet[field.name][i];
          });
          res.push(entry);
        }

        visData.jsonData = res;
      }
    });

    _defineProperty(this, "addSchemaRowMapping", () => {
      const pplRes = this.pplDataSource;
      const data = [];

      _lodash.default.forEach(pplRes.datarows, row => {
        const record = {};

        for (let i = 0; i < pplRes.schema.length; i++) {
          const cur = pplRes.schema[i];

          if (typeof row[i] === 'object') {
            record[cur.name] = JSON.stringify(row[i]);
          } else if (typeof row[i] === 'boolean') {
            record[cur.name] = row[i].toString();
          } else {
            record[cur.name] = row[i];
          }
        }

        data.push(record);
      });

      pplRes.jsonData = data;
    });

    _defineProperty(this, "getDataSource", () => this.pplDataSource);

    if (this.dataType === 'jdbc') {
      this.addSchemaRowMapping();
    } else if (this.dataType === 'viz') {
      this.addStatsMapping();
    }
  }
  /**
   * Add 'schemaName: data' entries for UI rendering
   */


}

exports.PPLDataSource = PPLDataSource;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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