/* $NetBSD: sun8i_a83t_ccu.h,v 1.2 2017/10/28 12:07:40 jmcneill Exp $ */

/*-
 * Copyright (c) 2017 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SUN8I_A83T_CCU_H
#define _SUN8I_A83T_CCU_H

#define	A83T_RST_USB_PHY0		0
#define	A83T_RST_USB_PHY1		1
#define	A83T_RST_USB_HSIC		2
#define	A83T_RST_DRAM			3
#define	A83T_RST_MBUS			4
#define	A83T_RST_BUS_MIPI_DSI		5
#define	A83T_RST_BUS_SS			6
#define	A83T_RST_BUS_DMA		7
#define	A83T_RST_BUS_MMC0		8
#define	A83T_RST_BUS_MMC1		9
#define	A83T_RST_BUS_MMC2		10
#define	A83T_RST_BUS_NAND		11
#define	A83T_RST_BUS_DRAM		12
#define	A83T_RST_BUS_EMAC		13
#define	A83T_RST_BUS_HSTIMER		14
#define	A83T_RST_BUS_SPI0		15
#define	A83T_RST_BUS_SPI1		16
#define	A83T_RST_BUS_OTG		17
#define	A83T_RST_BUS_EHCI0		18
#define	A83T_RST_BUS_EHCI1		19
#define	A83T_RST_BUS_OHCI0		20
#define	A83T_RST_BUS_VE			21
#define	A83T_RST_BUS_TCON0		22
#define	A83T_RST_BUS_TCON1		23
#define	A83T_RST_BUS_CSI		24
#define	A83T_RST_BUS_HDMI0		25
#define	A83T_RST_BUS_HDMI1		26
#define	A83T_RST_BUS_DE			27
#define	A83T_RST_BUS_GPU		28
#define	A83T_RST_BUS_MSGBOX		29
#define	A83T_RST_BUS_SPINLOCK		30
#define	A83T_RST_BUS_LVDS		31
#define	A83T_RST_BUS_SPDIF		32
#define	A83T_RST_BUS_I2S0		33
#define	A83T_RST_BUS_I2S1		34
#define	A83T_RST_BUS_I2S2		35
#define	A83T_RST_BUS_TDM		36
#define	A83T_RST_BUS_I2C0		37
#define	A83T_RST_BUS_I2C1		38
#define	A83T_RST_BUS_I2C2		39
#define	A83T_RST_BUS_UART0		40
#define	A83T_RST_BUS_UART1		41
#define	A83T_RST_BUS_UART2		42
#define	A83T_RST_BUS_UART3		43
#define	A83T_RST_BUS_UART4		44

#define	A83T_CLK_PLL_C0CPUX		0
#define	A83T_CLK_PLL_C1CPUX		1
#define	A83T_CLK_PLL_AUDIO		2
#define	A83T_CLK_PLL_VIDEO0		3
#define	A83T_CLK_PLL_VE			4
#define	A83T_CLK_PLL_DDR		5
#define	A83T_CLK_PLL_PERIPH		6
#define	A83T_CLK_PLL_GPU		7
#define	A83T_CLK_PLL_HSIC		8
#define	A83T_CLK_PLL_DE			9
#define	A83T_CLK_PLL_VIDEO1		10
#define	A83T_CLK_C0CPUX			11
#define	A83T_CLK_C1CPUX			12
#define	A83T_CLK_AXI0			13
#define	A83T_CLK_AXI1			14
#define	A83T_CLK_AHB1			15
#define	A83T_CLK_AHB2			16
#define	A83T_CLK_APB1			17
#define	A83T_CLK_APB2			18
#define	A83T_CLK_BUS_MIPI_DSI		19
#define	A83T_CLK_BUS_SS			20
#define	A83T_CLK_BUS_DMA		21
#define	A83T_CLK_BUS_MMC0		22
#define	A83T_CLK_BUS_MMC1		23
#define	A83T_CLK_BUS_MMC2		24
#define	A83T_CLK_BUS_NAND		25
#define	A83T_CLK_BUS_DRAM		26
#define	A83T_CLK_BUS_EMAC		27
#define	A83T_CLK_BUS_HSTIMER		28
#define	A83T_CLK_BUS_SPI0		29
#define	A83T_CLK_BUS_SPI1		30
#define	A83T_CLK_BUS_OTG		31
#define	A83T_CLK_BUS_EHCI0		32
#define	A83T_CLK_BUS_EHCI1		33
#define	A83T_CLK_BUS_OHCI0		34
#define	A83T_CLK_BUS_VE			35
#define	A83T_CLK_BUS_TCON0		36
#define	A83T_CLK_BUS_TCON1		37
#define	A83T_CLK_BUS_CSI		38
#define	A83T_CLK_BUS_HDMI		39
#define	A83T_CLK_BUS_DE			40
#define	A83T_CLK_BUS_GPU		41
#define	A83T_CLK_BUS_MSGBOX		42
#define	A83T_CLK_BUS_SPINLOCK		43
#define	A83T_CLK_BUS_SPDIF		44
#define	A83T_CLK_BUS_PIO		45
#define	A83T_CLK_BUS_I2S0		46
#define	A83T_CLK_BUS_I2S1		47
#define	A83T_CLK_BUS_I2S2		48
#define	A83T_CLK_BUS_TDM		49
#define	A83T_CLK_BUS_I2C0		50
#define	A83T_CLK_BUS_I2C1		51
#define	A83T_CLK_BUS_I2C2		52
#define	A83T_CLK_BUS_UART0		53
#define	A83T_CLK_BUS_UART1		54
#define	A83T_CLK_BUS_UART2		55
#define	A83T_CLK_BUS_UART3		56
#define	A83T_CLK_BUS_UART4		57
#define	A83T_CLK_CCI400			58
#define	A83T_CLK_NAND			59
#define	A83T_CLK_MMC0			60
#define	A83T_CLK_MMC0_SAMPLE		61
#define	A83T_CLK_MMC0_OUTPUT		62
#define	A83T_CLK_MMC1			63
#define	A83T_CLK_MMC1_SAMPLE		64
#define	A83T_CLK_MMC1_OUTPUT		65
#define	A83T_CLK_MMC2			66
#define	A83T_CLK_MMC2_SAMPLE		67
#define	A83T_CLK_MMC2_OUTPUT		68
#define	A83T_CLK_SS			69
#define	A83T_CLK_SPI0			70
#define	A83T_CLK_SPI1			71
#define	A83T_CLK_I2S0			72
#define	A83T_CLK_I2S1			73
#define	A83T_CLK_I2S2			74
#define	A83T_CLK_TDM			75
#define	A83T_CLK_SPDIF			76
#define	A83T_CLK_USB_PHY0		77
#define	A83T_CLK_USB_PHY1		78
#define	A83T_CLK_USB_HSIC		79
#define	A83T_CLK_USB_HSIC_12M		80
#define	A83T_CLK_USB_OHCI0		81
#define	A83T_CLK_DRAM			82
#define	A83T_CLK_DRAM_VE		83
#define	A83T_CLK_DRAM_CSI		84
#define	A83T_CLK_TCON0			85
#define	A83T_CLK_TCON1			86
#define	A83T_CLK_CSI_MISC		87
#define	A83T_CLK_MIPI_CSI		88
#define	A83T_CLK_CSI_MCLK		89
#define	A83T_CLK_CSI_SCLK		90
#define	A83T_CLK_VE			91
#define	A83T_CLK_AVS			92
#define	A83T_CLK_HDMI			93
#define	A83T_CLK_HDMI_SLOW		94
#define	A83T_CLK_MBUS			95
#define	A83T_CLK_MIPI_DSI0		96
#define	A83T_CLK_MIPI_DSI1		97
#define	A83T_CLK_GPU_CORE		98
#define	A83T_CLK_GPU_MEMORY		99
#define	A83T_CLK_GPU_HYD		100

#endif /* !_SUN8I_A83T_CCU_H */
