/*	$NetBSD: imx6_usbreg.h,v 1.1 2020/12/23 14:42:38 skrll Exp $	*/

/*
 * Copyright (c) 2014 Ryo Shimizu <ryo@nerv.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _IMX6_USBREG_H_
#define _IMX6_USBREG_H_

#include <sys/cdefs.h>

#define USBC_UOG_CAPLENGTH			0x00000100
#define USBC_UOG_PORTSC1			0x00000184
#define USBC_UOG_USBMODE			0x000001a8
#define  USBC_UOG_USBMODE_SDIS			__BIT(4)
#define  USBC_UOG_USBMODE_SLOM			__BIT(3)
#define  USBC_UOG_USBMODE_ES			__BIT(2)
#define  USBC_UOG_USBMODE_CM			__BITS(1, 0)
#define USBC_UH1_CAPLENGTH			0x00000300
#define USBC_UH1_PORTSC1			0x00000384
#define  USBC_UH_PORTSC1_PTS_1			__BITS(31, 30)
#define  USBC_UH_PORTSC1_PE			__BIT(2)
#define  USBC_UH_PORTSC1_PTS_2			__BIT(25)
#define  USBC_UH_PORTSC1_PTS_MASK		(__BITS(31, 30) | __BIT(25))
#define  USBC_UH_PORTSC1_PTS_UTMI		0
#define  USBC_UH_PORTSC1_PTS_ULPI		__BIT(31)
#define  USBC_UH_PORTSC1_PTS_SERIAL		(__BIT(31) | __BIT(30))
#define  USBC_UH_PORTSC1_PTS_HSIC		__BIT(25)
#define USBC_UH1_USBMODE			0x000003a8
#define  USBC_UH_USBMODE_SDIS			__BIT(4)
#define  USBC_UH_USBMODE_SLOM			__BIT(3)
#define  USBC_UH_USBMODE_ES			__BIT(2)
#define  USBC_UH_USBMODE_CM			__BITS(1, 0)
#define  USBC_UH_USBMODE_CM_IDLE		0
#define  USBC_UH_USBMODE_CM_DEVICE_CONTROLLER	2
#define  USBC_UH_USBMODE_CM_HOST_CONTROLLER	3
#define USBC_UH2_CAPLENGTH			0x00000500
#define USBC_UH2_PORTSC1			0x00000584
#define USBC_UH2_USBMODE			0x000005a8
#define USBC_UH3_CAPLENGTH			0x00000700
#define USBC_UH3_PORTSC1			0x00000784
#define USBC_UH3_USBMODE			0x000007a8

#define USBNC_BASE				0x00000800
#define USBNC_SIZE				0x00000020
#define USBNC_USB_OTG_CTRL			0x00000000
#define  USBNC_USB_OTG_CTRL_WIR			__BIT(31)
#define  USBNC_USB_OTG_CTRL_WKUP_VBUS_EN	__BIT(17)
#define  USBNC_USB_OTG_CTRL_WKUP_ID_EN		__BIT(16)
#define  USBNC_USB_OTG_CTRL_WKUP_SW		__BIT(15)
#define  USBNC_USB_OTG_CTRL_WKUP_SW_EN		__BIT(14)
#define  USBNC_USB_OTG_CTRL_UTMI_ON_CLOCK	__BIT(13)
#define  USBNC_USB_OTG_CTRL_WIE			__BIT(10)
#define  USBNC_USB_OTG_CTRL_PWR_POL		__BIT(9)
#define  USBNC_USB_OTG_CTRL_OVER_CUR_POL	__BIT(8)
#define  USBNC_USB_OTG_CTRL_OVER_CUR_DIS	__BIT(7)
#define USBNC_USB_UH1_CTRL			0x00000004
#define  USBNC_USB_UH1_CTRL_WIR			__BIT(31)
#define  USBNC_USB_UH1_CTRL_WKUP_VBUS_EN	__BIT(17)
#define  USBNC_USB_UH1_CTRL_WKUP_ID_EN		__BIT(16)
#define  USBNC_USB_UH1_CTRL_WKUP_SW		__BIT(15)
#define  USBNC_USB_UH1_CTRL_WKUP_SW_EN		__BIT(14)
#define  USBNC_USB_UH1_CTRL_UTMI_ON_CLOCK	__BIT(13)
#define  USBNC_USB_UH1_CTRL_WIE			__BIT(10)
#define  USBNC_USB_UH1_CTRL_PWR_POL		__BIT(9)
#define  USBNC_USB_UH1_CTRL_OVER_CUR_POL	__BIT(8)
#define  USBNC_USB_UH1_CTRL_OVER_CUR_DIS	__BIT(7)
#define USBNC_USB_UH2_CTRL			0x00000008
#define  USBNC_USB_UH2_CTRL_WKUP_SW		__BIT(15)
#define  USBNC_USB_UH2_CTRL_WKUP_SW_EN		__BIT(14)
#define  USBNC_USB_UH2_CTRL_UTMI_ON_CLOCK	__BIT(13)
#define  USBNC_USB_UH2_CTRL_WIE			__BIT(10)
#define USBNC_USB_UH3_CTRL			0x0000000c
#define  USBNC_USB_UH3_CTRL_WKUP_SW		__BIT(15)
#define  USBNC_USB_UH3_CTRL_WKUP_SW_EN		__BIT(14)
#define  USBNC_USB_UH3_CTRL_UTMI_ON_CLOCK	__BIT(13)
#define  USBNC_USB_UH3_CTRL_WIE			__BIT(10)
#define USBNC_USB_UH2_HSIC_CTRL			0x00000010
#define  USBNC_USB_UH2_HSIC_CTRL_CLK_VLK	__BIT(31)
#define  USBNC_USB_UH2_HSIC_CTRL_HSIC_EN	__BIT(12)
#define  USBNC_USB_UH2_HSIC_CTRL_HSIC_CLK_ON	__BIT(11)
#define USBNC_USB_UH3_HSIC_CTRL			0x00000014
#define  USBNC_USB_UH3_HSIC_CTRL_CLK_VLK	__BIT(31)
#define  USBNC_USB_UH3_HSIC_CTRL_HSIC_EN	__BIT(12)
#define  USBNC_USB_UH3_HSIC_CTRL_HSIC_CLK_ON	__BIT(11)
#define USBNC_USB_OTG_PHY_CTRL_0		0x00000018
#define  USBNC_USB_OTG_PHY_CTRL_0_UTMI_CLK_VLD	__BIT(31)
#define USBNC_USB_UH1_PHY_CTRL_0		0x0000001c
#define  USBNC_USB_UH1_PHY_CTRL_0_UTMI_CLK_VLD	__BIT(31)

#endif /* _IMX6_USBREG_H_ */
