unit peach; //Main form of PeaZip, organized in file browser, archiving, extraction, and options screens
{
 DESCRIPTION     :  Application providing GUI for calling PEA and third parts
                    open source executables, giving graphic tools for composing
                    appropriate command lines, such as files/folder selection,
                    import/export lists, choose parameters from graphic menus
                    etc.
                    Provides archive theming, cross-platform desktop, and script
                    integration features.
 REQUIREMENTS    :  FPC, Lazarus
                    Compiled pea and pealauncher in (peazip)/res/bin path
                    third parts executables in (peazip)/res/bin/executablename/
                    path

 EXTERNAL DATA   :  ---

 MEMORY USAGE    :  ---

 DISPLAY MODE    :  ---

 REFERENCES      :  ---

 REMARK          :  "Modification" notes are reported only for the last version.
                    To read all version's notes please refer to Change log page
                    https://peazip.github.io/changelog.html

 Version  Date      Author      Modification
 -------  --------  -------     ------------------------------------------
 PEA-PEACH
 0.10     20060908  G.Tani      Initial version named Pea-Peach 0.10
 0.11     20060920  G.Tani
 0.12     20060927  G.Tani
 0.13     20061103  G.Tani      Changed name of the release to PeaZip 1.0
 0.14     20061201  G.Tani      1.1
 0.15     20070118  G.Tani      1.2
 0.15b    20070122  G.Tani      1.2b
 0.16     20070201  G.Tani      1.3
 0.17     20070305  G.Tani      1.4
 0.18     20070319  G.Tani      1.5
 0.19     20070407  G.Tani      1.6
 0.20     20070512  G.Tani      1.7
 0.21     20070605  G.Tani      1.8
 0.22     20070708  G.Tani      1.8.1
 0.23     20070717  G.Tani      1.8.2
 0.24     20070807  G.Tani      1.9
 0.25     20070904  G.Tani      1.9.1
 0.26     20071003  G.Tani      1.9.2
 0.27     20071101  G.Tani      1.9.3
 0.28     20071206  G.Tani      1.10
 0.29     20080125  G.Tani      1.11
 0.30     20080319  G.Tani      2.0
 0.31     20080517  G.Tani      2.1
 0.32     20080807  G.Tani      2.2
 0.33     20080922  G.Tani      2.3a
 0.34     20081103  G.Tani      2.4
 0.35     20081124  G.Tani      2.4.1
 0.36     20090127  G.Tani      2.5
 0.37     20090224  G.Tani      2.5.1
 0.38     20090403  G.Tani      2.6.beta
 0.39     20090430  G.Tani      2.6
 0.40     20090604  G.Tani      2.6.1
 0.41     20090611  G.Tani      2.6.2
 0.42     20090713  G.Tani      2.6.3
 0.43     20090826  G.Tani      2.7.beta
 0.44     20090914  G.Tani      2.7
 0.45     20091017  G.Tani      2.7.1
 0.46     20091105  G.Tani      2.8.beta
 0.47     20091118  G.Tani      2.8
 0.48     20091202  G.Tani      2.8.1
 0.49     20100104  G.Tani      2.9.beta
 0.50     20100114  G.Tani      2.9
 0.51     20100124  G.Tani      2.9.1
 0.52     20100209  G.Tani      3.0.beta
 0.53     20100216  G.Tani      3.0
 0.54     20100408  G.Tani      3.1.beta
 0.55     20100424  G.Tani      3.1
 0.56     20100613  G.Tani      3.2
 0.57     20100626  G.Tani      3.2.1
 0.58     20100914  G.Tani      3.3
 0.59     20101023  G.Tani      3.4
 0.60     20101123  G.Tani      3.5
 0.61     20101212  G.Tani      3.5.1
 0.62     20101224  G.Tani      3.6
 0.63     20110209  G.Tani      3.6.1
 0.64     20110221  G.Tani      3.6.2
 0.65     20110406  G.Tani      3.7
 0.66     20110611  G.Tani      3.8
 0.67     20110731  G.Tani      3.9
 0.68     20110825  G.Tani      3.9.1
 0.69     20110918  G.Tani      4.0
 0.70     20111016  G.Tani      4.1
 0.71     20111120  G.Tani      4.2
 0.72     20111224  G.Tani      4.3
 0.73     20120128  G.Tani      4.4
 0.74     20120407  G.Tani      4.5
 0.75     20120501  G.Tani      4.5.1
 0.76     20120612  G.Tani      4.6
 0.77     20120702  G.Tani      4.6.1
 0.78     20120807  G.Tani      4.7
 0.79     20120818  G.Tani      4.7.1
 0.80     20120914  G.Tani      4.7.2
 0.81     20121014  G.Tani      4.7.3
 0.82     20121118  G.Tani      4.8
 0.83     20130117  G.Tani      4.8.1
 0.84     20130304  G.Tani      4.9
 0.85     20130323  G.Tani      4.9.1
 0.86     20130421  G.Tani      4.9.2
 0.87     20130617  G.Tani      5.0.0
 0.88     20130718  G.Tani      5.0.1
 0.89     20130830  G.Tani      5.1.0
 0.90     20131002  G.Tani      5.1.1
 0.91     20131122  G.Tani      5.2.0
 0.92     20131225  G.Tani      5.2.1
 0.93     20140221  G.Tani      5.2.2
 0.94     20140410  G.Tani      5.3.0
 0.95     20140502  G.Tani      5.3.1
 0.96     20140707  G.Tani      5.4.0
 0.97     20140810  G.Tani      5.4.1
 0.98     20141015  G.Tani      5.5.0
 0.99     20141201  G.Tani      5.5.1
 1.00     20141220  G.Tani      5.5.2
 1.01     20150117  G.Tani      5.5.3
 1.02     20150425  G.Tani      5.6.0
 1.03     20150613  G.Tani      5.6.1
 1.04     20150718  G.Tani      5.7.0
 1.05     20150811  G.Tani      5.7.1
 1.06     20150824  G.Tani      5.7.2
 1.07     20151003  G.Tani      5.8.0
 1.08     20151018  G.Tani      5.8.1
 1.09     20151125  G.Tani      5.9.0
 1.10     20151227  G.Tani      5.9.1
 1.11     20160221  G.Tani      6.0.0
 1.12     20160424  G.Tani      6.0.1
 1.13     20160512  G.Tani      6.0.2
 1.14     20160618  G.Tani      6.0.3
 1.15     20160721  G.Tani      6.1.0
 1.16     20160909  G.Tani      6.1.1
 1.17     20161101  G.Tani      6.2.0
 1.18     20161226  G.Tani      6.3.0
 1.19     20170205  G.Tani      6.3.1
 1.20     20170323  G.Tani      6.4.0
 1.21     20170429  G.Tani      6.4.1
 1.22     20171014  G.Tani      6.5.0
 1.23     20180208  G.Tani      6.5.1
 1.24     20180503  G.Tani      6.6.0
 1.25     20181024  G.Tani      6.6.1
 1.26     20190205  G.Tani      6.7.0
 1.27     20190309  G.Tani      6.7.1
 1.28     20190413  G.Tani      6.7.2
 1.29     20190501  G.Tani      6.8.0
 1.30     20190613  G.Tani      6.8.1
 1.31     20190815  G.Tani      6.9.0
 1.32     20190825  G.Tani      6.9.1
 1.33     20190831  G.Tani      6.9.2
 1.34     20191125  G.Tani      7.0.0
 1.35     20191228  G.Tani      7.0.1
 1.36     20200201  G.Tani      7.1.0
 1.37     20200307  G.Tani      7.1.1
 1.38     20200406  G.Tani      7.2.0
 1.39     20200424  G.Tani      7.2.1
 1.40     20200505  G.Tani      7.2.2
 1.41     20200514  G.Tani      7.3.0
 1.42     20200531  G.Tani      7.3.1
 1.43     20200618  G.Tani      7.3.2
 1.44     20200820  G.Tani      7.4.0
 1.45     20200905  G.Tani      7.4.1
 1.46     20200929  G.Tani      7.4.2
 1.47     20201110  G.Tani      7.5.0
 1.48     20201212  G.Tani      7.6.0
 1.49     20210105  G.Tani      7.7.0
 1.50     20210210  G.Tani      7.7.1
 1.51     20210315  G.Tani      7.8.0
 1.52     20210417  G.Tani      7.9.0
 1.53     20210609  G.Tani      8.0.0
 1.54     20210720  G.Tani      8.1.0
 1.55     20210909  G.Tani      8.2.0
 1.56     20211111  G.Tani      8.3.0
 1.57     20211212  G.Tani      8.4.0
 1.58     20220219  G.Tani      8.5.0
 1.59     20220406  G.Tani      8.6.0
 1.60     20220622  G.Tani      8.7.0
 1.61     20220814  G.Tani      8.8.0
 1.62     20221008  G.Tani      8.9.0
 1.63     20221215  G.Tani      9.0.0
 1.64     20230221  G.Tani      9.1.0
 1.65     20230415  G.Tani      9.2.0
 1.66     20230623  G.Tani      9.3.0
 1.67     20230808  G.Tani      9.4.0
 1.68     20231020  G.Tani      9.5.0
 1.69     20231210  G.Tani      9.6.0
 1.70     20240209  G.Tani      9.7.0
 1.71     20240213  G.Tani      9.7.1
 1.72     20240424  G.Tani      9.8.0
 1.73     20240728  G.Tani      9.9.0
 1.74     20240814  G.Tani      9.9.1
 1.75     20241019  G.Tani     10.0.0
 1.76     20241109  G.Tani     10.1.0
 1.77     20241226  G.Tani     10.2.0
 1.78     20250218  G.Tani     10.3.0
 1.79     20250405  G.Tani     10.4.0
 1.80     20250609  G.Tani     10.5.0
 1.81     20250806  G.Tani     10.6.0
 1.82     20250814  G.Tani     10.6.1
 1.83     20251015  G.Tani     10.7.0

BACKEND
Pea 1.27

CODE
Legacy code cleanup
Sources refactored to improve readability and maintainability
 Deleted legacy ansiutf8_utils unit, functions moved to list_utils
 Improved naming of units and items, expanded comments
 Unit peach organized in subsections collecting routines sharing similar scope, and unloaded of various routines better suited into other units
  Self-checking hash values, and various calls to external routines, moved to unit externalprograms
  Various filenames-related routines moved to unit list_utils
  Various helper routines moved to pea_utils
Updated crypto/hash library units to apply pure Pascal implementation of algorithms for any arbitrary non-x86/x86_64 architecture
Various fixes
 Fixed loading compression presets from archive conversion screen
 Fixed displaying CRC and folders content analysis in non-Window systems
 Fixed Qt6 performances selecting of large number of items in the file browser
 Fixed "Explore path (PeaZip)" now correctly reset search filter
 Fixed file browser no longer steal focus when updated, the behavior applied to various Linux/BSD DE

FILE MANAGER
(Linux, macOS) Improved detection and usage of ClamAV
(macOS) Improved Dynamic virtual mode
(macOS) Added Quick Look to "Open with" menu
Can now preview items in Zpaq archives, if "extract to absolute paths" and "extract all revisions" options are unchecked (as by default)
Improved browsing some types of archives (e.g. .pkg)
Improved image viewer functions
 Can now display image thumbnails in the file manager on all platforms (previously supported only on Windows)
  Thumbnails are displayed when navigating the filesystem, not inside archives (no content is ever automatically decompressed, use safer preview function instead), are always generated on the fly (no thumbnail is ever saved/cached by the application to enhance privacy), and are disabled when file manager is in virtual mode
  Thumbnails are displayed automatically when icon size is 48px or larger, can be set on/off manually from main menu > Organize > Show picture thumbnails option
 Added entry to view thumbnails on request, from context menu > File manager, or Ctrl+Space keyboard shortcut (applies same notes as for automatic thumbnails)
 Added new image viewer component to view images on request, from context menu > File manager, or Ctrl+Space keyboard shortcut
  Can zoom in (+ or up arrow) and out (- or down arrow) from 5% to 1000%, fit to screen (0), screen height (Shift+0), screen width (Ctrl+0), jump to 100% to 500% (1..5) and down to 20% (Ctrl+2..Ctrl+5)
  Can toggle immersive mode on/off (double click or enter) if supported by the platform, Esc exits immersive mode or exits the image viewer if not in immersive mode
  Can view previous (back arrow or left active border) and next image (forward arrow or space or right active border) the in same directory or search filter, or jump to first (Home) or last (End)
  Can rename and delete images from disk with all supported deletion routines (move to Trash, quick delete, zero delete, secure delete)
  Can view images when the file manager is in virtual mode, and can preview images inside archives (in this case one preview at time)
  The component is meant primarily as a viewer, most of the file management functions (as copy and move, find duplicates, modify the image) are featured in the file browser and are not duplicated in the viewer
Improved preview of archived files, added option to explore the path of preview with system browser
Improved Functions menu, a more comprehensive selection of core app's functions are now available in the menu, listed alphabetically in order to be easily discovered by users
Improved File tools > Text preview, can now search, count lines, words, chars, change text encoding (ANSI, ASCII, Unicode, UTF-8), and word wrap
Updated Line custom Theme

EXTRACTION and ARCHIVING
Fixed progress window, now reporting correct compression levels for Brotli and Zpaq
Improved handling output if extraction ends in error or is cancelled by the user
 Added option to keep files if extraction is not successful for Zstd backend (in Advanced tab of extraction screen)

INSTALLERS


242 file extensions supported

Translations updated and replaced in the package

--------------------------------------------------------------------------------
Status of Unicode support (since Lazarus 1.6.0)

1 - (cross-platform) Get Unicode paramstrings > natively supported
2 - (cross-platform) Handle Unicode strings and filenames > natively supported
3 - (Windows) Launch processes supporting Unicode > using tprocessutf8 instead
of tprocess works without requiring workarounds used in 5.8/5.9 releases.
(Unix-like) No issues about full Unicode support are known on *x systems.

--------------------------------------------------------------------------------
Zpaq support limitations

1 - Browsing of .zpaq archives is currently possible only in flat mode (f6) due
to PeaZip browser frontend implementation
2 - Partial extraction is not implemented in PeaZip extraction frontend as it is
supported only for absolute paths by design of the format/backend

--------------------------------------------------------------------------------

Export Convert tasks as scripts limitations

Exporting GUI task as script, if Convert archive flag is set, calls PeaZip
binary itself rather than backend binaries.
This is needed because archive conversion, as performed by PeaZip, needs extra
steps which backend binaries are not always able to perform, mainly:
- dynamically create a temporary fresh new work folder in which extraction step
will take place (some binaries will not force creation of non existing dirs)
- remove the intermediate dir, if the archive contains a single directory in the
root, to avoid to add an unwanted extra level of directory nesting in the
resulting archive (this would be complicated and not always possible to automate
relying on backend binaries only)
This solution limits the conversion to either run with current PeaZip's default
options (not requiring interaction, better for batch use), or to prompt the full
GUI to let the user customize the task on the fly (requires interaction).

--------------------------------------------------------------------------------
Performances

FILE/ARCHIVE BROWSER
TListView component in the file browser is dynamically switched to virtual mode
in update_listview to improve performances when displaying thousands of items at
once, in the same directory or search filter.
This threshold, ranging to 4 K to 16 K items, is different for each widgetset
(as performances of TListView varies decisively due to implementation in each
widgetset) and the default value can be changed or turned off (disabling virtual
mode) from Options > Settings, Performances group.
Virtual mode allows to display millions of items at once, but anyway
performances will slow down in the range of tens to hundreds -thousands of
items, depending on system performances and widgetset efficiency, due to factors
like:
 - bottleneck of the slow frontend TListView communicating back to the fast
 backend TStringGrid when needed
 - updating and sorting the increasingly large TStringGrid, even if it is a fast
 component
 - sheer increase of needed RAM even if the TStringGrid is memory efficient
 - listing content in the filesystem is mostly bound to the speed of
 FindFirst/FindNext which vary on different operating systems, and can likely be
 influenced by external factors like background filesystem activity/caching,
 slow disk, slow network units etc.
Please note:
A1) when browsing archives, using f6 flat mode raises warning confirmation
message starting from 64K items (fixed value, number of items is found during
pre-parsing, B1 stage explained below) as the operation may require a large
amount of RAM.
A2a) when browsing the file system, using f6 flat mode always raises warning as
many external factors may impact performances, as slow response, unexpexcted
expansion of links, etc.
A2b) when browsing the filesystem, auto-refresh delay time is incremented
starting from 4K items, and disabled at 16K items (fixed value) as the listing
refresh operation request becomes proportionally slower.
The delay time is also incremented for remote units, if detected.

ARCHIVE PRE-PARSER
PeaZip can pre-parse 7z / p7zip supported formats at opening in order to warn
users in advance of possible issues.
The pre-parse process sums up to:
B1) check if full actual content of the archive can be listed (list -l option),
regardless of what is declared in TOC table (which may be corrupted or have been
maliciously modified), which scales reasonably up to 1.5M files.
B2) scan for non explicitly listed dirs, which scales slowly and is maxed at
1.0M files and 32K directories unless "Always pre-parse" option is set, in
scan_omitted_dirs.
B3) scan for number of files, folders, and uncompressed content size contained
in each folder, which scales slowly and is maxed at 32K items in archive, again
in scan_omitted_dirs.
B4) treeview representation of the structure of archive directories is limited
to 4K dirs, value set by MAXNDIRTREE constant, due to the poor scalability of
the specific code, in populate_archive.

ARCHIVER CONTENT NAVIGATION
PeaZip browse 7z / p7zip supported formats using the more informative -slt
option, which is slower and uses more memory, and it is itself limited in
following steps:
C1) browse / search archives is allowed to scale up to 0.5M files to be
displayed at once on screen unless "Always pre-parse" option is set.
C2) same setting is used to scan archives for encrypted content (if applicable
for current format/operation), and scales as C1.
TOC encryption is detected in prebrowse step, items encryption is detected in
list_slt for current path/filter.

Browser performances setting (Options > Settings, Performances) internally sets
the prebrowse optimization variable which controls the behavior of the
application.
"Always pre-parse" will not stop pre-parsing B1, B2 nor listing C1 regadless the
number of found items, even if performances can be poor for very large archives
"Do not pre-parse" will skip pre-parsing B1 step, and limit all other
time-consuming operations up to small archives (in terms of number of items)
only, as specified in the following tab.
Medium and Large modes limit the operation to a number of items per archive, as
specified in the following table.
Fast mode will pre-parse the archives (up to same limitations of Medium mode)
only if errors are detected while listing the archive.
Regardless the browser mode setting, the pre-parse step is always applied if
errors are detected while opening an encrypted archive.
APPROX means the limitation is an approximate value, bond to the allowed maximum
memory size, EXACT means the limitation is bound to an exact count of the items.

                      list at once     pre-parse   scan for dirs   dir content
          memory      C1, C2 -slt      B1 -l       B2              B3
          APPROX      APPROX           APPROX      EXACT           EXACT
0 Always  unlimited   unlimited        unlimited   unlimited         32K
1 unused
2 Large      192 MB      0.5M              1.5M+   1.0M / 32K dirs   16K
3 Medium      64 MB      160K              0.5M+   256K / 8K dirs     8K
4 Fast        64 MB      160K    if needed/0.5M+   256K / 8K dirs     8K
5 Never       64 MB      160K           no/128K+     8K / 2K dirs     4K

In any case archives that cannot be browsed can still be directly listed, tested
and extracted.

Details
1a - execute_cl reading backend output will start using 32 KB of memory to speed
up tasks not requiring to parse a large amount of output, and will increase in
8 MB steps until hitting memory limitation set by the prebrowse mode.
1b - pre-parsing the full content of the archive at opening will stop as set by
prebrowse variable, and can be omitted with Do not prebrowse (5) setting
1c - searching for encrypted content in archive will stop accordingly to
prebrowse setting (will not be skipped with prebrowse set to 5)
2a - list_slt table used for browsing is allocated up to 0.5 M files and will
then increase (fast) as needed, while list_l table used for pre-parsing is
allocated to the needed size, unless pre-parsing was stopped at 1b
2b - scanning for omitted directories, which scales slowly, will stop
accordingly to prebrowse setting, maxed to 1.0M items or 32K dirs unless always
pre-parse mode is set.

ARCHIVE CREATION, EXTRACTION, TEST, LIST
Performances are mainly bound to the backend binary; interprocess communication
(through pipe) can be optimized in execute_cl, and launch_cl.
Faster operations like list need tighter loops to quickly process the output,
while slower ones need wider loops with sleep times to keep CPU usage low while
expecting output from the backend.

--------------------------------------------------------------------------------

(C) Copyright 2006 Giorgio Tani giorgio.tani.software@gmail.com
Official PeaZip site: see const FIRSTDOM and SECONDDOM in pea_utils unit
The program is released under GNU LGPL https://www.gnu.org/licenses/lgpl.txt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 3 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
}

{$mode objfpc}{$H+}
{$IFDEF DARWIN}
{$modeswitch ObjectiveC1}
{$linkframework CoreFoundation}
{$ENDIF}
interface

uses
{$IFDEF MSWINDOWS}
Windows, activex, ShlObj, ComObj, shellapi, windirs, winutils,
{$ELSE}
{$IFDEF DARWIN}MacOSAll, CocoaAll, {$ENDIF}baseunix, {$ENDIF}
LResources, Forms, Controls, Graphics, Dialogs, EditBtn, StdCtrls, Buttons,
ExtCtrls, ComCtrls, Grids, Menus, Spin, ShellCtrls, Masks, hash, adler32, CRC16,
CRC24, CRC32, CRC64, ED2K, MD4, MD5, RMD160, SHA1, SHA3_256, SHA256, SHA3_512,
SHA512, Whirl512, Blake2s, Blake2b, mem_util, AES_EAX, FCAES256, list_utils,
pea_utils, img_utils, UnitGwrap, unitAdvf, UnitWeb, UnitPW,
UnitKF, UnitInput, UnitDlg, UnitPM, UnitImgRes, UnitImgCrop, UnitImgViewer,
UnitDrop, UnitPaths, UnitSelect, UnitComment, Classes, SysUtils, Process,
UTF8Process, dateutils, fileutil, LazFileUtils, Types, LCLType, ActnList,
strutils, externalprograms;

type

   { TMyThread }

   TMyThreaddrop = class(TThread)
   private
      vpath:ansistring;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThreadimg = class(TThread)
   private
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThreadexe = class(TThread)
   private
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread1 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread2 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread3 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TMyThread4 = class(TThread)
   private
      fi:integer;
      fs,fread:ansistring;
      fbitmap:Tbitmap;
      procedure ReadStatus;
      procedure ShowStatus;
   protected
      procedure Execute; override;
   public
      constructor Create(CreateSuspended: boolean);
   end;

   TClipContent = array of array [0..6] of ansistring;
   Thistarray = array[1..8]of ansistring;

   TShellTreeViewOpener = class(TShellTreeView);

   { TFormPeach }

   TFormPeach = class(TForm)
     cbautobrowsetar: TComboBox;
     cbshowhidden: TCheckBox;
     CheckBoxShowVolatile: TCheckBox;
     CheckBoxZstdErrPolicy: TCheckBox;
     ComboBoxPAQThreads: TComboBox;
     ComboBoxVirtual: TComboBox;
     editExtEvForSec: TEdit;
     EditOptSearch: TComboBox;
     f11fullscreen: TAction;
     f9pwprompt: TAction;
     f8openbook1: TAction;
     f4menu: TAction;
     f3search: TAction;
     f5refresh: TAction;
     f6flat: TAction;
     ActionList1: TActionList;
     babouttos: TSpeedButton;
     baboutfaq: TSpeedButton;
     baboutlocalhelp: TSpeedButton;
     baboutbin: TSpeedButton;
     baboutthemes: TSpeedButton;
     baboutremoveunace: TSpeedButton;
     baboutremoveunrar: TSpeedButton;
     baboutsupport: TSpeedButton;
     baboutchangelog: TSpeedButton;
     babouttranslations: TSpeedButton;
     babouttracker: TSpeedButton;
     baboutup: TSpeedButton;
     baboutplugindir: TSpeedButton;
     baboutplugins: TSpeedButton;
     baboutweb: TSpeedButton;
     Bevel11: TShape;
     Bevel12: TShape;
     Bevel13: TShape;
     Bevel14: TShape;
     Bevel15: TShape;
     Bevel16: TShape;
     Bevel18: TShape;
     Labeladvextzstd: TLabel;
     MenuItemViewImage: TMenuItem;
     MenuItemForceThumbnails: TMenuItem;
     po_open_browser: TMenuItem;
     MenuItemERBrowser: TMenuItem;
     MenuItemPreBrowser: TMenuItem;
     MenuItemCopypathsMenu: TMenuItem;
     pmfun35: TMenuItem;
     pmfun27: TMenuItem;
     pmfun28: TMenuItem;
     pmfun29: TMenuItem;
     pmfun30: TMenuItem;
     pmfun31: TMenuItem;
     pmfun32: TMenuItem;
     pmfun33: TMenuItem;
     pmfun34: TMenuItem;
     pmfun26: TMenuItem;
     pmfun25: TMenuItem;
     ShapeListBar: TShape;
     Bevel21: TShape;
     BevelTitleOpt1: TPanel;
     BevelTitleOpt2: TPanel;
     BevelTitleOpt3: TPanel;
     BevelTitleOpt4: TPanel;
     BevelTitleOpt5: TPanel;
     BevelTitleOpt6: TPanel;
     BevelTitleOpt7: TPanel;
     BevelTitleOpt8: TPanel;
     BevelTitleOptions2: TPanel;
     BevelTitleOptions6: TPanel;
     BevelTitleOptions7: TPanel;
     BevelTitleOptions8: TPanel;
     BSchedule: TBitBtn;
     BScheduleExt: TBitBtn;
     ButtonOptCancel: TBitBtn;
     ButtonOptOK: TBitBtn;
     ButtonEditDesk: TButton;
     ButtonOutAdd: TSpeedButton;
     ButtonOutUpdate: TSpeedButton;
     ButtonEditNameAdd: TButton;
     ButtonCustomExt: TSpeedButton;
     ButtonEditNameOutExtract: TButton;
     ButtonEditNameUpdate: TButton;
     ButtonOpenCustom: TSpeedButton;
     ButtonEditNameCustom: TButton;
     ButtonEditNameCustomExt: TButton;
     Buttonfmactions1: TSpeedButton;
     ButtonRefSize: TButton;
     ButtonOutExtract: TSpeedButton;
     ButtonAddActions: TSpeedButton;
     cbAdvfAdd: TCheckBox;
     cbAdvfExt: TCheckBox;
     cbforcetype: TComboBox;
     cbDeleteInputModeExt: TComboBox;
     cbDeleteInputModeAdd: TComboBox;
     cbEncExtension: TCheckBox;
     cbSmallIconSize: TComboBox;
     cbExtEvForHow: TComboBox;
     cbRAR: TCheckBox;
     cbRARmanual: TCheckBox;
     cbRARBLAKE2: TCheckBox;
     cbRARlastmodtime: TComboBox;
     cbRARlock: TCheckBox;
     cbRARsaveopen: TCheckBox;
     cbRARsavesecurity: TCheckBox;
     cbRARsavestreams: TCheckBox;
     cbRARsfx: TCheckBox;
     cbRARrr: TCheckBox;
     cbRARsolid: TCheckBox;
     cbdefaultaction: TComboBox;
     cbtarpipe: TCheckBox;
     cbuntarpipe: TCheckBox;
     cbBoxAltBarStyle: TComboBox;
     CheckBoxUTC: TCheckBox;
     ComboBoxPEAKDF: TComboBox;
     ComboBoxPEAKDFw: TComboBox;
     csbmusic: TSpeedButton;
     csbpic: TSpeedButton;
     csbvid: TSpeedButton;
     csbdownloads: TSpeedButton;
     csbdoc: TSpeedButton;
     csbhome: TSpeedButton;
     LabelSysBin: TLabel;
     cbtimecreated: TCheckBox;
     cbType: TComboBox;
     cbUn7zaRecursive: TCheckBox;
     cbUn7zaRecursiveExclude: TCheckBox;
     cbzooming: TComboBox;
     CheckBoxExtNotArchives: TCheckBox;
     CheckBoxExtUnsupported: TCheckBox;
     CheckBoxExtUnsupportedPeaZip: TCheckBox;
     cbautoclosesingleextract: TCheckBox;
     cbEncoding: TComboBox;
     cbCustomExtension: TCheckBox;
     cbspacing: TComboBox;
     CheckBox7zunrar5: TCheckBox;
     cbAccentToolBar: TComboBox;
     cbAltBar: TComboBox;
     CheckBoxAltgridcol: TCheckBox;
     cbAltTabStyle: TComboBox;
     cbAltTabs: TComboBox;
     CheckBox7zOF: TCheckBox;
     CheckBoxAutoExtTar: TCheckBox;
     CheckBoxAutoExtTarConvert: TCheckBox;
     cbqdup: TCheckBox;
     CheckBoxAutoTest: TCheckBox;
     CheckBoxAutoOpen: TCheckBox;
     CheckBoxClosePeaZip: TCheckBox;
     CheckBoxEditArchives: TCheckBox;
     CheckBoxEnumd: TCheckBox;
     CheckBoxAC: TCheckBox;
     CheckBoxSmartFolder: TCheckBox;
     CheckBoxForceConvert: TCheckBox;
     CheckBoxExcludeEF: TCheckBox;
     CheckBoxForceLayout: TCheckBox;
     CheckBoxrelative: TCheckBox;
     CheckBoxSkipenc: TCheckBox;
     CheckBoxsnoi: TCheckBox;
     CheckBoxsnh: TCheckBox;
     CheckBoxsnl: TCheckBox;
     CheckBoxsnon: TCheckBox;
     CheckBoxsnzExt: TCheckBox;
     CheckBoxCenteredToolbar: TCheckBox;
     cbSolidAddress: TComboBox;
     CheckBoxssp: TCheckBox;
     CheckBoxstl: TCheckBox;
     CheckBoxzpaqabsolute: TCheckBox;
     CheckBoxzpaqall: TCheckBox;
     CheckBoxzpaqforce: TCheckBox;
     CheckBoxzpaqfull: TCheckBox;
     ComboBoxMaxArg: TComboBox;
     ComboBoxSyntaxLevel: TComboBox;
     ComboBox7zMemuse: TComboBox;
     ComboBoxSysbin: TComboBox;
     ComboBoxTAR: TComboBox;
     ComboBoxTARTS: TComboBox;
     ComboBoxTheme: TComboBox;
     ConsoleAdd: TPanel;
     ConsoleExtract: TPanel;
     csbdesk: TSpeedButton;
     csvsepchar: TLabel;
     CheckBoxSkipDel: TCheckBox;
     ComboBoxLanguage: TComboBox;
     csbroot: TSpeedButton;
     EditAddSame: TEdit;
     Editalias: TEdit;
     EditCSVsep: TEdit;
     EditOutExtractSame: TEdit;
     EditUn7zaFilterExclude: TEdit;
     gbConsoleCreate: TPanel;
     gbConsoleCreateExt: TPanel;
     iConsoleCreateImport: TImage;
     iConsoleCreateImportExt: TImage;
     il_dtheme_16_dark: TImageList;
     il_dtheme_96_dark: TImageList;
     il_dtheme_tool32_dark: TImageList;
     il_nonthemed_dark: TImageList;
     BtnPjSaveAdd: TBitBtn;
     BtnPjLaunchAdd: TBitBtn;
     BtnPjLaunchExt: TBitBtn;
     ImageFlatcrop: TSpeedButton;
     ImageFlattransform: TSpeedButton;
     ImageFlatren: TSpeedButton;
     ImageFlatconvert: TSpeedButton;
     ImageFlatfolder: TSpeedButton;
     ImageFlatdup: TSpeedButton;
     ImageInfoConsole: TImage;
     ImageInfoConsoleExt: TImage;
     ImageBCtext: TImage;
     BtnPjSaveExt: TBitBtn;
     ImOpt1: TImage;
     ImageFlat: TSpeedButton;
     ImageFlatadd: TSpeedButton;
     ImageFlatext: TSpeedButton;
     ImageFlattestmore: TSpeedButton;
     BtnPassword: TSpeedButton;
     ImOpt2: TImage;
     ImOpt3: TImage;
     ImOpt4: TImage;
     ImOpt5: TImage;
     ImOpt6: TImage;
     ImOpt7: TImage;
     ImOpt8: TImage;
     LabelPAQThreads: TLabel;
     LabelComment: TLabel;
     LabelExtHere: TLabel;
     LabelFunctionExtract: TLabel;
     LabelNamingExtract: TLabel;
     LabelContrast: TLabel;
     Labeloamtar: TLabel;
     Labeloambrowser: TLabel;
     Labelogmisc: TLabel;
     Labeloptsubsec: TLabel;
     LabelPEAKDFw: TLabel;
     LabelPEAKDF: TLabel;
     LabelTitleOptions6: TLabel;
     LabelUpdates: TLabel;
     LabelDoc: TLabel;
     LabelAddFolder: TLabel;
     Labeladvextzpaq: TLabel;
     LabelAdvExtZpaqBrZst: TLabel;
     LabelColorTemperature: TLabel;
     LabelTabsStyle: TLabel;
     labelmaxarg: TLabel;
     Labelo1: TLabel;
     Labelo2: TLabel;
     Labelo3: TLabel;
     Labelo4: TLabel;
     Labelo5: TLabel;
     Labelo6: TLabel;
     Labelo7: TLabel;
     Labelo8: TLabel;
     Labeloptsub8: TLabel;
     LabelPMpw: TLabel;
     Labelsmsize: TLabel;
     Labelspac6: TLabel;
     LabelPathUpdate: TLabel;
     LabelUpdateAddress: TLabel;
     Labelsyntaxlevel: TLabel;
     Label7zMemuse: TLabel;
     LabelAddressBar: TLabel;
     LabelActAdd: TLabel;
     LabelSpanAdd: TLabel;
     LabelLevelAdd: TLabel;
     LabelActUpdate: TLabel;
     LabelTypeAdd: TLabel;
     LabelColorToolbar: TLabel;
     LabelColorAddressbar: TLabel;
     LabelColorTabs: TLabel;
     LabelmoreoptExt: TLabel;
     LabelForceLayout: TLabel;
     CheckBoxExtrac32: TCheckBox;
     CheckBoxForceBrowse: TCheckBox;
     CheckBoxExtAnd: TCheckBox;
     ComboBoxKiB: TComboBox;
     ComboBoxPriority: TComboBox;
     Editcommonalgo: TEdit;
     EditCustomExtension: TEdit;
     editExtEvForWhat: TEdit;
     LabelTree: TLabel;
     LabelDefaultAction: TLabel;
     LabelColor2d: TLabel;
     LabelColPresets: TLabel;
     LabelmoreoptAdd: TLabel;
     Labeloafter: TLabel;
     LabelHash: TLabel;
     LabelCommonAlgo: TLabel;
     LabelFileSize: TLabel;
     Labelspac5: TLabel;
     LabelAddFiles: TLabel;
     LabelStatusClip: TLabel;
     LabelStatusAddUpdate: TLabel;
     LabelGoExtract: TLabel;
     Labelalias: TLabel;
     Labeltaropt: TLabel;
     LabeltaroptTS: TLabel;
     LabelTitleOptions1: TLabel;
     LabelTitleOptions2: TLabel;
     LabelTitleOptions3: TLabel;
     LabelTitleOptions4: TLabel;
     LabelTitleOptions5: TLabel;
     LabelTitleOptions7: TLabel;
     LabelTitleOptions8: TLabel;
     Labelspacing: TLabel;
     Labelsetwork: TLabel;
     Labelzooming: TLabel;
     lConsoleCreate_jobcode: TLabel;
     lConsoleCreate_jobcodeExt: TLabel;
     lConsoleCreate_outname: TLabel;
     lConsoleCreate_outnameExt: TLabel;
     LabelPriority: TLabel;
     CheckBoxNoConf: TCheckBox;
     CheckBoxzipxswitch: TCheckBox;
     CheckBoxZstd: TCheckBox;
     CheckBoxConvertPW: TCheckBox;
     CheckBoxDragDrop: TCheckBox;
     CheckBoxEncoding: TCheckBox;
     CheckBoxForceEdit: TCheckBox;
     CheckBoxAutoOpenTar: TCheckBox;
     CheckBoxJobEncoding: TCheckBox;
     CheckBoxForceOpen: TCheckBox;
     LabelPrebrowse: TLabel;
     CheckBoxBrotli: TCheckBox;
     CheckBoxsni: TCheckBox;
     CheckBoxIgnorePaths: TCheckBox;
     CheckBoxsniExt: TCheckBox;
     CheckBoxsns: TCheckBox;
     CheckBoxARCrr: TCheckBox;
     CheckBoxARCsfx: TCheckBox;
     CheckBoxARCabs: TCheckBox;
     CheckBoxMailAdd: TCheckBox;
     CheckBox7zSFX: TCheckBox;
     CheckBoxArchiveHistory: TCheckBox;
     CheckBoxAutoHaltA: TCheckBox;
     CheckBoxAutoHaltE: TCheckBox;
     CheckBoxBrowseNotVerbose: TCheckBox;
     CheckBoxConvert: TCheckBox;
     CheckBoxConvertVerbose: TCheckBox;
     CheckBoxDate: TCheckBox;
     CheckBoxDeleteInputExt: TCheckBox;
     CheckBoxDeleteInputAdd: TCheckBox;
     CheckBoxFolder: TCheckBox;
     CheckBoxIgnoreDisp: TCheckBox;
     CheckBoxIgnoreSel: TCheckBox;
     CheckBoxIntDir: TCheckBox;
     CheckBoxMailKeep: TCheckBox;
     CheckBoxSolidExtension: TCheckBox;
     CheckBoxNameAsParentFolder: TCheckBox;
     CheckBoxnetworkinfo: TCheckBox;
     CheckBoxParallelArchiving: TCheckBox;
     CheckBoxQuadMax: TCheckBox;
     CheckBoxSameArc: TCheckBox;
     CheckBoxSameExt: TCheckBox;
     CheckBoxSeparate: TCheckBox;
     CheckBoxShowHints: TCheckBox;
     CheckBoxsnsExt: TCheckBox;
     CheckBoxTarBefore: TCheckBox;
     CheckBoxUnPeaAttributes: TCheckBox;
     CheckBoxUPXStrip: TCheckBox;
     CheckBoxUPXBackup: TCheckBox;
     CheckBoxWindowStatus: TCheckBox;
     CheckBoxzcopy: TCheckBox;
     cbRAR5: TCheckBox;
     CheckGroupM1: TCheckGroup;
     CheckGroupMExt: TCheckGroup;
     CheckGroupW: TCheckGroup;
     CheckGroupWExt: TCheckGroup;
     ColorButton1: TColorButton;
     ColorButton2: TColorButton;
     ColorButton3: TColorButton;
     ComboBoxConsoleEncoding: TComboBox;
     ComboBoxDrag: TComboBox;
     comboRARdict: TComboBox;
     ComboBoxWD: TComboBox;
     ComboBoxLibre: TComboBox;
     ComboBoxprivacy: TComboBox;
     ComboBox7zalgo: TComboBox;
     ComboBoxARCLevel: TComboBox;
     ComboBoxARCFun: TComboBox;
     ComboBoxARCalgo: TComboBox;
     cbSplit: TComboBox;
     cbAct: TComboBox;
     ComboBoxSplit: TComboBox;
     ComboBox7zMethod: TComboBox;
     ComboBox7zLevel: TComboBox;
     ComboBox7zDictionary: TComboBox;
     ComboBox7zWord: TComboBox;
     ComboBox7zFun: TComboBox;
     ComboBox7zThreads: TComboBox;
     cbLevel: TComboBox;
     ComboBoxArchiveActUpdate: TComboBox;
     ComboBoxArchiveCustom: TComboBox;
     ComboBoxCustomSyntaxExt: TComboBox;
     ComboBox7zPasses: TComboBox;
     ComboBox7zPaths: TComboBox;
     ComboBoxArchivePathsExt: TComboBox;
     ComboBox7zSolid: TComboBox;
     ComboBoxBCMSolid: TComboBox;
     ComboBoxArcSfx: TComboBox;
     ComboBoxArcSolid: TComboBox;
     ComboBoxM2: TComboBox;
     ComboBoxMExt: TComboBox;
     ComboBoxOverwrite: TComboBox;
     ComboBoxOverwriteARC: TComboBox;
     ComboBoxPAQLevel: TComboBox;
     ComboBoxPasses: TComboBox;
     ComboBoxPEAStream: TComboBox;
     ComboBoxPEAObj: TComboBox;
     ComboBoxPEAVol: TComboBox;
     ComboBoxPEALevel: TComboBox;
     ComboBoxSD: TComboBox;
     ComboBoxSplitAlgo: TComboBox;
     ComboBoxUPX: TComboBox;
     ComboBoxBrowser: TComboBox;
     CompressionARC: TPanel;
     CompressionCustom: TPanel;
     CompressionCustomExt: TPanel;
     ctrlext: TSpeedButton;
     ctrlarc: TSpeedButton;
     DateEdit1: TDateEdit;
     DateEdit2: TDateEdit;
     DateEditExt1: TDateEdit;
     DateEditExt2: TDateEdit;
     Edit1: TEdit;
     Edit2: TEdit;
     Edit3: TEdit;
     EditAddFilename: TEdit;
     EditAddName: TEdit;
     EditEncoding: TEdit;
     EditNameUpdate: TEdit;
     EditDesk: TEdit;
     EditExtensionCustom: TEdit;
     EditAddFilepath: TEdit;
     EditNameCustom: TEdit;
     EditNameCustomExt: TEdit;
     Edit7zOpt: TEdit;
     EditOParc: TEdit;
     EditOPcustom: TEdit;
     EditCustomParamExt: TEdit;
     EditOutExtract: TEdit;
     EditSchedulePassword: TEdit;
     EditSchedulePasswordExt: TEdit;
     EditScheduleUser: TEdit;
     EditScheduleUserExt: TEdit;
     EditUn7zaFilter: TEdit;
     EditUn7zaFilterInteractive: TEdit;
     Group7z2: TPanel;
     Group7z1: TPanel;
     PanelExtAdv: TPanel;
     GroupExtract: TPanel;
     PanelAddArchiveOut: TPanel;
     PanelAddUpdateOut: TPanel;
     GroupBoxPEAAdv: TPanel;
     ImageInfoCustomExt: TImage;
     il_dtheme_96: TImageList;
     ImageListDlg: TImageList;
     Imagesp1: TImage;
     ImageInfoBinaries: TImage;
     ImageInfoEncoding: TImage;
     ButtonPasswordUpdate: TSpeedButton;
     Imagesp: TImage;
     Labelcb18: TLabel;
     LabelCustomDesktop: TLabel;
     LabelColor2b: TLabel;
     Labellightpresets: TLabel;
     LabelEncoding: TLabel;
     LabelAdvThemes: TLabel;
     LabelVirtual: TLabel;
     lsetdefaultout_arc: TLabel;
     Labelextevfor: TLabel;
     LabelConfigurearc: TLabel;
     LabelConfigureext: TLabel;
     Labeloamext1: TLabel;
     Labelrr: TLabel;
     labelRARdict: TLabel;
     Labelconsoleencoding: TLabel;
     Labeladvextace: TLabel;
     LabelFormColor: TLabel;
     LabelTextAccentColor: TLabel;
     LabelConfigurePw: TLabel;
     LabelCustomWorkPath: TLabel;
     LabelAppPath: TLabel;
     LabelOpenDesktop: TLabel;
     LabelcbSD: TLabel;
     LabelcbSDcustom: TLabel;
     LabelConf: TLabel;
     LabelOpenConf: TLabel;
     LabelConfigureSendTo: TLabel;
     LabelDefaultColor2: TLabel;
     LabelDefaultColor3: TLabel;
     LabelDefaultOpacity: TLabel;
     LabelInfoGeneral: TLabel;
     Labeloaenc: TLabel;
     Labeloaui: TLabel;
     Labelogpaths: TLabel;
     LabelOpacity: TLabel;
     Labelspac4: TLabel;
     LabelErrors: TLabel;
     LabelOutUpdate: TLabel;
     lsetdefaultout_ext: TLabel;
     eowrun: TMenuItem;
     lightdim: TMenuItem;
     lightlow: TMenuItem;
     lightmocha: TMenuItem;
     lightsenape: TMenuItem;
     lightgraphite: TMenuItem;
     lightplum: TMenuItem;
     mConsoleCreate: TMemo;
     mConsoleCreateExt: TMemo;
     mdefarcset: TMenuItem;
     MemoList: TMemo;
     maltbk: TMenuItem;
     maltfw: TMenuItem;
     aabc1: TMenuItem;
     aabc2: TMenuItem;
     aabc3: TMenuItem;
     aabc4: TMenuItem;
     aabc5: TMenuItem;
     aabc6: TMenuItem;
     aabc7: TMenuItem;
     aabc8: TMenuItem;
     apmbcexpand: TMenuItem;
     mdownloadthemes: TMenuItem;
     mdirbeforefiles: TMenuItem;
     mdefaultextract: TMenuItem;
     mdefaultarchive: TMenuItem;
     mbtext: TMenuItem;
     mbkde: TMenuItem;
     mbgnome: TMenuItem;
     mbgnome4: TMenuItem;
     mbmac: TMenuItem;
     mccomment: TMenuItem;
     mbrowserccomment: TMenuItem;
     mcomment: TMenuItem;
     po_functionsdummy: TMenuItem;
     layoutmotw: TMenuItem;
     layoutmotwfull: TMenuItem;
     MenuItem23: TMenuItem;
     MenuItem28: TMenuItem;
     MenuItem58: TMenuItem;
     MenuItem87: TMenuItem;
     MenuItemArchive_documents1: TMenuItem;
     MenuItemArchive_downloads: TMenuItem;
     MenuItemArchive_dropbox: TMenuItem;
     MenuItemArchive_googledrive: TMenuItem;
     MenuItemArchive_home1: TMenuItem;
     MenuItemArchive_music: TMenuItem;
     MenuItemArchive_myboxfiles: TMenuItem;
     MenuItemArchive_onedrive: TMenuItem;
     MenuItemArchive_pc: TMenuItem;
     MenuItemArchive_pictures: TMenuItem;
     MenuItemArchive_pubdoc: TMenuItem;
     MenuItemArchive_pubhome: TMenuItem;
     MenuItemArchive_skydrive: TMenuItem;
     MenuItemArchive_ubuntuone: TMenuItem;
     MenuItemArchive_videos: TMenuItem;
     mpathdesk1: TMenuItem;
     mpathexplore1: TMenuItem;
     mpathreset1: TMenuItem;
     mpathself1: TMenuItem;
     mshowhidden: TMenuItem;
     MenuItemToolsj: TMenuItem;
     pajdn1: TMenuItem;
     pajdn10: TMenuItem;
     pajdn11: TMenuItem;
     pajdn12: TMenuItem;
     pajdn13: TMenuItem;
     pajdn14: TMenuItem;
     pajdn15: TMenuItem;
     pajdn16: TMenuItem;
     pajdn17: TMenuItem;
     pajdn18: TMenuItem;
     pajdn19: TMenuItem;
     pajdn2: TMenuItem;
     pajdn20: TMenuItem;
     pajdn21: TMenuItem;
     pajdn22: TMenuItem;
     pajdn23: TMenuItem;
     pajdn24: TMenuItem;
     pajdn25: TMenuItem;
     pajdn26: TMenuItem;
     pajdn3: TMenuItem;
     pajdn4: TMenuItem;
     pajdn5: TMenuItem;
     pajdn6: TMenuItem;
     pajdn7: TMenuItem;
     pajdn8: TMenuItem;
     pajdn9: TMenuItem;
     pnabc0: TMenuItem;
     pnabc1: TMenuItem;
     pnabc2: TMenuItem;
     pnabc3: TMenuItem;
     pnabc4: TMenuItem;
     pnabc5: TMenuItem;
     pnabc6: TMenuItem;
     pnabc7: TMenuItem;
     pnabc8: TMenuItem;
     pnba1: TMenuItem;
     pnba10: TMenuItem;
     pnba11: TMenuItem;
     pnba12: TMenuItem;
     pnba13: TMenuItem;
     pnba14: TMenuItem;
     pnba15: TMenuItem;
     pnba16: TMenuItem;
     pnba17: TMenuItem;
     pnba18: TMenuItem;
     pnba19: TMenuItem;
     pnba2: TMenuItem;
     pnba20: TMenuItem;
     pnba21: TMenuItem;
     pnba22: TMenuItem;
     pnba23: TMenuItem;
     pnba3: TMenuItem;
     pnba4: TMenuItem;
     pnba5: TMenuItem;
     pnba6: TMenuItem;
     pnba7: TMenuItem;
     pnba8: TMenuItem;
     pnba9: TMenuItem;
     pnha0s: TMenuItem;
     pnha1: TMenuItem;
     pnha2: TMenuItem;
     pnha3: TMenuItem;
     pnha4: TMenuItem;
     pnha5: TMenuItem;
     pnha6: TMenuItem;
     pnha7: TMenuItem;
     pnha8: TMenuItem;
     pnra0: TMenuItem;
     pnra1: TMenuItem;
     pnra2: TMenuItem;
     pnra3: TMenuItem;
     pnra4: TMenuItem;
     pnra5: TMenuItem;
     pnra6: TMenuItem;
     pnra7: TMenuItem;
     pnra8: TMenuItem;
     PopupPathArchive: TPopupMenu;
     po_s256j: TMenuItem;
     pmmoreshaj: TMenuItem;
     po_lingdisks: TMenuItem;
     po_linglogs: TMenuItem;
     po_linlshw: TMenuItem;
     po_motwfull: TMenuItem;
     OpenDialogCustom: TOpenDialog;
     pmmoremotw: TMenuItem;
     po_checkmotw: TMenuItem;
     po_ntfszi: TMenuItem;
     po_ntfsads: TMenuItem;
     pmnavbooks: TPopupMenu;
     po_functionsaz: TMenuItem;
     pmfun24: TMenuItem;
     pmfun19: TMenuItem;
     pmfun20: TMenuItem;
     pmfun21: TMenuItem;
     pmfun22: TMenuItem;
     pmfun23: TMenuItem;
     pmspold: TMenuItem;
     mz175: TMenuItem;
     pmspminimal: TMenuItem;
     pmsppostmodern: TMenuItem;
     pmspmodern: TMenuItem;
     pmstylepresets: TMenuItem;
     pmspclassic: TMenuItem;
     MenuItemOpen_saveascsvl: TMenuItem;
     MenuItemOpen_saveastsv: TMenuItem;
     MenuItemOpen_saveas: TMenuItem;
     pmsaveascsvl: TMenuItem;
     pmsaveas: TMenuItem;
     pmsaveastsv: TMenuItem;
     po_savecopy: TMenuItem;
     munsavecopy: TMenuItem;
     mhextractto: TMenuItem;
     pmscompact: TMenuItem;
     MenuItemToolCrc32: TMenuItem;
     MenuItemToolMD5: TMenuItem;
     MenuItemToolSHA1: TMenuItem;
     MenuItemToolSHA256: TMenuItem;
     MenuItemToolBlake2s: TMenuItem;
     MenuItemToolsg: TMenuItem;
     MenuItemToolsv: TMenuItem;
     ComboBoxsec: TComboBox;
     Separator45: TMenuItem;
     MenuItemTooltextp: TMenuItem;
     MenuItemToolAnalyze: TMenuItem;
     Separator44: TMenuItem;
     Separator43: TMenuItem;
     Separator42: TMenuItem;
     Separator41: TMenuItem;
     Separator40: TMenuItem;
     Separator39: TMenuItem;
     po_cksum: TMenuItem;
     po_md5sum: TMenuItem;
     po_sha1sum: TMenuItem;
     po_sha256sum: TMenuItem;
     po_b2sum: TMenuItem;
     po_s256g: TMenuItem;
     po_s256v: TMenuItem;
     po_textp: TMenuItem;
     pmmoretext: TMenuItem;
     pmsizelargepppp: TMenuItem;
     pmmoresha1save: TMenuItem;
     pmmoremd5save: TMenuItem;
     pmmorecksave: TMenuItem;
     pmmoreblake2bsave: TMenuItem;
     pmmoreshag: TMenuItem;
     pmmoreshav: TMenuItem;
     pmmoreshasave: TMenuItem;
     pmsizelargeppp: TMenuItem;
     mexploretrash: TMenuItem;
     Separator37: TMenuItem;
     pow10defender: TMenuItem;
     pow10storage: TMenuItem;
     pow10dapps: TMenuItem;
     pow10apps: TMenuItem;
     pow10settings: TMenuItem;
     pow10: TMenuItem;
     mfilebrowser: TMenuItem;
     pmsizelargep: TMenuItem;
     pmsizelargepp: TMenuItem;
     msizetoggle: TMenuItem;
     pmsizesmall: TMenuItem;
     pmsizemedium: TMenuItem;
     pmsizelarge: TMenuItem;
     Separator36: TMenuItem;
     mz50: TMenuItem;
     mz67: TMenuItem;
     mz80: TMenuItem;
     mz87: TMenuItem;
     mz100: TMenuItem;
     mz115: TMenuItem;
     mz125: TMenuItem;
     mz150: TMenuItem;
     mz200: TMenuItem;
     mzoom: TMenuItem;
     Separator35: TMenuItem;
     po_gnometm: TMenuItem;
     po_kdetm: TMenuItem;
     Separator34: TMenuItem;
     pmextheresmart: TMenuItem;
     pmextherenew: TMenuItem;
     pmextherehere: TMenuItem;
     pmintddhere: TMenuItem;
     pmintddsmart: TMenuItem;
     pmintddnew: TMenuItem;
     mroot: TMenuItem;
     pmscomment: TMenuItem;
     pmsinfo: TMenuItem;
     pmintdd: TPopupMenu;
     pmexthere: TPopupMenu;
     Separator33: TMenuItem;
     pmflatarchives: TMenuItem;
     Separator32: TMenuItem;
     mFlatArchives: TMenuItem;
     mexttohistory: TMenuItem;
     mexttoc8: TMenuItem;
     mexttoc7: TMenuItem;
     mexttoc6: TMenuItem;
     mexttoc5: TMenuItem;
     mexttoc4: TMenuItem;
     mexttoc3: TMenuItem;
     mexttoc2: TMenuItem;
     mexttoc1: TMenuItem;
     mexttoc0: TMenuItem;
     Separator29: TMenuItem;
     mexttos8: TMenuItem;
     mexttos7: TMenuItem;
     mexttos6: TMenuItem;
     mexttos5: TMenuItem;
     mexttos4: TMenuItem;
     mexttos3: TMenuItem;
     mexttos2: TMenuItem;
     mexttos1: TMenuItem;
     mexttos0: TMenuItem;
     Separator28: TMenuItem;
     mexttoh2: TMenuItem;
     mexttoh3: TMenuItem;
     mexttoh4: TMenuItem;
     mexttoh5: TMenuItem;
     mexttoh6: TMenuItem;
     mexttoh7: TMenuItem;
     mexttoh8: TMenuItem;
     mexttoh1: TMenuItem;
     mexttob2: TMenuItem;
     mexttob3: TMenuItem;
     mexttob4: TMenuItem;
     mexttob5: TMenuItem;
     mexttob6: TMenuItem;
     mexttob7: TMenuItem;
     mexttob8: TMenuItem;
     mextto: TMenuItem;
     mexttob1: TMenuItem;
     Separator30: TMenuItem;
     Separator31: TMenuItem;
     Separator38: TMenuItem;
     Separator46: TMenuItem;
     SeparatorDE: TMenuItem;
     msmartsort: TMenuItem;
     pmsoparch: TMenuItem;
     pmsoppath: TMenuItem;
     mshowsidebar: TMenuItem;
     msidebar: TMenuItem;
     Separator27: TMenuItem;
     mloadprofile: TMenuItem;
     msaveprofile: TMenuItem;
     OpenDialogProfile: TOpenDialog;
     Panelside: TPanel;
     Separator26: TMenuItem;
     pmtabsreopen: TMenuItem;
     ShapeOptions1: TShape;
     Shapecsb: TShape;
     Shapelinkadd2: TShape;
     Shapelinkadd3: TShape;
     Shapelinkadd4: TShape;
     Shapelinkapps1: TShape;
     Shapelinkapps2: TShape;
     Shapelinkextract1: TShape;
     Shapelinkextract2: TShape;
     Shapelinkextract3: TShape;
     Shapelinkextract4: TShape;
     Shapelinkadd1: TShape;
     ShapeOptions2: TShape;
     ShapeOptions3: TShape;
     ShapeOptions4: TShape;
     ShapeOptions5: TShape;
     ShapeOptions6: TShape;
     ShapeOptions7: TShape;
     ShapeOptions8: TShape;
     smBookmarksa1: TMenuItem;
     smfsa1: TMenuItem;
     smHistorya1: TMenuItem;
     StringGridTabsLast: TStringGrid;
     Timerrename1: TTimer;
     zencmore: TMenuItem;
     zenc1254: TMenuItem;
     zenc1255: TMenuItem;
     zenc1256: TMenuItem;
     zenc1257: TMenuItem;
     zenc1258: TMenuItem;
     zenc20866: TMenuItem;
     zenc21866: TMenuItem;
     zenclocalutf8: TMenuItem;
     zencutf8: TMenuItem;
     zenclocal: TMenuItem;
     zenc1252: TMenuItem;
     zenc65001: TMenuItem;
     zenc437: TMenuItem;
     zenc850: TMenuItem;
     zenc852: TMenuItem;
     zenc858: TMenuItem;
     zenc866: TMenuItem;
     zenc874: TMenuItem;
     zenc932: TMenuItem;
     zenc936: TMenuItem;
     zenc949: TMenuItem;
     zenc950: TMenuItem;
     zenc1250: TMenuItem;
     zenc1251: TMenuItem;
     zenc1253: TMenuItem;
     mzencmore: TMenuItem;
     mzenc1254: TMenuItem;
     mzenc1255: TMenuItem;
     mzenc1256: TMenuItem;
     mzenc1257: TMenuItem;
     mzenc1258: TMenuItem;
     mzenc20866: TMenuItem;
     mzenc21866: TMenuItem;
     mzenclocalutf8: TMenuItem;
     mzencutf8: TMenuItem;
     mzenclocal: TMenuItem;
     mzenc1252: TMenuItem;
     mzenc65001: TMenuItem;
     mzenc437: TMenuItem;
     mzenc850: TMenuItem;
     mzenc852: TMenuItem;
     mzenc858: TMenuItem;
     mzenc866: TMenuItem;
     mzenc874: TMenuItem;
     mzenc932: TMenuItem;
     mzenc936: TMenuItem;
     mzenc949: TMenuItem;
     mzenc950: TMenuItem;
     mzenc1250: TMenuItem;
     mzenc1251: TMenuItem;
     mzenc1253: TMenuItem;
     azencmore: TMenuItem;
     azenc1254: TMenuItem;
     azenc1255: TMenuItem;
     azenc1256: TMenuItem;
     azenc1257: TMenuItem;
     azenc1258: TMenuItem;
     azenc20866: TMenuItem;
     azenc21866: TMenuItem;
     azenclocalutf8: TMenuItem;
     azencutf8: TMenuItem;
     azenclocal: TMenuItem;
     azenc1252: TMenuItem;
     azenc65001: TMenuItem;
     azenc437: TMenuItem;
     azenc850: TMenuItem;
     azenc852: TMenuItem;
     azenc858: TMenuItem;
     azenc866: TMenuItem;
     azenc874: TMenuItem;
     azenc932: TMenuItem;
     azenc936: TMenuItem;
     azenc949: TMenuItem;
     azenc950: TMenuItem;
     azenc1250: TMenuItem;
     azenc1251: TMenuItem;
     azenc1253: TMenuItem;
     pmtabsave: TMenuItem;
     pmadvf: TMenuItem;
     po_commentzip: TMenuItem;
     pmmorecommentzip: TMenuItem;
     po_browserccomment: TMenuItem;
     pmccomment: TMenuItem;
     mpeachangelog: TMenuItem;
     mpeatos: TMenuItem;
     pmmoreextract: TMenuItem;
     pmmoreconvert: TMenuItem;
     pmmoreadd: TMenuItem;
     pmtoolcompact: TMenuItem;
     mtranslationsfaq: TMenuItem;
     mswaptab: TMenuItem;
     PanelAdArchive4: TPanel;
     pmbcnw: TMenuItem;
     pmtabscloseall: TMenuItem;
     pmtabsnewwindow: TMenuItem;
     pmclip: TMenuItem;
     po_clip: TMenuItem;
     po_dedup: TMenuItem;
     po_windowopen: TMenuItem;
     MenuItemShowColMenu: TMenuItem;
     Panela: TPanel;
     Panele: TPanel;
     PanelExtZPAQ: TPanel;
     pmshowstylemenu: TMenuItem;
     PanelSPaddress: TPanel;
     pmmoretest: TMenuItem;
     MenuItemToggleNav: TMenuItem;
     pmfilebrowser: TMenuItem;
     Separator24: TMenuItem;
     Separator17: TMenuItem;
     pnbce1: TMenuItem;
     pnbce2: TMenuItem;
     pnbce3: TMenuItem;
     pnbce4: TMenuItem;
     pnbce5: TMenuItem;
     pnbce6: TMenuItem;
     pnbce7: TMenuItem;
     pnbce8: TMenuItem;
     pnhe1: TMenuItem;
     pnhe2: TMenuItem;
     pnhe3: TMenuItem;
     pnhe4: TMenuItem;
     pnhe5: TMenuItem;
     pnhe6: TMenuItem;
     pnhe7: TMenuItem;
     pnhe8: TMenuItem;
     pnbce0: TMenuItem;
     Separator23: TMenuItem;
     pnbcf1: TMenuItem;
     pnbcf2: TMenuItem;
     pnbcf3: TMenuItem;
     pnbcf4: TMenuItem;
     pnbcf5: TMenuItem;
     pnbcf6: TMenuItem;
     pnbcf7: TMenuItem;
     pnbcf8: TMenuItem;
     pnbcf0: TMenuItem;
     Separator22: TMenuItem;
     Separator21: TMenuItem;
     pnhe0: TMenuItem;
     pnhf1: TMenuItem;
     pnhf2: TMenuItem;
     pnhf3: TMenuItem;
     pnhf4: TMenuItem;
     pnhf5: TMenuItem;
     pnhf6: TMenuItem;
     pnhf7: TMenuItem;
     pnhf8: TMenuItem;
     pnhf0: TMenuItem;
     Separator20: TMenuItem;
     pmmain: TPopupMenu;
     Separator19: TMenuItem;
     Separator18: TMenuItem;
     po_addsep: TMenuItem;
     Separator25: TMenuItem;
     ShapeAddress1: TShape;
     ShapeAddress10: TShape;
     ShapeAddress11: TShape;
     ShapeAddress0: TShape;
     ShapeAddress2: TShape;
     ShapeAddress3: TShape;
     ShapeAddress4: TShape;
     ShapeAddress5: TShape;
     ShapeAddress6: TShape;
     ShapeAddress7: TShape;
     ShapeAddress8: TShape;
     ShapeAddress9: TShape;
     ShapeThemes: TShape;
     PanelProgress: TPanel;
     ShapeThemes1: TShape;
     ShapeThemes2: TShape;
     StringGridTB: TStringGrid;
     tabaddress: TMenuItem;
     pmquickdownloads: TMenuItem;
     Separator16: TMenuItem;
     Separator12: TMenuItem;
     mtoggletool: TMenuItem;
     mhbook: TMenuItem;
     mhhist: TMenuItem;
     mhaltup: TMenuItem;
     mhpwf9: TMenuItem;
     mhsearchf3: TMenuItem;
     mhmenunavf4: TMenuItem;
     mhrenamef2: TMenuItem;
     mhiddennav: TMenuItem;
     Separator15: TMenuItem;
     pmsstatus: TMenuItem;
     pmsno: TMenuItem;
     menupw: TMenuItem;
     MenuItemInfomenu: TMenuItem;
     MenuItemInfo: TMenuItem;
     MenuItemToggleStatus: TMenuItem;
     Separator14: TMenuItem;
     Separator13: TMenuItem;
     pmtoollarge: TMenuItem;
     pmtoolmedium: TMenuItem;
     MenuItemTB: TMenuItem;
     PanelTitleAppsTabAlign: TPanel;
     Separator10: TMenuItem;
     mshowstatusbar: TMenuItem;
     mshownavbar: TMenuItem;
     mshowtoolbar: TMenuItem;
     pmstatusnone: TMenuItem;
     pmtoolnone: TMenuItem;
     msettings: TMenuItem;
     pmsbookmarks: TMenuItem;
     pmshistory: TMenuItem;
     pmssession: TMenuItem;
     pmsclipboard: TMenuItem;
     pmshowmenu: TMenuItem;
     pmstatus: TPopupMenu;
     Separator11: TMenuItem;
     pmtoolsmall: TMenuItem;
     PanelTitleExtractTabAlign: TPanel;
     PanelTitleAddTabAlign: TPanel;
     Separator9: TMenuItem;
     po_showquicknavmenu: TMenuItem;
     Separator8: TMenuItem;
     pmshowmainmenu: TMenuItem;
     Separator7: TMenuItem;
     mverifyself: TMenuItem;
     pmshowsearch: TMenuItem;
     PopupLightPresets: TPopupMenu;
     Separator6: TMenuItem;
     pmhnewtab: TMenuItem;
     MenuItemOpen_saveascsv: TMenuItem;
     pmsaveascsv: TMenuItem;
     MenuItemContextRefresh: TMenuItem;
     Separator5: TMenuItem;
     BtnStyle: TSpeedButton;
     Separator4: TMenuItem;
     mprofileimmediate: TMenuItem;
     pmnavbc0: TMenuItem;
     pmnavbc1: TMenuItem;
     pmnavbc2: TMenuItem;
     pmnavbc3: TMenuItem;
     pmnavbc4: TMenuItem;
     pmnavbc5: TMenuItem;
     pmnavbc6: TMenuItem;
     pmnavbc7: TMenuItem;
     pmnavbc8: TMenuItem;
     pmr_files: TMenuItem;
     pmnavhistory: TPopupMenu;
     pmnavbreadcrumb: TPopupMenu;
     Separator2: TMenuItem;
     pmr_ren: TMenuItem;
     Separator3: TMenuItem;
     powRun: TMenuItem;
     pmapp8: TMenuItem;
     MenuItem102: TMenuItem;
     pmapp9: TMenuItem;
     MenuItem111: TMenuItem;
     MenuItem114: TMenuItem;
     MenuItem115: TMenuItem;
     MenuItem116: TMenuItem;
     MenuItem117: TMenuItem;
     MenuItem119: TMenuItem;
     MenuItem120: TMenuItem;
     MenuItem121: TMenuItem;
     marcopt: TMenuItem;
     mdefextset: TMenuItem;
     MenuItem124: TMenuItem;
     MenuItem128: TMenuItem;
     MenuItem129: TMenuItem;
     mcmethod: TMenuItem;
     mcaccessed: TMenuItem;
     mccreated: TMenuItem;
     MenuItem130: TMenuItem;
     mbrowsercaccessed: TMenuItem;
     mbrowsercmethod: TMenuItem;
     mbrowserccreated: TMenuItem;
     mautoadjust: TMenuItem;
     mBenchpea: TMenuItem;
     pmapp10: TMenuItem;
     pmapp11: TMenuItem;
     pmapp12: TMenuItem;
     pmapp13: TMenuItem;
     pmapp14: TMenuItem;
     pmapp15: TMenuItem;
     pmapp16: TMenuItem;
     pmappadv1: TMenuItem;
     pmappadv2: TMenuItem;
     pmappadv3: TMenuItem;
     pmappadv4: TMenuItem;
     pmappadv5: TMenuItem;
     pmappadv6: TMenuItem;
     pmappadv7: TMenuItem;
     pmappadv8: TMenuItem;
     pmapp1: TMenuItem;
     pmapp2: TMenuItem;
     pmapp3: TMenuItem;
     pmapp4: TMenuItem;
     pmapp5: TMenuItem;
     pmapp6: TMenuItem;
     pmapp7: TMenuItem;
     pmapp: TMenuItem;
     pmapprun: TMenuItem;
     owrun: TMenuItem;
     msamplescripts: TMenuItem;
     mloadlayout: TMenuItem;
     mfilterbrowser: TMenuItem;
     msavelayout: TMenuItem;
     Separator1: TMenuItem;
     menuitemopendocuments: TMenuItem;
     menuitemopendownloads: TMenuItem;
     po_maclaunch: TMenuItem;
     po_macdisk: TMenuItem;
     po_macact: TMenuItem;
     po_macsys: TMenuItem;
     po_browsercaccessed: TMenuItem;
     po_browsercmethod: TMenuItem;
     po_browserccreated: TMenuItem;
     MenuItemColMint: TMenuItem;
     MenuItemColUbuntu: TMenuItem;
     MenuItemColBeos: TMenuItem;
     MenuItemColWindows: TMenuItem;
     PopupColPresets: TPopupMenu;
     po_gnomesw: TMenuItem;
     po_cinnamonsett: TMenuItem;
     po_synaptic: TMenuItem;
     po_xfcesm: TMenuItem;
     po_kdesyssett: TMenuItem;
     MenuItem131: TMenuItem;
     po_gnomecc: TMenuItem;
     po_lintop: TMenuItem;
     po_linpsef: TMenuItem;
     po_linnetstat: TMenuItem;
     po_linipaddress: TMenuItem;
     po_linid: TMenuItem;
     po_linhistory: TMenuItem;
     po_lindush: TMenuItem;
     po_lindfh: TMenuItem;
     MenuItem8: TMenuItem;
     po_openunitasarchivelin: TMenuItem;
     po_dispenvstrlin: TMenuItem;
     po_linsystemtools: TMenuItem;
     MenuItemOpen_run: TMenuItem;
     po_openfiles: TMenuItem;
     pmcmethod: TMenuItem;
     pmcaccessed: TMenuItem;
     pmccreated: TMenuItem;
     po_whoami: TMenuItem;
     po_ver: TMenuItem;
     po_systeminfo: TMenuItem;
     po_ftp: TMenuItem;
     po_qwinsta: TMenuItem;
     po_quser: TMenuItem;
     po_hostname: TMenuItem;
     po_ipconfig: TMenuItem;
     po_getmac: TMenuItem;
     po_sysinfo: TMenuItem;
     pmqeselected: TMenuItem;
     pmqedisplayed: TMenuItem;
     pmqeall: TMenuItem;
     mtab: TMenuItem;
     pmtestcontext: TPopupMenu;
     pmtestcontextall: TMenuItem;
     pmtestcontextdisplayed: TMenuItem;
     pmtestcontextselected: TMenuItem;
     pmthemes: TMenuItem;
     MenuItem83: TMenuItem;
     pmrow: TMenuItem;
     MenuItem127: TMenuItem;
     pmtab: TMenuItem;
     MenuItem126: TMenuItem;
     pmsnav: TMenuItem;
     pmstree: TMenuItem;
     pmsnone: TMenuItem;
     pmtool1: TMenuItem;
     pmtool2: TMenuItem;
     pmtool3: TMenuItem;
     pcustmakecab: TMenuItem;
     pcustmakecabsep: TMenuItem;
     mtenc: TMenuItem;
     MenuItem123: TMenuItem;
     pmtextenc: TMenuItem;
     MenuItemTextEncoding: TMenuItem;
     pmr_cut: TMenuItem;
     pmr_appendts: TMenuItem;
     pmr_appenddirname: TMenuItem;
     pmr_prependdirname: TMenuItem;
     pmr_123: TMenuItem;
     pmr_ascii: TMenuItem;
     po_rename_ascii: TMenuItem;
     po_rename_cutlen: TMenuItem;
     mextopt: TMenuItem;
     PanelLCA1: TShape;
     PanelLCA2: TShape;
     PanelLCA3: TShape;
     PanelLCA4: TShape;
     PanelLCA5: TShape;
     PanelLCA6: TShape;
     PanelLCA7: TShape;
     PanelLCA8: TShape;
     PanelLCAa1: TShape;
     PanelLCAa2: TShape;
     PanelLCAa3: TShape;
     PanelLCAa4: TShape;
     PanelTabBar: TPanel;
     po_rr: TMenuItem;
     po_recover: TMenuItem;
     pmmorerecover: TMenuItem;
     pmmorerr: TMenuItem;
     mprofilerar: TMenuItem;
     PanelRar: TPanel;
     pob_blake2b: TMenuItem;
     pob_blake2s: TMenuItem;
     mprofile7zfast: TMenuItem;
     mprofile7zfastest: TMenuItem;
     PanelBrotli: TPanel;
     PanelZstd: TPanel;
     po_smart: TMenuItem;
     mprofiletarxz: TMenuItem;
     mprofilesave: TMenuItem;
     mprofileload: TMenuItem;
     mprofilezstd: TMenuItem;
     mprofiletargz: TMenuItem;
     mprofileextremezpaq: TMenuItem;
     mloadcompsettings: TMenuItem;
     msavecompsettings: TMenuItem;
     mForceSynceditsClear: TMenuItem;
     mForceClear: TMenuItem;
     mextallheresmart: TMenuItem;
     mextallherenew: TMenuItem;
     MenuItemExtAllHereSmart: TMenuItem;
     MenuItemExtAllHereNew: TMenuItem;
     pmqeheresmart: TMenuItem;
     pmqeherenew: TMenuItem;
     po_rename_filesonly: TMenuItem;
     mprofiletarzst: TMenuItem;
     po_rename_123: TMenuItem;
     pmpanalyzefolders: TMenuItem;
     po_analyzefolders: TMenuItem;
     mForceSyncedits: TMenuItem;
     Panel10: TPanel;
     pms2a_ext: TMenuItem;
     MenuItem118: TMenuItem;
     po_rename_separator: TMenuItem;
     po_more: TMenuItem;
     po_pdup: TMenuItem;
     PageOpt2: TScrollBox;
     PanelLine1: TPanel;
     PanelLine2: TPanel;
     PanelLine4: TPanel;
     PanelLine3: TPanel;
     PanelLine5: TPanel;
     PanelLine6: TPanel;
     PanelLine7: TPanel;
     PanelLine8: TPanel;
     pmhcopypath: TMenuItem;
     pmsaveastxt: TMenuItem;
     MenuItem71: TMenuItem;
     pmcname: TMenuItem;
     pmctype: TMenuItem;
     pmcsize: TMenuItem;
     pmcpacked: TMenuItem;
     pmcdate: TMenuItem;
     pmcatt: TMenuItem;
     pmccrc: TMenuItem;
     pmcfree: TMenuItem;
     pmcfs: TMenuItem;
     MenuItem145: TMenuItem;
     pmstyle1: TMenuItem;
     pmstyle3: TMenuItem;
     pmstyle5: TMenuItem;
     pmtabsm: TMenuItem;
     pmhtabs: TMenuItem;
     pmtabsbook: TMenuItem;
     pmstyle: TPopupMenu;
     PopupHeader: TPopupMenu;
     po_tabsopen: TMenuItem;
     pmtabsbookmarkorg: TMenuItem;
     pmtabsbookmarkadd: TMenuItem;
     mtabs: TMenuItem;
     pmtabscloseright: TMenuItem;
     pmtabscollapse: TMenuItem;
     pmtabsexpand: TMenuItem;
     MenuItem64: TMenuItem;
     MenuItem72: TMenuItem;
     pmtabscloseother: TMenuItem;
     ProgressBar2: TShape;
     cbExtEvForWhen: TComboBox;
     cbtree: TComboBox;
     cbHash: TComboBox;
     cbBinaries: TComboBox;
     cbBinariesStop: TComboBox;
     CheckBoxExtActionAdv: TComboBox;
     ShapeTitleAddb1: TShape;
     ShapeTitleAddb2: TShape;
     ShapeTitleAddb3: TShape;
     ShapeTitleAddb4: TShape;
     ShapeTitleAppsb1: TShape;
     ShapeTitleAppsb2: TShape;
     ShapeTitleExtractb1: TShape;
     ShapeTitleExtractb2: TShape;
     ShapeTitleExtractb3: TShape;
     ShapeTitleExtractb4: TShape;
     SpinEditOpacity: TSpinEdit;
     seRARrr: TSpinEdit;
     splitsearch: TSplitter;
     StringGridAddressAllFoldersContent: TStringGrid;
     StringGridArchive: TStringGrid;
     StringGridTabs: TStringGrid;
     Subtitleschopt: TLabel;
     SubtitleschoptExt: TLabel;
     ImageAdArchive3: TImage;
     ImageAddress0: TImage;
     ImageAddress1: TImage;
     ImageAddress2: TImage;
     ImageAddress3: TImage;
     ImageAddress4: TImage;
     ImageAddress5: TImage;
     ImageAddress6: TImage;
     ImageAddress7: TImage;
     ImageAdArchive0: TImage;
     ImageAdArchive1: TImage;
     ImageAdArchive2: TImage;
     ButtonOptReset: TBitBtn;
     ImageInfoSchedAdd: TImage;
     ImageInfoSchedExt: TImage;
     ImageListResetSearch: TImage;
     Imageopenadvf: TImage;
     ImageExtractAdvf: TImage;
     ImageAddAdvf: TImage;
     BtnPasswordArchive: TSpeedButton;
     BtnPasswordExtract: TSpeedButton;
     ImageSplit: TImage;
     LabelOutExtract: TLabel;
     LabelARCEnc: TLabel;
     Label7zEnc: TLabel;
     Label7zPath: TLabel;
     Labeladvext7z: TLabel;
     Labeladvextfreearc: TLabel;
     LabelArcSub3: TLabel;
     Labelogperf: TLabel;
     LabelWD: TLabel;
     Label7zFun: TLabel;
     LabelPEALevel: TLabel;
     LabelARCLevel: TLabel;
     LabelARCFun: TLabel;
     Label7zThreads: TLabel;
     Label7zLevel: TLabel;
     Label7zMethod: TLabel;
     Label7zDictionary: TLabel;
     Label7zWord: TLabel;
     LabelUPXLevel: TLabel;
     LabelPAQLevel: TLabel;
     Label7zPasses: TLabel;
     Label7zsolidblock: TLabel;
     LabelAbout: TLabel;
     Subtitle7zCompOpt: TLabel;
     Label7zOtherParams: TLabel;
     LabelARCParams: TLabel;
     LabelCustParams: TLabel;
     LabelCustSyntax: TLabel;
     LabelCustExtension: TLabel;
     LabelCustomParamExt: TLabel;
     LabelCustomSyntaxExt: TLabel;
     LabelCustomBinExt: TLabel;
     LabelCustExe: TLabel;
     LabelARCsolidblock: TLabel;
     LabelArcSub1: TLabel;
     LabelArcSub2: TLabel;
     Labelbcmblock: TLabel;
     LabelDefaultFormat: TLabel;
     Labeloamext: TLabel;
     Labelogreset: TLabel;
     LabelResetOpenWith: TLabel;
     Labelcbadvanced: TLabel;
     Labelcbbasic: TLabel;
     Labelcbsample: TLabel;
     Labelcbsampleadvanced: TLabel;
     LabelClipInfo: TLabel;
     LabelClickAdArchive1: TLabel;
     LabelClickAdArchive2: TLabel;
     LabelClickAdArchive3: TLabel;
     LabelClickAdArchive4: TLabel;
     LabelAppColor: TLabel;
     LabelConfigurePeaZip: TLabel;
     LabelCustom: TLabel;
     LabelDefaultColor1: TLabel;
     LabelEvery: TLabel;
     LabelEveryExt: TLabel;
     LabelEveryUnit: TLabel;
     LabelEveryUnitExt: TLabel;
     LabelLang: TLabel;
     Labeloptsub1: TLabel;
     LabelSecureDelete: TLabel;
     LabelHashFormat: TLabel;
     LabelBrowserHash: TLabel;
     LabelPanelHintAdd: TLabel;
     LabelPanelHintExtract: TLabel;
     LabelPEAStream: TLabel;
     LabelPEAObj: TLabel;
     LabelPEAVol: TLabel;
     LabelResetApp1: TLabel;
     LabelResetBookmarks: TLabel;
     LabelResetHistory: TLabel;
     LabelResetPM: TLabel;
     LabelResetPtmp: TLabel;
     LabelSplit: TLabel;
     LabelStatusExtract: TLabel;
     LabelOutAdd: TLabel;
     LabelTheme: TLabel;
     LabelTheme1: TLabel;
     LabelTheme2: TLabel;
     LabelTheme3: TLabel;
     LabelThemeLoaded: TLabel;
     LabelTitleApps1: TLabel;
     LabelTitleApps2: TLabel;
     LabelTitleExtract2: TLabel;
     LabelTitleExtract3: TLabel;
     LabelTitleExtract4: TLabel;
     LabelTitleExtract1: TLabel;
     ListAddress: TListView;
     Lmanageschedule1: TLabel;
     Lmanageschedule2: TLabel;
     LmanagescheduleExt1: TLabel;
     LmanagescheduleExt2: TLabel;
     lsa1: TLabel;
     lsa2: TLabel;
     lsa3: TLabel;
     lse1: TLabel;
     lse2: TLabel;
     lse3: TLabel;
     lsaday: TLabel;
     lsadayExt: TLabel;
     lsp: TLabel;
     lspext: TLabel;
     lsspcext: TLabel;
     lsspc1: TLabel;
     MemoAbout: TMemo;
     MenuItem104: TMenuItem;
     mCharCase: TMenuItem;
     mChar: TMenuItem;
     MenuItem105: TMenuItem;
     mDateYear: TMenuItem;
     mDateMonth: TMenuItem;
     mDateDay: TMenuItem;
     mDateHour: TMenuItem;
     mDateWeek: TMenuItem;
     MenuItem109: TMenuItem;
     maddexisting: TMenuItem;
     maddconvert: TMenuItem;
     MenuItem110: TMenuItem;
     abc4: TMenuItem;
     abc3: TMenuItem;
     abc2: TMenuItem;
     abc1: TMenuItem;
     abc8: TMenuItem;
     abc7: TMenuItem;
     abc6: TMenuItem;
     abc5: TMenuItem;
     abc0: TMenuItem;
     pmtabsnew: TMenuItem;
     pmtabsclose: TMenuItem;
     pmtabs: TPopupMenu;
     po_rename_appenddir: TMenuItem;
     po_rename_prependdir: TMenuItem;
     org_autoadjust: TMenuItem;
     MenuItemOpen_saveastxt: TMenuItem;
     mfun0: TMenuItem;
     metn: TMenuItem;
     morghistory: TMenuItem;
     morgsessionhistory: TMenuItem;
     morgbookmarks: TMenuItem;
     PanelActOptions: TPanel;
     PanelSpacerAdd: TPanel;
     ComboBoxActionArc: TComboBox;
     panelspacerextract: TPanel;
     pob_crc24: TMenuItem;
     pob_crc64: TMenuItem;
     pob_edonkey: TMenuItem;
     pob_md4: TMenuItem;
     pob_md5: TMenuItem;
     pob_ripemd: TMenuItem;
     pob_sha1: TMenuItem;
     pob_sha256: TMenuItem;
     pob_sha3256: TMenuItem;
     pob_sha512: TMenuItem;
     pob_sha3512: TMenuItem;
     pob_whirlpool: TMenuItem;
     pob_crc32: TMenuItem;
     pob_adler: TMenuItem;
     pob_crc16: TMenuItem;
     OptionsAdd: TScrollBox;
     OptionsAddAdv: TScrollBox;
     OptionsARC: TPanel;
     OptionsExtract: TScrollBox;
     OptionsExtractAdv: TScrollBox;
     PageOpt1: TScrollBox;
     PageOpt3: TScrollBox;
     PageOpt4: TScrollBox;
     PageOpt5: TScrollBox;
     PageOpt6: TScrollBox;
     PageOpt7: TScrollBox;
     PageOpt8: TScrollBox;
     Panel7z: TPanel;
     PanelApps1: TPanel;
     PanelApps2: TPanel;
     PanelARC: TPanel;
     PanelArchiveTypeOpt: TPanel;
     PanelCustom: TPanel;
     PanelHDW: TPanel;
     PanelHDWExt: TPanel;
     PanelHintAdd: TPanel;
     PanelHintExtract: TPanel;
     PanelMonthly: TPanel;
     PanelMonthlyExt: TPanel;
     PanelPAQ: TPanel;
     PanelPEA: TPanel;
     PanelQuad: TPanel;
     PanelScheduleAdd: TPanel;
     PanelScheduleExt: TPanel;
     PanelSplitFile: TPanel;
     PanelTitleApps: TPanel;
     PanelUPX: TPanel;
     PanelWeekly: TPanel;
     PanelWeeklyExt: TPanel;
     PEA: TGroupBox;
     pmbce: TMenuItem;
     pmbcexpand: TMenuItem;
     pmamr2: TMenuItem;
     pmamr3: TMenuItem;
     pmamr4: TMenuItem;
     pmamr5: TMenuItem;
     pmamr6: TMenuItem;
     pmamr7: TMenuItem;
     pmamr8: TMenuItem;
     pmamr1: TMenuItem;
     pmquickdesk: TMenuItem;
     pmquickhome: TMenuItem;
     pmquickop: TMenuItem;
     pmquickoa: TMenuItem;
     pmquicksd: TMenuItem;
     MenuItem48: TMenuItem;
     MenuItem50: TMenuItem;
     MenuItem61: TMenuItem;
     pmbcspacer: TMenuItem;
     pmtypeswap: TMenuItem;
     pmttitle: TMenuItem;
     PanelListResetSearch: TPanel;
     pmflat: TMenuItem;
     po_analyze: TMenuItem;
     pmmorehex: TMenuItem;
     pmqnointdir: TMenuItem;
     pmmoreanalysis: TMenuItem;
     po_rename_timestamp: TMenuItem;
     PanelSearch: TPanel;
     mextract: TMenuItem;
     MenuItem47: TMenuItem;
     mtoggletbrib: TMenuItem;
     mf4: TMenuItem;
     OpenDialogApps1: TOpenDialog;
     PanelAdArchive0: TPanel;
     PanelAdArchive3: TPanel;
     PanelAdArchive1: TPanel;
     PanelAdArchive2: TPanel;
     pmCustEditAdd: TMenuItem;
     pmCustEditAdd1: TMenuItem;
     pmCustEditApps: TPopupMenu;
     pmCustEditApps1: TPopupMenu;
     pmCustEditDesc: TMenuItem;
     pmCustEditDesc1: TMenuItem;
     pmCustEditEdit: TMenuItem;
     pmCustEditEdit1: TMenuItem;
     pmCustEditEdit1after: TMenuItem;
     pmCustEditRemove: TMenuItem;
     pmCustEditRemove1: TMenuItem;
     cbDefaultFormat: TComboBox;
     cbHashFormat: TComboBox;
     cbBrowserHash: TComboBox;
     ComboBoxActionExtract: TComboBox;
     RadioGroup7zSFX: TRadioGroup;
     RadioGroupBrowser: TComboBox;
     RadioGroupPaq: TRadioGroup;
     RadioGrouppwrequest: TComboBox;
     RadioGroupQuad: TRadioGroup;
     cbTimeStamp: TComboBox;
     schedaddname: TEdit;
     SchedAddnameExt: TEdit;
     schedaddschedule: TComboBox;
     SchedAddscheduleExt: TComboBox;
     ScheduleAdd: TScrollBox;
     scheduleend: TCheckBox;
     scheduleendext: TCheckBox;
     ScheduleExtract: TScrollBox;
     schedulehh: TSpinEdit;
     schedulehhext: TSpinEdit;
     schedulemm: TSpinEdit;
     schedulemmext: TSpinEdit;
     scheduleNN: TSpinEdit;
     scheduleNNext: TSpinEdit;
     schedulepassword: TLabel;
     schedulepasswordext: TLabel;
     schedulestart: TCheckBox;
     schedulestartext: TCheckBox;
     scheduleuser: TCheckBox;
     scheduleuserext: TCheckBox;
     PanelAddress: TPanel;
     SpinEditSplit: TSpinEdit;
     SplitterOptions: TSplitter;
     StringGridAdd: TStringGrid;
     StringGridExtract: TStringGrid;
     StringGridAddressAllFolders: TStringGrid;
     StringGridAddressOmittedFolders: TStringGrid;
     StringGridCustEdit: TStringGrid;
     StringGridCustEditAdv: TStringGrid;
     StringGridList: TStringGrid;
     StringGridAddress: TStringGrid;
     Subtitle7zOpt: TLabel;
     Subtitle7zEncOpt: TLabel;
     TabBar: THeaderControl;
     tbcontrast: TTrackBar;
     themesave_label: TLabel;
     ThemeReset: TImage;
     TimerBusy: TTimer;
     Timerrename: TTimer;
     tmupdate: TMenuItem;
     tmconvert: TMenuItem;
     tmextract: TMenuItem;
     munpeaextract: TMenuItem;
     mlayouts: TMenuItem;
     OpenDialogLayout: TOpenDialog;
     pmbcd17: TMenuItem;
     pmbcd18: TMenuItem;
     pmbcd19: TMenuItem;
     PanelAddress2: TPanel;
     PanelAddress3: TPanel;
     PanelAddress4: TPanel;
     PanelAddress5: TPanel;
     PanelAddress6: TPanel;
     PanelAddress7: TPanel;
     PanelAddress1: TPanel;
     PanelAddress0: TPanel;
     pmbcd0: TMenuItem;
     pmbcd16: TMenuItem;
     pmbcd5: TMenuItem;
     pmbcd6: TMenuItem;
     pmbcd7: TMenuItem;
     pmbcd8: TMenuItem;
     pmbcd9: TMenuItem;
     pmbcd10: TMenuItem;
     pmbcd11: TMenuItem;
     pmbcd12: TMenuItem;
     pmbcd13: TMenuItem;
     pmbcd14: TMenuItem;
     pmbcd15: TMenuItem;
     pmbcd1: TMenuItem;
     pmbcd2: TMenuItem;
     pmbcd3: TMenuItem;
     pmbcd4: TMenuItem;
     pmbcdir: TPopupMenu;
     po_renmenu: TMenuItem;
     pmbreadfs: TMenuItem;
     pmbreadfun: TMenuItem;
     mselectadv: TMenuItem;
     pmselectadv: TMenuItem;
     po_selectadv: TMenuItem;
     pmrselect: TMenuItem;
     pmcpypath: TMenuItem;
     pmCopyPath: TMenuItem;
     po_copypath: TMenuItem;
     msamemonth: TMenuItem;
     msameweek: TMenuItem;
     msameday: TMenuItem;
     msamehour: TMenuItem;
     MenuItem113: TMenuItem;
     msameyear: TMenuItem;
     mpackedsimilar50: TMenuItem;
     MenuItem107: TMenuItem;
     msizesimilar50: TMenuItem;
     MenuItem86: TMenuItem;
     mpackedsimilar: TMenuItem;
     msizesimilar: TMenuItem;
     mpacked100m: TMenuItem;
     mpacked10m: TMenuItem;
     mpacked100k: TMenuItem;
     mpackedempty: TMenuItem;
     MenuItem69: TMenuItem;
     mpackedover: TMenuItem;
     msize10m: TMenuItem;
     MenuItem106: TMenuItem;
     msize100m: TMenuItem;
     msizeover: TMenuItem;
     msize100k: TMenuItem;
     msize0: TMenuItem;
     pmcut: TMenuItem;
     pmr_add: TMenuItem;
     pmr_delete: TMenuItem;
     pmr_replace: TMenuItem;
     pmr_replacecase: TMenuItem;
     pmr_ext: TMenuItem;
     pmr_lowercase: TMenuItem;
     pmr_uppercase: TMenuItem;
     PopupMenuRename: TPopupMenu;
     po_im_TIFF: TMenuItem;
     pmisJPEG75: TMenuItem;
     pmisJPEG50: TMenuItem;
     po_im_JPEG75: TMenuItem;
     po_im_JPEG50: TMenuItem;
     po_im_4ktv: TMenuItem;
     po_im_4kcinema: TMenuItem;
     pmif8: TMenuItem;
     pmif6: TMenuItem;
     pmif7: TMenuItem;
     po_im_BMP: TMenuItem;
     po_im_75: TMenuItem;
     po_im_1024: TMenuItem;
     po_im_hd: TMenuItem;
     po_im_wuxga: TMenuItem;
     MenuItem108: TMenuItem;
     po_im_JPEG: TMenuItem;
     po_im_PNG: TMenuItem;
     MenuItem54: TMenuItem;
     po_im_50: TMenuItem;
     po_im_200: TMenuItem;
     mplugins: TMenuItem;
     po_rename_replace_case: TMenuItem;
     po_rename_uppercase: TMenuItem;
     po_rename_replace: TMenuItem;
     MenuItem26: TMenuItem;
     po_rename_ext: TMenuItem;
     po_rename_delete: TMenuItem;
     po_rename_add: TMenuItem;
     po_rename_lowercase: TMenuItem;
     pmmorecheck: TMenuItem;
     MenuItem36: TMenuItem;
     pmmore3: TMenuItem;
     pmmore4: TMenuItem;
     pmmore5: TMenuItem;
     pmmore6: TMenuItem;
     pmmore7: TMenuItem;
     pmmore8: TMenuItem;
     pmmoreseparator: TMenuItem;
     pmmore1: TMenuItem;
     pmmore2: TMenuItem;
     pmAdvanced: TMenuItem;
     pmrefreshlayout: TMenuItem;
     pmemr5: TMenuItem;
     pmemr6: TMenuItem;
     pmemr7: TMenuItem;
     pmemr8: TMenuItem;
     pmemr2: TMenuItem;
     pmemr3: TMenuItem;
     pmemr4: TMenuItem;
     pmemr0: TMenuItem;
     MenuItem6: TMenuItem;
     pmemr1: TMenuItem;
     pmemb6: TMenuItem;
     pmemb7: TMenuItem;
     pmemb8: TMenuItem;
     pmemb3: TMenuItem;
     pmemb2: TMenuItem;
     pmemb4: TMenuItem;
     pmemb5: TMenuItem;
     pmemb1: TMenuItem;
     pmFoldersmenu: TMenuItem;
     pmemrf5: TMenuItem;
     pmemrf6: TMenuItem;
     pmemrf7: TMenuItem;
     pmemrf8: TMenuItem;
     pmemrf2: TMenuItem;
     pmemrf3: TMenuItem;
     pmemrf4: TMenuItem;
     pmemrf0: TMenuItem;
     MenuItemsepfold: TMenuItem;
     pmemrf1: TMenuItem;
     pmembf6: TMenuItem;
     pmembf7: TMenuItem;
     pmembf8: TMenuItem;
     pmembf3: TMenuItem;
     pmembf2: TMenuItem;
     pmembf4: TMenuItem;
     pmembf5: TMenuItem;
     pmembf1: TMenuItem;
     pmExploremenu: TMenuItem;
     PanelTitleExtract: TPanel;
     BevelTitleOptions1: TPanel;
     BevelTitleOptions3: TPanel;
     BevelTitleOptions4: TPanel;
     BevelTitleOptions5: TPanel;
     ButtonArchiveOK: TBitBtn;
     ButtonArchiveCancel: TBitBtn;
     ButtonDelete: TSpeedButton;
     ButtonDup: TSpeedButton;
     ButtonDup1: TSpeedButton;
     ButtonNF: TSpeedButton;
     Buttonfmactions: TSpeedButton;
     SpeedButtonAdd: TSpeedButton;
     ButtonExtCancel: TBitBtn;
     ButtonExtOk: TBitBtn;
     ButtonImgRes: TSpeedButton;
     ButtonImgR: TSpeedButton;
     ButtonImgCrop: TSpeedButton;
     Buttonopenactions: TSpeedButton;
     ButtonOpenWith: TSpeedButton;
     ButtonProperties: TSpeedButton;
     ButtonRename1: TSpeedButton;
     ButtonUn7zaTest: TSpeedButton;
     ButtonCopy: TSpeedButton;
     Buttoncmto: TSpeedButton;
     ButtonRename: TSpeedButton;
     ButtonImgResize: TSpeedButton;
     ButtonUn7zaAdd: TSpeedButton;
     ButtonUn7zaConvert: TSpeedButton;
     ButtonPropertiesActions: TSpeedButton;
     ButtonExtractActions: TSpeedButton;
     ButtonCut: TSpeedButton;
     ButtonImg6: TSpeedButton;
     ButtonConvertActions: TSpeedButton;
     ButtonTestActions: TSpeedButton;
     ButtonUn7zaTo: TSpeedButton;
     ButtonPaste: TSpeedButton;
     ButtonImgRL: TSpeedButton;
     ButtonImgRR: TSpeedButton;
     LabelTitleAdd1: TLabel;
     LabelTitleAdd2: TLabel;
     LabelTitleAdd3: TLabel;
     LabelTitleAdd4: TLabel;
     pmrsh: TMenuItem;
     PanelTitleAdd: TPanel;
     pmmorefun_properties: TMenuItem;
     pmfun17: TMenuItem;
     pmfun18: TMenuItem;
     pmbcorganizebookmarks: TMenuItem;
     pmbcaddbookmark: TMenuItem;
     pmfunaz: TMenuItem;
     pmsearchdrag: TMenuItem;
     pmsearchweb: TMenuItem;
     PanelProgressAdd: TPanel;
     PanelProgressExtract: TPanel;
     ShellTreeViewTmp: TShellTreeView;
     MenuItem100: TMenuItem;
     mprofileultra7z: TMenuItem;
     mprofilenormal7z: TMenuItem;
     mprofilenormalzip: TMenuItem;
     mprofilefastzip: TMenuItem;
     mprofileencrypt7z: TMenuItem;
     mprofilesplitzip: TMenuItem;
     mprofileauto: TMenuItem;
     NotebookAdd: TPanel;
     PanelTitleOptions: TPanel;
     po_details: TMenuItem;
     pmmorefun_details: TMenuItem;
     pmmstatus_r: TMenuItem;
     pmfun6: TMenuItem;
     pmfun7: TMenuItem;
     pmfun8: TMenuItem;
     pmfun9: TMenuItem;
     pmfun10: TMenuItem;
     pmfun11: TMenuItem;
     pmfun12: TMenuItem;
     pmfun13: TMenuItem;
     pmfun14: TMenuItem;
     pmfun15: TMenuItem;
     pmfun16: TMenuItem;
     MenuItem20: TMenuItem;
     MenuItem93: TMenuItem;
     MenuItem94: TMenuItem;
     pmfun1: TMenuItem;
     pmfun2: TMenuItem;
     pmfun3: TMenuItem;
     pmfun4: TMenuItem;
     pmfun5: TMenuItem;
     tbtemperature: TTrackBar;
     w7contextlang: TMenuItem;
     mpeautils: TMenuItem;
     MenuItem5: TMenuItem;
     MenuItem92: TMenuItem;
     mPeaFAQ: TMenuItem;
     mPeaSupport: TMenuItem;
     mPeaSiteMirror: TMenuItem;
     pmsecuredeletefree: TMenuItem;
     pmzerofree: TMenuItem;
     MenuItem91: TMenuItem;
     pmzerofile: TMenuItem;
     po_securedeletefree: TMenuItem;
     po_zerofree: TMenuItem;
     MenuItem56: TMenuItem;
     po_zerofile: TMenuItem;
     pmqjmyboxfiles: TMenuItem;
     MenuItemOpen_myboxfiles: TMenuItem;
     mtaskscheduler: TMenuItem;
     mscheduledscripts: TMenuItem;
     CheckBoxClip: TCheckBox;
     ctrlback: TSpeedButton;
     ImageListRoot: TImage;
     Labelbsize: TLabel;
     LabelStatusAr: TLabel;
     LabelStatusEx: TLabel;
     pmrename: TMenuItem;
     MenuItemEnumerate: TMenuItem;
     pmjumppictures: TMenuItem;
     pmjumpvideos: TMenuItem;
     MenuItem12: TMenuItem;
     MenuItemOpen_music: TMenuItem;
     MenuItemOpen_pictures: TMenuItem;
     MenuItemOpen_videos: TMenuItem;
     pmjumpmusic: TMenuItem;
     MenuItem4: TMenuItem;
     mbc0: TMenuItem;
     mbc1: TMenuItem;
     mbc2: TMenuItem;
     mbc3: TMenuItem;
     mbc4: TMenuItem;
     mbc5: TMenuItem;
     mbc6: TMenuItem;
     mbc7: TMenuItem;
     mbc8: TMenuItem;
     MenuItem85: TMenuItem;
     MenuItem90: TMenuItem;
     pmhbc0: TMenuItem;
     pnbc2: TMenuItem;
     pnbc3: TMenuItem;
     pnbc4: TMenuItem;
     pnbc5: TMenuItem;
     pnbc6: TMenuItem;
     pnbc7: TMenuItem;
     pnbc8: TMenuItem;
     pnbc0: TMenuItem;
     pnbc1: TMenuItem;
     pmbc: TMenuItem;
     po_task: TMenuItem;
     pnr0: TMenuItem;
     pnh0s: TMenuItem;
     pmhr0: TMenuItem;
     pmh0s: TMenuItem;
     mrecent0: TMenuItem;
     MenuItem32: TMenuItem;
     mback: TMenuItem;
     MenuItem37: TMenuItem;
     mbackalias: TMenuItem;
     mhistory0s: TMenuItem;
     MenuItem75: TMenuItem;
     MenuItem76: TMenuItem;
     mb0: TMenuItem;
     MenuItem84: TMenuItem;
     po_sysmore: TMenuItem;
     po_msinfo32: TMenuItem;
     po_msconfig: TMenuItem;
     po_regedit: TMenuItem;
     po_mrt: TMenuItem;
     pmpowershell: TMenuItem;
     MenuItemPowerShell: TMenuItem;
     MenuItemOpen_powershell: TMenuItem;
     pmhr1f: TMenuItem;
     pmhr2f: TMenuItem;
     pmhr3f: TMenuItem;
     pmhr4f: TMenuItem;
     pmhr5f: TMenuItem;
     pmhr6f: TMenuItem;
     pmhr7f: TMenuItem;
     pmhr8f: TMenuItem;
     mRecent1f: TMenuItem;
     mRecent2f: TMenuItem;
     mRecent3f: TMenuItem;
     mRecent4f: TMenuItem;
     mRecent5f: TMenuItem;
     mRecent6f: TMenuItem;
     mRecent7f: TMenuItem;
     mRecent8f: TMenuItem;
     po_im_rl: TMenuItem;
     po_im_rr: TMenuItem;
     MenuItem82: TMenuItem;
     po_im_crop: TMenuItem;
     po_im_modify: TMenuItem;
     po_im: TMenuItem;
     menuitemopenhome: TMenuItem;
     mfwd: TMenuItem;
     PanelListRoot: TPanel;
     pmhrefresh: TMenuItem;
     MenuItemOpen_dropbox: TMenuItem;
     MenuItemOpen_googledrive: TMenuItem;
     MenuItemOpen_onedrive: TMenuItem;
     MenuItemOpen_skydrive: TMenuItem;
     MenuItemOpen_ubuntuone: TMenuItem;
     MenuItem73: TMenuItem;
     pmorganizebookmarks: TMenuItem;
     pmrsearch: TMenuItem;
     MenuItemOpen_organizebookmarks: TMenuItem;
     PanelInfoGeneral: TPanel;
     pmqjmore: TMenuItem;
     pmqjgoogledrive: TMenuItem;
     pmqjonedrive: TMenuItem;
     pmqjskydrive: TMenuItem;
     pmqjubuntuone: TMenuItem;
     pmisTIFF: TMenuItem;
     pmif1: TMenuItem;
     pmif2: TMenuItem;
     pmif3: TMenuItem;
     pmif4: TMenuItem;
     pmif5: TMenuItem;
     MenuItem88: TMenuItem;
     MenuItem89: TMenuItem;
     pmisBMP: TMenuItem;
     pmisJPEG: TMenuItem;
     pmisPNG: TMenuItem;
     pmiresize25: TMenuItem;
     pmiresize33: TMenuItem;
     pmiresize50: TMenuItem;
     pmiresize75: TMenuItem;
     pmiresize125: TMenuItem;
     pmiresize150: TMenuItem;
     pmiresize200: TMenuItem;
     pmiresize300: TMenuItem;
     pmiresize400: TMenuItem;
     pmir180: TMenuItem;
     pmirflip: TMenuItem;
     pmirmirror: TMenuItem;
     mpretoggle: TMenuItem;
     pmImageRotate: TPopupMenu;
     pmImageResize: TPopupMenu;
     po_alltasks: TMenuItem;
     pmpdup: TMenuItem;
     PanelBarOpen3: TPanel;
     po_recycle: TMenuItem;
     pmrecycle: TMenuItem;
     po_open_asarchivet: TMenuItem;
     MenuItem77: TMenuItem;
     pmmstatus_clipboard: TMenuItem;
     pmmstatus_ra: TMenuItem;
     pmmstatus_bookmarks: TMenuItem;
     pmmstatus_status: TMenuItem;
     pmws: TMenuItem;
     MenuItem47t: TMenuItem;
     MenuItem9t: TMenuItem;
     pmcheck: TMenuItem;
     pmnewfolder: TMenuItem;
     MenuItem79: TMenuItem;
     pmproperties: TMenuItem;
     mupdate: TMenuItem;
     MenuItem78: TMenuItem;
     mscripts: TMenuItem;
     modock: TMenuItem;
     mot: TMenuItem;
     mor: TMenuItem;
     mob: TMenuItem;
     mol: TMenuItem;
     modefault: TMenuItem;
     motr: TMenuItem;
     mobr: TMenuItem;
     mobl: TMenuItem;
     motl: TMenuItem;
     PanelBarOpen2: TPanel;
     pmtopen: TPopupMenu;
     pmtestinfolist: TPopupMenu;
     po_flat: TMenuItem;
     MenuItemOrganizeStatusbar: TMenuItem;
     MenuItemOrganizeNavbar: TMenuItem;
     MenuItemOrganizeToolbar: TMenuItem;
     mmore: TMenuItem;
     mJob: TMenuItem;
     mProperties: TMenuItem;
     ctrlfwd: TSpeedButton;
     ctrlwarning: TSpeedButton;
     ctrlup: TSpeedButton;
     EditOpenIn: TEdit;
     EditOpenInInteractive: TEdit;
     il_dtheme_16: TImageList;
     il_dtheme_tool32: TImageList;
     ImageAddress: TImage;
     ImageListSearch: TImage;
     il_nonthemed: TImageList;
     ImageTheme: TImage;
     LabelClickAddress1: TLabel;
     LabelClickAddress2: TLabel;
     LabelClickAddress3: TLabel;
     LabelClickAddress4: TLabel;
     LabelClickAddress5: TLabel;
     LabelClickAddress6: TLabel;
     LabelClickAddress7: TLabel;
     LabelClickAddress8: TLabel;
     LabelStatus: TLabel;
     LabelStatusExDetails: TLabel;
     LabelStatusdisplayed: TLabel;
     fextallfav1: TMenuItem;
     mwebs: TMenuItem;
     po_fm: TMenuItem;
     MenuItem34: TMenuItem;
     fextallfav2: TMenuItem;
     fextallfav3: TMenuItem;
     fextallfav4: TMenuItem;
     fextallfav5: TMenuItem;
     fextallfav6: TMenuItem;
     fextallfav7: TMenuItem;
     fextallfav8: TMenuItem;
     extalllast: TMenuItem;
     mbrowsersort: TMenuItem;
     MenuItem65: TMenuItem;
     MenuItem67: TMenuItem;
     MenuItem68: TMenuItem;
     MenuItem70: TMenuItem;
     mAdmin: TMenuItem;
     aowcustom_9: TMenuItem;
     aowcustom_10: TMenuItem;
     aowcustom_11: TMenuItem;
     aowcustom_12: TMenuItem;
     aowcustom_13: TMenuItem;
     aowcustom_14: TMenuItem;
     aowcustom_15: TMenuItem;
     aowcustom_16: TMenuItem;
     eowcustom_9: TMenuItem;
     eowcustom_10: TMenuItem;
     eowcustom_11: TMenuItem;
     eowcustom_12: TMenuItem;
     eowcustom_13: TMenuItem;
     eowcustom_14: TMenuItem;
     eowcustom_15: TMenuItem;
     eowcustom_16: TMenuItem;
     pmqjdropbox: TMenuItem;
     MenuItemProperties: TMenuItem;
     PanelBarOpen1: TPanel;
     mpm: TMenuItem;
     PanelBottom: TPanel;
     pmjumpbreadcrumb: TMenuItem;
     mrecsearch: TMenuItem;
     pmsrec: TMenuItem;
     powcustom_9: TMenuItem;
     powcustom_10: TMenuItem;
     powcustom_11: TMenuItem;
     powcustom_12: TMenuItem;
     powcustom_13: TMenuItem;
     powcustom_14: TMenuItem;
     powcustom_15: TMenuItem;
     powcustom_16: TMenuItem;
     owcustom_9: TMenuItem;
     owcustom_10: TMenuItem;
     owcustom_11: TMenuItem;
     owcustom_12: TMenuItem;
     owcustom_13: TMenuItem;
     owcustom_14: TMenuItem;
     owcustom_15: TMenuItem;
     owcustom_16: TMenuItem;
     mimmersive: TMenuItem;
     msimplesearch: TMenuItem;
     MenuItemopendesktop: TMenuItem;
     mfullscreen: TMenuItem;
     po_checksum: TMenuItem;
     mthumbimages: TMenuItem;
     pmshist3: TMenuItem;
     pmshist4: TMenuItem;
     pmshist5: TMenuItem;
     pmshist6: TMenuItem;
     pmshist7: TMenuItem;
     pmshist8: TMenuItem;
     pmshist1: TMenuItem;
     pmshist2: TMenuItem;
     mtoggleop: TMenuItem;
     mtogglestatusbar: TMenuItem;
     msorttoggle: TMenuItem;
     mtogglenavbar: TMenuItem;
     MenuItem51: TMenuItem;
     MenuItem62: TMenuItem;
     mttoggletoolbar: TMenuItem;
     pma2s_extnew1: TMenuItem;
     pma2s_extallnew1: TMenuItem;
     pma2s_extnew: TMenuItem;
     pma2s_cancel1: TMenuItem;
     pma2s_extract1: TMenuItem;
     pmapptosysextract: TPopupMenu;
     mPeaTracker: TMenuItem;
     pmireset: TMenuItem;
     pmextcontext: TPopupMenu;
     pmextcontextall: TMenuItem;
     pmextcontextdisplayed: TMenuItem;
     pmextcontextselected: TMenuItem;
     pmresetsearch: TPopupMenu;
     po_sortby: TMenuItem;
     pmbc1: TMenuItem;
     pmbc2: TMenuItem;
     pmbc3: TMenuItem;
     pmbc4: TMenuItem;
     pmbc5: TMenuItem;
     pmbc6: TMenuItem;
     pmbc7: TMenuItem;
     pmbc8: TMenuItem;
     mswapbars: TMenuItem;
     PanelClickAddress: TPanel;
     PanelListSearch: TPanel;
     PanelListBar: TPanel;
     pmqelast: TMenuItem;
     pmqe2fav: TMenuItem;
     pmqe3fav: TMenuItem;
     mextalldocuments: TMenuItem;
     pmqedocuments: TMenuItem;
     pmqesetpw: TMenuItem;
     mcolumns: TMenuItem;
     mcname: TMenuItem;
     mctype: TMenuItem;
     mcsize: TMenuItem;
     mcpacked: TMenuItem;
     mcdate: TMenuItem;
     mcatt: TMenuItem;
     mccrc: TMenuItem;
     mcfree: TMenuItem;
     mcfs: TMenuItem;
     mbrowsercname: TMenuItem;
     mbrowserctype: TMenuItem;
     mbrowsercsize: TMenuItem;
     mbrowsercpacked: TMenuItem;
     mbrowsercdate: TMenuItem;
     mbrowsercatt: TMenuItem;
     mbrowserccrc: TMenuItem;
     po_browsercname: TMenuItem;
     po_browserctype: TMenuItem;
     po_browsercsize: TMenuItem;
     po_browsercpacked: TMenuItem;
     po_browsercdate: TMenuItem;
     po_browsercatt: TMenuItem;
     po_browserccrc: TMenuItem;
     MenuItem44: TMenuItem;
     MenuItem52: TMenuItem;
     mbreset: TMenuItem;
     MenuItem63: TMenuItem;
     fextalldefault: TMenuItem;
     pmopenout: TMenuItem;
     pmqenopath: TMenuItem;
     mextalldesktop: TMenuItem;
     pmqen1: TMenuItem;
     pmqen2: TMenuItem;
     pmqen3: TMenuItem;
     pmqen4: TMenuItem;
     pmqen5: TMenuItem;
     mextallhere: TMenuItem;
     mextallto: TMenuItem;
     MenuItemExtAllHere: TMenuItem;
     MenuItemExtAllTo: TMenuItem;
     pmusedefault: TMenuItem;
     pmqedefault: TMenuItem;
     pmqe1fav: TMenuItem;
     MenuItem66: TMenuItem;
     pmqenewfolder: TMenuItem;
     pmqedesk: TMenuItem;
     pmqeto: TMenuItem;
     pmqehere: TMenuItem;
     mSystemIntegration: TMenuItem;
     pma2s_extractall1: TMenuItem;
     mwebsearch: TMenuItem;
     PanelIntro: TPanel;
     MenuItemDonations: TMenuItem;
     MenuItemOpen_downloads1: TMenuItem;
     pmjumpdownloads: TMenuItem;
     pmquickextract: TPopupMenu;
     pmbreadcrumb: TPopupMenu;
     po_open_asarchive: TMenuItem;
     pmjumprecent: TMenuItem;
     pmjumpsearches: TMenuItem;
     pmjumplibraries: TMenuItem;
     MenuItemOrganizeMbar: TMenuItem;
     MenuItemOpen_pubhome: TMenuItem;
     MenuItem53: TMenuItem;
     MenuItem55: TMenuItem;
     MenuItem57: TMenuItem;
     MenuItem59: TMenuItem;
     morganize: TMenuItem;
     pmhr1: TMenuItem;
     pmhr2: TMenuItem;
     pmhr3: TMenuItem;
     pmhr4: TMenuItem;
     pmhr5: TMenuItem;
     pmhr6: TMenuItem;
     pmhr7: TMenuItem;
     pmhr8: TMenuItem;
     pmhr9: TMenuItem;
     pmjumppubhome: TMenuItem;
     pma2s_extract: TMenuItem;
     pms2a_open: TMenuItem;
     MenuItem9: TMenuItem;
     mshowmenu: TMenuItem;
     mthl: TMenuItem;
     MenuItem46: TMenuItem;
     pms2a_add: TMenuItem;
     pma2s_cancel: TMenuItem;
     pms2a_copy: TMenuItem;
     pma2s_copy: TMenuItem;
     pms2a_move: TMenuItem;
     MenuItem45: TMenuItem;
     pms2a_cancel: TMenuItem;
     MenuItemOpen_search: TMenuItem;
     munsearch: TMenuItem;
     pma2s_move: TMenuItem;
     pmsystoapp: TPopupMenu;
     pmapptosys: TPopupMenu;
     Panelnav: TPanel;
     LabelStatusArDetails: TLabel;
     ListViewBrowser: TListView;
     mctrlf3: TMenuItem;
     mcancel: TMenuItem;
     mbcl: TMenuItem;
     MenuItem10: TMenuItem;
     MenuItem13: TMenuItem;
     MenuItem14: TMenuItem;
     mbpea: TMenuItem;
     mbexplore: TMenuItem;
     mr9: TMenuItem;
     mhpea: TMenuItem;
     mhexplore: TMenuItem;
     mhcl: TMenuItem;
     MenuItem39: TMenuItem;
     MenuItemOpen_pubdoc: TMenuItem;
     pmjumppubdoc: TMenuItem;
     pnh1: TMenuItem;
     pnh2: TMenuItem;
     pnh3: TMenuItem;
     pnh4: TMenuItem;
     pnh5: TMenuItem;
     pnh6: TMenuItem;
     pnh7: TMenuItem;
     pnh8: TMenuItem;
     ShellTreeViewNav: TShellTreeView;
     smHistory1: TMenuItem;
     mNav: TMenuItem;
     mhistory2: TMenuItem;
     mhistory3: TMenuItem;
     mhistory4: TMenuItem;
     mhistory5: TMenuItem;
     mhistory6: TMenuItem;
     mhistory7: TMenuItem;
     mhistory8: TMenuItem;
     mHistory: TMenuItem;
     mhistory1: TMenuItem;
     pmh9: TMenuItem;
     mshiftf3: TMenuItem;
     MenuItem41: TMenuItem;
     po_hidden: TMenuItem;
     mopenasarchive: TMenuItem;
     pmbookmarks: TMenuItem;
     po_convertarchive: TMenuItem;
     mrowselect: TMenuItem;
     po_selectall: TMenuItem;
     mgotypegz: TMenuItem;
     mgotype7zsfx: TMenuItem;
     mgotypetar: TMenuItem;
     mgotypezip: TMenuItem;
     mgotypebz2: TMenuItem;
     mgotype7z: TMenuItem;
     mgotype: TMenuItem;
     mgobrowser: TMenuItem;
     mextractarchive: TMenuItem;
     mtogglenew: TMenuItem;
     mLayout: TMenuItem;
     pmsecuredelete: TMenuItem;
     pmquickdelete: TMenuItem;
     pmcpyto: TMenuItem;
     pmmvto: TMenuItem;
     pmexplore: TMenuItem;
     pmcommand: TMenuItem;
     pmh2: TMenuItem;
     pmh3: TMenuItem;
     pmh4: TMenuItem;
     pmh5: TMenuItem;
     pmh7: TMenuItem;
     pmh6: TMenuItem;
     pmh8: TMenuItem;
     pmh1: TMenuItem;
     mLang: TMenuItem;
     MenuItemOpen_Last: TMenuItem;
     MenuItem2: TMenuItem;
     madvfilters: TMenuItem;
     MenuItem33: TMenuItem;
     mkeyfile: TMenuItem;
     msetpw: TMenuItem;
     mOptions: TMenuItem;
     mgoextlayout: TMenuItem;
     MenuItem31: TMenuItem;
     MenuItemextexplore: TMenuItem;
     NotebookExtract: TPanel;
     PanelActAdd: TPanel;
     PanelActExt: TPanel;
     PanelExtract: TPanel;
     PanelClipboard: TPanel;
     PopupMenuType: TPopupMenu;
     pmBrowser: TMenuItem;
     mf8: TMenuItem;
     mctrlf8: TMenuItem;
     mshiftf8: TMenuItem;
     mf2: TMenuItem;
     mf4up: TMenuItem;
     mfun: TMenuItem;
     PanelBack: TPanel;
     smfs1: TMenuItem;
     mf3: TMenuItem;
     MenuItemHistoryBook: TMenuItem;
     PopupMenuHistory: TPopupMenu;
     pnr1: TMenuItem;
     pnr2: TMenuItem;
     pnr3: TMenuItem;
     pnr4: TMenuItem;
     pnr5: TMenuItem;
     pnr6: TMenuItem;
     pnr7: TMenuItem;
     pnr8: TMenuItem;
     MenuItemOpen_here: TMenuItem;
     mRecent9: TMenuItem;
     pmjb2: TMenuItem;
     pmjb3: TMenuItem;
     pmjb4: TMenuItem;
     pmjb5: TMenuItem;
     pmjb6: TMenuItem;
     pmjb7: TMenuItem;
     pmjb8: TMenuItem;
     pmjb9: TMenuItem;
     pmjb10: TMenuItem;
     pmjb11: TMenuItem;
     pmjb12: TMenuItem;
     pmjb13: TMenuItem;
     pmjb14: TMenuItem;
     pmjb15: TMenuItem;
     pmjb16: TMenuItem;
     pmjb17: TMenuItem;
     pmjb18: TMenuItem;
     pmjb19: TMenuItem;
     pmjb20: TMenuItem;
     pmjb21: TMenuItem;
     pmjb22: TMenuItem;
     pmjb23: TMenuItem;
     pmjb24: TMenuItem;
     pmjumpsbook: TMenuItem;
     MenuItem29: TMenuItem;
     MenuItemOpen_pc: TMenuItem;
     pmjb1: TMenuItem;
     MenuItemOpen_desktop1: TMenuItem;
     MenuItemOpen_documents1: TMenuItem;
     MenuItemOpen_home1: TMenuItem;
     pcustompathexplore: TMenuItem;
     pojdn1: TMenuItem;
     pojdn2: TMenuItem;
     pojdn3: TMenuItem;
     pojdn4: TMenuItem;
     pojdn5: TMenuItem;
     pojdn6: TMenuItem;
     pojdn7: TMenuItem;
     pojdn8: TMenuItem;
     pojdn9: TMenuItem;
     pojdn10: TMenuItem;
     pojdn11: TMenuItem;
     pojdn12: TMenuItem;
     pojdn13: TMenuItem;
     pojdn14: TMenuItem;
     pojdn15: TMenuItem;
     pojdn16: TMenuItem;
     pojdn17: TMenuItem;
     pojdn18: TMenuItem;
     pojdn19: TMenuItem;
     pojdn20: TMenuItem;
     pojdn21: TMenuItem;
     pojdn22: TMenuItem;
     pojdn23: TMenuItem;
     pojdn24: TMenuItem;
     pojdn25: TMenuItem;
     pojdn26: TMenuItem;
     pnb1: TMenuItem;
     pnb2: TMenuItem;
     pnb3: TMenuItem;
     pnb4: TMenuItem;
     pnb5: TMenuItem;
     pnb6: TMenuItem;
     pnb7: TMenuItem;
     pnb8: TMenuItem;
     pnb9: TMenuItem;
     pnb10: TMenuItem;
     pnb11: TMenuItem;
     pnb12: TMenuItem;
     pnb13: TMenuItem;
     pnb14: TMenuItem;
     pnb15: TMenuItem;
     pnb16: TMenuItem;
     pnb17: TMenuItem;
     pnb18: TMenuItem;
     pnb19: TMenuItem;
     pnb20: TMenuItem;
     pnb21: TMenuItem;
     pnb22: TMenuItem;
     pnb23: TMenuItem;
     PopupPathExtract: TPopupMenu;
     pmmorefun_info: TMenuItem;
     pmmorefun_list: TMenuItem;
     aowseparator2: TMenuItem;
     PanelFilters: TPanel;
     MenuItemPW: TMenuItem;
     MenuItem27: TMenuItem;
     MenuItemNavigate: TMenuItem;
     OpenDialogTheme: TOpenDialog;
     pmjd1: TMenuItem;
     pmjd2: TMenuItem;
     pmjd3: TMenuItem;
     pmjd4: TMenuItem;
     pmjd5: TMenuItem;
     pmjd6: TMenuItem;
     pmjd7: TMenuItem;
     pmjd8: TMenuItem;
     pmjd9: TMenuItem;
     pmjd10: TMenuItem;
     pmjd11: TMenuItem;
     pmjd12: TMenuItem;
     pmjd13: TMenuItem;
     pmjd14: TMenuItem;
     pmjd15: TMenuItem;
     pmjd16: TMenuItem;
     pmjd17: TMenuItem;
     pmjd18: TMenuItem;
     pmjd19: TMenuItem;
     pmjd20: TMenuItem;
     pmjd21: TMenuItem;
     pmjd22: TMenuItem;
     pmjd23: TMenuItem;
     pmjd24: TMenuItem;
     pmjd25: TMenuItem;
     pmjd26: TMenuItem;
     pmmorefun: TPopupMenu;
     munpeabrowse: TMenuItem;
     munpea: TMenuItem;
     smBookmarks1: TMenuItem;
     MenuItemOpen_addtobookmarks: TMenuItem;
     po_delete: TMenuItem;
     po_securedelete: TMenuItem;
     sbBrowse: TMenuItem;
     MenuItemOpen_Up: TMenuItem;
     MenuItemOpen_back: TMenuItem;
     MenuItemOpen_fwd: TMenuItem;
     MenuItemOpen_root: TMenuItem;
     MenuItemOpen_jump: TMenuItem;
     MenuItemOpen_Flat: TMenuItem;
     MenuItemOpen_refresh: TMenuItem;
     po_spacer: TMenuItem;
     po_setpw: TMenuItem;
     mpeahelpoffline: TMenuItem;
     mTutorial: TMenuItem;
     eowseparator1: TMenuItem;
     eowcustom1: TMenuItem;
     eowcustom2: TMenuItem;
     eowcustom3: TMenuItem;
     eowcustom4: TMenuItem;
     eowcustom5: TMenuItem;
     eowcustom6: TMenuItem;
     eowcustom7: TMenuItem;
     eowcustom8: TMenuItem;
     powseparator1: TMenuItem;
     aowseparator1: TMenuItem;
     aowcustom1: TMenuItem;
     aowcustom2: TMenuItem;
     aowcustom3: TMenuItem;
     aowcustom4: TMenuItem;
     aowcustom6: TMenuItem;
     aowcustom5: TMenuItem;
     aowcustom7: TMenuItem;
     aowcustom8: TMenuItem;
     eowcustom9: TMenuItem;
     eowcustom10: TMenuItem;
     eowcustom11: TMenuItem;
     eowcustom12: TMenuItem;
     eowcustom13: TMenuItem;
     eowcustom14: TMenuItem;
     eowcustom15: TMenuItem;
     eowcustom16: TMenuItem;
     aowcustom9: TMenuItem;
     aowcustom10: TMenuItem;
     aowcustom11: TMenuItem;
     aowcustom12: TMenuItem;
     aowcustom13: TMenuItem;
     aowcustom14: TMenuItem;
     aowcustom15: TMenuItem;
     aowcustom16: TMenuItem;
     powcustom9: TMenuItem;
     powcustom10: TMenuItem;
     powcustom11: TMenuItem;
     powcustom12: TMenuItem;
     powcustom13: TMenuItem;
     powcustom14: TMenuItem;
     powcustom15: TMenuItem;
     powcustom16: TMenuItem;
     owcustom10: TMenuItem;
     owcustom11: TMenuItem;
     owcustom12: TMenuItem;
     owcustom13: TMenuItem;
     owcustom14: TMenuItem;
     owcustom15: TMenuItem;
     owcustom16: TMenuItem;
     owcustom9: TMenuItem;
     powcustom1: TMenuItem;
     powcustom2: TMenuItem;
     powcustom3: TMenuItem;
     powcustom4: TMenuItem;
     powcustom5: TMenuItem;
     powcustom6: TMenuItem;
     powcustom7: TMenuItem;
     powcustom8: TMenuItem;
     owcustom1: TMenuItem;
     owcustom2: TMenuItem;
     owcustom3: TMenuItem;
     owcustom4: TMenuItem;
     owcustom5: TMenuItem;
     owcustom6: TMenuItem;
     owcustom7: TMenuItem;
     owcustom8: TMenuItem;
     po_open_peazipt: TMenuItem;
     po_open_associatedt: TMenuItem;
     po_open_customt: TMenuItem;
     po_setappst: TMenuItem;
     owcustom1t: TMenuItem;
     owcustom2t: TMenuItem;
     owcustom3t: TMenuItem;
     owcustom4t: TMenuItem;
     owcustom5t: TMenuItem;
     owcustom6t: TMenuItem;
     owcustom7t: TMenuItem;
     owcustom8t: TMenuItem;
     owcustom9t: TMenuItem;
     owcustom10t: TMenuItem;
     owcustom11t: TMenuItem;
     owcustom12t: TMenuItem;
     owcustom13t: TMenuItem;
     owcustom14t: TMenuItem;
     owcustom15t: TMenuItem;
     owcustom16t: TMenuItem;
     owcustom_9t: TMenuItem;
     owcustom_10t: TMenuItem;
     owcustom_11t: TMenuItem;
     owcustom_12t: TMenuItem;
     owcustom_13t: TMenuItem;
     owcustom_14t: TMenuItem;
     owcustom_15t: TMenuItem;
     owcustom_16t: TMenuItem;
     SplitterBottom: TSplitter;
     SplitterSide: TSplitter;
     StringGridBookmarks: TStringGrid;
     StringGridClipboard: TStringGrid;
     StringGridSessionHistory: TStringGrid;
     StringGridRecent: TStringGrid;
     TimerBrowser: TTimer;
     TimerWinContext: TTimer;
     Timerdrag: TTimer;
     TimerHintStart: TTimer;
     tmpeazip: TMenuItem;
     MenuItem22: TMenuItem;
     tmcreate: TMenuItem;
     MenuItem21: TMenuItem;
     tmopenpath: TMenuItem;
     tmopenarchive: TMenuItem;
     MenuItem24: TMenuItem;
     tmquit: TMenuItem;
     mTray: TMenuItem;
     PopupMenuTray: TPopupMenu;
     TrayIconPZ: TTrayIcon;
     TreeViewNav: TTreeView;
     po_hexp: TMenuItem;
     MenuItemToolhexp: TMenuItem;
     pmJumpDocuments: TMenuItem;
     pclip_removeitem: TMenuItem;
     pclip_clearclip: TMenuItem;
     pmJump3: TMenuItem;
     PopupMenuClipboard: TPopupMenu;
      mAttributes: TMenuItem;
      mDate: TMenuItem;
      mDateRecent: TMenuItem;
      mDateEqual: TMenuItem;
      mDateOlder: TMenuItem;
      mDateERecent: TMenuItem;
      mDateEOlder: TMenuItem;
      MenuItem11: TMenuItem;
      mbAddArchive: TMenuItem;
      mbAddPath: TMenuItem;
      mbDelete: TMenuItem;
      mBookmarks: TMenuItem;
      mb12: TMenuItem;
      mb1: TMenuItem;
      mb11: TMenuItem;
      mb10: TMenuItem;
      mb9: TMenuItem;
      mb8: TMenuItem;
      mb7: TMenuItem;
      mb6: TMenuItem;
      mb5: TMenuItem;
      mb4: TMenuItem;
      mb3: TMenuItem;
      mb2: TMenuItem;
      mb13: TMenuItem;
      mb14: TMenuItem;
      mb15: TMenuItem;
      mb24: TMenuItem;
      mb16: TMenuItem;
      mb17: TMenuItem;
      mb18: TMenuItem;
      mb19: TMenuItem;
      mb20: TMenuItem;
      mb21: TMenuItem;
      mb22: TMenuItem;
      mb23: TMenuItem;
      MenuItem15: TMenuItem;
      mbNotes: TMenuItem;
      MenuItem16: TMenuItem;
      mAbout: TMenuItem;
      po_envstr: TMenuItem;
      po_convert: TMenuItem;
      MenuItemBookmarks: TMenuItem;
      pmExplorepath: TMenuItem;
      mcp: TMenuItem;
      mMisc: TMenuItem;
      po_copyto: TMenuItem;
      po_moveto: TMenuItem;
      MenuItemOpen_explore: TMenuItem;
      MenuItemOpen_commandprompt: TMenuItem;
      PopupMenuBookmarks: TPopupMenu;
      MenuItemRefresh: TMenuItem;
      mUser: TMenuItem;
      po_computer: TMenuItem;
      po_manage: TMenuItem;
      po_removeunits: TMenuItem;
      po_cpl: TMenuItem;
      po_taskman: TMenuItem;
      po_diskclean: TMenuItem;
      po_defrag: TMenuItem;
      po_systemtools: TMenuItem;
      mgolayout: TMenuItem;
      MenuItemOpen_path: TMenuItem;
      MenuItemOpen_archive: TMenuItem;
      po_join: TMenuItem;
      po_compare: TMenuItem;
      po_check: TMenuItem;
      po_paste: TMenuItem;
      po_split: TMenuItem;
      po_newfolder: TMenuItem;
      po_rename: TMenuItem;
      MenuItem7: TMenuItem;
      po_copy: TMenuItem;
      po_cut: TMenuItem;
      po_filetools: TMenuItem;
      po_open_peazip: TMenuItem;
      po_open_associated: TMenuItem;
      po_open_custom: TMenuItem;
      po_open: TMenuItem;
      MenuItemOpen_list_all: TMenuItem;
      MenuItemOpen_list_selected: TMenuItem;
      MenuItemOpen_list_displayed: TMenuItem;
      MenuItemOpen_list: TMenuItem;
      po_list: TMenuItem;
      po_test: TMenuItem;
      po_info: TMenuItem;
      po_exthere: TMenuItem;
      po_addtoarchive: TMenuItem;
      mRefresh: TMenuItem;
      pmJump2: TMenuItem;
      pmJump1: TMenuItem;
      pcustom3: TMenuItem;
      pcustom2: TMenuItem;
      pcustom1: TMenuItem;
      pcustom8: TMenuItem;
      pcustom7: TMenuItem;
      pcustom6: TMenuItem;
      pcustom5: TMenuItem;
      pcustom4: TMenuItem;
      mSpacer2_1: TMenuItem;
      mSortBySelection: TMenuItem;
      pmSearchAdd: TMenuItem;
      mSpacer0: TMenuItem;
      MenuItemToolCheck: TMenuItem;
      MenuItemToolCompare: TMenuItem;
      MenuItemOpen_ext_all: TMenuItem;
      MenuItemOpen_ext_selected: TMenuItem;
      MenuItemOpen_ext_displayed: TMenuItem;
      MenuItemOpen_ExtractHere: TMenuItem;
      mQuit: TMenuItem;
      mSpacer0_1: TMenuItem;
      mSizeESmaller: TMenuItem;
      mSizeELarger: TMenuItem;
      mPSLarger: TMenuItem;
      mPSELarger: TMenuItem;
      mPSEqual: TMenuItem;
      mPSESmaller: TMenuItem;
      mPackedSize: TMenuItem;
      mPSSmaller: TMenuItem;
      mSizeEqual: TMenuItem;
      mSizeLarger: TMenuItem;
      mSizeSmaller: TMenuItem;
      mSize: TMenuItem;
      mSpacer2_0: TMenuItem;
      mType: TMenuItem;
      pCustom: TPopupMenu;
      MainMenu1: TMainMenu;
      mDefaults: TMenuItem;
      MenuItem1: TMenuItem;
      mBench: TMenuItem;
      mEdit: TMenuItem;
      mBrowse: TMenuItem;
      MenuItemTools: TMenuItem;
      MenuItemOpen_info_selected: TMenuItem;
      MenuItemOpen_info_all: TMenuItem;
      MenuItemOpen_info_displayed: TMenuItem;
      mFlat: TMenuItem;
      mSpacer3: TMenuItem;
      openwithpeazip: TMenuItem;
      openwithassociated: TMenuItem;
      openwithcustom: TMenuItem;
      MenuItemERCustom: TMenuItem;
      MenuItemPrePeaZip: TMenuItem;
      MenuItemPreAssociated: TMenuItem;
      MenuItemPreCustom: TMenuItem;
      MenuItemERPeaZip: TMenuItem;
      MenuItemERAssociated: TMenuItem;
      mRecent4: TMenuItem;
      mRecent3: TMenuItem;
      mRecent2: TMenuItem;
      mRecent1: TMenuItem;
      mRecent8: TMenuItem;
      mRecent7: TMenuItem;
      mRecent6: TMenuItem;
      mRecent5: TMenuItem;
      mInvertSelection: TMenuItem;
      mSelectAll: TMenuItem;
      MenuItemOpen_preview: TMenuItem;
      MenuItemOpenWeb: TMenuItem;
      MenuItemOpen_test_all: TMenuItem;
      MenuItemOpen_test_selected: TMenuItem;
      MenuItemOpen_test_displayed: TMenuItem;
      MenuItemOpen_test: TMenuItem;
      MenuItemOpen_info: TMenuItem;
      MenuItemOpen_spacer5: TMenuItem;
      pmOpenPJdisplayed: TMenuItem;
      pmOpenPJselected: TMenuItem;
      pmOpenPJall: TMenuItem;
      pmOpenPJ: TPopupMenu;
      MenuItem5b: TMenuItem;
      MenuItemOpen_extandopenwith: TMenuItem;
      NotebookOpt: TPanel;
      PanelArchive: TPanel;
      PanelBarOpen: TPanel;
      PanelOptions: TPanel;
      PanelOpen: TPanel;
      pmSaveList: TMenuItem;
      pmLoadList: TMenuItem;
      pmAddFolder: TMenuItem;
      pmAddFile: TMenuItem;
      MenuItem3: TMenuItem;
      mPEA: TMenuItem;
      mFeatures: TMenuItem;
      mHelp: TMenuItem;
      mOptionsMenu: TMenuItem;
      OpenDialogLang: TOpenDialog;
      OpenDialogList: TOpenDialog;
      OpenDialogArchive: TOpenDialog;
      PopupLayout: TPopupMenu;
      PopupOpen: TPopupMenu;
      SaveDialogAS: TSaveDialog;
      SaveDialogPJ: TSaveDialog;
      SelectDirectoryDialog1: TSelectDirectoryDialog;
      TimerSync: TTimer;
      TreeViewTmp: TTreeView;
      procedure abc0Click(Sender: TObject);
      procedure abc1Click(Sender: TObject);
      procedure abc2Click(Sender: TObject);
      procedure abc3Click(Sender: TObject);
      procedure abc4Click(Sender: TObject);
      procedure abc5Click(Sender: TObject);
      procedure abc6Click(Sender: TObject);
      procedure abc7Click(Sender: TObject);
      procedure abc8Click(Sender: TObject);
      procedure cbautobrowsetarChange(Sender: TObject);
      procedure cbshowhiddenClick(Sender: TObject);
      procedure CheckBoxZstdErrPolicyClick(Sender: TObject);
      procedure ComboBoxPAQThreadsChange(Sender: TObject);
      procedure ComboBoxVirtualChange(Sender: TObject);
      procedure EditOptSearchEditingDone(Sender: TObject);
      procedure f11fullscreenExecute(Sender: TObject);
      procedure f9pwpromptExecute(Sender: TObject);
      procedure aowcustom10Click(Sender: TObject);
      procedure aowcustom11Click(Sender: TObject);
      procedure aowcustom12Click(Sender: TObject);
      procedure aowcustom13Click(Sender: TObject);
      procedure aowcustom14Click(Sender: TObject);
      procedure aowcustom15Click(Sender: TObject);
      procedure aowcustom16Click(Sender: TObject);
      procedure aowcustom1Click(Sender: TObject);
      procedure aowcustom2Click(Sender: TObject);
      procedure aowcustom3Click(Sender: TObject);
      procedure aowcustom4Click(Sender: TObject);
      procedure aowcustom5Click(Sender: TObject);
      procedure aowcustom6Click(Sender: TObject);
      procedure aowcustom7Click(Sender: TObject);
      procedure aowcustom8Click(Sender: TObject);
      procedure aowcustom9Click(Sender: TObject);
      procedure aowcustom_10Click(Sender: TObject);
      procedure aowcustom_11Click(Sender: TObject);
      procedure aowcustom_12Click(Sender: TObject);
      procedure aowcustom_13Click(Sender: TObject);
      procedure aowcustom_14Click(Sender: TObject);
      procedure aowcustom_15Click(Sender: TObject);
      procedure aowcustom_16Click(Sender: TObject);
      procedure aowcustom_9Click(Sender: TObject);
      procedure baboutbinClick(Sender: TObject);
      procedure baboutchangelogClick(Sender: TObject);
      procedure baboutfaqClick(Sender: TObject);
      procedure baboutlocalhelpClick(Sender: TObject);
      procedure baboutplugindirClick(Sender: TObject);
      procedure baboutthemesClick(Sender: TObject);
      procedure baboutpluginsClick(Sender: TObject);
      procedure baboutremoveunaceClick(Sender: TObject);
      procedure baboutremoveunrarClick(Sender: TObject);
      procedure baboutsupportClick(Sender: TObject);
      procedure babouttosClick(Sender: TObject);
      procedure babouttrackerClick(Sender: TObject);
      procedure babouttranslationsClick(Sender: TObject);
      procedure baboutupClick(Sender: TObject);
      procedure baboutwebClick(Sender: TObject);
      procedure BScheduleExtClick(Sender: TObject);
      procedure BScheduleClick(Sender: TObject);
      procedure ButtonOptOKClick(Sender: TObject);
      procedure ButtonArchiveCancelClick(Sender: TObject);
      procedure ButtoncmtoClick(Sender: TObject);
      procedure ButtonCopyClick(Sender: TObject);
      procedure ButtonCutClick(Sender: TObject);
      procedure ButtonEditDeskClick(Sender: TObject);
      procedure ButtonDupClick(Sender: TObject);
      procedure ButtonOutAddClick(Sender: TObject);
      procedure MenuItemERBrowserClick(Sender: TObject);
      procedure MenuItemForceThumbnailsClick(Sender: TObject);
      procedure MenuItemPreBrowserClick(Sender: TObject);
      procedure MenuItemCopypathsMenuClick(Sender: TObject);
      procedure MenuItemViewImageClick(Sender: TObject);
      procedure pmfun25Click(Sender: TObject);
      procedure pmfun26Click(Sender: TObject);
      procedure pmfun27Click(Sender: TObject);
      procedure pmfun28Click(Sender: TObject);
      procedure pmfun29Click(Sender: TObject);
      procedure pmfun30Click(Sender: TObject);
      procedure pmfun31Click(Sender: TObject);
      procedure pmfun32Click(Sender: TObject);
      procedure pmfun33Click(Sender: TObject);
      procedure pmfun34Click(Sender: TObject);
      procedure pmfun35Click(Sender: TObject);
      procedure po_open_browserClick(Sender: TObject);
      procedure SpeedButtonAddClick(Sender: TObject);
      procedure ButtonEditNameAddClick(Sender: TObject);
      procedure ButtonCustomExtClick(Sender: TObject);
      procedure ButtonEditNameOutExtractClick(Sender: TObject);
      procedure ButtonOpenCustomClick(Sender: TObject);
      procedure ButtonEditNameCustomExtClick(Sender: TObject);
      procedure ButtonExtCancelClick(Sender: TObject);
      procedure ButtonExtOkClick(Sender: TObject);
      procedure Buttonfmactions1Click(Sender: TObject);
      procedure ButtonfmactionsClick(Sender: TObject);
      procedure ButtonImgRClick(Sender: TObject);
      procedure ButtonImgResClick(Sender: TObject);
      procedure ButtonImgResizeClick(Sender: TObject);
      procedure ButtonImgCropClick(Sender: TObject);
      procedure ButtonImgRLClick(Sender: TObject);
      procedure ButtonImgRRClick(Sender: TObject);
      procedure ButtonImg6Click(Sender: TObject);
      procedure ButtonNFClick(Sender: TObject);
      procedure ButtonopenactionsClick(Sender: TObject);
      procedure ButtonOpenWithClick(Sender: TObject);
      procedure ButtonPasteClick(Sender: TObject);
      procedure ButtonPropertiesClick(Sender: TObject);
      procedure ButtonDeleteClick(Sender: TObject);
      procedure ButtonRenameClick(Sender: TObject);
      procedure ButtonOutExtractClick(Sender: TObject);
      procedure ButtonAddActionsClick(Sender: TObject);
      procedure ButtonAddActionsMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonUn7zaAddMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonUn7zaConvertClick(Sender: TObject);
      procedure ButtonUn7zaConvertMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonPropertiesActionsClick(Sender: TObject);
      procedure ButtonExtractActionsClick(Sender: TObject);
      procedure ButtonConvertActionsClick(Sender: TObject);
      procedure ButtonConvertActionsMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ButtonTestActionsClick(Sender: TObject);
      procedure cbAdvfAddClick(Sender: TObject);
      procedure cbAdvfExtClick(Sender: TObject);
      procedure cbautoclosesingleextractClick(Sender: TObject);
      procedure cbCustomExtensionClick(Sender: TObject);
      procedure cbdefaultactionChange(Sender: TObject);
      procedure cbDeleteInputModeAddChange(Sender: TObject);
      procedure cbDeleteInputModeExtChange(Sender: TObject);
      procedure cbEncExtensionClick(Sender: TObject);
      procedure cbEncodingChange(Sender: TObject);
      procedure cbSmallIconSizeChange(Sender: TObject);
      procedure cbExtEvForHowChange(Sender: TObject);
      procedure cbExtEvForWhenChange(Sender: TObject);
      procedure cbforcetypeChange(Sender: TObject);
      procedure cbRAR5Click(Sender: TObject);
      procedure cbRARmanualClick(Sender: TObject);
      procedure cbRARBLAKE2Click(Sender: TObject);
      procedure cbRARClick(Sender: TObject);
      procedure cbRARlastmodtimeChange(Sender: TObject);
      procedure cbRARlockClick(Sender: TObject);
      procedure cbRARrrClick(Sender: TObject);
      procedure cbRARsaveopenClick(Sender: TObject);
      procedure cbRARsavesecurityClick(Sender: TObject);
      procedure cbRARsavestreamsClick(Sender: TObject);
      procedure cbRARsfxClick(Sender: TObject);
      procedure cbRARsolidClick(Sender: TObject);
      procedure cbtarpipeClick(Sender: TObject);
      procedure cbuntarpipeClick(Sender: TObject);
      procedure cbBoxAltBarStyleChange(Sender: TObject);
      procedure CheckBoxUTCClick(Sender: TObject);
      procedure ComboBoxPEAKDFwChange(Sender: TObject);
      procedure ComboBoxPEAKDFChange(Sender: TObject);
      procedure csbdeskClick(Sender: TObject);
      procedure csbdocClick(Sender: TObject);
      procedure csbdownloadsClick(Sender: TObject);
      procedure csbhomeClick(Sender: TObject);
      procedure csbmusicClick(Sender: TObject);
      procedure csbpicClick(Sender: TObject);
      procedure csbrootClick(Sender: TObject);
      procedure cbtimecreatedClick(Sender: TObject);
      procedure cbtreeChange(Sender: TObject);
      procedure cbspacingChange(Sender: TObject);
      procedure cbzoomingChange(Sender: TObject);
      procedure CheckBoxExtNotArchivesClick(Sender: TObject);
      procedure CheckBoxExtUnsupportedClick(Sender: TObject);
      procedure CheckBoxExtUnsupportedPeaZipClick(Sender: TObject);
      procedure CheckBox7zunrar5Click(Sender: TObject);
      procedure cbAccentToolBarChange(Sender: TObject);
      procedure CheckBoxACClick(Sender: TObject);
      procedure cbAltBarChange(Sender: TObject);
      procedure cbAltTabStyleChange(Sender: TObject);
      procedure cbAltTabsChange(Sender: TObject);
      procedure CheckBoxARCabsClick(Sender: TObject);
      procedure CheckBoxMailAddClick(Sender: TObject);
      procedure CheckBoxAutoExtTarConvertClick(Sender: TObject);
      procedure CheckBoxAutoExtTarClick(Sender: TObject);
      procedure CheckBoxAutoOpenTarClick(Sender: TObject);
      procedure CheckBoxAutoTestClick(Sender: TObject);
      procedure CheckBoxBrotliClick(Sender: TObject);
      procedure CheckBoxBrowseNotVerboseClick(Sender: TObject);
      procedure CheckBoxCenteredToolbarClick(Sender: TObject);
      procedure CheckBoxClosePeaZipClick(Sender: TObject);
      procedure CheckBoxConvertPWChange(Sender: TObject);
      procedure CheckBoxConvertVerboseChange(Sender: TObject);
      procedure CheckBoxConvertChange(Sender: TObject);
      procedure CheckBoxDateClick(Sender: TObject);
      procedure CheckBoxDeleteInputAddClick(Sender: TObject);
      procedure CheckBoxDeleteInputExtClick(Sender: TObject);
      procedure CheckBoxDragDropClick(Sender: TObject);
      procedure CheckBoxEditArchivesChange(Sender: TObject);
      procedure CheckBoxEnumdClick(Sender: TObject);
      procedure CheckBoxExcludeEFClick(Sender: TObject);
      procedure CheckBoxExtAndClick(Sender: TObject);
      procedure CheckBoxExtrac32Click(Sender: TObject);
      procedure CheckBoxSmartFolderClick(Sender: TObject);
      procedure CheckBoxForceBrowseClick(Sender: TObject);
      procedure CheckBoxForceConvertClick(Sender: TObject);
      procedure CheckBoxForceEditClick(Sender: TObject);
      procedure CheckBoxForceLayoutClick(Sender: TObject);
      procedure CheckBoxForceOpenClick(Sender: TObject);
      procedure CheckBoxIntDirClick(Sender: TObject);
      procedure CheckBoxMailKeepClick(Sender: TObject);
      procedure CheckBoxSolidExtensionClick(Sender: TObject);
      procedure CheckBoxNameAsParentFolderClick(Sender: TObject);
      procedure CheckBoxnetworkinfoClick(Sender: TObject);
      procedure CheckBoxNoConfClick(Sender: TObject);
      procedure CheckBoxrelativeClick(Sender: TObject);
      procedure CheckBoxSameArcClick(Sender: TObject);
      procedure CheckBoxSameExtClick(Sender: TObject);
      procedure CheckBoxShowVolatileClick(Sender: TObject);
      procedure CheckBoxSkipDelClick(Sender: TObject);
      procedure CheckBoxSkipencClick(Sender: TObject);
      procedure CheckBoxsnhClick(Sender: TObject);
      procedure CheckBoxsniExtClick(Sender: TObject);
      procedure CheckBoxsniClick(Sender: TObject);
      procedure CheckBoxsnlClick(Sender: TObject);
      procedure CheckBoxsnoiClick(Sender: TObject);
      procedure CheckBoxsnonClick(Sender: TObject);
      procedure CheckBoxsnsExtClick(Sender: TObject);
      procedure CheckBoxsnsClick(Sender: TObject);
      procedure CheckBoxsnzExtClick(Sender: TObject);
      procedure cbSolidAddressChange(Sender: TObject);
      procedure CheckBoxsspClick(Sender: TObject);
      procedure CheckBoxstlClick(Sender: TObject);
      procedure CheckBoxARCsfxClick(Sender: TObject);
      procedure CheckBoxAutoOpenClick(Sender: TObject);
      procedure CheckBoxClipClick(Sender: TObject);
      procedure CheckBoxEncodingClick(Sender: TObject);
      procedure CheckBoxFolderClick(Sender: TObject);
      procedure CheckBoxJobEncodingClick(Sender: TObject);
      procedure CheckBoxParallelArchivingClick(Sender: TObject);
      procedure CheckBoxSeparateClick(Sender: TObject);
      procedure CheckBoxAltgridcolClick(Sender: TObject);
      procedure CheckBoxzcopyClick(Sender: TObject);
      procedure CheckBoxzipxswitchClick(Sender: TObject);
      procedure CheckBoxzpaqabsoluteClick(Sender: TObject);
      procedure CheckBoxzpaqallClick(Sender: TObject);
      procedure CheckBoxzpaqforceClick(Sender: TObject);
      procedure CheckBoxzpaqfullClick(Sender: TObject);
      procedure CheckBoxZstdClick(Sender: TObject);
      procedure CheckGroupM1ItemClick(Sender: TObject; Index: integer);
      procedure CheckGroupMExtItemClick(Sender: TObject; Index: integer);
      procedure CheckGroupWExtItemClick(Sender: TObject; Index: integer);
      procedure CheckGroupWItemClick(Sender: TObject; Index: integer);
      procedure ColorButton2ColorChanged(Sender: TObject);
      procedure ColorButton3ColorChanged(Sender: TObject);
      procedure ComboBoxConsoleEncodingChange(Sender: TObject);
      procedure ComboBoxSplitChange(Sender: TObject);
      procedure ComboBox7zMethodCloseUp(Sender: TObject);
      procedure ComboBox7zLevelCloseUp(Sender: TObject);
      procedure cbLevelCloseUp(Sender: TObject);
      procedure ComboBoxBrowserChange(Sender: TObject);
      procedure ComboBoxDragChange(Sender: TObject);
      procedure ComboBoxKiBChange(Sender: TObject);
      procedure ComboBoxLanguageCloseUp(Sender: TObject);
      procedure ComboBoxMaxArgChange(Sender: TObject);
      procedure ComboBox7zMemuseChange(Sender: TObject);
      procedure ComboBoxPriorityChange(Sender: TObject);
      procedure ComboBoxSysbinChange(Sender: TObject);
      procedure ComboBoxSyntaxLevelChange(Sender: TObject);
      procedure ComboBoxTARTSChange(Sender: TObject);
      procedure ComboBoxTARChange(Sender: TObject);
      procedure ComboBoxWDChange(Sender: TObject);
      procedure ComboBoxARCFunChange(Sender: TObject);
      procedure ComboBox7zFunChange(Sender: TObject);
      procedure ComboBox7zThreadsChange(Sender: TObject);
      procedure ComboBoxArchiveActUpdateChange(Sender: TObject);
      procedure cbActChange(Sender: TObject);
      procedure ComboBoxLibreChange(Sender: TObject);
      procedure ComboBoxprivacyChange(Sender: TObject);
      procedure ComboBoxSDChange(Sender: TObject);
      procedure comboRARdictChange(Sender: TObject);
      procedure csbvidClick(Sender: TObject);
      procedure ctrlarcClick(Sender: TObject);
      procedure ctrlextClick(Sender: TObject);
      procedure ctrlwarningClick(Sender: TObject);
      procedure DateEdit1Change(Sender: TObject);
      procedure DateEdit2Change(Sender: TObject);
      procedure DateEditExt1Change(Sender: TObject);
      procedure DateEditExt2Change(Sender: TObject);
      procedure EditAddNameChange(Sender: TObject);
      procedure EditOpenInInteractiveExit(Sender: TObject);
      procedure EditOpenInInteractiveKeyPress(Sender: TObject; var Key: char);
      procedure EditOpenInInteractiveKeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure EditOpenInChange(Sender: TObject);
      procedure EditOutExtractChange(Sender: TObject);
      procedure EditUn7zaFilterInteractiveKeyPress(Sender: TObject; var Key: char);
      procedure EditUn7zaFilterChange(Sender: TObject);
      procedure eowcustom10Click(Sender: TObject);
      procedure eowcustom11Click(Sender: TObject);
      procedure eowcustom12Click(Sender: TObject);
      procedure eowcustom13Click(Sender: TObject);
      procedure eowcustom14Click(Sender: TObject);
      procedure eowcustom15Click(Sender: TObject);
      procedure eowcustom16Click(Sender: TObject);
      procedure eowcustom1Click(Sender: TObject);
      procedure eowcustom2Click(Sender: TObject);
      procedure eowcustom3Click(Sender: TObject);
      procedure eowcustom4Click(Sender: TObject);
      procedure eowcustom5Click(Sender: TObject);
      procedure eowcustom6Click(Sender: TObject);
      procedure eowcustom7Click(Sender: TObject);
      procedure eowcustom8Click(Sender: TObject);
      procedure eowcustom9Click(Sender: TObject);
      procedure eowcustom_10Click(Sender: TObject);
      procedure eowcustom_11Click(Sender: TObject);
      procedure eowcustom_12Click(Sender: TObject);
      procedure eowcustom_13Click(Sender: TObject);
      procedure eowcustom_14Click(Sender: TObject);
      procedure eowcustom_15Click(Sender: TObject);
      procedure eowcustom_16Click(Sender: TObject);
      procedure eowcustom_9Click(Sender: TObject);
      procedure eowrunClick(Sender: TObject);
      procedure extalllastClick(Sender: TObject);
      procedure f3searchExecute(Sender: TObject);
      procedure f4menuExecute(Sender: TObject);
      procedure f5refreshExecute(Sender: TObject);
      procedure f8openbook1Execute(Sender: TObject);
      procedure fextallfav2Click(Sender: TObject);
      procedure fextallfav3Click(Sender: TObject);
      procedure fextallfav4Click(Sender: TObject);
      procedure fextallfav5Click(Sender: TObject);
      procedure fextallfav6Click(Sender: TObject);
      procedure fextallfav7Click(Sender: TObject);
      procedure fextallfav8Click(Sender: TObject);
      procedure fextallfav1Click(Sender: TObject);
      procedure fextalldefaultClick(Sender: TObject);
      procedure f6flatExecute(Sender: TObject);
      procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
      procedure FormResize(Sender: TObject);
      procedure FormShow(Sender: TObject);
      procedure ImageBCtextClick(Sender: TObject);
      procedure ImageBCtextMouseEnter(Sender: TObject);
      procedure ImageBCtextMouseLeave(Sender: TObject);
      procedure ImageFlatcropClick(Sender: TObject);
      procedure ImageFlatdupClick(Sender: TObject);
      procedure ImageFlatfolderClick(Sender: TObject);
      procedure ImageFlatrenClick(Sender: TObject);
      procedure ImageFlattestmoreClick(Sender: TObject);
      procedure ImageFlattransformClick(Sender: TObject);
      procedure Imagesp1Click(Sender: TObject);
      procedure ImagespClick(Sender: TObject);
      procedure LabelCommentClick(Sender: TObject);
      procedure LabelExtHereClick(Sender: TObject);
      procedure LabelWDClick(Sender: TObject);
      procedure LabelAddFilesClick(Sender: TObject);
      procedure LabelAddFolderClick(Sender: TObject);
      procedure LabelCustomDesktopClick(Sender: TObject);
      procedure LabelColPresetsClick(Sender: TObject);
      procedure LabelConfigurePwClick(Sender: TObject);
      procedure LabelDefaultColor3Click(Sender: TObject);
      procedure LabellightpresetsClick(Sender: TObject);
      procedure LabelErrorsClick(Sender: TObject);
      procedure LabelmoreoptExtClick(Sender: TObject);
      procedure cbqdupClick(Sender: TObject);
      procedure LabelPMpwClick(Sender: TObject);
      procedure LabelsetworkClick(Sender: TObject);
      procedure LabelStatusArClick(Sender: TObject);
      procedure LabelStatusArMouseEnter(Sender: TObject);
      procedure LabelStatusClick(Sender: TObject);
      procedure LabelStatusdisplayedClick(Sender: TObject);
      procedure LabelStatusdisplayedMouseEnter(Sender: TObject);
      procedure LabelStatusExClick(Sender: TObject);
      procedure LabelStatusExMouseEnter(Sender: TObject);
      procedure LabelStatusMouseEnter(Sender: TObject);
      procedure LabelThemeClick(Sender: TObject);
      procedure LabelTitleOptions2Click(Sender: TObject);
      procedure LabelTitleOptions2MouseEnter(Sender: TObject);
      procedure LabelTitleOptions2MouseLeave(Sender: TObject);
      procedure layoutmotwfullClick(Sender: TObject);
      procedure lightdimClick(Sender: TObject);
      procedure lightgraphiteClick(Sender: TObject);
      procedure lightmochaClick(Sender: TObject);
      procedure lightplumClick(Sender: TObject);
      procedure lightsenapeClick(Sender: TObject);
      procedure ListViewBrowserContextPopup(Sender: TObject; MousePos: TPoint;
        var Handled: Boolean);
      procedure ListViewBrowserData(Sender: TObject; Item: TListItem);
      procedure ListViewBrowserEdited(Sender: TObject; Item: TListItem;
        var AValue: string);
      procedure ListViewBrowserMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure lsetdefaultout_arcClick(Sender: TObject);
      procedure lsetdefaultout_extClick(Sender: TObject);
      procedure mautoadjustClick(Sender: TObject);
      procedure mBenchpeaClick(Sender: TObject);
      procedure mbgnome4Click(Sender: TObject);
      procedure mbgnomeClick(Sender: TObject);
      procedure mbkdeClick(Sender: TObject);
      procedure mbmacClick(Sender: TObject);
      procedure mbrowsercaccessedClick(Sender: TObject);
      procedure mbrowserccommentClick(Sender: TObject);
      procedure mbrowserccreatedClick(Sender: TObject);
      procedure mbrowsercmethodClick(Sender: TObject);
      procedure mbtextClick(Sender: TObject);
      procedure mcaccessedClick(Sender: TObject);
      procedure marcoptClick(Sender: TObject);
      procedure mccommentClick(Sender: TObject);
      procedure mccreatedClick(Sender: TObject);
      procedure mcommentClick(Sender: TObject);
      procedure mcommentrarClick(Sender: TObject);
      procedure mdefarcsetClick(Sender: TObject);
      procedure mdefextsetClick(Sender: TObject);
      procedure mcmethodClick(Sender: TObject);
      procedure lightlowClick(Sender: TObject);
      procedure mdirbeforefilesClick(Sender: TObject);
      procedure mdownloadthemesClick(Sender: TObject);
      procedure layoutmotwClick(Sender: TObject);
      procedure MenuItemToolsjClick(Sender: TObject);
      procedure mshowhiddenClick(Sender: TObject);
      procedure pmmoreshajClick(Sender: TObject);
      procedure po_lingdisksClick(Sender: TObject);
      procedure po_linglogsClick(Sender: TObject);
      procedure po_linlshwClick(Sender: TObject);
      procedure po_motwfullClick(Sender: TObject);
      procedure pmmoremotwClick(Sender: TObject);
      procedure po_checkmotwClick(Sender: TObject);
      procedure MenuItemToolAnalyzeClick(Sender: TObject);
      procedure MenuItemToolBlake2sClick(Sender: TObject);
      procedure MenuItemToolCrc32Click(Sender: TObject);
      procedure MenuItemToolMD5Click(Sender: TObject);
      procedure MenuItemToolsgClick(Sender: TObject);
      procedure MenuItemToolSHA1Click(Sender: TObject);
      procedure MenuItemToolSHA256Click(Sender: TObject);
      procedure MenuItemToolsvClick(Sender: TObject);
      procedure MenuItemTooltextpClick(Sender: TObject);
      procedure mexploretrashClick(Sender: TObject);
      procedure mhextracttoClick(Sender: TObject);
      procedure msizetoggleClick(Sender: TObject);
      procedure munsavecopyClick(Sender: TObject);
      procedure mz100Click(Sender: TObject);
      procedure mz115Click(Sender: TObject);
      procedure mz125Click(Sender: TObject);
      procedure mz150Click(Sender: TObject);
      procedure mz175Click(Sender: TObject);
      procedure mz200Click(Sender: TObject);
      procedure mz50Click(Sender: TObject);
      procedure mz67Click(Sender: TObject);
      procedure mz80Click(Sender: TObject);
      procedure mz87Click(Sender: TObject);
      procedure pmextherehereClick(Sender: TObject);
      procedure pmextherenewClick(Sender: TObject);
      procedure pmextheresmartClick(Sender: TObject);
      procedure pmfun19Click(Sender: TObject);
      procedure pmfun20Click(Sender: TObject);
      procedure pmfun21Click(Sender: TObject);
      procedure pmfun22Click(Sender: TObject);
      procedure pmfun23Click(Sender: TObject);
      procedure pmfun24Click(Sender: TObject);
      procedure pmintddnewClick(Sender: TObject);
      procedure pmintddhereClick(Sender: TObject);
      procedure mexttob1Click(Sender: TObject);
      procedure mexttob2Click(Sender: TObject);
      procedure mexttob3Click(Sender: TObject);
      procedure mexttob4Click(Sender: TObject);
      procedure mexttob5Click(Sender: TObject);
      procedure mexttob6Click(Sender: TObject);
      procedure mexttob7Click(Sender: TObject);
      procedure mexttob8Click(Sender: TObject);
      procedure mexttoc1Click(Sender: TObject);
      procedure mexttoc2Click(Sender: TObject);
      procedure mexttoc3Click(Sender: TObject);
      procedure mexttoc4Click(Sender: TObject);
      procedure mexttoc5Click(Sender: TObject);
      procedure mexttoc6Click(Sender: TObject);
      procedure mexttoc7Click(Sender: TObject);
      procedure mexttoc8Click(Sender: TObject);
      procedure mexttoh1Click(Sender: TObject);
      procedure mexttoh2Click(Sender: TObject);
      procedure mexttoh3Click(Sender: TObject);
      procedure mexttoh4Click(Sender: TObject);
      procedure mexttoh5Click(Sender: TObject);
      procedure mexttoh6Click(Sender: TObject);
      procedure mexttoh7Click(Sender: TObject);
      procedure mexttoh8Click(Sender: TObject);
      procedure mexttos1Click(Sender: TObject);
      procedure mexttos2Click(Sender: TObject);
      procedure mexttos3Click(Sender: TObject);
      procedure mexttos4Click(Sender: TObject);
      procedure mexttos5Click(Sender: TObject);
      procedure mexttos6Click(Sender: TObject);
      procedure mexttos7Click(Sender: TObject);
      procedure mexttos8Click(Sender: TObject);
      procedure mFlatArchivesClick(Sender: TObject);
      procedure mloadprofileClick(Sender: TObject);
      procedure msaveprofileClick(Sender: TObject);
      procedure mshowsidebarClick(Sender: TObject);
      procedure msidebarClick(Sender: TObject);
      procedure msmartsortClick(Sender: TObject);
      procedure pmflatarchivesClick(Sender: TObject);
      procedure pmintddsmartClick(Sender: TObject);
      procedure pmmoreblake2bsaveClick(Sender: TObject);
      procedure pmmorecksaveClick(Sender: TObject);
      procedure pmmoremd5saveClick(Sender: TObject);
      procedure pmmoresha1saveClick(Sender: TObject);
      procedure pmmoreshagClick(Sender: TObject);
      procedure pmmoreshasaveClick(Sender: TObject);
      procedure pmmoreshavClick(Sender: TObject);
      procedure pmmoretextClick(Sender: TObject);
      procedure pmspclassicClick(Sender: TObject);
      procedure pmspminimalClick(Sender: TObject);
      procedure pmspmodernClick(Sender: TObject);
      procedure pmspoldClick(Sender: TObject);
      procedure pmsppostmodernClick(Sender: TObject);
      procedure pmsaveascsvlClick(Sender: TObject);
      procedure pmsaveastsvClick(Sender: TObject);
      procedure pmsaveastxtClick(Sender: TObject);
      procedure pmscommentClick(Sender: TObject);
      procedure pmscompactClick(Sender: TObject);
      procedure pmsinfoClick(Sender: TObject);
      procedure pmsizelargeClick(Sender: TObject);
      procedure pmsizelargepClick(Sender: TObject);
      procedure pmsizelargeppClick(Sender: TObject);
      procedure pmsizelargepppClick(Sender: TObject);
      procedure pmsizelargeppppClick(Sender: TObject);
      procedure pmsizemediumClick(Sender: TObject);
      procedure pmsizesmallClick(Sender: TObject);
      procedure pmsoparchClick(Sender: TObject);
      procedure pmsoppathClick(Sender: TObject);
      procedure pmtabsreopenClick(Sender: TObject);
      procedure po_ntfsadsClick(Sender: TObject);
      procedure po_ntfsziClick(Sender: TObject);
      procedure po_s256jClick(Sender: TObject);
      procedure po_savecopyClick(Sender: TObject);
      procedure po_sha1sumClick(Sender: TObject);
      procedure pow10appsClick(Sender: TObject);
      procedure pow10dappsClick(Sender: TObject);
      procedure pow10defenderClick(Sender: TObject);
      procedure pow10settingsClick(Sender: TObject);
      procedure pow10storageClick(Sender: TObject);
      procedure po_b2sumClick(Sender: TObject);
      procedure po_cksumClick(Sender: TObject);
      procedure po_gnometmClick(Sender: TObject);
      procedure po_kdetmClick(Sender: TObject);
      procedure po_md5sumClick(Sender: TObject);
      procedure po_s256gClick(Sender: TObject);
      procedure po_s256vClick(Sender: TObject);
      procedure po_sha256sumClick(Sender: TObject);
      procedure po_textpClick(Sender: TObject);
      procedure ComboBoxsecChange(Sender: TObject);
      procedure StringGridBookmarksDragOver(Sender, Source: TObject; X,
        Y: Integer; State: TDragState; var Accept: Boolean);
      procedure Timerrename1Timer(Sender: TObject);
      procedure TreeViewNavDragOver(Sender, Source: TObject; X, Y: Integer;
        State: TDragState; var Accept: Boolean);
      procedure zenc1250Click(Sender: TObject);
      procedure zenc1251Click(Sender: TObject);
      procedure zenc1252Click(Sender: TObject);
      procedure zenc1253Click(Sender: TObject);
      procedure zenc1254Click(Sender: TObject);
      procedure zenc1255Click(Sender: TObject);
      procedure zenc1256Click(Sender: TObject);
      procedure zenc1257Click(Sender: TObject);
      procedure zenc1258Click(Sender: TObject);
      procedure zenc20866Click(Sender: TObject);
      procedure zenc21866Click(Sender: TObject);
      procedure zenc65001Click(Sender: TObject);
      procedure zenc850Click(Sender: TObject);
      procedure zenc852Click(Sender: TObject);
      procedure zenc858Click(Sender: TObject);
      procedure zenc866Click(Sender: TObject);
      procedure zenc874Click(Sender: TObject);
      procedure zenc932Click(Sender: TObject);
      procedure zenc936Click(Sender: TObject);
      procedure zenc949Click(Sender: TObject);
      procedure zenc950Click(Sender: TObject);
      procedure zenclocalClick(Sender: TObject);
      procedure zenclocalutf8Click(Sender: TObject);
      procedure zencmoreClick(Sender: TObject);
      procedure pmtabsaveClick(Sender: TObject);
      procedure MenuItemShowColMenuClick(Sender: TObject);
      procedure MenuItemToggleNavClick(Sender: TObject);
      procedure mpeachangelogClick(Sender: TObject);
      procedure mpeatosClick(Sender: TObject);
      procedure mswaptabClick(Sender: TObject);
      procedure mtranslationsfaqClick(Sender: TObject);
      procedure BtnStyleClick(Sender: TObject);
      procedure BtnStyleMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure pmadvfClick(Sender: TObject);
      procedure pmbcnwClick(Sender: TObject);
      procedure pmccommentClick(Sender: TObject);
      procedure pmclipClick(Sender: TObject);
      procedure pmembf1Click(Sender: TObject);
      procedure pmembf2Click(Sender: TObject);
      procedure pmembf3Click(Sender: TObject);
      procedure pmembf4Click(Sender: TObject);
      procedure pmembf5Click(Sender: TObject);
      procedure pmembf6Click(Sender: TObject);
      procedure pmembf7Click(Sender: TObject);
      procedure pmembf8Click(Sender: TObject);
      procedure pmemrf1Click(Sender: TObject);
      procedure pmemrf2Click(Sender: TObject);
      procedure pmemrf3Click(Sender: TObject);
      procedure pmemrf4Click(Sender: TObject);
      procedure pmemrf5Click(Sender: TObject);
      procedure pmemrf6Click(Sender: TObject);
      procedure pmemrf7Click(Sender: TObject);
      procedure pmemrf8Click(Sender: TObject);
      procedure pmmoreaddClick(Sender: TObject);
      procedure pmmorecommentzipClick(Sender: TObject);
      procedure pmmoreconvertClick(Sender: TObject);
      procedure pmmoreextractClick(Sender: TObject);
      procedure pmmoretestClick(Sender: TObject);
      procedure mdefaultextractClick(Sender: TObject);
      procedure pmshowstylemenuClick(Sender: TObject);
      procedure pmtabscloseallClick(Sender: TObject);
      procedure pmtabsnewwindowClick(Sender: TObject);
      procedure pmtoolcompactClick(Sender: TObject);
      procedure pnbce1Click(Sender: TObject);
      procedure pnbce2Click(Sender: TObject);
      procedure pnbce3Click(Sender: TObject);
      procedure pnbce4Click(Sender: TObject);
      procedure pnbce5Click(Sender: TObject);
      procedure pnbce6Click(Sender: TObject);
      procedure pnbce7Click(Sender: TObject);
      procedure pnbce8Click(Sender: TObject);
      procedure pnbcf1Click(Sender: TObject);
      procedure pnbcf2Click(Sender: TObject);
      procedure pnbcf3Click(Sender: TObject);
      procedure pnbcf4Click(Sender: TObject);
      procedure pnbcf5Click(Sender: TObject);
      procedure pnbcf6Click(Sender: TObject);
      procedure pnbcf7Click(Sender: TObject);
      procedure pnbcf8Click(Sender: TObject);
      procedure pnhe1Click(Sender: TObject);
      procedure pnhe2Click(Sender: TObject);
      procedure pnhe3Click(Sender: TObject);
      procedure pnhe4Click(Sender: TObject);
      procedure pnhe5Click(Sender: TObject);
      procedure pnhe6Click(Sender: TObject);
      procedure pnhe7Click(Sender: TObject);
      procedure pnhe8Click(Sender: TObject);
      procedure pnhf1Click(Sender: TObject);
      procedure pnhf2Click(Sender: TObject);
      procedure pnhf3Click(Sender: TObject);
      procedure pnhf4Click(Sender: TObject);
      procedure pnhf5Click(Sender: TObject);
      procedure pnhf6Click(Sender: TObject);
      procedure pnhf7Click(Sender: TObject);
      procedure pnhf8Click(Sender: TObject);
      procedure po_addsepClick(Sender: TObject);
      procedure MenuItemInfoClick(Sender: TObject);
      procedure MenuItemInfomenuClick(Sender: TObject);
      procedure MenuItemToggleStatusClick(Sender: TObject);
      procedure menupwClick(Sender: TObject);
      procedure msettingsClick(Sender: TObject);
      procedure mshownavbarClick(Sender: TObject);
      procedure mshowstatusbarClick(Sender: TObject);
      procedure mshowtoolbarClick(Sender: TObject);
      procedure pmquickdownloadsClick(Sender: TObject);
      procedure pmsnoClick(Sender: TObject);
      procedure pmsstatusClick(Sender: TObject);
      procedure pmstatusnoneClick(Sender: TObject);
      procedure pmtoollargeClick(Sender: TObject);
      procedure pmtoolmediumClick(Sender: TObject);
      procedure pmtoolnoneClick(Sender: TObject);
      procedure pmtoolsmallClick(Sender: TObject);
      procedure pmshowmainmenuClick(Sender: TObject);
      procedure mverifyselfClick(Sender: TObject);
      procedure pmhnewtabClick(Sender: TObject);
      procedure mfilterbrowserClick(Sender: TObject);
      procedure MenuItemColBeosClick(Sender: TObject);
      procedure MenuItemColMintClick(Sender: TObject);
      procedure MenuItemColUbuntuClick(Sender: TObject);
      procedure MenuItemColWindowsClick(Sender: TObject);
      procedure menuitemopendocumentsClick(Sender: TObject);
      procedure menuitemopendownloadsClick(Sender: TObject);
      procedure mloadlayoutClick(Sender: TObject);
      procedure mprofileimmediateClick(Sender: TObject);
      procedure msamplescriptsClick(Sender: TObject);
      procedure msavelayoutClick(Sender: TObject);
      procedure mTypeClick(Sender: TObject);
      procedure owrunClick(Sender: TObject);
      procedure pmr_filesClick(Sender: TObject);
      procedure pmr_renClick(Sender: TObject);
      procedure pmsaveascsvClick(Sender: TObject);
      procedure pmshowsearchClick(Sender: TObject);
      procedure powRunClick(Sender: TObject);
      procedure po_browserccommentClick(Sender: TObject);
      procedure po_cinnamonsettClick(Sender: TObject);
      procedure po_clipClick(Sender: TObject);
      procedure po_commentzipClick(Sender: TObject);
      procedure po_dedupClick(Sender: TObject);
      procedure po_gnomeccClick(Sender: TObject);
      procedure po_gnomeswClick(Sender: TObject);
      procedure po_kdesyssettClick(Sender: TObject);
      procedure po_lindfhClick(Sender: TObject);
      procedure po_lindushClick(Sender: TObject);
      procedure po_linhistoryClick(Sender: TObject);
      procedure po_linidClick(Sender: TObject);
      procedure po_linipaddressClick(Sender: TObject);
      procedure po_linnetstatClick(Sender: TObject);
      procedure po_linpsefClick(Sender: TObject);
      procedure po_lintopClick(Sender: TObject);
      procedure po_macactClick(Sender: TObject);
      procedure po_macdiskClick(Sender: TObject);
      procedure po_maclaunchClick(Sender: TObject);
      procedure po_macsysClick(Sender: TObject);
      procedure po_openunitasarchivelinClick(Sender: TObject);
      procedure po_dispenvstrlinClick(Sender: TObject);
      procedure MenuItemOpen_runClick(Sender: TObject);
      procedure pmcaccessedClick(Sender: TObject);
      procedure pmccreatedClick(Sender: TObject);
      procedure pmcmethodClick(Sender: TObject);
      procedure po_ftpClick(Sender: TObject);
      procedure po_getmacClick(Sender: TObject);
      procedure mtabClick(Sender: TObject);
      procedure pmqeallClick(Sender: TObject);
      procedure pmqedisplayedClick(Sender: TObject);
      procedure pmqeselectedClick(Sender: TObject);
      procedure pmrowClick(Sender: TObject);
      procedure pmsnavClick(Sender: TObject);
      procedure pmstreeClick(Sender: TObject);
      procedure pmsnoneClick(Sender: TObject);
      procedure MenuItemExtAllHereNewClick(Sender: TObject);
      procedure MenuItemExtAllHereSmartClick(Sender: TObject);
      procedure mextallherenewClick(Sender: TObject);
      procedure mextallheresmartClick(Sender: TObject);
      procedure mextoptClick(Sender: TObject);
      procedure mForceClearClick(Sender: TObject);
      procedure mForceSynceditsClearClick(Sender: TObject);
      procedure mForceSynceditsClick(Sender: TObject);
      procedure mloadcompsettingsClick(Sender: TObject);
      procedure mprofile7zfastClick(Sender: TObject);
      procedure mprofiletargzClick(Sender: TObject);
      procedure mprofiletarxzClick(Sender: TObject);
      procedure mprofileextremezpaqClick(Sender: TObject);
      procedure mprofile7zfastestClick(Sender: TObject);
      procedure mprofileloadClick(Sender: TObject);
      procedure mprofilerarClick(Sender: TObject);
      procedure mprofilesaveClick(Sender: TObject);
      procedure mprofiletarzstClick(Sender: TObject);
      procedure mprofilezstdClick(Sender: TObject);
      procedure msavecompsettingsClick(Sender: TObject);
      procedure mtabsClick(Sender: TObject);
      procedure PanelClickAddressMouseEnter(Sender: TObject);
      procedure pcustmakecabClick(Sender: TObject);
      procedure pmhtabsClick(Sender: TObject);
      procedure pmmorerecoverClick(Sender: TObject);
      procedure pmmorerrClick(Sender: TObject);
      procedure pmpanalyzefoldersClick(Sender: TObject);
      procedure pmqeherenewClick(Sender: TObject);
      procedure pmqeheresmartClick(Sender: TObject);
      procedure pmrshClick(Sender: TObject);
      procedure pmr_123Click(Sender: TObject);
      procedure pmr_appenddirnameClick(Sender: TObject);
      procedure pmr_appendtsClick(Sender: TObject);
      procedure pmr_asciiClick(Sender: TObject);
      procedure pmr_cutClick(Sender: TObject);
      procedure pmr_prependdirnameClick(Sender: TObject);
      procedure pms2a_extClick(Sender: TObject);
      procedure pmstyle1Click(Sender: TObject);
      procedure pmstyle3Click(Sender: TObject);
      procedure pmstyle5Click(Sender: TObject);
      procedure pmtabClick(Sender: TObject);
      procedure pmtabsbookmarkaddClick(Sender: TObject);
      procedure pmtabsbookmarkorgClick(Sender: TObject);
      procedure pmtabscloseotherClick(Sender: TObject);
      procedure pmtabscloserightClick(Sender: TObject);
      procedure pmtabscollapseClick(Sender: TObject);
      procedure pmtabsexpandClick(Sender: TObject);
      procedure pmtabsmClick(Sender: TObject);
      procedure pmtestcontextallClick(Sender: TObject);
      procedure pmtestcontextdisplayedClick(Sender: TObject);
      procedure pmtestcontextselectedClick(Sender: TObject);
      procedure pmthemesClick(Sender: TObject);
      procedure pmtool1Click(Sender: TObject);
      procedure pmtool2Click(Sender: TObject);
      procedure pmtool3Click(Sender: TObject);
      procedure pob_blake2bClick(Sender: TObject);
      procedure pob_blake2sClick(Sender: TObject);
      procedure po_analyzefoldersClick(Sender: TObject);
      procedure po_hostnameClick(Sender: TObject);
      procedure po_ipconfigClick(Sender: TObject);
      procedure po_openfilesClick(Sender: TObject);
      procedure po_pdupClick(Sender: TObject);
      procedure po_quserClick(Sender: TObject);
      procedure po_qwinstaClick(Sender: TObject);
      procedure po_recoverClick(Sender: TObject);
      procedure po_rename_123Click(Sender: TObject);
      procedure po_rename_asciiClick(Sender: TObject);
      procedure po_rename_cutlenClick(Sender: TObject);
      procedure po_rename_filesonlyClick(Sender: TObject);
      procedure po_rrClick(Sender: TObject);
      procedure po_setappstClick(Sender: TObject);
      procedure po_showquicknavmenuClick(Sender: TObject);
      procedure po_smartClick(Sender: TObject);
      procedure po_synapticClick(Sender: TObject);
      procedure po_systeminfoClick(Sender: TObject);
      procedure po_tabsopenClick(Sender: TObject);
      procedure po_verClick(Sender: TObject);
      procedure po_whoamiClick(Sender: TObject);
      procedure po_windowopenClick(Sender: TObject);
      procedure po_xfcesmClick(Sender: TObject);
      procedure cbHashChange(Sender: TObject);
      procedure seRARrrChange(Sender: TObject);
      procedure ShellTreeViewNavMouseEnter(Sender: TObject);
      procedure SpinEditSplitChange(Sender: TObject);
      procedure splitsearchMoved(Sender: TObject);
      procedure StringGridSessionHistoryDblClick(Sender: TObject);
      procedure TabBarContextPopup(Sender: TObject; MousePos: TPoint;
        var Handled: Boolean);
      procedure TabBarMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure TabBarMouseEnter(Sender: TObject);
      procedure TabBarSectionClick(HeaderControl: TCustomHeaderControl;
        Section: THeaderSection);
      procedure TabBarSectionEndDrag(Sender: TObject);
      procedure ImageInfoCustomExtClick(Sender: TObject);
      procedure ImageAdArchive0Click(Sender: TObject);
      procedure ImageAdArchive0MouseEnter(Sender: TObject);
      procedure ImageAdArchive0MouseLeave(Sender: TObject);
      procedure ImageAdArchive1Click(Sender: TObject);
      procedure ImageAdArchive1MouseEnter(Sender: TObject);
      procedure ImageAdArchive1MouseLeave(Sender: TObject);
      procedure ImageAdArchive2Click(Sender: TObject);
      procedure ImageAdArchive2MouseEnter(Sender: TObject);
      procedure ImageAdArchive2MouseLeave(Sender: TObject);
      procedure ImageAdArchive3Click(Sender: TObject);
      procedure ImageAdArchive3MouseEnter(Sender: TObject);
      procedure ImageAdArchive3MouseLeave(Sender: TObject);
      procedure ImageAddress0Click(Sender: TObject);
      procedure ImageAddress0MouseEnter(Sender: TObject);
      procedure ImageAddress0MouseLeave(Sender: TObject);
      procedure ImageAddress1Click(Sender: TObject);
      procedure ImageAddress1MouseEnter(Sender: TObject);
      procedure ImageAddress1MouseLeave(Sender: TObject);
      procedure ImageAddress2Click(Sender: TObject);
      procedure ImageAddress2MouseEnter(Sender: TObject);
      procedure ImageAddress2MouseLeave(Sender: TObject);
      procedure ImageAddress3Click(Sender: TObject);
      procedure ImageAddress3MouseEnter(Sender: TObject);
      procedure ImageAddress3MouseLeave(Sender: TObject);
      procedure ImageAddress4Click(Sender: TObject);
      procedure ImageAddress4MouseEnter(Sender: TObject);
      procedure ImageAddress4MouseLeave(Sender: TObject);
      procedure ImageAddress5Click(Sender: TObject);
      procedure ImageAddress5MouseEnter(Sender: TObject);
      procedure ImageAddress5MouseLeave(Sender: TObject);
      procedure ImageAddress6Click(Sender: TObject);
      procedure ImageAddress6MouseEnter(Sender: TObject);
      procedure ImageAddress6MouseLeave(Sender: TObject);
      procedure ImageAddress7Click(Sender: TObject);
      procedure ImageAddress7MouseEnter(Sender: TObject);
      procedure ImageAddress7MouseLeave(Sender: TObject);
      procedure ImageAddressClick(Sender: TObject);
      procedure ImageInfoConsoleClick(Sender: TObject);
      procedure ImageInfoConsoleExtClick(Sender: TObject);
      procedure ImageInfoSchedAddClick(Sender: TObject);
      procedure ImageInfoSchedExtClick(Sender: TObject);
      procedure ImageInfoBinariesClick(Sender: TObject);
      procedure ImageInfoEncodingClick(Sender: TObject);
      procedure ImageListRootMouseEnter(Sender: TObject);
      procedure ImageListRootMouseLeave(Sender: TObject);
      procedure ImageListResetSearchClick(Sender: TObject);
      procedure ImageListResetSearchMouseEnter(Sender: TObject);
      procedure ImageListResetSearchMouseLeave(Sender: TObject);
      procedure ImageListSearchDblClick(Sender: TObject);
      procedure ImageListSearchMouseEnter(Sender: TObject);
      procedure ImageListSearchMouseLeave(Sender: TObject);
      procedure ImageExtractAdvfClick(Sender: TObject);
      procedure ImageAddAdvfClick(Sender: TObject);
      procedure ImageopenadvfClick(Sender: TObject);
      procedure BtnPasswordArchiveClick(Sender: TObject);
      procedure ButtonOptCancelClick(Sender: TObject);
      procedure ButtonArchiveOKClick(Sender: TObject);
      procedure ButtonEditNameCustomClick(Sender: TObject);
      procedure ButtonUn7zaTestClick(Sender: TObject);
      procedure ButtonUn7zaAddClick(Sender: TObject);
      procedure ButtonUn7zaToClick(Sender: TObject);
      procedure cbTypeChange(Sender: TObject);
      procedure ComboBox7zalgoChange(Sender: TObject);
      procedure ComboBoxArchiveCustom1Change(Sender: TObject);
      procedure ComboBoxArchiveCustomChange(Sender: TObject);
      procedure ComboBoxOverwriteARCChange(Sender: TObject);
      procedure ComboBoxOverwriteChange(Sender: TObject);
      procedure ComboBoxPassesChange(Sender: TObject);
      procedure BtnPasswordExtractClick(Sender: TObject);
      procedure LabelAppPathClick(Sender: TObject);
      procedure LabelOpenDesktopClick(Sender: TObject);
      procedure LabelResetOpenWithClick(Sender: TObject);
      procedure LabelClickAdArchive1Click(Sender: TObject);
      procedure LabelClickAdArchive1MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive1MouseLeave(Sender: TObject);
      procedure LabelClickAdArchive2Click(Sender: TObject);
      procedure LabelClickAdArchive2MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive2MouseLeave(Sender: TObject);
      procedure LabelClickAdArchive3Click(Sender: TObject);
      procedure LabelClickAdArchive3MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive3MouseLeave(Sender: TObject);
      procedure LabelClickAdArchive4Click(Sender: TObject);
      procedure LabelClickAdArchive4MouseEnter(Sender: TObject);
      procedure LabelClickAdArchive4MouseLeave(Sender: TObject);
      procedure LabelClickAddress1Click(Sender: TObject);
      procedure LabelClickAddress1MouseEnter(Sender: TObject);
      procedure LabelClickAddress1MouseLeave(Sender: TObject);
      procedure LabelClickAddress2Click(Sender: TObject);
      procedure LabelClickAddress2MouseEnter(Sender: TObject);
      procedure LabelClickAddress2MouseLeave(Sender: TObject);
      procedure LabelClickAddress3Click(Sender: TObject);
      procedure LabelClickAddress3MouseEnter(Sender: TObject);
      procedure LabelClickAddress3MouseLeave(Sender: TObject);
      procedure LabelClickAddress4Click(Sender: TObject);
      procedure LabelClickAddress4MouseEnter(Sender: TObject);
      procedure LabelClickAddress4MouseLeave(Sender: TObject);
      procedure LabelClickAddress5Click(Sender: TObject);
      procedure LabelClickAddress5MouseEnter(Sender: TObject);
      procedure LabelClickAddress5MouseLeave(Sender: TObject);
      procedure LabelClickAddress6Click(Sender: TObject);
      procedure LabelClickAddress6MouseEnter(Sender: TObject);
      procedure LabelClickAddress6MouseLeave(Sender: TObject);
      procedure LabelClickAddress7Click(Sender: TObject);
      procedure LabelClickAddress7MouseEnter(Sender: TObject);
      procedure LabelClickAddress7MouseLeave(Sender: TObject);
      procedure LabelClickAddress8Click(Sender: TObject);
      procedure LabelClickAddress8MouseEnter(Sender: TObject);
      procedure LabelClickAddress8MouseLeave(Sender: TObject);
      procedure LabelOpenConfClick(Sender: TObject);
      procedure LabelConfigurePeaZipClick(Sender: TObject);
      procedure LabelConfigureSendToClick(Sender: TObject);
      procedure LabelLangClick(Sender: TObject);
      procedure LabelLang4Click(Sender: TObject);
      procedure LabelPanelHintAddMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure LabelPanelHintExtractMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure LabelResetAppClick(Sender: TObject);
      procedure LabelResetBookmarksClick(Sender: TObject);
      procedure LabelResetHistoryClick(Sender: TObject);
      procedure LabelResetPMClick(Sender: TObject);
      procedure LabelResetPtmpClick(Sender: TObject);
      procedure LabelGoExtractClick(Sender: TObject);
      procedure LabelTitleAdd1Click(Sender: TObject);
      procedure LabelTitleAdd1MouseEnter(Sender: TObject);
      procedure LabelTitleAdd1MouseLeave(Sender: TObject);
      procedure LabelTitleAdd2Click(Sender: TObject);
      procedure LabelTitleAdd2MouseEnter(Sender: TObject);
      procedure LabelTitleAdd2MouseLeave(Sender: TObject);
      procedure LabelTitleAdd3Click(Sender: TObject);
      procedure LabelTitleAdd3MouseEnter(Sender: TObject);
      procedure LabelTitleAdd3MouseLeave(Sender: TObject);
      procedure LabelTitleAdd4Click(Sender: TObject);
      procedure LabelTitleAdd4MouseEnter(Sender: TObject);
      procedure LabelTitleAdd4MouseLeave(Sender: TObject);
      procedure LabelTitleApps1Click(Sender: TObject);
      procedure LabelTitleApps1MouseEnter(Sender: TObject);
      procedure LabelTitleApps1MouseLeave(Sender: TObject);
      procedure LabelTitleApps2Click(Sender: TObject);
      procedure LabelTitleApps2MouseEnter(Sender: TObject);
      procedure LabelTitleApps2MouseLeave(Sender: TObject);
      procedure LabelTitleExtract1Click(Sender: TObject);
      procedure LabelTitleExtract1MouseEnter(Sender: TObject);
      procedure LabelTitleExtract1MouseLeave(Sender: TObject);
      procedure LabelTitleExtract2Click(Sender: TObject);
      procedure LabelTitleExtract2MouseEnter(Sender: TObject);
      procedure LabelTitleExtract2MouseLeave(Sender: TObject);
      procedure LabelTitleExtract3Click(Sender: TObject);
      procedure LabelTitleExtract3MouseEnter(Sender: TObject);
      procedure LabelTitleExtract3MouseLeave(Sender: TObject);
      procedure LabelTitleExtract4Click(Sender: TObject);
      procedure LabelTitleExtract4MouseEnter(Sender: TObject);
      procedure LabelTitleExtract4MouseLeave(Sender: TObject);
      procedure LabelTitleOptions1Click(Sender: TObject);
      procedure LabelTitleOptions1MouseEnter(Sender: TObject);
      procedure LabelTitleOptions1MouseLeave(Sender: TObject);
      procedure LabelTitleOptions3Click(Sender: TObject);
      procedure LabelTitleOptions3MouseEnter(Sender: TObject);
      procedure LabelTitleOptions3MouseLeave(Sender: TObject);
      procedure LabelTitleOptions4Click(Sender: TObject);
      procedure LabelTitleOptions4MouseEnter(Sender: TObject);
      procedure LabelTitleOptions4MouseLeave(Sender: TObject);
      procedure LabelTitleOptions5Click(Sender: TObject);
      procedure LabelTitleOptions5MouseEnter(Sender: TObject);
      procedure LabelTitleOptions5MouseLeave(Sender: TObject);
      procedure LabelTitleOptions6Click(Sender: TObject);
      procedure LabelTitleOptions6MouseEnter(Sender: TObject);
      procedure LabelTitleOptions6MouseLeave(Sender: TObject);
      procedure LabelTitleOptions7Click(Sender: TObject);
      procedure LabelTitleOptions7MouseEnter(Sender: TObject);
      procedure LabelTitleOptions7MouseLeave(Sender: TObject);
      procedure LabelTitleOptions8Click(Sender: TObject);
      procedure LabelTitleOptions8MouseEnter(Sender: TObject);
      procedure LabelTitleOptions8MouseLeave(Sender: TObject);
      procedure ListViewBrowserClick(Sender: TObject);
      procedure ListViewBrowserColumnClick(Sender: TObject; Column: TListColumn);
      procedure ListViewBrowserDblClick(Sender: TObject);
      procedure ListViewBrowserDragOver(Sender, Source: TObject; X, Y: Integer;
        State: TDragState; var Accept: Boolean);
      procedure ListViewBrowserKeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure ListViewBrowserKeyPress(Sender: TObject; var Key: char);
      procedure ListViewBrowserKeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure ListViewBrowserMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ListViewBrowserMouseEnter(Sender: TObject);
      procedure ListViewBrowserMouseLeave(Sender: TObject);
      procedure ListViewBrowserMouseMove(Sender: TObject; Shift: TShiftState; X,
        Y: Integer);
      procedure ListViewBrowserSelectItem(Sender: TObject; Item: TListItem;
        Selected: Boolean);
      procedure ListViewBrowserStartDrag(Sender: TObject; var DragObject: TDragObject
        );
      procedure Lmanageschedule1Click(Sender: TObject);
      procedure Lmanageschedule2Click(Sender: TObject);
      procedure mAboutClick(Sender: TObject);
      procedure pmtabsnewClick(Sender: TObject);
      procedure pmtabscloseClick(Sender: TObject);
      procedure mextractClick(Sender: TObject);
      procedure maddconvertClick(Sender: TObject);
      procedure maddexistingClick(Sender: TObject);
      procedure mf4Click(Sender: TObject);
      procedure mlayoutsClick(Sender: TObject);
      procedure morgbookmarksClick(Sender: TObject);
      procedure morghistoryClick(Sender: TObject);
      procedure morgsessionhistoryClick(Sender: TObject);
      procedure msamehourClick(Sender: TObject);
      procedure mCharCaseClick(Sender: TObject);
      procedure mCharClick(Sender: TObject);
      procedure mDateDayClick(Sender: TObject);
      procedure mDateHourClick(Sender: TObject);
      procedure mDateWeekClick(Sender: TObject);
      procedure mDateYearClick(Sender: TObject);
      procedure mpacked100kClick(Sender: TObject);
      procedure mpacked100mClick(Sender: TObject);
      procedure mpacked10mClick(Sender: TObject);
      procedure mpackedemptyClick(Sender: TObject);
      procedure mpackedoverClick(Sender: TObject);
      procedure mpackedsimilar50Click(Sender: TObject);
      procedure mpackedsimilarClick(Sender: TObject);
      procedure mpluginsClick(Sender: TObject);
      procedure mAdminClick(Sender: TObject);
      procedure madvfiltersClick(Sender: TObject);
      procedure mb0Click(Sender: TObject);
      procedure mb10Click(Sender: TObject);
      procedure mb11Click(Sender: TObject);
      procedure mb12Click(Sender: TObject);
      procedure mb13Click(Sender: TObject);
      procedure mb14Click(Sender: TObject);
      procedure mb15Click(Sender: TObject);
      procedure mb16Click(Sender: TObject);
      procedure mb17Click(Sender: TObject);
      procedure mb18Click(Sender: TObject);
      procedure mb19Click(Sender: TObject);
      procedure mb1Click(Sender: TObject);
      procedure mb20Click(Sender: TObject);
      procedure mb21Click(Sender: TObject);
      procedure mb22Click(Sender: TObject);
      procedure mb23Click(Sender: TObject);
      procedure mb24Click(Sender: TObject);
      procedure mb2Click(Sender: TObject);
      procedure mb3Click(Sender: TObject);
      procedure mb4Click(Sender: TObject);
      procedure mb5Click(Sender: TObject);
      procedure mb6Click(Sender: TObject);
      procedure mb7Click(Sender: TObject);
      procedure mb8Click(Sender: TObject);
      procedure mb9Click(Sender: TObject);
      procedure mbackaliasClick(Sender: TObject);
      procedure mbackClick(Sender: TObject);
      procedure mbAddArchiveClick(Sender: TObject);
      procedure mbAddPathClick(Sender: TObject);
      procedure mbc1Click(Sender: TObject);
      procedure mbc2Click(Sender: TObject);
      procedure mbc3Click(Sender: TObject);
      procedure mbc4Click(Sender: TObject);
      procedure mbc5Click(Sender: TObject);
      procedure mbc6Click(Sender: TObject);
      procedure mbc7Click(Sender: TObject);
      procedure mbc8Click(Sender: TObject);
      procedure mbclClick(Sender: TObject);
      procedure mbDeleteClick(Sender: TObject);
      procedure mbexploreClick(Sender: TObject);
      procedure mbNotesClick(Sender: TObject);
      procedure mbpeaClick(Sender: TObject);
      procedure mbresetClick(Sender: TObject);
      procedure mbrowsercattClick(Sender: TObject);
      procedure mbrowserccrcClick(Sender: TObject);
      procedure mbrowsercdateClick(Sender: TObject);
      procedure mbrowsercnameClick(Sender: TObject);
      procedure mbrowsercpackedClick(Sender: TObject);
      procedure mbrowsercsizeClick(Sender: TObject);
      procedure mbrowserctypeClick(Sender: TObject);
      procedure mcancelClick(Sender: TObject);
      procedure mcattClick(Sender: TObject);
      procedure mccrcClick(Sender: TObject);
      procedure mcdateClick(Sender: TObject);
      procedure mcfreeClick(Sender: TObject);
      procedure mcfsClick(Sender: TObject);
      procedure mcpackedClick(Sender: TObject);
      procedure mcpClick(Sender: TObject);
      procedure mcsizeClick(Sender: TObject);
      procedure mctrlf3Click(Sender: TObject);
      procedure mctrlf8Click(Sender: TObject);
      procedure mdefaultarchiveClick(Sender: TObject);
      procedure mctypeClick(Sender: TObject);
      procedure mPeaFAQClick(Sender: TObject);
      procedure mPeaSiteMirrorClick(Sender: TObject);
      procedure MenuItemArchive_dropboxClick(Sender: TObject);
      procedure MenuItemArchive_googledriveClick(Sender: TObject);
      procedure MenuItemArchive_musicClick(Sender: TObject);
      procedure MenuItemArchive_myboxfilesClick(Sender: TObject);
      procedure MenuItemArchive_picturesClick(Sender: TObject);
      procedure MenuItemArchive_onedriveClick(Sender: TObject);
      procedure MenuItemArchive_skydriveClick(Sender: TObject);
      procedure MenuItemArchive_ubuntuoneClick(Sender: TObject);
      procedure MenuItemArchive_videosClick(Sender: TObject);
      procedure MenuItemEnumerateClick(Sender: TObject);
      procedure menuitemopenhomeClick(Sender: TObject);
      procedure MenuItemOpen_dropboxClick(Sender: TObject);
      procedure MenuItemOpen_googledriveClick(Sender: TObject);
      procedure MenuItemOpen_musicClick(Sender: TObject);
      procedure MenuItemOpen_myboxfilesClick(Sender: TObject);
      procedure MenuItemOpen_organizebookmarksClick(Sender: TObject);
      procedure MenuItemOpen_picturesClick(Sender: TObject);
      procedure MenuItemOpen_powershellClick(Sender: TObject);
      procedure MenuItemOpen_onedriveClick(Sender: TObject);
      procedure MenuItemOpen_skydriveClick(Sender: TObject);
      procedure MenuItemOpen_ubuntuoneClick(Sender: TObject);
      procedure MenuItemOpen_videosClick(Sender: TObject);
      procedure MenuItemPowerShellClick(Sender: TObject);
      procedure mfwdClick(Sender: TObject);
      procedure mPeaSupportClick(Sender: TObject);
      procedure mpeautilsClick(Sender: TObject);
      procedure mprofileautoClick(Sender: TObject);
      procedure mprofileencrypt7zClick(Sender: TObject);
      procedure mprofilefastzipClick(Sender: TObject);
      procedure mprofilenormal7zClick(Sender: TObject);
      procedure mprofilenormalzipClick(Sender: TObject);
      procedure mprofilesplitzipClick(Sender: TObject);
      procedure mprofileultra7zClick(Sender: TObject);
      procedure mRecent1fClick(Sender: TObject);
      procedure mRecent2fClick(Sender: TObject);
      procedure mRecent3fClick(Sender: TObject);
      procedure mRecent4fClick(Sender: TObject);
      procedure mRecent5fClick(Sender: TObject);
      procedure mRecent6fClick(Sender: TObject);
      procedure mRecent7fClick(Sender: TObject);
      procedure mRecent8fClick(Sender: TObject);
      procedure msamedayClick(Sender: TObject);
      procedure msamemonthClick(Sender: TObject);
      procedure msameweekClick(Sender: TObject);
      procedure msameyearClick(Sender: TObject);
      procedure mscheduledscriptsClick(Sender: TObject);
      procedure mselectadvClick(Sender: TObject);
      procedure msize0Click(Sender: TObject);
      procedure msize100kClick(Sender: TObject);
      procedure msize100mClick(Sender: TObject);
      procedure msize10mClick(Sender: TObject);
      procedure msizeoverClick(Sender: TObject);
      procedure msizesimilar50Click(Sender: TObject);
      procedure msizesimilarClick(Sender: TObject);
      procedure mtaskschedulerClick(Sender: TObject);
      procedure mtoggletbribClick(Sender: TObject);
      procedure munpeaextractClick(Sender: TObject);
      procedure mwebsClick(Sender: TObject);
      procedure mDateMonthClick(Sender: TObject);
      procedure PanelHintAddMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure PanelHintExtractMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure PanelInfoGeneralClick(Sender: TObject);
      procedure pmamr1Click(Sender: TObject);
      procedure pmamr2Click(Sender: TObject);
      procedure pmamr3Click(Sender: TObject);
      procedure pmamr4Click(Sender: TObject);
      procedure pmamr5Click(Sender: TObject);
      procedure pmamr6Click(Sender: TObject);
      procedure pmamr7Click(Sender: TObject);
      procedure pmamr8Click(Sender: TObject);
      procedure pmabc0Click(Sender: TObject);
      procedure pmbcaddbookmarkClick(Sender: TObject);
      procedure pmbcd0Click(Sender: TObject);
      procedure pmbcd10Click(Sender: TObject);
      procedure pmbcd11Click(Sender: TObject);
      procedure pmbcd12Click(Sender: TObject);
      procedure pmbcd13Click(Sender: TObject);
      procedure pmbcd14Click(Sender: TObject);
      procedure pmbcd15Click(Sender: TObject);
      procedure pmbcd16Click(Sender: TObject);
      procedure pmbcd17Click(Sender: TObject);
      procedure pmbcd18Click(Sender: TObject);
      procedure pmbcd19Click(Sender: TObject);
      procedure pmbcd1Click(Sender: TObject);
      procedure pmbcd2Click(Sender: TObject);
      procedure pmbcd3Click(Sender: TObject);
      procedure pmbcd4Click(Sender: TObject);
      procedure pmbcd5Click(Sender: TObject);
      procedure pmbcd6Click(Sender: TObject);
      procedure pmbcd7Click(Sender: TObject);
      procedure pmbcd8Click(Sender: TObject);
      procedure pmbcd9Click(Sender: TObject);
      procedure pmbcexpandClick(Sender: TObject);
      procedure pmbcorganizebookmarksClick(Sender: TObject);
      procedure pmCopyPathClick(Sender: TObject);
      procedure pmcpypathClick(Sender: TObject);
      procedure pmCustEditAdd1Click(Sender: TObject);
      procedure pmCustEditAddClick(Sender: TObject);
      procedure pmCustEditDesc1Click(Sender: TObject);
      procedure pmCustEditDescClick(Sender: TObject);
      procedure pmCustEditEdit1afterClick(Sender: TObject);
      procedure pmCustEditEdit1Click(Sender: TObject);
      procedure pmCustEditEditClick(Sender: TObject);
      procedure pmCustEditRemove1Click(Sender: TObject);
      procedure pmCustEditRemoveClick(Sender: TObject);
      procedure pmcutClick(Sender: TObject);
      procedure pmemb1Click(Sender: TObject);
      procedure pmemb2Click(Sender: TObject);
      procedure pmemb3Click(Sender: TObject);
      procedure pmemb4Click(Sender: TObject);
      procedure pmemb5Click(Sender: TObject);
      procedure pmemb6Click(Sender: TObject);
      procedure pmemb7Click(Sender: TObject);
      procedure pmemb8Click(Sender: TObject);
      procedure pmemr1Click(Sender: TObject);
      procedure pmemr2Click(Sender: TObject);
      procedure pmemr3Click(Sender: TObject);
      procedure pmemr4Click(Sender: TObject);
      procedure pmemr5Click(Sender: TObject);
      procedure pmemr6Click(Sender: TObject);
      procedure pmemr7Click(Sender: TObject);
      procedure pmemr8Click(Sender: TObject);
      procedure pmflatClick(Sender: TObject);
      procedure pmfun10Click(Sender: TObject);
      procedure pmfun11Click(Sender: TObject);
      procedure pmfun12Click(Sender: TObject);
      procedure pmfun13Click(Sender: TObject);
      procedure pmfun14Click(Sender: TObject);
      procedure pmfun15Click(Sender: TObject);
      procedure pmfun16Click(Sender: TObject);
      procedure pmfun17Click(Sender: TObject);
      procedure pmfun18Click(Sender: TObject);
      procedure pmfun1Click(Sender: TObject);
      procedure pmfun2Click(Sender: TObject);
      procedure pmfun3Click(Sender: TObject);
      procedure pmfun4Click(Sender: TObject);
      procedure pmfun5Click(Sender: TObject);
      procedure pmfun6Click(Sender: TObject);
      procedure pmfun7Click(Sender: TObject);
      procedure pmfun8Click(Sender: TObject);
      procedure pmfun9Click(Sender: TObject);
      procedure pmhr1fClick(Sender: TObject);
      procedure pmhr2fClick(Sender: TObject);
      procedure pmhr3fClick(Sender: TObject);
      procedure pmhr4fClick(Sender: TObject);
      procedure pmhr5fClick(Sender: TObject);
      procedure pmhr6fClick(Sender: TObject);
      procedure pmhr7fClick(Sender: TObject);
      procedure pmhr8fClick(Sender: TObject);
      procedure pmif1Click(Sender: TObject);
      procedure pmif2Click(Sender: TObject);
      procedure pmif3Click(Sender: TObject);
      procedure pmif4Click(Sender: TObject);
      procedure pmif5Click(Sender: TObject);
      procedure pmif6Click(Sender: TObject);
      procedure pmif7Click(Sender: TObject);
      procedure pmif8Click(Sender: TObject);
      procedure pmir180Click(Sender: TObject);
      procedure pmiresize125Click(Sender: TObject);
      procedure pmiresize150Click(Sender: TObject);
      procedure pmiresize200Click(Sender: TObject);
      procedure pmiresize25Click(Sender: TObject);
      procedure pmiresize300Click(Sender: TObject);
      procedure pmiresize33Click(Sender: TObject);
      procedure pmiresize400Click(Sender: TObject);
      procedure pmiresize50Click(Sender: TObject);
      procedure pmiresize75Click(Sender: TObject);
      procedure pmirflipClick(Sender: TObject);
      procedure mpretoggleClick(Sender: TObject);
      procedure pmpdupClick(Sender: TObject);
      procedure pmirmirrorClick(Sender: TObject);
      procedure pmisBMPClick(Sender: TObject);
      procedure pmisJPEG50Click(Sender: TObject);
      procedure pmisJPEG75Click(Sender: TObject);
      procedure pmisJPEGClick(Sender: TObject);
      procedure pmisPNGClick(Sender: TObject);
      procedure pmisTIFFClick(Sender: TObject);
      procedure pmjd10Click(Sender: TObject);
      procedure pmjd11Click(Sender: TObject);
      procedure pmjd12Click(Sender: TObject);
      procedure pmjd13Click(Sender: TObject);
      procedure pmjd14Click(Sender: TObject);
      procedure pmjd15Click(Sender: TObject);
      procedure pmjd16Click(Sender: TObject);
      procedure pmjd17Click(Sender: TObject);
      procedure pmjd18Click(Sender: TObject);
      procedure pmjd19Click(Sender: TObject);
      procedure pmjd1Click(Sender: TObject);
      procedure pmjd20Click(Sender: TObject);
      procedure pmjd21Click(Sender: TObject);
      procedure pmjd22Click(Sender: TObject);
      procedure pmjd23Click(Sender: TObject);
      procedure pmjd24Click(Sender: TObject);
      procedure pmjd25Click(Sender: TObject);
      procedure pmjd26Click(Sender: TObject);
      procedure pmjd2Click(Sender: TObject);
      procedure pmjd3Click(Sender: TObject);
      procedure pmjd4Click(Sender: TObject);
      procedure pmjd5Click(Sender: TObject);
      procedure pmjd6Click(Sender: TObject);
      procedure pmjd7Click(Sender: TObject);
      procedure pmjd8Click(Sender: TObject);
      procedure pmjd9Click(Sender: TObject);
      procedure pmjumpmusicClick(Sender: TObject);
      procedure pmjumppicturesClick(Sender: TObject);
      procedure pmjumpusersClick(Sender: TObject);
      procedure pmjumpvideosClick(Sender: TObject);
      procedure pmmore1Click(Sender: TObject);
      procedure pmmore2Click(Sender: TObject);
      procedure pmmore3Click(Sender: TObject);
      procedure pmmore4Click(Sender: TObject);
      procedure pmmore5Click(Sender: TObject);
      procedure pmmore6Click(Sender: TObject);
      procedure pmmore7Click(Sender: TObject);
      procedure pmmore8Click(Sender: TObject);
      procedure pmmoreanalysisClick(Sender: TObject);
      procedure pmmorefun_detailsClick(Sender: TObject);
      procedure pmmorefun_propertiesClick(Sender: TObject);
      procedure pmmorecheckClick(Sender: TObject);
      procedure pmmorehexClick(Sender: TObject);
      procedure pmmstatus_bookmarksClick(Sender: TObject);
      procedure pmmstatus_clipboardClick(Sender: TObject);
      procedure pmmstatus_raClick(Sender: TObject);
      procedure pmmstatus_rClick(Sender: TObject);
      procedure pmmstatus_statusClick(Sender: TObject);
      procedure pmorganizebookmarksClick(Sender: TObject);
      procedure pmpowershellClick(Sender: TObject);
      procedure pmqjdropboxClick(Sender: TObject);
      procedure pmqjgoogledriveClick(Sender: TObject);
      procedure pmqjmyboxfilesClick(Sender: TObject);
      procedure pmqjonedriveClick(Sender: TObject);
      procedure pmqjskydriveClick(Sender: TObject);
      procedure pmqjubuntuoneClick(Sender: TObject);
      procedure pmqnointdirClick(Sender: TObject);
      procedure pmquickdeskClick(Sender: TObject);
      procedure pmquickhomeClick(Sender: TObject);
      procedure pmquickoaClick(Sender: TObject);
      procedure pmquickopClick(Sender: TObject);
      procedure pmquicksdClick(Sender: TObject);
      procedure pmrecycleClick(Sender: TObject);
      procedure pmrenameClick(Sender: TObject);
      procedure pmrsearchClick(Sender: TObject);
      procedure pmrselectClick(Sender: TObject);
      procedure pmr_addClick(Sender: TObject);
      procedure pmr_deleteClick(Sender: TObject);
      procedure pmr_extClick(Sender: TObject);
      procedure pmr_lowercaseClick(Sender: TObject);
      procedure pmr_replacecaseClick(Sender: TObject);
      procedure pmr_replaceClick(Sender: TObject);
      procedure pmr_uppercaseClick(Sender: TObject);
      procedure pmsearchdragClick(Sender: TObject);
      procedure pmsearchwebClick(Sender: TObject);
      procedure pmsecuredeletefreeClick(Sender: TObject);
      procedure pmselectadvClick(Sender: TObject);
      procedure pmtypeswapClick(Sender: TObject);
      procedure pmwsClick(Sender: TObject);
      procedure MenuItemopendesktopClick(Sender: TObject);
      procedure MenuItemOrganizeNavbarClick(Sender: TObject);
      procedure MenuItemOrganizeStatusbarClick(Sender: TObject);
      procedure MenuItemOrganizeToolbarClick(Sender: TObject);
      procedure MenuItemPropertiesClick(Sender: TObject);
      procedure mfullscreenClick(Sender: TObject);
      procedure mimmersiveClick(Sender: TObject);
      procedure mJobClick(Sender: TObject);
      procedure mobClick(Sender: TObject);
      procedure moblClick(Sender: TObject);
      procedure mobrClick(Sender: TObject);
      procedure modefaultClick(Sender: TObject);
      procedure molClick(Sender: TObject);
      procedure morClick(Sender: TObject);
      procedure motClick(Sender: TObject);
      procedure motlClick(Sender: TObject);
      procedure motrClick(Sender: TObject);
      procedure mpmClick(Sender: TObject);
      procedure mPropertiesClick(Sender: TObject);
      procedure mrecsearchClick(Sender: TObject);
      procedure mscriptsClick(Sender: TObject);
      procedure msimplesearchClick(Sender: TObject);
      procedure mupdateClick(Sender: TObject);
      procedure owcustom10tClick(Sender: TObject);
      procedure owcustom11tClick(Sender: TObject);
      procedure owcustom12tClick(Sender: TObject);
      procedure owcustom13tClick(Sender: TObject);
      procedure owcustom14tClick(Sender: TObject);
      procedure owcustom15tClick(Sender: TObject);
      procedure owcustom16tClick(Sender: TObject);
      procedure owcustom1tClick(Sender: TObject);
      procedure owcustom2tClick(Sender: TObject);
      procedure owcustom3tClick(Sender: TObject);
      procedure owcustom4tClick(Sender: TObject);
      procedure owcustom5tClick(Sender: TObject);
      procedure owcustom6tClick(Sender: TObject);
      procedure owcustom7tClick(Sender: TObject);
      procedure owcustom8tClick(Sender: TObject);
      procedure owcustom9tClick(Sender: TObject);
      procedure owcustom_10Click(Sender: TObject);
      procedure owcustom_10tClick(Sender: TObject);
      procedure owcustom_11Click(Sender: TObject);
      procedure owcustom_11tClick(Sender: TObject);
      procedure owcustom_12Click(Sender: TObject);
      procedure owcustom_12tClick(Sender: TObject);
      procedure owcustom_13Click(Sender: TObject);
      procedure owcustom_13tClick(Sender: TObject);
      procedure owcustom_14Click(Sender: TObject);
      procedure owcustom_14tClick(Sender: TObject);
      procedure owcustom_15Click(Sender: TObject);
      procedure owcustom_15tClick(Sender: TObject);
      procedure owcustom_16Click(Sender: TObject);
      procedure owcustom_16tClick(Sender: TObject);
      procedure owcustom_9Click(Sender: TObject);
      procedure owcustom_9tClick(Sender: TObject);

      procedure pmcheckClick(Sender: TObject);
      procedure pmnewfolderClick(Sender: TObject);
      procedure pmpropertiesClick(Sender: TObject);
      procedure pmsrecClick(Sender: TObject);
      procedure pmzerofileClick(Sender: TObject);
      procedure pmzerofreeClick(Sender: TObject);
      procedure pnabc1Click(Sender: TObject);
      procedure pnabc2Click(Sender: TObject);
      procedure pnabc3Click(Sender: TObject);
      procedure pnabc4Click(Sender: TObject);
      procedure pnabc5Click(Sender: TObject);
      procedure pnabc6Click(Sender: TObject);
      procedure pnabc7Click(Sender: TObject);
      procedure pnabc8Click(Sender: TObject);
      procedure pnbc1Click(Sender: TObject);
      procedure pnbc2Click(Sender: TObject);
      procedure pnbc3Click(Sender: TObject);
      procedure pnbc4Click(Sender: TObject);
      procedure pnbc5Click(Sender: TObject);
      procedure pnbc6Click(Sender: TObject);
      procedure pnbc7Click(Sender: TObject);
      procedure pnbc8Click(Sender: TObject);
      procedure pob_adlerClick(Sender: TObject);
      procedure pob_crc16Click(Sender: TObject);
      procedure pob_crc24Click(Sender: TObject);
      procedure pob_crc32Click(Sender: TObject);
      procedure pob_crc64Click(Sender: TObject);
      procedure pob_edonkeyClick(Sender: TObject);
      procedure pob_md4Click(Sender: TObject);
      procedure pob_md5Click(Sender: TObject);
      procedure pob_ripemdClick(Sender: TObject);
      procedure pob_sha1Click(Sender: TObject);
      procedure pob_sha256Click(Sender: TObject);
      procedure pob_sha3256Click(Sender: TObject);
      procedure pob_sha3512Click(Sender: TObject);
      procedure pob_sha512Click(Sender: TObject);
      procedure pob_whirlpoolClick(Sender: TObject);
      procedure powcustom_10Click(Sender: TObject);
      procedure powcustom_11Click(Sender: TObject);
      procedure powcustom_12Click(Sender: TObject);
      procedure powcustom_13Click(Sender: TObject);
      procedure powcustom_14Click(Sender: TObject);
      procedure powcustom_15Click(Sender: TObject);
      procedure powcustom_16Click(Sender: TObject);
      procedure powcustom_9Click(Sender: TObject);
      procedure po_alltasksClick(Sender: TObject);
      procedure po_analyzeClick(Sender: TObject);
      procedure po_checksumClick(Sender: TObject);
      procedure po_copypathClick(Sender: TObject);
      procedure msorttoggleClick(Sender: TObject);
      procedure mthumbimagesClick(Sender: TObject);
      procedure mtogglenavbarClick(Sender: TObject);
      procedure mtoggleopClick(Sender: TObject);
      procedure mtogglestatusbarClick(Sender: TObject);
      procedure mttoggletoolbarClick(Sender: TObject);
      procedure MenuItemDonationsClick(Sender: TObject);
      procedure MenuItemArchive_downloadsClick(Sender: TObject);
      procedure MenuItemExtAllHereClick(Sender: TObject);
      procedure MenuItemExtAllToClick(Sender: TObject);
      procedure MenuItemOpenWebClick(Sender: TObject);
      procedure MenuItemOpen_downloads1Click(Sender: TObject);
      procedure MenuItemOrganizeMbarClick(Sender: TObject);
      procedure MenuItemArchive_pubdocClick(Sender: TObject);
      procedure MenuItemArchive_pubhomeClick(Sender: TObject);
      procedure MenuItemOpen_pubdocClick(Sender: TObject);
      procedure MenuItemOpen_pubhomeClick(Sender: TObject);
      procedure MenuItemOpen_searchClick(Sender: TObject);
      procedure mextalldesktopClick(Sender: TObject);
      procedure mextalldocumentsClick(Sender: TObject);
      procedure mextallhereClick(Sender: TObject);
      procedure mextalltoClick(Sender: TObject);
      procedure mhclClick(Sender: TObject);
      procedure mhexploreClick(Sender: TObject);
      procedure mhistory1Click(Sender: TObject);
      procedure mhistory2Click(Sender: TObject);
      procedure mhistory3Click(Sender: TObject);
      procedure mhistory4Click(Sender: TObject);
      procedure mhistory5Click(Sender: TObject);
      procedure mhistory6Click(Sender: TObject);
      procedure mhistory7Click(Sender: TObject);
      procedure mhistory8Click(Sender: TObject);
      procedure mhpeaClick(Sender: TObject);
      procedure mopenasarchiveClick(Sender: TObject);
      procedure mgobrowserClick(Sender: TObject);
      procedure mextractarchiveClick(Sender: TObject);
      procedure MenuItemArchive_documents1Click(Sender: TObject);
      procedure MenuItemArchive_home1Click(Sender: TObject);
      procedure MenuItemextexploreClick(Sender: TObject);
      procedure MenuItemOpen_LastClick(Sender: TObject);
      procedure mf8Click(Sender: TObject);
      procedure mgoextlayoutClick(Sender: TObject);
      procedure mgotype7zClick(Sender: TObject);
      procedure mgotype7zsfxClick(Sender: TObject);
      procedure mgotypebz2Click(Sender: TObject);
      procedure mgotypegzClick(Sender: TObject);
      procedure mgotypetarClick(Sender: TObject);
      procedure mgotypezipClick(Sender: TObject);
      procedure mLangClick(Sender: TObject);
      procedure mpathdesk1Click(Sender: TObject);
      procedure mpathexplore1Click(Sender: TObject);
      procedure mpathreset1Click(Sender: TObject);
      procedure mpathself1Click(Sender: TObject);
      procedure mPeaTrackerClick(Sender: TObject);
      procedure mr9Click(Sender: TObject);
      procedure mrowselectClick(Sender: TObject);
      procedure msetpwClick(Sender: TObject);
      procedure mshiftf3Click(Sender: TObject);
      procedure MenuItemHistoryBookClick(Sender: TObject);
      procedure MenuItemNavigateClick(Sender: TObject);
      procedure MenuItemOpen_desktop1Click(Sender: TObject);
      procedure MenuItemOpen_documents1Click(Sender: TObject);
      procedure MenuItemOpen_hereClick(Sender: TObject);
      procedure MenuItemOpen_home1Click(Sender: TObject);
      procedure MenuItemPWClick(Sender: TObject);
      procedure MenuItemToolhexpClick(Sender: TObject);
      procedure mEnvstrClick(Sender: TObject);
      procedure MenuItemBookmarksClick(Sender: TObject);
      procedure MenuItemOpen_addtobookmarksClick(Sender: TObject);
      procedure MenuItemOpen_commandpromptClick(Sender: TObject);
      procedure MenuItemRefreshClick(Sender: TObject);
      procedure mf2Click(Sender: TObject);
      procedure mf3Click(Sender: TObject);
      procedure mf4upClick(Sender: TObject);
      procedure mpeahelpofflineClick(Sender: TObject);
      procedure mRecent9Click(Sender: TObject);
      procedure mshiftf8Click(Sender: TObject);
      procedure mshowmenuClick(Sender: TObject);
      procedure mswapbarsClick(Sender: TObject);
      procedure mSystemIntegrationClick(Sender: TObject);
      procedure mthlClick(Sender: TObject);
      procedure mtogglenewClick(Sender: TObject);
      procedure mTrayClick(Sender: TObject);
      procedure mTutorialClick(Sender: TObject);
      procedure munsearchClick(Sender: TObject);
      procedure mUserClick(Sender: TObject);
      procedure mwebsearchClick(Sender: TObject);
      procedure owcustom10Click(Sender: TObject);
      procedure owcustom11Click(Sender: TObject);
      procedure owcustom12Click(Sender: TObject);
      procedure owcustom13Click(Sender: TObject);
      procedure owcustom14Click(Sender: TObject);
      procedure owcustom15Click(Sender: TObject);
      procedure owcustom16Click(Sender: TObject);
      procedure owcustom1Click(Sender: TObject);
      procedure owcustom2Click(Sender: TObject);
      procedure owcustom3Click(Sender: TObject);
      procedure owcustom4Click(Sender: TObject);
      procedure owcustom5Click(Sender: TObject);
      procedure owcustom6Click(Sender: TObject);
      procedure owcustom7Click(Sender: TObject);
      procedure owcustom8Click(Sender: TObject);
      procedure owcustom9Click(Sender: TObject);
      procedure pajdn10Click(Sender: TObject);
      procedure pajdn11Click(Sender: TObject);
      procedure pajdn12Click(Sender: TObject);
      procedure pajdn13Click(Sender: TObject);
      procedure pajdn14Click(Sender: TObject);
      procedure pajdn15Click(Sender: TObject);
      procedure pajdn16Click(Sender: TObject);
      procedure pajdn17Click(Sender: TObject);
      procedure pajdn18Click(Sender: TObject);
      procedure pajdn19Click(Sender: TObject);
      procedure pajdn1Click(Sender: TObject);
      procedure pajdn20Click(Sender: TObject);
      procedure pajdn21Click(Sender: TObject);
      procedure pajdn22Click(Sender: TObject);
      procedure pajdn23Click(Sender: TObject);
      procedure pajdn24Click(Sender: TObject);
      procedure pajdn25Click(Sender: TObject);
      procedure pajdn26Click(Sender: TObject);
      procedure pajdn2Click(Sender: TObject);
      procedure pajdn3Click(Sender: TObject);
      procedure pajdn4Click(Sender: TObject);
      procedure pajdn5Click(Sender: TObject);
      procedure pajdn6Click(Sender: TObject);
      procedure pajdn7Click(Sender: TObject);
      procedure pajdn8Click(Sender: TObject);
      procedure pajdn9Click(Sender: TObject);
      procedure PanelClickAddressClick(Sender: TObject);
      procedure pclip_clearclipClick(Sender: TObject);
      procedure pclip_removeitemClick(Sender: TObject);
      procedure pcustompathexploreClick(Sender: TObject);
      procedure pma2s_copyClick(Sender: TObject);
      procedure pma2s_extallnew1Click(Sender: TObject);
      procedure pma2s_extnew1Click(Sender: TObject);
      procedure pma2s_extnewClick(Sender: TObject);
      procedure pma2s_extract1Click(Sender: TObject);
      procedure pma2s_extractall1Click(Sender: TObject);
      procedure pma2s_extractClick(Sender: TObject);
      procedure pma2s_moveClick(Sender: TObject);
      procedure pmbc1Click(Sender: TObject);
      procedure pmbc2Click(Sender: TObject);
      procedure pmbc3Click(Sender: TObject);
      procedure pmbc4Click(Sender: TObject);
      procedure pmbc5Click(Sender: TObject);
      procedure pmbc6Click(Sender: TObject);
      procedure pmbc7Click(Sender: TObject);
      procedure pmbc8Click(Sender: TObject);
      procedure pmbookmarksClick(Sender: TObject);
      procedure pmBrowserClick(Sender: TObject);
      procedure pmcommandClick(Sender: TObject);
      procedure pmcpytoClick(Sender: TObject);
      procedure pmexploreClick(Sender: TObject);
      procedure pmextcontextallClick(Sender: TObject);
      procedure pmextcontextdisplayedClick(Sender: TObject);
      procedure pmextcontextselectedClick(Sender: TObject);
      procedure pmh9Click(Sender: TObject);
      procedure pmhr1Click(Sender: TObject);
      procedure pmhr2Click(Sender: TObject);
      procedure pmhr3Click(Sender: TObject);
      procedure pmhr4Click(Sender: TObject);
      procedure pmhr5Click(Sender: TObject);
      procedure pmhr6Click(Sender: TObject);
      procedure pmhr7Click(Sender: TObject);
      procedure pmhr8Click(Sender: TObject);
      procedure pmhr9Click(Sender: TObject);
      procedure pmiresetClick(Sender: TObject);
      procedure pmjb10Click(Sender: TObject);
      procedure pmjb11Click(Sender: TObject);
      procedure pmjb12Click(Sender: TObject);
      procedure pmjb13Click(Sender: TObject);
      procedure pmjb14Click(Sender: TObject);
      procedure pmjb15Click(Sender: TObject);
      procedure pmjb16Click(Sender: TObject);
      procedure pmjb17Click(Sender: TObject);
      procedure pmjb18Click(Sender: TObject);
      procedure pmjb19Click(Sender: TObject);
      procedure pmjb1Click(Sender: TObject);
      procedure pmjb20Click(Sender: TObject);
      procedure pmjb21Click(Sender: TObject);
      procedure pmjb22Click(Sender: TObject);
      procedure pmjb23Click(Sender: TObject);
      procedure pmjb24Click(Sender: TObject);
      procedure pmjb2Click(Sender: TObject);
      procedure pmjb3Click(Sender: TObject);
      procedure pmjb4Click(Sender: TObject);
      procedure pmjb5Click(Sender: TObject);
      procedure pmjb6Click(Sender: TObject);
      procedure pmjb7Click(Sender: TObject);
      procedure pmjb8Click(Sender: TObject);
      procedure pmjb9Click(Sender: TObject);
      procedure pmJump3Click(Sender: TObject);
      procedure pmJumpDocumentsClick(Sender: TObject);
      procedure pmjumpdownloadsClick(Sender: TObject);
      procedure pmjumplibrariesClick(Sender: TObject);
      procedure pmjumppubdocClick(Sender: TObject);
      procedure pmjumppubhomeClick(Sender: TObject);
      procedure pmjumprecentClick(Sender: TObject);
      procedure pmjumpsearchesClick(Sender: TObject);
      procedure pmmorefun_infoClick(Sender: TObject);
      procedure pmmorefun_listClick(Sender: TObject);
      procedure pmmvtoClick(Sender: TObject);
      procedure pmopenoutClick(Sender: TObject);
      procedure pmqe1favClick(Sender: TObject);
      procedure pmqe2favClick(Sender: TObject);
      procedure pmqe3favClick(Sender: TObject);
      procedure pmqedefaultClick(Sender: TObject);
      procedure pmqedeskClick(Sender: TObject);
      procedure pmqedocumentsClick(Sender: TObject);
      procedure pmqehereClick(Sender: TObject);
      procedure pmqelastClick(Sender: TObject);
      procedure pmqen1Click(Sender: TObject);
      procedure pmqen2Click(Sender: TObject);
      procedure pmqen3Click(Sender: TObject);
      procedure pmqen4Click(Sender: TObject);
      procedure pmqen5Click(Sender: TObject);
      procedure pmqenewfolderClick(Sender: TObject);
      procedure pmqenopathClick(Sender: TObject);
      procedure pmqesetpwClick(Sender: TObject);
      procedure pmqetoClick(Sender: TObject);
      procedure pmquickdeleteClick(Sender: TObject);
      procedure pms2a_addClick(Sender: TObject);
      procedure pms2a_copyClick(Sender: TObject);
      procedure pms2a_moveClick(Sender: TObject);
      procedure pms2a_openClick(Sender: TObject);
      procedure pmsecuredeleteClick(Sender: TObject);
      procedure pmshist1Click(Sender: TObject);
      procedure pmshist2Click(Sender: TObject);
      procedure pmshist3Click(Sender: TObject);
      procedure pmshist4Click(Sender: TObject);
      procedure pmshist5Click(Sender: TObject);
      procedure pmshist6Click(Sender: TObject);
      procedure pmshist7Click(Sender: TObject);
      procedure pmshist8Click(Sender: TObject);
      procedure pmusedefaultClick(Sender: TObject);
      procedure pnb10Click(Sender: TObject);
      procedure pnb11Click(Sender: TObject);
      procedure pnb12Click(Sender: TObject);
      procedure pnb13Click(Sender: TObject);
      procedure pnb14Click(Sender: TObject);
      procedure pnb15Click(Sender: TObject);
      procedure pnb16Click(Sender: TObject);
      procedure pnb17Click(Sender: TObject);
      procedure pnb18Click(Sender: TObject);
      procedure pnb19Click(Sender: TObject);
      procedure pnb1Click(Sender: TObject);
      procedure pnb20Click(Sender: TObject);
      procedure pnb21Click(Sender: TObject);
      procedure pnb22Click(Sender: TObject);
      procedure pnb23Click(Sender: TObject);
      procedure pnb2Click(Sender: TObject);
      procedure pnb3Click(Sender: TObject);
      procedure pnb4Click(Sender: TObject);
      procedure pnb5Click(Sender: TObject);
      procedure pnb6Click(Sender: TObject);
      procedure pnb7Click(Sender: TObject);
      procedure pnb8Click(Sender: TObject);
      procedure pnb9Click(Sender: TObject);
      procedure pnba10Click(Sender: TObject);
      procedure pnba11Click(Sender: TObject);
      procedure pnba12Click(Sender: TObject);
      procedure pnba13Click(Sender: TObject);
      procedure pnba14Click(Sender: TObject);
      procedure pnba15Click(Sender: TObject);
      procedure pnba16Click(Sender: TObject);
      procedure pnba17Click(Sender: TObject);
      procedure pnba18Click(Sender: TObject);
      procedure pnba19Click(Sender: TObject);
      procedure pnba1Click(Sender: TObject);
      procedure pnba20Click(Sender: TObject);
      procedure pnba21Click(Sender: TObject);
      procedure pnba22Click(Sender: TObject);
      procedure pnba23Click(Sender: TObject);
      procedure pnba2Click(Sender: TObject);
      procedure pnba3Click(Sender: TObject);
      procedure pnba4Click(Sender: TObject);
      procedure pnba5Click(Sender: TObject);
      procedure pnba6Click(Sender: TObject);
      procedure pnba7Click(Sender: TObject);
      procedure pnba8Click(Sender: TObject);
      procedure pnba9Click(Sender: TObject);
      procedure pnh1Click(Sender: TObject);
      procedure pnh2Click(Sender: TObject);
      procedure pnh3Click(Sender: TObject);
      procedure pnh4Click(Sender: TObject);
      procedure pnh5Click(Sender: TObject);
      procedure pnh6Click(Sender: TObject);
      procedure pnh7Click(Sender: TObject);
      procedure pnh8Click(Sender: TObject);
      procedure pnha1Click(Sender: TObject);
      procedure pnha2Click(Sender: TObject);
      procedure pnha3Click(Sender: TObject);
      procedure pnha4Click(Sender: TObject);
      procedure pnha5Click(Sender: TObject);
      procedure pnha6Click(Sender: TObject);
      procedure pnha7Click(Sender: TObject);
      procedure pnha8Click(Sender: TObject);
      procedure pnr1Click(Sender: TObject);
      procedure pnr2Click(Sender: TObject);
      procedure pnr3Click(Sender: TObject);
      procedure pnr4Click(Sender: TObject);
      procedure pnr5Click(Sender: TObject);
      procedure pnr6Click(Sender: TObject);
      procedure pnr7Click(Sender: TObject);
      procedure pnr8Click(Sender: TObject);
      procedure pnra1Click(Sender: TObject);
      procedure pnra2Click(Sender: TObject);
      procedure pnra3Click(Sender: TObject);
      procedure pnra4Click(Sender: TObject);
      procedure pnra5Click(Sender: TObject);
      procedure pnra6Click(Sender: TObject);
      procedure pnra7Click(Sender: TObject);
      procedure pnra8Click(Sender: TObject);
      procedure pojdn10Click(Sender: TObject);
      procedure pojdn11Click(Sender: TObject);
      procedure pojdn12Click(Sender: TObject);
      procedure pojdn13Click(Sender: TObject);
      procedure pojdn14Click(Sender: TObject);
      procedure pojdn15Click(Sender: TObject);
      procedure pojdn16Click(Sender: TObject);
      procedure pojdn17Click(Sender: TObject);
      procedure pojdn18Click(Sender: TObject);
      procedure pojdn19Click(Sender: TObject);
      procedure pojdn1Click(Sender: TObject);
      procedure pojdn20Click(Sender: TObject);
      procedure pojdn21Click(Sender: TObject);
      procedure pojdn22Click(Sender: TObject);
      procedure pojdn23Click(Sender: TObject);
      procedure pojdn24Click(Sender: TObject);
      procedure pojdn25Click(Sender: TObject);
      procedure pojdn26Click(Sender: TObject);
      procedure pojdn2Click(Sender: TObject);
      procedure pojdn3Click(Sender: TObject);
      procedure pojdn4Click(Sender: TObject);
      procedure pojdn5Click(Sender: TObject);
      procedure pojdn6Click(Sender: TObject);
      procedure pojdn7Click(Sender: TObject);
      procedure pojdn8Click(Sender: TObject);
      procedure pojdn9Click(Sender: TObject);
      procedure PopupOpenPopup(Sender: TObject);
      procedure powcustom10Click(Sender: TObject);
      procedure powcustom11Click(Sender: TObject);
      procedure powcustom12Click(Sender: TObject);
      procedure powcustom13Click(Sender: TObject);
      procedure powcustom14Click(Sender: TObject);
      procedure powcustom15Click(Sender: TObject);
      procedure powcustom16Click(Sender: TObject);
      procedure powcustom1Click(Sender: TObject);
      procedure powcustom2Click(Sender: TObject);
      procedure powcustom3Click(Sender: TObject);
      procedure powcustom4Click(Sender: TObject);
      procedure powcustom5Click(Sender: TObject);
      procedure powcustom6Click(Sender: TObject);
      procedure powcustom7Click(Sender: TObject);
      procedure powcustom8Click(Sender: TObject);
      procedure powcustom9Click(Sender: TObject);
      procedure po_computerClick(Sender: TObject);
      procedure po_convertarchiveClick(Sender: TObject);
      procedure po_convertClick(Sender: TObject);
      procedure po_copytoClick(Sender: TObject);
      procedure po_cplClick(Sender: TObject);
      procedure po_detailsClick(Sender: TObject);
      procedure po_envstrClick(Sender: TObject);
      procedure po_flatClick(Sender: TObject);
      procedure po_hexpClick(Sender: TObject);
      procedure po_im_1024Click(Sender: TObject);
      procedure po_im_200Click(Sender: TObject);
      procedure po_im_4kcinemaClick(Sender: TObject);
      procedure po_im_4ktvClick(Sender: TObject);
      procedure po_im_50Click(Sender: TObject);
      procedure po_im_75Click(Sender: TObject);
      procedure po_im_BMPClick(Sender: TObject);
      procedure po_im_cropClick(Sender: TObject);
      procedure po_im_hdClick(Sender: TObject);
      procedure po_im_JPEG50Click(Sender: TObject);
      procedure po_im_JPEG75Click(Sender: TObject);
      procedure po_im_JPEGClick(Sender: TObject);
      procedure po_im_modifyClick(Sender: TObject);
      procedure po_im_PNGClick(Sender: TObject);
      procedure po_im_rlClick(Sender: TObject);
      procedure po_im_rrClick(Sender: TObject);
      procedure po_im_TIFFClick(Sender: TObject);
      procedure po_im_wuxgaClick(Sender: TObject);
      procedure po_manageClick(Sender: TObject);
      procedure po_movetoClick(Sender: TObject);
      procedure po_mrtClick(Sender: TObject);
      procedure po_msconfigClick(Sender: TObject);
      procedure po_msinfo32Click(Sender: TObject);
      procedure po_open_asarchiveClick(Sender: TObject);
      procedure po_open_asarchivetClick(Sender: TObject);
      procedure po_open_associatedtClick(Sender: TObject);
      procedure po_open_peaziptClick(Sender: TObject);
      procedure po_recycleClick(Sender: TObject);
      procedure po_regeditClick(Sender: TObject);
      procedure po_removeunitsClick(Sender: TObject);
      procedure po_rename_addClick(Sender: TObject);
      procedure po_rename_appenddirClick(Sender: TObject);
      procedure po_rename_extClick(Sender: TObject);
      procedure po_rename_lowercaseClick(Sender: TObject);
      procedure po_rename_deleteClick(Sender: TObject);
      procedure po_rename_prependdirClick(Sender: TObject);
      procedure po_rename_replaceClick(Sender: TObject);
      procedure po_rename_replace_caseClick(Sender: TObject);
      procedure po_rename_timestampClick(Sender: TObject);
      procedure po_rename_uppercaseClick(Sender: TObject);
      procedure po_securedeletefreeClick(Sender: TObject);
      procedure po_selectadvClick(Sender: TObject);
      procedure po_selectallClick(Sender: TObject);
      procedure po_setpwClick(Sender: TObject);
      procedure po_taskClick(Sender: TObject);
      procedure po_taskmanClick(Sender: TObject);
      procedure MenuItemOpen_archiveClick(Sender: TObject);
      procedure MenuItemOpen_exploreClick(Sender: TObject);
      procedure MenuItemOpen_pathClick(Sender: TObject);
      procedure MenuItemOpen_refreshClick(Sender: TObject);
      procedure mgolayoutClick(Sender: TObject);
      procedure mRefreshClick(Sender: TObject);
      procedure CheckBoxIgnorePathsClick(Sender: TObject);
      procedure CheckBoxARCrrClick(Sender: TObject);
      procedure CheckBoxArchiveHistoryClick(Sender: TObject);
      procedure CheckBox7zOFClick(Sender: TObject);
      procedure CheckBoxIgnoreDispClick(Sender: TObject);
      procedure CheckBoxIgnoreSelClick(Sender: TObject);
      procedure CheckBoxQuadMaxClick(Sender: TObject);
      procedure CheckBoxShowHintsClick(Sender: TObject);
      procedure CheckBoxTarBeforeClick(Sender: TObject);
      procedure CheckBoxWindowStatusClick(Sender: TObject);
      procedure ColorButton1ColorChanged(Sender: TObject);
      procedure ComboBoxARCalgoChange(Sender: TObject);
      procedure ComboBoxARCLevelChange(Sender: TObject);
      procedure cbSplitChange(Sender: TObject);
      procedure ComboBoxArcSolidChange(Sender: TObject);
      procedure ComboBoxPAQLevelChange(Sender: TObject);
      procedure ComboBoxPEAStreamChange(Sender: TObject);
      procedure ComboBoxPEAObjChange(Sender: TObject);
      procedure ComboBoxPEAVolChange(Sender: TObject);
      procedure ComboBoxPEALevelChange(Sender: TObject);
      procedure ComboBoxSplitAlgoChange(Sender: TObject);
      procedure ComboBoxThemeChange(Sender: TObject);
      procedure ComboBoxUPXChange(Sender: TObject);
      procedure ctrlbackClick(Sender: TObject);
      procedure ctrlfwdClick(Sender: TObject);
      procedure ctrlupClick(Sender: TObject);
      procedure FormCreate(Sender: TObject);
      procedure FormDropFiles(Sender: TObject; const FileNames: array of String
        );
      procedure iConsoleCreateImportExtClick(Sender: TObject);
      procedure iConsoleCreateImportClick(Sender: TObject);
      procedure BtnPjLaunchAddClick(Sender: TObject);
      procedure BtnPjLaunchExtClick(Sender: TObject);
      procedure BtnPjSaveAddClick(Sender: TObject);
      procedure ButtonOptResetClick(Sender: TObject);
      procedure ImageListRootClick(Sender: TObject);
      procedure ImageListSearchClick(Sender: TObject);
      procedure BtnPasswordClick(Sender: TObject);
      procedure BtnPjSaveExtClick(Sender: TObject);
      procedure LabelDefaultColor1Click(Sender: TObject);
      procedure LabelDefaultColor2Click(Sender: TObject);
      procedure LabelDefaultOpacityClick(Sender: TObject);
      procedure mAttributesClick(Sender: TObject);
      procedure mBenchClick(Sender: TObject);
      procedure mDateEOlderClick(Sender: TObject);
      procedure mDateEqualClick(Sender: TObject);
      procedure mDateERecentClick(Sender: TObject);
      procedure mDateOlderClick(Sender: TObject);
      procedure mDateRecentClick(Sender: TObject);
      procedure mDefaultsClick(Sender: TObject);
      procedure MenuItem1Click(Sender: TObject);
      procedure MenuItem3Click(Sender: TObject);
      procedure pmExplorepathClick(Sender: TObject);
      procedure MenuItemERAssociatedClick(Sender: TObject);
      procedure MenuItemERCustomClick(Sender: TObject);
      procedure MenuItemERPeaZipClick(Sender: TObject);
      procedure MenuItemOpen_backClick(Sender: TObject);
      procedure MenuItemOpen_ext_allClick(Sender: TObject);
      procedure MenuItemOpen_ext_displayedClick(Sender: TObject);
      procedure MenuItemOpen_ext_selectedClick(Sender: TObject);
      procedure MenuItemOpen_FlatClick(Sender: TObject);
      procedure MenuItemOpen_fwdClick(Sender: TObject);
      procedure MenuItemOpen_info_allClick(Sender: TObject);
      procedure MenuItemOpen_info_displayedClick(Sender: TObject);
      procedure MenuItemOpen_info_selectedClick(Sender: TObject);
      procedure MenuItemOpen_jumpClick(Sender: TObject);
      procedure MenuItemOpen_list_allClick(Sender: TObject);
      procedure MenuItemOpen_list_displayedClick(Sender: TObject);
      procedure MenuItemOpen_list_selectedClick(Sender: TObject);
      procedure MenuItemOpen_rootClick(Sender: TObject);
      procedure MenuItemOpen_test_allClick(Sender: TObject);
      procedure MenuItemOpen_test_displayedClick(Sender: TObject);
      procedure MenuItemOpen_test_selectedClick(Sender: TObject);
      procedure MenuItemOpen_upClick(Sender: TObject);
      procedure MenuItemPreAssociatedClick(Sender: TObject);
      procedure MenuItemPreCustomClick(Sender: TObject);
      procedure MenuItemPrePeaZipClick(Sender: TObject);
      procedure MenuItemToolCheckClick(Sender: TObject);
      procedure MenuItemToolCompareClick(Sender: TObject);
      procedure mFlatClick(Sender: TObject);
      procedure mInvertSelectionClick(Sender: TObject);
      procedure mKeyFileClick(Sender: TObject);
      procedure mOptionsClick(Sender: TObject);
      procedure mPEAClick(Sender: TObject);
      procedure mPSELargerClick(Sender: TObject);
      procedure mPSEqualClick(Sender: TObject);
      procedure mPSESmallerClick(Sender: TObject);
      procedure mPSLargerClick(Sender: TObject);
      procedure mPSSmallerClick(Sender: TObject);
      procedure mQuitClick(Sender: TObject);
      procedure mRecent1Click(Sender: TObject);
      procedure mRecent2Click(Sender: TObject);
      procedure mRecent3Click(Sender: TObject);
      procedure mRecent4Click(Sender: TObject);
      procedure mRecent5Click(Sender: TObject);
      procedure mRecent6Click(Sender: TObject);
      procedure mRecent7Click(Sender: TObject);
      procedure mRecent8Click(Sender: TObject);
      procedure mSelectAllClick(Sender: TObject);
      procedure mSizeELargerClick(Sender: TObject);
      procedure mSizeEqualClick(Sender: TObject);
      procedure mSizeESmallerClick(Sender: TObject);
      procedure mSizeLargerClick(Sender: TObject);
      procedure mSizeSmallerClick(Sender: TObject);
      procedure mSortBySelectionClick(Sender: TObject);
      procedure mUnPEAbrowseClick(Sender: TObject);
      procedure mUnPEAClick(Sender: TObject);
      procedure openwithassociatedClick(Sender: TObject);
      procedure openwithcustomClick(Sender: TObject);
      procedure openwithpeazipClick(Sender: TObject);
      procedure pcustom1Click(Sender: TObject);
      procedure pcustom2Click(Sender: TObject);
      procedure pcustom3Click(Sender: TObject);
      procedure pcustom4Click(Sender: TObject);
      procedure pcustom5Click(Sender: TObject);
      procedure pcustom6Click(Sender: TObject);
      procedure pcustom7Click(Sender: TObject);
      procedure pcustom8Click(Sender: TObject);
      procedure pmAddFileClick(Sender: TObject);
      procedure pmAddFolderClick(Sender: TObject);
      procedure pmJump2Click(Sender: TObject);
      procedure pmLoadListClick(Sender: TObject);
      procedure pmOpenPJallClick(Sender: TObject);
      procedure pmOpenPJdisplayedClick(Sender: TObject);
      procedure pmOpenPJselectedClick(Sender: TObject);
      procedure pmSaveListClick(Sender: TObject);
      procedure pmSearchAddClick(Sender: TObject);
      procedure po_addtoarchiveClick(Sender: TObject);
      procedure po_checkClick(Sender: TObject);
      procedure po_compareClick(Sender: TObject);
      procedure po_copyClick(Sender: TObject);
      procedure po_cutClick(Sender: TObject);
      procedure po_defragClick(Sender: TObject);
      procedure po_deleteClick(Sender: TObject);
      procedure po_diskcleanClick(Sender: TObject);
      procedure po_exthereClick(Sender: TObject);
      procedure po_infoClick(Sender: TObject);
      procedure po_joinClick(Sender: TObject);
      procedure po_listClick(Sender: TObject);
      procedure po_newfolderClick(Sender: TObject);
      procedure po_open_associatedClick(Sender: TObject);
      procedure po_open_customClick(Sender: TObject);
      procedure po_open_peazipClick(Sender: TObject);
      procedure po_pasteClick(Sender: TObject);
      procedure po_renameClick(Sender: TObject);
      procedure po_securedeleteClick(Sender: TObject);
      procedure po_splitClick(Sender: TObject);
      procedure po_testClick(Sender: TObject);
      procedure po_zerofileClick(Sender: TObject);
      procedure po_zerofreeClick(Sender: TObject);
      procedure cbDefaultFormatChange(Sender: TObject);
      procedure cbHashFormatChange(Sender: TObject);
      procedure cbBrowserHashChange(Sender: TObject);
      procedure cbBinariesChange(Sender: TObject);
      procedure cbBinariesStopChange(Sender: TObject);
      procedure CheckBoxExtActionAdvChange(Sender: TObject);
      procedure ComboBoxActionArcChange(Sender: TObject);
      procedure ComboBoxActionExtractChange(Sender: TObject);
      procedure RadioGroupPaqClick(Sender: TObject);
      procedure RadioGrouppwrequestChange(Sender: TObject);
      procedure RadioGroupQuadClick(Sender: TObject);
      procedure cbTimeStampChange(Sender: TObject);
      procedure SchedAddscheduleExtChange(Sender: TObject);
      procedure schedaddscheduleChange(Sender: TObject);
      procedure scheduleendextChange(Sender: TObject);
      procedure scheduleendChange(Sender: TObject);
      procedure schedulestartextChange(Sender: TObject);
      procedure schedulestartChange(Sender: TObject);
      procedure scheduleuserextChange(Sender: TObject);
      procedure scheduleuserChange(Sender: TObject);
      procedure ShellTreeViewNavCustomDraw(Sender: TCustomTreeView;
        const ARect: TRect; var DefaultDraw: Boolean);
      procedure ShellTreeViewNavKeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure ShellTreeViewNavMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure ShellTreeViewNavMouseMove(Sender: TObject; Shift: TShiftState; X,
        Y: Integer);
      procedure ShellTreeViewNavMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure SpinEditOpacityChange(Sender: TObject);
      procedure SplitterBottomMoved(Sender: TObject);
      procedure SplitterSideMoved(Sender: TObject);
      procedure SplitterOptionsMoved(Sender: TObject);
      procedure StringGridAddDblClick(Sender: TObject);
      procedure StringGridAddDrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGridAddHeaderClick(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGridAddHeaderSized(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGridAddKeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGridAddKeyPress(Sender: TObject; var Key: char);
      procedure StringGridAddKeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGridAddMouseDown(Sender: TOBject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGridAddMouseUp(Sender: TOBject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGridExtractDblClick(Sender: TObject);
      procedure StringGridExtractDrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGridExtractHeaderClick(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGridExtractHeaderSized(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure StringGridExtractKeyDown(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGridExtractKeyPress(Sender: TObject; var Key: char);
      procedure StringGridExtractKeyUp(Sender: TObject; var Key: Word;
        Shift: TShiftState);
      procedure StringGridExtractMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGridExtractMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure StringGridBookmarksColRowMoved(Sender: TObject;
        IsColumn: Boolean; sIndex, tIndex: Integer);
      procedure StringGridBookmarksDblClick(Sender: TObject);
      procedure StringGridBookmarksDrawCell(Sender: TObject; aCol,
        aRow: Integer; aRect: TRect; aState: TGridDrawState);
      procedure StringGridBookmarksHeaderClick(Sender: TObject;
        IsColumn: Boolean; Index: Integer);
      procedure StringGridBookmarksHeaderSized(Sender: TObject;
        IsColumn: Boolean; Index: Integer);
      procedure StringGridBookmarksKeyPress(Sender: TObject; var Key: char);
      procedure StringGridBookmarksMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure StringGridClipboardDblClick(Sender: TObject);
      procedure StringGridClipboardKeyPress(Sender: TObject; var Key: char);
      procedure StringGridCustEditAdvColRowMoved(Sender: TObject;
        IsColumn: Boolean; sIndex, tIndex: Integer);
      procedure StringGridCustEditAdvDblClick(Sender: TObject);
      procedure StringGridCustEditAdvMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure StringGridCustEditAdvSelectCell(Sender: TObject; aCol,
        aRow: Integer; var CanSelect: Boolean);
      procedure StringGridCustEditColRowMoved(Sender: TObject;
        IsColumn: Boolean; sIndex, tIndex: Integer);
      procedure StringGridCustEditDblClick(Sender: TObject);
      procedure StringGridCustEditMouseDown(Sender: TObject;
        Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      procedure StringGridSessionHistoryDrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGridSessionHistoryHeaderSized(Sender: TObject;
        IsColumn: Boolean; Index: Integer);
      procedure StringGridRecentDblClick(Sender: TObject);
      procedure StringGridRecentDrawCell(Sender: TObject; aCol, aRow: Integer;
        aRect: TRect; aState: TGridDrawState);
      procedure StringGridRecentHeaderSized(Sender: TObject; IsColumn: Boolean;
        Index: Integer);
      procedure tbcontrastChange(Sender: TObject);
      procedure ThemeResetClick(Sender: TObject);
      procedure themesave_labelClick(Sender: TObject);
      procedure TimerSyncTimer(Sender: TObject);
      procedure TimerBrowserTimer(Sender: TObject);
      procedure TimerWinContextStartTimer(Sender: TObject);
      procedure TimerWinContextTimer(Sender: TObject);
      procedure TimerBusyTimer(Sender: TObject);
      procedure TimerdragTimer(Sender: TObject);
      procedure TimerHintStartTimer(Sender: TObject);
      procedure TimerrenameTimer(Sender: TObject);
      procedure tmconvertClick(Sender: TObject);
      procedure tmcreateClick(Sender: TObject);
      procedure tmextractClick(Sender: TObject);
      procedure tmopenarchiveClick(Sender: TObject);
      procedure tmopenpathClick(Sender: TObject);
      procedure tmpeazipClick(Sender: TObject);
      procedure tmquitClick(Sender: TObject);
      procedure tmupdateClick(Sender: TObject);
      procedure tbtemperatureChange(Sender: TObject);
      procedure TrayIconPZClick(Sender: TObject);
      procedure TrayIconPZDblClick(Sender: TObject);
      procedure TreeViewNavMouseDown(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure TreeViewNavMouseEnter(Sender: TObject);
      procedure TreeViewNavMouseUp(Sender: TObject; Button: TMouseButton;
        Shift: TShiftState; X, Y: Integer);
      procedure w7contextlangClick(Sender: TObject);
      procedure zenc437Click(Sender: TObject);
      procedure zencutf8Click(Sender: TObject);
   private
      { private declarations }
      procedure DragOverHandler(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
   public
      { public declarations }
   end;

{$IFDEF MSWINDOWS}
type //used for custom drag and drop
  TControlDragObject = class(TDragObject)
  private
    FDragImages: TDragImageList;
    FX, FY: Integer;
  protected
    procedure EndDrag(Target: TObject; X, Y: Integer); override;
    function GetDragCursor(Accepted: Boolean; X, Y: Integer): TCursor; override;
    //function GetDragImages: TDragImageList; override;
  public
    constructor CreateWithHotSpot(AControl: TWinControl; X, Y: Integer);
    destructor Destroy; override;
  end;

procedure FixControlStyles(Parent: TControl);

//used for system drag and drop
procedure dodropfiles(winc:TWinControl; sarr:array of ansistring; dropmode:integer); external 'dragdropfilesdll.dll';
procedure dodropvfiles(winc:TWinControl; vpath:ansistring; dropmode:integer); external 'dragdropfilesdll.dll';
procedure changevpath(vpath2: ansistring);  external 'dragdropfilesdll.dll';
procedure readvstatus(var vstat: ansistring);  external 'dragdropfilesdll.dll';
procedure setvstatus(vstat: ansistring);  external 'dragdropfilesdll.dll';
{$ENDIF}
//(Windows) custom drag and drop
function dragtowin(var dragdest:ansistring):integer;
//(Windows) native drag and drop
procedure cleandragtmp;
//delete directory and verify result
function cleardir(var s:ansistring; cleardirname,force_skip_ptmpcode:boolean):integer;
function cleardirsimple(s:ansistring):integer;
//password and keyfile request
function ask_pwkeyfile:integer;
procedure hideconfirmation;
procedure showconfirmation;
//request input
function pInputQuery ( const FCaption, FPrompt, Fwarning : ansistring; var UserValue : ansistring; chkb:boolean ) : Boolean;
//launch command with progress window
function launch_cl(cl,jobcode,outname:ansistring):integer;
//get temp work path
procedure getworkpath(var work_path:ansistring; out_param:ansistring);
//compose command line
function compose_un7z_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unace_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unarc_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unzpaq_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unlpaq_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode:ansistring):integer;
function compose_unpaq_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode:ansistring):integer;
function compose_unquad_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode:ansistring):integer;
function compose_unbrotli_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unzstd_cl(var cl,jobcode,outname:ansistring; real_extract:boolean; mode,selection:ansistring):integer;
function compose_unpea_cl(var cl,jobcode,outname:ansistring):integer;
function compose_uncustom_cl(var cl,jobcode,outname:ansistring; real_extract:boolean):integer;
function compose_rarspecfun_cl(var cl,jobcode,outname:ansistring; specfun:ansistring):integer;
procedure check_files(var in_param,cl,oper:ansistring);
//execute command line
function execute_cl(cl,mode:ansistring):integer;
function execute_cl_simple(cl:ansistring):integer;
procedure execute_cl_process(cl:ansistring);
//output name
function setoutname(var s:ansistring; i:integer):integer;
procedure suggest_outname(var s:ansistring; t:ansistring; i:integer);
function addext(s:ansistring):ansistring;
procedure checkoutpath_extract;
procedure tempcheckoutpath_extract;
//from file broswer to extraction screen
procedure list_toextractor(act,modeofuse:ansistring);
//update content in archiving and extraction screens
procedure updatelayout(enumdir:ansistring);
procedure updatecontent_ext;
//set archiving and extraction screens
procedure setpanel_add(ipanel:integer);
procedure setpanel_extract(ipanel:integer);
procedure setextpopupmenu(menutype:ansistring);
procedure setscripttarpipe;
procedure setscriptuntarpipe;
//gest status bar information
procedure get_statuss(s:ansistring);
//scripting engine, import task defined in the gui as cl
function importjobcl(var cl,jobcode,outname:ansistring):integer;
function importjobcl_extract(var cl,jobcode,outname:ansistring):integer;
//get name for saving schedulted task
procedure getscheduledtaskname(stype:integer);
//set archive format
procedure on_ComboBoxArchiveCompressionLevelChange;
procedure getarccaption(s:ansistring);
procedure change_imagesplit;
procedure set_values(archive_type,compression_method,compression_level:ansistring);
procedure setquickcompset(s:ansistring);
procedure archive_type_select(s:ansistring);
procedure setsyntaxstring7z;
//set tar before compression operation
procedure check_tarbefore(tdirs:integer);
//apply switch archive / extract to original path
procedure on_checkboxsamearcclick;
procedure on_checkboxsameextclick;
//start archiving an extraction tasks
procedure on_buttonarchiveclick;
procedure on_buttonextokclick;
function extract_finalize_bytype(fn,s:ansistring; var cl,jobcode,outname,mode:ansistring; realext:boolean): integer;
//exit after task
procedure exit_withsave;
procedure exit_nosave;
//quick extraction from file browser
procedure quickextract(dest,fol,sel:ansistring);
procedure directextractfromname(var in_param,out_param:ansistring; optype:ansistring; intitems:ansistring);
//extract then move to destination
procedure moveafterextract(var outname:ansistring);
//optionally remove dir nesting from extracted content
procedure extraction_checkintermediatedir(var outname:ansistring; optype:ansistring);
//move zpaq content after extraction
procedure movezpaq(cl:ansistring);
//update archive
procedure setupdatecontrols(encnt:boolean);
procedure checkcontextadd;
procedure syncedit_archive;
procedure renamefileinarchive(nameold,namenew:ansistring;cleardestname:boolean);
function addtoarchive_inarchive(forceadd:boolean):boolean;
//test for encryption
function testencrypted:integer;
function testencrypted_open:integer;
//check selected items
function checklistsel:integer;
function checklistanysel:integer;
function checklisttotsel(var nsel:integer; var strsel:ansistring):integer;
//open archive
function open_inputselect:integer;
procedure browse_special_cases;
procedure open_archive_fromname(s:ansistring);
procedure browse_arc(mode:ansistring);
function testeditable:boolean;
function testencrypted_fromname(fname,modearchive:ansistring):integer;
procedure generate_archive_breadcrumb;
//get name of multipart archive
procedure getmultiname(var s,in_param:ansistring);
//list archive
procedure filter_archivecontent;
procedure kp_EditUn7zaFilterInteractive_nonrecursive;
procedure on_mFlatArchivesClick(i:integer);
//archive level comment
procedure readcomment;
//list directory
procedure listdir(s:ansistring; recmode,treemode:boolean);
//(Windows) list pc
procedure listpc;
//set file browser style
procedure setbrowsertype(btype:integer);
//set file browser columns
procedure set_listview_col;
procedure setbrowser_crchash(i:integer);
procedure savecol;
//display folders before files
procedure set_dirbeforefiles(dmode:integer);
//sort file browser
procedure sort_az_stringgridlist(c:integer);
//update file browser content
procedure update_listview;
procedure update_listview_sel;
//refresh file browser
procedure navrefresh;
procedure do_forcerefresh;
//lock and unlock file browser waiting for updating the status
procedure enter_busy_status;
procedure exit_busy_status;
//open item from file browser
procedure grid_obj_open;
function cp_open(s:ansistring; desk_env:byte):integer;
function count_clipboard:ansistring;
procedure openwith_base(act,target:ansistring);
//define extensions of items not to be opened without user's consent
procedure on_ComboBoxsecChange;
//treeview
procedure populatetree;
procedure populatetreefunctions;
function gettreeicon(sg:TStringGrid; arow:integer):integer;
//tab bar
function gettabname(nrow:integer):ansistring;
procedure save_tabs;
//status bar
procedure update_info;
function isarchiveeditable:integer;
procedure set_statuss_nav;
//bookmarks
function extractbookmarkname(s:ansistring):ansistring;
//address bar
procedure update_addressbar(apath:ansistring);
//search
procedure setsearchbar(sb:byte);
procedure rsearch;
procedure do_resetsearch;
procedure list_un7z_search;
//search on the web
procedure run_websearch(s:ansistring);
//move file
procedure clickmoveto;
//execute function
procedure do_pmfun(capt:ansistring);
//apply compression preset
procedure settpreset(i,sz:integer; stylemode:boolean);
//password manager
procedure loadpm;
procedure setpm(pmfun:integer);
//bookmarks
procedure load_bookmarks;
//set theme
procedure ComboBoxTheme_onchange;
procedure setwindowsopacity;
procedure getthemepath(var thpath:ansistring);
procedure settabsstyled;
//localization
procedure peaziplanguage(s: ansistring);
//configuration
procedure save_conf;
procedure updateconf_modified;
//reset
procedure reset_temp(mode:integer);
procedure dohistoryreset;
//restart peazip
procedure restartpeaapp;
procedure restartclosepeaapp;
procedure saverestartclosepeaapp;
//startup
procedure condopenaction(s:utf8string);

const
  HLIBRE_DIR    = 0; //hardcoded "libre directive" 0 not hardcoded, read from configuration; 1 hardcoded to allow only using Free Software components; 2 hardcoded to allow only using Free Software components and open archive formats (not encumbered by patents for read nor write)
  HPRIVACY_MODE = 0; //hardcoded privacy_mode directive 0 not hardcoded, read from configuration; 1,2 hardcoded skippable or non skippable password request at startup, overriding configuration
  HSYSBIN       = 0; //hardcoded use of binaries in system paths, eg as in $PATH 0 no, read from configuration; 1 only 7z / p7zip; 2 all backend binaries
  HBINPATH      = '';//hardcoded path for binaries
  HCONFPATH     = '';//hardcoded path for configuration
  HSHAREPATH    = '';//hardcoded path for other data (non binary, non configuration)
  WS_EX_LAYERED = $80000;
  LWA_ALPHA     = $2;
  PEAZIPVERSION = '10.7';
  PEAZIPREVISION= '.0';
  SPECEXTCONST  = '001 bat exe htm html msi r01 z01';
  {$IFDEF MSWINDOWS}
  SECEXTCONST   = 'exe cmd msi bat ps1 vbs reg';
  {$ELSE}
  {$IFDEF DARWIN}
  SECEXTCONST   = 'sh scpt scptd applescript';
  {$ELSE}
  SECEXTCONST   = 'sh';
  {$ENDIF}
  {$ENDIF}
  PREFALGOCONST = 'CRC32 CRC64 MD5 RIPEMD160 SHA1 BLAKE2S SHA256 SHA3_256';
  MAXNDIRTREE   = 4096;
  DEFAULT_THEME = 'main-embedded';
  DLEFT         = 64;
  DTOP          = 64;
  DWIDTH        = 1024;
  DHEIGTH       = 600;
  DGWLEFT       = 92;
  DGWTOP        = 92;
  DGWWIDTH      = 640;
  DGWHEIGTH     = 320;
  MAXTABN       = 256;
  NAMEVARSTR    = ' - ';
  ZCHAR         = '+';
  ZSTRING       = '----------';
  ZSTRINGS      = '--';
  ZSTRINGL      = '------------------- ----- ------------ ------------  ------------------------';
  {$IFDEF MSWINDOWS}
  NDLINES       = 3;//15.x+
  {$ELSE}
  NDLINES       = 3;//15.x+
  {$ENDIF}
  RAR5STRING    = 'Details: RAR 5'; //check first 14 characters
  READE_LIST    = '7Z, ACE, ARC/WRC, ARJ, BR, BZ/TBZ, CAB, CHM/CHW/HXS, COMPOUND (MSI, DOC, XLS, PPT), CPIO, GZ/TGZ, ISO, Java (JAR, EAR, WAR), LZH/LHA, Linux (DEB, PET/PUP, RPM, SLP), NSIS, OOo, PAK/PK3/PK4, PAQ/LPAQ/ZPAQ, PEA, QUAD/BALZ/BCM, RAR, TAR, WIM/SWM, XPI, Z/TZ, ZIP, ZST...';
  WRITEE_LIST   = '7Z, 7Z-sfx, ARC, ARC-sfx, BR, BZ2, GZ, *PAQ, PEA, QUAD/BALZ/BCM, split, TAR, UPX, WIM, XZ, ZIP, ZST';
  APPMAIN       = 'PeaZip';
  STR_7Z        = '7Z';
  STR_ARC       = 'ARC';
  STR_BROTLI    = 'Brotli';
  STR_BZIP2     = 'BZip2';
  STR_GZIP      = 'GZip';
  STR_LPAQ      = 'LPAQ';
  STR_PAQ       = 'PAQ';
  STR_PEA       = 'PEA';
  STR_QUAD      = 'QUAD/BALZ/BCM';
  STR_TAR       = 'TAR';
  STR_UPX       = 'UPX';
  STR_ZIP       = 'ZIP';
  STR_ZPAQ      = '*PAQ';
  STR_WIM       = 'WIM';
  STR_XZ        = 'XZ';
  STR_ZSTD      = 'Zstd';
  //PeaZip's folder in working directory, containing all temporary work files unless 1) set to be created in output 2) archive conversion, always run in output
  STR_PZWORKTMP = 'peazip-tmp';
  //temp app subfolder, where different peazip instances can exchange messages and data
  STR_PEAZIPTMP = '.pztmp';
  //temp subdirs, deleted as soon as possible by each instance during use
  STR_TMP       = '.ptmp';
  STR_STMP      = '.pstmp';//special preview
  STR_TMPEXT    = '.petmp';//interactive extraction
  STR_TMPDD     = '.pdtmp';//drag and drop extraction
  //temp files
  STR_TESTOUT   = '.ptestouttmp';
  STR_STOPALL   = '.pstopalltmp';
  STR_TMPDROPE  = '.pdropetmp';
  STR_TMPERRI   = '.perritmp';

var
   FormPeach: TFormPeach;
   patheditor:TEdit;
   TargetNode,TargetNode2:TTreeNode;
   TS:TTimeStamp;
   clipcontent,clipcontent1:TClipcontent;
   aconf,conf,book,tabsf,cedit,t:text;
   pmfileb:file of byte;
   imod,inbcnode,rowsize,selnode:integer;
   abcrs: array [1..4] of ansistring;
   specextensions,secextensions: array of ansistring;

   //scaling
   il16,ilsmall,il96: TImageList;
   qscale,qscaleimages,pspacing,pzoom,pspacingd,pzoomd,ensmall,ensmalld,
   icon_sizeplus,baseiconsize,scalediconsize,spacedscalediconsize,relativeiconsize,
   COL1D,COL2D,COL3D,COL4D,COL5D,COL6D,COL7D:integer;

   //address bar colors
   abactivecol,abarchivecol,tabpencol,tabbrushcol,tablowcol,tabbrushhighcol:tcolor;

   //Listview hints
   h:THintWindow;
   r:TRect;
   shint,prevshint:ansistring;

   //status extractor
   epfolder,epfolder1,epdefault,epextract,epskip,epdelete,epfilters,eparcextract,eparcskip,epaceextract,epsupp,epunsupp,vexcustom3,epunsupp1:integer;
   epdefaultextractpath,vexcustom1,vexcustom2,vexc1,vexc2,vexc3,vexc4,vexc5,vexc6,vexc7,vexc8:ansistring;
   epdopt,vexpaths,epsni,epsns,epsnz,epzall,epzfull,epzabs,epzfor,ezstderr:integer;

   //status archiver
   apdefault,apformat,apfilters,apenum,apencext,apappend,apcustext,apsplit,apspin,apsize,apdelete,apverbose,appw,apdopt,aprar,aprar5,aprardict,aprarmanual,aprarblake2,
   aprarsfx,aprarsolid,apprarrr,aprarrr,aprarsaveopen,aprarsavesecurity,aprarsavestreams,aprarlastmodtime,aprarlock:integer;
   apdefaultarchivepath,apextcapt:ansistring;
   v7z1,v7z2,v7z3,v7z4,v7z5,v7z6,v7z7,v7snoi,v7snon,v7z7b,v7z8,v7z9,v7z10,v7z11,v7z11b,v7z13,v7z13b,v7z14,v7z15,v7z16,v7z16a,v7z16b,v7z17,v7z18,v7z17c,vtartype,vtartime,v7zpaths,vlevel_7z,vlevel_bzip2,vlevel_gz,vlevel_zip,vlevel_xz,v9b,v9z,v9r,vbr1,vzst1:integer;
   v7z12,vmethod_7z,vmethod_zip,varc7,vcustom1,vcustom2,vcustom3:ansistring;
   vquad1,vquad2,vpaq1,vpaq1b,vpaq2,vupx1,vupx2,vupx3,varc1,varc2,varc3,varc3b,varc4,varc5,varc6,varc8,vsplit1,vpea1,vpea2,vpea3,vpea4,vpea5,vpea6,vcustom4:integer;

   //status options
   vopt1,vopt1b,vopt1c,vopt7c,vopt12t,vopt19e,vopt19esec,vopt19f,vopt5d3t,vopt5csv:ansistring;
   vopt2,vopt3,vopt4,vopt4b,vopt4c,vopt4d,vopt4e,vopt4f,vopt4g,vopt4h,vopt5,vopt5b,vopt5c,vopt5d,vopt5dt,vopt5d4,vopt5utc,vopt5d1,vopt5d2,vopt5d3,vopt5e,
   vopt5f,vopt5f1,vopt5g,vopt5dup,vopt5dsh,vopt5gtar,vopt5gtar1,vopt5h,vopt5sw,vopt5ca,vopt6,vopt7,vopt7b,vopt8,vopt9,vopt10,vopt11,vopt12,voptlibre,
   voptprivacy,vopt13,voptts,vopt15c,vopt15d,vopt15e,vopt15e2,vopt15f,vopt15g,vopt15gg,vopt15h,vopt15i,vopt16,vopt17,vopt18,vopt18b,
   vopt19,vopt19b,vopt19c,vopt19csec,vopt19d,vopt20,vopt20b,vopt21,vopt22,vopt22b,vopt23,vopt23b,vopt24,vopt24b,vopt24c,vopt25,valg1,valg2,valg3,valg4,valg5,
   valg6,valg7,valg8,valg9,valg10,valg11,valg12,valg13,valg14,valg15:integer;

   //image editing options
   simgfun, simgw, simgh, simgper, simgasp, simgconv, simgj, simgt, simgb, simgl, simgr, simgpercent, deco_style:integer;
   fthumbs,gofthumbs:boolean;

   devicon:array [1..26] of TBitmap;
   Bplaceshistory,Barchive_bigger2,Barchive_big,Barchive,BArchiveSupported,
   BFileSupported,BExesupported,Bunsupported,Bback,Bbookmark,Bbookmarkadd,Bclearlayout,
   Bdefaults,Bdelete,Bdvd_supported,Bexpand,Bextractall,Bextractall_big,Bfd_supported,
   BFolder,Bgo,Bgopath,Bgoup,Bhd_supported,Binfo,Bkeyfile,Bloadlayout,Blocker,Blocker2,
   Bmail,Bnav,Bp0,Bpreview,Bram_supported,Brefresh,Bremote_supported,Bremovable_supported,
   Bresetpath,Broot,Brun,Bsavelayout,Bsearch,Bdesk,Bsystemtools,Btestall,Btestall_big,
   Bstop,Bweb,Bwipe,Blink,Bconvert,Bconvert_big,Btxt,Bspreadsheet,Bvideo,Baudio,Bimage,
   Bpresentation,Bpdf,Bsupported,Bbat,Bdll,Bdb,Bgif,Bico,Bvector,
   Bdetailsfs,Bjpeg,Bapps,Bextractalln_big,Bextractalln,
   Barc7z,Barcrar,Barczip,Barcblock,Barcdisk,Barcinstaller,
   Btool_cut,Btool_copy,Btool_paste,Btool_openw,Btool_properties,Btool_rename,
   Btool_delete,Btool_dup,BTool_cut_small,BTool_copy_small,BTool_dup_small,
   Btool_properties_small,Btool_rename_small,BTool_resize,BTool_crop,
   BTool_rl,BTool_rr,BTool_resize_small,BTool_crop_small,
   BTool_rl_small,BTool_rr_small,Bdownloadfolder,Bcloudfolder,Bhomefolder,
   Bdvd_supported96,Bfd_supported96,BFolder96,Bhd_supported96,Bram_supported96,
   Bremote_supported96,Bremovable_supported96,Btxt96,Bspreadsheet96,Bvideo96,Baudio96,Bimage96,
   Bpresentation96,Bpdf96,Bsupported96,Bbat96,Bdll96,Bdb96,Bgif96,Bico96,Bvector96,Bjpeg96,BArchiveSupported96,
   BFileSupported96,BExesupported96,Bunsupported96,Blink96,Bweb96,Bmail96,
   Barc7z96,Barcrar96,Barczip96,Barcblock96,Barcdisk96,Barcinstaller96,
   Bfm,Bdetailsf,Blistf,Biconsf,Bnonthemed,
   Bav,Bfilter,Bflat,Bcollapse,
   Bp1,barc,bext,bextf,btest,blist,bmenu,bseparator,bsettings,
   binfodlg,bwarningdlg,bwarningsmall,berrordlg,Bdesk96,Bhomefolder96,
   Bdownloadfolder96,Bcloudfolder96: TBitmap;

   dfilenames:array of string;

   devname:array [1..26] of ansistring;
   patchclip:array of array [0..15] of ansistring;
   israr5,browse_option,caption_release,caption_build,tempstring,alt_tempstring,archive_type,archive_t,
   compression_method,compression_level,parameters,kdir,in_name,in_file,in_folder,
   output_name,out_qualified_name,size_u,cks,data_compression,save_cks,bcomp,
   keyfname,themedir,theme_name,theme_author,theme_license,theme_path,wrk_path,executable_path,resource_path,binpath,sharepath,
   persistent_source,fun,subfun,btfun,tools_path,color1,color2,color3,color4,color5,color1d,
   color2d,color3d,color4d,color5d,prev_type,
   prev_method,prev_level,method_7z,dmethod_7z,method_zip,dmethod_zip,ptmpcode,ptmpdir,pstmpdir,graphicsfolder,graphicsfolderd,
   archive_content,wincomspec,delimiter,desktop_path,prevpanel,winver,majmin,indir,destdir,
   prev_destdir,local_desktop,home_path,confpath,currentcomp,currentfs,usr_documents,usr_music,usr_videos,usr_pictures,users_root,
   public_documents,public_home,usr_recent,usr_searches,usr_libraries,usr_downloads,usr_sendto,
   shared_dropbox,shared_googledrive,shared_onedrive,shared_skydrive,shared_ubuntuone,shared_myboxfiles,
   usr_name,lastobj,lastobjarch,custedit1,custedit2,custedit3,custedit4,custedit5,
   custedit6,custedit7,custedit8,custedit9,custedit10,custedit11,custedit12,custedit13,
   custedit14,custedit15,custedit16,prevcaption,advedit1before,advedit2before,advedit3before,
   advedit4before,advedit5before,advedit6before,advedit7before,advedit8before,advedit1after,
   advedit2after,advedit3after,advedit4after,advedit5after,advedit6after,advedit7after,
   advedit8after,advedit1alt,advedit2alt,advedit3alt,advedit4alt,advedit5alt,advedit6alt,
   advedit7alt,advedit8alt,
   winpfolder,winpfolder32,winsysfolder,winappdatafolder,fun_status,lastoutpath,lastextractionpath,
   status0,status1,status_curfilesystem,status_curarchive,statuss,statusw,statust,statusr,
   checkver,extsel,defaultextractpath,defaultarchivepath,dn,dn1,
   prevrun,titlestring,sortstatusstring,updateid,prevupdateid,prevarchive,inputfile,
   peaziptmpdir,peaziptmpdirroot,peaziptmpdir_tmp,basedragtitle,unacepluginstatus,unrar5pluginstatus,addformatspluginstatus,
   prevlistfilter,browsersdir,custom_work_path,tempaddinarchive,beingpreviewed,moverelpath,
   move_out_param,lcmethod,langstrhint,plistfile,statushint,infocpu,inforam,infomem,
   statushintar,statushintex,typehint,csvsep,origout,origoutnf,origouttf,origoutmf,
   prefixd,prefixf,prefixdaz,prefixdza,prefixfaz,alias7z,rarcommentfilename,mddtarget,pipepw,
   specbrowse,pspecbrowse,syntaxstring7z,renorig,browserwarningmsg,browserwarningmsg1,browserwarningmsg2:ansistring;

   tvolumes,tdirs,tfiles,psize,tvol,tsize:qword;
   sizefreeout,sizefreewrk,sizefreeint: int64;

   devtype:array [1..26] of integer;
   appdb:array [1..16] of integer;
   appdb2:array [1..8] of integer;
   imlistindex,imtodo,exelistindex,exetodo:array of integer;
   listrow,listsortcol,listsortcol1,listsortcol2,listsortbook,title_lines_7z,
   currow1,browsingmode7z,splittersize,splitter2size,lastbar,lasttoolbar,prevbar,splitter3size,splitsearchsize,
   barheight,mbarheight,mmbarheight,intcellhw,expandfs,expandroot,expandbook,expandhistory,expandmore,expandrun,expandapps,expandfun,
   secgroupheight,listcol,ares,esna,euns,col1size,col2size,col3size,col4size,col5size,col6size,col7size,colmethodsize,colcommentsize,
   toolsize,ptoolsize,navbar,addressbar,ptabbar,psidebar,work_dir,rootdirrecord,mappeddrivesinfo,session_mappeddrivesinfo,
   appentries1,pcount,refreshstatus,usealtcolor,altaddressstyle,altbread,macbread,solidaddressstyle,toolcentered,alttabstyle,accenttoolbar,highlighttabs,altaddressstyled,toolcenteredd,solidaddressstyled,alttabstyled,accenttoolbard,usealtcolord,highlighttabsd,ws_top,ws_left,ws_height,ws_width,ws_gw_top,ws_gw_left,ws_gw_height,ws_gw_width,
   archive_type_selected,prebrowsesize,smalliconsize,largeiconsize,browsersize,browsertype,
   sync,imindex,exeindex,showthumbnails,simplesearch,recsearch,issearching,browserch,arcabspath,keeppw,usebreadcrumb,
   pmnotdecrypted,pimmersive,hnum,tpcomp,tpreset,prevdrbutton,bctemp,listmode,favdelete,convertverbose,convertpw,
   libre_directive,tsstyle,updatingcontent,wasselected,wasselectedp,ptabid,atabid,
   doptadd,doptext,privacy_mode,showvolatile,tryopenwerrors,forcecanbechanged,forcetype,excludeef,tsutc,euns1,
   autosync,sys7zlin,i16res,i32res,i48res,i96res,tabheight,tablabelheight,tabheightl,pbarh,autoopentar,spansize,advopdictionary,
   advopword,advoppasses,advopblocksize,noconfdel,specialmoderar,pforceconsole,closeonsingleextract,movetorelativepath,
   forcebrowse,forceconvert,forcelayout,nitems,storecreated,max_cl,temperature,temperatured,contrast,
   contrastd,lsize,ntoolstyle,pperc,dirbeforefiles,decostyle,decostyled,abt,altmenu,seccond,allowvirtual,sizevirtual,virtualopt,
   curselcount,prevselcount:integer;

   ltime,stime:longint;

   ent_buffer: array [0..63] of byte;
   opacity,opacityd,df,pf,pobj,pcompr,pvol,nrkdf,trkdf,pstream,salgo,zaout,zaout1,ws,ws_status,
   ignorepathextand,level_7z,dlevel_7z,level_xz,level_brotli,level_zstd,level_rar,
   level_bzip2,level_arc,solid_arc,rr_arc,algo_arc,algo_zipenc,level_gz,level_paq,threads_zpaq,paqver,
   level_quad,level_upx,level_zip,dlevel_zip,snoi7z,snon7z,openw_all7z,showpwfield,setencfn,intpw,hidepwconf,
   autoclosegwrap,mailkeep,autoopen,autotest,autoclosepeazip,skipenctest,tartype,tartime,
   browserstyle,desk_env,prebrowse,maxargsize,ignorepathdisp,enc7zscc,sni7z,sns7z,snh7z,snl7z,ssp7z,stl7z,snz7z,maxbrotli,maxzstd,
   ignorepathsel,removeintdir,ignorepathdd,savehistory,fav7z,favARC,favbz,favcustom,favgz,favpea,favquad,favsfx,
   favsfxarc,favsplit,favtar,favupx,favzip,favzpaq,favwim,favxz,favbrotli,favzstandard,enableextand,
   extpw,algodisp,algoall,algoadler,algocrc16,
   algocrc24,algocrc32,algocrc64,algoed2k,algomd4,algomd5,algoripemd160,algosha1,
   algosha3_256,algosha256,algosha3_512,algosha512,algowhirl,showguihints,customsyntax,
   customsyntax1,erasepasses,filesizebase,extopt7z,extoptarc,extaction7z,extactionarc,extactionace,
   clipmode,jobdefenc,
   archivenameenc,tonewfolder,parallelarchive,zcopy,mcuzip,nameaspartent,spchar,enumd,addencext,repcustext,addtstext,swzipx,
   defaulttabsmenu,multi_option,memuse_option,nonverboselog,skipdel,disableintscript,use7zunrar5,useextrac32,sort7zbytype,browsersd,userar,userar5,setrarmanual,userarblake2,
   userardict,userarsfx,userarsolid,userarrr,puserarrr,userarsaveopen,userarsavesecurity,userarsavestreams,userarlastmodtime,
   userarlock,tmpremoveintdir,renselonly,renfilesonly,defaultspanning,spanunit,zpaqall,zpaqfull,zpaqabsolute,zpaqforce,
   dragtargetprotect,whenspecialopen,howspecialopen,ptsync,taskpriority,defaultactionst,displayfoldercontent,filterbrowser,
   immediate_execution,defaultarchiveaction,showsearchbar,tar_atomic,tar_atomic_convert,syntaxlevel7z,convint,
   qdup,restoretabbar,scripttarpipe,scriptuntarpipe,zstderr:byte;

   call_validated,keyf_opened,no_more_files,az,
   using_tarbefore,tarbeforenameexception,seemencrypted,imgloaded,imgloading,
   settingvalues,archiveopened,browsinghistory,filecopying,openstarted,dragcancelled,
   listingdir,control_listingdir,done_listingexe,waitdrawok,needwaitupdating,updatingarchive_inarchive,goarchiving,updatingarchive_sync,
   stayopen,completeshowpea,savetype,pcmenupopulated,updatinglistview,updatingsel,rowselect,smartsortenabled,showmenu,
   thighlight,ccreated,caccessed,cmethod,ctype,csize,cpacked,cdate,catt,ccomment,ccrc,cfree,cfs,multiaddupdating,dontsavecustom7z,
   dontsavecustomzip,forceopenasarchive,skipapstatus,browserbusy,fromtree,spinchanged,
   swapbars,swaptab,treeonbutton,rightdropbutton,popupclosed,done_quickfunctions,contextconvert_switch,
   funflag,endflag,setbs,launchwithsemaphore,disable_twofactor,extselall,tmpenumd,uacneeded,
   cancellingarchive,nffromdrag,unrar5shown,unaceshown,restartingapp,needsave,is_searching,
   h_folders,nomatch,set_archivetree,aisexpanded,setsequenceerror,tmpextnf,settmpextnf,
   keeppreview,loadadvdefaults,havewinrar,singleextract,specialopen,pclicked,
   willbemoved,forcewillbemoved,forcenotwillbemoved,pdrop,prebrowsing,imported_tarbeforejob,
   darwinsimulatedrop,starttaberror,updatingconf,intdd,consolecl,piperar,settingadv,navbarhidden,pshowh,oafromgrid,frompc,dolistupdate:boolean;

   activelabel_options,activelabel_add,activelabel_extract,activelabel_apps:TLabel;

   //system drag and drop
   disdrag,threadextracting,imdel:boolean;
   nativedrag:integer;
   {$IFDEF MSWINDOWS}
   vpatha,vpathb,vpath2,vpathname:ansistring;
   //drag and drop
   FDragObject:TDragObject;
   //semaphore
   psem,psemwait: THandle;
   {$ENDIF}

   lang_file:ansistring;
   //text strings
   txt_10_7_errload,txt_10_7_errfile,txt_10_7_first,txt_10_7_fit,txt_10_7_fith,txt_10_7_fitw,txt_10_7_keep,txt_10_7_next,txt_10_7_prev,txt_10_7_pwh,txt_10_7_thumbnails,txt_10_7_images,
   txt_10_6_virtual,
   txt_10_5_ntfsalt,txt_10_5_type_description_rar,txt_10_5_sectype,txt_10_5_sectypewarning,txt_10_5_checkmotw,txt_10_5_sh,txt_10_5_fr,txt_10_5_pathlock,
   txt_10_4_moving,
   txt_10_3_classic,txt_10_3_m,txt_10_3_pm,txt_10_3_minimal,txt_10_3_ascii,txt_10_3_aw,
   txt_10_2_savecopy,
   txt_10_1_full,txt_10_1_under,txt_10_1_kdfw,
   txt_10_0_exptrash,txt_10_0_comp,txt_10_0_ptarzst,txt_10_0_ptargz,txt_10_0_ptarxz,txt_10_0_save,txt_10_0_tp,
   txt_9_9_uac,txt_9_9_utc,TXT_9_9_kdf,
   txt_9_8_fnew,txt_9_8_fsmart,txt_9_8_alwaysflat,
   txt_9_7_tarpipe,txt_9_7_smartsorting,
   txt_9_6_centered,txt_9_6_loadpconfirm,txt_9_6_loadp,txt_9_6_saveppw,txt_9_6_savepoverwrite,txt_9_6_savep,txt_9_6_cside,txt_9_6_scside,
   txt_9_5_all,txt_9_5_precond,txt_9_5_largea,txt_9_5_mediuma,txt_9_5_smalla,txt_9_5_reopentab,txt_9_5_savetabs,txt_9_5_sb,
   txt_9_4_savecomment,txt_9_4_hintcomment,txt_9_4_r,txt_9_4_rw,
   txt_9_3_contrast,txt_9_3_continue,txt_9_3_fsd,txt_9_3_fsw,txt_9_3_canedit,txt_9_3_canforce,txt_9_3_cannotedit,txt_9_3_mrar,
   txt_9_2_7za,txt_9_2_swt,txt_9_2_tfaq,txt_9_2_doc,txt_9_2_updates,txt_9_2_compact,txt_9_2_changelog,txt_9_2_tos,
   txt_9_1_7zs,txt_9_1_ac,txt_9_1_ef,txt_9_1_enlargeicons,txt_9_1_nw,txt_9_1_qdup,txt_9_1_closeall,
   txt_9_0_tnav,txt_9_0_showmainmenu,txt_9_0_navmenu,txt_9_0_accesstime,txt_9_0_hl,txt_9_0_sl,txt_9_0_mem,txt_9_0_autoexttar,txt_9_0_plugind,txt_9_0_df,
   txt_8_9_empty,txt_8_9_ttb,txt_8_9_stoptest,txt_8_9_disp,txt_8_9_parsing,
   txt_8_8_snz,txt_8_8_snoi,txt_8_8_snon,txt_8_8_altt,txt_8_8_light,txt_8_8_autotest,txt_8_8_ca,txt_8_8_cb,txt_8_8_centered,txt_8_8_cw,txt_8_8_btn,txt_8_8_lnk,txt_8_8_tab,txt_8_8_sm,txt_8_8_solcol,txt_8_8_intnote,
   txt_8_7_csvhelp,txt_8_7_csv,txt_8_7_showsearchbar,txt_8_7_verifybin,txt_8_7_hok,txt_8_7_hnotok,txt_8_7_after,txt_8_7_mo,txt_8_7_bintest,txt_8_7_showhm,txt_8_7_showsm,
   txt_8_6_clear,txt_8_6_noclear,txt_8_6_nosimple,txt_8_6_immediate,txt_8_6_yessimple,
   txt_8_5_detailslarge,txt_8_5_listlarge,txt_8_5_intext,txt_8_5_advbrowser,txt_8_5_loadlayout,txt_8_5_samplescripts,
   txt_8_4_keepopenerrorslist,
   txt_8_3_prefalgo,txt_8_3_mbubin,txt_8_3_mbudec,txt_8_3_mbu,txt_8_3_maxarg,txt_8_3_skipdel,txt_8_3_cw,txt_8_3_lw,txt_8_3_temperature,txt_8_3_htab,txt_8_3_noupx,
   txt_8_2_slower,txt_8_2_df,txt_8_2_vreport,txt_8_2_alltimes,txt_8_2_supportedby,txt_8_2_keep,txt_8_2_skipet,txt_8_2_ta,txt_8_2_tc,txt_8_2_tm,
   txt_8_1_volumes,txt_8_1_ed,txt_8_1_slow,txt_8_1_preparse,txt_8_1_nopreparse,txt_8_1_preparsehint,txt_8_1_bo,txt_8_1_bop,txt_8_1_togglearc,txt_8_1_vslow,
   txt_8_0_altcol,txt_8_0_commonalgo,txt_8_0_forcebrowse,txt_8_0_forceconvert,txt_8_0_forcetyping,txt_8_0_forcetypinghelp,txt_8_0_setpwopt,txt_8_0_defaultaction,txt_8_0_defaultactionhint,txt_8_0_enableextand,
   txt_7_9_spacing,txt_7_9_zooming,
   txt_7_8_dd,txt_7_8_custext,txt_7_8_rel,txt_7_8_priorityhigh,txt_7_8_priorityidle,txt_7_8_prioritynormal,txt_7_8_priorityrealtime,txt_7_8_tpriority,txt_7_8_requirerestart,txt_7_8_changelocalization,
   txt_7_7_sys7zreq,txt_7_7_sys7z,txt_7_7_nonetemp,txt_7_7_outtemp,txt_7_7_tw,txt_7_7_noneall,
   txt_7_6_zipenc,txt_7_6_custenc,txt_7_6_forcelocalenc,txt_7_6_forceutf8enc,txt_7_6_defaultenc,txt_7_6_setcurdef,txt_7_6_setdef,txt_7_6_cpnote,txt_7_6_tacolor,txt_7_6_color,txt_7_6_dim,txt_7_6_dark,txt_7_6_tno,txt_7_6_tadvanced,txt_7_6_tsimple,txt_7_8_destexistfile,txt_7_8_update,
   txt_7_5_autoclosesingle,txt_7_5_dragnone,txt_7_5_draglock,txt_7_5_draghide,txt_7_5_draglh,txt_7_5_specialbrowse,txt_7_5_ee,txt_7_5_always,txt_7_5_ask,txt_7_5_never,txt_7_5_cutlen,txt_7_5_cutlenw,txt_7_5_repnascii,
   txt_7_4_tcurr,txt_7_4_tkeep,txt_7_4_7zfbrotlicomp,txt_7_4_7zfzstandardcomp,txt_7_4_lock,txt_7_4_locked,txt_7_4_presetrar,txt_7_4_comment,txt_7_4_recover,txt_7_4_lockconfirm,txt_7_4_setarc,txt_7_4_setext,txt_7_4_swzipx,
   txt_7_3_profile7zfastest,txt_7_3_profile7zfast,txt_7_3_maxbr,txt_7_3_maxzstd,txt_7_3_stl,txt_7_3_archiveerrors,txt_7_3_archiveerrorshint,txt_7_3_noconfdel,txt_7_3_clickextall,
   txt_7_2_altcomp,txt_7_2_clearnoupdate,txt_7_2_autoclosepeazip,txt_7_2_zpaqall,txt_7_2_extcomp,txt_7_2_extcompultra,txt_7_2_fbrotlicomp,txt_7_2_fzstandardcomp,txt_7_2_loadcompsettings,txt_7_2_savecompsettings,txt_7_2_source,txt_7_2_updateclear,
   txt_7_1_type_description_brotli,txt_7_1_typetosearch,txt_7_1_type_description_zstd,txt_7_1_profileintermediate,txt_7_1_renfilesonly,txt_7_1_smart,txt_7_1_new,
   txt_7_0_autoopentar,txt_7_0_exttmppath,txt_7_0_af,
   txt_6_9_autou,txt_6_9_uconf,txt_6_9_opuns,txt_6_9_forceu,txt_6_9_overarch,
   txt_6_8_ndrop,txt_6_7_nop,txt_6_6_pdupfound,txt_6_6_rsh,txt_6_6_pdupfind,txt_6_6_forcemodify,
   txt_6_5_sni,txt_6_5_sns,txt_6_5_mandatory,txt_6_5_askp,txt_6_5_privacy,txt_6_5_nop,
   txt_6_5_chp,txt_6_5_np,txt_6_5_def,txt_6_5_abort,txt_6_5_error,txt_6_5_yesall,
   txt_6_5_yes,txt_6_5_warning,txt_6_5_seqerr,txt_6_5_showvolatile,txt_6_5_force,
   txt_6_4_tabbar,txt_6_4_new,txt_6_4_closeallother,txt_6_4_closeright,
   txt_6_4_collapse,txt_6_4_expand,txt_6_4_openintab,
   txt_6_4_paths,txt_6_4_relative,txt_6_4_full,txt_6_4_absolute,txt_6_4_appdirn,txt_6_4_prepdirn,
   txt_6_3_uar,txt_6_3_syn,txt_6_3_autoadjust,txt_6_3_cinfo,
   txt_6_2_encext,txt_6_2_archive,txt_6_2_container,txt_6_1_ec,txt_6_0_msq,
   txt_5_9_lff,txt_5_9_pff,txt_5_9_start,
   txt_5_8_ascii,txt_5_8_cp,txt_5_8_utf,txt_5_8_l0,txt_5_8_l1,txt_5_8_l2,txt_5_8_fs,txt_5_8_fsr,
   txt_5_7_pinstalled,txt_5_7_pmissing,txt_5_7_plugin,
   txt_5_6_exarc,txt_5_6_upexisting,txt_5_6_layouts,txt_5_6_rc,txt_5_6_basic,txt_5_6_verbose,
   txt_5_6_tab,
   txt_5_5_case,txt_5_5_add,txt_5_5_ext,txt_5_5_halt,txt_5_5_replaceneww,txt_5_5_plugin,
   txt_5_5_lower,txt_5_5_newext,txt_5_5_new,txt_5_5_old,txt_5_5_delete,txt_5_5_replacestr,
   txt_5_5_replaceoldw,txt_5_5_upper,txt_5_5_extw,txt_5_5_intdir,txt_5_5_string,
   txt_5_5_n,txt_5_5_position,txt_5_5_positionw,txt_5_5_positionwd,txt_5_5_starting,
   txt_5_5_similar,txt_5_5_select,txt_5_5_addsel,txt_5_5_subtractsel,txt_5_5_copypath,
   txt_5_5_datesameday,txt_5_5_datesamehour,txt_5_5_datesamemonth,txt_5_5_datesameweek,txt_5_5_datesameyear,
   txt_5_5_datehour,txt_5_5_datemonth,txt_5_5_dateweek,txt_5_5_dateyear,txt_5_5_dateday,
   txt_5_5_scan,
   txt_5_4_da,txt_5_4_lv,txt_5_4_used,txt_5_4_deletearchives,txt_5_4_deleteoriginal,
   txt_5_4_deletearchivesconfirm,txt_5_4_deletefiles,txt_5_4_deletefilesconfirm,
   txt_5_3_cml,txt_5_3_cmlmessage,txt_5_3_resetsi,txt_5_3_ia,txt_5_3_io,txt_5_3_rec,txt_5_3_exc,
   txt_5_2_oadd,txt_5_2_oext,txt_5_2_zerofiles,txt_5_2_zerofree,txt_5_2_securedeletefree,txt_5_2_zerodelete,
   txt_5_2_zfree,txt_5_2_sdfree,txt_5_2_free,txt_5_3_profilebest, txt_5_3_profileadvanced,
   txt_5_3_profilenormal, txt_5_3_profileveryfast, txt_5_3_profilepassword, txt_5_3_profile10mb,
   txt_5_3_profilesfx,
   txt_5_1_schedexplain,txt_5_1_schedname,txt_5_1_schedule,txt_5_1_hourly,txt_5_1_daily,txt_5_1_weekly,
   txt_5_1_monthly,txt_5_1_once,txt_5_1_onstart,txt_5_1_onlogin,txt_5_1_every,txt_5_1_hours,txt_5_1_day,txt_5_1_days,
   txt_5_1_weeks,txt_5_1_months,txt_5_1_w1,txt_5_1_w2,txt_5_1_w3,txt_5_1_w4,txt_5_1_w5,txt_5_1_w6,txt_5_1_w7,
   txt_5_1_last,txt_5_1_starttime,txt_5_1_startdate,txt_5_1_enddate,txt_5_1_schedmanage,txt_5_1_schedadd,
   txt_5_1_schederr,txt_5_1_schedok,txt_5_1_scriptmanage,txt_5_1_schedscripts,txt_5_1_ts,
   txt_5_0_bc,txt_5_0_resetpm,txt_5_0_enum,txt_5_0_ps,txt_5_0_sh,txt_5_0_skip,txt_5_0_perf,txt_5_0_music,txt_5_0_pictures,txt_5_0_removeall,txt_5_0_resetbookmarks,txt_5_0_videos,
   txt_4_9_frame,txt_4_9_listth,txt_4_9_shadow,txt_4_9_style,
   txt_4_8_presets,txt_4_8_listno,txt_4_8_detailsno,txt_4_8_details,txt_4_8_iconm,txt_4_8_iconl,
   txt_4_8_crop,txt_4_8_fullscreen,txt_4_8_fun,txt_4_8_immersive,txt_4_8_resize,txt_4_8_rr,txt_4_8_rl,
   txt_4_8_imagemanager,txt_4_8_flip,txt_4_8_mirror,txt_4_8_replace,txt_4_8_fit,txt_4_8_fitl,
   txt_4_8_h,txt_4_8_noresize,txt_4_8_aspect,txt_4_8_w,txt_4_8_stop,txt_4_8_t,txt_4_8_attach25,
   txt_4_8_keeparchive,
   txt_4_7_pcomp,txt_4_7_pk,txt_4_7_spchar,txt_4_7_recycle,txt_4_7_recycleask,
   txt_4_6_am,txt_4_6_fm,txt_4_6_users,
   txt_4_5_dock,txt_4_5_l,txt_4_5_t,txt_4_5_r,txt_4_5_b,txt_4_5_pj,txt_4_5_update,txt_4_5_noupdate,txt_4_5_goupdate,txt_4_5_koupdate,
   txt_4_5_upxpj, txt_4_5_properties, txt_4_5_shaddress, txt_4_5_shnav, txt_4_5_shstatus, txt_4_5_shtool,
   txt_4_4_confremove, txt_4_4_confremoveall,
   txt_4_3_keeppw, txt_4_3_recsrc, txt_4_3_breadcrumb, txt_4_3_pwman,
   txt_4_3_pwmanhint,txt_4_3_pwmanpwhint,txt_4_3_pwmanmaster, txt_4_3_pwmanlist,
   txt_4_3_exppl, txt_4_3_expple, txt_4_3_expplp, txt_4_3_pwmancorr, txt_4_3_resetpm,
   txt_4_2_arcabspath,
   txt_4_1_duplicateshint, txt_4_1_selected, txt_4_1_duplicatesfound, txt_4_1_duplicatesfind,
   txt_4_1_simplesearch,txt_4_1_runasadmin,txt_4_1_adminhint,
   txt_4_0_thim,
   txt_3_8_type_description_wim,txt_3_8_type_description_xz,
   txt_3_7_donations,txt_3_7_sort,txt_3_7_swapbars,txt_3_7_themedbars,txt_3_7_nameasparent,
   txt_3_7_tracker,
   txt_3_6_close,txt_3_6_resetapps,txt_3_6_ignoredd,txt_3_6_ethemes,
   txt_3_5_td,txt_3_5_managecustomthemes,
   txt_3_4_smallicons,txt_3_4_nopaths,
   txt_3_3_run,txt_3_3_runexp,txt_3_3_skipunits,txt_3_3_apppath,txt_3_3_apps,txt_3_3_stralt,
   txt_3_3_multi,
   txt_3_2_conf,txt_3_2_7zutf8nonascii,txt_3_2_donations,txt_3_2_alltasks,
   txt_3_1_sccenc,txt_3_1_languagetools,txt_3_1_lib,txt_3_1_recent,txt_3_1_src,txt_3_1_more,
   txt_3_1_sendto,txt_3_1_openasarchive,txt_3_1_downloads,txt_3_1_pathexc,txt_3_1_plsmartmin,
   txt_3_1_workingdir,txt_3_1_systmp,
   txt_3_0_nonreadableorpw,txt_3_0_readablepw,txt_3_0_resettmp,txt_3_0_configure,
   txt_2_9_address,txt_2_9_selected,txt_2_9_public,txt_2_9_organize,txt_2_9_lt,txt_2_9_mt,txt_2_9_st,
   txt_2_9_copyhere,txt_2_9_movehere,txt_2_9_columns,
   txt_2_9_noscan,txt_2_9_vst,txt_2_9_thl,txt_2_9_toolbar,txt_2_9_test_pw2G,txt_2_9_adv,
   txt_2_9_extconsole,txt_2_9_rec,txt_2_9_views,txt_2_9_none,txt_2_9_showmenu,txt_2_9_setapps,
   txt_2_9_nav,txt_2_9_navbar,txt_2_9_showtool,txt_2_9_tree,txt_2_9_home,
   txt_2_8_experimental,txt_2_8_zcopy,txt_2_8_addvol,txt_2_8_uniterror,txt_2_8_cannotconvert,
   txt_2_8_convertbegin,txt_2_8_convert,txt_2_8_convertexisting,txt_2_8_details,
   txt_2_8_convertdelete,txt_2_8_parallel,txt_2_8_convertnote,txt_2_8_unitrecommend,
   txt_2_8_viewasarchive,txt_2_8_nounit,txt_2_8_rowselect,
   txt_2_8_typeunit,txt_2_8_usedefaultoutpath,txt_2_8_statusbar,txt_2_8_custom,
   txt_2_7_encfn,txt_2_7_validatecl,txt_2_7_validatefn,txt_2_7_cancel,txt_2_7_ok,
   txt_2_7_separate,txt_2_7_output,txt_2_7_archivehint,txt_2_7_optional,txt_2_7_pwnotset,
   txt_2_7_pwarcset,txt_2_7_pwextset,txt_2_7_setpw,txt_2_7_pwsupported,
   txt_2_7_extfrom,txt_2_7_ext,txt_2_7_updating,txt_2_7_goarclayout,txt_2_7_goextlayout,
   txt_2_7_setadvf,txt_2_7_selpath,txt_2_7_dirsize,txt_2_7_exthint,
   txt_2_7_clipboard,txt_2_7_noinput,txt_2_7_es,txt_2_7_eu,txt_2_7_separateerror,
   txt_2_7_drag_archive,txt_2_7_list_tryflatorpw,txt_2_7_un7z_browse_flat,txt_2_7_oop,
   txt_2_7_experimental,
   txt_2_6_folders,txt_2_6_plalways,
   txt_2_6_plsmart,txt_2_6_advanced,
   txt_2_5_sessionio,txt_2_5_advanced,txt_2_5_basic,txt_2_5_cannotrun,txt_2_5_custeditors,
   txt_2_5_delete,txt_2_5_delete_fromarchive,txt_2_5_langflag,txt_2_5_encpj,
   txt_2_5_execommand,txt_2_5_help,txt_2_5_langhint,
   txt_2_5_mini_help,txt_2_5_offline_help,txt_2_5_tray,txt_2_5_remove,txt_2_5_hintpaths,
   txt_2_5_selectapp,txt_2_5_strafter,txt_2_5_strbefore,txt_2_5_encoding,
   txt_2_5_nopw,
   txt_2_4_itemsheight,txt_2_4_tb,txt_2_4_deletebookmarks,txt_2_4_totalmem,txt_2_4_operation,
   txt_2_4_advclip,txt_2_4_stdclip,txt_2_4_copyfrom,txt_2_4_extractfrom,
   txt_2_4_draghint,txt_2_4_clearclipboard,txt_2_4_removefromclipboard,txt_2_4_path,
   txt_2_4_adding,txt_2_4_documents,txt_2_4_hexp,txt_2_4_gvideo,txt_2_4_wenc,txt_2_4_yanswers,
   txt_2_4_wdict,txt_2_4_wbook,txt_2_4_wsrc,txt_2_4_wcommons,txt_2_4_wnews,
   txt_2_3_pw_errorchar,txt_2_3_envstr,txt_2_3_never_pw,txt_2_3_home,txt_2_3_on_pw,txt_2_3_test_pw100,txt_2_3_test_pw,
   txt_list_isfolder,txt_action_extopen,txt_error_passwordnotmatch,txt_action_preview,
   txt_preview_hint,txt_removeselected,txt_savelayout,txt_better,txt_default2,txt_faster,
   txt_fastermem,txt_tempdir,txt_stream,txt_slowermem,txt_store,txt_newfolder,
   txt_7z_exitcodeunknown,
   txt_none,txt_fd,txt_7z_exitcode1,txt_attach10,txt_7z_exitcode2,
   txt_7z_exitcode255,txt_fat32,txt_dvd,txt_attach5,txt_cd650,txt_7z_exitcode7,txt_cd700,
   txt_type_description_7z,txt_dvddl,txt_7z_exitcode8,txt_abort,txt_about,txt_action,
   txt_action_hint,txt_add,txt_add_existing_archive,txt_add_archive,
   txt_add_files,txt_add_folder,txt_add_path,txt_add_tolayout,txt_add_toarchive,txt_add_tobookmarks,
   txt_address_hint,txt_adv_filters,txt_algo,txt_all,txt_all_default,txt_all_type,
   txt_all_date,txt_all_psize,txt_all_attributes,txt_all_size,txt_error_input_upx,
   txt_always_pw,txt_ignore_ext,txt_ignore_disp,txt_ignore_sel,txt_key_hint,
   txt_timestamp,txt_appoptions,txt_type_description_arc,txt_archive,txt_un7z_browse_ok,
   txt_interface,txt_archivecreation,txt_tarbefore_hint,
   txt_archive_hint,txt_compressionratio_hint,txt_archiving,txt_cl_long,txt_overwrite_askbefore,
   txt_associated,txt_attributes,txt_author,txt_ren_existing,txt_ren_extracted,txt_autofolder,
   txt_back,txt_backend,txt_backupexe,txt_bettercompression,txt_blogs,txt_blowfish,
   txt_bookmarks,txt_browse,txt_browser,txt_aborted_error,txt_list_browsing,
   txt_archive_root,txt_type_description_bzip2,txt_pw_empty,txt_add_error,txt_un7z_browse_failure,
   txt_list_error,txt_conf_cannotsave,txt_check_hint,txt_check,txt_check_select,txt_clear,
   txt_clearlayout,txt_pj_hint,txt_autoclose,txt_cl,txt_compare,txt_compress,
   txt_compress_executable,txt_compress_openforwriting,txt_compression,txt_compmanagement,
   txt_pw_confirm,txt_console,txt_console_interface,txt_content,
   txt_controlpanel,txt_copy,txt_copyto,txt_create,txt_create_archive,txt_title_create,
   txt_create_keyfile,txt_create_folder,txt_create_theme,txt_rr,txt_create_sfx,txt_cr_current,
   txt_custom,txt_type_description_custom,txt_customapp,txt_custom_parameters,txt_customsize,
   txt_cut,txt_datetime,txt_default,txt_default_compression,
   txt_default_format,txt_theme_default,
   txt_hard_reset_hint,txt_desktop,txt_dictionary,txt_dirs,txt_dis,txt_disk_cleanup,
   txt_disk_defrag,txt_disk_management,txt_dispaly,txt_displayedmnu_obj,txt_displayedobjects,
   txt_nocompress,txt_delete,txt_wipe,txt_done,txt_edit,txt_elapsed,
   txt_error_emptycl,txt_encrypt,txt_encrypted,txt_encryption,txt_note,
   txt_random_keys,txt_random_keys_hint,txt_ent,txt_ent_tools,txt_eqorlarger,
   txt_eqorrecent,txt_eqorolder,txt_eqorsmaller,txt_equal,txt_erase_hint,txt_extraction_error,
   txt_exclude_hint,txt_exclude_recourse,txt_exclusion_recourse,txt_exclusion,txt_exe,
   txt_overwrite_qry,txt_confirm_overwrite,txt_explore_outpath,txt_explore_path,txt_ext,
   txt_caption_extract,txt_ext_nopath,txt_ext_all,txt_ext_allhere,txt_ext_allto,txt_extopen_custom,
   txt_extopen_with,txt_ext_disp_here,txt_ext_disp,txt_ext_disp_to,txt_ext_here,txt_ext_sel_here,
   txt_ext_sel,txt_ext_sel_to,txt_extobj,txt_newfoldermenu,txt_extto,txt_level_fast,
   txt_fastcompr,txt_fastopen,txt_level_fastest,txt_favformats,txt_file,txt_filebrowser,
   txt_filelist_savedas,txt_filetools,txt_files,txt_nfiles,txt_fs,
   txt_filters_recourse,txt_filters,txt_flat,txt_list_flat,txt_unit_floppy,txt_foldername,
   txt_nfolders,txt_error_input_multi,txt_fwd,txt_list_found,txt_free,
   txt_free2,txt_name_full,txt_function,txt_general,txt_multithreading,
   txt_go_browser,txt_go_path,txt_guicl,txt_guipealauncher,txt_graphic,
   txt_gridaltcolor,txt_gridrowheight,txt_gui,txt_type_description_gzip,txt_hardreset,
   txt_here,txt_list_history,txt_homeroot,txt_quickbrowse_hint,
   txt_backupexe_hint,txt_attach,txt_images,txt_include_hint,txt_filters_hint,txt_inclusion_recourse,
   txt_inclusion,txt_error_function,txt_info,txt_infoall,txt_infodisp,txt_infosel,
   txt_inputinfo,txt_input_list,txt_iop,txt_ipo,txt_input,txt_integrity,txt_chunk_size,
   txt_invertsel,txt_type_exe,txt_return_to_archive,txt_not_accessible,txt_type_unsupported,
   txt_checkname_failed,txt_not_accessible_list,txt_theme_create_error,txt_theme_exists,
   txt_job_code,txt_job_definition_saved,txt_job_success,txt_join,txt_joinfiles,
   txt_keyfile,txt_keyfile_not_found,txt_keyfile_notcreated,txt_larger,
   txt_lastused,txt_launch,txt_layout,txt_level,txt_license,txt_caption_list,txt_list_details,
   txt_list_all,txt_list_disp,txt_list_sel,txt_toggle_warning,txt_loadfile,txt_loadlayout,
   txt_unit_hd,txt_localization,txt_lpaqver,txt_type_description_lpaq,txt_maininterface,
   txt_maxcomp,txt_level_maximum,txt_restartrequired,txt_required_memory,
   txt_method,txt_misc,txt_modify,txt_morecontrols,txt_morerecent,
   txt_ent_hint,txt_moveto,txt_mypc,txt_list_na,txt_name,txt_naming,txt_unit_remote,
   txt_newarchive,txt_news,txt_no,txt_noinput,txt_nocompress_hint,
   txt_split_noinput,txt_open_noinput,txt_list_nomatch,txt_singlethread,txt_none2,
   txt_nonsolid,txt_level_normal,txt_copy_error,txt_description,txt_compare_second,
   txt_peaobj,txt_displayed_obj,txt_olderthan,txt_ondblclick,
   txt_opacity,txt_open,txt_openarchive,txt_title_open,txt_open_bookmark,txt_cphere,
   txt_open_file,txt_open_files,txt_open_path,txt_opensource,txt_openwith,
   txt_aborted,txt_unit_cd,txt_options,txt_other,txt_otherparams,
   txt_oip,txt_opi,txt_output,txt_overwrite,txt_compressed_size,txt_paqver,
   txt_type_description_paq,txt_pio,txt_poi,txt_parameters,txt_error_partial,
   txt_passes,txt_pw,txt_pwlength,txt_un7z_browse_pw,txt_un7z_browse_pw_other,txt_paste,
   txt_path,txt_pea_appcolor,txt_pea_textcolor,txt_type_description_pea,txt_peazip_new,
   txt_peazip_help,txt_peazip_web,txt_performall,txt_upxorstrip,
   txt_not_removable_file,txt_not_removable,txt_custom_executable_missing,
   txt_type_unsupported_select,txt_no_theme_name,txt_please_wait,txt_copy_wait,txt_previewwith,
   txt_projectadmin,txt_type_description_quad,txt_quickdelete,txt_quit,txt_unit_ram,
   txt_read,txt_recentarchives,txt_rr_hint,txt_search_refine,txt_fefreshf5,
   txt_release,txt_unit_removable,txt_remove_bookmark,txt_remove_external_unit,
   txt_rename,txt_caption_repair,txt_restartrequired2,txt_reset,txt_reset_archivename,
   txt_reset_theme,
   txt_restore_att,txt_run_as,txt_run_as2,txt_sample,
   txt_saveas,txt_savehistory,txt_save_infolder,txt_savejob,txt_savejobdefinition,
   txt_savejobdefinition_hint,txt_save_winstate,
   txt_search,txt_searchanddrag,txt_nrsearch,txt_search_hint,txt_search_web,txt_list_searching,
   txt_securedelete,txt_default_description,txt_selectall,txt_selectdir,
   txt_selected_obj,txt_selected_objects,txt_sfx,txt_sendbymail,txt_set_defaults,
   txt_settings,txt_sfx_interface,txt_showhints,
   txt_show_messages,txt_showpw,txt_singlevol,txt_size,txt_sizeb,txt_skip_existing,
   txt_slowercomp,txt_smaller,txt_solid,txt_solid_block,txt_solid_auto,txt_solid_extension,
   txt_listtest,txt_sortbysel,txt_list_sorting,
   txt_speed,txt_split,txt_type_description_split,txt_split_file,txt_list_nostats,
   txt_status,txt_level_store,txt_stream_control,txt_strip,txt_keyfile_created,txt_suggestpw,
   txt_noupx,txt_syntax,txt_sysbenchmark,txt_benchmark,txt_systools,txt_tarbefore,
   txt_type_description_tar,txt_taskman,txt_caption_test,txt_testall,txt_testdisp,
   txt_testpw,txt_testsel,txt_col_hint,txt_bookmarks_hint,txt_archive_noinput_tolist,
   txt_theme,txt_icons_found,txt_themename,txt_icons_not_found,txt_theme_create_success,
   txt_theming,txt_extand_error,txt_threads,txt_titlescolor,
   txt_to,txt_toggle_browseflat,txt_toggle_historybookmarks,txt_toolbarscolor,txt_tools,
   txt_best,txt_type,txt_level_ultra,txt_error_openfile,txt_cl_hint,
   txt_ace_missing,txt_units,txt_unit_unknown,txt_un7z_pw_untested,txt_up,txt_update,
   txt_type_description_upx,txt_advfilters,txt_openfiles_hint,txt_usenet,txt_user_name,
   txt_using,txt_volumepea,txt_volume_size,txt_type_ext_uns,txt_websites,
   txt_word,txt_write,txt_ramdompw_hint,txt_exe_hint,
   txt_pj_hint2,txt_type_description_zip,txt_zipcrypto_hint,txt_name_provide,txt_cnewfolder,
   txt_searchfor,txt_websearch,txt_on,txt_convert:ansistring;

implementation

{ TFormPeach }

{///////////////////////////////////////////////////////////////////////////////

subsection GUI CLONE MENUS

///////////////////////////////////////////////////////////////////////////////}

function CloneMenuItem(Src: TMenuItem): TMenuItem;//generic cloning method modified for PeaZip's main menu as source
var
  i: Integer;
begin
  if Src=nil then Exit;
  Result:=TMenuItem.Create(Src.Owner);
  Result.Caption:=Src.Caption;
  if Result.Caption='' then Result.Visible:=False;
  Result.ShortCut:=Src.ShortCut;
  Result.OnClick:=Src.OnClick;
  Result.Tag:=Src.Tag;
  Result.Checked:=Src.Checked;
  Result.RadioItem:=Src.RadioItem;
  Result.Visible:=Src.Visible;
  Result.Enabled:=Src.Enabled;
  Result.Bitmap:=Src.Bitmap;
  if Src.Name='pmshowstylemenu' then
     begin
     Result.Visible:=true;
     Result.Enabled:=true;
     end;
  case Src.Name of
     'mfun0', 'mfun', 'mtoggletool', 'mbrowser':
     begin
     Result.Visible:=false;
     Result.Enabled:=false;
     end;
  end;
  {$IFNDEF MSWINDOWS}
  case Src.Name of
     'mthumbimages', 'mscheduledscripts', 'mtaskscheduler', 'MenuItem11', 'mAdmin', 'w7contextlang', 'mSystemIntegration':
     begin
     Result.Visible:=false;
     Result.Enabled:=false;
     end;
  end;
  {$ENDIF}
  for i:=0 to Src.Count-1 do
     Result.Add(CloneMenuItem(Src[i]));
end;

procedure CopyMenu(Src, Dst: TMenu);
var
  i: Integer;
begin
  Dst.Items.Clear;
  Dst.Items.Add(CloneMenuItem(FormPeach.pmshowstylemenu));
  Dst.Items.Add(CloneMenuItem(FormPeach.Separator7));
  for i:=0 to Src.Items.Count-1 do
    Dst.Items.Add(CloneMenuItem(Src.Items[i]));
end;

procedure CopyMenuItems(Src, Dst: TMenuItem; n:integer);
var
  i: Integer;
begin
  Dst.Clear;
  for i:=0 to Src.Count-1 do
    begin
    if n<>0 then
       if i>n then exit;
    Dst.Add(CloneMenuItem(Src[i]));
    end;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI CUSTOM TABS

///////////////////////////////////////////////////////////////////////////////}

//general tabs
procedure exitlabel(var a: TLabel; var b:TShape);
begin
if (alttabstyle<>1) and (alttabstyle<>4) then
   begin
   b.Brush.Color:=tabbrushcol;
   b.Pen.Color:=tabpencol;
   b.Pen.Style:=psSolid;
   end
else
   begin
   b.Brush.Color:=tabpencol;
   b.Pen.Color:=tabpencol;
   b.Pen.Style:=psSolid;
   end;
if (highlighttabs=1) or (highlighttabs=4) or (highlighttabs=5) then a.Font.Color:=clDefault else a.Font.Color:=pGray;
end;

procedure clicklabel(var a: TLabel; var b:TShape);
begin
if (alttabstyle<>1) and (alttabstyle<>4) then
   begin
   b.Brush.Color:=StringToColor(color2);
   b.Pen.Color:=tabpencol;
   b.Pen.Style:=psSolid;
   end
else
   begin
   b.Brush.Color:=tablowcol;
   b.Pen.Color:=tabpencol;
   b.Pen.Style:=psSolid;
   end;
if ((alttabstyle=1) or (alttabstyle=4)) and ((highlighttabs=1) or (highlighttabs=4) or (highlighttabs=5)) then a.Font.Color:=ptextaccent else a.Font.Color:=clDefault;
end;

procedure enterlabel(var a: TLabel; var b:TShape);
begin
b.Brush.Color:=tabbrushhighcol;
b.Pen.Color:=tabpencol;
b.Pen.Style:=psSolid;
a.Font.Color:=clDefault;
end;

///add
procedure exitlabel_add(var a: TLabel; var b:TShape);
begin
if activelabel_add=a then exit;
exitlabel(a,b);
end;

procedure deselectlabels_add;
begin
with FormPeach do
begin
if (alttabstyle<>1) and (alttabstyle<>4) then
   begin
   exitlabel_add(LabelTitleAdd1,ShapeTitleAddb1);
   exitlabel_add(LabelTitleAdd2,ShapeTitleAddb2);
   exitlabel_add(LabelTitleAdd3,ShapeTitleAddb3);
   exitlabel_add(LabelTitleAdd4,ShapeTitleAddb4);
   end
else
   begin
   exitlabel_add(LabelTitleAdd1,Shapelinkadd1);
   exitlabel_add(LabelTitleAdd2,Shapelinkadd2);
   exitlabel_add(LabelTitleAdd3,Shapelinkadd3);
   exitlabel_add(LabelTitleAdd4,Shapelinkadd4);
   end;
end;
end;

procedure setlabelpanel_add(var a: Tlabel);
begin
with FormPeach do
begin
if a = LabelTitleAdd1 then setpanel_add(1);
if a = LabelTitleAdd2 then setpanel_add(2);
if a = LabelTitleAdd3 then setpanel_add(3);
if a = LabelTitleAdd4 then setpanel_add(4);
end;
end;

procedure clicklabel_add(var a: TLabel; var b:TShape);
begin
activelabel_add:=a;
deselectlabels_add;
clicklabel(a,b);
setlabelpanel_add(a);
end;

procedure enterlabel_add(var a: TLabel; var b:TShape);
begin
if activelabel_add=a then exit;
enterlabel(a,b);
end;

///extract
procedure exitlabel_extract(var a: TLabel; var b:TShape);
begin
if activelabel_extract=a then exit;
exitlabel(a,b);
end;

procedure deselectlabels_extract;
begin
with FormPeach do
begin
if (alttabstyle<>1) and (alttabstyle<>4) then
   begin
   exitlabel_extract(LabelTitleextract1,ShapeTitleextractb1);
   exitlabel_extract(LabelTitleextract2,ShapeTitleextractb2);
   exitlabel_extract(LabelTitleextract3,ShapeTitleextractb3);
   exitlabel_extract(LabelTitleextract4,ShapeTitleextractb4);
   end
else
   begin
   exitlabel_extract(LabelTitleextract1,Shapelinkextract1);
   exitlabel_extract(LabelTitleextract2,Shapelinkextract2);
   exitlabel_extract(LabelTitleextract3,Shapelinkextract3);
   exitlabel_extract(LabelTitleextract4,Shapelinkextract4);
   end;
end;
end;

procedure setlabelpanel_extract(var a: Tlabel);
begin
with FormPeach do
begin
if a = LabelTitleextract1 then setpanel_extract(1);
if a = LabelTitleextract2 then setpanel_extract(2);
if a = LabelTitleextract3 then setpanel_extract(3);
if a = LabelTitleextract4 then setpanel_extract(4);
end;
end;

procedure clicklabel_extract(var a: TLabel; var b:TShape);
begin
activelabel_extract:=a;
deselectlabels_extract;
clicklabel(a,b);
setlabelpanel_extract(a);
end;

procedure enterlabel_extract(var a: TLabel; var b:TShape);
begin
if activelabel_extract=a then exit;
enterlabel(a,b);
end;

///apps subpage
procedure exitlabel_apps(var a: TLabel; var b:TShape);
begin
if activelabel_apps=a then exit;
exitlabel(a,b);
end;

procedure deselectlabels_apps;
begin
with FormPeach do
begin
if (alttabstyle<>1) and (alttabstyle<>4) then
   begin
   exitlabel_apps(LabelTitleapps1,ShapeTitleAppsb1);
   exitlabel_apps(LabelTitleapps2,ShapeTitleAppsb2);
   end
else
   begin
   exitlabel_apps(LabelTitleapps1,Shapelinkapps1);
   exitlabel_apps(LabelTitleapps2,Shapelinkapps2);
   end;
end;
end;

procedure setpanel_apps(i:integer);
begin
case i of
   1: begin
   FormPeach.PanelApps1.Visible:=true;
   FormPeach.PanelApps2.Visible:=false;
   end;
   2: begin
   FormPeach.PanelApps1.Visible:=false;
   FormPeach.PanelApps2.Visible:=true;
   end;
end;
end;

procedure setlabelpanel_apps(var a: Tlabel);
begin
with FormPeach do
begin
if a = LabelTitleapps1 then setpanel_apps(1);
if a = LabelTitleapps2 then setpanel_apps(2);
end;
end;

procedure clicklabel_apps(var a: TLabel; var b:TShape);
begin
activelabel_apps:=a;
deselectlabels_apps;
clicklabel(a,b);
setlabelpanel_apps(a);
end;

procedure enterlabel_apps(var a: TLabel; var b:TShape);
begin
if activelabel_apps=a then exit;
enterlabel(a,b);
end;

///options
procedure exitlabel_options(var a: TLabel; var b: TShape);
begin
if activelabel_options=a then exit;
if ((highlighttabs=4) or (highlighttabs=5)) then a.Font.Color:=clDefault else a.Font.Color:=pGray;
b.Brush.Color:=FormPeach.PanelTitleOptions.Color;
end;

procedure deselectlabels_options;
begin
with FormPeach do
begin
exitlabel_options(LabelTitleoptions1,ShapeOptions1);
exitlabel_options(LabelTitleoptions2,ShapeOptions2);
exitlabel_options(LabelTitleoptions3,ShapeOptions3);
exitlabel_options(LabelTitleoptions4,ShapeOptions4);
exitlabel_options(LabelTitleoptions5,ShapeOptions5);
exitlabel_options(LabelTitleoptions6,ShapeOptions6);
exitlabel_options(LabelTitleoptions7,ShapeOptions7);
exitlabel_options(LabelTitleoptions8,ShapeOptions8);
end;
end;

procedure updatepluginstatus;
begin
if fileexists(binpath+'unrar'+DirectorySeparator+UNRARNAME+EXEEXT) then
   begin
   unrar5pluginstatus:=txt_5_7_pinstalled;
   FormPeach.baboutremoveunrar.Visible:=true;
   end
else
   begin
   unrar5pluginstatus:=txt_5_7_pmissing;
   FormPeach.baboutremoveunrar.Visible:=false;
   end;
if fileexists(binpath+'unace'+DirectorySeparator+'unace'+EXEEXT) then
   begin
   unacepluginstatus:=txt_5_7_pinstalled;
   FormPeach.baboutremoveunace.Visible:=true;
   end
else
   begin
   unacepluginstatus:=txt_5_7_pmissing;
   FormPeach.baboutremoveunace.Visible:=false;
   end;
if fileexists(binpath+'lpaq'+DirectorySeparator+'lpaq1'+EXEEXT) then
addformatspluginstatus:=txt_5_7_pinstalled
else
addformatspluginstatus:=txt_5_7_pmissing;
FormPeach.LabelAbout.caption:=APPMAIN+' '+txt_release+' '+PEAZIPVERSION+PEAZIPREVISION+' - '+caption_build+char($0d)+char($0a)
        +txt_license+' LGPLv3, '+txt_projectadmin+' Giorgio Tani'+char($0d)+char($0a)
        +char($0d)+char($0a)
        +langstrhint+char($0d)+char($0a)
        +char($0d)+char($0a)
        +txt_using+char($0d)+char($0a)
        +APPLICATION_PEA+char($0d)+char($0a)
        +APPLICATION_7Z+char($0d)+char($0a)
        +APPLICATION_ZPAQ+char($0d)+char($0a)
        +APPLICATION_STRIP+char($0d)+char($0a)
        +APPLICATION_QUAD+char($0d)+char($0a)
        +APPLICATION_FREEARC+char($0d)+char($0a)
        +APPLICATION_BROTLI+char($0d)+char($0a)
        +APPLICATION_ZSTD+char($0d)+char($0a)
        +char($0d)+char($0a)
        +'Plugin:'+char($0d)+char($0a)
        +'PeaZip Additional Formats Plugin (LGPLv3) - '+addformatspluginstatus+char($0d)+char($0a)
        +APPLICATION_UNACE+' - '+unacepluginstatus+char($0d)+char($0a)
        +APPLICATION_UNRAR+' - '+unrar5pluginstatus+char($0d)+char($0a);
end;

procedure setlabelpanel_options(var a: Tlabel);
begin
with FormPeach do
begin
if a = LabelTitleoptions1 then PageOpt1.Visible:=true else PageOpt1.Visible:=false;
if a = LabelTitleoptions2 then PageOpt2.Visible:=true else PageOpt2.Visible:=false;
if a = LabelTitleoptions3 then PageOpt3.Visible:=true else PageOpt3.Visible:=false;
if a = LabelTitleoptions4 then PageOpt4.Visible:=true else PageOpt4.Visible:=false;
if a = LabelTitleoptions5 then PageOpt5.Visible:=true else PageOpt5.Visible:=false;
if a = LabelTitleoptions6 then PageOpt6.Visible:=true else PageOpt6.Visible:=false;
if a = LabelTitleoptions7 then PageOpt7.Visible:=true else PageOpt7.Visible:=false;
if a = LabelTitleoptions8 then begin PageOpt8.Visible:=true; updatepluginstatus; end else PageOpt8.Visible:=false;
end;
end;

procedure clicklabel_options(var a: TLabel; var b: TShape);
begin
activelabel_options:=a;
deselectlabels_options;
a.Font.Color:=clDefault;
if (alttabstyle<>1) and (alttabstyle<>4) then
   b.Brush.Color:=tabbrushcol
else
   b.Brush.Color:=tablowcol;
setlabelpanel_options(a);
end;

procedure enterlabel_options(var a: TLabel; var b: TShape);
begin
if activelabel_options=a then exit;
a.Font.Color:=clDefault;
b.Brush.Color:=tabbrushhighcol;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI SCALING set items size and spacing

///////////////////////////////////////////////////////////////////////////////}

procedure psetbuttonwidth(var btt:TSpeedButton; rsize:integer; ontheleft:boolean);
var w,h:integer;
begin
FormPeach.labelbsize.Caption:=btt.Caption;
FormPeach.labelbsize.GetPreferredSize(w,h,false,true);
FormPeach.labelbsize.Caption:='';
if ontheleft=true then w:=w+rsize*2+6
else w:=w+rsize+6;
if w<rsize*3 then w:=rsize*3;
btt.Width:=w;
end;

procedure settoolglyphtop;
begin
with FormPeach do
begin
ButtonUn7zaTest.Layout:=blGlyphTop;
ButtonUn7zaAdd.Layout:=blGlyphTop;
ButtonUn7zaTo.Layout:=blGlyphTop;
ButtonUn7zaConvert.Layout:=blGlyphTop;
ButtonCut.Layout:=blGlyphTop;
ButtonCopy.Layout:=blGlyphTop;
ButtonPaste.Layout:=blGlyphTop;
ButtonOpenWith.Layout:=blGlyphTop;
ButtonProperties.Layout:=blGlyphTop;
ButtonRename.Layout:=blGlyphTop;
ButtonRename1.Layout:=blGlyphTop;
ButtonDelete.Layout:=blGlyphTop;
ButtonDup.Layout:=blGlyphTop;
ButtonNF.Layout:=blGlyphTop;
ButtonDup1.Layout:=blGlyphTop;
ButtonImgResize.Layout:=blGlyphTop;
ButtonImgCrop.Layout:=blGlyphTop;
ButtonImgRL.Layout:=blGlyphTop;
ButtonImgRR.Layout:=blGlyphTop;
end;
end;

procedure settoolglyphleft;
begin
with FormPeach do
begin
ButtonUn7zaTest.Layout:=blGlyphLeft;
ButtonUn7zaAdd.Layout:=blGlyphLeft;
ButtonUn7zaTo.Layout:=blGlyphLeft;
ButtonUn7zaConvert.Layout:=blGlyphLeft;
ButtonCut.Layout:=blGlyphLeft;
ButtonCopy.Layout:=blGlyphLeft;
ButtonPaste.Layout:=blGlyphLeft;
ButtonOpenWith.Layout:=blGlyphLeft;
ButtonProperties.Layout:=blGlyphLeft;
ButtonRename.Layout:=blGlyphLeft;
ButtonRename1.Layout:=blGlyphLeft;
ButtonDelete.Layout:=blGlyphLeft;
ButtonDup.Layout:=blGlyphLeft;
ButtonNF.Layout:=blGlyphLeft;
ButtonDup1.Layout:=blGlyphLeft;
ButtonImgResize.Layout:=blGlyphLeft;
ButtonImgCrop.Layout:=blGlyphLeft;
ButtonImgRL.Layout:=blGlyphLeft;
ButtonImgRR.Layout:=blGlyphLeft;
end;
end;

procedure settoolmargin;
begin
with FormPeach do
begin
ButtonUn7zaTest.Margin:=-1;
ButtonUn7zaAdd.Margin:=-1;
ButtonUn7zaTo.Margin:=-1;
ButtonUn7zaConvert.Margin:=-1;
ButtonCut.Margin:=-1;
ButtonCopy.Margin:=-1;
ButtonPaste.Margin:=-1;
ButtonOpenWith.Margin:=-1;
ButtonProperties.Margin:=-1;
ButtonRename.Margin:=-1;
ButtonRename1.Margin:=-1;
ButtonDelete.Margin:=-1;
ButtonDup.Margin:=-1;
ButtonNF.Margin:=-1;
ButtonDup1.Margin:=-1;
ButtonImgResize.Margin:=-1;
ButtonImgCrop.Margin:=-1;
ButtonImgRL.Margin:=-1;
ButtonImgRR.Margin:=-1;
end;
end;

procedure settoolspacing(n:integer);
begin
with FormPeach do
begin
ButtonUn7zaTest.Spacing:=n;
ButtonUn7zaAdd.Spacing:=n;
ButtonUn7zaTo.Spacing:=n;
ButtonUn7zaConvert.Spacing:=n;
ButtonCut.Spacing:=n;
ButtonCopy.Spacing:=n;
ButtonPaste.Spacing:=n;
ButtonOpenWith.Spacing:=n;
ButtonProperties.Spacing:=n;
ButtonRename.Spacing:=n;
ButtonRename1.Spacing:=n;
ButtonDelete.Spacing:=n;
ButtonDup.Spacing:=n;
ButtonNF.Spacing:=n;
ButtonDup1.Spacing:=n;
ButtonImgResize.Spacing:=n;
ButtonImgCrop.Spacing:=n;
ButtonImgRL.Spacing:=n;
ButtonImgRR.Spacing:=n;
end;
end;

procedure settoolbigicon;
begin
with FormPeach do
begin
ButtonUn7zaTest.Glyph:=Btestall_big;
ButtonUn7zaAdd.Glyph:=Barchive_big;
ButtonUn7zaTo.Glyph:=Bextractall_big;
ButtonUn7zaConvert.Glyph:=Bconvert_big;
ButtonCut.Glyph:=BTool_cut;
ButtonCopy.Glyph:=BTool_copy;
ButtonPaste.Glyph:=BTool_paste;
ButtonOpenWith.Glyph:=BTool_openw;
ButtonProperties.Glyph:=BTool_properties;
ButtonRename.Glyph:=BTool_rename;
ButtonRename1.Glyph:=BTool_rename;
ButtonDelete.Glyph:=BTool_delete;
ButtonDup.Glyph:=BTool_dup;
ButtonNF.Glyph:=Bdetailsfs;
ButtonDup1.Glyph:=BTool_dup;
ButtonImgResize.Glyph:=BTool_resize;
ButtonImgCrop.Glyph:=BTool_crop;
ButtonImgRL.Glyph:=BTool_rl;
ButtonImgRR.Glyph:=BTool_rr;
end;
end;

procedure settoolsmallicon;
begin
with FormPeach do
begin
ButtonUn7zaTest.Glyph:=Btestall;
ButtonUn7zaAdd.Glyph:=Barchive;
ButtonUn7zaTo.Glyph:=Bextractall;
ButtonUn7zaConvert.Glyph:=Bconvert;
ButtonCut.Glyph:=BTool_cut_small;
ButtonCopy.Glyph:=BTool_copy_small;
ButtonPaste.Glyph:=Bloadlayout;
ButtonOpenWith.Glyph:=Bapps;
ButtonProperties.Glyph:=BTool_properties_small;
ButtonRename.Glyph:=BTool_rename_small;
ButtonRename1.Glyph:=BTool_rename_small;
ButtonDelete.Glyph:=Bstop;
ButtonDup.Glyph:=BTool_dup_small;
ButtonNF.Glyph:=BFolder;
ButtonDup1.Glyph:=BTool_dup_small;
ButtonImgResize.Glyph:=BTool_resize_small;
ButtonImgCrop.Glyph:=BTool_crop_small;
ButtonImgRL.Glyph:=BTool_rl_small;
ButtonImgRR.Glyph:=BTool_rr_small;
end;
end;

procedure settooltext;
begin
with FormPeach do
begin
ButtonUn7zaTo.Caption:=txt_caption_extract;
ButtonUn7zaTest.Caption:=txt_caption_test;
ButtonUn7zaAdd.Caption:=txt_add;
pmttitle.Caption:=txt_add;
pmtypeswap.Caption:=txt_add+' <> '+txt_2_8_convert;
ButtonUn7zaConvert.Caption:=txt_2_8_convert;
ButtonCut.Caption:=txt_cut;
ButtonCopy.Caption:=txt_copy;
ButtonPaste.Caption:=txt_paste;
ButtonProperties.Caption:=txt_4_5_properties;
ButtonRename.Caption:=txt_rename;
ButtonRename1.Caption:=txt_rename;
ButtonDup.Caption:=txt_4_1_duplicatesfind;
ButtonNF.Caption:=txt_cnewfolder;
ButtonDup1.Caption:=txt_4_1_duplicatesfind;
ButtonImgResize.Caption:=txt_4_8_t;
ButtonImgCrop.Caption:=txt_4_8_crop;
ButtonImgRL.Caption:=txt_4_8_rl;
ButtonImgRR.Caption:=txt_4_8_rr;
ButtonCut.Hint:='';
ButtonCopy.Hint:='';
ButtonPaste.Hint:='';
ButtonOpenWith.Hint:='';
ButtonProperties.Hint:='';
ButtonRename.Hint:='';
ButtonRename1.Hint:='';
ButtonDelete.Hint:='';
ButtonDup.Hint:='';
ButtonNF.Hint:='';
ButtonDup1.Hint:='';
ButtonImgResize.Hint:='';
ButtonImgCrop.Hint:='';
ButtonImgRL.Hint:='';
ButtonImgRR.Hint:='';
end;
end;

procedure settoolbtnw(refw:integer; glyph_on_side:boolean);
begin
with FormPeach do
begin
psetbuttonwidth(ButtonUn7zato,refw,glyph_on_side);
psetbuttonwidth(ButtonUn7zaTest,refw,glyph_on_side);
psetbuttonwidth(ButtonUn7zaAdd,refw,glyph_on_side);
psetbuttonwidth(ButtonUn7zaConvert,refw,glyph_on_side);
ButtonPropertiesActions.Width:=imagelistroot.width;
ButtonExtractActions.Width:=imagelistroot.width;
ButtonConvertActions.Width:=imagelistroot.width;
ButtonAddActions.Width:=imagelistroot.width;
ButtonTestActions.Width:=imagelistroot.width;
//filemanager
psetbuttonwidth(ButtonCut,refw,glyph_on_side);
psetbuttonwidth(ButtonCopy,refw,glyph_on_side);
psetbuttonwidth(ButtonPaste,refw,glyph_on_side);
psetbuttonwidth(ButtonOpenWith,refw,glyph_on_side);
psetbuttonwidth(ButtonProperties,refw,glyph_on_side);
psetbuttonwidth(ButtonRename,refw,glyph_on_side);
psetbuttonwidth(ButtonDelete,refw,glyph_on_side);
psetbuttonwidth(ButtonDup,refw,glyph_on_side);
psetbuttonwidth(ButtonNF,refw,glyph_on_side);
Buttoncmto.Width:=imagelistroot.width;
Buttonopenactions.Width:=imagelistroot.width;
Buttonfmactions.Width:=imagelistroot.width;
Buttonfmactions1.Width:=imagelistroot.width;
//imageviewer
psetbuttonwidth(ButtonDup1,refw,glyph_on_side);
psetbuttonwidth(ButtonRename1,refw,glyph_on_side);
psetbuttonwidth(ButtonImgResize,refw,glyph_on_side);
psetbuttonwidth(ButtonImgCrop,refw,glyph_on_side);
psetbuttonwidth(ButtonImgRL,refw,glyph_on_side);
psetbuttonwidth(ButtonImgRR,refw,glyph_on_side);
ButtonImg6.Width:=imagelistroot.width;
ButtonImgR.Width:=imagelistroot.width;
ButtonImgRes.Width:=imagelistroot.width;
end;
end;

procedure settoolbtnwfixed;
begin
with FormPeach do
begin
ButtonUn7zaTo.Width:=ctrlback.width;
ButtonUn7zaTest.Width:=ctrlback.width;
ButtonUn7zaAdd.Width:=ctrlback.width;
ButtonUn7zaConvert.Width:=ctrlback.width;
ButtonPropertiesActions.Width:=imagelistroot.width;
ButtonExtractActions.Width:=imagelistroot.width;
ButtonConvertActions.Width:=imagelistroot.width;
ButtonAddActions.Width:=imagelistroot.width;
ButtonTestActions.Width:=imagelistroot.width;
//filemanager
ButtonCut.Width:=ctrlback.width;
ButtonCopy.Width:=ctrlback.width;
ButtonPaste.Width:=ctrlback.width;
ButtonOpenWith.Width:=ctrlback.width;
ButtonProperties.Width:=ctrlback.width;
ButtonRename.Width:=ctrlback.width;
ButtonDelete.Width:=ctrlback.width;
ButtonDup.Width:=ctrlback.width;
ButtonNF.Width:=ctrlback.width;
Buttoncmto.Width:=imagelistroot.width;
Buttonopenactions.Width:=imagelistroot.width;
Buttonfmactions.Width:=imagelistroot.width;
Buttonfmactions1.Width:=imagelistroot.width;
//imageviewer
ButtonDup1.Width:=ctrlback.width;
ButtonRename1.Width:=ctrlback.width;
ButtonImgResize.Width:=ctrlback.width;
ButtonImgCrop.Width:=ctrlback.width;
ButtonImgRL.Width:=ctrlback.width;
ButtonImgRR.Width:=ctrlback.width;
ButtonImg6.Width:=imagelistroot.width;
ButtonImgR.Width:=imagelistroot.width;
ButtonImgRes.Width:=imagelistroot.width;
end;
end;

procedure setlargetoolbar2;
var bheight:longint;
begin
with FormPeach do
begin
if lsize=1 then bheight:=mbarheight
else bheight:=mmbarheight;
bheight:=(bheight*pzoom) div 100;
PanelBarOpen.Height:=bheight;
PanelBarOpen1.Height:=bheight;
PanelBarOpen2.Height:=bheight;
PanelBarOpen3.Height:=bheight;
settoolglyphleft;
settoolmargin;
settoolspacing((6*qscaleimages) div 100);
settoolbigicon;
settooltext;
settoolbtnw((24*qscaleimages) div 100,true);
end;
toolsize:=0;
ptoolsize:=toolsize;
end;

procedure setsmalltoolbar2;
var
   smallheight:integer;
begin
with FormPeach do
begin
//smallheight:=PanelListBar.Height;
//if smallheight=0 then smallheight:=barheight;
smallheight:=barheight;
PanelBarOpen.Height:=smallheight;
PanelBarOpen2.Height:=smallheight;
PanelBarOpen3.Height:=smallheight;
settoolglyphleft;
settoolmargin;
settoolspacing((6*qscaleimages) div 100);
settoolsmallicon;
settooltext;
settoolbtnw((24*qscaleimages) div 100,true);
end;
toolsize:=4;
ptoolsize:=toolsize;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI ICONS

///////////////////////////////////////////////////////////////////////////////}

procedure setpwicons;
begin
try
if (FormPW.EditPWpass.Text='') and (FormPW.EditPWkeyfile.Text='') then
   begin
   FormPeach.msetpw.Bitmap:=Blocker2;
   FormPeach.msetpw.Caption:=txt_2_7_setpw;
   FormPeach.BtnPasswordExtract.Glyph:=blocker2;
   FormPeach.BtnPasswordArchive.Glyph:=blocker2;
   FormPeach.BtnPassword.Glyph:=blocker2;
   FormPeach.BtnPassword.Hint:=txt_2_7_pwnotset;
   FormPeach.po_setpw.Bitmap:=Blocker2;
   FormPeach.po_setpw.Caption:=txt_2_7_setpw;
   FormPeach.menupw.Bitmap:=Blocker2;
   FormPeach.menupw.Caption:=txt_2_7_setpw;
   FormPeach.pmqesetpw.Bitmap:=Blocker2;
   FormPeach.pmqesetpw.Caption:=txt_2_7_setpw;
   FormPeach.menuitempw.Bitmap:=Blocker2;
   FormPeach.menuitempw.Caption:=txt_2_7_setpw;
   if (archive_type<>'7z') and (archive_type<>'zip') and (archive_type<>'arc') and (archive_type<>'zpaq') and (fun<>'PEA') and (fun<>'CUSTOM') then
      begin
      FormPeach.BtnPasswordArchive.Caption:=txt_2_7_setpw;
      FormPeach.BtnPasswordArchive.Hint:=txt_2_5_nopw;
      FormPeach.BtnPasswordArchive.Visible:=false;
      end
   else
      begin
      FormPeach.BtnPasswordArchive.Caption:=txt_2_7_setpw;
      FormPeach.BtnPasswordArchive.Hint:=txt_encryption;
      FormPeach.BtnPasswordArchive.Visible:=true;
      end;
   FormPeach.BtnPasswordExtract.Caption:=txt_2_7_setpw;
   FormPeach.BtnPasswordExtract.Hint:=txt_encryption;
   end
else
   begin
   FormPeach.msetpw.Bitmap:=Blocker;
   FormPeach.msetpw.Caption:=txt_2_7_setpw+' *';
   FormPeach.BtnPasswordExtract.Glyph:=blocker;
   FormPeach.BtnPasswordArchive.Glyph:=blocker;
   FormPeach.BtnPassword.Glyph:=blocker;
   FormPeach.BtnPassword.Hint:=txt_2_7_pwextset;
   FormPeach.po_setpw.Bitmap:=Blocker;
   FormPeach.po_setpw.Caption:=txt_2_7_setpw+' *';
   FormPeach.menupw.Bitmap:=Blocker;
   FormPeach.menupw.Caption:=txt_2_7_setpw+' *';
   FormPeach.pmqesetpw.Bitmap:=Blocker;
   FormPeach.pmqesetpw.Caption:=txt_2_7_setpw+' *';
   FormPeach.menuitempw.Bitmap:=Blocker;
   FormPeach.menuitempw.Caption:=txt_2_7_setpw+' *';
   if (archive_type<>'7z') and (archive_type<>'zip') and (archive_type<>'arc') and (archive_type<>'zpaq') and (fun<>'PEA') and (fun<>'CUSTOM') then
      begin
      FormPeach.BtnPasswordArchive.Caption:=txt_2_7_setpw;
      FormPeach.BtnPasswordArchive.Hint:=txt_2_5_nopw;
      FormPeach.BtnPasswordArchive.Visible:=false;
      end
   else
      begin
      FormPeach.BtnPasswordArchive.Caption:=txt_2_7_setpw;
      FormPeach.BtnPasswordArchive.Hint:=txt_encryption;
      FormPeach.BtnPasswordArchive.Visible:=true;
      end;
   FormPeach.BtnPasswordExtract.Caption:=txt_2_7_setpw;
   FormPeach.BtnPasswordExtract.Hint:=txt_encryption;
   end;
except
end;
end;

function geticon(fullname,fulltype:ansistring; pc:boolean):integer;
var
   s,ext:ansistring;
begin
result:=-1;
ext:=lowercase(fulltype);
if pc=true then
   begin
   if ext = lowercase(txt_unit_removable) then result:=11; //Bremovable_supported
   if ext = lowercase(txt_unit_hd) then result:=8; //Bhd_supported
   if ext = lowercase(txt_unit_remote) then result:=10; //Bremote_supported
   if ext = lowercase(txt_unit_cd) then result:=6; //Bdvd_supported
   if ext = lowercase(txt_unit_ram) then result:=9; //Bram_supported
   if ext = lowercase(txt_unit_floppy) then result:=7; //Bfd_supported
   exit;
   end;
s:=fullname;
if (ext=lowercase(txt_list_isfolder)) or (ext=' [folder]') then begin result:=3; exit; end;
case ext of
'.lnk': result:=4;
'.txt','asc','.rtf','.wri','.ini','.log': result:=14;
'.doc','.dot','.docx','.dotx','.odt','.sxw','.wpd','.wps','.wpt','.gdoc','.tmdx','.pages': result:=2;
'.xls','.xlt','.xlsx','.xltm','.xltx','.ods','.gnm','.gnumeric','.csv','.123',
'.sxc','.gsheet','.numbers','.numbers-tef','.dif','.pmdx','.pmvx': result:=13;
'.pps','.ppt','.pot','.pptx','.ppsx','.potx','.odp','.gslides','.prdx','.key': result:=18;
'.db','.dbf','.mdb','.adp','.mdf','.nsf','.dat','.fp','.fp3','.fp5','.fp7',
'.frm','.odb','.ora','.sql','.sqlite','.wdb','.rpt','.iwa': result:=24;
'.eml': result:=23;
'.bat','.pif','.scr','.vbs','.cmd','.reg','.sh','.command','.csh': result:=20;
'.dll','.sys','.so','.dylib': result:=22;
'.htm','.html','.xml','.mht','.url': result:=16;
'.pdf': result:=19;
'.ani','.cur','.ico','.icl','.icns','.xbm','.xpm': result:=26;
'.svg','.ps','.eps','.cdr','.ai','.cpt','.psd','.psp','.xcf','.pdn','.blend',
'.dwf','.dwg','.3ds','.pict','.pic','.pct','.dxf','.wmf','.djvu','.djv','.xps',
'.oxps','.tex','.gdraw','.pub','.pmd': result:=27;
'.png','.bmp','.tga','.tif','.tiff','.pbm','.pgm','.ppm','.pns': result:=17;
'.gif': result:=25;
'.jpg','.jpe','.jpeg','.jif','.jfif','.jfi','.jpx','.jp2','.j2k','.webp','.jps',
'.mpo','.heif','.heic','.avif': result:=35;
'.avi','.mpg','.mpeg','.mpe','.mpv','.mp2','.m2v','.xvid','.divx','.mp4','.m4v',
'.m4p','.mov','.qt','.3gp','.3g2','.wmv','.swf','.flv','.f4p','.f4v','.fla',
'.mkv','.mk3d','.webm','.vob','.ogv','.rm','.rmvb','.asf','.amv','.svi','.nsv',
'.mng','.apng','.mts','.ts': result:=15;
'.wav','.mp3','.mid','.wma','.aiff','.au','.ogg','.oga','.aac','.amr','.ape',
'.flac','.wv','.m4a','.mpc','.ra','.pcm','.gsm','.aa','.aax','.m4b','.mmf',
'.opus','.tta','.vox': result:=12;
'.7z':result:=45;
'.rar':result:=46;
'.zip','.zipx':result:=47;
'.001','.r01','.z01','.zx01':result:=48;
'.iso':result:=49;
'.deb','.rpm','.appx','.msix','.snap','.appimage':result:=50;
else
case testext(s) of //most used special formats are intercepted before
   -1: result:=5; //BUnsupported
   503: result:=21;//any other primarily non archive format not intercepted before (like swf fla flv)
   502: result:=21;//other office files, non executable compound
   501: result:=21;//other ooo files
   500: result:=1;//exe and msi
   else
      result:=0;//generic archives
   end;
end;
end;

function pgetbitmap(i:integer):TBitmap;
begin
case i of
   0: result:=Barchivesupported;
   1: result:=Bexesupported;
   2: result:=Bfilesupported;
   3: result:=Bfolder;
   4: result:=Blink;
   5: result:=Bunsupported;
   6: result:=Bdvd_supported;
   7: result:=Bfd_supported;
   8: result:=Bhd_supported;
   9: result:=Bram_supported;
  10: result:=Bremote_supported;
  11: result:=Bremovable_supported;
  12: result:=Baudio;
  13: result:=Bspreadsheet;
  14: result:=Btxt;
  15: result:=Bvideo;
  16: result:=Bweb;
  17: result:=Bimage;
  18: result:=Bpresentation;
  19: result:=Bpdf;
  20: result:=Bbat;
  21: result:=Bsupported;
  22: result:=Bdll;
  23: result:=Bmail;
  24: result:=Bdb;
  25: result:=Bgif;
  26: result:=Bico;
  27: result:=Bvector;
  28: result:=Binfo;
  29: result:=Bsearch;
  30: result:=Bbookmark;
  31: result:=Broot;
  32: result:=Bsystemtools;
  33: result:=Bexpand;
  34: result:=Bgopath;
  35: result:=Bjpeg;
  45: result:=Barc7z;
  46: result:=Barcrar;
  47: result:=Barczip;
  48: result:=Barcblock;
  49: result:=Barcdisk;
  50: result:=Barcinstaller;
   else result:=Bunsupported;
   end;
end;

function drawmenuicon(s1:ansistring):TBitmap;
var
   fulltype:ansistring;
   i:integer;
begin
with FormPeach do
begin
if s1='' then
   begin
   result:=nil;
   exit;
   end;
if (s1 = desktop_path) or (s1 = txt_desktop) then
   begin
   result:=Bdesk;
   exit;
   end;
if (s1 = home_path) or (s1 = txt_2_9_home) then
   begin
   result:=Bhomefolder;
   exit;
   end;
if (s1 = usr_documents) or (s1 = txt_2_4_documents) then
   begin
   result:=Bfilesupported;
   exit;
   end;
if (s1 = usr_downloads) or (s1 = txt_3_1_downloads) then
   begin
   result:=Bdownloadfolder;
   exit;
   end;
if (s1 = usr_music) or (s1 = txt_5_0_music) then
   begin
   result:=Baudio;
   exit;
   end;
if (s1 = usr_pictures) or (s1 = txt_5_0_pictures) then
   begin
   result:=Bimage;
   exit;
   end;
if (s1 = usr_videos) or (s1 = txt_5_0_videos) then
   begin
   result:=Bvideo;
   exit;
   end;
if (s1 = shared_dropbox) or (s1 = shared_myboxfiles) or (s1 = shared_googledrive)
   or (s1 = shared_onedrive) or (s1 = shared_skydrive) or (s1 = shared_ubuntuone)then
   begin
   result:=Bcloudfolder;
   exit;
   end;
{$IFDEF MSWINDOWS}
if (s1 = txt_mypc) or (s1 = 'Computer''s root') then
   begin
   result:=Bsystemtools;
   exit;
   end;
if length(s1) = 3 then
   begin
   i:=ord(s1[1])-64;
   result:=devicon[i];
   exit;
   end;
{$ENDIF}
if s1<>'' then
   if s1[length(s1)]=directoryseparator then fulltype:=txt_list_isfolder
else fulltype:=extractfileext(s1);
result:=pgetbitmap(geticon(s1,fulltype,false));
end;
end;

function drawhistoryicon(n:integer):TBitmap;
var
   s1,s2:ansistring;
begin
with FormPeach do
begin
s1:=StringGridSessionHistory.Cells[2,n];
if s1='' then
   begin
   result:=nil;
   exit;
   end;
if StringGridSessionHistory.Cells[1,n] = txt_list_found then
   begin
   result:=Bsearch;
   exit;
   end;
if StringGridSessionHistory.Cells[1,n] = txt_list_flat then
   begin
   result:=Bexpand;
   exit;
   end;
s2:=StringGridSessionHistory.Cells[3,n];
if s2<>''
   then s2:=s2[length(s2)];
if s2<>'*' then
   begin
   result:=Bgopath;
   exit;
   end;
result:=drawmenuicon(s1);
end;
end;

function drawrecenticon(s:ansistring):TBitmap;
var
   fulltype:ansistring;
   i:integer;
begin
with FormPeach do
begin
if s='' then
   begin
   result:=nil;
   exit;
   end;
{$IFDEF MSWINDOWS}
if (s = txt_mypc)  or (s = 'Computer''s root') then
   begin
   result:=Bsystemtools;
   exit;
   end;
if length(s) = 3 then
   begin
   i:=ord(s[1])-64;
   result:=devicon[i];
   exit;
   end;
{$ENDIF}
if s<>'' then
   if s[length(s)]=directoryseparator then fulltype:=txt_list_isfolder
   else fulltype:=extractfileext(s);
result:=pgetbitmap(geticon(s,fulltype,false));
end;
end;

function getpcmenuicon(b:TBitmap):integer;
begin
Result:=5; //unsupported, in ImageList1
if b=Bfd_supported then Result:=7;
if b=Bremovable_supported then Result:=11;
if b=Bhd_supported then Result:=8;
if b=Bremote_supported then Result:=10;
if b=Bdvd_supported then Result:=6;
if b=Bram_supported then Result:=9;
end;

function drawlisticon(arow:integer):integer;
var
   fullname,fulltype,s:ansistring;
   pc:boolean;
begin
result:=5;
if (FormPeach.EditOpenIn.Text<>txt_mypc) then pc:=false
else pc:=true;
fullname:=FormPeach.StringGridList.Cells[12,arow];
fulltype:=lowercase(FormPeach.StringGridList.Cells[2,arow]);
if FormPeach.StringGridList.Cells[1,arow]<>'' then
   if (fulltype=lowercase(txt_list_isfolder)) or (fulltype=' [folder]') then
      begin
      result:=3;
      s:=fullname+directoryseparator;
      if s = desktop_path then result:=36;
      if s = home_path then result:=42;
      if s = usr_documents then result:=2;
      if s = usr_downloads then result:=43;
      if s = usr_music then result:=12;
      if s = usr_pictures then result:=17;
      if s = usr_videos then result:=15;
      if (s = shared_dropbox) or (s = shared_myboxfiles) or (s = shared_googledrive)
      or (s = shared_onedrive) or (s = shared_skydrive) or (s = shared_ubuntuone)then result:=44;
      end
   else
      result:=geticon(fullname,fulltype,pc);
end;

function drawtabicon(arow:integer):integer;
var
   s,s1,fulltype:ansistring;
   i:integer;
begin
result:=-1;
if arow>=FormPeach.StringGridSessionHistory.rowcount then exit;
s:=FormPeach.StringGridSessionHistory.Cells[2,arow];
if (s = txt_mypc) or (s = 'Computer''s root') then
   begin
   result:=32;
   exit;
   end;
if FormPeach.StringGridSessionHistory.Cells[1,arow] = txt_list_found then
      begin
      result:=29;
      exit;
      end;
if FormPeach.StringGridSessionHistory.Cells[1,arow] = txt_list_flat then
      begin
      result:=33;
      exit;
      end;
s1:=FormPeach.StringGridSessionHistory.Cells[3,arow];
if s1<>'' then
   s1:=s1[length(s1)];
if s1<>'*' then
      begin
      result:=34;
      exit;
      end;
if s = desktop_path then
   begin
   result:=36;
   exit;
   end;
if s = home_path then
   begin
   result:=42;
   exit;
   end;
if s = usr_documents then
   begin
   result:=2;
   exit;
   end;
if s = usr_downloads then
   begin
   result:=43;
   exit;
   end;
if s = usr_music then
   begin
   result:=12;
   exit;
   end;
if s = usr_pictures then
   begin
   result:=17;
   exit;
   end;
if s = usr_videos then
   begin
   result:=15;
   exit;
   end;
if (s = shared_dropbox) or (s = shared_myboxfiles) or (s = shared_googledrive)
   or (s = shared_onedrive) or (s = shared_skydrive) or (s = shared_ubuntuone)then
   begin
   result:=44;
   exit;
   end;
{$IFDEF MSWINDOWS}
if length(s) = 3 then
   begin
   i:=getdrivetype(Pchar(s));
   if (s[1]='A') or (s[1]='B') then result:=7
   else
      case i of
         2: result:=11;
         3: result:=8;
         4: result:=10;
         5: result:=6;
         6: result:=9;
         else result:=5;
      end;
   exit;
   end;
{$ENDIF}
if s<>'' then
   if s[length(s)]=directoryseparator then fulltype:=txt_list_isfolder
else fulltype:=extractfileext(s);
result:=geticon(s,fulltype,false);
end;

procedure clearimagelist(var aimagelist:TImageList);
begin
repeat
aimagelist.Delete(aimagelist.Count-1);
until aimagelist.Count<=0;
end;

procedure intloadicon(var srcbitmap,destbitmap:TBitmap; icon_size,relativeiconsize:integer);
var
   abitmap:TBitmap;
begin
if icon_size>96 then
   begin //this method is better for expanding icons
   abitmap:=Tbitmap.Create;
   abitmap.Assign(srcbitmap);
   setpbitmap(abitmap,scalediconsize);
   loadlargeicon(abitmap,destbitmap,spacedscalediconsize);
   abitmap.free;
   end
else
   begin //this method is better for reducing icons
   loadlargeicon(srcbitmap,destbitmap,relativeiconsize);
   end;
il96.Add(destbitmap,nil);
end;

procedure loadlargeicons(icon_size:integer);
var
   abitmap:TBitmap;
begin
baseiconsize:=icon_size;
scalediconsize:=(icon_size*qscaleimages) div 100;
spacedscalediconsize:=((icon_size+pspacing*2)*qscaleimages) div 100;
with FormPeach do
   begin
   clearimagelist(il96);
   il96.Height:=spacedscalediconsize;
   il96.Width:=spacedscalediconsize;
   case icon_size of
   48: relativeiconsize:=spacedscalediconsize * 2;
   64: relativeiconsize:=(spacedscalediconsize*3) div 2;
   72: relativeiconsize:=(spacedscalediconsize*4) div 3;
   96: relativeiconsize:=spacedscalediconsize;
   128: relativeiconsize:=(spacedscalediconsize*3) div 4;
   144: relativeiconsize:=(spacedscalediconsize*2) div 3;
   192: relativeiconsize:=spacedscalediconsize div 2;
   end;
   abitmap:=Tbitmap.Create;
   intloadicon(Barchivesupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bexesupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bfilesupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(BFolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Blink96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bunsupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdvd_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bfd_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bhd_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bram_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bremote_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bremovable_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Baudio96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bspreadsheet96,abitmap,icon_size,relativeiconsize);
   intloadicon(Btxt96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bvideo96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bweb96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bimage96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bpresentation96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bpdf96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bbat96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bsupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdll96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bmail96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdb96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bgif96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bico96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bvector96,abitmap,icon_size,relativeiconsize);
   intloadicon(Binfo,abitmap,icon_size,relativeiconsize);
   intloadicon(Bsearch,abitmap,icon_size,relativeiconsize);
   intloadicon(Bbookmark,abitmap,icon_size,relativeiconsize);
   intloadicon(Broot,abitmap,icon_size,relativeiconsize);
   intloadicon(Bsystemtools,abitmap,icon_size,relativeiconsize);
   intloadicon(Bexpand,abitmap,icon_size,relativeiconsize);
   intloadicon(Bgopath,abitmap,icon_size,relativeiconsize);
   intloadicon(Bjpeg96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdesk96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bplaceshistory,abitmap,icon_size,relativeiconsize);
   intloadicon(Bbookmarkadd,abitmap,icon_size,relativeiconsize);
   intloadicon(Brun,abitmap,icon_size,relativeiconsize);
   intloadicon(Bpreview,abitmap,icon_size,relativeiconsize);
   intloadicon(Bapps,abitmap,icon_size,relativeiconsize);
   intloadicon(Bhomefolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdownloadfolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bcloudfolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barc7z96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcrar96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barczip96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcblock96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcdisk96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcinstaller96,abitmap,icon_size,relativeiconsize);
   ListViewBrowser.LargeImages:=il96;
   abitmap.free;
   end;
end;

procedure loadsmallicons(icon_size:integer);
var
   abitmap:TBitmap;
begin
baseiconsize:=icon_size;
scalediconsize:=(icon_size*qscaleimages) div 100;
with FormPeach do
   begin
   case icon_size of
   16: begin
   spacedscalediconsize:=icon_sizeplus;
   relativeiconsize:=icon_sizeplus;
   clearimagelist(il16);
   il16.Height:=icon_sizeplus;
   il16.Width:=icon_sizeplus;
   abitmap:=Tbitmap.Create;
   loadlargeicon(Barchivesupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bexesupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bfilesupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(BFolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Blink,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bunsupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdvd_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bfd_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bhd_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bram_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bremote_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bremovable_supported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Baudio,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bspreadsheet,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Btxt,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bvideo,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bweb,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bimage,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bpresentation,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bpdf,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bbat,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bsupported,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdll,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bmail,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdb,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bgif,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bico,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bvector,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Binfo,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bsearch,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bbookmark,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Broot,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bsystemtools,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bexpand,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bgopath,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bjpeg,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdesk,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bplaceshistory,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bbookmarkadd,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Brun,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bpreview,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bapps,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bhomefolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bdownloadfolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Bcloudfolder,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barc7z,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcrar,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barczip,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcblock,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcdisk,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   loadlargeicon(Barcinstaller,abitmap,icon_sizeplus);
   il16.Add(abitmap,nil);
   ListViewBrowser.SmallImages:=il16;
   abitmap.free;
   end;
   else
   begin
   spacedscalediconsize:=((icon_size+pspacing*2)*qscaleimages) div 100;
   clearimagelist(il96);
   il96.Height:=spacedscalediconsize;
   il96.Width:=spacedscalediconsize;
   case icon_size of
   24: relativeiconsize:=spacedscalediconsize * 4;
   32: relativeiconsize:=spacedscalediconsize * 3;
   48: relativeiconsize:=spacedscalediconsize * 2;
   64: relativeiconsize:=(spacedscalediconsize * 3) div 2;
   72: relativeiconsize:=(spacedscalediconsize * 4) div 3;
   96: relativeiconsize:=spacedscalediconsize;
   end;
   abitmap:=Tbitmap.Create;
   intloadicon(Barchivesupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bexesupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bfilesupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(BFolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Blink96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bunsupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdvd_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bfd_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bhd_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bram_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bremote_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bremovable_supported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Baudio96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bspreadsheet96,abitmap,icon_size,relativeiconsize);
   intloadicon(Btxt96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bvideo96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bweb96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bimage96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bpresentation96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bpdf96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bbat96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bsupported96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdll96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bmail96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdb96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bgif96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bico96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bvector96,abitmap,icon_size,relativeiconsize);
   intloadicon(Binfo,abitmap,icon_size,relativeiconsize);
   intloadicon(Bsearch,abitmap,icon_size,relativeiconsize);
   intloadicon(Bbookmark,abitmap,icon_size,relativeiconsize);
   intloadicon(Broot,abitmap,icon_size,relativeiconsize);
   intloadicon(Bsystemtools,abitmap,icon_size,relativeiconsize);
   intloadicon(Bexpand,abitmap,icon_size,relativeiconsize);
   intloadicon(Bgopath,abitmap,icon_size,relativeiconsize);
   intloadicon(Bjpeg96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdesk96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bplaceshistory,abitmap,icon_size,relativeiconsize);
   intloadicon(Bbookmarkadd,abitmap,icon_size,relativeiconsize);
   intloadicon(Brun,abitmap,icon_size,relativeiconsize);
   intloadicon(Bpreview,abitmap,icon_size,relativeiconsize);
   intloadicon(Bapps,abitmap,icon_size,relativeiconsize);
   intloadicon(Bhomefolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bdownloadfolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Bcloudfolder96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barc7z96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcrar96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barczip96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcblock96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcdisk96,abitmap,icon_size,relativeiconsize);
   intloadicon(Barcinstaller96,abitmap,icon_size,relativeiconsize);
   ListViewBrowser.SmallImages:=il96;
   abitmap.free;
   end;
   end;
   end;
end;

procedure loadimglisticons;
var
   abitmap:TBitmap;
begin
with FormPeach do
begin
abitmap:=Tbitmap.Create;
ilsmall.Clear;
loadlargeicon(Barchivesupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bexesupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bfilesupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(BFolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Blink,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bunsupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdvd_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bfd_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bhd_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bram_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bremote_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bremovable_supported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Baudio,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bspreadsheet,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Btxt,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bvideo,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bweb,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bimage,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bpresentation,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bpdf,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bbat,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bsupported,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdll,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bmail,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdb,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bgif,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bico,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bvector,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Binfo,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bsearch,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bbookmark,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Broot,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bsystemtools,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bexpand,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bgopath,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bjpeg,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdesk,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bplaceshistory,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bbookmarkadd,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Brun,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bpreview,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bapps,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bhomefolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bdownloadfolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bcloudfolder,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barc7z,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcrar,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barczip,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcblock,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcdisk,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barcinstaller,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Barchive,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bextractall,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bextractalln,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
loadlargeicon(Bconvert,abitmap,icon_sizeplus);
ilsmall.Add(abitmap,nil);
abitmap.free;
end;
end;

procedure load_icons; //load icons from bitmaps
var
   i:integer;
   thpath:ansistring;

procedure loadlighticons;
begin
with FormPeach do
   begin
   il_nonthemed.getbitmap(0,Bav);
   il_nonthemed.getbitmap(1,Bfilter);
   il_nonthemed.getbitmap(2,Bflat);
   il_nonthemed.getbitmap(3,Bcollapse);
   il_dtheme_16.getbitmap(0,Bbookmarkadd);
   il_dtheme_16.getbitmap(1,Bapps);
   il_dtheme_16.getbitmap(2,BArchive);
   il_dtheme_16.getbitmap(3,Bclearlayout);
   il_dtheme_16.getbitmap(4,Bconvert);
   il_dtheme_16.getbitmap(5,Bdelete);
   il_dtheme_16.getbitmap(6,Bextractall);
   il_dtheme_16.getbitmap(7,Bextractalln);
   il_dtheme_16.getbitmap(8,Bloadlayout);
   il_dtheme_16.getbitmap(9,Bpreview);
   il_dtheme_16.getbitmap(10,Brun);
   il_dtheme_16.getbitmap(11,Bsavelayout);
   il_dtheme_16.getbitmap(12,Bwipe);
   il_dtheme_16.getbitmap(13,Btestall);
   il_dtheme_16.getbitmap(14,Bdvd_supported);
   il_dtheme_16.getbitmap(15,Bfd_supported);
   il_dtheme_16.getbitmap(16,Bhd_supported);
   il_dtheme_16.getbitmap(17,Bram_supported);
   il_dtheme_16.getbitmap(18,Bremote_supported);
   il_dtheme_16.getbitmap(19,Bremovable_supported);
   il_dtheme_16.getbitmap(20,BArchiveSupported);
   il_dtheme_16.getbitmap(21,Baudio);
   il_dtheme_16.getbitmap(22,Bdll);
   il_dtheme_16.getbitmap(23,Bdb);
   il_dtheme_16.getbitmap(24,BFileSupported);
   il_dtheme_16.getbitmap(25,BExeSupported);
   il_dtheme_16.getbitmap(26,Bimage);
   il_dtheme_16.getbitmap(27,Bico);
   il_dtheme_16.getbitmap(28,Bjpeg);
   il_dtheme_16.getbitmap(29,Bgif);
   il_dtheme_16.getbitmap(30,Bvector);
   il_dtheme_16.getbitmap(31,Blink);
   il_dtheme_16.getbitmap(32,Bmail);
   il_dtheme_16.getbitmap(33,Bpdf);
   il_dtheme_16.getbitmap(34,Bpresentation);
   il_dtheme_16.getbitmap(35,Bbat);
   il_dtheme_16.getbitmap(36,Bspreadsheet);
   il_dtheme_16.getbitmap(37,Bsupported);
   il_dtheme_16.getbitmap(38,Btxt);
   il_dtheme_16.getbitmap(39,BUnsupported);
   il_dtheme_16.getbitmap(40,Bvideo);
   il_dtheme_16.getbitmap(41,Bweb);
   il_dtheme_16.getbitmap(42,BFolder);
   il_dtheme_16.getbitmap(43,Binfo);
   il_dtheme_16.getbitmap(44,Bnav);
   il_dtheme_16.getbitmap(45,Bkeyfile);
   il_dtheme_16.getbitmap(46,Blocker);
   il_dtheme_16.getbitmap(47,Blocker2);
   il_dtheme_16.getbitmap(48,Bback);
   il_dtheme_16.getbitmap(49,Bexpand);
   il_dtheme_16.getbitmap(50,Bgo);
   il_dtheme_16.getbitmap(51,Brefresh);
   il_dtheme_16.getbitmap(52,Bsearch);
   il_dtheme_16.getbitmap(53,Bgopath);
   il_dtheme_16.getbitmap(54,Bresetpath);
   il_dtheme_16.getbitmap(55,Bgoup);
   il_dtheme_16.getbitmap(56,Bp0);
   il_dtheme_16.getbitmap(57,Bbookmark);
   il_dtheme_16.getbitmap(58,Bdesk);
   il_dtheme_16.getbitmap(59,Bplaceshistory);
   il_dtheme_16.getbitmap(60,Broot);
   il_dtheme_16.getbitmap(61,Bsystemtools);
   il_dtheme_16.getbitmap(62,BDefaults);
   il_dtheme_16.getbitmap(63,Bstop);
   il_dtheme_16.getbitmap(64,BTool_cut_small);
   il_dtheme_16.getbitmap(65,BTool_copy_small);
   il_dtheme_16.getbitmap(66,BTool_dup_small);
   il_dtheme_16.getbitmap(67,Btool_properties_small);
   il_dtheme_16.getbitmap(68,Btool_rename_small);
   il_dtheme_16.getbitmap(69,Btool_resize_small);
   il_dtheme_16.getbitmap(70,Btool_crop_small);
   il_dtheme_16.getbitmap(71,BTool_rl_small);
   il_dtheme_16.getbitmap(72,BTool_rr_small);
   il_dtheme_16.getbitmap(73,Bmenu);
   il_dtheme_16.getbitmap(74,Bseparator);
   il_dtheme_16.getbitmap(75,Bsettings);
   il_dtheme_16.getbitmap(76,Bdetailsf);
   il_dtheme_16.getbitmap(77,Blistf);
   il_dtheme_16.getbitmap(78,Biconsf);
   il_dtheme_16.getbitmap(79,Bhomefolder);
   il_dtheme_16.getbitmap(80,Bdownloadfolder);
   il_dtheme_16.getbitmap(81,Bcloudfolder);
   il_dtheme_16.getbitmap(82,Barc7z);
   il_dtheme_16.getbitmap(83,Barcrar);
   il_dtheme_16.getbitmap(84,Barczip);
   il_dtheme_16.getbitmap(85,Barcblock);
   il_dtheme_16.getbitmap(86,Barcdisk);
   il_dtheme_16.getbitmap(87,Barcinstaller);
   il_dtheme_96.getbitmap(0,Bdvd_supported96);
   il_dtheme_96.getbitmap(1,Bfd_supported96);
   il_dtheme_96.getbitmap(2,Bhd_supported96);
   il_dtheme_96.getbitmap(3,Bram_supported96);
   il_dtheme_96.getbitmap(4,Bremote_supported96);
   il_dtheme_96.getbitmap(5,Bremovable_supported96);
   il_dtheme_96.getbitmap(6,BArchiveSupported96);
   il_dtheme_96.getbitmap(7,Baudio96);
   il_dtheme_96.getbitmap(8,Bdll96);
   il_dtheme_96.getbitmap(9,Bdb96);
   il_dtheme_96.getbitmap(10,BFileSupported96);
   il_dtheme_96.getbitmap(11,BExeSupported96);
   il_dtheme_96.getbitmap(12,Bimage96);
   il_dtheme_96.getbitmap(13,Bico96);
   il_dtheme_96.getbitmap(14,Bjpeg96);
   il_dtheme_96.getbitmap(15,Bgif96);
   il_dtheme_96.getbitmap(16,Bvector96);
   il_dtheme_96.getbitmap(17,Blink96);
   il_dtheme_96.getbitmap(18,Bmail96);
   il_dtheme_96.getbitmap(19,Bpdf96);
   il_dtheme_96.getbitmap(20,Bpresentation96);
   il_dtheme_96.getbitmap(21,Bbat96);
   il_dtheme_96.getbitmap(22,Bspreadsheet96);
   il_dtheme_96.getbitmap(23,Bsupported96);
   il_dtheme_96.getbitmap(24,Btxt96);
   il_dtheme_96.getbitmap(25,BUnsupported96);
   il_dtheme_96.getbitmap(26,Bvideo96);
   il_dtheme_96.getbitmap(27,Bweb96);
   il_dtheme_96.getbitmap(28,BFolder96);
   il_dtheme_96.getbitmap(29,Barc7z96);
   il_dtheme_96.getbitmap(30,Barcrar96);
   il_dtheme_96.getbitmap(31,Barczip96);
   il_dtheme_96.getbitmap(32,Barcblock96);
   il_dtheme_96.getbitmap(33,Barcdisk96);
   il_dtheme_96.getbitmap(34,Barcinstaller96);
   il_dtheme_96.getbitmap(35,Bcloudfolder96);
   il_dtheme_96.getbitmap(36,Bdesk96);
   il_dtheme_96.getbitmap(37,Bdownloadfolder96);
   il_dtheme_96.getbitmap(38,bhomefolder96);
   il_dtheme_tool32.getbitmap(0,Bdetailsfs);
   il_dtheme_tool32.getbitmap(1,BArchive_big);
   il_dtheme_tool32.getbitmap(2,Bconvert_big);
   il_dtheme_tool32.getbitmap(3,Bextractall_big);
   il_dtheme_tool32.getbitmap(4,Bextractalln_big);
   il_dtheme_tool32.getbitmap(5,Btestall_big);
   il_dtheme_tool32.getbitmap(6,Btool_cut);
   il_dtheme_tool32.getbitmap(7,Btool_copy);
   il_dtheme_tool32.getbitmap(8,Btool_paste);
   il_dtheme_tool32.getbitmap(9,Btool_openw);
   il_dtheme_tool32.getbitmap(10,Btool_properties);
   il_dtheme_tool32.getbitmap(11,Btool_rename);
   il_dtheme_tool32.getbitmap(12,Btool_delete);
   il_dtheme_tool32.getbitmap(13,Btool_dup);
   il_dtheme_tool32.getbitmap(14,Btool_resize);
   il_dtheme_tool32.getbitmap(15,Btool_crop);
   il_dtheme_tool32.getbitmap(16,BTool_rl);
   il_dtheme_tool32.getbitmap(17,BTool_rr);
   end;
end;

procedure loaddarkicons;
begin
with FormPeach do
   begin
   il_nonthemed_dark.getbitmap(0,Bav);
   il_nonthemed_dark.getbitmap(1,Bfilter);
   il_nonthemed_dark.getbitmap(4,Bflat);
   il_nonthemed_dark.getbitmap(3,Bcollapse);
   il_dtheme_16_dark.getbitmap(0,Bbookmarkadd);
   il_dtheme_16_dark.getbitmap(1,Bapps);
   il_dtheme_16_dark.getbitmap(2,BArchive);
   il_dtheme_16_dark.getbitmap(3,Bclearlayout);
   il_dtheme_16_dark.getbitmap(4,Bconvert);
   il_dtheme_16_dark.getbitmap(5,Bdelete);
   il_dtheme_16_dark.getbitmap(6,Bextractall);
   il_dtheme_16_dark.getbitmap(7,Bextractalln);
   il_dtheme_16_dark.getbitmap(8,Bloadlayout);
   il_dtheme_16_dark.getbitmap(9,Bpreview);
   il_dtheme_16_dark.getbitmap(10,Brun);
   il_dtheme_16_dark.getbitmap(11,Bsavelayout);
   il_dtheme_16_dark.getbitmap(12,Bwipe);
   il_dtheme_16_dark.getbitmap(13,Btestall);
   il_dtheme_16_dark.getbitmap(14,Bdvd_supported);
   il_dtheme_16_dark.getbitmap(15,Bfd_supported);
   il_dtheme_16_dark.getbitmap(16,Bhd_supported);
   il_dtheme_16_dark.getbitmap(17,Bram_supported);
   il_dtheme_16_dark.getbitmap(18,Bremote_supported);
   il_dtheme_16_dark.getbitmap(19,Bremovable_supported);
   il_dtheme_16_dark.getbitmap(20,BArchiveSupported);
   il_dtheme_16_dark.getbitmap(21,Baudio);
   il_dtheme_16_dark.getbitmap(22,Bdll);
   il_dtheme_16_dark.getbitmap(23,Bdb);
   il_dtheme_16_dark.getbitmap(24,BFileSupported);
   il_dtheme_16_dark.getbitmap(25,BExeSupported);
   il_dtheme_16_dark.getbitmap(26,Bimage);
   il_dtheme_16_dark.getbitmap(27,Bico);
   il_dtheme_16_dark.getbitmap(28,Bjpeg);
   il_dtheme_16_dark.getbitmap(29,Bgif);
   il_dtheme_16_dark.getbitmap(30,Bvector);
   il_dtheme_16_dark.getbitmap(31,Blink);
   il_dtheme_16_dark.getbitmap(32,Bmail);
   il_dtheme_16_dark.getbitmap(33,Bpdf);
   il_dtheme_16_dark.getbitmap(34,Bpresentation);
   il_dtheme_16_dark.getbitmap(35,Bbat);
   il_dtheme_16_dark.getbitmap(36,Bspreadsheet);
   il_dtheme_16_dark.getbitmap(37,Bsupported);
   il_dtheme_16_dark.getbitmap(38,Btxt);
   il_dtheme_16_dark.getbitmap(39,BUnsupported);
   il_dtheme_16_dark.getbitmap(40,Bvideo);
   il_dtheme_16_dark.getbitmap(41,Bweb);
   il_dtheme_16_dark.getbitmap(42,BFolder);
   il_dtheme_16_dark.getbitmap(43,Binfo);
   il_dtheme_16_dark.getbitmap(44,Bnav);
   il_dtheme_16_dark.getbitmap(45,Bkeyfile);
   il_dtheme_16_dark.getbitmap(46,Blocker);
   il_dtheme_16_dark.getbitmap(47,Blocker2);
   il_dtheme_16_dark.getbitmap(48,Bback);
   il_dtheme_16_dark.getbitmap(49,Bexpand);
   il_dtheme_16_dark.getbitmap(50,Bgo);
   il_dtheme_16_dark.getbitmap(51,Brefresh);
   il_dtheme_16_dark.getbitmap(52,Bsearch);
   il_dtheme_16_dark.getbitmap(53,Bgopath);
   il_dtheme_16_dark.getbitmap(54,Bresetpath);
   il_dtheme_16_dark.getbitmap(55,Bgoup);
   il_dtheme_16_dark.getbitmap(56,Bp0);
   il_dtheme_16_dark.getbitmap(57,Bbookmark);
   il_dtheme_16_dark.getbitmap(58,Bdesk);
   il_dtheme_16_dark.getbitmap(59,Bplaceshistory);
   il_dtheme_16_dark.getbitmap(60,Broot);
   il_dtheme_16_dark.getbitmap(61,Bsystemtools);
   il_dtheme_16_dark.getbitmap(62,BDefaults);
   il_dtheme_16_dark.getbitmap(63,Bstop);
   il_dtheme_16_dark.getbitmap(64,BTool_cut_small);
   il_dtheme_16_dark.getbitmap(65,BTool_copy_small);
   il_dtheme_16_dark.getbitmap(66,BTool_dup_small);
   il_dtheme_16_dark.getbitmap(67,Btool_properties_small);
   il_dtheme_16_dark.getbitmap(68,Btool_rename_small);
   il_dtheme_16_dark.getbitmap(69,Btool_resize_small);
   il_dtheme_16_dark.getbitmap(70,Btool_crop_small);
   il_dtheme_16_dark.getbitmap(71,BTool_rl_small);
   il_dtheme_16_dark.getbitmap(72,BTool_rr_small);
   il_dtheme_16_dark.getbitmap(73,Bmenu);
   il_dtheme_16_dark.getbitmap(74,Bseparator);
   il_dtheme_16_dark.getbitmap(75,Bsettings);
   il_dtheme_16_dark.getbitmap(76,Bdetailsf);
   il_dtheme_16_dark.getbitmap(77,Blistf);
   il_dtheme_16_dark.getbitmap(78,Biconsf);
   il_dtheme_16_dark.getbitmap(79,Bhomefolder);
   il_dtheme_16_dark.getbitmap(80,Bdownloadfolder);
   il_dtheme_16_dark.getbitmap(81,Bcloudfolder);
   il_dtheme_16_dark.getbitmap(82,Barc7z);
   il_dtheme_16_dark.getbitmap(83,Barcrar);
   il_dtheme_16_dark.getbitmap(84,Barczip);
   il_dtheme_16_dark.getbitmap(85,Barcblock);
   il_dtheme_16_dark.getbitmap(86,Barcdisk);
   il_dtheme_16_dark.getbitmap(87,Barcinstaller);
   il_dtheme_96_dark.getbitmap(0,Bdvd_supported96);
   il_dtheme_96_dark.getbitmap(1,Bfd_supported96);
   il_dtheme_96_dark.getbitmap(2,Bhd_supported96);
   il_dtheme_96_dark.getbitmap(3,Bram_supported96);
   il_dtheme_96_dark.getbitmap(4,Bremote_supported96);
   il_dtheme_96_dark.getbitmap(5,Bremovable_supported96);
   il_dtheme_96_dark.getbitmap(6,BArchiveSupported96);
   il_dtheme_96_dark.getbitmap(7,Baudio96);
   il_dtheme_96_dark.getbitmap(8,Bdll96);
   il_dtheme_96_dark.getbitmap(9,Bdb96);
   il_dtheme_96_dark.getbitmap(10,BFileSupported96);
   il_dtheme_96_dark.getbitmap(11,BExeSupported96);
   il_dtheme_96_dark.getbitmap(12,Bimage96);
   il_dtheme_96_dark.getbitmap(13,Bico96);
   il_dtheme_96_dark.getbitmap(14,Bjpeg96);
   il_dtheme_96_dark.getbitmap(15,Bgif96);
   il_dtheme_96_dark.getbitmap(16,Bvector96);
   il_dtheme_96_dark.getbitmap(17,Blink96);
   il_dtheme_96_dark.getbitmap(18,Bmail96);
   il_dtheme_96_dark.getbitmap(19,Bpdf96);
   il_dtheme_96_dark.getbitmap(20,Bpresentation96);
   il_dtheme_96_dark.getbitmap(21,Bbat96);
   il_dtheme_96_dark.getbitmap(22,Bspreadsheet96);
   il_dtheme_96_dark.getbitmap(23,Bsupported96);
   il_dtheme_96_dark.getbitmap(24,Btxt96);
   il_dtheme_96_dark.getbitmap(25,BUnsupported96);
   il_dtheme_96_dark.getbitmap(26,Bvideo96);
   il_dtheme_96_dark.getbitmap(27,Bweb96);
   il_dtheme_96_dark.getbitmap(28,BFolder96);
   il_dtheme_96_dark.getbitmap(29,Barc7z96);
   il_dtheme_96_dark.getbitmap(30,Barcrar96);
   il_dtheme_96_dark.getbitmap(31,Barczip96);
   il_dtheme_96_dark.getbitmap(32,Barcblock96);
   il_dtheme_96_dark.getbitmap(33,Barcdisk96);
   il_dtheme_96_dark.getbitmap(34,Barcinstaller96);
   il_dtheme_96_dark.getbitmap(35,Bcloudfolder96);
   il_dtheme_96_dark.getbitmap(36,Bdesk96);
   il_dtheme_96_dark.getbitmap(37,Bdownloadfolder96);
   il_dtheme_96_dark.getbitmap(38,bhomefolder96);
   il_dtheme_tool32_dark.getbitmap(0,Bdetailsfs);
   il_dtheme_tool32_dark.getbitmap(1,BArchive_big);
   il_dtheme_tool32_dark.getbitmap(2,Bconvert_big);
   il_dtheme_tool32_dark.getbitmap(3,Bextractall_big);
   il_dtheme_tool32_dark.getbitmap(4,Bextractalln_big);
   il_dtheme_tool32_dark.getbitmap(5,Btestall_big);
   il_dtheme_tool32_dark.getbitmap(6,Btool_cut);
   il_dtheme_tool32_dark.getbitmap(7,Btool_copy);
   il_dtheme_tool32_dark.getbitmap(8,Btool_paste);
   il_dtheme_tool32_dark.getbitmap(9,Btool_openw);
   il_dtheme_tool32_dark.getbitmap(10,Btool_properties);
   il_dtheme_tool32_dark.getbitmap(11,Btool_rename);
   il_dtheme_tool32_dark.getbitmap(12,Btool_delete);
   il_dtheme_tool32_dark.getbitmap(13,Btool_dup);
   il_dtheme_tool32_dark.getbitmap(14,Btool_resize);
   il_dtheme_tool32_dark.getbitmap(15,Btool_crop);
   il_dtheme_tool32_dark.getbitmap(16,BTool_rl);
   il_dtheme_tool32_dark.getbitmap(17,BTool_rr);
   end;
end;

begin
if imgloaded=true then exit;
if imgloading=true then exit;
imgloading:=true;
case ensmall of
   0: i16res:=(16*qscaleimages) div 100;
   1: i16res:=(18*qscaleimages) div 100;
   2: i16res:=(20*qscaleimages) div 100;
   3: i16res:=(24*qscaleimages) div 100;
   4: i16res:=(28*qscaleimages) div 100;
   5: i16res:=(32*qscaleimages) div 100;
   end;
if lsize=0 then
   i32res:=(24*qscaleimages) div 100
else
   i32res:=(32*qscaleimages) div 100;
i48res:=(48*qscaleimages) div 100;
i96res:=(96*qscaleimages) div 100;
with FormPeach do
   begin
   try
   //set non-themed graphic
   Bnonthemed:=TBitmap.Create;
   Bp1:=TBitmap.Create;
   binfodlg:=TBitmap.Create;
   bwarningdlg:=TBitmap.Create;
   bwarningsmall:=TBitmap.Create;
   berrordlg:=TBitmap.Create;
   il_nonthemed.getbitmap(0,Bnonthemed);
   il_nonthemed.getbitmap(5,Bp1);
   ImageListDlg.getbitmap(0,binfodlg);
   ImageListDlg.getbitmap(1,bwarningdlg);
   ImageListDlg.getbitmap(1,bwarningsmall);
   ImageListDlg.getbitmap(2,berrordlg);
   setpbitmap(Bnonthemed,i16res);
   setpbitmap(Bp1,i16res);
   setpbitmap(binfodlg,i32res);
   setpbitmap(bwarningdlg,i32res);
   setpbitmap(bwarningsmall,i16res);
   setpbitmap(berrordlg,i32res);
   //set themed graphic
   Bav:=TBitmap.Create;
   Bfilter:=TBitmap.Create;
   Bflat:=TBitmap.Create;
   Bcollapse:=TBitmap.Create;
   Bdetailsf:=TBitmap.Create;
   Blistf:=TBitmap.Create;
   Biconsf:=TBitmap.Create;
   bmenu:=TBitmap.Create;
   bseparator:=TBitmap.Create;
   bsettings:=TBitmap.Create;
   Bapps:=TBitmap.Create;
   Barchive_bigger2:=TBitmap.Create;
   Bplaceshistory:=TBitmap.Create;
   Bdb:=TBitmap.Create;
   Bgif:=TBitmap.Create;
   Bico:=TBitmap.Create;
   Bvector:=TBitmap.Create;
   Bsupported:=TBitmap.Create;
   Bbat:=TBitmap.Create;
   Bdll:=TBitmap.Create;
   Bimage:=TBitmap.Create;
   Bjpeg:=TBitmap.Create;
   Bpresentation:=TBitmap.Create;
   Bpdf:=TBitmap.Create;
   Btxt:=TBitmap.Create;
   Bspreadsheet:=TBitmap.Create;
   Bvideo:=TBitmap.Create;
   Baudio:=TBitmap.Create;
   Bconvert:=TBitmap.Create;
   Bconvert_big:=TBitmap.Create;
   BArchive_big:=TBitmap.Create;
   BArchive:=TBitmap.Create;
   BArchiveSupported:=TBitmap.Create;
   BFileSupported:=TBitmap.Create;
   BExesupported:=TBitmap.Create;
   BUnsupported:=TBitmap.Create;
   Bback:=TBitmap.Create;
   Bbookmark:=TBitmap.Create;
   Bbookmarkadd:=TBitmap.Create;
   Bclearlayout:=TBitmap.Create;
   BDefaults:=TBitmap.Create;
   Bdelete:=TBitmap.Create;
   Bdvd_supported:=TBitmap.Create;
   Bexpand:=TBitmap.Create;
   Bextractall:=TBitmap.Create;
   Bextractalln:=TBitmap.Create;
   Bextractall_big:=TBitmap.Create;
   Bextractalln_big:=TBitmap.Create;
   Bfd_supported:=TBitmap.Create;
   BFolder:=TBitmap.Create;
   Bgo:=TBitmap.Create;
   Bgopath:=TBitmap.Create;
   Bgoup:=TBitmap.Create;
   Bhd_supported:=TBitmap.Create;
   Binfo:=TBitmap.Create;
   Bkeyfile:=TBitmap.Create;
   Bloadlayout:=TBitmap.Create;
   Blocker:=TBitmap.Create;
   Blocker2:=TBitmap.Create;
   Bmail:=TBitmap.Create;
   Bnav:=TBitmap.Create;
   Bp0:=TBitmap.Create;
   Bpreview:=TBitmap.Create;
   Bram_supported:=TBitmap.Create;
   Brefresh:=TBitmap.Create;
   Bremote_supported:=TBitmap.Create;
   Bremovable_supported:=TBitmap.Create;
   Bresetpath:=TBitmap.Create;
   Broot:=TBitmap.Create;
   Brun:=TBitmap.Create;
   Bsavelayout:=TBitmap.Create;
   Bsearch:=TBitmap.Create;
   Bdesk:=TBitmap.Create;
   Bdesk96:=TBitmap.Create;
   bhomefolder96:=TBitmap.Create;
   Bdownloadfolder96:=TBitmap.Create;
   Bcloudfolder96:=TBitmap.Create;
   Bsystemtools:=TBitmap.Create;
   Btestall:=TBitmap.Create;
   Bstop:=TBitmap.Create;
   Bweb:=TBitmap.Create;
   Bwipe:=TBitmap.Create;
   Btestall_big:=TBitmap.Create;
   Blink:=TBitmap.Create;
   Bdetailsfs:=TBitmap.Create;
   BTool_cut_small:=TBitmap.Create;
   BTool_copy_small:=TBitmap.Create;
   BTool_dup_small:=TBitmap.Create;
   Btool_properties_small:=TBitmap.Create;
   Btool_rename_small:=TBitmap.Create;
   Btool_cut:=TBitmap.Create;
   Btool_copy:=TBitmap.Create;
   Btool_paste:=TBitmap.Create;
   Btool_openw:=TBitmap.Create;
   Btool_properties:=TBitmap.Create;
   Btool_rename:=TBitmap.Create;
   Btool_delete:=TBitmap.Create;
   Btool_dup:=TBitmap.Create;
   BTool_resize:=TBitmap.Create;
   BTool_crop:=TBitmap.Create;
   BTool_rl:=TBitmap.Create;
   BTool_rr:=TBitmap.Create;
   BTool_resize_small:=TBitmap.Create;
   BTool_crop_small:=TBitmap.Create;
   BTool_rl_small:=TBitmap.Create;
   BTool_rr_small:=TBitmap.Create;
   Bdvd_supported96:=TBitmap.Create;
   Bfd_supported96:=TBitmap.Create;
   BFolder96:=TBitmap.Create;
   Bhd_supported96:=TBitmap.Create;
   Bram_supported96:=TBitmap.Create;
   Bremote_supported96:=TBitmap.Create;
   Bremovable_supported96:=TBitmap.Create;
   Btxt96:=TBitmap.Create;
   Bspreadsheet96:=TBitmap.Create;
   Bvideo96:=TBitmap.Create;
   Baudio96:=TBitmap.Create;
   Bimage96:=TBitmap.Create;
   Bpresentation96:=TBitmap.Create;
   Bpdf96:=TBitmap.Create;
   Bsupported96:=TBitmap.Create;
   Bbat96:=TBitmap.Create;
   Bdll96:=TBitmap.Create;
   Bdb96:=TBitmap.Create;
   Bgif96:=TBitmap.Create;
   Bico96:=TBitmap.Create;
   Bvector96:=TBitmap.Create;
   Bjpeg96:=TBitmap.Create;
   BArchiveSupported96:=TBitmap.Create;
   BFileSupported96:=TBitmap.Create;
   BExesupported96:=TBitmap.Create;
   Bunsupported96:=TBitmap.Create;
   Blink96:=TBitmap.Create;
   Bweb96:=TBitmap.Create;
   Bmail96:=TBitmap.Create;
   Bhomefolder:=TBitmap.Create;
   Bdownloadfolder:=TBitmap.Create;
   Bcloudfolder:=TBitmap.Create;
   Barc7z:=TBitmap.Create;
   Barcrar:=TBitmap.Create;
   Barczip:=TBitmap.Create;
   Barcblock:=TBitmap.Create;
   Barcdisk:=TBitmap.Create;
   Barcinstaller:=TBitmap.Create;
   Barc7z96:=TBitmap.Create;
   Barcrar96:=TBitmap.Create;
   Barczip96:=TBitmap.Create;
   Barcblock96:=TBitmap.Create;
   Barcdisk96:=TBitmap.Create;
   Barcinstaller96:=TBitmap.Create;
   getthemepath(thpath);
   Bfm:=TBitmap.Create;
   try Bfm.LoadFromFile(thpath+graphicsfolder+'fm-theme.bmp'); except end;
   Bfm.Transparent:=True;
   ImageTheme.Picture.Bitmap:=Bfm;

   if evalcolor(clWindow)>128 then loadlighticons
   else loaddarkicons;

   if ((theme_name)<>(DEFAULT_THEME)) then
   begin
   try
   getthemedbitmap(Bdetailsf,thpath+graphicsfolder+'16'+directoryseparator+'16-detailsf.png');
   getthemedbitmap(Blistf,thpath+graphicsfolder+'16'+directoryseparator+'16-listf.png');
   getthemedbitmap(Biconsf,thpath+graphicsfolder+'16'+directoryseparator+'16-iconsf.png');
   getthemedbitmap(Bav,thpath+graphicsfolder+'16'+directoryseparator+'16-av.png');
   getthemedbitmap(Bfilter,thpath+graphicsfolder+'16'+directoryseparator+'16-filter.png');
   getthemedbitmap(Bflat,thpath+graphicsfolder+'16'+directoryseparator+'16-flat.png');
   getthemedbitmap(Bcollapse,thpath+graphicsfolder+'16'+directoryseparator+'16-collapse.png');
   getthemedbitmap(bmenu,thpath+graphicsfolder+'16'+directoryseparator+'16-menu.png');
   getthemedbitmap(bseparator,thpath+graphicsfolder+'16'+directoryseparator+'16-separator.png');
   getthemedbitmap(bsettings,thpath+graphicsfolder+'16'+directoryseparator+'16-settings.png');
   getthemedbitmap(Bcloudfolder96,thpath+graphicsfolder+'96'+directoryseparator+'96-cloud.png');
   getthemedbitmap(Bdesk96,thpath+graphicsfolder+'96'+directoryseparator+'96-desktop.png');
   getthemedbitmap(Bdownloadfolder96,thpath+graphicsfolder+'96'+directoryseparator+'96-downloads.png');
   getthemedbitmap(Bhomefolder96,thpath+graphicsfolder+'96'+directoryseparator+'96-home.png');
   getthemedbitmap(BArchiveSupported,thpath+graphicsfolder+'16'+directoryseparator+'16-archive.png');
   getthemedbitmap(Barc7z,thpath+graphicsfolder+'16'+directoryseparator+'16-7z.png');
   getthemedbitmap(Barcrar,thpath+graphicsfolder+'16'+directoryseparator+'16-rar.png');
   getthemedbitmap(Barczip,thpath+graphicsfolder+'16'+directoryseparator+'16-zip.png');
   getthemedbitmap(Barcblock,thpath+graphicsfolder+'16'+directoryseparator+'16-spanned.png');
   getthemedbitmap(Barcdisk,thpath+graphicsfolder+'16'+directoryseparator+'16-diskimage.png');
   getthemedbitmap(Barcinstaller,thpath+graphicsfolder+'16'+directoryseparator+'16-package.png');
   getthemedbitmap(BArchiveSupported96,thpath+graphicsfolder+'96'+directoryseparator+'96-archive.png');
   getthemedbitmap(Barc7z96,thpath+graphicsfolder+'96'+directoryseparator+'96-7z.png');
   getthemedbitmap(Barcrar96,thpath+graphicsfolder+'96'+directoryseparator+'96-rar.png');
   getthemedbitmap(Barczip96,thpath+graphicsfolder+'96'+directoryseparator+'96-zip.png');
   getthemedbitmap(Barcblock96,thpath+graphicsfolder+'96'+directoryseparator+'96-spanned.png');
   getthemedbitmap(Barcdisk96,thpath+graphicsfolder+'96'+directoryseparator+'96-diskimage.png');
   getthemedbitmap(Barcinstaller96,thpath+graphicsfolder+'96'+directoryseparator+'96-package.png');
   except end;//10.4 to 9.3 theme update
   getthemedbitmap(Bhomefolder,thpath+graphicsfolder+'16'+directoryseparator+'16-home.png');
   getthemedbitmap(Bdownloadfolder,thpath+graphicsfolder+'16'+directoryseparator+'16-downloads.png');
   getthemedbitmap(Bcloudfolder,thpath+graphicsfolder+'16'+directoryseparator+'16-cloud.png');
   getthemedbitmap(Bbookmarkadd,thpath+graphicsfolder+'16'+directoryseparator+'16-bookmarks-add.png');
   getthemedbitmap(Bapps,thpath+graphicsfolder+'16'+directoryseparator+'16-run-with.png');
   getthemedbitmap(BArchive,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-add.png');
   getthemedbitmap(Bclearlayout,thpath+graphicsfolder+'16'+directoryseparator+'16-delete-clear.png');
   getthemedbitmap(Bconvert,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-convert.png');
   getthemedbitmap(Bdelete,thpath+graphicsfolder+'16'+directoryseparator+'16-delete.png');
   getthemedbitmap(Bextractall,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-extract.png');
   getthemedbitmap(Bextractalln,thpath+graphicsfolder+'16'+directoryseparator+'16-archive-extract-tonew.png');
   getthemedbitmap(Bloadlayout,thpath+graphicsfolder+'16'+directoryseparator+'16-paste.png');
   getthemedbitmap(Bpreview,thpath+graphicsfolder+'16'+directoryseparator+'16-run-preview.png');
   getthemedbitmap(Brun,thpath+graphicsfolder+'16'+directoryseparator+'16-run.png');
   getthemedbitmap(Bsavelayout,thpath+graphicsfolder+'16'+directoryseparator+'16-save.png');
   getthemedbitmap(Bwipe,thpath+graphicsfolder+'16'+directoryseparator+'16-delete-secure.png');
   getthemedbitmap(Btestall,thpath+graphicsfolder+'16'+directoryseparator+'16-test.png');
   getthemedbitmap(BFolder,thpath+graphicsfolder+'16'+directoryseparator+'16-folder.png');
   getthemedbitmap(Binfo,thpath+graphicsfolder+'16'+directoryseparator+'16-info.png');
   getthemedbitmap(Bnav,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation.png');
   getthemedbitmap(Bkeyfile,thpath+graphicsfolder+'16'+directoryseparator+'16-keyfile.png');
   getthemedbitmap(Blocker,thpath+graphicsfolder+'16'+directoryseparator+'16-password-set.png');
   getthemedbitmap(Blocker2,thpath+graphicsfolder+'16'+directoryseparator+'16-password-notset.png');
   getthemedbitmap(Bback,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-back.png');
   getthemedbitmap(Bexpand,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-flat.png');
   getthemedbitmap(Bgo,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-forward.png');
   getthemedbitmap(Brefresh,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-refresh.png');
   getthemedbitmap(Bsearch,thpath+graphicsfolder+'16'+directoryseparator+'16-search.png');
   getthemedbitmap(Bgopath,thpath+graphicsfolder+'16'+directoryseparator+'16-search-here.png');
   getthemedbitmap(Bresetpath,thpath+graphicsfolder+'16'+directoryseparator+'16-undo.png');
   getthemedbitmap(Bgoup,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-up.png');
   getthemedbitmap(Bp0,thpath+graphicsfolder+'16'+directoryseparator+'16-navigation-refreshing.png');
   getthemedbitmap(Bbookmark,thpath+graphicsfolder+'16'+directoryseparator+'16-bookmarks.png');
   getthemedbitmap(Bdesk,thpath+graphicsfolder+'16'+directoryseparator+'16-desktop.png');
   getthemedbitmap(Bplaceshistory,thpath+graphicsfolder+'16'+directoryseparator+'16-history.png');
   getthemedbitmap(Broot,thpath+graphicsfolder+'16'+directoryseparator+'16-folder-special.png');
   getthemedbitmap(Bsystemtools,thpath+graphicsfolder+'16'+directoryseparator+'16-computer.png');
   getthemedbitmap(BDefaults,thpath+graphicsfolder+'16'+directoryseparator+'16-options.png');
   getthemedbitmap(Bstop,thpath+graphicsfolder+'16'+directoryseparator+'16-stop.png');
   getthemedbitmap(BTool_cut_small,thpath+graphicsfolder+'16'+directoryseparator+'16-cut.png');
   getthemedbitmap(BTool_copy_small,thpath+graphicsfolder+'16'+directoryseparator+'16-copy.png');
   getthemedbitmap(BTool_dup_small,thpath+graphicsfolder+'16'+directoryseparator+'16-find-duplicates.png');
   getthemedbitmap(Btool_properties_small,thpath+graphicsfolder+'16'+directoryseparator+'16-properties.png');
   getthemedbitmap(Btool_rename_small,thpath+graphicsfolder+'16'+directoryseparator+'16-rename.png');
   getthemedbitmap(Btool_resize_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-modify.png');
   getthemedbitmap(Btool_crop_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-crop.png');
   getthemedbitmap(BTool_rl_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-rl.png');
   getthemedbitmap(BTool_rr_small,thpath+graphicsfolder+'16'+directoryseparator+'16-picture-rr.png');
   getthemedbitmap(Bdll,thpath+graphicsfolder+'16'+directoryseparator+'16-file-library.png');
   getthemedbitmap(BExeSupported,thpath+graphicsfolder+'16'+directoryseparator+'16-file-executable.png');
   getthemedbitmap(Bbat,thpath+graphicsfolder+'16'+directoryseparator+'16-file-script.png');
   getthemedbitmap(Bdetailsfs,thpath+graphicsfolder+'32'+directoryseparator+'32-folder.png');
   getthemedbitmap(BArchive_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-add.png');
   getthemedbitmap(Bconvert_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-convert.png');
   getthemedbitmap(Bextractall_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-extract.png');
   getthemedbitmap(Bextractalln_big,thpath+graphicsfolder+'32'+directoryseparator+'32-archive-extract-tonew.png');
   getthemedbitmap(Btestall_big,thpath+graphicsfolder+'32'+directoryseparator+'32-test.png');
   getthemedbitmap(Btool_cut,thpath+graphicsfolder+'32'+directoryseparator+'32-cut.png');
   getthemedbitmap(Btool_copy,thpath+graphicsfolder+'32'+directoryseparator+'32-copy.png');
   getthemedbitmap(Btool_paste,thpath+graphicsfolder+'32'+directoryseparator+'32-paste.png');
   getthemedbitmap(Btool_openw,thpath+graphicsfolder+'32'+directoryseparator+'32-run-with.png');
   getthemedbitmap(Btool_properties,thpath+graphicsfolder+'32'+directoryseparator+'32-properties.png');
   getthemedbitmap(Btool_rename,thpath+graphicsfolder+'32'+directoryseparator+'32-rename.png');
   getthemedbitmap(Btool_delete,thpath+graphicsfolder+'32'+directoryseparator+'32-delete-secure.png');
   getthemedbitmap(Btool_dup,thpath+graphicsfolder+'32'+directoryseparator+'32-find-duplicates.png');
   getthemedbitmap(Btool_resize,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-modify.png');
   getthemedbitmap(Btool_crop,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-crop.png');
   getthemedbitmap(BTool_rl,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-rl.png');
   getthemedbitmap(BTool_rr,thpath+graphicsfolder+'32'+directoryseparator+'32-picture-rr.png');
   getthemedbitmap(BFolder96,thpath+graphicsfolder+'96'+directoryseparator+'96-folder.png');
   getthemedbitmap(Bdll96,thpath+graphicsfolder+'96'+directoryseparator+'96-file-library.png');
   getthemedbitmap(BExeSupported96,thpath+graphicsfolder+'96'+directoryseparator+'96-file-executable.png');
   getthemedbitmap(Bbat96,thpath+graphicsfolder+'96'+directoryseparator+'96-file-script.png');
   end;
   setpbitmap(Bav,i16res);
   setpbitmap(Bfilter,i16res);
   setpbitmap(Bflat,i16res);
   setpbitmap(Bcollapse,i16res);
   mAdmin.Bitmap:=Bav;
   ctrlext.Glyph:=Bflat;
   ctrlarc.Glyph:=Bflat;
   Imageopenadvf.Width:=i16res;
   Imageopenadvf.Height:=i16res;
   Imageopenadvf.Picture.Bitmap:=Bfilter;
   ImageExtractAdvf.Width:=i16res;
   ImageExtractAdvf.Height:=i16res;
   ImageExtractAdvf.Picture.Bitmap:=Bfilter;
   ImageAddAdvf.Width:=i16res;
   ImageAddAdvf.Height:=i16res;
   ImageAddAdvf.Picture.Bitmap:=Bfilter;
   imagesp.Width:=i16res;
   imagesp.Height:=i16res;
   imagesp.Picture.Bitmap:=Bcollapse;
   imagesp1.Width:=i16res;
   imagesp1.Height:=i16res;
   imagesp1.Picture.Bitmap:=Bcollapse;
   setpbitmap(Bdetailsf,i16res);
   setpbitmap(Blistf,i16res);
   setpbitmap(Biconsf,i16res);
   setpbitmap(bmenu,i16res);
   setpbitmap(bseparator,i16res);
   setpbitmap(bsettings,i16res);
   setpbitmap(Bbookmarkadd,i16res);
   setpbitmap(Bapps,i16res);
   setpbitmap(BArchive,i16res);
   setpbitmap(Bclearlayout,i16res);
   setpbitmap(Bconvert,i16res);
   setpbitmap(Bdelete,i16res);
   setpbitmap(Bextractall,i16res);
   setpbitmap(Bextractalln,i16res);
   setpbitmap(Bloadlayout,i16res);
   setpbitmap(Bpreview,i16res);
   setpbitmap(Brun,i16res);
   setpbitmap(Bsavelayout,i16res);
   setpbitmap(Bwipe,i16res);
   setpbitmap(Btestall,i16res);
   setpbitmap(Bdvd_supported,i16res);
   setpbitmap(Bfd_supported,i16res);
   setpbitmap(Bhd_supported,i16res);
   setpbitmap(Bram_supported,i16res);
   setpbitmap(Bremote_supported,i16res);
   setpbitmap(Bremovable_supported,i16res);
   setpbitmap(BArchiveSupported,i16res);
   setpbitmap(Baudio,i16res);
   setpbitmap(Bdll,i16res);
   setpbitmap(Bdb,i16res);
   setpbitmap(BFileSupported,i16res);
   setpbitmap(BExeSupported,i16res);
   setpbitmap(Bimage,i16res);
   setpbitmap(Bico,i16res);
   setpbitmap(Bjpeg,i16res);
   setpbitmap(Bgif,i16res);
   setpbitmap(Bvector,i16res);
   setpbitmap(Blink,i16res);
   setpbitmap(Bmail,i16res);
   setpbitmap(Bpdf,i16res);
   setpbitmap(Bpresentation,i16res);
   setpbitmap(Bbat,i16res);
   setpbitmap(Bspreadsheet,i16res);
   setpbitmap(Bsupported,i16res);
   setpbitmap(Btxt,i16res);
   setpbitmap(BUnsupported,i16res);
   setpbitmap(Bvideo,i16res);
   setpbitmap(Bweb,i16res);
   setpbitmap(BFolder,i16res);
   setpbitmap(Binfo,i16res);
   setpbitmap(Bnav,i16res);
   setpbitmap(Bkeyfile,i16res);
   setpbitmap(Blocker,i16res);
   setpbitmap(Blocker2,i16res);
   setpbitmap(Bback,i16res);
   setpbitmap(Bexpand,i16res);
   setpbitmap(Bgo,i16res);
   setpbitmap(Brefresh,i16res);
   setpbitmap(Bsearch,i16res);
   setpbitmap(Bgopath,i16res);
   setpbitmap(Bresetpath,i16res);
   setpbitmap(Bgoup,i16res);
   setpbitmap(Bp0,i16res);
   setpbitmap(Bbookmark,i16res);
   setpbitmap(Bdesk,i16res);
   setpbitmap(Bplaceshistory,i16res);
   setpbitmap(Broot,i16res);
   setpbitmap(Bsystemtools,i16res);
   setpbitmap(BDefaults,i16res);
   setpbitmap(Bstop,i16res);
   setpbitmap(BTool_cut_small,i16res);
   setpbitmap(BTool_copy_small,i16res);
   setpbitmap(BTool_dup_small,i16res);
   setpbitmap(Btool_properties_small,i16res);
   setpbitmap(Btool_rename_small,i16res);
   setpbitmap(Btool_resize_small,i16res);
   setpbitmap(Btool_crop_small,i16res);
   setpbitmap(BTool_rl_small,i16res);
   setpbitmap(BTool_rr_small,i16res);
   setpbitmap(Bhomefolder,i16res);
   setpbitmap(Bdownloadfolder,i16res);
   setpbitmap(Bcloudfolder,i16res);
   setpbitmap(Barc7z,i16res);
   setpbitmap(Barcrar,i16res);
   setpbitmap(Barczip,i16res);
   setpbitmap(Barcblock,i16res);
   setpbitmap(Barcdisk,i16res);
   setpbitmap(Barcinstaller,i16res);
   setpbitmap(Bdvd_supported96,i96res);
   setpbitmap(Bfd_supported96,i96res);
   setpbitmap(Bhd_supported96,i96res);
   setpbitmap(Bram_supported96,i96res);
   setpbitmap(Bremote_supported96,i96res);
   setpbitmap(Bremovable_supported96,i96res);
   setpbitmap(BArchiveSupported96,i96res);
   setpbitmap(Baudio96,i96res);
   setpbitmap(Bdll96,i96res);
   setpbitmap(Bdb96,i96res);
   setpbitmap(BFileSupported96,i96res);
   setpbitmap(BExeSupported96,i96res);
   setpbitmap(Bimage96,i96res);
   setpbitmap(Bico96,i96res);
   setpbitmap(Bjpeg96,i96res);
   setpbitmap(Bgif96,i96res);
   setpbitmap(Bvector96,i96res);
   setpbitmap(Blink96,i96res);
   setpbitmap(Bmail96,i96res);
   setpbitmap(Bpdf96,i96res);
   setpbitmap(Bpresentation96,i96res);
   setpbitmap(Bbat96,i96res);
   setpbitmap(Bspreadsheet96,i96res);
   setpbitmap(Bsupported96,i96res);
   setpbitmap(Btxt96,i96res);
   setpbitmap(BUnsupported96,i96res);
   setpbitmap(Bvideo96,i96res);
   setpbitmap(Bweb96,i96res);
   setpbitmap(BFolder96,i96res);
   setpbitmap(Barc7z96,i96res);
   setpbitmap(Barcrar96,i96res);
   setpbitmap(Barczip96,i96res);
   setpbitmap(Barcblock96,i96res);
   setpbitmap(Barcdisk96,i96res);
   setpbitmap(Barcinstaller96,i96res);
   setpbitmap(Bcloudfolder96,i96res);
   setpbitmap(Bdesk96,i96res);
   setpbitmap(Bdownloadfolder96,i96res);
   setpbitmap(Bhomefolder96,i96res);
   Barc:=TBitmap.Create;
   Barc.Assign(Barchive_big);
   setpbitmap(Barc,i96res);
   bext:=TBitmap.Create;
   bext.Assign(Bextractall_big);
   setpbitmap(bext,i96res);
   bextf:=TBitmap.Create;
   bextf.Assign(Bextractalln_big);
   setpbitmap(bextf,i96res);
   btest:=TBitmap.Create;
   btest.Assign(Btool_properties);
   setpbitmap(btest,i96res);
   blist:=TBitmap.Create;
   blist.Assign(Btool_copy);
   setpbitmap(blist,i96res);

   setpbitmap(Bdetailsfs,i32res);
   setpbitmap(BArchive_big,i32res);
   setpbitmap(Bconvert_big,i32res);
   setpbitmap(Bextractall_big,i32res);
   setpbitmap(Bextractalln_big,i32res);
   setpbitmap(Btestall_big,i32res);
   setpbitmap(Btool_cut,i32res);
   setpbitmap(Btool_copy,i32res);
   setpbitmap(Btool_paste,i32res);
   setpbitmap(Btool_openw,i32res);
   setpbitmap(Btool_properties,i32res);
   setpbitmap(Btool_rename,i32res);
   setpbitmap(Btool_delete,i32res);
   setpbitmap(Btool_dup,i32res);
   setpbitmap(Btool_resize,i32res);
   setpbitmap(Btool_crop,i32res);
   setpbitmap(BTool_rl,i32res);
   setpbitmap(BTool_rr,i32res);

   {//possible implementation, monochrome folder icons
   BFolder.Canvas.Brush.Color:=clGreen;
   BFolder.Canvas.FloodFill(BFolder.Width div 2,BFolder.Height div 2,clWindow,fsborder);
   BFolder96.Canvas.Brush.Color:=clGreen;
   BFolder96.Canvas.FloodFill(BFolder96.Width div 2,BFolder96.Height div 2,clWindow,fsborder);}

   for i:=1 to 26 do devicon[i]:=Bunsupported;//show "unsupported" icon if the bookmarked unit is not mounted
   pmstyle1.Bitmap:=Bdetailsf;
   pmstyle3.Bitmap:=Blistf;
   pmstyle5.Bitmap:=Biconsf;
   mlang.Bitmap:=Binfo;
   mDefaults.Bitmap:=BDefaults;
   msettings.Bitmap:=BDefaults;
   pmthemes.Bitmap:=BDefaults;
   ImageAddress.Width:=i16res;
   ImageAddress.Height:=i16res;
   ImageAddress.Picture.Bitmap:=Bsystemtools;
   ImOpt1.Width:=i16res;
   ImOpt1.Height:=i16res;
   ImOpt1.Transparent:=true;
   ImOpt1.Picture.Bitmap:=BDefaults;
   ImOpt2.Width:=i16res;
   ImOpt2.Height:=i16res;
   ImOpt2.Transparent:=true;
   ImOpt2.Picture.Bitmap:=Bexpand;
   ImOpt3.Width:=i16res;
   ImOpt3.Height:=i16res;
   ImOpt3.Transparent:=true;
   ImOpt3.Picture.Bitmap:=BArchiveSupported;
   ImOpt4.Width:=i16res;
   ImOpt4.Height:=i16res;
   ImOpt4.Transparent:=true;
   ImOpt4.Picture.Bitmap:=BFolder;
   ImOpt5.Width:=i16res;
   ImOpt5.Height:=i16res;
   ImOpt5.Transparent:=true;
   ImOpt5.Picture.Bitmap:=Bapps;
   ImOpt6.Width:=i16res;
   ImOpt6.Height:=i16res;
   ImOpt6.Transparent:=true;
   ImOpt6.Picture.Bitmap:=Bimage;
   ImOpt7.Width:=i16res;
   ImOpt7.Height:=i16res;
   ImOpt7.Transparent:=true;
   ImOpt7.Picture.Bitmap:=Bsearch;
   ImOpt8.Width:=i16res;
   ImOpt8.Height:=i16res;
   ImOpt8.Transparent:=true;
   ImOpt8.Picture.Bitmap:=Binfo;
   MenuItemOpen_root.Bitmap:=Bsystemtools;
   po_systemtools.Bitmap:=Bsystemtools;
   po_linsystemtools.Bitmap:=Bsystemtools;
   MenuItemopendesktop.Bitmap:=Bdesk;
   MenuItemopendownloads.Bitmap:=Bdownloadfolder;
   MenuItemopendocuments.Bitmap:=BFileSupported;
   ButtonOptReset.Glyph:=Bresetpath;
   po_convertarchive.Bitmap:=Bconvert;
   csbroot.Glyph:=Bsystemtools;
   csbhome.Glyph:=bhomefolder;
   csbdesk.Glyph:=bdesk;
   csbdownloads.Glyph:=Bdownloadfolder;
   csbdoc.Glyph:=bfilesupported;
   csbmusic.Glyph:=baudio;
   csbpic.Glyph:=Bimage;
   csbvid.Glyph:=Bvideo;
   ctrlback.Glyph:=Bback;
   ctrlfwd.Glyph:=Bgo;
   ctrlup.Glyph:=Bgoup;
   ctrlwarning.Glyph:=Bwarningsmall;
   refreshstatus:=0;
   ImageListSearch.Picture.Bitmap:=Bsearch;
   ImageListResetSearch.Picture.Bitmap:=Bdelete;
   pmireset.Bitmap:=Bdelete;
   msetpw.Bitmap:=Blocker2;
   mpm.Bitmap:=Bsavelayout;
   mscripts.Bitmap:=bbat;
   BtnPassword.Glyph:=Blocker2;
   BtnPasswordArchive.Glyph:=Blocker2;
   BtnPasswordExtract.Glyph:=Blocker2;
   mkeyfile.Bitmap:=Bkeyfile;
   mverifyself.Bitmap:=BExesupported;
   iConsoleCreateImport.Width:=i16res;
   iConsoleCreateImport.Height:=i16res;
   iConsoleCreateImport.Picture.Bitmap:=Bresetpath;
   iConsoleCreateImportExt.Width:=i16res;
   iConsoleCreateImportExt.Height:=i16res;
   iConsoleCreateImportExt.Picture.Bitmap:=Bresetpath;
   ImageInfoCustomExt.Width:=i16res;
   ImageInfoCustomExt.Height:=i16res;
   ImageInfoCustomExt.Picture.Bitmap:=Binfo;
   ImageInfoCustomExt.Transparent:=true;
   ImageInfoConsole.Width:=i16res;
   ImageInfoConsole.Height:=i16res;
   ImageInfoConsole.Picture.Bitmap:=Binfo;
   ImageInfoConsole.Transparent:=true;
   ImageInfoConsoleExt.Width:=i16res;
   ImageInfoConsoleExt.Height:=i16res;
   ImageInfoConsoleExt.Picture.Bitmap:=Binfo;
   ImageInfoConsoleExt.Transparent:=true;
   ImageInfoSchedAdd.Width:=i16res;
   ImageInfoSchedAdd.Height:=i16res;
   ImageInfoSchedAdd.Picture.Bitmap:=Binfo;
   ImageInfoSchedAdd.Transparent:=true;
   ImageInfoSchedExt.Width:=i16res;
   ImageInfoSchedExt.Height:=i16res;
   ImageInfoSchedExt.Picture.Bitmap:=Binfo;
   ImageInfoSchedExt.Transparent:=true;
   ImageInfoBinaries.Width:=i16res;
   ImageInfoBinaries.Height:=i16res;
   ImageInfoBinaries.Picture.Bitmap:=Binfo;
   ImageInfoBinaries.Transparent:=true;
   ImageInfoEncoding.Width:=i16res;
   ImageInfoEncoding.Height:=i16res;
   ImageInfoEncoding.Picture.Bitmap:=Binfo;
   ImageInfoEncoding.Transparent:=true;
   ImageSplit.Width:=i16res;
   ImageSplit.Height:=i16res;
   ImageSplit.Transparent:=true;
   mBookmarks.Bitmap:=BBookmark;
   smBookmarks1.Bitmap:=BBookmark;
   smBookmarksa1.Bitmap:=BBookmark;
   MenuItemOpen_pc.Bitmap:=Bsystemtools;
   MenuItemArchive_pc.Bitmap:=Bsystemtools;
   smfs1.Bitmap:=Broot;
   smfsa1.Bitmap:=Broot;
   pmJumppubhome.Bitmap:=bfolder;
   MenuItemArchive_pubhome.Bitmap:=bfolder;
   MenuItemOpen_pubhome.Bitmap:=bfolder;
   MenuItemArchive_home1.Bitmap:=bhomefolder;
   MenuItemArchive_documents1.Bitmap:=bfilesupported;
   MenuItemArchive_downloads.Bitmap:=Bdownloadfolder;
   MenuItemArchive_music.Bitmap:=baudio;
   MenuItemArchive_pictures.Bitmap:=bimage;
   MenuItemArchive_videos.Bitmap:=bvideo;
   MenuItemArchive_pubdoc.Bitmap:=bfolder;
   MenuItemOpenhome.Bitmap:=Bhomefolder;
   MenuItemOpen_home1.Bitmap:=bhomefolder;
   pmquickhome.Bitmap:=Bhomefolder;
   pmquickdesk.Bitmap:=Bdesk;
   pmquickdownloads.Bitmap:=Bdownloadfolder;
   MenuItemOpen_documents1.Bitmap:=bfilesupported;
   MenuItemOpen_downloads1.Bitmap:=Bdownloadfolder;
   MenuItemOpen_music.Bitmap:=baudio;
   MenuItemOpen_pictures.Bitmap:=bimage;
   MenuItemOpen_videos.Bitmap:=bvideo;
   MenuItemOpen_pubdoc.Bitmap:=bfolder;
   pmjump3.Bitmap:=Bhomefolder;
   pmjumpdocuments.Bitmap:=BFileSupported;
   pmjumppubdoc.Bitmap:=bfolder;
   pmjumprecent.Bitmap:=bfolder;
   pmjumpsearches.Bitmap:=bfolder;
   pmjumplibraries.Bitmap:=bfolder;
   pmjumpdownloads.Bitmap:=Bdownloadfolder;
   pmjumpmusic.Bitmap:=baudio;
   pmjumppictures.Bitmap:=bimage;
   pmjumpvideos.Bitmap:=bvideo;
   pmrecycle.Bitmap:=Bclearlayout;
   po_recycle.Bitmap:=Bclearlayout;
   pmbookmarks.Bitmap:=BBookmarkadd;
   mb0.Bitmap:=BBookmarkadd;
   mb24.Bitmap:=BBookmark;
   pmbcaddbookmark.Bitmap:=BBookmarkadd;
   pmbcorganizebookmarks.Bitmap:=BBookmark;
   MenuItemOpen_organizebookmarks.Bitmap:=BBookmark;
   pmorganizebookmarks.Bitmap:=BBookmark;
   MenuItemBookmarks.Bitmap:=BBookmarkadd;
   MenuItemOpen_addtobookmarks.Bitmap:=BBookmarkadd;
   MenuItemHistoryBook.Bitmap:=Bbookmarkadd;
   MenuItemOpen_back.Bitmap:=Bback;
   MenuItemOpen_ExtractHere.Bitmap:=Bextractall;
   MenuItemPW.Bitmap:=Blocker2;
   mjob.Bitmap:=bbat;
   po_setpw.Bitmap:=Blocker2;
   menupw.Bitmap:=Blocker2;
   pmqesetpw.Bitmap:=Blocker2;
   imageflat.Glyph:=bsettings;
   BtnStyle.Glyph:=bsettings;
   imageflatadd.Glyph:=Barchive;
   imageflatconvert.Glyph:=Bconvert;
   imageflatext.Glyph:=Bextractall;
   imageflatdup.Glyph:=BTool_dup_small;
   imageflatfolder.Glyph:=BFolder;
   imageflatren.Glyph:=Btool_rename_small;
   ImageFlattransform.Glyph:=Btool_resize_small;
   ImageFlatcrop.Glyph:=Btool_crop_small;
   ImageFlattestmore.Glyph:=bmenu;
   ButtonPropertiesActions.Glyph:=bmenu;
   ButtonExtractActions.Glyph:=bmenu;
   ButtonConvertActions.Glyph:=bmenu;
   ButtonAddActions.Glyph:=bmenu;
   ButtonTestActions.Glyph:=bmenu;
   Buttoncmto.Glyph:=bmenu;
   Buttonopenactions.Glyph:=bmenu;
   Buttonfmactions.Glyph:=bmenu;
   Buttonfmactions1.Glyph:=bmenu;
   ButtonImg6.Glyph:=bmenu;
   ButtonImgR.Glyph:=bmenu;
   ButtonImgRes.Glyph:=bmenu;
   Imagelistroot.Picture.Bitmap:=bmenu;
   ButtonOutAdd.Glyph:=bmenu;
   ButtonOutUpdate.Glyph:=bmenu;
   ButtonOpenCustom.Glyph:=bmenu;
   SpeedButtonAdd.Glyph:=bmenu;
   ButtonOutExtract.Glyph:=bmenu;
   ButtonCustomExt.Glyph:=bmenu;
   ImageAddress0.Picture.Bitmap:=bseparator;
   ImageAddress1.Picture.Bitmap:=bseparator;
   ImageAddress2.Picture.Bitmap:=bseparator;
   ImageAddress3.Picture.Bitmap:=bseparator;
   ImageAddress4.Picture.Bitmap:=bseparator;
   ImageAddress5.Picture.Bitmap:=bseparator;
   ImageAddress6.Picture.Bitmap:=bseparator;
   ImageAddress7.Picture.Bitmap:=bseparator;
   ImageAdArchive0.Picture.Bitmap:=bseparator;
   ImageAdArchive1.Picture.Bitmap:=bseparator;
   ImageAdArchive2.Picture.Bitmap:=bseparator;
   ImageAdArchive3.Picture.Bitmap:=bseparator;
   MenuItemOpen_Flat.Bitmap:=Bexpand;
   MenuItemOpen_fwd.Bitmap:=Bgo;
   MenuItemOpen_refresh.Bitmap:=Brefresh;
   MenuItemOpen_test.Bitmap:=Btestall;
   MenuItemOpen_up.Bitmap:=Bgoup;
   mf3.Bitmap:=Bsearch;
   mf4up.Bitmap:=Bgoup;
   mback.Bitmap:=Bback;
   mFlat.Bitmap:=Bexpand;
   pmFlat.Bitmap:=Bexpand;
   po_flat.Bitmap:=Bexpand;
   mpeahelpoffline.Bitmap:=BPdf;
   mRefresh.Bitmap:=Brefresh;
   MenuItemContextRefresh.Bitmap:=Brefresh;
   pmhrefresh.Bitmap:=Brefresh;
   pmAddFile.Bitmap:=Bunsupported;
   pmAddFolder.Bitmap:=Bfolder;
   pmSearchAdd.Bitmap:=Bsearch;
   po_addtoarchive.Bitmap:=BArchive;
   po_delete.Bitmap:=Bdelete;
   pmquickdelete.Bitmap:=Bdelete;
   po_zerofile.Bitmap:=Bwipe;
   pmzerofile.Bitmap:=Bwipe;
   po_exthere.Bitmap:=Bextractall;
   pmqeto.Bitmap:=Bextractall;
   MenuItemExtAllTo.Bitmap:=Bextractall;
   po_securedelete.Bitmap:=Bstop;
   pmsecuredelete.Bitmap:=Bstop;
   pmjump1.Bitmap:=Bsystemtools;
   pmqjmore.Bitmap:=bfolder;
   pmjump2.Bitmap:=Bdesk;
   pmqjdropbox.Bitmap:=Bcloudfolder;
   pmqjmyboxfiles.Bitmap:=Bcloudfolder;
   pmqjgoogledrive.Bitmap:=Bcloudfolder;
   pmqjonedrive.Bitmap:=Bcloudfolder;
   pmqjskydrive.Bitmap:=Bcloudfolder;
   pmqjubuntuone.Bitmap:=Bcloudfolder;
   MenuItemOpen_dropbox.Bitmap:=Bcloudfolder;
   MenuItemOpen_myboxfiles.Bitmap:=Bcloudfolder;
   MenuItemOpen_googledrive.Bitmap:=Bcloudfolder;
   MenuItemOpen_onedrive.Bitmap:=Bcloudfolder;
   MenuItemOpen_skydrive.Bitmap:=Bcloudfolder;
   MenuItemOpen_ubuntuone.Bitmap:=Bcloudfolder;
   MenuItemArchive_dropbox.Bitmap:=Bcloudfolder;
   MenuItemArchive_myboxfiles.Bitmap:=Bcloudfolder;
   MenuItemArchive_googledrive.Bitmap:=Bcloudfolder;
   MenuItemArchive_onedrive.Bitmap:=Bcloudfolder;
   MenuItemArchive_skydrive.Bitmap:=Bcloudfolder;
   MenuItemArchive_ubuntuone.Bitmap:=Bcloudfolder;
   MenuItemOpen_desktop1.Bitmap:=Bdesk;
   mpathdesk1.Bitmap:=Bdesk;
   mhistory.Bitmap:=Bplaceshistory;
   smhistorya1.Bitmap:=Bplaceshistory;
   smhistory1.Bitmap:=Bplaceshistory;
   po_test.Bitmap:=Btestall;
   pmtabsclose.Bitmap:=Bdelete;
   pmtabsbookmarkadd.Bitmap:=BBookmarkadd;
   pmtabsbookmarkorg.Bitmap:=BBookmark;
   ThemeReset.Width:=i16res;
   ThemeReset.Height:=i16res;
   ThemeReset.Picture.Bitmap:=Bresetpath;
   ThemeReset.Transparent:=true;
   Imagelistsearch.Transparent:=true;
   ImageListResetSearch.Transparent:=true;
   loadimglisticons;
   LabelThemeLoaded.Caption:=txt_icons_found;
   ComboBoxTheme.hint:=thpath+extractfilepath(theme_path);
   LabelTheme.hint:=txt_3_5_managecustomthemes;
   LabelTheme1.hint:=thpath+extractfilepath(theme_path);
   imgloaded:=true;
   imgloading:=false;
   except
   LabelThemeLoaded.Caption:=txt_icons_not_found;
   end;
   end;
end;

procedure clearicons;
begin
clearimagelist(il16);
clearimagelist(il96);
end;

procedure rebuildicons(doicons:boolean);
//if the parameter is true, clear and reload small or large icons accordingly to the view style of ListView
//in this way, new icons can be appended at runtime after base file type icons each time a new folder/view
//is loaded, i.e. to represent image's thumbnails
begin
if doicons=false then exit;
case browsertype of
   2:
   begin
   clearimagelist(il96);
   loadlargeicons(largeiconsize);
   end;
   1:
   begin
   if smalliconsize=16 then clearimagelist(il16)
   else clearimagelist(il96);
   loadsmallicons(smalliconsize);
   end;
   0:
   begin
   if smalliconsize=16 then clearimagelist(il16)
   else clearimagelist(il96);
   loadsmallicons(smalliconsize);
   end;
   end;
end;

procedure drawcellicon(sg:tstringgrid; arow:integer);
var
   fullname,fulltype:ansistring;
   l,t:integer;
begin
l:=sg.CellRect(0,arow).Left+intcellhw;
t:=sg.CellRect(0,arow).Top+intcellhw;
fullname:=sg.Cells[8,arow];
fulltype:=sg.Cells[2,arow];
if sg.Cells[1,arow]<>'' then
   sg.Canvas.Draw(l,t,pgetbitmap(geticon(fullname,fulltype,false)));
end;

procedure drawbarcellicon(sg:tstringgrid; arow:integer);
var
   s,s1,fulltype:ansistring;
   l,t,i,cellfilter:integer;
begin
if sg.RowCount<2 then exit;
if arow>=sg.rowcount then exit;
if sg=FormPeach.StringGridBookmarks then cellfilter:=4
else cellfilter:=3;
l:=sg.CellRect(0,arow).Left+intcellhw;
t:=sg.CellRect(0,arow).Top+intcellhw;
if sg=FormPeach.stringgridrecent then
   s:=sg.Cells[1,arow]
else
   s:=sg.Cells[2,arow];
if (s = txt_mypc) or (s = 'Computer''s root') then
   begin
   sg.Canvas.Draw(l,t,Bsystemtools);
   exit;
   end;
if sg<>FormPeach.stringgridrecent then
   begin
   if sg.Cells[1,arow] = txt_list_found then
      begin
      sg.Canvas.Draw(l,t,Bsearch);
      exit;
      end;
   if sg.Cells[1,arow] = txt_list_flat then
      begin
      sg.Canvas.Draw(l,t,Bexpand);
      exit;
      end;
   s1:=sg.Cells[cellfilter,arow];
   if s1<>'' then
      s1:=s1[length(s1)];
   if s1<>'*' then
      begin
      sg.Canvas.Draw(l,t,Bgopath);
      exit;
      end;
   end;
if (s = desktop_path) or (s=txt_desktop) then
   begin
   sg.Canvas.Draw(l,t,Bdesk);
   exit;
   end;
if (s = home_path) or (s=txt_2_9_home) then
   begin
   sg.Canvas.Draw(l,t,Bhomefolder);
   exit;
   end;
if (s = usr_documents) or (s=txt_2_4_documents) then
   begin
   sg.Canvas.Draw(l,t,Bfilesupported);
   exit;
   end;
if (s = usr_downloads) or (s=txt_3_1_downloads) then
   begin
   sg.Canvas.Draw(l,t,Bdownloadfolder);
   exit;
   end;
if (s = usr_music) or (s=txt_5_0_music) then
   begin
   sg.Canvas.Draw(l,t,Baudio);
   exit;
   end;
if (s = usr_pictures) or (s=txt_5_0_pictures) then
   begin
   sg.Canvas.Draw(l,t,Bimage);
   exit;
   end;
if (s = usr_videos) or (s=txt_5_0_videos) then
   begin
   sg.Canvas.Draw(l,t,Bvideo);
   exit;
   end;
if (s = shared_dropbox) or (s = shared_myboxfiles) or (s = shared_googledrive)
   or (s = shared_onedrive) or (s = shared_skydrive) or (s = shared_ubuntuone)then
   begin
   sg.Canvas.Draw(l,t,Bcloudfolder);
   exit;
   end;
{$IFDEF MSWINDOWS}
if length(s) = 3 then
   begin
   i:=ord(s[1])-64;
   sg.Canvas.Draw(l,t,devicon[i]);
   exit;
   end;
{$ENDIF}
if s<>'' then
   if s[length(s)]=directoryseparator then fulltype:=txt_list_isfolder
else fulltype:=extractfileext(s);
if sg.Cells[1,arow]<>'' then
   sg.Canvas.Draw(l,t,pgetbitmap(geticon(s,fulltype,false)));
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI FORM SET items values

///////////////////////////////////////////////////////////////////////////////}

procedure positem(var scro:TScrollBox; toppos:integer);
begin
if toppos<0 then toppos:=0;
if toppos>scro.VertScrollBar.Range then toppos:=0;
scro.VertScrollBar.Position:=toppos;
end;

procedure set_adveditcl(i:integer);
begin
case i of
   1: FormPeach.Labelcbsampleadvanced.caption:=advedit1before+stringdelim('%f')+advedit1after;
   2: FormPeach.Labelcbsampleadvanced.caption:=advedit2before+stringdelim('%f')+advedit2after;
   3: FormPeach.Labelcbsampleadvanced.caption:=advedit3before+stringdelim('%f')+advedit3after;
   4: FormPeach.Labelcbsampleadvanced.caption:=advedit4before+stringdelim('%f')+advedit4after;
   5: FormPeach.Labelcbsampleadvanced.caption:=advedit5before+stringdelim('%f')+advedit5after;
   6: FormPeach.Labelcbsampleadvanced.caption:=advedit6before+stringdelim('%f')+advedit6after;
   7: FormPeach.Labelcbsampleadvanced.caption:=advedit7before+stringdelim('%f')+advedit7after;
   8: FormPeach.Labelcbsampleadvanced.caption:=advedit8before+stringdelim('%f')+advedit8after;
   end;
end;

procedure setdescription_advcustedit;
var
   s:ansistring;
   sg:TStringGrid;
begin
sg:=FormPeach.StringGridCustEditAdv;
s:=sg.Cells[1,sg.Row];
if InputQuery(txt_description, '', s) then
   begin
   sg.Cells[1,sg.Row]:=s;
   sg.AutoSizeColumns;
   end;
set_adveditcl(sg.Row);
end;

procedure setdescription_custedit;
var
   s:ansistring;
begin
s:=FormPeach.StringGridCustedit.Cells[1,FormPeach.StringGridCustedit.Row];
if InputQuery(txt_description, '', s) then
   begin
   FormPeach.StringGridCustedit.Cells[1,FormPeach.StringGridCustedit.Row]:=s;
   FormPeach.StringGridCustedit.AutoSizeColumns;
   end;
end;

procedure editstring1_advcustedit;
var
   s:ansistring;
begin
s:=FormPeach.StringGridCustEditAdv.Cells[2,FormPeach.StringGridCustEditAdv.Row];
if InputQuery(txt_2_5_strbefore, '', s) then
   begin
   FormPeach.StringGridCustEditAdv.Cells[2,FormPeach.StringGridCustEditAdv.Row]:=s;
   FormPeach.StringGridCustEditAdv.AutoSizeColumns;
   end;
set_adveditcl(FormPeach.StringGridCustEditAdv.Row);
end;

procedure editstring2_advcustedit;
var
   s:ansistring;
begin
s:=FormPeach.StringGridCustEditAdv.Cells[3,FormPeach.StringGridCustEditAdv.Row];
if InputQuery(txt_2_5_strafter, '', s) then
   begin
   FormPeach.StringGridCustEditAdv.Cells[3,FormPeach.StringGridCustEditAdv.Row]:=s;
   FormPeach.StringGridCustEditAdv.AutoSizeColumns;
   end;
set_adveditcl(FormPeach.StringGridCustEditAdv.Row);
end;

procedure editstring3_advcustedit;
var
   s:ansistring;
begin
s:=FormPeach.StringGridCustEditAdv.Cells[4,FormPeach.StringGridCustEditAdv.Row];
if InputQuery(txt_3_3_stralt, '', s) then
   begin
   FormPeach.StringGridCustEditAdv.Cells[4,FormPeach.StringGridCustEditAdv.Row]:=s;
   FormPeach.StringGridCustEditAdv.AutoSizeColumns;
   end;
set_adveditcl(FormPeach.StringGridCustEditAdv.Row);
end;

procedure editapp_custedit;
var
   s:ansistring;
begin
s:=FormPeach.StringGridCustedit.Cells[2,FormPeach.StringGridCustedit.Row];
if InputQuery(txt_edit, '', s) then
   begin
   FormPeach.StringGridCustedit.Cells[2,FormPeach.StringGridCustedit.Row]:=s;
   FormPeach.StringGridCustedit.AutoSizeColumns;
   end;
end;

function translatespecialfolders(var s: ansistring):boolean;
begin
result:=false;
if s = 'Computer''s root' then begin s:=txt_mypc; result:=true; end;
if s = desktop_path then begin s:=txt_desktop; result:=true; end;
if s = home_path then begin s:=txt_2_9_home; result:=true; end;
if s = usr_documents then begin s:=txt_2_4_documents; result:=true; end;
if s = usr_downloads then begin s:=txt_3_1_downloads; result:=true; end;
if s = usr_music then begin s:=txt_5_0_music; result:=true; end;
if s = usr_pictures then begin s:=txt_5_0_pictures; result:=true; end;
if s = usr_videos then begin s:=txt_5_0_videos; result:=true; end;
end;

procedure set_ow_custedit_menu;
begin
with FormPeach do
begin
if StringGridCustedit.Cells[1,1]<>'' then owcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then owcustom1.Caption:=extractfilename(custedit1)
   else owcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then owcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then owcustom2.Caption:=extractfilename(custedit2)
   else owcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then owcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then owcustom3.Caption:=extractfilename(custedit3)
   else owcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then owcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then owcustom4.Caption:=extractfilename(custedit4)
   else owcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then owcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then owcustom5.Caption:=extractfilename(custedit5)
   else owcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then owcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then owcustom6.Caption:=extractfilename(custedit6)
   else owcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then owcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then owcustom7.Caption:=extractfilename(custedit7)
   else owcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then owcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then owcustom8.Caption:=extractfilename(custedit8)
   else owcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then owcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then owcustom_9.Caption:=extractfilename(custedit9)
   else owcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then owcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then owcustom_10.Caption:=extractfilename(custedit10)
   else owcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then owcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then owcustom_11.Caption:=extractfilename(custedit11)
   else owcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then owcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then owcustom_12.Caption:=extractfilename(custedit12)
   else owcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then owcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then owcustom_13.Caption:=extractfilename(custedit13)
   else owcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then owcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then owcustom_14.Caption:=extractfilename(custedit14)
   else owcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then owcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then owcustom_15.Caption:=extractfilename(custedit15)
   else owcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then owcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then owcustom_16.Caption:=extractfilename(custedit16)
   else owcustom_16.Caption:=custedit16;
if StringGridCustEditAdv.Cells[1,1]<>'' then owcustom9.Caption:=StringGridCustEditAdv.Cells[1,1]
else owcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustEditAdv.Cells[1,2]<>'' then owcustom10.Caption:=StringGridCustEditAdv.Cells[1,2]
else owcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustEditAdv.Cells[1,3]<>'' then owcustom11.Caption:=StringGridCustEditAdv.Cells[1,3]
else owcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustEditAdv.Cells[1,4]<>'' then owcustom12.Caption:=StringGridCustEditAdv.Cells[1,4]
else owcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustEditAdv.Cells[1,5]<>'' then owcustom13.Caption:=StringGridCustEditAdv.Cells[1,5]
else owcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustEditAdv.Cells[1,6]<>'' then owcustom14.Caption:=StringGridCustEditAdv.Cells[1,6]
else owcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustEditAdv.Cells[1,7]<>'' then owcustom15.Caption:=StringGridCustEditAdv.Cells[1,7]
else owcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustEditAdv.Cells[1,8]<>'' then owcustom16.Caption:=StringGridCustEditAdv.Cells[1,8]
else owcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then owcustom1.visible:=true else owcustom1.visible:=false;
if custedit2<>'' then owcustom2.visible:=true else owcustom2.visible:=false;
if custedit3<>'' then owcustom3.visible:=true else owcustom3.visible:=false;
if custedit4<>'' then owcustom4.visible:=true else owcustom4.visible:=false;
if custedit5<>'' then owcustom5.visible:=true else owcustom5.visible:=false;
if custedit6<>'' then owcustom6.visible:=true else owcustom6.visible:=false;
if custedit7<>'' then owcustom7.visible:=true else owcustom7.visible:=false;
if custedit8<>'' then owcustom8.visible:=true else owcustom8.visible:=false;
if custedit9<>'' then owcustom_9.visible:=true else owcustom_9.visible:=false;
if custedit10<>'' then owcustom_10.visible:=true else owcustom_10.visible:=false;
if custedit11<>'' then owcustom_11.visible:=true else owcustom_11.visible:=false;
if custedit12<>'' then owcustom_12.visible:=true else owcustom_12.visible:=false;
if custedit13<>'' then owcustom_13.visible:=true else owcustom_13.visible:=false;
if custedit14<>'' then owcustom_14.visible:=true else owcustom_14.visible:=false;
if custedit15<>'' then owcustom_15.visible:=true else owcustom_15.visible:=false;
if custedit16<>'' then owcustom_16.visible:=true else owcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then owcustom9.visible:=true else owcustom9.visible:=false;
if advedit2before+advedit2after<>'' then owcustom10.visible:=true else owcustom10.visible:=false;
if advedit3before+advedit3after<>'' then owcustom11.visible:=true else owcustom11.visible:=false;
if advedit4before+advedit4after<>'' then owcustom12.visible:=true else owcustom12.visible:=false;
if advedit5before+advedit5after<>'' then owcustom13.visible:=true else owcustom13.visible:=false;
if advedit6before+advedit6after<>'' then owcustom14.visible:=true else owcustom14.visible:=false;
if advedit7before+advedit7after<>'' then owcustom15.visible:=true else owcustom15.visible:=false;
if advedit8before+advedit8after<>'' then owcustom16.visible:=true else owcustom16.visible:=false;
pmmore1.caption:=owcustom9.caption;
pmmore2.caption:=owcustom10.caption;
pmmore3.caption:=owcustom11.caption;
pmmore4.caption:=owcustom12.caption;
pmmore5.caption:=owcustom13.caption;
pmmore6.caption:=owcustom14.caption;
pmmore7.caption:=owcustom15.caption;
pmmore8.caption:=owcustom16.caption;
pmmore1.visible:=owcustom9.visible;
pmmore2.visible:=owcustom10.visible;
pmmore3.visible:=owcustom11.visible;
pmmore4.visible:=owcustom12.visible;
pmmore5.visible:=owcustom13.visible;
pmmore6.visible:=owcustom14.visible;
pmmore7.visible:=owcustom15.visible;
pmmore8.visible:=owcustom16.visible;
pmapp1.Caption:=owcustom1.Caption;
pmapp1.Visible:=owcustom1.Visible;
pmapp2.Caption:=owcustom2.Caption;
pmapp2.Visible:=owcustom2.Visible;
pmapp3.Caption:=owcustom3.Caption;
pmapp3.Visible:=owcustom3.Visible;
pmapp4.Caption:=owcustom4.Caption;
pmapp4.Visible:=owcustom4.Visible;
pmapp5.Caption:=owcustom5.Caption;
pmapp5.Visible:=owcustom5.Visible;
pmapp6.Caption:=owcustom6.Caption;
pmapp6.Visible:=owcustom6.Visible;
pmapp7.Caption:=owcustom7.Caption;
pmapp7.Visible:=owcustom7.Visible;
pmapp8.Caption:=owcustom8.Caption;
pmapp8.Visible:=owcustom8.Visible;
pmapp9.Caption:=owcustom_9.Caption;
pmapp9.Visible:=owcustom_9.Visible;
pmapp10.Caption:=owcustom_10.Caption;
pmapp10.Visible:=owcustom_10.Visible;
pmapp11.Caption:=owcustom_11.Caption;
pmapp11.Visible:=owcustom_11.Visible;
pmapp12.Caption:=owcustom_12.Caption;
pmapp12.Visible:=owcustom_12.Visible;
pmapp13.Caption:=owcustom_13.Caption;
pmapp13.Visible:=owcustom_13.Visible;
pmapp14.Caption:=owcustom_14.Caption;
pmapp14.Visible:=owcustom_14.Visible;
pmapp15.Caption:=owcustom_15.Caption;
pmapp15.Visible:=owcustom_15.Visible;
pmapp16.Caption:=owcustom_16.Caption;
pmapp16.Visible:=owcustom_16.Visible;
pmappadv1.Caption:=owcustom9.Caption;
pmappadv1.Visible:=owcustom9.Visible;
pmappadv2.Caption:=owcustom10.Caption;
pmappadv2.Visible:=owcustom10.Visible;
pmappadv3.Caption:=owcustom11.Caption;
pmappadv3.Visible:=owcustom11.Visible;
pmappadv4.Caption:=owcustom12.Caption;
pmappadv4.Visible:=owcustom12.Visible;
pmappadv5.Caption:=owcustom13.Caption;
pmappadv5.Visible:=owcustom13.Visible;
pmappadv6.Caption:=owcustom14.Caption;
pmappadv6.Visible:=owcustom14.Visible;
pmappadv7.Caption:=owcustom15.Caption;
pmappadv7.Visible:=owcustom15.Visible;
pmappadv8.Caption:=owcustom16.Caption;
pmappadv8.Visible:=owcustom16.Visible;
end;
end;

procedure set_eow_custedit_menu;
begin
with FormPeach do
begin
if StringGridCustedit.Cells[1,1]<>'' then eowcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then eowcustom1.Caption:=extractfilename(custedit1)
   else eowcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then eowcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then eowcustom2.Caption:=extractfilename(custedit2)
   else eowcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then eowcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then eowcustom3.Caption:=extractfilename(custedit3)
   else eowcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then eowcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then eowcustom4.Caption:=extractfilename(custedit4)
   else eowcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then eowcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then eowcustom5.Caption:=extractfilename(custedit5)
   else eowcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then eowcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then eowcustom6.Caption:=extractfilename(custedit6)
   else eowcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then eowcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then eowcustom7.Caption:=extractfilename(custedit7)
   else eowcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then eowcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then eowcustom8.Caption:=extractfilename(custedit8)
   else eowcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then eowcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then eowcustom_9.Caption:=extractfilename(custedit9)
   else eowcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then eowcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then eowcustom_10.Caption:=extractfilename(custedit10)
   else eowcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then eowcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then eowcustom_11.Caption:=extractfilename(custedit11)
   else eowcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then eowcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then eowcustom_12.Caption:=extractfilename(custedit12)
   else eowcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then eowcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then eowcustom_13.Caption:=extractfilename(custedit13)
   else eowcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then eowcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then eowcustom_14.Caption:=extractfilename(custedit14)
   else eowcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then eowcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then eowcustom_15.Caption:=extractfilename(custedit15)
   else eowcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then eowcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then eowcustom_16.Caption:=extractfilename(custedit16)
   else eowcustom_16.Caption:=custedit16;
if StringGridCustEditAdv.Cells[1,1]<>'' then eowcustom9.Caption:=StringGridCustEditAdv.Cells[1,1]
else eowcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustEditAdv.Cells[1,2]<>'' then eowcustom10.Caption:=StringGridCustEditAdv.Cells[1,2]
else eowcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustEditAdv.Cells[1,3]<>'' then eowcustom11.Caption:=StringGridCustEditAdv.Cells[1,3]
else eowcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustEditAdv.Cells[1,4]<>'' then eowcustom12.Caption:=StringGridCustEditAdv.Cells[1,4]
else eowcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustEditAdv.Cells[1,5]<>'' then eowcustom13.Caption:=StringGridCustEditAdv.Cells[1,5]
else eowcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustEditAdv.Cells[1,6]<>'' then eowcustom14.Caption:=StringGridCustEditAdv.Cells[1,6]
else eowcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustEditAdv.Cells[1,7]<>'' then eowcustom15.Caption:=StringGridCustEditAdv.Cells[1,7]
else eowcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustEditAdv.Cells[1,8]<>'' then eowcustom16.Caption:=StringGridCustEditAdv.Cells[1,8]
else eowcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then eowcustom1.visible:=true else eowcustom1.visible:=false;
if custedit2<>'' then eowcustom2.visible:=true else eowcustom2.visible:=false;
if custedit3<>'' then eowcustom3.visible:=true else eowcustom3.visible:=false;
if custedit4<>'' then eowcustom4.visible:=true else eowcustom4.visible:=false;
if custedit5<>'' then eowcustom5.visible:=true else eowcustom5.visible:=false;
if custedit6<>'' then eowcustom6.visible:=true else eowcustom6.visible:=false;
if custedit7<>'' then eowcustom7.visible:=true else eowcustom7.visible:=false;
if custedit8<>'' then eowcustom8.visible:=true else eowcustom8.visible:=false;
if custedit9<>'' then eowcustom_9.visible:=true else eowcustom_9.visible:=false;
if custedit10<>'' then eowcustom_10.visible:=true else eowcustom_10.visible:=false;
if custedit11<>'' then eowcustom_11.visible:=true else eowcustom_11.visible:=false;
if custedit12<>'' then eowcustom_12.visible:=true else eowcustom_12.visible:=false;
if custedit13<>'' then eowcustom_13.visible:=true else eowcustom_13.visible:=false;
if custedit14<>'' then eowcustom_14.visible:=true else eowcustom_14.visible:=false;
if custedit15<>'' then eowcustom_15.visible:=true else eowcustom_15.visible:=false;
if custedit16<>'' then eowcustom_16.visible:=true else eowcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then eowcustom9.visible:=true else eowcustom9.visible:=false;
if advedit2before+advedit2after<>'' then eowcustom10.visible:=true else eowcustom10.visible:=false;
if advedit3before+advedit3after<>'' then eowcustom11.visible:=true else eowcustom11.visible:=false;
if advedit4before+advedit4after<>'' then eowcustom12.visible:=true else eowcustom12.visible:=false;
if advedit5before+advedit5after<>'' then eowcustom13.visible:=true else eowcustom13.visible:=false;
if advedit6before+advedit6after<>'' then eowcustom14.visible:=true else eowcustom14.visible:=false;
if advedit7before+advedit7after<>'' then eowcustom15.visible:=true else eowcustom15.visible:=false;
if advedit8before+advedit8after<>'' then eowcustom16.visible:=true else eowcustom16.visible:=false;
end;
end;

procedure set_pow_custedit_menu;
begin
with FormPeach do
begin
if StringGridCustedit.Cells[1,1]<>'' then powcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then powcustom1.Caption:=extractfilename(custedit1)
   else powcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then powcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then powcustom2.Caption:=extractfilename(custedit2)
   else powcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then powcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then powcustom3.Caption:=extractfilename(custedit3)
   else powcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then powcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then powcustom4.Caption:=extractfilename(custedit4)
   else powcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then powcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then powcustom5.Caption:=extractfilename(custedit5)
   else powcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then powcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then powcustom6.Caption:=extractfilename(custedit6)
   else powcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then powcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then powcustom7.Caption:=extractfilename(custedit7)
   else powcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then powcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then powcustom8.Caption:=extractfilename(custedit8)
   else powcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then powcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then powcustom_9.Caption:=extractfilename(custedit9)
   else powcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then powcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then powcustom_10.Caption:=extractfilename(custedit10)
   else powcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then powcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then powcustom_11.Caption:=extractfilename(custedit11)
   else powcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then powcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then powcustom_12.Caption:=extractfilename(custedit12)
   else powcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then powcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then powcustom_13.Caption:=extractfilename(custedit13)
   else powcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then powcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then powcustom_14.Caption:=extractfilename(custedit14)
   else powcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then powcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then powcustom_15.Caption:=extractfilename(custedit15)
   else powcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then powcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then powcustom_16.Caption:=extractfilename(custedit16)
   else powcustom_16.Caption:=custedit16;
if StringGridCustEditAdv.Cells[1,1]<>'' then powcustom9.Caption:=StringGridCustEditAdv.Cells[1,1]
else powcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustEditAdv.Cells[1,2]<>'' then powcustom10.Caption:=StringGridCustEditAdv.Cells[1,2]
else powcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustEditAdv.Cells[1,3]<>'' then powcustom11.Caption:=StringGridCustEditAdv.Cells[1,3]
else powcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustEditAdv.Cells[1,4]<>'' then powcustom12.Caption:=StringGridCustEditAdv.Cells[1,4]
else powcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustEditAdv.Cells[1,5]<>'' then powcustom13.Caption:=StringGridCustEditAdv.Cells[1,5]
else powcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustEditAdv.Cells[1,6]<>'' then powcustom14.Caption:=StringGridCustEditAdv.Cells[1,6]
else powcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustEditAdv.Cells[1,7]<>'' then powcustom15.Caption:=StringGridCustEditAdv.Cells[1,7]
else powcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustEditAdv.Cells[1,8]<>'' then powcustom16.Caption:=StringGridCustEditAdv.Cells[1,8]
else powcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then powcustom1.visible:=true else powcustom1.visible:=false;
if custedit2<>'' then powcustom2.visible:=true else powcustom2.visible:=false;
if custedit3<>'' then powcustom3.visible:=true else powcustom3.visible:=false;
if custedit4<>'' then powcustom4.visible:=true else powcustom4.visible:=false;
if custedit5<>'' then powcustom5.visible:=true else powcustom5.visible:=false;
if custedit6<>'' then powcustom6.visible:=true else powcustom6.visible:=false;
if custedit7<>'' then powcustom7.visible:=true else powcustom7.visible:=false;
if custedit8<>'' then powcustom8.visible:=true else powcustom8.visible:=false;
if custedit9<>'' then powcustom_9.visible:=true else powcustom_9.visible:=false;
if custedit10<>'' then powcustom_10.visible:=true else powcustom_10.visible:=false;
if custedit11<>'' then powcustom_11.visible:=true else powcustom_11.visible:=false;
if custedit12<>'' then powcustom_12.visible:=true else powcustom_12.visible:=false;
if custedit13<>'' then powcustom_13.visible:=true else powcustom_13.visible:=false;
if custedit14<>'' then powcustom_14.visible:=true else powcustom_14.visible:=false;
if custedit15<>'' then powcustom_15.visible:=true else powcustom_15.visible:=false;
if custedit16<>'' then powcustom_16.visible:=true else powcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then powcustom9.visible:=true else powcustom9.visible:=false;
if advedit2before+advedit2after<>'' then powcustom10.visible:=true else powcustom10.visible:=false;
if advedit3before+advedit3after<>'' then powcustom11.visible:=true else powcustom11.visible:=false;
if advedit4before+advedit4after<>'' then powcustom12.visible:=true else powcustom12.visible:=false;
if advedit5before+advedit5after<>'' then powcustom13.visible:=true else powcustom13.visible:=false;
if advedit6before+advedit6after<>'' then powcustom14.visible:=true else powcustom14.visible:=false;
if advedit7before+advedit7after<>'' then powcustom15.visible:=true else powcustom15.visible:=false;
if advedit8before+advedit8after<>'' then powcustom16.visible:=true else powcustom16.visible:=false;
end;
end;

procedure set_aow_custedit_menu;
begin
with FormPeach do
begin
if StringGridCustedit.Cells[1,1]<>'' then aowcustom1.Caption:=StringGridCustedit.Cells[1,1]
else
   if extractfilename(custedit1)<>'' then aowcustom1.Caption:=extractfilename(custedit1)
   else aowcustom1.Caption:=custedit1;
if StringGridCustedit.Cells[1,2]<>'' then aowcustom2.Caption:=StringGridCustedit.Cells[1,2]
else
   if extractfilename(custedit2)<>'' then aowcustom2.Caption:=extractfilename(custedit2)
   else aowcustom2.Caption:=custedit2;
if StringGridCustedit.Cells[1,3]<>'' then aowcustom3.Caption:=StringGridCustedit.Cells[1,3]
else
   if extractfilename(custedit3)<>'' then aowcustom3.Caption:=extractfilename(custedit3)
   else aowcustom3.Caption:=custedit3;
if StringGridCustedit.Cells[1,4]<>'' then aowcustom4.Caption:=StringGridCustedit.Cells[1,4]
else
   if extractfilename(custedit4)<>'' then aowcustom4.Caption:=extractfilename(custedit4)
   else aowcustom4.Caption:=custedit4;
if StringGridCustedit.Cells[1,5]<>'' then aowcustom5.Caption:=StringGridCustedit.Cells[1,5]
else
   if extractfilename(custedit5)<>'' then aowcustom5.Caption:=extractfilename(custedit5)
   else aowcustom5.Caption:=custedit5;
if StringGridCustedit.Cells[1,6]<>'' then aowcustom6.Caption:=StringGridCustedit.Cells[1,6]
else
   if extractfilename(custedit6)<>'' then aowcustom6.Caption:=extractfilename(custedit6)
   else aowcustom6.Caption:=custedit6;
if StringGridCustedit.Cells[1,7]<>'' then aowcustom7.Caption:=StringGridCustedit.Cells[1,7]
else
   if extractfilename(custedit7)<>'' then aowcustom7.Caption:=extractfilename(custedit7)
   else aowcustom7.Caption:=custedit7;
if StringGridCustedit.Cells[1,8]<>'' then aowcustom8.Caption:=StringGridCustedit.Cells[1,8]
else
   if extractfilename(custedit8)<>'' then aowcustom8.Caption:=extractfilename(custedit8)
   else aowcustom8.Caption:=custedit8;
if StringGridCustedit.Cells[1,9]<>'' then aowcustom_9.Caption:=StringGridCustedit.Cells[1,9]
else
   if extractfilename(custedit9)<>'' then aowcustom_9.Caption:=extractfilename(custedit9)
   else aowcustom_9.Caption:=custedit9;
if StringGridCustedit.Cells[1,10]<>'' then aowcustom_10.Caption:=StringGridCustedit.Cells[1,10]
else
   if extractfilename(custedit10)<>'' then aowcustom_10.Caption:=extractfilename(custedit10)
   else aowcustom_10.Caption:=custedit10;
if StringGridCustedit.Cells[1,11]<>'' then aowcustom_11.Caption:=StringGridCustedit.Cells[1,11]
else
   if extractfilename(custedit11)<>'' then aowcustom_11.Caption:=extractfilename(custedit11)
   else aowcustom_11.Caption:=custedit11;
if StringGridCustedit.Cells[1,12]<>'' then aowcustom_12.Caption:=StringGridCustedit.Cells[1,12]
else
   if extractfilename(custedit12)<>'' then aowcustom_12.Caption:=extractfilename(custedit12)
   else aowcustom_12.Caption:=custedit12;
if StringGridCustedit.Cells[1,13]<>'' then aowcustom_13.Caption:=StringGridCustedit.Cells[1,13]
else
   if extractfilename(custedit13)<>'' then aowcustom_13.Caption:=extractfilename(custedit13)
   else aowcustom_13.Caption:=custedit13;
if StringGridCustedit.Cells[1,14]<>'' then aowcustom_14.Caption:=StringGridCustedit.Cells[1,14]
else
   if extractfilename(custedit14)<>'' then aowcustom_14.Caption:=extractfilename(custedit14)
   else aowcustom_14.Caption:=custedit14;
if StringGridCustedit.Cells[1,15]<>'' then aowcustom_15.Caption:=StringGridCustedit.Cells[1,15]
else
   if extractfilename(custedit15)<>'' then aowcustom_15.Caption:=extractfilename(custedit15)
   else aowcustom_15.Caption:=custedit15;
if StringGridCustedit.Cells[1,16]<>'' then aowcustom_16.Caption:=StringGridCustedit.Cells[1,16]
else
   if extractfilename(custedit16)<>'' then aowcustom_16.Caption:=extractfilename(custedit16)
   else aowcustom_16.Caption:=custedit16;
if StringGridCustEditAdv.Cells[1,1]<>'' then aowcustom9.Caption:=StringGridCustEditAdv.Cells[1,1]
else aowcustom9.Caption:=advedit1before+stringdelim('%f')+advedit1after;
if StringGridCustEditAdv.Cells[1,2]<>'' then aowcustom10.Caption:=StringGridCustEditAdv.Cells[1,2]
else aowcustom10.Caption:=advedit2before+stringdelim('%f')+advedit2after;
if StringGridCustEditAdv.Cells[1,3]<>'' then aowcustom11.Caption:=StringGridCustEditAdv.Cells[1,3]
else aowcustom11.Caption:=advedit3before+stringdelim('%f')+advedit3after;
if StringGridCustEditAdv.Cells[1,4]<>'' then aowcustom12.Caption:=StringGridCustEditAdv.Cells[1,4]
else aowcustom12.Caption:=advedit4before+stringdelim('%f')+advedit4after;
if StringGridCustEditAdv.Cells[1,5]<>'' then aowcustom13.Caption:=StringGridCustEditAdv.Cells[1,5]
else aowcustom13.Caption:=advedit5before+stringdelim('%f')+advedit5after;
if StringGridCustEditAdv.Cells[1,6]<>'' then aowcustom14.Caption:=StringGridCustEditAdv.Cells[1,6]
else aowcustom14.Caption:=advedit6before+stringdelim('%f')+advedit6after;
if StringGridCustEditAdv.Cells[1,7]<>'' then aowcustom15.Caption:=StringGridCustEditAdv.Cells[1,7]
else aowcustom15.Caption:=advedit7before+stringdelim('%f')+advedit7after;
if StringGridCustEditAdv.Cells[1,8]<>'' then aowcustom16.Caption:=StringGridCustEditAdv.Cells[1,8]
else aowcustom16.Caption:=advedit8before+stringdelim('%f')+advedit8after;
if custedit1<>'' then aowcustom1.visible:=true else aowcustom1.visible:=false;
if custedit2<>'' then aowcustom2.visible:=true else aowcustom2.visible:=false;
if custedit3<>'' then aowcustom3.visible:=true else aowcustom3.visible:=false;
if custedit4<>'' then aowcustom4.visible:=true else aowcustom4.visible:=false;
if custedit5<>'' then aowcustom5.visible:=true else aowcustom5.visible:=false;
if custedit6<>'' then aowcustom6.visible:=true else aowcustom6.visible:=false;
if custedit7<>'' then aowcustom7.visible:=true else aowcustom7.visible:=false;
if custedit8<>'' then aowcustom8.visible:=true else aowcustom8.visible:=false;
if custedit9<>'' then aowcustom_9.visible:=true else aowcustom_9.visible:=false;
if custedit10<>'' then aowcustom_10.visible:=true else aowcustom_10.visible:=false;
if custedit11<>'' then aowcustom_11.visible:=true else aowcustom_11.visible:=false;
if custedit12<>'' then aowcustom_12.visible:=true else aowcustom_12.visible:=false;
if custedit13<>'' then aowcustom_13.visible:=true else aowcustom_13.visible:=false;
if custedit14<>'' then aowcustom_14.visible:=true else aowcustom_14.visible:=false;
if custedit15<>'' then aowcustom_15.visible:=true else aowcustom_15.visible:=false;
if custedit16<>'' then aowcustom_16.visible:=true else aowcustom_16.visible:=false;
if advedit1before+advedit1after<>'' then aowcustom9.visible:=true else aowcustom9.visible:=false;
if advedit2before+advedit2after<>'' then aowcustom10.visible:=true else aowcustom10.visible:=false;
if advedit3before+advedit3after<>'' then aowcustom11.visible:=true else aowcustom11.visible:=false;
if advedit4before+advedit4after<>'' then aowcustom12.visible:=true else aowcustom12.visible:=false;
if advedit5before+advedit5after<>'' then aowcustom13.visible:=true else aowcustom13.visible:=false;
if advedit6before+advedit6after<>'' then aowcustom14.visible:=true else aowcustom14.visible:=false;
if advedit7before+advedit7after<>'' then aowcustom15.visible:=true else aowcustom15.visible:=false;
if advedit8before+advedit8after<>'' then aowcustom16.visible:=true else aowcustom16.visible:=false;
if advedit1before+advedit2before+advedit3before+advedit4before+advedit5before+advedit6before+advedit7before+advedit8before+
   advedit1after+advedit2after+advedit3after+advedit4after+advedit5after+advedit6after+advedit7after+advedit8after<>'' then aowseparator2.visible:=true else aowseparator2.visible:=false;
end;
end;

procedure set_custedit_menus;
begin
set_ow_custedit_menu;
set_eow_custedit_menu;
set_pow_custedit_menu;
set_aow_custedit_menu;
populatetree;
end;

procedure set_custedit_fromtable;
begin
with FormPeach do
begin
custedit1:=StringGridCustedit.Cells[2,1];
custedit2:=StringGridCustedit.Cells[2,2];
custedit3:=StringGridCustedit.Cells[2,3];
custedit4:=StringGridCustedit.Cells[2,4];
custedit5:=StringGridCustedit.Cells[2,5];
custedit6:=StringGridCustedit.Cells[2,6];
custedit7:=StringGridCustedit.Cells[2,7];
custedit8:=StringGridCustedit.Cells[2,8];
custedit9:=StringGridCustedit.Cells[2,9];
custedit10:=StringGridCustedit.Cells[2,10];
custedit11:=StringGridCustedit.Cells[2,11];
custedit12:=StringGridCustedit.Cells[2,12];
custedit13:=StringGridCustedit.Cells[2,13];
custedit14:=StringGridCustedit.Cells[2,14];
custedit15:=StringGridCustedit.Cells[2,15];
custedit16:=StringGridCustedit.Cells[2,16];
advedit1before:=StringGridCustEditAdv.Cells[2,1];
advedit2before:=StringGridCustEditAdv.Cells[2,2];
advedit3before:=StringGridCustEditAdv.Cells[2,3];
advedit4before:=StringGridCustEditAdv.Cells[2,4];
advedit5before:=StringGridCustEditAdv.Cells[2,5];
advedit6before:=StringGridCustEditAdv.Cells[2,6];
advedit7before:=StringGridCustEditAdv.Cells[2,7];
advedit8before:=StringGridCustEditAdv.Cells[2,8];
advedit1after:=StringGridCustEditAdv.Cells[3,1];
advedit2after:=StringGridCustEditAdv.Cells[3,2];
advedit3after:=StringGridCustEditAdv.Cells[3,3];
advedit4after:=StringGridCustEditAdv.Cells[3,4];
advedit5after:=StringGridCustEditAdv.Cells[3,5];
advedit6after:=StringGridCustEditAdv.Cells[3,6];
advedit7after:=StringGridCustEditAdv.Cells[3,7];
advedit8after:=StringGridCustEditAdv.Cells[3,8];
advedit1alt:=StringGridCustEditAdv.Cells[4,1];
advedit2alt:=StringGridCustEditAdv.Cells[4,2];
advedit3alt:=StringGridCustEditAdv.Cells[4,3];
advedit4alt:=StringGridCustEditAdv.Cells[4,4];
advedit5alt:=StringGridCustEditAdv.Cells[4,5];
advedit6alt:=StringGridCustEditAdv.Cells[4,6];
advedit7alt:=StringGridCustEditAdv.Cells[4,7];
advedit8alt:=StringGridCustEditAdv.Cells[4,8];
end;
end;

procedure set_custedit_totable;
begin
with FormPeach do
begin
StringGridCustedit.Cells[2,1]:=custedit1;
StringGridCustedit.Cells[2,2]:=custedit2;
StringGridCustedit.Cells[2,3]:=custedit3;
StringGridCustedit.Cells[2,4]:=custedit4;
StringGridCustedit.Cells[2,5]:=custedit5;
StringGridCustedit.Cells[2,6]:=custedit6;
StringGridCustedit.Cells[2,7]:=custedit7;
StringGridCustedit.Cells[2,8]:=custedit8;
StringGridCustedit.Cells[2,9]:=custedit9;
StringGridCustedit.Cells[2,10]:=custedit10;
StringGridCustedit.Cells[2,11]:=custedit11;
StringGridCustedit.Cells[2,12]:=custedit12;
StringGridCustedit.Cells[2,13]:=custedit13;
StringGridCustedit.Cells[2,14]:=custedit14;
StringGridCustedit.Cells[2,15]:=custedit15;
StringGridCustedit.Cells[2,16]:=custedit16;
StringGridCustedit.AutoSizeColumns;
StringGridCustEditAdv.Cells[2,1]:=advedit1before;
StringGridCustEditAdv.Cells[2,2]:=advedit2before;
StringGridCustEditAdv.Cells[2,3]:=advedit3before;
StringGridCustEditAdv.Cells[2,4]:=advedit4before;
StringGridCustEditAdv.Cells[2,5]:=advedit5before;
StringGridCustEditAdv.Cells[2,6]:=advedit6before;
StringGridCustEditAdv.Cells[2,7]:=advedit7before;
StringGridCustEditAdv.Cells[2,8]:=advedit8before;
StringGridCustEditAdv.Cells[3,1]:=advedit1after;
StringGridCustEditAdv.Cells[3,2]:=advedit2after;
StringGridCustEditAdv.Cells[3,3]:=advedit3after;
StringGridCustEditAdv.Cells[3,4]:=advedit4after;
StringGridCustEditAdv.Cells[3,5]:=advedit5after;
StringGridCustEditAdv.Cells[3,6]:=advedit6after;
StringGridCustEditAdv.Cells[3,7]:=advedit7after;
StringGridCustEditAdv.Cells[3,8]:=advedit8after;
StringGridCustEditAdv.Cells[4,1]:=advedit1alt;
StringGridCustEditAdv.Cells[4,2]:=advedit2alt;
StringGridCustEditAdv.Cells[4,3]:=advedit3alt;
StringGridCustEditAdv.Cells[4,4]:=advedit4alt;
StringGridCustEditAdv.Cells[4,5]:=advedit5alt;
StringGridCustEditAdv.Cells[4,6]:=advedit6alt;
StringGridCustEditAdv.Cells[4,7]:=advedit7alt;
StringGridCustEditAdv.Cells[4,8]:=advedit8alt;
StringGridCustEditAdv.AutoSizeColumns;
end;
end;

procedure populaterecentpanel;
var
   i:integer;
begin
try
FormPeach.StringGridRecent.Rowcount:=17;
i:=1;
if FormPeach.mRecent1f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent1f.Caption; i:=i+1; end;
if FormPeach.mRecent2f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent2f.Caption; i:=i+1; end;
if FormPeach.mRecent3f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent3f.Caption; i:=i+1; end;
if FormPeach.mRecent4f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent4f.Caption; i:=i+1; end;
if FormPeach.mRecent5f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent5f.Caption; i:=i+1; end;
if FormPeach.mRecent6f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent6f.Caption; i:=i+1; end;
if FormPeach.mRecent7f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent7f.Caption; i:=i+1; end;
if FormPeach.mRecent8f.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=''; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent8f.Caption; i:=i+1; end;

if FormPeach.mRecent1.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent1.Caption; i:=i+1; end;
if FormPeach.mRecent2.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent2.Caption; i:=i+1; end;
if FormPeach.mRecent3.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent3.Caption; i:=i+1; end;
if FormPeach.mRecent4.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent4.Caption; i:=i+1; end;
if FormPeach.mRecent5.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent5.Caption; i:=i+1; end;
if FormPeach.mRecent6.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent6.Caption; i:=i+1; end;
if FormPeach.mRecent7.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent7.Caption; i:=i+1; end;
if FormPeach.mRecent8.Caption<>'' then begin FormPeach.StringGridRecent.Cells[0,i]:=' '; FormPeach.StringGridRecent.Cells[1,i]:=FormPeach.mRecent8.Caption; i:=i+1; end;
FormPeach.StringGridRecent.Rowcount:=i;
FormPeach.StringGridRecent.AutosizeColumns;
FormPeach.StringGridRecent.ColWidths[0]:=rowsize;
FormPeach.StringGridRecent.ColWidths[2]:=0;
FormPeach.StringGridRecent.ColWidths[3]:=0;
FormPeach.StringGridRecent.ColWidths[4]:=0;
except
end;
if (FormPeach.mRecent1f.Caption='') and (FormPeach.mRecent1.Caption='') then
   begin
   FormPeach.MenuItem55.visible:=false;
   FormPeach.MenuItem57.visible:=false;
   FormPeach.MenuItem58.visible:=false;
   FormPeach.MenuItem59.visible:=false;
   end
else
   begin
   FormPeach.MenuItem55.visible:=true;
   FormPeach.MenuItem57.visible:=true;
   FormPeach.MenuItem58.visible:=true;
   FormPeach.MenuItem59.visible:=true;
   end ;
end;

procedure setsearchhistorymenu;
begin
with FormPeach do
begin
if pmshist1.Caption<>'' then pmshist1.Visible:=true else pmshist1.Visible:=false;
if pmshist2.Caption<>'' then pmshist2.Visible:=true else pmshist2.Visible:=false;
if pmshist3.Caption<>'' then pmshist3.Visible:=true else pmshist3.Visible:=false;
if pmshist4.Caption<>'' then pmshist4.Visible:=true else pmshist4.Visible:=false;
if pmshist5.Caption<>'' then pmshist5.Visible:=true else pmshist5.Visible:=false;
if pmshist6.Caption<>'' then pmshist6.Visible:=true else pmshist6.Visible:=false;
if pmshist7.Caption<>'' then pmshist7.Visible:=true else pmshist7.Visible:=false;
if pmshist8.Caption<>'' then pmshist8.Visible:=true else pmshist8.Visible:=false;
end;
end;

procedure checkrecent(var srec:Thistarray);
var
  i,j:integer;
  csrec:Thistarray;
begin
for i:=1 to 8 do csrec[i]:='';
j:=1;
for i:=1 to 8 do
   if fileexists(srec[i]) then
      begin
      csrec[j]:=srec[i];
      j:=j+1;
      end;
FormPeach.mRecent1.Caption:=csrec[1];
FormPeach.mRecent2.Caption:=csrec[2];
FormPeach.mRecent3.Caption:=csrec[3];
FormPeach.mRecent4.Caption:=csrec[4];
FormPeach.mRecent5.Caption:=csrec[5];
FormPeach.mRecent6.Caption:=csrec[6];
FormPeach.mRecent7.Caption:=csrec[7];
FormPeach.mRecent8.Caption:=csrec[8];
end;

procedure checkrecentf(var srecf:Thistarray);
var
  i,j:integer;
  csrecf:Thistarray;
begin
for i:=1 to 8 do csrecf[i]:='';
j:=1;
for i:=1 to 8 do
   if checkdirexists(srecf[i]) then
      begin
      csrecf[j]:=srecf[i];
      j:=j+1;
      end;
FormPeach.mRecent1f.Caption:=csrecf[1];
FormPeach.mRecent2f.Caption:=csrecf[2];
FormPeach.mRecent3f.Caption:=csrecf[3];
FormPeach.mRecent4f.Caption:=csrecf[4];
FormPeach.mRecent5f.Caption:=csrecf[5];
FormPeach.mRecent6f.Caption:=csrecf[6];
FormPeach.mRecent7f.Caption:=csrecf[7];
FormPeach.mRecent8f.Caption:=csrecf[8];
end;

procedure setshowvolatile;
begin
if showvolatile=1 then
begin
FormPeach.checkboxseparate.Font.Style:=[fsItalic];
FormPeach.checkboxsamearc.Font.Style:=[fsItalic];
FormPeach.checkboxconvert.Font.Style:=[fsItalic];
FormPeach.CheckBoxConvertPW.Font.Style:=[fsItalic];
FormPeach.CheckBoxConvertVerbose.Font.Style:=[fsItalic];
FormPeach.CheckBoxTarBefore.Font.Style:=[fsItalic];
FormPeach.checkboxsameext.Font.Style:=[fsItalic];
FormPeach.ComboBox7zFun.Font.Style:=[fsItalic];
FormPeach.ComboBox7zPaths.Font.Style:=[fsItalic];
FormPeach.Label7zDictionary.Font.Style:=[fsItalic];
FormPeach.Label7zWord.Font.Style:=[fsItalic];
FormPeach.Label7zPasses.Font.Style:=[fsItalic];
FormPeach.Label7zsolidblock.Font.Style:=[fsItalic];
FormPeach.Label7zFun.Font.Style:=[fsItalic];
FormPeach.Label7zPath.Font.Style:=[fsItalic];
end
else
begin
FormPeach.checkboxseparate.Font.Style:=[];
FormPeach.checkboxsamearc.Font.Style:=[];
FormPeach.checkboxconvert.Font.Style:=[];
FormPeach.CheckBoxConvertPW.Font.Style:=[];
FormPeach.CheckBoxConvertVerbose.Font.Style:=[];
FormPeach.CheckBoxTarBefore.Font.Style:=[];
FormPeach.checkboxsameext.Font.Style:=[];
FormPeach.ComboBox7zFun.Font.Style:=[];
FormPeach.ComboBox7zPaths.Font.Style:=[];
FormPeach.Label7zDictionary.Font.Style:=[];
FormPeach.Label7zWord.Font.Style:=[];
FormPeach.Label7zPasses.Font.Style:=[];
FormPeach.Label7zsolidblock.Font.Style:=[];
FormPeach.Label7zFun.Font.Style:=[];
FormPeach.Label7zPath.Font.Style:=[];
end;
end;

procedure setspecialextensions;
var
  astr: ansistring;
  aastr: array of ansistring;
  i,j:integer;
begin
astr:=FormPeach.editExtEvForWhat.Caption;
aastr:=astr.Split(' ');
j:=0;
SetLength(specextensions,0);
SetLength(specextensions,128);
for i:=0 to length(aastr)-1 do
   if aastr[i]<>'' then
      begin
      specextensions[j]:=aastr[i];
      if specextensions[j,1] <> '.' then specextensions[j]:='.'+specextensions[j];
      j:=j+1;
      if j>=128 then break;
      end;
SetLength(specextensions,j);
end;

procedure setsecurityextensions;
var
  astr: ansistring;
  aastr: array of ansistring;
  i,j:integer;
begin
astr:=FormPeach.editExtEvForSec.Caption;
aastr:=astr.Split(' ');
j:=0;
SetLength(secextensions,0);
SetLength(secextensions,128);
for i:=0 to length(aastr)-1 do
   if aastr[i]<>'' then
      begin
      secextensions[j]:=aastr[i];
      if secextensions[j,1] <> '.' then secextensions[j]:='.'+secextensions[j];
      j:=j+1;
      if j>=128 then break;
      end;
SetLength(secextensions,j);
end;

procedure defaultvirtualopt;
begin
{$IFDEF MSWINDOWS}
allowvirtual:=1; sizevirtual:=8; //8K
FormPeach.ComboBoxvirtual.Items[0]:=txt_default+' (> 8 K)';
{$ELSE}
allowvirtual:=0; sizevirtual:=0; //disabld for GTK2, GTK3 ad other widgetsets
FormPeach.ComboBoxvirtual.Items[0]:=txt_default+' ('+txt_no+')';
{$IFDEF LCLQT6}
allowvirtual:=1; sizevirtual:=16; //16K for Qt6
FormPeach.ComboBoxvirtual.Items[0]:=txt_default+' (> 16 K)';
{$ENDIF}
{$IFDEF LCLQT5}
allowvirtual:=1; sizevirtual:=16; //16K for Qt5 (legacy)
FormPeach.ComboBoxvirtual.Items[0]:=txt_default+' (> 16 K)';
{$ENDIF}
{$IFDEF DARWIN}
allowvirtual:=1; sizevirtual:=4; //4K for macOS
FormPeach.ComboBoxvirtual.Items[0]:=txt_default+' (> 4 K)';
{$ELSE}
{$ENDIF}
{$ENDIF}
end;

procedure populaterecenticons;
begin
with FormPeach do
begin
if mRecent1.visible=true then mRecent1.Bitmap:=drawrecenticon(mRecent1.Caption);
if mRecent2.visible=true then mRecent2.Bitmap:=drawrecenticon(mRecent2.Caption);
if mRecent3.visible=true then mRecent3.Bitmap:=drawrecenticon(mRecent3.Caption);
if mRecent4.visible=true then mRecent4.Bitmap:=drawrecenticon(mRecent4.Caption);
if mRecent5.visible=true then mRecent5.Bitmap:=drawrecenticon(mRecent5.Caption);
if mRecent6.visible=true then mRecent6.Bitmap:=drawrecenticon(mRecent6.Caption);
if mRecent7.visible=true then mRecent7.Bitmap:=drawrecenticon(mRecent7.Caption);
if mRecent8.visible=true then mRecent8.Bitmap:=drawrecenticon(mRecent8.Caption);
if pmhr1.visible=true then pmhr1.Bitmap:=mRecent1.Bitmap;
if pmhr2.visible=true then pmhr2.Bitmap:=mRecent2.Bitmap;
if pmhr3.visible=true then pmhr3.Bitmap:=mRecent3.Bitmap;
if pmhr4.visible=true then pmhr4.Bitmap:=mRecent4.Bitmap;
if pmhr5.visible=true then pmhr5.Bitmap:=mRecent5.Bitmap;
if pmhr6.visible=true then pmhr6.Bitmap:=mRecent6.Bitmap;
if pmhr7.visible=true then pmhr7.Bitmap:=mRecent7.Bitmap;
if pmhr8.visible=true then pmhr8.Bitmap:=mRecent8.Bitmap;
if pmhr1.visible=true then pmamr1.Bitmap:=mRecent1.Bitmap;
if pmhr2.visible=true then pmamr2.Bitmap:=mRecent2.Bitmap;
if pmhr3.visible=true then pmamr3.Bitmap:=mRecent3.Bitmap;
if pmhr4.visible=true then pmamr4.Bitmap:=mRecent4.Bitmap;
if pmhr5.visible=true then pmamr5.Bitmap:=mRecent5.Bitmap;
if pmhr6.visible=true then pmamr6.Bitmap:=mRecent6.Bitmap;
if pmhr7.visible=true then pmamr7.Bitmap:=mRecent7.Bitmap;
if pmhr8.visible=true then pmamr8.Bitmap:=mRecent8.Bitmap;
end;
end;

procedure populaterecenticonsf;
begin
with FormPeach do
begin
if mRecent1f.visible=true then mRecent1f.Bitmap:=drawmenuicon(mRecent1f.Caption);
if mRecent2f.visible=true then mRecent2f.Bitmap:=drawmenuicon(mRecent2f.Caption);
if mRecent3f.visible=true then mRecent3f.Bitmap:=drawmenuicon(mRecent3f.Caption);
if mRecent4f.visible=true then mRecent4f.Bitmap:=drawmenuicon(mRecent4f.Caption);
if mRecent5f.visible=true then mRecent5f.Bitmap:=drawmenuicon(mRecent5f.Caption);
if mRecent6f.visible=true then mRecent6f.Bitmap:=drawmenuicon(mRecent6f.Caption);
if mRecent7f.visible=true then mRecent7f.Bitmap:=drawmenuicon(mRecent7f.Caption);
if mRecent8f.visible=true then mRecent8f.Bitmap:=drawmenuicon(mRecent8f.Caption);
if pmhr1f.visible=true then pmhr1f.Bitmap:=mRecent1f.Bitmap;
if pmhr2f.visible=true then pmhr2f.Bitmap:=mRecent2f.Bitmap;
if pmhr3f.visible=true then pmhr3f.Bitmap:=mRecent3f.Bitmap;
if pmhr4f.visible=true then pmhr4f.Bitmap:=mRecent4f.Bitmap;
if pmhr5f.visible=true then pmhr5f.Bitmap:=mRecent5f.Bitmap;
if pmhr6f.visible=true then pmhr6f.Bitmap:=mRecent6f.Bitmap;
if pmhr7f.visible=true then pmhr7f.Bitmap:=mRecent7f.Bitmap;
if pmhr8f.visible=true then pmhr8f.Bitmap:=mRecent8f.Bitmap;
if mexttoh1.visible=true then mexttoh1.Bitmap:=mRecent1f.Bitmap;
if mexttoh2.visible=true then mexttoh2.Bitmap:=mRecent2f.Bitmap;
if mexttoh3.visible=true then mexttoh3.Bitmap:=mRecent3f.Bitmap;
if mexttoh4.visible=true then mexttoh4.Bitmap:=mRecent4f.Bitmap;
if mexttoh5.visible=true then mexttoh5.Bitmap:=mRecent5f.Bitmap;
if mexttoh6.visible=true then mexttoh6.Bitmap:=mRecent6f.Bitmap;
if mexttoh7.visible=true then mexttoh7.Bitmap:=mRecent7f.Bitmap;
if mexttoh8.visible=true then mexttoh8.Bitmap:=mRecent8f.Bitmap;
end;
end;

procedure setrecenticons_extract_archive;
begin
FormPeach.pnr1.Caption:=FormPeach.mRecent1f.Caption;
FormPeach.pnr2.Caption:=FormPeach.mRecent2f.Caption;
FormPeach.pnr3.Caption:=FormPeach.mRecent3f.Caption;
FormPeach.pnr4.Caption:=FormPeach.mRecent4f.Caption;
FormPeach.pnr5.Caption:=FormPeach.mRecent5f.Caption;
FormPeach.pnr6.Caption:=FormPeach.mRecent6f.Caption;
FormPeach.pnr7.Caption:=FormPeach.mRecent7f.Caption;
FormPeach.pnr8.Caption:=FormPeach.mRecent8f.Caption;
FormPeach.pmemr1.Caption:=FormPeach.mRecent1f.Caption;
FormPeach.pmemr2.Caption:=FormPeach.mRecent2f.Caption;
FormPeach.pmemr3.Caption:=FormPeach.mRecent3f.Caption;
FormPeach.pmemr4.Caption:=FormPeach.mRecent4f.Caption;
FormPeach.pmemr5.Caption:=FormPeach.mRecent5f.Caption;
FormPeach.pmemr6.Caption:=FormPeach.mRecent6f.Caption;
FormPeach.pmemr7.Caption:=FormPeach.mRecent7f.Caption;
FormPeach.pmemr8.Caption:=FormPeach.mRecent8f.Caption;
FormPeach.mexttoh1.Caption:=FormPeach.mRecent1f.Caption;
FormPeach.mexttoh2.Caption:=FormPeach.mRecent2f.Caption;
FormPeach.mexttoh3.Caption:=FormPeach.mRecent3f.Caption;
FormPeach.mexttoh4.Caption:=FormPeach.mRecent4f.Caption;
FormPeach.mexttoh5.Caption:=FormPeach.mRecent5f.Caption;
FormPeach.mexttoh6.Caption:=FormPeach.mRecent6f.Caption;
FormPeach.mexttoh7.Caption:=FormPeach.mRecent7f.Caption;
FormPeach.mexttoh8.Caption:=FormPeach.mRecent8f.Caption;
FormPeach.pnra1.Caption:=FormPeach.mRecent1f.Caption;
FormPeach.pnra2.Caption:=FormPeach.mRecent2f.Caption;
FormPeach.pnra3.Caption:=FormPeach.mRecent3f.Caption;
FormPeach.pnra4.Caption:=FormPeach.mRecent4f.Caption;
FormPeach.pnra5.Caption:=FormPeach.mRecent5f.Caption;
FormPeach.pnra6.Caption:=FormPeach.mRecent6f.Caption;
FormPeach.pnra7.Caption:=FormPeach.mRecent7f.Caption;
FormPeach.pnra8.Caption:=FormPeach.mRecent8f.Caption;
FormPeach.pnr1.Visible:=FormPeach.mRecent1f.Visible;
FormPeach.pnr2.Visible:=FormPeach.mRecent2f.Visible;
FormPeach.pnr3.Visible:=FormPeach.mRecent3f.Visible;
FormPeach.pnr4.Visible:=FormPeach.mRecent4f.Visible;
FormPeach.pnr5.Visible:=FormPeach.mRecent5f.Visible;
FormPeach.pnr6.Visible:=FormPeach.mRecent6f.Visible;
FormPeach.pnr7.Visible:=FormPeach.mRecent7f.Visible;
FormPeach.pnr8.Visible:=FormPeach.mRecent8f.Visible;
FormPeach.pmemr1.Visible:=FormPeach.mRecent1f.Visible;
FormPeach.pmemr2.Visible:=FormPeach.mRecent2f.Visible;
FormPeach.pmemr3.Visible:=FormPeach.mRecent3f.Visible;
FormPeach.pmemr4.Visible:=FormPeach.mRecent4f.Visible;
FormPeach.pmemr5.Visible:=FormPeach.mRecent5f.Visible;
FormPeach.pmemr6.Visible:=FormPeach.mRecent6f.Visible;
FormPeach.pmemr7.Visible:=FormPeach.mRecent7f.Visible;
FormPeach.pmemr8.Visible:=FormPeach.mRecent8f.Visible;
FormPeach.mexttoh1.Visible:=FormPeach.mRecent1f.Visible;
FormPeach.mexttoh2.Visible:=FormPeach.mRecent2f.Visible;
FormPeach.mexttoh3.Visible:=FormPeach.mRecent3f.Visible;
FormPeach.mexttoh4.Visible:=FormPeach.mRecent4f.Visible;
FormPeach.mexttoh5.Visible:=FormPeach.mRecent5f.Visible;
FormPeach.mexttoh6.Visible:=FormPeach.mRecent6f.Visible;
FormPeach.mexttoh7.Visible:=FormPeach.mRecent7f.Visible;
FormPeach.mexttoh8.Visible:=FormPeach.mRecent8f.Visible;
FormPeach.pnra1.Visible:=FormPeach.mRecent1f.Visible;
FormPeach.pnra2.Visible:=FormPeach.mRecent2f.Visible;
FormPeach.pnra3.Visible:=FormPeach.mRecent3f.Visible;
FormPeach.pnra4.Visible:=FormPeach.mRecent4f.Visible;
FormPeach.pnra5.Visible:=FormPeach.mRecent5f.Visible;
FormPeach.pnra6.Visible:=FormPeach.mRecent6f.Visible;
FormPeach.pnra7.Visible:=FormPeach.mRecent7f.Visible;
FormPeach.pnra8.Visible:=FormPeach.mRecent8f.Visible;
if FormPeach.pnr1.visible=true then FormPeach.pnr1.Bitmap:=FormPeach.mRecent1f.Bitmap;
if FormPeach.pnr2.visible=true then FormPeach.pnr2.Bitmap:=FormPeach.mRecent2f.Bitmap;
if FormPeach.pnr3.visible=true then FormPeach.pnr3.Bitmap:=FormPeach.mRecent3f.Bitmap;
if FormPeach.pnr4.visible=true then FormPeach.pnr4.Bitmap:=FormPeach.mRecent4f.Bitmap;
if FormPeach.pnr5.visible=true then FormPeach.pnr5.Bitmap:=FormPeach.mRecent5f.Bitmap;
if FormPeach.pnr6.visible=true then FormPeach.pnr6.Bitmap:=FormPeach.mRecent6f.Bitmap;
if FormPeach.pnr7.visible=true then FormPeach.pnr7.Bitmap:=FormPeach.mRecent7f.Bitmap;
if FormPeach.pnr8.visible=true then FormPeach.pnr8.Bitmap:=FormPeach.mRecent8f.Bitmap;
if FormPeach.pmemr1.visible=true then FormPeach.pmemr1.Bitmap:=FormPeach.mRecent1f.Bitmap;
if FormPeach.pmemr2.visible=true then FormPeach.pmemr2.Bitmap:=FormPeach.mRecent2f.Bitmap;
if FormPeach.pmemr3.visible=true then FormPeach.pmemr3.Bitmap:=FormPeach.mRecent3f.Bitmap;
if FormPeach.pmemr4.visible=true then FormPeach.pmemr4.Bitmap:=FormPeach.mRecent4f.Bitmap;
if FormPeach.pmemr5.visible=true then FormPeach.pmemr5.Bitmap:=FormPeach.mRecent5f.Bitmap;
if FormPeach.pmemr6.visible=true then FormPeach.pmemr6.Bitmap:=FormPeach.mRecent6f.Bitmap;
if FormPeach.pmemr7.visible=true then FormPeach.pmemr7.Bitmap:=FormPeach.mRecent7f.Bitmap;
if FormPeach.pmemr8.visible=true then FormPeach.pmemr8.Bitmap:=FormPeach.mRecent8f.Bitmap;
if FormPeach.mexttoh1.visible=true then FormPeach.mexttoh1.Bitmap:=FormPeach.mRecent1f.Bitmap;
if FormPeach.mexttoh2.visible=true then FormPeach.mexttoh2.Bitmap:=FormPeach.mRecent2f.Bitmap;
if FormPeach.mexttoh3.visible=true then FormPeach.mexttoh3.Bitmap:=FormPeach.mRecent3f.Bitmap;
if FormPeach.mexttoh4.visible=true then FormPeach.mexttoh4.Bitmap:=FormPeach.mRecent4f.Bitmap;
if FormPeach.mexttoh5.visible=true then FormPeach.mexttoh5.Bitmap:=FormPeach.mRecent5f.Bitmap;
if FormPeach.mexttoh6.visible=true then FormPeach.mexttoh6.Bitmap:=FormPeach.mRecent6f.Bitmap;
if FormPeach.mexttoh7.visible=true then FormPeach.mexttoh7.Bitmap:=FormPeach.mRecent7f.Bitmap;
if FormPeach.mexttoh8.visible=true then FormPeach.mexttoh8.Bitmap:=FormPeach.mRecent8f.Bitmap;
if FormPeach.pnra1.visible=true then FormPeach.pnra1.Bitmap:=FormPeach.mRecent1f.Bitmap;
if FormPeach.pnra2.visible=true then FormPeach.pnra2.Bitmap:=FormPeach.mRecent2f.Bitmap;
if FormPeach.pnra3.visible=true then FormPeach.pnra3.Bitmap:=FormPeach.mRecent3f.Bitmap;
if FormPeach.pnra4.visible=true then FormPeach.pnra4.Bitmap:=FormPeach.mRecent4f.Bitmap;
if FormPeach.pnra5.visible=true then FormPeach.pnra5.Bitmap:=FormPeach.mRecent5f.Bitmap;
if FormPeach.pnra6.visible=true then FormPeach.pnra6.Bitmap:=FormPeach.mRecent6f.Bitmap;
if FormPeach.pnra7.visible=true then FormPeach.pnra7.Bitmap:=FormPeach.mRecent7f.Bitmap;
if FormPeach.pnra8.visible=true then FormPeach.pnra8.Bitmap:=FormPeach.mRecent8f.Bitmap;
FormPeach.pmemrf1.Caption:=FormPeach.mRecent1f.Caption;
FormPeach.pmemrf2.Caption:=FormPeach.mRecent2f.Caption;
FormPeach.pmemrf3.Caption:=FormPeach.mRecent3f.Caption;
FormPeach.pmemrf4.Caption:=FormPeach.mRecent4f.Caption;
FormPeach.pmemrf5.Caption:=FormPeach.mRecent5f.Caption;
FormPeach.pmemrf6.Caption:=FormPeach.mRecent6f.Caption;
FormPeach.pmemrf7.Caption:=FormPeach.mRecent7f.Caption;
FormPeach.pmemrf8.Caption:=FormPeach.mRecent8f.Caption;
FormPeach.pmemrf1.Visible:=FormPeach.mRecent1f.Visible;
FormPeach.pmemrf2.Visible:=FormPeach.mRecent2f.Visible;
FormPeach.pmemrf3.Visible:=FormPeach.mRecent3f.Visible;
FormPeach.pmemrf4.Visible:=FormPeach.mRecent4f.Visible;
FormPeach.pmemrf5.Visible:=FormPeach.mRecent5f.Visible;
FormPeach.pmemrf6.Visible:=FormPeach.mRecent6f.Visible;
FormPeach.pmemrf7.Visible:=FormPeach.mRecent7f.Visible;
FormPeach.pmemrf8.Visible:=FormPeach.mRecent8f.Visible;
if FormPeach.pmemrf1.visible=true then FormPeach.pmemrf1.Bitmap:=FormPeach.mRecent1f.Bitmap;
if FormPeach.pmemrf2.visible=true then FormPeach.pmemrf2.Bitmap:=FormPeach.mRecent2f.Bitmap;
if FormPeach.pmemrf3.visible=true then FormPeach.pmemrf3.Bitmap:=FormPeach.mRecent3f.Bitmap;
if FormPeach.pmemrf4.visible=true then FormPeach.pmemrf4.Bitmap:=FormPeach.mRecent4f.Bitmap;
if FormPeach.pmemrf5.visible=true then FormPeach.pmemrf5.Bitmap:=FormPeach.mRecent5f.Bitmap;
if FormPeach.pmemrf6.visible=true then FormPeach.pmemrf6.Bitmap:=FormPeach.mRecent6f.Bitmap;
if FormPeach.pmemrf7.visible=true then FormPeach.pmemrf7.Bitmap:=FormPeach.mRecent7f.Bitmap;
if FormPeach.pmemrf8.visible=true then FormPeach.pmemrf8.Bitmap:=FormPeach.mRecent8f.Bitmap;
end;

procedure addtofolderhistory(s:ansistring);
begin
if savehistory=0 then exit;
if s<>FormPeach.mRecent1f.Caption then
   if s<>FormPeach.mRecent2f.Caption then
      if s<>FormPeach.mRecent3f.Caption then
         if s<>FormPeach.mRecent4f.Caption then
            if s<>FormPeach.mRecent5f.Caption then
               if s<>FormPeach.mRecent6f.Caption then
                  if s<>FormPeach.mRecent7f.Caption then
                     begin
                     FormPeach.mRecent8f.Caption:=FormPeach.mRecent7f.Caption;
                     FormPeach.mRecent7f.Caption:=FormPeach.mRecent6f.Caption;
                     FormPeach.mRecent6f.Caption:=FormPeach.mRecent5f.Caption;
                     FormPeach.mRecent5f.Caption:=FormPeach.mRecent4f.Caption;
                     FormPeach.mRecent4f.Caption:=FormPeach.mRecent3f.Caption;
                     FormPeach.mRecent3f.Caption:=FormPeach.mRecent2f.Caption;
                     FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
                     FormPeach.mRecent1f.Caption:=s;
                     end
                  else
                     begin
                     FormPeach.mRecent7f.Caption:=FormPeach.mRecent6f.Caption;
                     FormPeach.mRecent6f.Caption:=FormPeach.mRecent5f.Caption;
                     FormPeach.mRecent5f.Caption:=FormPeach.mRecent4f.Caption;
                     FormPeach.mRecent4f.Caption:=FormPeach.mRecent3f.Caption;
                     FormPeach.mRecent3f.Caption:=FormPeach.mRecent2f.Caption;
                     FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
                     FormPeach.mRecent1f.Caption:=s;
                     end
               else
                  begin
                  FormPeach.mRecent6f.Caption:=FormPeach.mRecent5f.Caption;
                  FormPeach.mRecent5f.Caption:=FormPeach.mRecent4f.Caption;
                  FormPeach.mRecent4f.Caption:=FormPeach.mRecent3f.Caption;
                  FormPeach.mRecent3f.Caption:=FormPeach.mRecent2f.Caption;
                  FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
                  FormPeach.mRecent1f.Caption:=s;
                  end
            else
               begin
               FormPeach.mRecent5f.Caption:=FormPeach.mRecent4f.Caption;
               FormPeach.mRecent4f.Caption:=FormPeach.mRecent3f.Caption;
               FormPeach.mRecent3f.Caption:=FormPeach.mRecent2f.Caption;
               FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
               FormPeach.mRecent1f.Caption:=s;
               end
         else
            begin
            FormPeach.mRecent4f.Caption:=FormPeach.mRecent3f.Caption;
            FormPeach.mRecent3f.Caption:=FormPeach.mRecent2f.Caption;
            FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
            FormPeach.mRecent1f.Caption:=s;
            end
      else
         begin
         FormPeach.mRecent3f.Caption:=FormPeach.mRecent2f.Caption;
         FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
         FormPeach.mRecent1f.Caption:=s;
         end
   else
      begin
      FormPeach.mRecent2f.Caption:=FormPeach.mRecent1f.Caption;
      FormPeach.mRecent1f.Caption:=s;
      end;
if FormPeach.mRecent1f.Caption<>'' then FormPeach.mRecent1f.Visible:=true else FormPeach.mRecent1f.Visible:=false;
if FormPeach.mRecent2f.Caption<>'' then FormPeach.mRecent2f.Visible:=true else FormPeach.mRecent2f.Visible:=false;
if FormPeach.mRecent3f.Caption<>'' then FormPeach.mRecent3f.Visible:=true else FormPeach.mRecent3f.Visible:=false;
if FormPeach.mRecent4f.Caption<>'' then FormPeach.mRecent4f.Visible:=true else FormPeach.mRecent4f.Visible:=false;
if FormPeach.mRecent5f.Caption<>'' then FormPeach.mRecent5f.Visible:=true else FormPeach.mRecent5f.Visible:=false;
if FormPeach.mRecent6f.Caption<>'' then FormPeach.mRecent6f.Visible:=true else FormPeach.mRecent6f.Visible:=false;
if FormPeach.mRecent7f.Caption<>'' then FormPeach.mRecent7f.Visible:=true else FormPeach.mRecent7f.Visible:=false;
if FormPeach.mRecent8f.Caption<>'' then FormPeach.mRecent8f.Visible:=true else FormPeach.mRecent8f.Visible:=false;
FormPeach.pmhr1f.Caption:=FormPeach.mRecent1f.Caption;
FormPeach.pmhr2f.Caption:=FormPeach.mRecent2f.Caption;
FormPeach.pmhr3f.Caption:=FormPeach.mRecent3f.Caption;
FormPeach.pmhr4f.Caption:=FormPeach.mRecent4f.Caption;
FormPeach.pmhr5f.Caption:=FormPeach.mRecent5f.Caption;
FormPeach.pmhr6f.Caption:=FormPeach.mRecent6f.Caption;
FormPeach.pmhr7f.Caption:=FormPeach.mRecent7f.Caption;
FormPeach.pmhr8f.Caption:=FormPeach.mRecent8f.Caption;
FormPeach.pmhr1f.Visible:=FormPeach.mRecent1f.Visible;
FormPeach.pmhr2f.Visible:=FormPeach.mRecent2f.Visible;
FormPeach.pmhr3f.Visible:=FormPeach.mRecent3f.Visible;
FormPeach.pmhr4f.Visible:=FormPeach.mRecent4f.Visible;
FormPeach.pmhr5f.Visible:=FormPeach.mRecent5f.Visible;
FormPeach.pmhr6f.Visible:=FormPeach.mRecent6f.Visible;
FormPeach.pmhr7f.Visible:=FormPeach.mRecent7f.Visible;
FormPeach.pmhr8f.Visible:=FormPeach.mRecent8f.Visible;
setrecenticons_extract_archive;
populaterecenticonsf;
populaterecentpanel;
populatetree;
end;

procedure addtoarchivehistory(s:ansistring);
begin
if savehistory=0 then exit;
if s<>FormPeach.mRecent1.Caption then
   if s<>FormPeach.mRecent2.Caption then
      if s<>FormPeach.mRecent3.Caption then
         if s<>FormPeach.mRecent4.Caption then
            if s<>FormPeach.mRecent5.Caption then
               if s<>FormPeach.mRecent6.Caption then
                  if s<>FormPeach.mRecent7.Caption then
                     begin
                     FormPeach.mRecent8.Caption:=FormPeach.mRecent7.Caption;
                     FormPeach.mRecent7.Caption:=FormPeach.mRecent6.Caption;
                     FormPeach.mRecent6.Caption:=FormPeach.mRecent5.Caption;
                     FormPeach.mRecent5.Caption:=FormPeach.mRecent4.Caption;
                     FormPeach.mRecent4.Caption:=FormPeach.mRecent3.Caption;
                     FormPeach.mRecent3.Caption:=FormPeach.mRecent2.Caption;
                     FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
                     FormPeach.mRecent1.Caption:=s;
                     end
                  else
                     begin
                     FormPeach.mRecent7.Caption:=FormPeach.mRecent6.Caption;
                     FormPeach.mRecent6.Caption:=FormPeach.mRecent5.Caption;
                     FormPeach.mRecent5.Caption:=FormPeach.mRecent4.Caption;
                     FormPeach.mRecent4.Caption:=FormPeach.mRecent3.Caption;
                     FormPeach.mRecent3.Caption:=FormPeach.mRecent2.Caption;
                     FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
                     FormPeach.mRecent1.Caption:=s;
                     end
               else
                  begin
                  FormPeach.mRecent6.Caption:=FormPeach.mRecent5.Caption;
                  FormPeach.mRecent5.Caption:=FormPeach.mRecent4.Caption;
                  FormPeach.mRecent4.Caption:=FormPeach.mRecent3.Caption;
                  FormPeach.mRecent3.Caption:=FormPeach.mRecent2.Caption;
                  FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
                  FormPeach.mRecent1.Caption:=s;
                  end
            else
               begin
               FormPeach.mRecent5.Caption:=FormPeach.mRecent4.Caption;
               FormPeach.mRecent4.Caption:=FormPeach.mRecent3.Caption;
               FormPeach.mRecent3.Caption:=FormPeach.mRecent2.Caption;
               FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
               FormPeach.mRecent1.Caption:=s;
               end
         else
            begin
            FormPeach.mRecent4.Caption:=FormPeach.mRecent3.Caption;
            FormPeach.mRecent3.Caption:=FormPeach.mRecent2.Caption;
            FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
            FormPeach.mRecent1.Caption:=s;
            end
      else
         begin
         FormPeach.mRecent3.Caption:=FormPeach.mRecent2.Caption;
         FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
         FormPeach.mRecent1.Caption:=s;
         end
   else
      begin
      FormPeach.mRecent2.Caption:=FormPeach.mRecent1.Caption;
      FormPeach.mRecent1.Caption:=s;
      end;
if FormPeach.mRecent1.Caption<>'' then FormPeach.mRecent1.Visible:=true else FormPeach.mRecent1.Visible:=false;
if FormPeach.mRecent2.Caption<>'' then FormPeach.mRecent2.Visible:=true else FormPeach.mRecent2.Visible:=false;
if FormPeach.mRecent3.Caption<>'' then FormPeach.mRecent3.Visible:=true else FormPeach.mRecent3.Visible:=false;
if FormPeach.mRecent4.Caption<>'' then FormPeach.mRecent4.Visible:=true else FormPeach.mRecent4.Visible:=false;
if FormPeach.mRecent5.Caption<>'' then FormPeach.mRecent5.Visible:=true else FormPeach.mRecent5.Visible:=false;
if FormPeach.mRecent6.Caption<>'' then FormPeach.mRecent6.Visible:=true else FormPeach.mRecent6.Visible:=false;
if FormPeach.mRecent7.Caption<>'' then FormPeach.mRecent7.Visible:=true else FormPeach.mRecent7.Visible:=false;
if FormPeach.mRecent8.Caption<>'' then FormPeach.mRecent8.Visible:=true else FormPeach.mRecent8.Visible:=false;
FormPeach.pmhr1.Caption:=FormPeach.mRecent1.Caption;
FormPeach.pmhr2.Caption:=FormPeach.mRecent2.Caption;
FormPeach.pmhr3.Caption:=FormPeach.mRecent3.Caption;
FormPeach.pmhr4.Caption:=FormPeach.mRecent4.Caption;
FormPeach.pmhr5.Caption:=FormPeach.mRecent5.Caption;
FormPeach.pmhr6.Caption:=FormPeach.mRecent6.Caption;
FormPeach.pmhr7.Caption:=FormPeach.mRecent7.Caption;
FormPeach.pmhr8.Caption:=FormPeach.mRecent8.Caption;
FormPeach.pmhr1.Visible:=FormPeach.mRecent1.Visible;
FormPeach.pmhr2.Visible:=FormPeach.mRecent2.Visible;
FormPeach.pmhr3.Visible:=FormPeach.mRecent3.Visible;
FormPeach.pmhr4.Visible:=FormPeach.mRecent4.Visible;
FormPeach.pmhr5.Visible:=FormPeach.mRecent5.Visible;
FormPeach.pmhr6.Visible:=FormPeach.mRecent6.Visible;
FormPeach.pmhr7.Visible:=FormPeach.mRecent7.Visible;
FormPeach.pmhr8.Visible:=FormPeach.mRecent8.Visible;
FormPeach.pmamr1.Caption:=(FormPeach.mRecent1.Caption);
FormPeach.pmamr2.Caption:=(FormPeach.mRecent2.Caption);
FormPeach.pmamr3.Caption:=(FormPeach.mRecent3.Caption);
FormPeach.pmamr4.Caption:=(FormPeach.mRecent4.Caption);
FormPeach.pmamr5.Caption:=(FormPeach.mRecent5.Caption);
FormPeach.pmamr6.Caption:=(FormPeach.mRecent6.Caption);
FormPeach.pmamr7.Caption:=(FormPeach.mRecent7.Caption);
FormPeach.pmamr8.Caption:=(FormPeach.mRecent8.Caption);
FormPeach.pmamr1.Visible:=FormPeach.mRecent1.Visible;
FormPeach.pmamr2.Visible:=FormPeach.mRecent2.Visible;
FormPeach.pmamr3.Visible:=FormPeach.mRecent3.Visible;
FormPeach.pmamr4.Visible:=FormPeach.mRecent4.Visible;
FormPeach.pmamr5.Visible:=FormPeach.mRecent5.Visible;
FormPeach.pmamr6.Visible:=FormPeach.mRecent6.Visible;
FormPeach.pmamr7.Visible:=FormPeach.mRecent7.Visible;
FormPeach.pmamr8.Visible:=FormPeach.mRecent8.Visible;
addtofolderhistory(extractfilepath(s));
populaterecenticons;
populaterecentpanel;
populatetree;
end;

procedure addtocustomhistory(s:ansistring);
begin
if s<>FormPeach.pcustom1.Caption then
   if s<>FormPeach.pcustom2.Caption then
      if s<>FormPeach.pcustom3.Caption then
         if s<>FormPeach.pcustom4.Caption then
            if s<>FormPeach.pcustom5.Caption then
               if s<>FormPeach.pcustom6.Caption then
                  if s<>FormPeach.pcustom7.Caption then
                     begin
                     FormPeach.pcustom8.Caption:=FormPeach.pcustom7.Caption;
                     FormPeach.pcustom7.Caption:=FormPeach.pcustom6.Caption;
                     FormPeach.pcustom6.Caption:=FormPeach.pcustom5.Caption;
                     FormPeach.pcustom5.Caption:=FormPeach.pcustom4.Caption;
                     FormPeach.pcustom4.Caption:=FormPeach.pcustom3.Caption;
                     FormPeach.pcustom3.Caption:=FormPeach.pcustom2.Caption;
                     FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
                     FormPeach.pcustom1.Caption:=s;
                     end
                  else
                     begin
                     FormPeach.pcustom7.Caption:=FormPeach.pcustom6.Caption;
                     FormPeach.pcustom6.Caption:=FormPeach.pcustom5.Caption;
                     FormPeach.pcustom5.Caption:=FormPeach.pcustom4.Caption;
                     FormPeach.pcustom4.Caption:=FormPeach.pcustom3.Caption;
                     FormPeach.pcustom3.Caption:=FormPeach.pcustom2.Caption;
                     FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
                     FormPeach.pcustom1.Caption:=s;
                     end
               else
                  begin
                  FormPeach.pcustom6.Caption:=FormPeach.pcustom5.Caption;
                  FormPeach.pcustom5.Caption:=FormPeach.pcustom4.Caption;
                  FormPeach.pcustom4.Caption:=FormPeach.pcustom3.Caption;
                  FormPeach.pcustom3.Caption:=FormPeach.pcustom2.Caption;
                  FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
                  FormPeach.pcustom1.Caption:=s;
                  end
            else
               begin
               FormPeach.pcustom5.Caption:=FormPeach.pcustom4.Caption;
               FormPeach.pcustom4.Caption:=FormPeach.pcustom3.Caption;
               FormPeach.pcustom3.Caption:=FormPeach.pcustom2.Caption;
               FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
               FormPeach.pcustom1.Caption:=s;
               end
         else
            begin
            FormPeach.pcustom4.Caption:=FormPeach.pcustom3.Caption;
            FormPeach.pcustom3.Caption:=FormPeach.pcustom2.Caption;
            FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
            FormPeach.pcustom1.Caption:=s;
            end
      else
         begin
         FormPeach.pcustom3.Caption:=FormPeach.pcustom2.Caption;
         FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
         FormPeach.pcustom1.Caption:=s;
         end
   else
      begin
      FormPeach.pcustom2.Caption:=FormPeach.pcustom1.Caption;
      FormPeach.pcustom1.Caption:=s;
      end;
if FormPeach.pcustom1.Caption<>'' then FormPeach.pcustom1.Visible:=true else FormPeach.pcustom1.Visible:=false;
if FormPeach.pcustom2.Caption<>'' then FormPeach.pcustom2.Visible:=true else FormPeach.pcustom2.Visible:=false;
if FormPeach.pcustom3.Caption<>'' then FormPeach.pcustom3.Visible:=true else FormPeach.pcustom3.Visible:=false;
if FormPeach.pcustom4.Caption<>'' then FormPeach.pcustom4.Visible:=true else FormPeach.pcustom4.Visible:=false;
if FormPeach.pcustom5.Caption<>'' then FormPeach.pcustom5.Visible:=true else FormPeach.pcustom5.Visible:=false;
if FormPeach.pcustom6.Caption<>'' then FormPeach.pcustom6.Visible:=true else FormPeach.pcustom6.Visible:=false;
if FormPeach.pcustom7.Caption<>'' then FormPeach.pcustom7.Visible:=true else FormPeach.pcustom7.Visible:=false;
if FormPeach.pcustom8.Caption<>'' then FormPeach.pcustom8.Visible:=true else FormPeach.pcustom8.Visible:=false;
end;

procedure sethistory;
begin
   if FormPeach.mRecent1.Caption<>'' then FormPeach.mRecent1.Visible:=true else FormPeach.mRecent1.Visible:=false;
   if FormPeach.mRecent2.Caption<>'' then FormPeach.mRecent2.Visible:=true else FormPeach.mRecent2.Visible:=false;
   if FormPeach.mRecent3.Caption<>'' then FormPeach.mRecent3.Visible:=true else FormPeach.mRecent3.Visible:=false;
   if FormPeach.mRecent4.Caption<>'' then FormPeach.mRecent4.Visible:=true else FormPeach.mRecent4.Visible:=false;
   if FormPeach.mRecent5.Caption<>'' then FormPeach.mRecent5.Visible:=true else FormPeach.mRecent5.Visible:=false;
   if FormPeach.mRecent6.Caption<>'' then FormPeach.mRecent6.Visible:=true else FormPeach.mRecent6.Visible:=false;
   if FormPeach.mRecent7.Caption<>'' then FormPeach.mRecent7.Visible:=true else FormPeach.mRecent7.Visible:=false;
   if FormPeach.mRecent8.Caption<>'' then FormPeach.mRecent8.Visible:=true else FormPeach.mRecent8.Visible:=false;
   FormPeach.pmhr1.Visible:=FormPeach.mRecent1.Visible;
   FormPeach.pmhr2.Visible:=FormPeach.mRecent2.Visible;
   FormPeach.pmhr3.Visible:=FormPeach.mRecent3.Visible;
   FormPeach.pmhr4.Visible:=FormPeach.mRecent4.Visible;
   FormPeach.pmhr5.Visible:=FormPeach.mRecent5.Visible;
   FormPeach.pmhr6.Visible:=FormPeach.mRecent6.Visible;
   FormPeach.pmhr7.Visible:=FormPeach.mRecent7.Visible;
   FormPeach.pmhr8.Visible:=FormPeach.mRecent8.Visible;
   FormPeach.pmamr1.Caption:=(FormPeach.mRecent1.Caption);
   FormPeach.pmamr2.Caption:=(FormPeach.mRecent2.Caption);
   FormPeach.pmamr3.Caption:=(FormPeach.mRecent3.Caption);
   FormPeach.pmamr4.Caption:=(FormPeach.mRecent4.Caption);
   FormPeach.pmamr5.Caption:=(FormPeach.mRecent5.Caption);
   FormPeach.pmamr6.Caption:=(FormPeach.mRecent6.Caption);
   FormPeach.pmamr7.Caption:=(FormPeach.mRecent7.Caption);
   FormPeach.pmamr8.Caption:=(FormPeach.mRecent8.Caption);
   FormPeach.pmamr1.Visible:=FormPeach.mRecent1.Visible;
   FormPeach.pmamr2.Visible:=FormPeach.mRecent2.Visible;
   FormPeach.pmamr3.Visible:=FormPeach.mRecent3.Visible;
   FormPeach.pmamr4.Visible:=FormPeach.mRecent4.Visible;
   FormPeach.pmamr5.Visible:=FormPeach.mRecent5.Visible;
   FormPeach.pmamr6.Visible:=FormPeach.mRecent6.Visible;
   FormPeach.pmamr7.Visible:=FormPeach.mRecent7.Visible;
   FormPeach.pmamr8.Visible:=FormPeach.mRecent8.Visible;
   if FormPeach.mRecent1f.Caption<>'' then FormPeach.mRecent1f.Visible:=true else FormPeach.mRecent1f.Visible:=false;
   if FormPeach.mRecent2f.Caption<>'' then FormPeach.mRecent2f.Visible:=true else FormPeach.mRecent2f.Visible:=false;
   if FormPeach.mRecent3f.Caption<>'' then FormPeach.mRecent3f.Visible:=true else FormPeach.mRecent3f.Visible:=false;
   if FormPeach.mRecent4f.Caption<>'' then FormPeach.mRecent4f.Visible:=true else FormPeach.mRecent4f.Visible:=false;
   if FormPeach.mRecent5f.Caption<>'' then FormPeach.mRecent5f.Visible:=true else FormPeach.mRecent5f.Visible:=false;
   if FormPeach.mRecent6f.Caption<>'' then FormPeach.mRecent6f.Visible:=true else FormPeach.mRecent6f.Visible:=false;
   if FormPeach.mRecent7f.Caption<>'' then FormPeach.mRecent7f.Visible:=true else FormPeach.mRecent7f.Visible:=false;
   if FormPeach.mRecent8f.Caption<>'' then FormPeach.mRecent8f.Visible:=true else FormPeach.mRecent8f.Visible:=false;
   FormPeach.pmhr1f.Visible:=FormPeach.mRecent1f.Visible;
   FormPeach.pmhr2f.Visible:=FormPeach.mRecent2f.Visible;
   FormPeach.pmhr3f.Visible:=FormPeach.mRecent3f.Visible;
   FormPeach.pmhr4f.Visible:=FormPeach.mRecent4f.Visible;
   FormPeach.pmhr5f.Visible:=FormPeach.mRecent5f.Visible;
   FormPeach.pmhr6f.Visible:=FormPeach.mRecent6f.Visible;
   FormPeach.pmhr7f.Visible:=FormPeach.mRecent7f.Visible;
   FormPeach.pmhr8f.Visible:=FormPeach.mRecent8f.Visible;
   FormPeach.pnr1.Visible:=FormPeach.mRecent1f.Visible;
   FormPeach.pnr2.Visible:=FormPeach.mRecent2f.Visible;
   FormPeach.pnr3.Visible:=FormPeach.mRecent3f.Visible;
   FormPeach.pnr4.Visible:=FormPeach.mRecent4f.Visible;
   FormPeach.pnr5.Visible:=FormPeach.mRecent5f.Visible;
   FormPeach.pnr6.Visible:=FormPeach.mRecent6f.Visible;
   FormPeach.pnr7.Visible:=FormPeach.mRecent7f.Visible;
   FormPeach.pnr8.Visible:=FormPeach.mRecent8f.Visible;
   FormPeach.pmemr1.Visible:=FormPeach.mRecent1f.Visible;
   FormPeach.pmemr2.Visible:=FormPeach.mRecent2f.Visible;
   FormPeach.pmemr3.Visible:=FormPeach.mRecent3f.Visible;
   FormPeach.pmemr4.Visible:=FormPeach.mRecent4f.Visible;
   FormPeach.pmemr5.Visible:=FormPeach.mRecent5f.Visible;
   FormPeach.pmemr6.Visible:=FormPeach.mRecent6f.Visible;
   FormPeach.pmemr7.Visible:=FormPeach.mRecent7f.Visible;
   FormPeach.pmemr8.Visible:=FormPeach.mRecent8f.Visible;
   FormPeach.mexttoh1.Visible:=FormPeach.mRecent1f.Visible;
   FormPeach.mexttoh2.Visible:=FormPeach.mRecent2f.Visible;
   FormPeach.mexttoh3.Visible:=FormPeach.mRecent3f.Visible;
   FormPeach.mexttoh4.Visible:=FormPeach.mRecent4f.Visible;
   FormPeach.mexttoh5.Visible:=FormPeach.mRecent5f.Visible;
   FormPeach.mexttoh6.Visible:=FormPeach.mRecent6f.Visible;
   FormPeach.mexttoh7.Visible:=FormPeach.mRecent7f.Visible;
   FormPeach.mexttoh8.Visible:=FormPeach.mRecent8f.Visible;
   FormPeach.pmemrf1.Visible:=FormPeach.mRecent1f.Visible;
   FormPeach.pmemrf2.Visible:=FormPeach.mRecent2f.Visible;
   FormPeach.pmemrf3.Visible:=FormPeach.mRecent3f.Visible;
   FormPeach.pmemrf4.Visible:=FormPeach.mRecent4f.Visible;
   FormPeach.pmemrf5.Visible:=FormPeach.mRecent5f.Visible;
   FormPeach.pmemrf6.Visible:=FormPeach.mRecent6f.Visible;
   FormPeach.pmemrf7.Visible:=FormPeach.mRecent7f.Visible;
   FormPeach.pmemrf8.Visible:=FormPeach.mRecent8f.Visible;
   FormPeach.pnra1.Visible:=FormPeach.mRecent1f.Visible;
   FormPeach.pnra2.Visible:=FormPeach.mRecent2f.Visible;
   FormPeach.pnra3.Visible:=FormPeach.mRecent3f.Visible;
   FormPeach.pnra4.Visible:=FormPeach.mRecent4f.Visible;
   FormPeach.pnra5.Visible:=FormPeach.mRecent5f.Visible;
   FormPeach.pnra6.Visible:=FormPeach.mRecent6f.Visible;
   FormPeach.pnra7.Visible:=FormPeach.mRecent7f.Visible;
   FormPeach.pnra8.Visible:=FormPeach.mRecent8f.Visible;
end;

procedure settonewfolder(i:integer);
begin
with FormPeach do
begin
case i of
  0: begin
     MenuItemOpen_ExtractHere.Bitmap:=Bextractall;
     po_exthere.Bitmap:=Bextractall;
     pmqeto.Bitmap:=Bextractall;
     MenuItemExtAllTo.Bitmap:=Bextractall;
     ButtonUn7zaTo.Hint:=txt_ext_sel;
     if toolsize<3 then
        begin
        ButtonUn7zaTo.Glyph:=Bextractall_big;
        end
     else
        if toolsize<6 then
           begin
           ButtonUn7zaTo.Glyph:=Bextractall;
           end;
     ImageFlatext.Glyph:=Bextractall;
     ImageFlatext.Hint:=txt_ext_sel;
     LabelExtHere.Caption:=txt_ext_here;
     end;
  1: begin
     MenuItemOpen_ExtractHere.Bitmap:=Bextractalln;
     po_exthere.Bitmap:=Bextractalln;
     pmqeto.Bitmap:=Bextractalln;
     MenuItemExtAllTo.Bitmap:=Bextractalln;
     ButtonUn7zaTo.Hint:=txt_caption_extract+' '+txt_newfolder;
     if toolsize<3 then
        begin
        ButtonUn7zaTo.Glyph:=Bextractalln_big;
        end
     else
        if toolsize<6 then
           begin
           ButtonUn7zaTo.Glyph:=Bextractalln;
           end;
     ImageFlatext.Glyph:=Bextractalln;
     ImageFlatext.Hint:=txt_caption_extract+' '+txt_newfolder;
     if removeintdir=1 then LabelExtHere.Caption:=txt_9_8_fsmart else LabelExtHere.Caption:=txt_9_8_fnew;
     end;
  end;
end;
populatetree;
end;

procedure setnamingpolicymenu(enmenu:boolean);
begin
with FormPeach do
begin
pmqen1.enabled:=enmenu;
pmqen2.enabled:=enmenu;
pmqen3.enabled:=enmenu;
pmqen4.enabled:=enmenu;
pmqen5.enabled:=enmenu;
end;
end;

procedure setquickextractmenu;
var
   curpath:ansistring;
begin
with FormPeach do
begin
if EditOpenIn.Text<>txt_mypc then
   if (fun='FILEBROWSER') then curpath:=EditOpenIn.Text
   else curpath:=extractfilepath(EditOpenIn.Text)
else curpath:='';
if curpath<>'' then
   if curpath[length(curpath)] <> directoryseparator then curpath:=curpath+directoryseparator;

//set quick extraction menu
if (defaultextractpath<>'') then
      begin
      pmqedefault.visible:=true;
      pmqedefault.caption:=txt_ext_allto+' '+defaultextractpath+' (Ctrl+9)';
      end
   else pmqedefault.visible:=false;
if (lastextractionpath<>'') then
      begin
      pmqelast.visible:=true;
      pmqelast.caption:=txt_ext_allto+' '+lastextractionpath+' (Ctrl+0)';
      end
   else pmqelast.visible:=false;
if (extractfilepath(pnb1.Caption)<>'') and
   (extractfilepath(pnb1.Caption)<>lastextractionpath) then
      begin
      pmqe1fav.visible:=true;
      pmqe1fav.caption:=txt_ext_allto+' '+extractfilepath(pnb1.Caption)+' (Ctrl+1)';
      end
   else pmqe1fav.visible:=false;
if (extractfilepath(pnb2.Caption)<>'') and
   (extractfilepath(pnb2.Caption)<>extractfilepath(pnb1.Caption)) and
   (extractfilepath(pnb2.Caption)<>lastextractionpath) then
      begin
      pmqe2fav.visible:=true;
      pmqe2fav.caption:=txt_ext_allto+' '+extractfilepath(pnb2.Caption)+' (Ctrl+2)';
      end
   else pmqe2fav.visible:=false;
if (extractfilepath(pnb3.Caption)<>'')  and
   (extractfilepath(pnb3.Caption)<>extractfilepath(pnb1.Caption)) and
   (extractfilepath(pnb3.Caption)<>extractfilepath(pnb2.Caption)) and
   (extractfilepath(pnb3.Caption)<>lastextractionpath) then
      begin
      pmqe3fav.visible:=true;
      pmqe3fav.caption:=txt_ext_allto+' '+extractfilepath(pnb3.Caption)+' (Ctrl+3)';
      end
   else pmqe3fav.visible:=false;
if (fun='FILEBROWSER') or (fun='UN7Z') then setnamingpolicymenu(true)
else setnamingpolicymenu(false);
end;
end;

function testname(name:ansistring; sg:TStringGrid):integer; //test if an object is already listed in the stringgrid
var
   i:integer;
begin
testname:=1;
if checkfiledirname(name)<>0 then begin pMessageWarningOK(txt_2_7_validatefn+' '+name); exit; end;
for i:=1 to sg.RowCount-1 do
   if sg.Cells[8,i]=name then
      begin
      testname:=1;
      exit;
      end;
testname:=0;
end;

procedure deselectingrid(sg:tstringgrid);
var
   i:integer;
begin
if sg.Rowcount<2 then exit;
if sg.ColCount<12 then exit;
for i:=1 to sg.Rowcount-1 do
   sg.Cells[11,i]:='0';
end;

procedure addfilestr(sg:TStringGrid; filename:ansistring);
var
   fsize:qword;
   s:ansistring;
   rc,iext:integer;
begin
if sg=FormPeach.StringGridAdd then
   begin
   try
   srcfilesize(filename,fsize);
   rc:=sg.Rowcount+1;
   sg.RowCount:=rc;
   sg.Cells[0,rc-1]:='';
   sg.Cells[1,rc-1]:=extractfilename(filename);
   sg.Cells[2,rc-1]:=extractfileext(filename);
   try sg.Cells[3,rc-1]:=nicenumber(inttostr(fsize),filesizebase); except end;
   sg.Cells[4,rc-1]:='0';
   sg.Cells[5,rc-1]:='1';
   try sg.Cells[6,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss', filedatetodatetime(fileage(filename)));
   dword2decodedFileAttributes(filegetattr(filename),s);
   sg.Cells[7,rc-1]:=s; except end;
   sg.Cells[8,rc-1]:=filename;
   sg.Cells[9,rc-1]:=prefixf+filename;
   sg.Cells[12,rc-1]:=inttostr(fsize);
   sg.Cells[10,rc-1]:=inttostr(length(inttostr(length(sg.Cells[12,rc-1]))))+inttostr(length(sg.Cells[12,rc-1]))+sg.Cells[12,rc-1];
   sg.Cells[11,rc-1]:='0';
   tpcomp:=testpcomp(filename);
   sg.Cells[15,rc-1]:=inttostr(fsize*tpcomp);
   except
   exit;
   end;
   end
else
   begin
   try
   if (sg=FormPeach.StringGridExtract) then srcfilesize_multipart(filename,fsize)
   else srcfilesize(filename,fsize);
   rc:=sg.Rowcount+1;
   sg.RowCount:=rc;
   sg.Cells[0,rc-1]:='';
   sg.Cells[1,rc-1]:=extractfilename(filename);
   sg.Cells[2,rc-1]:=extractfileext(filename);
   sg.Cells[3,rc-1]:=nicenumber(inttostr(fsize),filesizebase);
   sg.Cells[4,rc-1]:='';
   iext:=testext(filename);
   if sg=FormPeach.StringGridExtract then
      if iext>=0 then
         if (iext>=500) and (iext<=503) then
                           sg.Cells[4,rc-1]:='.'
                        else
                           sg.Cells[4,rc-1]:='+';
   sg.Cells[5,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss', filedatetodatetime(fileage(filename)));
   dword2decodedFileAttributes(filegetattr(filename),s);
   sg.Cells[6,rc-1]:=s;
   sg.Cells[7,rc-1]:='';
   sg.Cells[8,rc-1]:=filename;
   sg.Cells[9,rc-1]:=prefixf+filename;
   sg.Cells[12,rc-1]:=inttostr(fsize);
   sg.Cells[10,rc-1]:=inttostr(length(inttostr(length(sg.Cells[12,rc-1]))))+inttostr(length(sg.Cells[12,rc-1]))+sg.Cells[12,rc-1];
   sg.Cells[11,rc-1]:='0';
   except
   exit;
   end;
   end;
end;

function rListint(mode: string;
  dir, mask: ansistring;
  fattrib: qword;
  recur: boolean;
  var nfiles, ndirs: qword;
  var flist: TFoundList;
  var fsizes: TFoundListSizes;
  var ftimes: TFoundListAges;
  var fattr: TFoundListAttrib;
  var fattr_dec: TFoundList
  ): integer;
var
  r: TSearchRec;
begin
  result := 1;
  Inc(ndirs, 1);
  if FindFirst(dir + mask, fattrib, r) = 0 then
  begin
    try
      if upcase(mode) = 'DETAILS' then
        repeat
          if ((r.Name <> '.') and (r.Name <> '..')) then
          begin
            SetLength(flist, nfiles + 1);
            SetLength(fsizes, nfiles + 1);
            SetLength(ftimes, nfiles + 1);
            SetLength(fattr, nfiles + 1);
            SetLength(fattr_dec, nfiles + 1);
            flist[nfiles] := dir + (r.Name);
            if (r.Attr and faDirectory <> 0) then
            begin
              if flist[nfiles][length(flist[nfiles])] <> DirectorySeparator then
                flist[nfiles] := flist[nfiles] + DirectorySeparator;
              Inc(ndirs, 1);
            end;
            fsizes[nfiles] := r.Size;
            ftimes[nfiles] := r.Time;
            fattr[nfiles] := r.Attr;
            dword2decodedFileAttributes(r.Attr, fattr_dec[nfiles]);
            Inc(nfiles, 1);
            if nfiles and ((1024)-1) = 0 then Application.ProcessMessages;
          end;
        until findnext(r) <> 0;
    except
      FindClose(r);
      result := 2;
      exit;
    end;
    FindClose(r);
  end;
  if recur = True then
    if FindFirst(dir + '*', fattrib or faDirectory, r) = 0 then
    begin
      try
        repeat
          if ((r.Attr and faDirectory) <> 0) and (r.Name <> '.') and
            (r.Name <> '..') then
          begin
            rListint(mode, dir + (r.Name) +
              DirectorySeparator, mask, fattrib, recur, nfiles, ndirs, flist, fsizes, ftimes, fattr, fattr_dec);
            Dec(ndirs, 1);
            application.ProcessMessages;
          end;
        until findnext(r) <> 0;
      except
        FindClose(r);
        result := 4;
        exit;
      end;
      FindClose(r);
    end;
  if result = 1 then
    result := 0;
end;

function dirsizetcint(path, mask: ansistring;
  fattrib: qword;
  recur: boolean;
  addtofirstobj: boolean;
  var nfiles, ndirs: qword;
  var size, tcsize: qword
  ): integer;
var
  i,tpcomp: integer;
  dir: ansistring;
  flist: TFoundList;
  fsizes: TFoundListSizes;
  ftimes: TFoundListAges;
  fattr: TFoundListAttrib;
  fattr_dec: TFoundList;
begin
  result := 1;
  if addtofirstobj = True then
    nfiles := 1
  else
    nfiles := 0;
  ndirs := 0;
  size := 0;
  tcsize := 0;
  try
    //check for valid path, else set executable path as path
    if length(path) = 0 then
       begin
       result := 4;
       exit;
       end
    else
       dir := path;
    //check for directoryseparator at the end of the path (needed)
    if dir<>'' then
      if dir[length(dir)] <> DirectorySeparator then
      dir := dir + DirectorySeparator;
    result := rListint('DETAILS', dir, mask, fattrib, recur, nfiles, ndirs, flist,
      fsizes, ftimes, fattr, fattr_dec);
    if addtofirstobj = False then
      ndirs := ndirs - 1;
    for i := 0 to length(fsizes) - 1 do
      begin
      size := size + fsizes[i];
      tpcomp:=testpcomp(flist[i]);
      tcsize := tcsize+ (fsizes[i] * tpcomp);
      end;
  except
    result := 4;
    exit;
  end;
  if result = 1 then
    result := 0;
end;

procedure addfolderstr(sg:TStringGrid; foldername:ansistring);
var
   r:TSearchRec;
   s:ansistring;
   nfiles,ndirs,size,tpcompsize:qword;
   rc:integer;
begin
rc:=sg.Rowcount+1;
sg.RowCount:=rc;
sg.Cells[0,rc-1]:='';
sg.Cells[1,rc-1]:=extractfilename(foldername);
if (extractfilename(foldername)='') and (foldername<>'') then sg.Cells[1,rc-1]:=copy(foldername,1,1);
sg.Cells[2,rc-1]:=txt_list_isfolder;
sg.Cells[3,rc-1]:='0 B';
sg.Cells[4,rc-1]:='1';
sg.Cells[5,rc-1]:='0';
if FindFirst(foldername+'.',faDirectory,r) = 0 then
   begin
   sg.Cells[6,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss', filedatetodatetime(r.Time));
   dword2decodedFileAttributes(r.Attr,s);
   sg.Cells[7,rc-1]:=s;
   end;
FindClose(r);
sg.Cells[8,rc-1]:=foldername;
sg.Cells[9,rc-1]:=prefixd+foldername;
sg.Cells[10,rc-1]:='0';
sg.Cells[11,rc-1]:='0';
sg.Cells[12,rc-1]:='0';
sg.Cells[15,rc-1]:='0';
if (tmpenumd=true) then
   begin
   //enumerate content
   if sg=FormPeach.StringGridAdd then DirSizetcint(foldername,'*',FaAnyFile,true,true,nfiles,ndirs,size,tpcompsize)
      else DirSize(foldername,'*',FaAnyFile,true,true,nfiles,ndirs,size);
   if sg.Rowcount=1 then exit;
   sg.Cells[3,rc-1]:=nicenumber(inttostr(size),filesizebase);
   sg.Cells[4,rc-1]:=inttostr(ndirs);
   sg.Cells[5,rc-1]:=inttostr(nfiles-ndirs);
   sg.Cells[12,rc-1]:=inttostr(size);
   sg.Cells[10,rc-1]:=inttostr(length(inttostr(length(sg.Cells[12,rc-1]))))+inttostr(length(sg.Cells[12,rc-1]))+sg.Cells[12,rc-1];
   sg.Cells[15,rc-1]:=inttostr(tpcompsize);
   end;
end;

procedure autosize_stringgrid1;
begin
FormPeach.StringGridAdd.AutoSizeColumns;
FormPeach.StringGridAdd.ColWidths[0]:=rowsize;
FormPeach.StringGridAdd.ColWidths[1]:=COL1D;
FormPeach.StringGridAdd.ColWidths[9]:=0;
FormPeach.StringGridAdd.ColWidths[10]:=0;
FormPeach.StringGridAdd.ColWidths[11]:=0;
FormPeach.StringGridAdd.ColWidths[12]:=0;
FormPeach.StringGridAdd.colwidths[13]:=0;
FormPeach.StringGridAdd.colwidths[14]:=0;
FormPeach.StringGridAdd.colwidths[15]:=0;
end;

procedure autosize_stringgrid2;
begin
with FormPeach do
begin
StringGridExtract.AutoSizeColumns;
StringGridExtract.ColWidths[0]:=rowsize;
StringGridExtract.ColWidths[1]:=COL1D;
StringGridExtract.ColWidths[9]:=0;
StringGridExtract.ColWidths[10]:=0;
StringGridExtract.ColWidths[11]:=0;
StringGridExtract.ColWidths[12]:=0;
StringGridExtract.colwidths[13]:=0;
StringGridExtract.colwidths[14]:=0;
StringGridExtract.colwidths[15]:=0;
end;
end;

procedure hide_panelhintadd;
begin
FormPeach.PanelHintAdd.Visible:=false;
FormPeach.StringGridAdd.Hint:=txt_2_7_archivehint;
end;

procedure hide_panelhintextract;
begin
FormPeach.PanelHintExtract.Visible:=false;
FormPeach.StringGridExtract.Hint:=txt_2_7_exthint;
end;

procedure updatecontent(sg:TStringGrid; var tvolumes,tdirs,tfiles,tsize:qword; upsort:boolean); //update label showing bytes/files/dirs listed in the stringgrid1; update list of archive types
var
   i:integer;
   s:ansistring;
   tpcompsize:qword;
begin
if updatingcontent=1 then exit;
updatingcontent:=1;
tfiles:=0;
tdirs:=0;
tvolumes:=0;
tsize:=0;
tpcompsize:=0;
sizefreeint:=0;
//hint overlay for add
if sg=FormPeach.StringGridAdd then
   if sg.RowCount>1 then hide_panelhintadd
   else FormPeach.PanelHintAdd.Visible:=true;
for i:=1 to sg.RowCount-1 do
   begin
   tdirs:=tdirs+strtoint(sg.Cells[4,i]);
   tfiles:=tfiles+strtoint(sg.Cells[5,i]);
   try
      tsize:=tsize+strtoqword(sg.Cells[12,i]);
      tpcompsize:=tpcompsize+strtoqword(sg.Cells[15,i]);
   except
   end;
   if upsort=true then sg.Cells[11,i]:='0';
   end;
autosize_stringgrid1;
if using_tarbefore=false then
   begin
   if (FormPeach.cbType.Text=STR_GZIP) or
      (FormPeach.cbType.Text=STR_BZIP2) or
      (FormPeach.cbType.Text=STR_XZ) or
      (FormPeach.cbType.Text=STR_QUAD) or
      (FormPeach.cbType.Text=STR_BROTLI) or
      (FormPeach.cbType.Text=STR_ZSTD) or
      (FormPeach.cbType.Text=txt_split) or
      ((FormPeach.cbType.Text=STR_ZPAQ) and (FormPeach.RadioGroupPaq.ItemIndex=0)) then
      check_tarbefore(tdirs);
   end;
if FormPeach.StringGridAdd.RowCount=1 then
   begin
   status1:=inttostr(tdirs)+' '+txt_dirs+' '+inttostr(tfiles)+' '+txt_files+' '+nicenumber(inttostr(tsize),filesizebase);
   if updatingarchive_inarchive=false then
      begin
      FormPeach.LabelStatusArDetails.Caption:=status1;
      FormPeach.LabelStatusAddUpdate.Caption:='';
      end
   else
      begin
      FormPeach.LabelStatusArDetails.Caption:=status1;
      FormPeach.LabelStatusAddUpdate.Caption:=txt_2_7_updating;
      FormPeach.EditAddName.Caption:=FormPeach.editopenin.caption;
      end;
   if (FormPeach.EditAddFilepath.Text='') or (FormPeach.EditAddFilename.Text='') then setoutname(s,0);
   updatingcontent:=0;
   exit;
   end;
if upsort=true then
   begin
   FormPeach.StringGridAdd.SortColRow(true,9);
   FormPeach.StringGridAdd.Cells[11,1]:='1';
   FormPeach.StringGridAdd.Row:=1;
   end;
sizefreeint:=tsize;
status1:=inttostr(tdirs)+' '+txt_dirs+' '+inttostr(tfiles)+' '+txt_files+' '+nicenumber(inttostr(tsize),filesizebase);
if updatingarchive_inarchive=false then
   begin
   FormPeach.LabelStatusArDetails.Caption:=status1;
   if tsize<>0 then FormPeach.LabelStatusArDetails.Caption:=FormPeach.LabelStatusArDetails.Caption+' | '+txt_4_7_pcomp+' '+inttostr((tsize*100 - tpcompsize) div tsize)+'%';
   FormPeach.LabelStatusAddUpdate.Caption:='';
   end
else
   begin
   FormPeach.LabelStatusArDetails.Caption:=status1;
   if tsize<>0 then FormPeach.LabelStatusArDetails.Caption:=FormPeach.LabelStatusArDetails.Caption+' | '+txt_4_7_pcomp+' '+inttostr((tsize*100 - tpcompsize) div tsize)+'%';
   FormPeach.LabelStatusAddUpdate.Caption:=txt_2_7_updating;
   FormPeach.EditAddName.Caption:=FormPeach.editopenin.caption;
   end;
if (FormPeach.EditAddFilepath.Text='') or (FormPeach.EditAddFilename.Text='') then setoutname(s,0);
updatingcontent:=0;
end;

procedure addfile;
var
   i:integer;
begin
if FormPeach.OpenDialogList.Execute then
   if FormPeach.OpenDialogList.FileName<>'' then
      begin
      FormPeach.StringGridAdd.Cursor:=crHourGlass;
      deselectingrid(FormPeach.StringGridAdd);
      FormPeach.OpenDialogList.Files.Count;
      for i:=0 to FormPeach.OpenDialogList.Files.Count-1 do
         if testname(FormPeach.OpenDialogList.Files[i], FormPeach.StringGridAdd)=0 then
            begin
            //show names of items being added is not implemented here since adding files is very fast
            addfilestr(FormPeach.StringGridAdd,FormPeach.OpenDialogList.Files[i]);
            end;
      FormPeach.StringGridAdd.AutoSizeColumns;
      updatecontent(FormPeach.StringGridAdd,tvolumes,tdirs,tfiles,tsize,true);
      FormPeach.StringGridAdd.Cursor:=crDefault;
      end;
end;

procedure test_extfile(s:ansistring; var okfile:boolean);
begin
okfile:=false;
if testname(s, FormPeach.StringGridExtract)=0 then //no duplicate entries
   if (testinput(s,false)=0) then //unsupported
      if FormPeach.CheckBoxExtUnsupported.State=cbChecked then okfile:=true
      else
   else
      case testext(s) of
         503: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true;
         502: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true;
         501: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true; //non-archives
         500: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true; //Windows executables, installers
         else okfile:=true;
         end;
end;

procedure test_extfile_noduplicatecheck(s:ansistring; var okfile:boolean);
begin
okfile:=false;
   if (testinput(s,false)=0) then //unsupported
      if FormPeach.CheckBoxExtUnsupported.State=cbChecked then okfile:=true
      else
   else
      case testext(s) of
         503: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true;
         502: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true;
         501: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true; //non-archives
         500: if FormPeach.CheckBoxExtNotArchives.State=cbChecked then okfile:=true; //Windows executables, installers
         else okfile:=true;
         end;
end;

procedure addfile_ext;
var
   i:integer;
   okfile:boolean;
begin
if FormPeach.OpenDialogList.Execute then
   if FormPeach.OpenDialogList.FileName<>'' then
      begin
      FormPeach.StringGridExtract.Cursor:=crHourGlass;
      deselectingrid(FormPeach.StringGridExtract);
      FormPeach.OpenDialogList.Files.Count;
      for i:=0 to FormPeach.OpenDialogList.Files.Count-1 do
         begin
         test_extfile(FormPeach.OpenDialogList.Files[i],okfile);
         if okfile=true then
            begin
            if checkfiledirname(FormPeach.OpenDialogList.Files[i])<>0 then begin pMessageWarningOK(txt_2_7_validatefn+' '+FormPeach.OpenDialogList.Files[i]); exit; end;
            addfilestr(FormPeach.StringGridExtract,FormPeach.OpenDialogList.Files[i]);
            end;
         end;
      updatecontent_ext;
      FormPeach.StringGridExtract.Cursor:=crDefault;
      end;
end;

procedure addfile_fromname(s:ansistring);
begin
deselectingrid(FormPeach.StringGridAdd);
if testname(s, FormPeach.StringGridAdd)=0 then
   begin
   addfilestr(FormPeach.StringGridAdd,s);
   FormPeach.StringGridAdd.AutoSizeColumns;
   updatecontent(FormPeach.StringGridAdd,tvolumes,tdirs,tfiles,tsize,true);
   end;
end;

procedure addfile_ext_fromname(s:ansistring);
var
   okfile:boolean;
begin
deselectingrid(FormPeach.StringGridExtract);
test_extfile(s,okfile);
if okfile=true then
   begin
   if checkfiledirname(s)<>0 then begin pMessageWarningOK(txt_2_7_validatefn+' '+s); exit; end;
   addfilestr(FormPeach.StringGridExtract,s);
   end;
updatecontent_ext;
end;

procedure addfilefolder_ext_fromname(s:ansistring);
var
   j:integer;
   okfile:boolean;
   exp_files:TFoundList;
   exp_fsizes:TFoundListSizes;
   exp_ftimes:TFoundListAges;
   exp_fattr:TFoundListAttrib;
   exp_fattr_dec:TFoundList;
   nfound:qword;
begin
FormPeach.StringGridExtract.Cursor:=crHourGlass;
deselectingrid(FormPeach.StringGridExtract);
if length(s)>2 then
   if s[length(s)]=directoryseparator then
      begin
      SetLength(s,length(s)-1);
      expand(s,exp_files,exp_fsizes,exp_ftimes,exp_fattr,exp_fattr_dec,nfound);
      for j:=0 to nfound-1 do
         if pos('D',exp_fattr_dec[j])=0 then
            begin
            test_extfile(exp_files[j],okfile);
            if okfile=true then
               begin
               if checkfiledirname(exp_files[j])<>0 then begin pMessageWarningOK(txt_2_7_validatefn+' '+exp_files[j]); exit; end;
               addfilestr(FormPeach.StringGridExtract,exp_files[j]);
               end;
            end;
      updatecontent_ext;
      end
   else addfile_ext_fromname(s);
FormPeach.StringGridExtract.Cursor:=crDefault;
end;

procedure addfolder_ext;
begin
if FormPeach.SelectDirectoryDialog1.Execute then
   if FormPeach.SelectDirectoryDialog1.FileName<>'' then
      begin
      addfilefolder_ext_fromname(FormPeach.SelectDirectoryDialog1.FileName+DirectorySeparator);
      end;
end;

procedure addfilefolder_fromname(s:ansistring);
var
   s1:ansistring;
begin
s1:=FormPeach.Caption;
deselectingrid(FormPeach.StringGridAdd);
if length(s)>2 then
   if s[length(s)]=directoryseparator then
      begin
      SetLength(s,length(s)-1);
      if testname(s, FormPeach.StringGridAdd)=0 then
         begin
         FormPeach.StringGridAdd.Cursor:=crHourGlass;
         FormPeach.Caption:=txt_2_4_adding+' '+s;
         Application.ProcessMessages;
         deselectingrid(FormPeach.StringGridAdd);
         addfolderstr(FormPeach.StringGridAdd,s);
         FormPeach.StringGridAdd.AutoSizeColumns;
         updatecontent(FormPeach.StringGridAdd,tvolumes,tdirs,tfiles,tsize,true);
         FormPeach.StringGridAdd.Cursor:=crDefault;
         end;
      end
   else addfile_fromname(s);
FormPeach.Caption:=s1;
updatelayout('');
end;

procedure addfolder;
begin
if FormPeach.SelectDirectoryDialog1.Execute then
   if FormPeach.SelectDirectoryDialog1.FileName<>'' then
      addfilefolder_fromname(FormPeach.SelectDirectoryDialog1.FileName);
end;

procedure setsearch_disabled;
begin
FormPeach.EditUn7zaFilter.Text:='*';
FormPeach.EditUn7zaFilter.Enabled:=false;
FormPeach.EditUn7zaFilter.Visible:=false;
FormPeach.EditUn7zaFilterInteractive.ReadOnly:=true;
FormPeach.EditUn7zaFilterInteractive.Visible:=false;
end;

procedure setsearch_enabled;
begin
FormPeach.EditUn7zaFilter.ReadOnly:=false;
FormPeach.EditUn7zaFilter.Enabled:=true;
FormPeach.EditUn7zaFilter.Visible:=true;
FormPeach.EditUn7zaFilterInteractive.ReadOnly:=false;
FormPeach.EditUn7zaFilterInteractive.Visible:=true;
end;

procedure advfiltersupdate;
begin
with FormPeach do
begin
if FormAdvf.CheckBoxAdvFilters.State=cbChecked then
   begin
   if filterbrowser=1 then
      begin
      if fun='UN7Z' then setsearch_disabled;
      status0:=txt_list_found;
      end;
   madvfilters.checked:=true;
   end
else
   begin
   setsearch_enabled;
   status0:=txt_list_browsing;
   madvfilters.checked:=false;
   browsingmode7z:=0;
   end;
end;
end;

procedure setfiltericon(vis:boolean);
begin
FormPeach.Imageopenadvf.visible:=vis;
FormPeach.ImageExtractAdvf.visible:=vis;
FormPeach.ImageAddAdvf.visible:=vis;
end;

procedure msg_not_accessible_list(s:ansistring);
begin
//interactive error message suppressed
end;

procedure loadlist(sg:TStringGrid; listfilename:AnsiString);
var
   in_param:TFoundlist;
   listfile:ansistring;
   i:integer;
begin
FormPeach.OpenDialogLayout.InitialDir:=confpath+'Layouts'+DirectorySeparator;
listfile:='';
if listfilename<>'' then
   if FileExists(listfilename) then
      listfile:=listfilename;
if listfilename='' then //interactive, better not use at startup, ignore non existing layouts to improve portable use
   if FormPeach.OpenDialogLayout.Execute then
      if FormPeach.OpenDialogLayout.FileName<>'' then listfile:=FormPeach.OpenDialogLayout.FileName;
if listfile<>'' then
   begin
      read_filelist(listfile,in_param);
      plistfile:=listfile;
      for i:=0 to length(in_param)-1 do
         begin
         if pos('*filter* ',in_param[i])=1 then
            begin
            FormAdvf.MemoAdvExclude.Append(copy(in_param[i],10,length(in_param[i])-9));
            if FormAdvf.CheckBoxAdvFilters.State=cbUnchecked then
               begin
               FormAdvf.CheckBoxAdvFilters.State:=cbChecked;
               set_advfilters_enabled(True);
               setfiltericon(true);
               advfiltersupdate;
               end;
            end
         else
            if pos('*filter_include* ',in_param[i])=1 then
               begin
               FormAdvf.MemoAdvInclude.Append(copy(in_param[i],18,length(in_param[i])-17));
               if FormAdvf.CheckBoxAdvFilters.State=cbUnchecked then
                  begin
                  FormAdvf.CheckBoxAdvFilters.State:=cbChecked;
                  set_advfilters_enabled(True);
                  setfiltericon(true);
                  advfiltersupdate;
                  end;
               end
            else
               if sg<>nil then
               begin
               if sg=FormPeach.StringGridAdd then
                  if testname(in_param[i], sg)=0 then
                     if filegetattr(in_param[i]) > 0 then
                        if filegetattr(in_param[i]) and faDirectory =0 then addfilestr(sg,in_param[i])
                        else addfolderstr(sg,in_param[i])
                     else msg_not_accessible_list(in_param[i])
                  else
               else
                  if testname(in_param[i], sg)=0 then
                     if filegetattr(in_param[i]) > 0 then
                        if filegetattr(in_param[i]) and faDirectory =0 then addfilestr(sg,in_param[i])
                        else
                     else msg_not_accessible_list(in_param[i]);
               end;
         end;
      if sg<>nil then
         if sg=FormPeach.StringGridAdd then updatecontent(FormPeach.StringGridAdd,tvolumes,tdirs,tfiles,tsize,true)
         else updatecontent_ext;
      end;
end;

function check_input:integer;
begin
check_input:=-1;
//check if input is suitable for chosen archive_type
if FormPeach.StringGridAdd.RowCount=1 then
   if FormAdvf.CheckBoxAdvFilters.State=cbUnChecked then
      begin
      exit;
      end;
check_input:=0;
end;

function check_extraction_input:integer;
begin
check_extraction_input:=-1;
if FormPeach.StringGridExtract.RowCount=1 then
   if FormAdvf.CheckBoxAdvFilters.State=cbUnChecked then
      begin
      pMessageWarningOK(txt_2_7_noinput);
      exit;
      end;
check_extraction_input:=0;
end;

procedure savelist(sg:TStringGrid);
var
   x:dword;
   tname:ansistring;
begin
if sg=FormPeach.StringGridAdd then
   if check_input<>0 then exit;
if sg=FormPeach.StringGridExtract then
   if check_extraction_input<>0 then exit;
FormPeach.SaveDialogPJ.DefaultExt:='.txt';
FormPeach.SaveDialogPJ.InitialDir:=confpath+'Layouts'+DirectorySeparator;
if FormPeach.SaveDialogPJ.Execute then
   if FormPeach.SaveDialogPJ.FileName<>'' then tname:=FormPeach.SaveDialogPJ.FileName;
if tname='' then exit;
assignfile(t,tname);
rewrite(t);
write_header(t);
if sg<>nil then for x:=1 to sg.RowCount-1 do writeln(t,sg.Cells[8,x]);
if FormAdvf.MemoAdvExclude.Lines.Count>0 then
   for x:=0 to FormAdvf.MemoAdvExclude.Lines.Count-1 do writeln(t,'*filter* '+FormAdvf.MemoAdvExclude.Lines[x]);
if FormAdvf.MemoAdvInclude.Lines.Count>0 then
   for x:=0 to FormAdvf.MemoAdvInclude.Lines.Count-1 do writeln(t,'*filter_include* '+FormAdvf.MemoAdvInclude.Lines[x]);
closefile(t);
end;

procedure clearlist;
begin
FormPeach.StringGridAdd.Row:=0;
FormPeach.StringGridAdd.RowCount:=1;
updatecontent(FormPeach.StringGridAdd,tvolumes,tdirs,tfiles,tsize,true);
end;

procedure restorelistTB;
var i:integer;
begin
FormPeach.StringGridAdd.RowCount:=FormPeach.StringGridTB.RowCount;
for i:=1 to FormPeach.StringGridTB.RowCount-1 do
   FormPeach.StringGridAdd.Rows[i].Assign(FormPeach.StringGridTB.Rows[i]);
FormPeach.StringGridAdd.Row:=0;
updatecontent(FormPeach.StringGridAdd,tvolumes,tdirs,tfiles,tsize,true);
end;

procedure clearlist_ext;
begin
FormPeach.StringGridExtract.Row:=0;
FormPeach.StringGridExtract.RowCount:=1;
FormPeach.LabelStatusExtract.Caption:='';
end;

procedure addtohistorypopup;
var
   s:ansistring;
   rc:integer;
begin
with FormPeach do
   begin
   rc:=StringGridSessionHistory.RowCount;
   if rc>1 then pmh1.caption:=StringGridSessionHistory.Cells[2,rc-1]+' '+StringGridSessionHistory.Cells[3,rc-1] else pmh1.caption:='';
   if rc>2 then pmh2.caption:=StringGridSessionHistory.Cells[2,rc-2]+' '+StringGridSessionHistory.Cells[3,rc-2] else pmh2.caption:='';
   if rc>3 then pmh3.caption:=StringGridSessionHistory.Cells[2,rc-3]+' '+StringGridSessionHistory.Cells[3,rc-3] else pmh3.caption:='';
   if rc>4 then pmh4.caption:=StringGridSessionHistory.Cells[2,rc-4]+' '+StringGridSessionHistory.Cells[3,rc-4] else pmh4.caption:='';
   if rc>5 then pmh5.caption:=StringGridSessionHistory.Cells[2,rc-5]+' '+StringGridSessionHistory.Cells[3,rc-5] else pmh5.caption:='';
   if rc>6 then pmh6.caption:=StringGridSessionHistory.Cells[2,rc-6]+' '+StringGridSessionHistory.Cells[3,rc-6] else pmh6.caption:='';
   if rc>7 then pmh7.caption:=StringGridSessionHistory.Cells[2,rc-7]+' '+StringGridSessionHistory.Cells[3,rc-7] else pmh7.caption:='';
   if rc>8 then pmh8.caption:=StringGridSessionHistory.Cells[2,rc-8]+' '+StringGridSessionHistory.Cells[3,rc-8] else pmh8.caption:='';
   if pmh8.caption='' then pmh8.visible:=false else pmh8.visible:=true;
   if pmh7.caption='' then pmh7.visible:=false else pmh7.visible:=true;
   if pmh6.caption='' then pmh6.visible:=false else pmh6.visible:=true;
   if pmh5.caption='' then pmh5.visible:=false else pmh5.visible:=true;
   if pmh4.caption='' then pmh4.visible:=false else pmh4.visible:=true;
   if pmh3.caption='' then pmh3.visible:=false else pmh3.visible:=true;
   if pmh2.caption='' then pmh2.visible:=false else pmh2.visible:=true;
   if pmh1.visible=true then pmh1.Bitmap:=drawhistoryicon(rc-1);
   if pmh2.visible=true then pmh2.Bitmap:=drawhistoryicon(rc-2);
   if pmh3.visible=true then pmh3.Bitmap:=drawhistoryicon(rc-3);
   if pmh4.visible=true then pmh4.Bitmap:=drawhistoryicon(rc-4);
   if pmh5.visible=true then pmh5.Bitmap:=drawhistoryicon(rc-5);
   if pmh6.visible=true then pmh6.Bitmap:=drawhistoryicon(rc-6);
   if pmh7.visible=true then pmh7.Bitmap:=drawhistoryicon(rc-7);
   if pmh8.visible=true then pmh8.Bitmap:=drawhistoryicon(rc-8);
   if rc>1 then mhistory1.caption:=StringGridSessionHistory.Cells[2,rc-1]+' '+StringGridSessionHistory.Cells[3,rc-1] else mhistory1.caption:='';
   if rc>2 then mhistory2.caption:=StringGridSessionHistory.Cells[2,rc-2]+' '+StringGridSessionHistory.Cells[3,rc-2] else mhistory2.caption:='';
   if rc>3 then mhistory3.caption:=StringGridSessionHistory.Cells[2,rc-3]+' '+StringGridSessionHistory.Cells[3,rc-3] else mhistory3.caption:='';
   if rc>4 then mhistory4.caption:=StringGridSessionHistory.Cells[2,rc-4]+' '+StringGridSessionHistory.Cells[3,rc-4] else mhistory4.caption:='';
   if rc>5 then mhistory5.caption:=StringGridSessionHistory.Cells[2,rc-5]+' '+StringGridSessionHistory.Cells[3,rc-5] else mhistory5.caption:='';
   if rc>6 then mhistory6.caption:=StringGridSessionHistory.Cells[2,rc-6]+' '+StringGridSessionHistory.Cells[3,rc-6] else mhistory6.caption:='';
   if rc>7 then mhistory7.caption:=StringGridSessionHistory.Cells[2,rc-7]+' '+StringGridSessionHistory.Cells[3,rc-7] else mhistory7.caption:='';
   if rc>8 then mhistory8.caption:=StringGridSessionHistory.Cells[2,rc-8]+' '+StringGridSessionHistory.Cells[3,rc-8] else mhistory8.caption:='';
   if mhistory8.caption='' then mhistory8.visible:=false else mhistory8.visible:=true;
   if mhistory7.caption='' then mhistory7.visible:=false else mhistory7.visible:=true;
   if mhistory6.caption='' then mhistory6.visible:=false else mhistory6.visible:=true;
   if mhistory5.caption='' then mhistory5.visible:=false else mhistory5.visible:=true;
   if mhistory4.caption='' then mhistory4.visible:=false else mhistory4.visible:=true;
   if mhistory3.caption='' then mhistory3.visible:=false else mhistory3.visible:=true;
   if mhistory2.caption='' then mhistory2.visible:=false else mhistory2.visible:=true;
   if mhistory1.visible=true then mhistory1.Bitmap:=pmh1.Bitmap;
   if mhistory2.visible=true then mhistory2.Bitmap:=pmh2.Bitmap;
   if mhistory3.visible=true then mhistory3.Bitmap:=pmh3.Bitmap;
   if mhistory4.visible=true then mhistory4.Bitmap:=pmh4.Bitmap;
   if mhistory5.visible=true then mhistory5.Bitmap:=pmh5.Bitmap;
   if mhistory6.visible=true then mhistory6.Bitmap:=pmh6.Bitmap;
   if mhistory7.visible=true then mhistory7.Bitmap:=pmh7.Bitmap;
   if mhistory8.visible=true then mhistory8.Bitmap:=pmh8.Bitmap;
   if rc>1 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-1];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha1.caption:=s else pnha1.caption:='';
      end;
   if rc>2 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-2];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha2.caption:=s else pnha2.caption:='';
      end;
   if rc>3 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-3];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha3.caption:=s else pnha3.caption:='';
      end;
   if rc>4 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-4];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha4.caption:=s else pnha4.caption:='';
      end;
   if rc>5 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-5];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha5.caption:=s else pnha5.caption:='';
      end;
   if rc>6 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-6];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha6.caption:=s else pnha6.caption:='';
      end;
   if rc>7 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-7];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha7.caption:=s else pnha7.caption:='';
      end;
   if rc>8 then
      begin
      s:=StringGridSessionHistory.Cells[2,rc-8];
      if s=txt_mypc then s:='';
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=extractfilepath(s);
      if s<>'' then pnha8.caption:=s else pnha8.caption:='';
      end;
   if pnha8.caption='' then pnha8.visible:=false else pnha8.visible:=true;
   if pnha7.caption='' then pnha7.visible:=false else pnha7.visible:=true;
   if pnha6.caption='' then pnha6.visible:=false else pnha6.visible:=true;
   if pnha5.caption='' then pnha5.visible:=false else pnha5.visible:=true;
   if pnha4.caption='' then pnha4.visible:=false else pnha4.visible:=true;
   if pnha3.caption='' then pnha3.visible:=false else pnha3.visible:=true;
   if pnha2.caption='' then pnha2.visible:=false else pnha2.visible:=true;
   if pnha1.caption='' then pnha1.visible:=false else pnha1.visible:=true;
   if pnha1.visible=true then pnha1.Bitmap:=pmh1.Bitmap;
   if pnha2.visible=true then pnha2.Bitmap:=pmh2.Bitmap;
   if pnha3.visible=true then pnha3.Bitmap:=pmh3.Bitmap;
   if pnha4.visible=true then pnha4.Bitmap:=pmh4.Bitmap;
   if pnha5.visible=true then pnha5.Bitmap:=pmh5.Bitmap;
   if pnha6.visible=true then pnha6.Bitmap:=pmh6.Bitmap;
   if pnha7.visible=true then pnha7.Bitmap:=pmh7.Bitmap;
   if pnha8.visible=true then pnha8.Bitmap:=pmh8.Bitmap;
   pnh1.caption:=pnha1.caption;
   pnh2.caption:=pnha2.caption;
   pnh3.caption:=pnha3.caption;
   pnh4.caption:=pnha4.caption;
   pnh5.caption:=pnha5.caption;
   pnh6.caption:=pnha6.caption;
   pnh7.caption:=pnha7.caption;
   pnh8.caption:=pnha8.caption;
   if pnh8.caption='' then pnh8.visible:=false else pnh8.visible:=true;
   if pnh7.caption='' then pnh7.visible:=false else pnh7.visible:=true;
   if pnh6.caption='' then pnh6.visible:=false else pnh6.visible:=true;
   if pnh5.caption='' then pnh5.visible:=false else pnh5.visible:=true;
   if pnh4.caption='' then pnh4.visible:=false else pnh4.visible:=true;
   if pnh3.caption='' then pnh3.visible:=false else pnh3.visible:=true;
   if pnh2.caption='' then pnh2.visible:=false else pnh2.visible:=true;
   if pnh1.caption='' then pnh1.visible:=false else pnh1.visible:=true;
   if pnh1.visible=true then pnh1.Bitmap:=pmh1.Bitmap;
   if pnh2.visible=true then pnh2.Bitmap:=pmh2.Bitmap;
   if pnh3.visible=true then pnh3.Bitmap:=pmh3.Bitmap;
   if pnh4.visible=true then pnh4.Bitmap:=pmh4.Bitmap;
   if pnh5.visible=true then pnh5.Bitmap:=pmh5.Bitmap;
   if pnh6.visible=true then pnh6.Bitmap:=pmh6.Bitmap;
   if pnh7.visible=true then pnh7.Bitmap:=pmh7.Bitmap;
   if pnh8.visible=true then pnh8.Bitmap:=pmh8.Bitmap;
   if rc>1 then pnhf1.caption:=StringGridSessionHistory.Cells[2,rc-1] else pnhf1.caption:='';
   if rc>2 then pnhf2.caption:=StringGridSessionHistory.Cells[2,rc-2] else pnhf2.caption:='';
   if rc>3 then pnhf3.caption:=StringGridSessionHistory.Cells[2,rc-3] else pnhf3.caption:='';
   if rc>4 then pnhf4.caption:=StringGridSessionHistory.Cells[2,rc-4] else pnhf4.caption:='';
   if rc>5 then pnhf5.caption:=StringGridSessionHistory.Cells[2,rc-5] else pnhf5.caption:='';
   if rc>6 then pnhf6.caption:=StringGridSessionHistory.Cells[2,rc-6] else pnhf6.caption:='';
   if rc>7 then pnhf7.caption:=StringGridSessionHistory.Cells[2,rc-7] else pnhf7.caption:='';
   if rc>8 then pnhf8.caption:=StringGridSessionHistory.Cells[2,rc-8] else pnhf8.caption:='';
   if pnhf8.caption='' then pnhf8.visible:=false else pnhf8.visible:=true;
   if pnhf7.caption='' then pnhf7.visible:=false else pnhf7.visible:=true;
   if pnhf6.caption='' then pnhf6.visible:=false else pnhf6.visible:=true;
   if pnhf5.caption='' then pnhf5.visible:=false else pnhf5.visible:=true;
   if pnhf4.caption='' then pnhf4.visible:=false else pnhf4.visible:=true;
   if pnhf3.caption='' then pnhf3.visible:=false else pnhf3.visible:=true;
   if pnhf2.caption='' then pnhf2.visible:=false else pnhf2.visible:=true;
   if pnhf1.caption='' then pnhf1.visible:=false else pnhf1.visible:=true;
   if pnhf1.visible=true then pnhf1.Bitmap:=pmh1.Bitmap;
   if pnhf2.visible=true then pnhf2.Bitmap:=pmh2.Bitmap;
   if pnhf3.visible=true then pnhf3.Bitmap:=pmh3.Bitmap;
   if pnhf4.visible=true then pnhf4.Bitmap:=pmh4.Bitmap;
   if pnhf5.visible=true then pnhf5.Bitmap:=pmh5.Bitmap;
   if pnhf6.visible=true then pnhf6.Bitmap:=pmh6.Bitmap;
   if pnhf7.visible=true then pnhf7.Bitmap:=pmh7.Bitmap;
   if pnhf8.visible=true then pnhf8.Bitmap:=pmh8.Bitmap;
   pnhe1.caption:=pnha1.caption;
   pnhe2.caption:=pnha2.caption;
   pnhe3.caption:=pnha3.caption;
   pnhe4.caption:=pnha4.caption;
   pnhe5.caption:=pnha5.caption;
   pnhe6.caption:=pnha6.caption;
   pnhe7.caption:=pnha7.caption;
   pnhe8.caption:=pnha8.caption;
   if pnhe8.caption='' then pnhe8.visible:=false else pnhe8.visible:=true;
   if pnhe7.caption='' then pnhe7.visible:=false else pnhe7.visible:=true;
   if pnhe6.caption='' then pnhe6.visible:=false else pnhe6.visible:=true;
   if pnhe5.caption='' then pnhe5.visible:=false else pnhe5.visible:=true;
   if pnhe4.caption='' then pnhe4.visible:=false else pnhe4.visible:=true;
   if pnhe3.caption='' then pnhe3.visible:=false else pnhe3.visible:=true;
   if pnhe2.caption='' then pnhe2.visible:=false else pnhe2.visible:=true;
   if pnhe1.caption='' then pnhe1.visible:=false else pnhe1.visible:=true;
   if pnhe1.visible=true then pnhe1.Bitmap:=pmh1.Bitmap;
   if pnhe2.visible=true then pnhe2.Bitmap:=pmh2.Bitmap;
   if pnhe3.visible=true then pnhe3.Bitmap:=pmh3.Bitmap;
   if pnhe4.visible=true then pnhe4.Bitmap:=pmh4.Bitmap;
   if pnhe5.visible=true then pnhe5.Bitmap:=pmh5.Bitmap;
   if pnhe6.visible=true then pnhe6.Bitmap:=pmh6.Bitmap;
   if pnhe7.visible=true then pnhe7.Bitmap:=pmh7.Bitmap;
   if pnhe8.visible=true then pnhe8.Bitmap:=pmh8.Bitmap;
   mexttos1.caption:=pnha1.caption;
   mexttos2.caption:=pnha2.caption;
   mexttos3.caption:=pnha3.caption;
   mexttos4.caption:=pnha4.caption;
   mexttos5.caption:=pnha5.caption;
   mexttos6.caption:=pnha6.caption;
   mexttos7.caption:=pnha7.caption;
   mexttos8.caption:=pnha8.caption;
   if mexttos8.caption='' then mexttos8.visible:=false else mexttos8.visible:=true;
   if mexttos7.caption='' then mexttos7.visible:=false else mexttos7.visible:=true;
   if mexttos6.caption='' then mexttos6.visible:=false else mexttos6.visible:=true;
   if mexttos5.caption='' then mexttos5.visible:=false else mexttos5.visible:=true;
   if mexttos4.caption='' then mexttos4.visible:=false else mexttos4.visible:=true;
   if mexttos3.caption='' then mexttos3.visible:=false else mexttos3.visible:=true;
   if mexttos2.caption='' then mexttos2.visible:=false else mexttos2.visible:=true;
   if mexttos1.caption='' then mexttos1.visible:=false else mexttos1.visible:=true;
   if mexttos1.visible=true then mexttos1.Bitmap:=pmh1.Bitmap;
   if mexttos2.visible=true then mexttos2.Bitmap:=pmh2.Bitmap;
   if mexttos3.visible=true then mexttos3.Bitmap:=pmh3.Bitmap;
   if mexttos4.visible=true then mexttos4.Bitmap:=pmh4.Bitmap;
   if mexttos5.visible=true then mexttos5.Bitmap:=pmh5.Bitmap;
   if mexttos6.visible=true then mexttos6.Bitmap:=pmh6.Bitmap;
   if mexttos7.visible=true then mexttos7.Bitmap:=pmh7.Bitmap;
   if mexttos8.visible=true then mexttos8.Bitmap:=pmh8.Bitmap;

   CopyMenuItems(mHistory,pmnavhistory.Items,28);
   end;
end;

procedure sethistorybuttons;
begin
if FormPeach.StringGridSessionHistory.Row=FormPeach.StringGridSessionHistory.RowCount-1 then FormPeach.ctrlfwd.enabled:=false
else FormPeach.ctrlfwd.enabled:=true;
if FormPeach.StringGridSessionHistory.Row=1 then FormPeach.ctrlback.enabled:=false
else FormPeach.ctrlback.enabled:=true;
end;

procedure addtohistory;
var
   rc,selptab:integer;
begin
FormPeach.StringGridSessionHistory.RowCount:=FormPeach.StringGridSessionHistory.Row+1;
if fun='UN7Z' then
   begin
   if (FormPeach.EditUn7zaFilter.Text=FormPeach.StringGridSessionHistory.Cells[1,FormPeach.StringGridSessionHistory.RowCount-1]) and (FormPeach.EditUn7zaFilterExclude.Text=FormPeach.StringGridSessionHistory.Cells[1,FormPeach.StringGridSessionHistory.RowCount-1]) then exit;
   rc:=FormPeach.StringGridSessionHistory.Rowcount;
   if (FormPeach.StringGridSessionHistory.Cells[1,rc-1]=status0) and
      (FormPeach.StringGridSessionHistory.Cells[2,rc-1]=FormPeach.EditOpenIn.Text) and
      (FormPeach.StringGridSessionHistory.Cells[3,rc-1]=FormPeach.EditUn7zaFilter.Text) and
      (FormPeach.StringGridSessionHistory.Cells[4,rc-1]=FormPeach.EditUn7zaFilterExclude.Text) then exit;
   rc:=rc+1;
   FormPeach.StringGridSessionHistory.RowCount:=rc;
   FormPeach.StringGridSessionHistory.Cells[1,rc-1]:=status0;
   FormPeach.StringGridSessionHistory.Cells[2,rc-1]:=FormPeach.EditOpenIn.Text;
   FormPeach.StringGridSessionHistory.Cells[3,rc-1]:=FormPeach.EditUn7zaFilter.Text;
   FormPeach.StringGridSessionHistory.Cells[4,rc-1]:=FormPeach.EditUn7zaFilterExclude.Text;
   end
else
   begin
   rc:=FormPeach.StringGridSessionHistory.Rowcount;
   if (FormPeach.StringGridSessionHistory.Cells[1,rc-1]=status0) and
      (FormPeach.StringGridSessionHistory.Cells[2,rc-1]=FormPeach.EditOpenIn.Text) and
      (FormPeach.StringGridSessionHistory.Cells[3,rc-1]=FormPeach.EditUn7zaFilter.Text) then exit;
   rc:=rc+1;
   FormPeach.StringGridSessionHistory.RowCount:=rc;
   FormPeach.StringGridSessionHistory.Cells[1,rc-1]:=status0;
   FormPeach.StringGridSessionHistory.Cells[2,rc-1]:=FormPeach.EditOpenIn.Text;
   FormPeach.StringGridSessionHistory.Cells[3,rc-1]:=FormPeach.EditUn7zaFilter.Text;
   FormPeach.StringGridSessionHistory.Cells[4,rc-1]:='';
   end;
FormPeach.StringGridSessionHistory.AutosizeColumns;
FormPeach.StringGridSessionHistory.ColWidths[0]:=rowsize;
if FormPeach.StringGridSessionHistory.Width<250 then FormPeach.StringGridSessionHistory.Width:=250;
FormPeach.StringGridSessionHistory.Row:=FormPeach.StringGridSessionHistory.RowCount-1;
addtohistorypopup;
sethistorybuttons;
populatetree;
for selptab:=0 to FormPeach.TabBar.Sections.Count-1 do if FormPeach.TabBar.Sections.Items[selptab].ID=atabid then break;
if FormPeach.TabBar.Sections.Items[selptab].ID<>0 then
    begin
    FormPeach.TabBar.Sections[selptab].Text:=gettabname(FormPeach.StringGridSessionHistory.Row);
    FormPeach.TabBar.Sections[selptab].ImageIndex:=drawtabicon(FormPeach.StringGridSessionHistory.Row);
    FormPeach.StringGridTabs.Rows[atabid]:=FormPeach.StringGridSessionHistory.Rows[FormPeach.StringGridSessionHistory.Row];
    end;
end;

procedure populatebookmarks;
var
   i,j,k:integer;
   s,s1,s2:ansistring;
begin
with FormPeach do
begin
mb1.visible:=false;
mb2.visible:=false;
mb3.visible:=false;
mb4.visible:=false;
mb5.visible:=false;
mb6.visible:=false;
mb7.visible:=false;
mb8.visible:=false;
mb9.visible:=false;
mb10.visible:=false;
mb11.visible:=false;
mb12.visible:=false;
mb13.visible:=false;
mb14.visible:=false;
mb15.visible:=false;
mb16.visible:=false;
mb17.visible:=false;
mb18.visible:=false;
mb19.visible:=false;
mb20.visible:=false;
mb21.visible:=false;
mb22.visible:=false;
mb23.visible:=false;
pnb1.visible:=false;
pnb2.visible:=false;
pnb3.visible:=false;
pnb4.visible:=false;
pnb5.visible:=false;
pnb6.visible:=false;
pnb7.visible:=false;
pnb8.visible:=false;
pnb9.visible:=false;
pnb10.visible:=false;
pnb11.visible:=false;
pnb12.visible:=false;
pnb13.visible:=false;
pnb14.visible:=false;
pnb15.visible:=false;
pnb16.visible:=false;
pnb17.visible:=false;
pnb18.visible:=false;
pnb19.visible:=false;
pnb20.visible:=false;
pnb21.visible:=false;
pnb22.visible:=false;
pnb23.visible:=false;
pnba1.visible:=false;
pnba2.visible:=false;
pnba3.visible:=false;
pnba4.visible:=false;
pnba5.visible:=false;
pnba6.visible:=false;
pnba7.visible:=false;
pnba8.visible:=false;
pnba9.visible:=false;
pnba10.visible:=false;
pnba11.visible:=false;
pnba12.visible:=false;
pnba13.visible:=false;
pnba14.visible:=false;
pnba15.visible:=false;
pnba16.visible:=false;
pnba17.visible:=false;
pnba18.visible:=false;
pnba19.visible:=false;
pnba20.visible:=false;
pnba21.visible:=false;
pnba22.visible:=false;
pnba23.visible:=false;
pmjb1.visible:=false;
pmjb2.visible:=false;
pmjb3.visible:=false;
pmjb4.visible:=false;
pmjb5.visible:=false;
pmjb6.visible:=false;
pmjb7.visible:=false;
pmjb8.visible:=false;
pmjb9.visible:=false;
pmjb10.visible:=false;
pmjb11.visible:=false;
pmjb12.visible:=false;
pmjb13.visible:=false;
pmjb14.visible:=false;
pmjb15.visible:=false;
pmjb16.visible:=false;
pmjb17.visible:=false;
pmjb18.visible:=false;
pmjb19.visible:=false;
pmjb20.visible:=false;
pmjb21.visible:=false;
pmjb22.visible:=false;
pmjb23.visible:=false;
j:=StringGridBookmarks.RowCount;
if j>24 then j:=24;
k:=0;
if StringGridBookmarks.RowCount>1 then
   for i:=1 to j-1 do
      begin
      s:=FormPeach.StringGridBookmarks.Cells[2,i];
      s2:=s;
      if length(s)>0 then
         if s[length(s)]=directoryseparator then s1:=s
         else s1:=extractfilepath(s);
      //translatespecialfolders(s); unused, different form for same path may be confusing
      case i of
         1: begin
            pmembf1.caption:=s2;
            mb1.caption:=s2;
            mb1.visible:=true;
            mb1.Bitmap:=drawmenuicon(mb1.Caption);
            pmjb1.caption:=s2;
            pmjb1.visible:=true;
            pmjb1.Bitmap:=mb1.Bitmap;
            pnb1.caption:=s1;
            pnba1.caption:=s1;
            if s1<>'' then
               begin
               pnb1.visible:=true;
               pnb1.Bitmap:=drawmenuicon(pnb1.Caption);
               pnba1.visible:=true;
               pnba1.Bitmap:=pnb1.Bitmap;
               end;
            end;
         2: begin
            pmembf2.caption:=s2;
            mb2.caption:=s2;
            mb2.visible:=true;
            mb2.Bitmap:=drawmenuicon(mb2.Caption);
            pmjb2.caption:=s2;
            pmjb2.visible:=true;
            pmjb2.Bitmap:=mb2.Bitmap;
            pnb2.caption:=s1;
            pnba2.caption:=s1;
            if s1<>'' then
               begin
               pnb2.visible:=true;
               pnb2.Bitmap:=drawmenuicon(pnb2.Caption);
               pnba2.visible:=true;
               pnba2.Bitmap:=pnb2.Bitmap;
               end;
            end;
         3: begin
         pmembf3.caption:=s2;
         mb3.caption:=s2;
         mb3.visible:=true;
         mb3.Bitmap:=drawmenuicon(mb3.Caption);
         pmjb3.caption:=s2;
         pmjb3.visible:=true;
         pmjb3.Bitmap:=mb3.Bitmap;
         pnb3.caption:=s1;
         pnba3.caption:=s1;
         if s1<>'' then
            begin
            pnb3.visible:=true;
            pnb3.Bitmap:=drawmenuicon(pnb3.Caption);
            pnba3.visible:=true;
            pnba3.Bitmap:=pnb3.Bitmap;
            end;
         end;
         4: begin
         pmembf4.caption:=s2;
         mb4.caption:=s2;
         mb4.visible:=true;
         mb4.Bitmap:=drawmenuicon(mb4.Caption);
         pmjb4.caption:=s2;
         pmjb4.visible:=true;
         pmjb4.Bitmap:=mb4.Bitmap;
         pnb4.caption:=s1;
         pnba4.caption:=s1;
         if s1<>'' then
            begin
            pnb4.visible:=true;
            pnb4.Bitmap:=drawmenuicon(pnb4.Caption);
            pnba4.visible:=true;
            pnba4.Bitmap:=pnb4.Bitmap;
            end;
         end;
         5: begin
         pmembf5.caption:=s2;
         mb5.caption:=s2;
         mb5.visible:=true;
         mb5.Bitmap:=drawmenuicon(mb5.Caption);
         pmjb5.caption:=s2;
         pmjb5.visible:=true;
         pmjb5.Bitmap:=mb5.Bitmap;
         pnb5.caption:=s1;
         pnba5.caption:=s1;
         if s1<>'' then
            begin
            pnb5.visible:=true;
            pnb5.Bitmap:=drawmenuicon(pnb5.Caption);
            pnba5.visible:=true;
            pnba5.Bitmap:=pnb5.Bitmap;
            end;
         end;
         6: begin
         pmembf6.caption:=s2;
         mb6.caption:=s2;
         mb6.visible:=true;
         mb6.Bitmap:=drawmenuicon(mb6.Caption);
         pmjb6.caption:=s2;
         pmjb6.visible:=true;
         pmjb6.Bitmap:=mb6.Bitmap;
         pnb6.caption:=s1;
         pnba6.caption:=s1;
         if s1<>'' then
            begin
            pnb6.visible:=true;
            pnb6.Bitmap:=drawmenuicon(pnb6.Caption);
            pnba6.visible:=true;
            pnba6.Bitmap:=pnb6.Bitmap;
            end;
         end;
         7: begin
         pmembf7.caption:=s2;
         mb7.caption:=s2;
         mb7.visible:=true;
         mb7.Bitmap:=drawmenuicon(mb7.Caption);
         pmjb7.caption:=s2;
         pmjb7.visible:=true;
         pmjb7.Bitmap:=mb7.Bitmap;
         pnb7.caption:=s1;
         pnba7.caption:=s1;
         if s1<>'' then
            begin
            pnb7.visible:=true;
            pnb7.Bitmap:=drawmenuicon(pnb7.Caption);
            pnba7.visible:=true;
            pnba7.Bitmap:=pnb7.Bitmap;
            end;
         end;
         8: begin
         pmembf8.caption:=s2;
         mb8.caption:=s2;
         mb8.visible:=true;
         mb8.Bitmap:=drawmenuicon(mb8.Caption);
         pmjb8.caption:=s2;
         pmjb8.visible:=true;
         pmjb8.Bitmap:=mb8.Bitmap;
         pnb8.caption:=s1;
         pnba8.caption:=s1;
         if s1<>'' then
            begin
            pnb8.visible:=true;
            pnb8.Bitmap:=drawmenuicon(pnb8.Caption);
            pnba8.visible:=true;
            pnba8.Bitmap:=pnb8.Bitmap;
            end;
         end;
         9: begin
         mb9.caption:=s2;
         mb9.visible:=true;
         mb9.Bitmap:=drawmenuicon(mb9.Caption);
         pmjb9.caption:=s2;
         pmjb9.visible:=true;
         pmjb9.Bitmap:=mb9.Bitmap;
         pnb9.caption:=s1;
         pnba9.caption:=s1;
         if s1<>'' then
            begin
            pnb9.visible:=true;
            pnb9.Bitmap:=drawmenuicon(pnb9.Caption);
            pnba9.visible:=true;
            pnba9.Bitmap:=pnb9.Bitmap;
            end;
         end;
         10: begin
         mb10.caption:=s2;
         mb10.visible:=true;
         mb10.Bitmap:=drawmenuicon(mb10.Caption);
         pmjb10.caption:=s2;
         pmjb10.visible:=true;
         pmjb10.Bitmap:=mb10.Bitmap;
         pnb10.caption:=s1;
         pnba10.caption:=s1;
         if s1<>'' then
            begin
            pnb10.visible:=true;
            pnb10.Bitmap:=drawmenuicon(pnb10.Caption);
            pnba10.visible:=true;
            pnba10.Bitmap:=pnb10.Bitmap;
            end;
         end;
         11: begin
            mb11.caption:=s2;
            mb11.visible:=true;
            mb11.Bitmap:=drawmenuicon(mb11.Caption);
            pmjb11.caption:=s2;
            pmjb11.visible:=true;
            pmjb11.Bitmap:=mb11.Bitmap;
            pnb11.caption:=s1;
            pnba11.caption:=s1;
            if s1<>'' then
               begin
               pnb11.visible:=true;
               pnb11.Bitmap:=drawmenuicon(pnb11.Caption);
               pnba11.visible:=true;
               pnba11.Bitmap:=pnb11.Bitmap;
               end;
            end;
         12: begin
            mb12.caption:=s2;
            mb12.visible:=true;
            mb12.Bitmap:=drawmenuicon(mb12.Caption);
            pmjb12.caption:=s2;
            pmjb12.visible:=true;
            pmjb12.Bitmap:=mb12.Bitmap;
            pnb12.caption:=s1;
            pnba12.caption:=s1;
            if s1<>'' then
               begin
               pnb12.visible:=true;
               pnb12.Bitmap:=drawmenuicon(pnb12.Caption);
               pnba12.visible:=true;
               pnba12.Bitmap:=pnb12.Bitmap;
               end;
            end;
         13: begin
         mb13.caption:=s2;
         mb13.visible:=true;
         mb13.Bitmap:=drawmenuicon(mb13.Caption);
         pmjb13.caption:=s2;
         pmjb13.visible:=true;
         pmjb13.Bitmap:=mb13.Bitmap;
         pnb13.caption:=s1;
         pnba13.caption:=s1;
         if s1<>'' then
            begin
            pnb13.visible:=true;
            pnb13.Bitmap:=drawmenuicon(pnb13.Caption);
            pnba13.visible:=true;
            pnba13.Bitmap:=pnb13.Bitmap;
            end;
         end;
         14: begin
         mb14.caption:=s2;
         mb14.visible:=true;
         mb14.Bitmap:=drawmenuicon(mb14.Caption);
         pmjb14.caption:=s2;
         pmjb14.visible:=true;
         pmjb14.Bitmap:=mb14.Bitmap;
         pnb14.caption:=s1;
         pnba14.caption:=s1;
         if s1<>'' then
            begin
            pnb14.visible:=true;
            pnb14.Bitmap:=drawmenuicon(pnb14.Caption);
            pnba14.visible:=true;
            pnba14.Bitmap:=pnb14.Bitmap;
            end;
         end;
         15: begin
         mb15.caption:=s2;
         mb15.visible:=true;
         mb15.Bitmap:=drawmenuicon(mb15.Caption);
         pmjb15.caption:=s2;
         pmjb15.visible:=true;
         pmjb15.Bitmap:=mb15.Bitmap;
         pnb15.caption:=s1;
         pnba15.caption:=s1;
         if s1<>'' then
            begin
            pnb15.visible:=true;
            pnb15.Bitmap:=drawmenuicon(pnb15.Caption);
            pnba15.visible:=true;
            pnba15.Bitmap:=pnb15.Bitmap;
            end;
         end;
         16: begin
         mb16.caption:=s2;
         mb16.visible:=true;
         mb16.Bitmap:=drawmenuicon(mb16.Caption);
         pmjb16.caption:=s2;
         pmjb16.visible:=true;
         pmjb16.Bitmap:=mb16.Bitmap;
         pnb16.caption:=s1;
         pnba16.caption:=s1;
         if s1<>'' then
            begin
            pnb16.visible:=true;
            pnb16.Bitmap:=drawmenuicon(pnb16.Caption);
            pnba16.visible:=true;
            pnba16.Bitmap:=pnb16.Bitmap;
            end;
         end;
         17: begin
         mb17.caption:=s2;
         mb17.visible:=true;
         mb17.Bitmap:=drawmenuicon(mb17.Caption);
         pmjb17.caption:=s2;
         pmjb17.visible:=true;
         pmjb17.Bitmap:=mb17.Bitmap;
         pnb17.caption:=s1;
         pnba17.caption:=s1;
         if s1<>'' then
            begin
            pnb17.visible:=true;
            pnb17.Bitmap:=drawmenuicon(pnb17.Caption);
            pnba17.visible:=true;
            pnba17.Bitmap:=pnb17.Bitmap;
            end;
         end;
         18: begin
         mb18.caption:=s2;
         mb18.visible:=true;
         mb18.Bitmap:=drawmenuicon(mb18.Caption);
         pmjb18.caption:=s2;
         pmjb18.visible:=true;
         pmjb18.Bitmap:=mb18.Bitmap;
         pnb18.caption:=s1;
         pnba18.caption:=s1;
         if s1<>'' then
            begin
            pnb18.visible:=true;
            pnb18.Bitmap:=drawmenuicon(pnb18.Caption);
            pnba18.visible:=true;
            pnba18.Bitmap:=pnb18.Bitmap;
            end;
         end;
         19: begin
         mb19.caption:=s2;
         mb19.visible:=true;
         mb19.Bitmap:=drawmenuicon(mb19.Caption);
         pmjb19.caption:=s2;
         pmjb19.visible:=true;
         pmjb19.Bitmap:=mb19.Bitmap;
         pnb19.caption:=s1;
         pnba19.caption:=s1;
         if s1<>'' then
            begin
            pnb19.visible:=true;
            pnb19.Bitmap:=drawmenuicon(pnb19.Caption);
            pnba19.visible:=true;
            pnba19.Bitmap:=pnb19.Bitmap;
            end;
         end;
         20: begin
         mb20.caption:=s2;
         mb20.visible:=true;
         mb20.Bitmap:=drawmenuicon(mb20.Caption);
         pmjb20.caption:=s2;
         pmjb20.visible:=true;
         pmjb20.Bitmap:=mb20.Bitmap;
         pnb20.caption:=s1;
         pnba20.caption:=s1;
         if s1<>'' then
            begin
            pnb20.visible:=true;
            pnb20.Bitmap:=drawmenuicon(pnb20.Caption);
            pnba20.visible:=true;
            pnba20.Bitmap:=pnb20.Bitmap;
            end;
         end;
         21: begin
            mb21.caption:=s2;
            mb21.visible:=true;
            mb21.Bitmap:=drawmenuicon(mb21.Caption);
            pmjb21.caption:=s2;
            pmjb21.visible:=true;
            pmjb21.Bitmap:=mb21.Bitmap;
            pnb21.caption:=s1;
            pnba21.caption:=s1;
            if s1<>'' then
               begin
               pnb21.visible:=true;
               pnb21.Bitmap:=drawmenuicon(pnb21.Caption);
               pnba21.visible:=true;
               pnba21.Bitmap:=pnb21.Bitmap;
               end;
            end;
         22: begin
            mb22.caption:=s2;
            mb22.visible:=true;
            mb22.Bitmap:=drawmenuicon(mb22.Caption);
            pmjb22.caption:=s2;
            pmjb22.visible:=true;
            pmjb22.Bitmap:=mb22.Bitmap;
            pnb22.caption:=s1;
            pnba22.caption:=s1;
            if s1<>'' then
               begin
               pnb22.visible:=true;
               pnb22.Bitmap:=drawmenuicon(pnb22.Caption);
               pnba22.visible:=true;
               pnba22.Bitmap:=pnb22.Bitmap;
               end;
            end;
         23: begin
         mb23.caption:=s2;
         mb23.visible:=true;
         mb23.Bitmap:=drawmenuicon(mb23.Caption);
         pmjb23.caption:=s2;
         pmjb23.visible:=true;
         pmjb23.Bitmap:=mb23.Bitmap;
         pnb23.caption:=s1;
         pnba23.caption:=s1;
         if s1<>'' then
            begin
            pnb23.visible:=true;
            pnb23.Bitmap:=drawmenuicon(pnb23.Caption);
            pnba23.visible:=true;
            pnba23.Bitmap:=pnb23.Bitmap;
            end;
         end;
         end;
      end;
pmemb1.caption:=pnb1.caption;
pmemb2.caption:=pnb2.caption;
pmemb3.caption:=pnb3.caption;
pmemb4.caption:=pnb4.caption;
pmemb5.caption:=pnb5.caption;
pmemb6.caption:=pnb6.caption;
pmemb7.caption:=pnb7.caption;
pmemb8.caption:=pnb8.caption;
pmemb1.visible:=pnb1.visible;
pmemb2.visible:=pnb2.visible;
pmemb3.visible:=pnb3.visible;
pmemb4.visible:=pnb4.visible;
pmemb5.visible:=pnb5.visible;
pmemb6.visible:=pnb6.visible;
pmemb7.visible:=pnb7.visible;
pmemb8.visible:=pnb8.visible;
pmemb1.Bitmap:=pnb1.Bitmap;
pmemb2.Bitmap:=pnb2.Bitmap;
pmemb3.Bitmap:=pnb3.Bitmap;
pmemb4.Bitmap:=pnb4.Bitmap;
pmemb5.Bitmap:=pnb5.Bitmap;
pmemb6.Bitmap:=pnb6.Bitmap;
pmemb7.Bitmap:=pnb7.Bitmap;
pmemb8.Bitmap:=pnb8.Bitmap;
pmembf1.visible:=pmjb1.visible;
pmembf2.visible:=pmjb2.visible;
pmembf3.visible:=pmjb3.visible;
pmembf4.visible:=pmjb4.visible;
pmembf5.visible:=pmjb5.visible;
pmembf6.visible:=pmjb6.visible;
pmembf7.visible:=pmjb7.visible;
pmembf8.visible:=pmjb8.visible;
if pmembf1.caption=txt_mypc then pmembf1.visible:=false;
if pmembf2.caption=txt_mypc then pmembf2.visible:=false;
if pmembf3.caption=txt_mypc then pmembf3.visible:=false;
if pmembf4.caption=txt_mypc then pmembf4.visible:=false;
if pmembf5.caption=txt_mypc then pmembf5.visible:=false;
if pmembf6.caption=txt_mypc then pmembf6.visible:=false;
if pmembf7.caption=txt_mypc then pmembf7.visible:=false;
if pmembf8.caption=txt_mypc then pmembf8.visible:=false;
pmembf1.Bitmap:=pmjb1.Bitmap;
pmembf2.Bitmap:=pmjb2.Bitmap;
pmembf3.Bitmap:=pmjb3.Bitmap;
pmembf4.Bitmap:=pmjb4.Bitmap;
pmembf5.Bitmap:=pmjb5.Bitmap;
pmembf6.Bitmap:=pmjb6.Bitmap;
pmembf7.Bitmap:=pmjb7.Bitmap;
pmembf8.Bitmap:=pmjb8.Bitmap;

mexttob1.caption:=pnb1.caption;
mexttob2.caption:=pnb2.caption;
mexttob3.caption:=pnb3.caption;
mexttob4.caption:=pnb4.caption;
mexttob5.caption:=pnb5.caption;
mexttob6.caption:=pnb6.caption;
mexttob7.caption:=pnb7.caption;
mexttob8.caption:=pnb8.caption;
mexttob1.visible:=pnb1.visible;
mexttob2.visible:=pnb2.visible;
mexttob3.visible:=pnb3.visible;
mexttob4.visible:=pnb4.visible;
mexttob5.visible:=pnb5.visible;
mexttob6.visible:=pnb6.visible;
mexttob7.visible:=pnb7.visible;
mexttob8.visible:=pnb8.visible;
mexttob1.Bitmap:=pnb1.Bitmap;
mexttob2.Bitmap:=pnb2.Bitmap;
mexttob3.Bitmap:=pnb3.Bitmap;
mexttob4.Bitmap:=pnb4.Bitmap;
mexttob5.Bitmap:=pnb5.Bitmap;
mexttob6.Bitmap:=pnb6.Bitmap;
mexttob7.Bitmap:=pnb7.Bitmap;
mexttob8.Bitmap:=pnb8.Bitmap;
CopyMenuItems(mBookmarks,pmnavbooks.Items,0);
end;
populatetree;
end;

function check_duplicated_bookmark(s,s1,s2,s3:ansistring):integer;
var
   i:integer;
begin
check_duplicated_bookmark:=-1;
for i:=1 to FormPeach.StringGridBookmarks.RowCount-1 do
   if (FormPeach.StringGridBookmarks.Cells[2,i]=s)
   and (FormPeach.StringGridBookmarks.Cells[1,i]=s1)
   and (FormPeach.StringGridBookmarks.Cells[4,i]=s2)
   and (FormPeach.StringGridBookmarks.Cells[5,i]=s3) then
      begin
      check_duplicated_bookmark:=-1;
      exit;
      end;
check_duplicated_bookmark:=0;
end;

procedure addtobookmarks(s:ansistring);
var
   i,rc:integer;
   s1,s2,s3:ansistring;
begin
s1:=txt_list_browsing;
s2:='*';
s3:='';
case s of
   '*browser':
   begin
   if fun='FILEBROWSER' then
      s:=FormPeach.EditOpenIn.Text //ignore selection
   else
      begin
      s:='*current';
      end;
   end;
   '*browsercontext':
   begin
   if fun='FILEBROWSER' then
      if checklistsel<>0 then s:=FormPeach.EditOpenIn.Text
      else s:=FormPeach.StringGridList.Cells[12,FormPeach.StringGridList.Row]
   else
      begin
      s:='*current';
      end;
   end;
   '*layout':
   begin
   {$IFDEF MSWINDOWS}if FormPeach.PanelArchive.Visible=true{$ELSE}if FormPeach.PanelArchive.Top=0{$ENDIF} then s:=FormPeach.StringGridAdd.Cells[8,FormPeach.StringGridAdd.Row]
   else s:=FormPeach.StringGridExtract.Cells[8,FormPeach.StringGridExtract.Row];
   end;
   '*history':
   begin
   s:=FormPeach.StringGridSessionHistory.Cells[2,FormPeach.StringGridSessionHistory.Row];
   s1:=FormPeach.StringGridSessionHistory.Cells[1,FormPeach.StringGridSessionHistory.Row];
   s2:=FormPeach.StringGridSessionHistory.Cells[3,FormPeach.StringGridSessionHistory.Row];
   s3:=FormPeach.StringGridSessionHistory.Cells[4,FormPeach.StringGridSessionHistory.Row];
   end;
   '*recent':
   begin
   s:=FormPeach.StringGridrecent.Cells[1,FormPeach.StringGridrecent.Row];
   s1:=txt_list_browsing;
   s2:='*';
   s3:='';
   end;
   end;

if s='*current' then
   begin
   rc:=FormPeach.StringGridSessionHistory.Rowcount-1;
   s:=FormPeach.StringGridSessionHistory.Cells[2,rc];
   s1:=FormPeach.StringGridSessionHistory.Cells[1,rc];
   s2:=FormPeach.StringGridSessionHistory.Cells[3,rc];
   s3:=FormPeach.StringGridSessionHistory.Cells[4,rc];
   end;

if s<>txt_mypc then
   if filegetattr(escapefilename(s,desk_env)) and faDirectory <>0 then
      if s<>'' then
         if s[length(s)]<>directoryseparator then s:=s+directoryseparator;
if check_duplicated_bookmark(s,s1,s2,s3)=0 then
   begin
   rc:=FormPeach.StringGridBookmarks.Rowcount+1;
   FormPeach.StringGridBookmarks.RowCount:=rc;
   FormPeach.StringGridBookmarks.Cells[2,rc-1]:=s;
   FormPeach.StringGridBookmarks.Cells[1,rc-1]:=s1;
   FormPeach.StringGridBookmarks.Cells[3,rc-1]:=extractbookmarkname(s);
   FormPeach.StringGridBookmarks.Cells[4,rc-1]:=s2;
   FormPeach.StringGridBookmarks.Cells[5,rc-1]:=s3;
   if savehistory=1 then
      FormPeach.StringGridBookmarks.Cells[9,rc-1]:=FormatDateTime('yyyy-mm-dd hh:mm:ss',now)
   else
      FormPeach.StringGridBookmarks.Cells[9,rc-1]:='';
   FormPeach.StringGridBookmarks.AutosizeColumns;
   FormPeach.StringGridBookmarks.ColWidths[10]:=0;
   FormPeach.StringGridBookmarks.ColWidths[11]:=0;
   FormPeach.StringGridBookmarks.ColWidths[0]:=rowsize;
   for i:=1 to FormPeach.StringGridBookmarks.RowCount-2 do FormPeach.StringGridBookmarks.Cells[11,i]:='0';
   FormPeach.StringGridBookmarks.Cells[11,FormPeach.StringGridBookmarks.RowCount-1]:='1';
   end;
populatebookmarks;
end;

procedure set_group_fm(cond:boolean);
begin
with FormPeach do
begin
po_newfolder.visible:=cond;
MenuItem26.visible:=cond;
po_renmenu.visible:=cond;
po_rename.visible:=cond;
pmr_ren.visible:=cond;
po_rename_lowercase.visible:=cond;
po_rename_uppercase.visible:=cond;
po_rename_timestamp.visible:=cond;
po_rename_appenddir.visible:=cond;
po_rename_prependdir.visible:=cond;
Po_rename_123.visible:=cond;
po_rename_add.visible:=cond;
po_rename_delete.visible:=cond;
po_rename_replace.visible:=cond;
po_rename_replace_case.visible:=cond;
po_rename_ext.visible:=cond;
po_rename_cutlen.visible:=cond;
po_rename_ascii.visible:=cond;
po_rename_separator.visible:=cond;
MenuItem119.visible:=cond;
separator2.visible:=cond;
Separator3.visible:=cond;
po_rename_filesonly.visible:=cond;
pmr_files.visible:=cond;
MenuItem7.visible:=cond;
MenuItem56.visible:=cond;
if fun='UN7Z' then
   begin
   po_newfolder.visible:=true;
   MenuItem26.visible:=true;
   po_renmenu.visible:=true;
   MenuItem7.visible:=true;
   po_rename.visible:=true;
   pmr_ren.visible:=true;
   po_rename_lowercase.visible:=true;
   po_rename_uppercase.visible:=true;
   po_rename_timestamp.visible:=true;
   po_rename_appenddir.visible:=true;
   po_rename_prependdir.visible:=true;
   Po_rename_123.visible:=true;
   po_rename_add.visible:=true;
   po_rename_delete.visible:=true;
   po_rename_replace.visible:=true;
   po_rename_replace_case.visible:=true;
   po_rename_ext.visible:=true;
   po_rename_cutlen.visible:=true;
   po_rename_ascii.visible:=true;
   po_rename_separator.visible:=true;
   MenuItem119.visible:=true;
   po_rename_filesonly.visible:=true;
   separator2.visible:=true;
   Separator3.visible:=true;
   pmr_files.visible:=true;
   MenuItem56.visible:=true;
   end;
{$IFDEF MSWINDOWS}FormPeach.po_recycle.Visible:=cond;{$ENDIF}
{$IFDEF DARWIN}FormPeach.po_recycle.Visible:=cond;{$ENDIF}
separator37.visible:=cond;
po_delete.Visible:=cond;
po_securedelete.Visible:=cond;
po_zerofile.Visible:=cond;
po_zerofree.Visible:=cond;
po_securedeletefree.Visible:=cond;
MenuItem16.visible:=cond;
po_copyto.visible:=cond;
po_moveto.visible:=cond;
if fun='UN7Z' then po_moveto.visible:=true;
po_copy.visible:=cond;
po_cut.visible:=cond;
po_paste.visible:=cond;
//MenuItem67.visible:=cond;
end;
end;

procedure filebrowsermenus;
begin
with FormPeach do
begin
po_open.visible:=true;
po_windowopen.visible:=true;
po_exthere.visible:=true;
po_addsep.visible:=true;
if EditOpenIn.Text=txt_mypc then
   begin
   po_list.visible:=true;
   set_group_fm(false);
   end
else
   begin
   //po_open_asarchive.visible:=true;
   //po_open_asarchivet.visible:=true;
   //Menuitem77.visible:=true;
   po_test.visible:=true;
   po_info.visible:=true;
   po_list.visible:=true;
   po_filetools.visible:=true;
   MenuItem145.Visible:=true;
   po_more.Visible:=true;
   po_pdup.Visible:=true;
   po_checksum.Visible:=true;
   po_dedup.Visible:=true;
   po_analyzefolders.Visible:=true;
   pmfilebrowser.Visible:=true;
   pmpanalyzefolders.Visible:=true;
   pmpdup.Visible:=true;
   pmcheck.Visible:=true;
   Separator17.visible:=true;
   po_im.visible:=true;
   MenuItemForceThumbnails.visible:=true;
   set_group_fm(true);
   end;
MenuItemOpen_ExtractHere.Visible:=false;
pmmorefun_details.Enabled:=true;
pmmorefun_list.Enabled:=true;
pmmorefun_info.Enabled:=true;
pmmorerr.Visible:=false;
if (havewinrar=true) and (userar=1) then pmmorerecover.Visible:=true;
po_rr.Visible:=false;
if (havewinrar=true) and (userar=1) then po_recover.Visible:=true;
end;
end;

procedure advancedarchivebrowsermenus;
begin
with FormPeach do
begin
MenuItemOpen_ExtractHere.Visible:=true;
MenuItemOpen_test.Visible:=true;
MenuItemOpen_list.Visible:=true;
MenuItemOpen_preview.visible:=true;
po_windowopen.visible:=true;
if enableextand=1 then MenuItemOpen_extandopenwith.visible:=true
else MenuItemOpen_extandopenwith.visible:=false;
MenuItem120.Visible:=true;
mForceSyncedits.Visible:=true;
mForceSynceditsClear.Visible:=true;
mForceClear.Visible:=true;
pmmorefun_details.Enabled:=true;
pmmorefun_list.Enabled:=true;
pmmorefun_info.Enabled:=true;
pmmorerr.Visible:=false;
pmmorerecover.Visible:=false;
po_rr.Visible:=false;
po_recover.Visible:=false;
end;
end;

procedure set_extcontext_off;
begin
FormPeach.pmextcontextdisplayed.enabled:=false;
FormPeach.pmextcontextselected.enabled:=false;
FormPeach.pmqedisplayed.enabled:=false;
FormPeach.pmqeselected.enabled:=false;
FormPeach.pmtestcontextdisplayed.enabled:=false;
FormPeach.pmtestcontextselected.enabled:=false;
end;

procedure set_extcontext_on;
begin
FormPeach.pmextcontextdisplayed.enabled:=true;
FormPeach.pmextcontextselected.enabled:=true;
FormPeach.pmqedisplayed.enabled:=true;
FormPeach.pmqeselected.enabled:=true;
FormPeach.pmtestcontextdisplayed.enabled:=true;
FormPeach.pmtestcontextselected.enabled:=true;
end;

procedure setbuttonmenus;
begin
with FormPeach do
begin
ButtonUn7zaTo.Enabled:=true;
set_extcontext_off;
ButtonUn7zaTest.Enabled:=false;
ButtonDelete.Enabled:=false;
ButtonUn7zaAdd.Enabled:=false;
ButtonUn7zaAdd.Hint:='';
po_addtoarchive.Enabled:=false;
po_exthere.visible:=false;
po_addsep.visible:=false;
po_test.visible:=false;
po_info.visible:=false;
po_list.visible:=false;
po_open.visible:=false;
po_windowopen.visible:=false;
//po_open_asarchive.visible:=false;
//po_open_asarchivet.visible:=false;
//Menuitem77.visible:=false;
sbBrowse.Visible:=false;
set_group_fm(false);
po_filetools.visible:=false;
MenuItem145.Visible:=false;
po_more.Visible:=false;
po_pdup.Visible:=false;
po_checksum.Visible:=false;
po_dedup.Visible:=false;
po_analyzefolders.Visible:=false;
pmfilebrowser.Visible:=false;
pmpanalyzefolders.Visible:=false;
pmpdup.Visible:=false;
pmcheck.Visible:=false;
Separator17.visible:=false;
po_im.visible:=false;
MenuItemForceThumbnails.visible:=false;
MenuItemOpen_preview.visible:=false;
MenuItemOpen_test.Visible:=false;
MenuItemOpen_info.Visible:=false;
MenuItemOpen_list.Visible:=false;
MenuItem120.Visible:=false;
mForceSyncedits.Visible:=false;
mForceSynceditsClear.Visible:=false;
mForceClear.Visible:=false;
MenuItemOpen_extandopenwith.visible:=false;
pmmorefun_details.Enabled:=false;
pmmorefun_list.Enabled:=false;
pmmorefun_info.Enabled:=false;
case fun of
   'FILEBROWSER':
   begin
   ButtonUn7zaTest.Enabled:=true;
   po_addtoarchive.Enabled:=true;
   ButtonDelete.Enabled:=true;
   ButtonUn7zaAdd.Enabled:=true;
   ButtonUn7zaAdd.Hint:=txt_add_tolayout;
   filebrowsermenus;
   sbBrowse.Visible:=true;
   end;
   'UN7Z':
   begin
   ButtonUn7zaTest.Enabled:=true;
   po_addtoarchive.Enabled:=true;
   ButtonDelete.Enabled:=true;
   ButtonUn7zaAdd.Enabled:=true;
   ButtonUn7zaAdd.Hint:=txt_add_toarchive;
   advancedarchivebrowsermenus;
   sbBrowse.Visible:=true;
   MenuItemOpen_info.Visible:=true;
   end;
   'UNARC':
   begin
   ButtonUn7zaTest.Enabled:=true;
   po_addtoarchive.Enabled:=true;
   ButtonDelete.Enabled:=true;
   ButtonUn7zaAdd.Enabled:=true;
   ButtonUn7zaAdd.Hint:=txt_add_toarchive;
   advancedarchivebrowsermenus;
   mForceSyncedits.Visible:=false;
   mForceSynceditsClear.Visible:=false;
   mForceClear.Visible:=false;
   MenuItem120.Visible:=false;
   end;
   'UNZPAQ':
   begin
   ButtonUn7zaTest.Enabled:=true;
   po_addtoarchive.Enabled:=true;
   ButtonUn7zaAdd.Enabled:=true;
   ButtonUn7zaAdd.Hint:=txt_add_toarchive;
   end;
   'UNBROTLI': ButtonUn7zaTest.Enabled:=true;
   'UNZSTD': ButtonUn7zaTest.Enabled:=true;
   end;
ImageFlatadd.Enabled:=ButtonUn7zaAdd.Enabled;
ImageFlatconvert.Enabled:=ButtonUn7zaConvert.Enabled;
ImageFlatext.Enabled:=ButtonUn7zaTo.Enabled;
end;
end;

procedure prepare_filebrowser;
begin
setpanel_extract(1);
set_extcontext_off;
{$IFDEF MSWINDOWS}FormPeach.po_delete.Caption:=txt_quickdelete+' (Shift+Del)';{$ELSE}FormPeach.po_delete.Caption:=txt_quickdelete;{$ENDIF}
end;

procedure set_organizebrowsermenu_sort(c:integer);
begin
FormPeach.mbrowsercname.Checked:=false;
FormPeach.mbrowserctype.Checked:=false;
FormPeach.mbrowsercsize.Checked:=false;
FormPeach.mbrowsercpacked.Checked:=false;
FormPeach.mbrowsercdate.Checked:=false;
FormPeach.mbrowserccreated.Checked:=false;
FormPeach.mbrowsercaccessed.Checked:=false;
FormPeach.mbrowsercmethod.Checked:=false;
FormPeach.mbrowserccomment.Checked:=false;
FormPeach.mbrowsercatt.Checked:=false;
FormPeach.mbrowserccrc.Checked:=false;
FormPeach.mbrowsercname.Caption:=FormPeach.ListViewBrowser.Column[0].Caption;
FormPeach.mbrowserctype.Caption:=FormPeach.ListViewBrowser.Column[1].Caption;
FormPeach.mbrowsercsize.Caption:=FormPeach.ListViewBrowser.Column[2].Caption;
FormPeach.mbrowsercpacked.Caption:=txt_info+' / '+txt_compressed_size;//FormPeach.ListViewBrowser.Column[3].Caption;
FormPeach.mbrowsercdate.Caption:=FormPeach.ListViewBrowser.Column[4].Caption;
FormPeach.mbrowserccreated.Caption:=FormPeach.ListViewBrowser.Column[5].Caption;
FormPeach.mbrowsercaccessed.Caption:=FormPeach.ListViewBrowser.Column[6].Caption;
FormPeach.mbrowsercmethod.Caption:=FormPeach.ListViewBrowser.Column[7].Caption;
FormPeach.mbrowserccomment.Caption:=FormPeach.ListViewBrowser.Column[8].Caption;
FormPeach.mbrowsercatt.Caption:=FormPeach.ListViewBrowser.Column[9].Caption;
FormPeach.mbrowserccrc.Caption:=FormPeach.ListViewBrowser.Column[10].Caption;
case c of
   0: begin FormPeach.mbrowsercname.Checked:=true; end;
   1: begin FormPeach.mbrowserctype.Checked:=true; end;
   2: begin FormPeach.mbrowsercsize.Checked:=true; end;
   3: begin FormPeach.mbrowsercpacked.Checked:=true; end;
   4: begin FormPeach.mbrowsercdate.Checked:=true; end;
   5: begin FormPeach.mbrowserccreated.Checked:=true; end;
   6: begin FormPeach.mbrowsercaccessed.Checked:=true; end;
   7: begin FormPeach.mbrowsercmethod.Checked:=true; end;
   8: begin FormPeach.mbrowserccomment.Checked:=true; end;
   9: begin FormPeach.mbrowsercatt.Checked:=true; end;
   10: begin FormPeach.mbrowserccrc.Checked:=true; end;
   end;
FormPeach.po_browsercname.Checked:=FormPeach.mbrowsercname.Checked;
FormPeach.po_browserctype.Checked:=FormPeach.mbrowserctype.Checked;
FormPeach.po_browsercsize.Checked:=FormPeach.mbrowsercsize.Checked;
FormPeach.po_browsercpacked.Checked:=FormPeach.mbrowsercpacked.Checked;
FormPeach.po_browsercdate.Checked:=FormPeach.mbrowsercdate.Checked;
FormPeach.po_browserccreated.Checked:=FormPeach.mbrowserccreated.Checked;
FormPeach.po_browsercaccessed.Checked:=FormPeach.mbrowsercaccessed.Checked;
FormPeach.po_browsercmethod.Checked:=FormPeach.mbrowsercmethod.Checked;
FormPeach.po_browserccomment.Checked:=FormPeach.mbrowserccomment.Checked;
FormPeach.po_browsercatt.Checked:=FormPeach.mbrowsercatt.Checked;
FormPeach.po_browserccrc.Checked:=FormPeach.mbrowserccrc.Checked;
FormPeach.po_browsercname.Caption:=FormPeach.mbrowsercname.Caption;
FormPeach.po_browserctype.Caption:=FormPeach.mbrowserctype.Caption;
FormPeach.po_browsercsize.Caption:=FormPeach.mbrowsercsize.Caption;
FormPeach.po_browsercpacked.Caption:=FormPeach.mbrowsercpacked.Caption;
FormPeach.pmcpacked.Caption:=FormPeach.mbrowsercpacked.Caption;
FormPeach.mcpacked.Caption:=FormPeach.mbrowsercpacked.Caption;
FormPeach.po_browsercdate.Caption:=FormPeach.mbrowsercdate.Caption;
FormPeach.po_browserccreated.Caption:=FormPeach.mbrowserccreated.Caption;
FormPeach.po_browsercaccessed.Caption:=FormPeach.mbrowsercaccessed.Caption;
FormPeach.po_browsercmethod.Caption:=FormPeach.mbrowsercmethod.Caption;
FormPeach.po_browserccomment.Caption:=FormPeach.mbrowserccomment.Caption;
FormPeach.po_browsercatt.Caption:=FormPeach.mbrowsercatt.Caption;
FormPeach.po_browserccrc.Caption:=FormPeach.mbrowserccrc.Caption;
end;

procedure settoolbarw;
begin
with FormPeach do
begin
case lasttoolbar of
1: PanelBarOpen1.Width:=ButtonUn7zaAdd.Width+ButtonUn7zaTo.Width+
ButtonUn7zaTest.Width+ButtonPropertiesActions.Width+ButtonUn7zaConvert.Width+ButtonExtractActions.Width+
ButtonConvertActions.Width+ButtonAddActions.Width+ButtonTestActions.Width+ButtonDelete.Width+8;
2: PanelBarOpen2.Width:=ButtonCopy.Width+ButtonCut.Width+ButtonPaste.Width+
Buttoncmto.Width+ButtonOpenWith.Width+Buttonopenactions.Width+ButtonRename.Width+
Buttonfmactions.Width+Buttonfmactions1.Width+ButtonDup.Width+ButtonNF.Width+8;
3: PanelBarOpen3.Width:=ButtonDup1.Width+ButtonImgResize.Width+ButtonImgCrop.Width+
ButtonImgRL.Width+ButtonImgRR.Width+(ButtonImg6.Width*3)+ButtonRename1.Width+8;
end;
if toolcentered=1 then
   begin
   PanelBarOpen1.AnchorSideLeft.Side:=asrCenter;
   PanelBarOpen2.AnchorSideLeft.Side:=asrCenter;
   PanelBarOpen3.AnchorSideLeft.Side:=asrCenter;
   end
else
   begin
   PanelBarOpen1.AnchorSideLeft.Side:=asrLeft;
   PanelBarOpen2.AnchorSideLeft.Side:=asrLeft;
   PanelBarOpen3.AnchorSideLeft.Side:=asrLeft;
   end;
end;
end;

procedure settoolbardisp;
begin
with FormPeach do
begin
{$IFNDEF MSWINDOWS}
ButtonProperties.Visible:=false;
MenuItemProperties.Visible:=false;
mProperties.Visible:=false;
pmProperties.Visible:=false;
{$ENDIF}
if lasttoolbar=1 then
   begin
   if fun='FILEBROWSER' then ButtonDelete.Caption:=txt_securedelete
   else ButtonDelete.Caption:=txt_2_5_delete_fromarchive;
   end;
if lasttoolbar=2 then
   if fun<>'FILEBROWSER' then
      begin
      ButtonCut.Enabled:=false;
      ButtonCopy.Enabled:=false;
      ButtonPaste.Enabled:=false;
      Buttoncmto.Enabled:=false;
      ButtonNF.Enabled:=false;
      ButtonDup.Enabled:=false;
      ButtonRename.Enabled:=false;
      Buttonfmactions1.Enabled:=false;
      ButtonOpenWith.Caption:=txt_previewwith;
      ButtonOpenWith.Enabled:=false;
      Buttonopenactions.Enabled:=false;
      if fun='UN7Z' then
         begin
         ButtonRename.Enabled:=true;
         Buttonfmactions1.Enabled:=true;
         ButtonNF.Enabled:=true;
         end;
      if (fun='UN7Z') or (fun='UNARC') then
         begin
         ButtonOpenWith.Enabled:=true;
         Buttonopenactions.Enabled:=true;
         end;
      end
   else
      begin
      ButtonCut.Enabled:=true;
      ButtonCopy.Enabled:=true;
      ButtonPaste.Enabled:=true;
      Buttoncmto.Enabled:=true;
      ButtonNF.Enabled:=true;
      ButtonDup.Enabled:=true;
      ButtonRename.Enabled:=true;
      Buttonfmactions1.Enabled:=true;
      ButtonOpenWith.Caption:=txt_openwith;
      ButtonOpenWith.Enabled:=true;
      Buttonopenactions.Enabled:=true;
      end;
if lasttoolbar=3 then
   if fun<>'FILEBROWSER' then
      begin
      ButtonDup1.enabled:=false;
      ButtonRename1.Enabled:=false;
      ButtonImgResize.enabled:=false;
      ButtonImgCrop.enabled:=false;
      ButtonImgR.enabled:=false;
      ButtonImgRes.enabled:=false;
      ButtonImgRL.enabled:=false;
      ButtonImgRR.enabled:=false;
      if fun='UN7Z' then
         begin
         ButtonRename1.Enabled:=true;
         end;
      end
   else
      begin
      ButtonDup1.enabled:=true;
      ButtonRename1.Enabled:=true;
      ButtonImgResize.enabled:=true;
      ButtonImgCrop.enabled:=true;
      ButtonImgR.enabled:=true;
      ButtonImgRes.enabled:=true;
      ButtonImgRL.enabled:=true;
      ButtonImgRR.enabled:=true;
      end;
if lasttoolbar=2 then ImageFlatdup.Enabled:=ButtonDup.Enabled else ImageFlatdup.Enabled:=ButtonDup1.Enabled;
ImageFlatfolder.Enabled:=ButtonNF.Enabled;
ImageFlatren.Enabled:=ButtonRename.Enabled;
ImageFlattransform.Enabled:=ButtonImgRes.Enabled;
ImageFlatcrop.Enabled:=ButtonImgCrop.Enabled;
end;
end;

procedure addmenuenable(enmode:integer);
begin
case enmode of
0: begin FormPeach.ButtonConvertActions.enabled:=false; FormPeach.ButtonAddActions.enabled:=false; end;
1: begin FormPeach.ButtonConvertActions.enabled:=true; FormPeach.ButtonAddActions.enabled:=true; end;
end;
end;

procedure showbar(s:ansistring);
begin
prevbar:=lastbar;
with FormPeach do
   begin
   MenuItemOrganizeStatusbar.Checked:=true;
   mshowstatusbar.Checked:=true;
   pmmstatus_status.Checked:=false;
   pmmstatus_bookmarks.Checked:=false;
   pmmstatus_ra.Checked:=false;
   pmmstatus_r.Checked:=false;
   pmmstatus_clipboard.Checked:=false;
   pmstatusnone.Checked:=false;
   SplitterBottom.Enabled:=true;
   SplitterBottom.Color:=stringtocolor(colbtnhigh);
   pmclip.Checked:=false;
   po_clip.Checked:=false;
   case s of
      'none' :
      begin
      MenuItemOrganizeStatusbar.Checked:=false;
      mshowstatusbar.Checked:=false;
      SplitterBottom.top:=PanelFilters.Height;
      lastbar:=1;
      PanelBottom.visible:=false;
      stringgridrecent.visible:=false;
      StringGridSessionHistory.visible:=false;
      stringgridbookmarks.visible:=false;
      PanelClipboard.visible:=false;
      pmstatusnone.Checked:=true;
      end;
      'statusbar' :
      begin
      SplitterBottom.top:=PanelFilters.Height-PanelBottom.Height;
      SplitterBottom.Color:=FormPeach.color;
      SplitterBottom.Enabled:=false;
      lastbar:=0;
      PanelBottom.visible:=true;
      stringgridrecent.visible:=false;
      StringGridSessionHistory.visible:=false;
      stringgridbookmarks.visible:=false;
      PanelClipboard.visible:=false;
      pmmstatus_status.Checked:=true;
      end;
      'bookmarks' :
      begin
      PanelBottom.visible:=false;
      stringgridrecent.visible:=false;
      StringGridSessionHistory.visible:=false;
      stringgridbookmarks.visible:=true;
      PanelClipboard.visible:=false;
      lastbar:=2;
      SplitterBottom.top:=PanelFilters.Height-splittersize;
      pmmstatus_bookmarks.Checked:=true;
      LabelInfoGeneral.Caption:=txt_bookmarks;
      end;
      'recent' :
      begin
      PanelBottom.visible:=false;
      stringgridrecent.visible:=true;
      StringGridSessionHistory.visible:=false;
      stringgridbookmarks.visible:=false;
      PanelClipboard.visible:=false;
      lastbar:=3;
      SplitterBottom.top:=PanelFilters.Height-splittersize;
      pmmstatus_ra.Checked:=true;
      LabelInfoGeneral.Caption:=txt_list_history;
      end;
      'sessionrecent' :
      begin
      PanelBottom.visible:=false;
      stringgridrecent.visible:=false;
      StringGridSessionHistory.visible:=true;
      stringgridbookmarks.visible:=false;
      PanelClipboard.visible:=false;
      lastbar:=4;
      SplitterBottom.top:=PanelFilters.Height-splittersize;
      pmmstatus_r.Checked:=true;
      LabelInfoGeneral.Caption:=txt_5_0_sh;
      end;
      'clip' :
      begin
      PanelBottom.visible:=false;
      stringgridrecent.visible:=false;
      StringGridSessionHistory.visible:=false;
      stringgridbookmarks.visible:=false;
      PanelClipboard.visible:=true;
      FormPeach.StringGridClipboard.Autosizecolumns;
      lastbar:=5;
      SplitterBottom.top:=PanelFilters.Height-splittersize;
      pmmstatus_clipboard.Checked:=true;
      LabelInfoGeneral.Caption:=txt_2_7_clipboard;
      pmclip.Checked:=true;
      po_clip.Checked:=true;
      end;
   end;
   end;
end;

procedure showpanel_prepare; //make invisible all panels
begin
with FormPeach do
   begin
   try
   shint:='';
   prevshint:='';
   h.hide;
   except
   end;
   {$IFDEF MSWINDOWS}
   PanelArchive.Visible:=false;
   PanelOpen.Visible:=false;
   PanelExtract.Visible:=false;
   PanelOptions.Visible:=false;
   {$ELSE}//sometimes panels remains visible, so hide them otherwise
   PanelArchive.Top:=10000;
   PanelOpen.Top:=10000;
   PanelExtract.Top:=10000;
   PanelOptions.Top:=10000;
   {$ENDIF}
   {mEdit.Visible:=false;
   mBrowse.Visible:=false;
   mOrganize.Visible:=false;
   mLayout.Visible:=false;}
   mEdit.Enabled:=false;
   mBrowse.Enabled:=false;
   mOrganize.Enabled:=false;
   mLayout.Enabled:=false;
   imported_tarbeforejob:=false;
   intdd:=false;
   marcopt.enabled:=true;
   mextopt.enabled:=true;
   end;
end;

procedure prepare_apps_panel;
begin
with FormPeach do
begin
LabelTitleApps1.Caption:='      '+txt_5_6_basic+'      ';
LabelTitleApps2.Caption:='      '+txt_2_6_advanced+'      ';
activelabel_apps:=LabelTitleApps1;
Caption:=txt_3_3_apps;
Labelcbadvanced.Caption:=txt_2_5_advanced;
Labelcbadvanced.Hint:=txt_2_5_custeditors;
Labelcbbasic.Caption:=txt_2_5_basic;
Labelcbbasic.Hint:=txt_2_5_custeditors;
Labelcbsample.Caption:=txt_sample;
pmCusteditDesc.Caption:=txt_note;
pmCusteditAdd.Caption:=txt_2_5_selectapp;
pmCusteditEdit.Caption:=txt_edit;
pmCusteditRemove.Caption:=txt_2_5_remove;
pmCusteditDesc1.Caption:=txt_note;
pmCusteditAdd1.Caption:=txt_2_5_selectapp;
pmCusteditEdit1.Caption:=txt_2_5_strbefore;
pmCusteditEdit1after.Caption:=txt_2_5_strafter;
pmCusteditRemove1.Caption:=txt_2_5_remove;
LabelResetApp1.Caption:=txt_reset+' '+txt_3_3_apps;
end;
end;

procedure savecustlist;
begin
with FormPeach do
begin
vexc1:=pcustom1.Caption;
vexc2:=pcustom2.Caption;
vexc3:=pcustom3.Caption;
vexc4:=pcustom4.Caption;
vexc5:=pcustom5.Caption;
vexc6:=pcustom6.Caption;
vexc7:=pcustom7.Caption;
vexc8:=pcustom8.Caption;
end;
end;

procedure restorecustlist;
begin
with FormPeach do
begin
pcustom1.Caption:=vexc1;
pcustom2.Caption:=vexc2;
pcustom3.Caption:=vexc3;
pcustom4.Caption:=vexc4;
pcustom5.Caption:=vexc5;
pcustom6.Caption:=vexc6;
pcustom7.Caption:=vexc7;
pcustom8.Caption:=vexc8;
end;
end;

procedure showfmmenu(menusrc:integer);
var
   p:tpoint;
begin
with FormPeach do
begin
MenuItem14.visible:=true;
pmbookmarks.visible:=true;
pmorganizebookmarks.visible:=true;
pmcommand.visible:=true;
pmpowershell.visible:=true;
pmexplore.visible:=true;
pmquickdelete.visible:=true;
pmsecuredelete.Visible:=true;
pmzerofile.Visible:=true;
MenuItem79.visible:=false;//disabled
pmzerofree.visible:=false;//disabled
pmsecuredeletefree.visible:=false;//disabled
pmrecycle.Visible:=false;
{$IFDEF MSWINDOWS}pmrecycle.Visible:=true;{$ENDIF}
{$IFDEF DARWIN}pmrecycle.Visible:=true;{$ENDIF}
MenuItem91.visible:=true;
MenuItem75.visible:=true;
pmcut.visible:=false;
pmcheck.visible:=true;
pmpdup.visible:=true;
pmws.visible:=true;
if fun='FILEBROWSER' then
   begin
   pmcpyto.Visible:=true;
   pmmvto.Visible:=true;
   pmnewfolder.Visible:=True;
   pmrename.Visible:=True;
   menuitem14.Visible:=True;
   //pmrecycle.Visible:=True;
   pmquickdelete.Visible:=True;
   pmzerofile.Visible:=True;
   pmsecuredelete.Visible:=True;
   end
else
   begin
   pmcheck.visible:=false;
   pmpdup.visible:=false;
   pmcpyto.Visible:=false;
   pmmvto.Visible:=false;
   pmnewfolder.Visible:=False;
   pmrename.Visible:=false;
   menuitem14.Visible:=false;
   pmrecycle.Visible:=false;
   pmquickdelete.Visible:=false;
   pmzerofile.Visible:=false;
   pmsecuredelete.Visible:=false;
   if fun='UN7Z' then
      begin
      pmmvto.Visible:=true;
      pmnewfolder.Visible:=true;
      pmrename.Visible:=true;
      end;
   end;
p.x:=0;
p.y:=0;
case menusrc of
1: begin
p.x:=ButtonPropertiesActions.left;
p.y:=ButtonPropertiesActions.top+ButtonPropertiesActions.height;
end;
2: begin
p.x:=buttoncmto.left;
p.y:=buttoncmto.top+ButtonPropertiesActions.height;
pmsecuredelete.Visible:=false;
pmzerofile.Visible:=false;
pmrecycle.Visible:=false;
pmquickdelete.visible:=false;
pmnewfolder.Visible:=False;
pmbookmarks.visible:=false;
pmorganizebookmarks.visible:=false;
pmcommand.visible:=false;
pmpowershell.visible:=false;
pmexplore.visible:=false;
MenuItem14.visible:=false;
pmcheck.visible:=false;
pmpdup.visible:=false;
pmws.visible:=false;
//MenuItem79.visible:=false;
//pmzerofree.visible:=false;
//pmsecuredeletefree.visible:=false;
MenuItem91.visible:=false;
MenuItem75.visible:=false;
pmrename.Visible:=false;
//pmcut.visible:=true;
pmproperties.visible:=false;
pmfilebrowser.visible:=false;
pmpanalyzefolders.Visible:=false;
pmpdup.Visible:=false;
pmcheck.Visible:=false;
Separator17.visible:=false;
end;
3: begin
p.x:=buttonfmactions.left;
p.y:=buttonfmactions.top+ButtonPropertiesActions.height;
end;
4: begin
p.x:=buttonimg6.left;
p.y:=buttonimg6.top+buttonimg6.height;
end;
end;
if swapbars=true then p.y:=p.y+PanelListBar.height+PanelTabBar.height;
p:=clienttoscreen(p);
pmmorefun.popup(p.x,p.y);
end;
end;

procedure togglemenubar;
begin
with FormPeach do
begin
if showmenu=false then
   begin
   {$IFDEF MSWINDOWS}if FormPeach.WindowState=wsNormal then FormPeach.Height:=FormPeach.Height-MainMenu1.Height;{$ENDIF}
   mshowmenu.checked:=false;
   pmshowmenu.checked:=false;
   MenuItemOrganizeMbar.checked:=false;
   mfeatures.visible:=false;
   medit.visible:=false;
   mBrowse.visible:=false;
   mOrganize.Visible:=false;
   mlayout.visible:=false;
   moptionsmenu.visible:=false;
   moptions.visible:=false;
   mhelp.visible:=false;
   mfeatures.enabled:=false;
   medit.enabled:=false;
   mBrowse.enabled:=false;
   mOrganize.enabled:=false;
   mlayout.enabled:=false;
   moptionsmenu.enabled:=false;
   moptions.enabled:=false;
   mhelp.enabled:=false;
   end
else
   begin
   mshowmenu.checked:=true;
   pmshowmenu.checked:=true;
   MenuItemOrganizeMbar.checked:=true;
   mfeatures.visible:=true;
   moptionsmenu.visible:=true;
   moptions.visible:=true;
   mhelp.visible:=true;
   mfeatures.Enabled:=true;
   moptionsmenu.Enabled:=true;
   moptions.Enabled:=true;
   mhelp.Enabled:=true;
   mLayout.Visible:=true;
   mEdit.Visible:=true;
   mBrowse.Visible:=true;
   mOrganize.Visible:=true;
   if (prevpanel='archive') or (prevpanel='extract') then
      begin
      mLayout.Enabled:=true;
      end;
   if prevpanel='open' then
      begin
      mEdit.Enabled:=true;
      mBrowse.Enabled:=true;
      mOrganize.Enabled:=true;
      end;
   end;
end;
if FormPeach.WindowState=wsNormal then FormPeach.Height:=ws_height;
FormPeach.Repaint;
end;

procedure set_swapbars;
begin
with FormPeach do
if swapbars=false then
   begin
   PanelBarOpen.AnchorSideTop.Control:=PanelOpen;
   PanelBarOpen.AnchorSideTop.Side:=asrTop;
   if swaptab=false then
      begin
      PanelTabBar.AnchorSideTop.Control:=PanelBarOpen;
      PanelTabBar.AnchorSideTop.Side:=asrBottom;
      PanelFilters.AnchorSideTop.Control:=PanelListBar;
      PanelFilters.AnchorSideTop.Side:=asrBottom;
      mswaptab.checked:=false;
      end
   else
      begin
      PanelListBar.AnchorSideTop.Control:=PanelBarOpen;
      PanelListBar.AnchorSideTop.Side:=asrBottom;
      PanelTabBar.AnchorSideTop.Control:=PanelListBar;
      PanelTabBar.AnchorSideTop.Side:=asrBottom;
      PanelFilters.AnchorSideTop.Control:=PanelTabBar;
      PanelFilters.AnchorSideTop.Side:=asrBottom;
      mswaptab.checked:=true;
      end;
   mswapbars.checked:=false;
   end
else
   begin
   if swaptab=false then
      begin
      PanelTabBar.AnchorSideTop.Control:=PanelOpen;
      PanelTabBar.AnchorSideTop.Side:=asrTop;
      PanelBarOpen.AnchorSideTop.Control:=PanelListBar;
      PanelBarOpen.AnchorSideTop.Side:=asrBottom;
      mswaptab.checked:=false;
      end
   else
      begin
      PanelListBar.AnchorSideTop.Control:=PanelOpen;
      PanelListBar.AnchorSideTop.Side:=asrTop;
      PanelTabBar.AnchorSideTop.Control:=PanelListBar;
      PanelTabBar.AnchorSideTop.Side:=asrBottom;
      PanelBarOpen.AnchorSideTop.Control:=PanelTabBar;
      PanelBarOpen.AnchorSideTop.Side:=asrBottom;
      mswaptab.checked:=true;
      end;
   PanelFilters.AnchorSideTop.Control:=PanelBarOpen;
   PanelFilters.AnchorSideTop.Side:=asrBottom;
   mswapbars.checked:=true;
   end;
end;

procedure setthl;
begin
FormPeach.ButtonUn7zaTest.Flat:=not(thighlight);
FormPeach.ButtonUn7zaAdd.Flat:=not(thighlight);
FormPeach.ButtonUn7zaTo.Flat:=not(thighlight);
FormPeach.ButtonUn7zaConvert.Flat:=not(thighlight);
FormPeach.ButtonPropertiesActions.Flat:=not(thighlight);
FormPeach.ButtonExtractActions.Flat:=not(thighlight);
FormPeach.ButtonConvertActions.Flat:=not(thighlight);
FormPeach.ButtonAddActions.Flat:=not(thighlight);
FormPeach.ButtonDelete.Flat:=not(thighlight);
FormPeach.ButtonTestActions.Flat:=not(thighlight);
FormPeach.ButtonCut.Flat:=not(thighlight);
FormPeach.ButtonPaste.Flat:=not(thighlight);
FormPeach.ButtonRename.Flat:=not(thighlight);
FormPeach.ButtonCopy.Flat:=not(thighlight);
FormPeach.Buttoncmto.Flat:=not(thighlight);
FormPeach.Buttonfmactions.Flat:=not(thighlight);
FormPeach.ButtonOpenWith.Flat:=not(thighlight);
FormPeach.ButtonOpenactions.Flat:=not(thighlight);
FormPeach.ButtonDup.Flat:=not(thighlight);
FormPeach.ButtonNF.Flat:=not(thighlight);
FormPeach.Buttonfmactions1.Flat:=not(thighlight);
FormPeach.ButtonImgRl.Flat:=not(thighlight);
FormPeach.ButtonImgResize.Flat:=not(thighlight);
FormPeach.ButtonImgRR.Flat:=not(thighlight);
FormPeach.ButtonImgCrop.Flat:=not(thighlight);
FormPeach.ButtonImg6.Flat:=not(thighlight);
FormPeach.ButtonImgR.Flat:=not(thighlight);
FormPeach.ButtonImgRes.Flat:=not(thighlight);
FormPeach.ButtonDup1.Flat:=not(thighlight);
FormPeach.ButtonRename1.Flat:=not(thighlight);
FormPeach.mthl.checked:=thighlight;
end;

procedure settoolbar;
begin
FormPeach.MenuItemOrganizeToolbar.checked:=true;
FormPeach.mshowtoolbar.checked:=true;
FormPeach.PanelBarOpen.visible:=true;
settoolbardisp;
FormPeach.ImageFlat.visible:=false;
FormPeach.pmtoollarge.Checked:=false;
FormPeach.pmtoolmedium.Checked:=false;
FormPeach.pmtoolsmall.Checked:=false;
FormPeach.pmtoolcompact.Checked:=false;
FormPeach.pmtoolnone.Checked:=false;
case toolsize of //note: currently needs to be called when the browser is rendered, or vsList style would not display right column size
   0: begin
      setlargetoolbar2;
      if lsize=1 then FormPeach.pmtoollarge.Checked:=true
      else FormPeach.pmtoolmedium.Checked:=true;
      end;
   {1: begin //1 becomes large icons + text below mode to change previous standard mode for existing installations
      setlargetoolbar1;
      end;
   2: begin
      setlargetoolbar3;
      end;
   3: begin
      setsmalltoolbar1;
      end;}
   4: begin
      setsmalltoolbar2;
      FormPeach.pmtoolsmall.Checked:=true;
      end;
   {5: begin
      setsmalltoolbar3;
      end;
   6: begin
      settexttoolbar;
      end;}
   7: begin
      FormPeach.MenuItemOrganizeToolbar.checked:=false;
      FormPeach.mshowtoolbar.checked:=false;
      FormPeach.PanelBarOpen.height:=0;
      FormPeach.PanelBarOpen.visible:=false;
      FormPeach.ImageFlat.visible:=true;
      if ntoolstyle=4 then FormPeach.pmtoolcompact.Checked:=true;
      if ntoolstyle=5 then FormPeach.pmtoolnone.Checked:=true;
      end;
   end;
FormPeach.pmmoretest.Visible:=FormPeach.ImageFlat.visible;
FormPeach.pmmoreadd.Visible:=false;
FormPeach.pmmoreconvert.Visible:=false;
FormPeach.pmmoreextract.Visible:=false;
if FormPeach.ImageFlat.visible=true then FormPeach.PanelSPaddress.Width:=1 else FormPeach.PanelSPaddress.Width:=8;
if ntoolstyle=4 then
   begin
   case lasttoolbar of
   1: begin
      FormPeach.ImageFlatadd.Visible:=true;
      FormPeach.ImageFlatconvert.Visible:=true;
      FormPeach.ImageFlatext.Visible:=true;
      FormPeach.ImageFlatdup.Visible:=false;
      FormPeach.ImageFlatfolder.Visible:=false;
      FormPeach.ImageFlatren.Visible:=false;
      FormPeach.ImageFlattransform.Visible:=false;
      FormPeach.ImageFlatcrop.Visible:=false;
      FormPeach.PanelSPaddress.AnchorSideRight.Control:=FormPeach.ImageFlatadd;
      end;
   2: begin
      FormPeach.ImageFlatadd.Visible:=false;
      FormPeach.ImageFlatconvert.Visible:=false;
      FormPeach.ImageFlatext.Visible:=false;
      FormPeach.ImageFlatdup.Visible:=true;
      FormPeach.ImageFlatfolder.Visible:=true;
      FormPeach.ImageFlatren.Visible:=true;
      FormPeach.ImageFlattransform.Visible:=false;
      FormPeach.ImageFlatcrop.Visible:=false;
      FormPeach.PanelSPaddress.AnchorSideRight.Control:=FormPeach.ImageFlatren;
      FormPeach.pmmoreadd.Visible:=true;
      FormPeach.pmmoreconvert.Visible:=true;
      FormPeach.pmmoreextract.Visible:=true;
      end;
   3: begin
      FormPeach.ImageFlatadd.Visible:=false;
      FormPeach.ImageFlatconvert.Visible:=false;
      FormPeach.ImageFlatext.Visible:=false;
      FormPeach.ImageFlatdup.Visible:=true;
      FormPeach.ImageFlatfolder.Visible:=false;
      FormPeach.ImageFlatren.Visible:=false;
      FormPeach.ImageFlattransform.Visible:=true;
      FormPeach.ImageFlatcrop.Visible:=true;
      FormPeach.PanelSPaddress.AnchorSideRight.Control:=FormPeach.ImageFlatcrop;
      FormPeach.pmmoreadd.Visible:=true;
      FormPeach.pmmoreconvert.Visible:=true;
      FormPeach.pmmoreextract.Visible:=true;
      end;
   end;
   FormPeach.ImageFlattestmore.Visible:=true;
   end
else
   begin
   FormPeach.ImageFlatadd.Visible:=false;
   FormPeach.ImageFlatconvert.Visible:=false;
   FormPeach.ImageFlatext.Visible:=false;
   FormPeach.ImageFlatdup.Visible:=false;
   FormPeach.ImageFlatfolder.Visible:=false;
   FormPeach.ImageFlatren.Visible:=false;
   FormPeach.ImageFlattransform.Visible:=false;
   FormPeach.ImageFlatcrop.Visible:=false;
   FormPeach.ImageFlattestmore.Visible:=false;
   end;
settoolbarw;
setthl;
settonewfolder(tonewfolder);
end;

procedure prepare_GUI;
var
   i:integer;
begin
if showguihints=1 then FormPeach.ShowHint:=true else FormPeach.ShowHint:=false;
with FormPeach.PanelArchive do begin Top:=0; Left:=0; Width:=FormPeach.Width; end;
with FormPeach.PanelOpen do begin Top:=0; Left:=0; Width:=FormPeach.Width; end;
with FormPeach.PanelOptions do begin Top:=0; Left:=0; Width:=FormPeach.Width; end;
with FormPeach do
begin
{$IFDEF MSWINDOWS}
FormDrop.ShapeDragDrop.Brush.Color:=clInactiveCaption;
{$ENDIF}
for i:=1 to 16 do StringGridCustedit.Cells[0,i]:=inttostr(i);
StringGridCustedit.Cells[1,0]:=txt_description;
StringGridCustedit.Cells[2,0]:=txt_2_5_execommand;
StringGridCustedit.AutoSizeColumns;
for i:=1 to 8 do StringGridCustEditAdv.Cells[0,i]:=inttostr(i);
StringGridCustEditAdv.Cells[1,0]:=txt_description;
StringGridCustEditAdv.Cells[2,0]:=txt_2_5_strbefore;
StringGridCustEditAdv.Cells[3,0]:=txt_2_5_strafter;
StringGridCustEditAdv.Cells[4,0]:=txt_3_3_stralt;
StringGridCustEditAdv.AutoSizeColumns;
StringGridAdd.Cells[1,0]:=txt_name;
StringGridAdd.Cells[2,0]:=txt_type;
StringGridAdd.Cells[3,0]:=txt_size;
StringGridAdd.Cells[4,0]:=txt_nfolders;
StringGridAdd.Cells[5,0]:=txt_nfiles;
StringGridAdd.Cells[6,0]:=txt_8_2_tm;
StringGridAdd.Cells[7,0]:=txt_attributes;
StringGridAdd.Cells[8,0]:=txt_name_full;
StringGridAdd.AutoSizeColumns;
StringGridAdd.ColWidths[0]:=rowsize;
StringGridAdd.ColWidths[1]:=COL1D;
StringGridAdd.ColWidths[9]:=0;
StringGridAdd.ColWidths[10]:=0;
StringGridAdd.ColWidths[11]:=0;
StringGridAdd.ColWidths[12]:=0;
StringGridAdd.colwidths[13]:=0;
StringGridAdd.colwidths[14]:=8;
StringGridExtract.Cells[1,0]:=txt_name;
StringGridExtract.Cells[2,0]:=txt_type;
StringGridExtract.Cells[3,0]:=txt_size;
StringGridExtract.Cells[4,0]:=txt_compressed_size;
StringGridExtract.Cells[5,0]:=txt_8_2_tm;
StringGridExtract.Cells[6,0]:=txt_attributes;
StringGridExtract.Cells[7,0]:=txt_check_select;
StringGridExtract.Cells[8,0]:=txt_name_full;
autosize_stringgrid2;
set_listview_col;
StringGridBookmarks.Cells[1,0]:=txt_bookmarks;
StringGridBookmarks.Cells[2,0]:=txt_name_full;
StringGridBookmarks.Cells[3,0]:=txt_name;
StringGridBookmarks.Cells[4,0]:=txt_inclusion;
StringGridBookmarks.Cells[5,0]:=txt_exclusion;
StringGridBookmarks.Cells[6,0]:=txt_description;
StringGridBookmarks.Cells[7,0]:=txt_5_4_used;
StringGridBookmarks.Cells[8,0]:=txt_5_4_lv;
StringGridBookmarks.Cells[9,0]:=txt_5_4_da;
StringGridBookmarks.AutoSizeColumns;
StringGridBookmarks.ColWidths[10]:=0;
StringGridBookmarks.ColWidths[11]:=0;
StringGridBookmarks.ColWidths[0]:=rowsize;
StringGridClipboard.Cells[0,0]:=txt_2_4_operation;
StringGridClipboard.Cells[1,0]:=txt_name;
StringGridClipboard.Cells[2,0]:=txt_type;
StringGridClipboard.Cells[3,0]:=txt_name_full;
StringGridClipboard.Cells[4,0]:=txt_path;
StringGridClipboard.Cells[5,0]:=txt_size;
StringGridClipboard.Cells[6,0]:=txt_8_2_tm;
StringGridClipboard.AutoSizeColumns;
StringGridClipboard.ColWidths[0]:=rowsize;
activelabel_options:=LabelTitleOptions1;
clicklabel_options(LabelTitleoptions1,ShapeOptions1);
setpanel_extract(1);
StringGridRecent.ColWidths[0]:=rowsize;
StringGridRecent.Cells[1,0]:=txt_list_history;
FormPeach.StringGridRecent.AutosizeColumns;
FormPeach.StringGridRecent.ColWidths[0]:=rowsize;
FormPeach.StringGridRecent.ColWidths[2]:=0;
FormPeach.StringGridRecent.ColWidths[3]:=0;
FormPeach.StringGridRecent.ColWidths[4]:=0;
StringGridSessionHistory.ColWidths[0]:=rowsize;
StringGridSessionHistory.Cells[1,0]:=txt_5_0_sh;
StringGridSessionHistory.Cells[2,0]:=txt_name;
StringGridSessionHistory.Cells[3,0]:=txt_inclusion;
StringGridSessionHistory.Cells[4,0]:=txt_exclusion;
openwithcustom.Visible:=false;
MenuItemPreCustom.Visible:=false;
po_open_custom.Visible:=false;
MenuItemERCustom.Visible:=false; //uses Windows specific open with method
EditUn7zaFilterExclude.Enabled:=false;
//fix position of some elements that tend to change without an apparent reason in the IDE
if ws=1 then //load last window status
   begin
   if ws_status=0 then
      begin
      FormPeach.WindowState:=wsNormal;
      FormPeach.Left:=ws_left;
      FormPeach.Top:=ws_top;
      FormPeach.Width:=ws_width;
      FormPeach.Height:=ws_height;
      end
   else FormPeach.WindowState:=wsMaximized;
   end;
//status0:=caption_release;
pojdn1.Visible:=false;
pojdn2.Visible:=false;
pojdn3.Visible:=false;
pojdn4.Visible:=false;
pojdn5.Visible:=false;
pojdn6.Visible:=false;
pojdn7.Visible:=false;
pojdn8.Visible:=false;
pojdn9.Visible:=false;
pojdn10.Visible:=false;
pojdn11.Visible:=false;
pojdn12.Visible:=false;
pojdn13.Visible:=false;
pojdn14.Visible:=false;
pojdn15.Visible:=false;
pojdn16.Visible:=false;
pojdn17.Visible:=false;
pojdn18.Visible:=false;
pojdn19.Visible:=false;
pojdn20.Visible:=false;
pojdn21.Visible:=false;
pojdn22.Visible:=false;
pojdn23.Visible:=false;
pojdn24.Visible:=false;
pojdn25.Visible:=false;
pojdn26.Visible:=false;
pajdn1.Visible:=false;
pajdn2.Visible:=false;
pajdn3.Visible:=false;
pajdn4.Visible:=false;
pajdn5.Visible:=false;
pajdn6.Visible:=false;
pajdn7.Visible:=false;
pajdn8.Visible:=false;
pajdn9.Visible:=false;
pajdn10.Visible:=false;
pajdn11.Visible:=false;
pajdn12.Visible:=false;
pajdn13.Visible:=false;
pajdn14.Visible:=false;
pajdn15.Visible:=false;
pajdn16.Visible:=false;
pajdn17.Visible:=false;
pajdn18.Visible:=false;
pajdn19.Visible:=false;
pajdn20.Visible:=false;
pajdn21.Visible:=false;
pajdn22.Visible:=false;
pajdn23.Visible:=false;
pajdn24.Visible:=false;
pajdn25.Visible:=false;
pajdn26.Visible:=false;
pmjd1.Visible:=false;
pmjd2.Visible:=false;
pmjd3.Visible:=false;
pmjd4.Visible:=false;
pmjd5.Visible:=false;
pmjd6.Visible:=false;
pmjd7.Visible:=false;
pmjd8.Visible:=false;
pmjd9.Visible:=false;
pmjd10.Visible:=false;
pmjd11.Visible:=false;
pmjd12.Visible:=false;
pmjd13.Visible:=false;
pmjd14.Visible:=false;
pmjd15.Visible:=false;
pmjd16.Visible:=false;
pmjd17.Visible:=false;
pmjd18.Visible:=false;
pmjd19.Visible:=false;
pmjd20.Visible:=false;
pmjd21.Visible:=false;
pmjd22.Visible:=false;
pmjd23.Visible:=false;
pmjd24.Visible:=false;
pmjd25.Visible:=false;
pmjd26.Visible:=false;
pea.Visible:=false;
Comboboxarcsfx.Itemindex:=2;
setsearchbar(showsearchbar);
end;
end;

procedure setschedulevisible(isvis:boolean);
begin
FormPeach.ScheduleAdd.Visible:=isvis;
FormPeach.ScheduleExtract.Visible:=isvis;
end;

procedure movepform;
begin
pimmersive:=0;
FormPeach.WindowState:=wsNormal;
FormPeach.BorderStyle:=bsSizeable;
FormPeach.Width:=DWIDTH;
FormPeach.Height:=DHEIGTH;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI OPTIONS set and restore options in gui items

///////////////////////////////////////////////////////////////////////////////}

procedure savestatus_archiver;
begin
if updatingarchive_inarchive=true then exit;
with FormPeach do
begin
if mdefaultarchive.checked=true then apdefault:=1 else apdefault:=0;
apdefaultarchivepath:=defaultarchivepath;
apformat:=cbType.ItemIndex;
if cbAdvfAdd.State=cbchecked then apfilters:=1 else apfilters:=0;
if checkboxenumd.State=cbchecked then apenum:=1 else apenum:=0;
if cbRAR.State=cbchecked then aprar:=1 else aprar:=0;
if cbRAR5.State=cbchecked then aprar5:=1 else aprar5:=0;
aprardict:=comboRARdict.ItemIndex;
if cbRARBLAKE2.State=cbchecked then aprarblake2:=1 else aprarblake2:=0;
//if cbRARmanual.State=cbchecked then aprarmanual:=1 else aprarmanual:=0;
if cbRARsfx.State=cbchecked then aprarsfx:=1 else aprarsfx:=0;
if cbRARsolid.State=cbchecked then aprarsolid:=1 else aprarsolid:=0;
if cbRARrr.State=cbchecked then aprarrr:=1 else aprarrr:=0;
apprarrr:=seRARrr.Value;
if cbRARsaveopen.State=cbchecked then aprarsaveopen:=1 else aprarsaveopen:=0;
if cbRARsavesecurity.State=cbchecked then aprarsavesecurity:=1 else aprarsavesecurity:=0;
if cbRARsavestreams.State=cbchecked then aprarsavestreams:=1 else aprarsavestreams:=0;
aprarlastmodtime:=cbRARlastmodtime.ItemIndex;
if cbRARlock.State=cbchecked then aprarlock:=1 else aprarlock:=0;
if cbEncExtension.State=cbchecked then apencext:=1 else apencext:=0;
if CheckBoxdate.State=cbchecked then apappend:=1 else apappend:=0;
if cbCustomExtension.State=cbchecked then apcustext:=1 else apcustext:=0;
apextcapt:=EditCustomExtension.Caption;
if CheckBoxConvertPW.State=cbchecked then appw:=1 else appw:=0;
if CheckBoxConvertVerbose.State=cbchecked then apverbose:=1 else apverbose:=0;
apsplit:=cbSplit.ItemIndex;
apspin:=SpinEditSplit.Value;
apsize:=ComboBoxSplit.ItemIndex;
apdelete:=cbDeleteInputModeAdd.ItemIndex;
if CheckBoxDeleteInputAdd.State=cbchecked then apdopt:=1 else apdopt:=0;
//7z
vlevel_7z:=level_7z;
vlevel_xz:=level_xz;
vlevel_bzip2:=level_bzip2;
vlevel_gz:=level_gz;
vlevel_zip:=level_zip;
vmethod_7z:=method_7z;
vmethod_zip:=method_zip;
if fun='BROTLI' then v9b:=cbLevel.Itemindex else v9b:=level_brotli;
if (fun='CUSTOM') and (userar=1) and (havewinrar=true) then v9r:=cbLevel.Itemindex else v9r:=level_rar;
if fun='ZSTD' then v9z:=cbLevel.Itemindex else v9z:=level_zstd;
v7z1:=ComboBox7zLevel.Itemindex;
v7z2:=ComboBox7zMethod.Itemindex;
v7z3:=ComboBox7zDictionary.Itemindex;
v7z4:=ComboBox7zWord.Itemindex;
v7z5:=ComboBox7zPasses.Itemindex;
v7z6:=ComboBox7zSolid.Itemindex;
if CheckBoxSolidExtension.State=cbchecked then v7z7b:=1 else v7z7b:=0;
if CheckBox7zOF.State=cbchecked then v7z7:=1 else v7z7:=0;
if Checkboxsnoi.State=cbchecked then v7snoi:=1 else v7snoi:=0;
if Checkboxsnon.State=cbchecked then v7snon:=1 else v7snon:=0;
if CheckBox7zSFX.State=cbchecked then v7z8:=1 else v7z8:=0;
if Checkboxsni.State=cbchecked then v7z15:=1 else v7z15:=0;
if Checkboxsns.State=cbchecked then v7z16:=1 else v7z16:=0;
if Checkboxsnh.State=cbchecked then v7z16a:=1 else v7z16a:=0;
if Checkboxsnl.State=cbchecked then v7z16b:=1 else v7z16b:=0;
if Checkboxstl.State=cbchecked then v7z17:=1 else v7z17:=0;
if Checkboxssp.State=cbchecked then v7z18:=1 else v7z18:=0;
if CheckBoxBrotli.State=cbchecked then vbr1:=1 else vbr1:=0;
if CheckBoxZstd.State=cbchecked then vzst1:=1 else vzst1:=0;
v7z9:=RadioGroup7zSFX.Itemindex;
v7z10:=ComboBox7zFun.Itemindex;
v7z11:=ComboBox7zThreads.Itemindex;
v7z11b:=ComboBox7zMemuse.Itemindex;
v7z12:=Edit7zOpt.Text;
if CheckBoxMailAdd.State=cbchecked then v7z13:=1 else v7z13:=0;
if CheckboxMailKeep.State=cbchecked then v7z13b:=1 else v7z13b:=0;
v7z14:=Combobox7zalgo.Itemindex;
v7zpaths:=ComboBox7zPaths.Itemindex;
vtartype:=ComboBoxTAR.Itemindex;
vtartime:=ComboBoxTARTS.Itemindex;
//quad/balz/bcm
vquad1:=radiogroupquad.Itemindex;
if CheckboxQuadMax.State=cbchecked then vquad2:=1 else vquad2:=0;
//paq
vpaq1:=ComboBoxPAQLevel.ItemIndex;
vpaq1b:=ComboBoxPAQThreads.ItemIndex;
vpaq2:=RadioGroupPaq.ItemIndex;
//upx
vupx1:=ComboBoxUPX.ItemIndex;
if CheckBoxUPXStrip.State=cbchecked then vupx2:=1 else vupx2:=0;
if CheckBoxUPXBackup.State=cbchecked then vupx3:=1 else vupx3:=0;
//arc
varc1:=ComboBoxARCLevel.ItemIndex;
varc2:=ComboBoxARCSolid.ItemIndex;
if CheckBoxARCrr.State=cbchecked then varc3:=1 else varc3:=0;
if CheckBoxARCabs.State=cbchecked then varc3b:=1 else varc3b:=0;
if CheckBoxARCsfx.State=cbchecked then varc4:=1 else varc4:=0;
varc5:=ComboBoxARCSfx.ItemIndex;
varc6:=ComboBoxARCFun.ItemIndex;
varc7:=EditOPARC.Text;
varc8:=ComboBoxARCalgo.ItemIndex;
//split
vsplit1:=ComboBoxSplitAlgo.ItemIndex;
//pea
vpea1:=ComboBoxPEALevel.ItemIndex;
vpea2:=ComboBoxPEAObj.ItemIndex;
vpea3:=ComboBoxPEAVol.ItemIndex;
vpea4:=ComboBoxPEAStream.ItemIndex;
vpea5:=ComboBoxPEAKDFw.ItemIndex;
vpea6:=ComboBoxPEAKDF.ItemIndex;
//custom
vcustom1:=EditNameCustom.Text;
vcustom2:=EditExtensionCustom.Text;
vcustom3:=EditOPCustom.Text;
vcustom4:=ComboBoxArchiveCustom.ItemIndex;
savecustlist;
end;
end;

procedure on_ComboBox7zalgochange;
begin
getarccaption(FormPeach.cbType.Text);
if archive_type='zip' then algo_zipenc:=FormPeach.ComboBox7zalgo.ItemIndex;
end;

procedure cbSplit_onchange;
begin
with FormPeach do
begin
if cbSplit.ItemIndex > 0 then CheckBoxMailAdd.Enabled:=false
else CheckBoxMailAdd.Enabled:=true;
if FormPeach.CheckBoxMailAdd.Enabled=false then
   begin
   FormPeach.CheckBoxMailAdd.Checked:=false;
   FormPeach.CheckBoxMailKeep.Visible:=false;
   end;
change_imagesplit;
if cbSplit.ItemIndex = 1 then
   begin
   SpinEditSplit.Visible:=true;
   ComboBoxSplit.Visible:=true;
   end
else
   begin
   SpinEditSplit.Visible:=false;
   ComboBoxSplit.Visible:=false;
   end;
defaultspanning:=cbSplit.ItemIndex;
spansize:=FormPeach.SpinEditSplit.Value;
spanunit:=FormPeach.ComboBoxSplit.ItemIndex;
end;
end;

procedure ComboBoxArchive3_onchange;
begin
if settingvalues=false then
   with FormPeach do
      begin
      compression_method:=ComboBox7zMethod.Text;
      if (cbType.Text=STR_7Z) or (cbType.Text=txt_sfx+' '+STR_7Z) then method_7z:=compression_method;
      if cbType.Text=STR_ZIP then method_zip:=compression_method;
      set_values(archive_type,compression_method,compression_level);
      getarccaption(FormPeach.cbType.Text);
      end;
end;

procedure CheckBoxArchiveOF_onclick;
begin
with FormPeach do
begin
if CheckBox7zOF.State=cbChecked then openw_all7z:=1 else openw_all7z:=0;
end;
end;

procedure CheckBoxsni_onclick;
begin
with FormPeach do
begin
if CheckBoxsni.State=cbChecked then sni7z:=1 else sni7z:=0;
CheckBoxsniExt.State:=CheckBoxsni.State;
end;
end;

procedure CheckBoxsniExt_onclick;
begin
with FormPeach do
begin
if CheckBoxsniExt.State=cbChecked then sni7z:=1 else sni7z:=0;
CheckBoxsni.State:=CheckBoxsniExt.State;
end;
end;

procedure CheckBoxsns_onclick;
begin
with FormPeach do
begin
if CheckBoxsns.State=cbChecked then sns7z:=1 else sns7z:=0;
CheckBoxsnsExt.State:=CheckBoxsns.State;
end;
end;

procedure CheckBoxsnh_onclick;
begin
if FormPeach.CheckBoxsnh.State=cbChecked then snh7z:=1 else snh7z:=0;
end;

procedure CheckBoxsnl_onclick;
begin
if FormPeach.CheckBoxsnl.State=cbChecked then snl7z:=1 else snl7z:=0;
end;

procedure CheckBoxsnzExt_onclick;
begin
with FormPeach do
begin
if CheckBoxsnzExt.State=cbChecked then snz7z:=1 else snz7z:=0;
end;
end;

procedure CheckBoxstl_onClick;
begin
if FormPeach.CheckBoxstl.State=cbChecked then stl7z:=1 else stl7z:=0;
end;

procedure CheckBoxssp_onClick;
begin
if FormPeach.CheckBoxssp.State=cbChecked then ssp7z:=1 else ssp7z:=0;
end;

procedure CheckBoxBrotli_onClick;
begin
if FormPeach.CheckBoxBrotli.State=cbChecked then maxbrotli:=1 else maxbrotli:=0;
end;

procedure CheckBoxZstd_onClick;
begin
if FormPeach.CheckBoxZstd.State=cbChecked then maxzstd:=1 else maxzstd:=0;
end;

procedure CheckBoxsnsExt_onclick;
begin
with FormPeach do
begin
if CheckBoxsnsExt.State=cbChecked then sns7z:=1 else sns7z:=0;
CheckBoxsns.State:=CheckBoxsnsExt.State;
end;
end;

procedure CheckBoxZstdErrPolicy_onclick;
begin
with FormPeach do
begin
if CheckBoxZstdErrPolicy.State=cbChecked then zstderr:=1 else zstderr:=0;
end;
end;

procedure CheckBoxMQS_onclick;
begin
with FormPeach do
begin
if CheckBoxSolidExtension.State=cbChecked then sort7zbytype:=1 else sort7zbytype:=0;
end;
end;

procedure on_RadioGroupQuadClick;
begin
case FormPeach.RadioGroupQuad.ItemIndex of
   0: archive_type:='quad';
   1: archive_type:='balz';
   2: archive_type:='bcm';
   end;
if FormPeach.RadioGroupQuad.ItemIndex=2 then
   begin
   FormPeach.CheckBoxQuadMax.enabled:=false;
   FormPeach.Labelbcmblock.visible:=true;
   FormPeach.ComboBoxBCMSolid.visible:=true;
   end
else
   begin
   FormPeach.CheckBoxQuadMax.enabled:=true;
   FormPeach.Labelbcmblock.visible:=false;
   FormPeach.ComboBoxBCMSolid.visible:=false;
   end;
getarccaption(STR_QUAD);
end;

procedure on_CheckBoxQuadMax_click;
begin
if FormPeach.CheckBoxQuadMax.State=cbChecked then level_quad:=1 else level_quad:=0;
updateconf_modified;
end;

procedure on_ComboBoxPAQ1Change;
begin
level_paq:=FormPeach.ComboBoxPAQLevel.ItemIndex;
end;

procedure on_ComboBoxPAQ2Change;
begin
threads_zpaq:=FormPeach.ComboBoxPAQThreads.ItemIndex;
end;

procedure on_RadioGroupPaqClick;
var
   fnm:ansistring;
begin
case FormPeach.RadioGroupPaq.ItemIndex of
   0: begin
      archive_type:='lpaq8';
      check_tarbefore(tdirs);
      end;
   1: archive_type:='paq8o';
   2: archive_type:='zpaq';
   end;
if FormPeach.RadioGroupPaq.ItemIndex=2 then
   begin
   FormPeach.ComboBoxPAQThreads.Enabled:=true;
   FormPeach.LabelPAQThreads.Enabled:=true;
   end
else
   begin
   FormPeach.ComboBoxPAQThreads.Enabled:=false;
   FormPeach.LabelPAQThreads.Enabled:=false;
   end;
paqver:=FormPeach.RadioGroupPaq.ItemIndex;
suggest_outname(fnm,FormPeach.cbType.Text,0);
fnm:=extractfilename(fnm);
FormPeach.EditAddName.Text:=FormPeach.EditAddFilepath.Text+addext(fnm);
getarccaption(STR_ZPAQ);
end;

procedure on_ComboBoxUPXChange;
begin
level_upx:=FormPeach.ComboBoxUPX.ItemIndex;
end;

procedure on_ComboBoxARCChange;
begin
level_arc:=FormPeach.ComboBoxARCLevel.ItemIndex;
setquickcompset('ARC');
end;

procedure on_ComboBoxArcSolidChange;
begin
solid_arc:=FormPeach.ComboBoxARCsolid.ItemIndex;
end;

procedure on_CheckBoxARC1Click;
begin
if FormPeach.CheckBoxARCrr.state=cbChecked then rr_arc:=1
else rr_arc:=0;
end;

procedure on_CheckBoxARC2Click;
begin
if FormPeach.CheckBoxARCsfx.state=cbChecked then FormPeach.ComboboxArcSfx.Visible:=true
else FormPeach.ComboboxArcSfx.Visible:=false;
end;

procedure on_ComboBoxARC2Change;
begin
if (FormPeach.CheckBoxARCsfx.State=cbChecked) then
   getarccaption(txt_sfx+' '+STR_ARC)
else
   getarccaption(STR_ARC);
end;

procedure on_ComboBoxARCalgoChange;
begin
algo_arc:=FormPeach.ComboBoxARCalgo.ItemIndex;
end;

procedure ComboBoxSplit3_onchange;
begin
salgo:=FormPeach.ComboBoxSplitAlgo.ItemIndex;
end;

procedure ComboBoxPEACompression1_onchange;
begin
pcompr:=FormPeach.ComboBoxPEALevel.ItemIndex;
end;

procedure ComboBoxPEA3_onchange;
begin
pobj:=FormPeach.ComboBoxPEAObj.ItemIndex;
end;

procedure ComboBoxPEA4_onchange;
begin
pvol:=FormPeach.ComboBoxPEAVol.ItemIndex;
end;

procedure ComboBoxPEA2_onchange;
begin
pstream:=FormPeach.ComboBoxPEAStream.ItemIndex;
end;

procedure ComboBoxKDF_onchange;
begin
trkdf:=FormPeach.ComboBoxPEAKDF.ItemIndex;
case FormPeach.ComboBoxPEAKDF.ItemIndex of
   2:
   begin
   FormPeach.ComboBoxPEAKDFw.Items.Strings[0]:=txt_default;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[1]:='+200K '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[2]:='+500K '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[3]:='+1M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[4]:='+2M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[5]:='+5M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[6]:='+10M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[7]:='+25M '+txt_9_9_kdf;
   end;
   1:
   begin
   FormPeach.ComboBoxPEAKDFw.Items.Strings[0]:='64 MB RAM + '+txt_default;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[1]:='128 MB RAM +200K '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[2]:='256 MB RAM +500K '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[3]:='512 MB RAM +1M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[4]:='1 GB RAM (p=1) +2M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[5]:='1 GB RAM (p=2) +5M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[6]:='1 GB RAM (p=4) +10M '+txt_9_9_kdf;
   FormPeach.ComboBoxPEAKDFw.Items.Strings[7]:='1 GB RAM (p=8) +25M '+txt_9_9_kdf;
   end;
   0:
   begin
   FormPeach.ComboBoxPEAKDFw.Items.Strings[0]:='64 MB RAM (r=8, p=1)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[1]:='128 MB RAM (r=8, p=1)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[2]:='256 MB RAM (r=8, p=1)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[3]:='512 MB RAM (r=8, p=1)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[4]:='1 GB RAM (r=8, p=1)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[5]:='1 GB RAM (r=8, p=2)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[6]:='1 GB RAM (r=8, p=4)';
   FormPeach.ComboBoxPEAKDFw.Items.Strings[7]:='1 GB RAM (r=8, p=8)';
   end;
end;
end;

procedure ComboBoxKDF1_onchange;
begin
nrkdf:=FormPeach.ComboBoxPEAKDFw.ItemIndex;
end;

procedure on_ComboBoxArchiveCustomChange;
begin
customsyntax:=FormPeach.ComboBoxArchiveCustom.ItemIndex;
updateconf_modified;
end;

procedure on_cbtypechange;
begin
archive_type_select(FormPeach.cbType.Text);
if stayopen=true then
   pf:=FormPeach.cbType.ItemIndex
else
   if savetype=true then
      pf:=FormPeach.cbType.ItemIndex;
end;

procedure on_CheckBoxAutoOpenClick;
begin
   if FormPeach.CheckBoxAutoOpen.State=cbChecked then autoopen:=1 else autoopen:=0;
end;

procedure on_CheckBoxAutoTestClick;
begin
   if FormPeach.CheckBoxAutoTest.State=cbChecked then autotest:=1 else autotest:=0;
end;

procedure on_CheckBoxARC3Click;
begin
if FormPeach.CheckBoxARCabs.state=cbChecked then arcabspath:=1
else arcabspath:=0;
end;

procedure on_CheckBoxArchive4;
begin
if FormPeach.CheckBoxMailAdd.State=cbChecked then FormPeach.CheckBoxMailKeep.Visible:=true
else FormPeach.CheckBoxMailKeep.Visible:=false;
end;

procedure on_CheckBoxAutoExtTar1Click;
begin
if FormPeach.CheckBoxAutoExtTarConvert.State=cbChecked then tar_atomic_convert:=1 else tar_atomic_convert:=0;
end;

procedure on_CheckBoxAutoExtTarClick;
begin
if FormPeach.CheckBoxAutoExtTar.State=cbChecked then tar_atomic:=1 else tar_atomic:=0;
end;

procedure TFormPeach.CheckBoxAutoExtTarClick(Sender: TObject);
begin
on_CheckBoxAutoExtTarClick;
end;

procedure on_CheckBoxAutoOpenTarClick;
begin
if FormPeach.CheckBoxAutoOpenTar.State=cbChecked then autoopentar:=1 else autoopentar:=0;
end;

procedure on_checkboxconvertVerbose;
begin
if FormPeach.CheckBoxConvertVerbose.Checked=true then convertverbose:=1 else convertverbose:=0;
end;

procedure on_checkboxconvertPW;
begin
if FormPeach.CheckBoxConvertPW.Checked=true then convertpw:=1 else convertpw:=0;
end;

procedure on_CheckBoxDeleteInputAddClick;
begin
if FormPeach.CheckBoxDeleteInputAdd.State=cbChecked then
   begin
   FormPeach.cbDeleteInputModeAdd.Visible:=true;
   doptadd:=1;
   end
else
   begin
   FormPeach.cbDeleteInputModeAdd.Visible:=false;
   doptadd:=0;
   end;
end;

procedure on_CheckBoxDeleteInputClick;
begin
if FormPeach.CheckBoxDeleteInputExt.State=cbChecked then
   begin
   FormPeach.cbDeleteInputModeExt.Visible:=true;
   doptext:=1;
   end
else
   begin
   FormPeach.cbDeleteInputModeExt.Visible:=false;
   doptext:=0;
   end;
end;

procedure on_CheckBoxDragDrop_click;
begin
if FormPeach.CheckBoxDragDrop.State=cbChecked then nativedrag:=1 else nativedrag:=0;
FormDrop.Visible:=false;
if nativedrag=0 then FormPeach.ComboBoxDrag.enabled:=false else FormPeach.ComboBoxDrag.enabled:=true;
end;

procedure on_CheckBoxEditArchives_click;
begin
if FormPeach.CheckBoxEditArchives.State=cbChecked then autosync:=1 else autosync:=0;
end;

procedure on_CheckBoxMailKeepClick;
begin
if FormPeach.CheckBoxMailKeep.State=cbChecked then mailkeep:=1 else mailkeep:=0;
end;

procedure on_ComboBoxArchive8Change;
begin
if FormPeach.ComboBox7zThreads.Enabled=true then
   multi_option:=FormPeach.ComboBox7zThreads.ItemIndex;
end;

procedure on_ComboBoxmemuseChange;
begin
memuse_option:=FormPeach.ComboBox7zMemuse.ItemIndex;
end;

procedure on_cbdeleteinputmode1Change;
begin
favdelete:=FormPeach.cbDeleteInputModeAdd.ItemIndex;
FormPeach.cbDeleteInputModeExt.ItemIndex:=FormPeach.cbDeleteInputModeAdd.ItemIndex;
end;

procedure cbtimecreated_onClick;
begin
if FormPeach.cbtimecreated.State=cbChecked then storecreated:=1 else storecreated:=0;
end;

procedure CheckBoxsnoi_onclick;
begin
if FormPeach.CheckBoxsnoi.State=cbChecked then snoi7z:=1 else snoi7z:=0;
end;

procedure CheckBoxsnon_onclick;
begin
if FormPeach.CheckBoxsnon.State=cbChecked then snon7z:=1 else snon7z:=0;
end;

procedure restorestatus_archiver;
begin
with FormPeach do
begin
CheckBoxAutoHaltA.State:=cbUnchecked;
if apdefault=1 then mdefaultarchive.checked:=true else mdefaultarchive.checked:=false;
defaultarchivepath:=apdefaultarchivepath;
if mdefaultarchive.checked=true then
   mdefaultarchive.caption:=txt_archive+' > '+txt_2_8_usedefaultoutpath+' '+defaultarchivepath
else
   mdefaultarchive.caption:=txt_archive+' > '+txt_7_6_setdef;
lsetdefaultout_arc.caption:=mdefaultarchive.caption;
//archive_type_select(cbType.Items[apformat]);
cbType.ItemIndex:=apformat; on_cbtypechange;
if apfilters=1 then cbAdvfAdd.State:=cbchecked else cbAdvfAdd.State:=cbunchecked;
if apenum=1 then checkboxenumd.State:=cbchecked else checkboxenumd.State:=cbunchecked; CheckBoxEnumdClick(nil);
if apencext=1 then cbEncExtension.State:=cbchecked else cbEncExtension.State:=cbunchecked; cbencextensionclick(nil);
if apappend=1 then CheckBoxdate.State:=cbchecked else CheckBoxdate.State:=cbunchecked; CheckBoxDateClick(nil);
if apcustext=1 then cbCustomExtension.State:=cbchecked else cbCustomExtension.State:=cbunchecked; cbCustomExtensionClick(nil);
EditCustomExtension.Caption:=apextcapt;
if apverbose=1 then CheckBoxConvertVerbose.State:=cbchecked else CheckBoxConvertVerbose.State:=cbunchecked; on_checkboxconvertVerbose;
CheckBoxConvertVerbose.visible:=FormPeach.CheckBoxConvert.Checked;
if appw=1 then CheckBoxConvertPW.State:=cbchecked else CheckBoxConvertPW.State:=cbunchecked; on_checkboxconvertPW;
CheckBoxConvertPW.visible:=FormPeach.CheckBoxConvert.Checked;
cbSplit.ItemIndex:=apsplit;
SpinEditSplit.Value:=apspin;
ComboBoxSplit.ItemIndex:=apsize;
cbSplit_onchange;
level_brotli:=v9b;
level_rar:=v9r;
level_zstd:=v9z;
//7z
level_7z:=vlevel_7z;
level_xz:=vlevel_xz;
level_bzip2:=vlevel_bzip2;
level_gz:=vlevel_gz;
level_zip:=vlevel_zip;
method_7z:=vmethod_7z;
method_zip:=vmethod_zip;
ComboBox7zLevel.Itemindex:=v7z1; on_ComboBoxArchiveCompressionLevelChange;
ComboBox7zMethod.Itemindex:=v7z2; ComboBoxArchive3_onchange;
ComboBox7zDictionary.Itemindex:=v7z3;
ComboBox7zWord.Itemindex:=v7z4;
ComboBox7zPasses.Itemindex:=v7z5;
ComboBox7zSolid.Itemindex:=v7z6;
if v7z7b=1 then CheckBoxSolidExtension.State:=cbchecked else CheckBoxSolidExtension.State:=cbunchecked; CheckboxMQS_onclick;
if v7z7=1 then CheckBox7zOF.State:=cbchecked else CheckBox7zOF.State:=cbunchecked; CheckBoxArchiveOF_onclick;
if v7snoi=1 then Checkboxsnoi.State:=cbchecked else Checkboxsnoi.State:=cbunchecked; CheckBoxsnoi_onclick;
if v7snon=1 then Checkboxsnon.State:=cbchecked else Checkboxsnon.State:=cbunchecked; CheckBoxsnon_onclick;
if v7z8=1 then CheckBox7zSFX.State:=cbchecked else CheckBox7zSFX.State:=cbunchecked;
if v7z15=1 then Checkboxsni.State:=cbchecked else Checkboxsni.State:=cbunchecked; CheckBoxsni_onclick;
if v7z16=1 then Checkboxsns.State:=cbchecked else Checkboxsns.State:=cbunchecked; CheckBoxsns_onclick;
if v7z16a=1 then Checkboxsnh.State:=cbchecked else Checkboxsnh.State:=cbunchecked; CheckBoxsnh_onclick;
if v7z16b=1 then Checkboxsnl.State:=cbchecked else Checkboxsnl.State:=cbunchecked; CheckBoxsnl_onclick;
if v7z17=1 then Checkboxstl.State:=cbchecked else Checkboxstl.State:=cbunchecked; CheckBoxstl_onclick;
if v7z18=1 then Checkboxssp.State:=cbchecked else Checkboxssp.State:=cbunchecked; Checkboxssp_onclick;
if vbr1=1 then CheckBoxBrotli.State:=cbchecked else CheckBoxBrotli.State:=cbunchecked; CheckBoxBrotli_onclick;
if vzst1=1 then CheckBoxZstd.State:=cbchecked else CheckBoxZstd.State:=cbunchecked; CheckBoxZstd_onclick;
RadioGroup7zSFX.Itemindex:=v7z9;
ComboBox7zFun.Itemindex:=v7z10;
cbAct.Itemindex:=ComboBox7zFun.Itemindex;
ComboBox7zThreads.Itemindex:=v7z11; on_ComboBoxArchive8Change;
ComboBox7zMemuse.Itemindex:=v7z11b; on_ComboBoxmemuseChange;
Edit7zOpt.Text:=v7z12;
if v7z13=1 then CheckBoxMailAdd.State:=cbchecked else CheckBoxMailAdd.State:=cbunchecked;
if v7z13b=1 then CheckboxMailKeep.State:=cbchecked else CheckboxMailKeep.State:=cbunchecked;
on_CheckBoxMailKeepClick;
on_CheckBoxArchive4;
Combobox7zalgo.Itemindex:=v7z14; on_ComboBox7zalgochange;
ComboBox7zPaths.Itemindex:=v7zpaths;
ComboBoxtar.Itemindex:=vtartype;
ComboBoxTARTS.Itemindex:=vtartime;
//quad/balz/bcm
radiogroupquad.Itemindex:=vquad1; on_RadioGroupQuadClick;
if vquad2=1 then CheckboxQuadMax.State:=cbchecked else CheckboxQuadMax.State:=cbunchecked; on_CheckBoxQuadMax_click;
//paq
ComboBoxPAQLevel.ItemIndex:=vpaq1; on_ComboBoxPAQ1Change;
ComboBoxPAQThreads.ItemIndex:=vpaq1b; on_ComboBoxPAQ2Change;
RadioGroupPaq.ItemIndex:=vpaq2; on_RadioGroupPaqClick;
//upx
ComboBoxUPX.ItemIndex:=vupx1;
if vupx2=1 then CheckBoxUPXStrip.State:=cbchecked else CheckBoxUPXStrip.State:=cbunchecked;
if vupx3=1 then CheckBoxUPXBackup.State:=cbchecked else CheckBoxUPXBackup.State:=cbunchecked;
//arc
ComboBoxARCLevel.ItemIndex:=varc1; on_ComboBoxARCChange;
ComboBoxARCSolid.ItemIndex:=varc2; on_ComboBoxArcSolidChange;
if varc3=1 then CheckBoxARCrr.State:=cbchecked else CheckBoxARCrr.State:=cbunchecked; on_CheckBoxARC1Click;
if varc3b=1 then CheckBoxARCabs.State:=cbchecked else CheckBoxARCabs.State:=cbunchecked; on_CheckBoxARC3Click;
if varc4=1 then CheckBoxARCsfx.State:=cbchecked else CheckBoxARCsfx.State:=cbunchecked; on_CheckBoxARC2Click;
ComboBoxARCSfx.ItemIndex:=varc5;
ComboBoxARCFun.ItemIndex:=varc6; on_ComboBoxARC2Change;
EditOPARC.Text:=varc7;
ComboBoxARCalgo.ItemIndex:=varc8; on_ComboBoxARCalgoChange;
//split
ComboBoxSplitAlgo.ItemIndex:=vsplit1; ComboBoxSplit3_onchange;
//pea
ComboBoxPEALevel.ItemIndex:=vpea1; ComboBoxPEACompression1_onchange;
ComboBoxPEAObj.ItemIndex:=vpea2; ComboBoxPEA3_onchange;
ComboBoxPEAVol.ItemIndex:=vpea3; ComboBoxPEA4_onchange;
ComboBoxPEAStream.ItemIndex:=vpea4; ComboBoxPEA2_onchange;
ComboBoxPEAKDFw.ItemIndex:=vpea5; ComboBoxKDF1_onchange;
ComboBoxPEAKDF.ItemIndex:=vpea6; ComboBoxKDF_onchange;
//custom
if aprar=1 then cbRAR.State:=cbchecked else cbRAR.State:=cbunchecked; cbRARClick(nil);
if aprar5=1 then cbRAR5.State:=cbchecked else cbRAR5.State:=cbunchecked; cbRAR5Click(nil);
comboRARdict.ItemIndex:=aprardict; comboRARdictChange(nil);
if aprarblake2=1 then cbRARBLAKE2.State:=cbchecked else cbRARBLAKE2.State:=cbunchecked; cbRARBLAKE2Click(nil);
//if aprarmanual=1 then cbRARmanual.State:=cbchecked else cbRARmanual.State:=cbunchecked;
if aprarsfx=1 then cbRARsfx.State:=cbchecked else cbRARsfx.State:=cbunchecked; cbRARsfxClick(nil);
if aprarsolid=1 then cbRARsolid.State:=cbchecked else cbRARsolid.State:=cbunchecked; cbRARsolidClick(nil);
if aprarrr=1 then cbRARrr.State:=cbchecked else cbRARrr.State:=cbunchecked; cbRARrrClick(nil);
seRARrr.Value:=apprarrr; seRARrrChange(nil);
if aprarsaveopen=1 then cbRARsaveopen.State:=cbchecked else cbRARsaveopen.State:=cbunchecked; cbRARsaveopenClick(nil);
if aprarsavesecurity=1 then cbRARsavesecurity.State:=cbchecked else cbRARsavesecurity.State:=cbunchecked; cbRARsavesecurityClick(nil);
if aprarsavestreams=1 then cbRARsavestreams.State:=cbchecked else cbRARsavestreams.State:=cbunchecked; cbRARsavestreamsClick(nil);
cbRARlastmodtime.ItemIndex:=aprarlastmodtime; cbRARlastmodtimeChange(nil);
if aprarlock=1 then cbRARlock.State:=cbchecked else cbRARlock.State:=cbunchecked; cbRARlockClick(nil);
EditNameCustom.Text:=vcustom1;
EditExtensionCustom.Text:=vcustom2;
EditOPCustom.Text:=vcustom3;
ComboBoxArchiveCustom.ItemIndex:=vcustom4; on_ComboBoxArchiveCustomChange;
cbDeleteInputModeAdd.ItemIndex:=apdelete; on_cbdeleteinputmode1Change;
if apdopt=1 then CheckBoxDeleteInputAdd.State:=cbchecked else CheckBoxDeleteInputAdd.State:=cbunchecked; on_CheckBoxDeleteInputAddClick;
restorecustlist;
end;
end;

procedure savestatus_extractor;
begin
with FormPeach do
begin
if CheckBoxrelative.State=cbchecked then vopt4f:=1 else vopt4f:=0;
if CheckBoxFolder.State=cbchecked then epfolder:=1
else epfolder:=0;
if mdefaultextract.checked=true then epdefault:=1
else epdefault:=0;
epdefaultextractpath:=defaultextractpath;
epextract:=ComboBoxActionExtract.ItemIndex;
epskip:=Comboboxoverwrite.ItemIndex;
epdelete:=cbDeleteInputModeExt.ItemIndex;
if CheckBoxDeleteInputExt.checked=true then epdopt:=1
else epdopt:=0;
if cbAdvfExt.State=cbchecked then epfilters:=1
else epfilters:=0;
eparcextract:=ComboBoxActionArc.ItemIndex;
eparcskip:=ComboboxoverwriteArc.ItemIndex;
epaceextract:=CheckBoxExtActionAdv.ItemIndex;
if CheckBoxExtNotArchives.State=cbchecked then epsupp:=1
else epsupp:=0;
if CheckBoxsniExt.State=cbchecked then epsni:=1
else epsni:=0;
if CheckBoxsnsExt.State=cbchecked then epsns:=1
else epsns:=0;
if CheckBoxsnzExt.State=cbchecked then epsnz:=1
else epsnz:=0;
if CheckBoxZstdErrPolicy.State=cbchecked then ezstderr:=1
else ezstderr:=0;
if CheckBoxzpaqall.State=cbchecked then epzall:=1
else epzall:=0;
if CheckBoxzpaqfull.State=cbchecked then epzfull:=1
else epzfull:=0;
if CheckBoxzpaqabsolute.State=cbchecked then epzabs:=1
else epzabs:=0;
if CheckBoxzpaqforce.State=cbchecked then epzfor:=1
else epzfor:=0;
if CheckBoxExtUnsupported.State=cbchecked then epunsupp:=1
else epunsupp:=0;
if CheckBoxExtUnsupportedPeaZip.State=cbchecked then epunsupp1:=1
else epunsupp1:=0;
vexpaths:=ComboBoxArchivePathsExt.ItemIndex;
vexcustom1:=EditNameCustomExt.Text;
vexcustom2:=EditCustomParamExt.Text;
vexcustom3:=ComboBoxCustomSyntaxExt.ItemIndex;
savecustlist;
end;
end;

function getextcaption:ansistring;
begin
with FormPeach do
begin
if tonewfolder=0 then
   if movetorelativepath=1 then result:=txt_caption_extract
   else result:=ComboBoxOverwrite.Caption
else
   if removeintdir=1 then result:=txt_5_5_intdir
   else result:=txt_newfoldermenu;
end;
end;

procedure on_CheckBoxFolderClick;
begin
if FormPeach.CheckBoxFolder.state=cbChecked then tonewfolder:=1
else tonewfolder:=0;
FormPeach.Caption:=getextcaption;
updateconf_modified;
settonewfolder(tonewfolder);
end;

procedure on_radiogroupactionchange;
begin
extaction7z:=FormPeach.ComboBoxActionExtract.ItemIndex;
updateconf_modified;
end;

procedure on_ComboBoxOverwriteChange;
begin
extopt7z:=FormPeach.ComboBoxOverwrite.ItemIndex;
FormPeach.Caption:=getextcaption;
updateconf_modified;
end;

procedure on_RadioGroupActionArcChange;
begin
extactionarc:=FormPeach.ComboBoxActionArc.ItemIndex;
updateconf_modified;
end;

procedure on_ComboBoxOverwriteARCChange;
begin
extoptarc:=FormPeach.ComboBoxOverwriteARC.ItemIndex;
updateconf_modified;
end;

procedure on_RadioGroupAction1Change;
begin
extactionace:=FormPeach.CheckBoxExtActionAdv.ItemIndex;
updateconf_modified;
end;

procedure on_CheckBox1Click;
begin
if FormPeach.CheckBoxExtNotArchives.state=cbChecked then esna:=1
else esna:=0;
updateconf_modified;
end;

procedure on_CheckBox2Click;
begin
if FormPeach.CheckBoxExtUnsupported.state=cbChecked then euns:=1
else euns:=0;
updateconf_modified;
end;

procedure on_CheckBox3Click;
begin
if FormPeach.CheckBoxExtUnsupportedPeaZip.state=cbChecked then euns1:=1
else euns1:=0;
updateconf_modified;
end;

procedure on_cbdeleteinputmodeChange;
begin
favdelete:=FormPeach.cbDeleteInputModeExt.ItemIndex;
FormPeach.cbDeleteInputModeAdd.ItemIndex:=FormPeach.cbDeleteInputModeExt.ItemIndex;
end;

procedure on_CheckBoxFolder1_click;
begin
if FormPeach.CheckBoxSmartFolder.State=cbChecked then removeintdir:=1 else removeintdir:=0;
FormPeach.CheckBoxIntDir.State:=FormPeach.CheckBoxSmartFolder.State;
if removeintdir=1 then FormPeach.pmqnointdir.Checked:=true else FormPeach.pmqnointdir.Checked:=false;
updateconf_modified;
end;

procedure on_checkboxrelativeclick;
begin
if FormPeach.CheckBoxrelative.State=cbChecked then movetorelativepath:=1 else movetorelativepath:=0;
if (FormPeach.CheckBoxrelative.State=cbChecked) and (FormPeach.CheckBoxrelative.enabled=true) then
   begin
   FormPeach.Labelsetwork.enabled:=true;
   end
else
   begin
   willbemoved:=false;
   forcewillbemoved:=false;
   moverelpath:='';
   move_out_param:='';
   FormPeach.Labelsetwork.enabled:=false;
   end;
FormPeach.Caption:=getextcaption;
end;

procedure restorestatus_extractor;
begin
with FormPeach do
begin
CheckBoxAutoHaltE.State:=cbUnchecked;
if epfolder=1 then CheckBoxFolder.State:=cbchecked
else CheckBoxFolder.State:=cbunchecked; on_CheckBoxFolderClick;
if vopt4f=1 then CheckBoxrelative.State:=cbchecked
else CheckBoxrelative.State:=cbunchecked; on_CheckBoxrelativeclick;
if epdefault=1 then mdefaultextract.checked:=true
else mdefaultextract.checked:=false;
if epdefault=1 then pmusedefault.checked:=true
else pmusedefault.checked:=false;
defaultextractpath:=epdefaultextractpath;
if mdefaultextract.checked=true then
   begin
   mdefaultextract.caption:=txt_caption_extract+' > '+txt_2_8_usedefaultoutpath+' '+defaultextractpath;
   end
else
   begin
   mdefaultextract.caption:=txt_caption_extract+' > '+txt_7_6_setdef;
   end;
pmusedefault.caption:=mdefaultextract.caption;
lsetdefaultout_ext.caption:=mdefaultextract.caption;
ComboBoxActionExtract.ItemIndex:=epextract; on_radiogroupactionchange;
Comboboxoverwrite.ItemIndex:=epskip; on_ComboBoxOverwriteChange;
cbDeleteInputModeExt.ItemIndex:=epdelete; on_cbdeleteinputmodeChange;
if epdopt=1 then CheckBoxDeleteInputExt.checked:=true
else CheckBoxDeleteInputExt.checked:=false; on_CheckBoxDeleteInputClick;
if epfilters=1 then cbAdvfExt.State:=cbchecked
else cbAdvfExt.State:=cbunchecked;
ComboBoxActionArc.ItemIndex:=eparcextract; on_RadioGroupActionArcChange;
ComboboxoverwriteArc.ItemIndex:=eparcskip; on_ComboboxoverwriteArcChange;
CheckBoxExtActionAdv.ItemIndex:=epaceextract; on_RadioGroupAction1Change;
if epsupp=1 then CheckBoxExtNotArchives.State:=cbchecked
else CheckBoxExtNotArchives.State:=cbunchecked; on_CheckBox1Click;
if epsni=1 then CheckBoxsniExt.State:=cbchecked
else CheckBoxsniExt.State:=cbunchecked; CheckBoxsniExt_onclick;
if epsns=1 then CheckBoxsnsExt.State:=cbchecked
else CheckBoxsnsExt.State:=cbunchecked; CheckBoxsnsExt_onclick;
if epsnz=1 then CheckBoxsnzExt.State:=cbchecked
else CheckBoxsnzExt.State:=cbunchecked; CheckBoxsnzExt_onclick;
if ezstderr=1 then CheckBoxZstdErrPolicy.State:=cbchecked
else CheckBoxZstdErrPolicy.State:=cbunchecked; CheckBoxZstdErrPolicy_onclick;
if epzall=1 then CheckBoxzpaqall.State:=cbchecked
else CheckBoxzpaqall.State:=cbunchecked; CheckBoxzpaqallClick(nil);
if epzfull=1 then CheckBoxzpaqfull.State:=cbchecked
else CheckBoxzpaqfull.State:=cbunchecked; CheckBoxzpaqfullClick(nil);
if epzabs=1 then CheckBoxzpaqabsolute.State:=cbchecked
else CheckBoxzpaqabsolute.State:=cbunchecked; CheckBoxzpaqabsoluteClick(nil);
if epzfor=1 then CheckBoxzpaqforce.State:=cbchecked
else CheckBoxzpaqforce.State:=cbunchecked; CheckBoxzpaqforceClick(nil);
if epunsupp=1 then CheckBoxExtUnsupported.State:=cbchecked
else CheckBoxExtUnsupported.State:=cbunchecked; on_CheckBox2Click;
if epunsupp1=1 then CheckBoxExtUnsupportedPeaZip.State:=cbchecked
else CheckBoxExtUnsupportedPeaZip.State:=cbunchecked; on_CheckBox3Click;
ComboBoxArchivePathsExt.ItemIndex:=vexpaths;
EditNameCustomExt.Text:=vexcustom1;
EditCustomParamExt.Text:=vexcustom2;
ComboBoxCustomSyntaxExt.ItemIndex:=vexcustom3;
restorecustlist;
end;
end;

procedure savestatus_defaults;
begin
with FormPeach do
begin
vopt1:=EditDesk.Caption;
vopt1b:=EditEncoding.Caption;
vopt1c:=FormPeach.Editalias.Caption;
vopt2:=cbBinaries.ItemIndex;
vopt3:=cbBinariesStop.ItemIndex;
voptlibre:=ComboBoxLibre.ItemIndex;
voptprivacy:=ComboBoxPrivacy.ItemIndex;
if CheckBoxSkipenc.State=cbchecked then vopt4g:=1 else vopt4g:=0;
if CheckBoxSmartFolder.State=cbchecked then epfolder1:=1 else epfolder1:=0;
if cbtimecreated.State=cbchecked then v7z17c:=1 else v7z17c:=0;
if CheckBoxnameasparentfolder.State=cbchecked then vopt4c:=1 else vopt4c:=0;
if CheckBoxAutoOpen.State=cbchecked then vopt4:=1 else vopt4:=0;
if CheckBoxAutoTest.State=cbchecked then vopt4h:=1 else vopt4h:=0;
if CheckBoxClosePeaZip.State=cbchecked then vopt4d:=1 else vopt4d:=0;
if CheckBoxDragDrop.State=cbchecked then vopt5e:=1 else vopt5e:=0;
if CheckBoxEditArchives.State=cbchecked then vopt5f:=1 else vopt5f:=0;
vopt5f1:=ComboBoxSysbin.ItemIndex;
if CheckBoxJobEncoding.State=cbchecked then vopt5:=1 else vopt5:=0;
if CheckBoxShowVolatile.State=cbchecked then vopt5b:=1 else vopt5b:=0;
if CheckBoxAutoOpenTar.State=cbchecked then vopt5g:=1 else vopt5g:=0;
if cbqdup.State=cbchecked then vopt5dup:=1 else vopt5dup:=0;
if cbshowhidden.State=cbchecked then vopt5dsh:=1 else vopt5dsh:=0;
if CheckBoxAutoExtTar.State=cbchecked then vopt5gtar:=1 else vopt5gtar:=0;
if CheckBoxAutoExtTarConvert.State=cbchecked then vopt5gtar1:=1 else vopt5gtar1:=0;
if CheckBoxNoConf.State=cbchecked then vopt5h:=1 else vopt5h:=0;
if CheckBoxzipxswitch.State=cbchecked then vopt5sw:=1 else vopt5sw:=0;
if CheckBoxAC.State=cbchecked then vopt5ca:=1 else vopt5ca:=0;
if CheckBoxForceOpen.State=cbchecked then vopt5c:=1 else vopt5c:=0;
if CheckBoxForceEdit.State=cbchecked then vopt5d:=1 else vopt5d:=0;
vopt5dt:=cbforcetype.ItemIndex;
if CheckBoxExcludeEF.State=cbchecked then vopt5d4:=1 else vopt5d4:=0;
if CheckBoxUTC.State=cbchecked then vopt5utc:=1 else vopt5utc:=0;
if CheckBoxForceLayout.State=cbchecked then vopt5d3:=1 else vopt5d3:=0;
vopt5d3t:=LabelForceLayout.Caption;
vopt5csv:=EditCSVsep.Caption;
if CheckBoxForceBrowse.State=cbchecked then vopt5d1:=1 else vopt5d1:=0;
if CheckBoxForceConvert.State=cbchecked then vopt5d2:=1 else vopt5d2:=0;
if CheckBoxEncoding.State=cbchecked then vopt6:=1 else vopt6:=0;
vopt23:=cbEncoding.ItemIndex;
vopt23b:=ComboBoxSyntaxLevel.ItemIndex;
vopt24:=cbtree.ItemIndex;
vopt24c:=cbautobrowsetar.ItemIndex;
vopt24b:=cbdefaultaction.ItemIndex;
vopt7:=ComboBoxConsoleEncoding.ItemIndex;
vopt7b:=ComboboxSD.ItemIndex;
vopt7c:=LabelcbSDcustom.Caption;
if CheckBoxParallelArchiving.State=cbchecked then vopt8:=1 else vopt8:=0;
if CheckBoxArchiveHistory.State=cbchecked then vopt9:=1 else vopt9:=0;
if CheckBoxShowHints.State=cbchecked then vopt10:=1 else vopt10:=0;
if CheckBoxzcopy.State=cbchecked then vopt11:=1 else vopt11:=0;
vopt12:=ComboBoxWD.ItemIndex;
vopt12t:=custom_work_path;
vopt13:=cbDefaultFormat.ItemIndex;
voptts:=cbTimeStamp.ItemIndex;
vopt15c:=ComboBoxBrowser.ItemIndex;
vopt15h:=ComboBoxMaxArg.ItemIndex;
vopt15gg:=ComboBoxVirtual.ItemIndex;
vopt15g:=ComboBoxPriority.ItemIndex;
vopt15f:=ComboBoxDrag.ItemIndex;
if CheckBoxBrowseNotVerbose.State=cbchecked then vopt15d:=1 else vopt15d:=0;
if CheckBoxSkipDel.State=cbchecked then vopt15i:=1 else vopt15i:=0;
if CheckBox7zunrar5.State=cbchecked then vopt15e:=1 else vopt15e:=0;
if CheckBoxExtrac32.State=cbchecked then vopt15e2:=1 else vopt15e2:=0;
vopt16:=RadioGrouppwrequest.ItemIndex;
if CheckBoxIgnoreDisp.State=cbchecked then vopt17:=1 else vopt17:=0;
if CheckBoxIntDir.State=cbchecked then vopt25:=1 else vopt25:=0;
if CheckBoxIgnoreSel.State=cbchecked then vopt18:=1 else vopt18:=0;
if CheckBoxExtAnd.State=cbchecked then vopt18b:=1 else vopt18b:=0;
if CheckBoxIgnorePaths.State=cbchecked then vopt19:=1 else vopt19:=0;
if cbautoclosesingleextract.State=cbchecked then vopt19b:=1 else vopt19b:=0;
vopt19c:=cbExtEvForWhen.ItemIndex;
vopt19csec:=ComboBoxsec.ItemIndex;
vopt19d:=cbExtEvForHow.ItemIndex;
vopt19e:=editExtEvForWhat.Caption;
vopt19esec:=editExtEvForSec.Caption;
vopt19f:=Editcommonalgo.Caption;
vopt20:=cbHashFormat.ItemIndex;
vopt20b:=cbBrowserHash.ItemIndex;
vopt21:=cbHash.ItemIndex;
vopt22:=ComboBoxPasses.ItemIndex;
vopt22b:=ComboBoxKiB.ItemIndex;
end;
end;

procedure on_RadioGroup4Change;
begin
zaout:=FormPeach.cbBinaries.ItemIndex;
zaout1:=zaout;
end;

procedure on_RadioGroup6Change;
begin
autoclosegwrap:=FormPeach.cbBinariesStop.ItemIndex;
end;

procedure on_CheckBoxJobEncodingClick;
begin
if FormPeach.CheckBoxJobEncoding.State=cbChecked then jobdefenc:=1 else jobdefenc:=0;
end;

procedure on_CheckBoxEncodingClick;
begin
if FormPeach.CheckBoxEncoding.State=cbChecked then archivenameenc:=1 else archivenameenc:=0;
end;

procedure on_ComboBox1Change;
begin
enc7zscc:=FormPeach.ComboBoxConsoleEncoding.ItemIndex;
end;

procedure on_ComboBoxSyntaxLevelChange;
begin
syntaxlevel7z:=FormPeach.ComboBoxSyntaxLevel.ItemIndex;
setsyntaxstring7z;
end;

procedure on_ComboBoxSDChange;
begin
browsersd:=FormPeach.ComboBoxSD.ItemIndex;
browsersdir:='';
if browsersd=4 then
   if FormPeach.SelectDirectoryDialog1.Execute then
      if FormPeach.SelectDirectoryDialog1.FileName<>'' then
         browsersdir:=FormPeach.SelectDirectoryDialog1.FileName
      else
         begin
         FormPeach.ComboBoxSD.ItemIndex:=0;
         on_ComboBoxSDChange;
         end
   else
      begin
      FormPeach.ComboBoxSD.ItemIndex:=0;
      on_ComboBoxSDChange;
      end;
FormPeach.LabelcbSDcustom.Caption:=browsersdir;
end;

procedure on_CheckBoxArchiveHistory_click;
begin
if FormPeach.CheckBoxArchiveHistory.State=cbChecked then savehistory:=1 else savehistory:=0;
if savehistory=1 then FormPeach.LabelResetHistory.enabled:=true else FormPeach.LabelResetHistory.enabled:=false;
end;

procedure on_CheckBoxShowHintsClick;
begin
if FormPeach.CheckBoxShowHints.State=cbChecked then showguihints:=1 else showguihints:=0;
end;

procedure on_ComboBoxWDChange;
begin
work_dir:=FormPeach.ComboBoxWD.ItemIndex;
end;

procedure on_CheckBoxzcopyClick;
begin
if FormPeach.CheckBoxzcopy.State=cbChecked then zcopy:=1 else zcopy:=0;
end;

procedure on_CheckBoxParallelArchivingClick;
begin
if FormPeach.CheckBoxParallelarchiving.State=cbChecked then parallelarchive:=1 else parallelarchive:=0;
end;

procedure on_RadioGroup0Change;
begin
df:=FormPeach.cbDefaultFormat.ItemIndex;
archive_type_selected:=-1;
end;

procedure on_cbforcetypeChange;
begin
forcetype:=FormPeach.cbforcetype.ItemIndex;
end;

procedure on_cbExtEvForWhenChange;
begin
whenspecialopen:=FormPeach.cbExtEvForWhen.ItemIndex;
if whenspecialopen=0 then
   begin
   FormPeach.cbExtEvForHow.enabled:=false;
   FormPeach.editExtEvForWhat.enabled:=false;
   end
else
   begin
   FormPeach.cbExtEvForHow.enabled:=true;
   FormPeach.editExtEvForWhat.enabled:=true;
   end;
end;

procedure on_cbExtEvForHowChange;
begin
howspecialopen:=FormPeach.cbExtEvForHow.ItemIndex;
end;

procedure on_RadioGroupTSClick;
begin
tsstyle:=FormPeach.cbTimeStamp.ItemIndex;
end;

procedure on_CheckBoxSkipDel_click;
begin
if FormPeach.CheckBoxSkipDel.State=cbChecked then skipdel:=1 else skipdel:=0;
end;

procedure on_CheckBoxBrowseNotVerbose_click;
begin
if FormPeach.CheckBoxBrowseNotVerbose.State=cbChecked then nonverboselog:=1 else nonverboselog:=0;
end;

procedure on_CheckBoxPrebrowse_click;
begin
case FormPeach.ComboBoxBrowser.ItemIndex of
   0: prebrowse:=0;
   1: prebrowse:=2;
   2: prebrowse:=3;
   3: prebrowse:=4;
   4: prebrowse:=5;
end;
end;

procedure on_CheckBoxmaxarg_click;
begin
maxargsize:=FormPeach.ComboBoxMaxArg.ItemIndex;
{$IFDEF MSWINDOWS}
//Windows handle up to 32KB maximum command line length
max_cl:=32768;
{$ELSE}
//32KB to 2MB custom maximum command line length is now supported for Linux Systems
max_cl:=131072;
case maxargsize of
   0: max_cl:=32*1024;
   1: max_cl:=64*1024;
   2: max_cl:=128*1024;
   3: max_cl:=256*1024;
   4: max_cl:=512*1024;
   5: max_cl:=1024*1024;
   6: max_cl:=1536*1024;
   7: max_cl:=2048*1024;
end;
{$ENDIF}
end;

procedure on_comboboxvirtualchange;
begin
virtualopt:=FormPeach.ComboBoxVirtual.ItemIndex;
case virtualopt of
   0: begin
      defaultvirtualopt;
      end;
   1: begin allowvirtual:=1; sizevirtual:=0; end;
   2: begin allowvirtual:=1; sizevirtual:=4; end;
   3: begin allowvirtual:=1; sizevirtual:=8; end;
   4: begin allowvirtual:=1; sizevirtual:=16; end;
   5: begin allowvirtual:=0; sizevirtual:=0; end;
   end;
end;

procedure on_comboboxprioritychange;
begin
taskpriority:=FormPeach.ComboBoxPriority.ItemIndex;
end;

procedure on_CheckBoxDrag_click;
begin
dragtargetprotect:=FormPeach.ComboBoxDrag.ItemIndex;
end;

procedure on_RadioGrouppwrequestChange;
begin
extpw:=FormPeach.RadioGrouppwrequest.ItemIndex;
end;

procedure on_CheckBoxIgnoreDisp_click;
begin
if FormPeach.CheckBoxIgnoreDisp.State=cbChecked then ignorepathdisp:=1 else ignorepathdisp:=0;
end;

procedure on_CheckBoxIgnoreSel_click;
begin
if FormPeach.CheckBoxIgnoreSel.State=cbChecked then ignorepathsel:=1 else ignorepathsel:=0;
end;

procedure on_CheckBoxExtAnd_click;
begin
if FormPeach.CheckBoxExtAnd.State=cbChecked then enableextand:=1 else enableextand:=0;
if enableextand=1 then FormPeach.MenuItemOpen_extandopenwith.Visible:=true
else FormPeach.MenuItemOpen_extandopenwith.Visible:=false;
end;

procedure on_CheckBoxIntDir_click;
begin
if FormPeach.CheckBoxIntDir.State=cbChecked then removeintdir:=1 else removeintdir:=0;
FormPeach.CheckBoxSmartFolder.State:=FormPeach.CheckBoxIntDir.State;
if removeintdir=1 then FormPeach.pmqnointdir.Checked:=true else FormPeach.pmqnointdir.Checked:=false;
end;

procedure on_CheckBox4_click;
begin
if FormPeach.CheckBoxIgnorePaths.State=cbChecked then ignorepathextand:=1 else ignorepathextand:=0;
end;

procedure on_RadioGroup1Click;
begin
algodisp:=FormPeach.cbHashFormat.ItemIndex;
end;

procedure on_RadioGroup2Click;
begin
setbrowser_crchash(FormPeach.cbBrowserHash.ItemIndex+1);
end;

procedure on_cbcheckallClick;
begin
algoall:=FormPeach.cbHash.ItemIndex;
if algoall=0 then
   begin
   FormPeach.LabelCommonAlgo.Enabled:=true;
   FormPeach.Editcommonalgo.Enabled:=true;
   end
else
   begin
   FormPeach.LabelCommonAlgo.Enabled:=false;
   FormPeach.Editcommonalgo.Enabled:=false;
   end;
end;

procedure on_ComboBoxKiBChange;
begin
filesizebase:=FormPeach.ComboBoxKiB.ItemIndex;
end;

procedure on_ComboBoxPassesChange;
begin
erasepasses:=FormPeach.ComboBoxPasses.ItemIndex;
end;

procedure setzencoding;
begin
FormPeach.zenclocalutf8.checked:=false;
FormPeach.zencutf8.checked:=false;
FormPeach.zenclocal.checked:=false;
FormPeach.zenc437.checked:=false;
FormPeach.zenc850.checked:=false;
FormPeach.zenc852.checked:=false;
FormPeach.zenc858.checked:=false;
FormPeach.zenc866.checked:=false;
FormPeach.zenc874.checked:=false;
FormPeach.zenc932.checked:=false;
FormPeach.zenc936.checked:=false;
FormPeach.zenc949.checked:=false;
FormPeach.zenc950.checked:=false;
FormPeach.zenc1250.checked:=false;
FormPeach.zenc1251.checked:=false;
FormPeach.zenc1252.checked:=false;
FormPeach.zenc1253.checked:=false;
FormPeach.zenc1254.checked:=false;
FormPeach.zenc1255.checked:=false;
FormPeach.zenc1256.checked:=false;
FormPeach.zenc1257.checked:=false;
FormPeach.zenc1258.checked:=false;
FormPeach.zenc20866.checked:=false;
FormPeach.zenc21866.checked:=false;
FormPeach.zenc65001.checked:=false;
case mcuzip of
   0: FormPeach.zenclocalutf8.checked:=true;
   1: FormPeach.zencutf8.checked:=true;
   2: FormPeach.zenclocal.checked:=true;
   3: case FormPeach.editencoding.Caption of
      '437': FormPeach.zenc437.checked:=true;
      '850': FormPeach.zenc850.checked:=true;
      '852': FormPeach.zenc852.checked:=true;
      '858': FormPeach.zenc858.checked:=true;
      '866': FormPeach.zenc866.checked:=true;
      '874': FormPeach.zenc874.checked:=true;
      '932': FormPeach.zenc932.checked:=true;
      '936': FormPeach.zenc936.checked:=true;
      '949': FormPeach.zenc949.checked:=true;
      '950': FormPeach.zenc950.checked:=true;
      '1250': FormPeach.zenc1250.checked:=true;
      '1251': FormPeach.zenc1251.checked:=true;
      '1252': FormPeach.zenc1252.checked:=true;
      '1253': FormPeach.zenc1253.checked:=true;
      '1254': FormPeach.zenc1254.checked:=true;
      '1255': FormPeach.zenc1255.checked:=true;
      '1256': FormPeach.zenc1256.checked:=true;
      '1257': FormPeach.zenc1257.checked:=true;
      '1258': FormPeach.zenc1258.checked:=true;
      '20866': FormPeach.zenc20866.checked:=true;
      '21866': FormPeach.zenc21866.checked:=true;
      '65001': FormPeach.zenc65001.checked:=true;
      end;
   end;
FormPeach.mzenclocalutf8.checked:=false;
FormPeach.mzencutf8.checked:=false;
FormPeach.mzenclocal.checked:=false;
FormPeach.mzenc437.checked:=false;
FormPeach.mzenc850.checked:=false;
FormPeach.mzenc852.checked:=false;
FormPeach.mzenc858.checked:=false;
FormPeach.mzenc866.checked:=false;
FormPeach.mzenc874.checked:=false;
FormPeach.mzenc932.checked:=false;
FormPeach.mzenc936.checked:=false;
FormPeach.mzenc949.checked:=false;
FormPeach.mzenc950.checked:=false;
FormPeach.mzenc1250.checked:=false;
FormPeach.mzenc1251.checked:=false;
FormPeach.mzenc1252.checked:=false;
FormPeach.mzenc1253.checked:=false;
FormPeach.mzenc1254.checked:=false;
FormPeach.mzenc1255.checked:=false;
FormPeach.mzenc1256.checked:=false;
FormPeach.mzenc1257.checked:=false;
FormPeach.mzenc1258.checked:=false;
FormPeach.mzenc20866.checked:=false;
FormPeach.mzenc21866.checked:=false;
FormPeach.mzenc65001.checked:=false;
case mcuzip of
   0: FormPeach.mzenclocalutf8.checked:=true;
   1: FormPeach.mzencutf8.checked:=true;
   2: FormPeach.mzenclocal.checked:=true;
   3: case FormPeach.editencoding.Caption of
      '437': FormPeach.mzenc437.checked:=true;
      '850': FormPeach.mzenc850.checked:=true;
      '852': FormPeach.mzenc852.checked:=true;
      '858': FormPeach.mzenc858.checked:=true;
      '866': FormPeach.mzenc866.checked:=true;
      '874': FormPeach.mzenc874.checked:=true;
      '932': FormPeach.mzenc932.checked:=true;
      '936': FormPeach.mzenc936.checked:=true;
      '949': FormPeach.mzenc949.checked:=true;
      '950': FormPeach.mzenc950.checked:=true;
      '1250': FormPeach.mzenc1250.checked:=true;
      '1251': FormPeach.mzenc1251.checked:=true;
      '1252': FormPeach.mzenc1252.checked:=true;
      '1253': FormPeach.mzenc1253.checked:=true;
      '1254': FormPeach.mzenc1254.checked:=true;
      '1255': FormPeach.mzenc1255.checked:=true;
      '1256': FormPeach.mzenc1256.checked:=true;
      '1257': FormPeach.mzenc1257.checked:=true;
      '1258': FormPeach.mzenc1258.checked:=true;
      '20866': FormPeach.mzenc20866.checked:=true;
      '21866': FormPeach.mzenc21866.checked:=true;
      '65001': FormPeach.mzenc65001.checked:=true;
      end;
   end;
FormPeach.azenclocalutf8.checked:=false;
FormPeach.azencutf8.checked:=false;
FormPeach.azenclocal.checked:=false;
FormPeach.azenc437.checked:=false;
FormPeach.azenc850.checked:=false;
FormPeach.azenc852.checked:=false;
FormPeach.azenc858.checked:=false;
FormPeach.azenc866.checked:=false;
FormPeach.azenc874.checked:=false;
FormPeach.azenc932.checked:=false;
FormPeach.azenc936.checked:=false;
FormPeach.azenc949.checked:=false;
FormPeach.azenc950.checked:=false;
FormPeach.azenc1250.checked:=false;
FormPeach.azenc1251.checked:=false;
FormPeach.azenc1252.checked:=false;
FormPeach.azenc1253.checked:=false;
FormPeach.azenc1254.checked:=false;
FormPeach.azenc1255.checked:=false;
FormPeach.azenc1256.checked:=false;
FormPeach.azenc1257.checked:=false;
FormPeach.azenc1258.checked:=false;
FormPeach.azenc20866.checked:=false;
FormPeach.azenc21866.checked:=false;
FormPeach.azenc65001.checked:=false;
case mcuzip of
   0: FormPeach.azenclocalutf8.checked:=true;
   1: FormPeach.azencutf8.checked:=true;
   2: FormPeach.azenclocal.checked:=true;
   3: case FormPeach.editencoding.Caption of
      '437': FormPeach.azenc437.checked:=true;
      '850': FormPeach.azenc850.checked:=true;
      '852': FormPeach.azenc852.checked:=true;
      '858': FormPeach.azenc858.checked:=true;
      '866': FormPeach.azenc866.checked:=true;
      '874': FormPeach.azenc874.checked:=true;
      '932': FormPeach.azenc932.checked:=true;
      '936': FormPeach.azenc936.checked:=true;
      '949': FormPeach.azenc949.checked:=true;
      '950': FormPeach.azenc950.checked:=true;
      '1250': FormPeach.azenc1250.checked:=true;
      '1251': FormPeach.azenc1251.checked:=true;
      '1252': FormPeach.azenc1252.checked:=true;
      '1253': FormPeach.azenc1253.checked:=true;
      '1254': FormPeach.azenc1254.checked:=true;
      '1255': FormPeach.azenc1255.checked:=true;
      '1256': FormPeach.azenc1256.checked:=true;
      '1257': FormPeach.azenc1257.checked:=true;
      '1258': FormPeach.azenc1258.checked:=true;
      '20866': FormPeach.azenc20866.checked:=true;
      '21866': FormPeach.azenc21866.checked:=true;
      '65001': FormPeach.azenc65001.checked:=true;
      end;
   end;
end;

procedure on_CBEncoding1Change;
begin
mcuzip:=FormPeach.cbEncoding.ItemIndex;
if FormPeach.cbEncoding.ItemIndex=3 then FormPeach.EditEncoding.Visible:=true else FormPeach.EditEncoding.Visible:=false;
setzencoding;
end;

procedure on_CheckBoxnameasparentfolderclick;
begin
if FormPeach.CheckBoxNameAsParentFolder.State=cbChecked then nameaspartent:=1 else nameaspartent:=0;
end;

procedure on_ComboBoxLibreChange;
begin
libre_directive:=FormPeach.ComboBoxLibre.ItemIndex;
end;

procedure on_ComboBoxPrivacyChange;
begin
privacy_mode:=FormPeach.ComboBoxPrivacy.ItemIndex;
end;

procedure on_CheckBoxExtrac32_click;
begin
if FormPeach.CheckBoxExtrac32.State=cbChecked then useextrac32:=1 else useextrac32:=0;
end;

procedure on_CheckBox7zunrar5_click;
begin
if FormPeach.CheckBox7zunrar5.State=cbChecked then use7zunrar5:=1 else use7zunrar5:=0;
end;

procedure settabs;
begin
if (alttabstyle=2) or (alttabstyle=5) then tablabelheight:=30
else tablabelheight:=24;
tablabelheight:=(tablabelheight*qscale) div 100;
settabsstyled;
end;

procedure on_CheckBoxShowVolatileClick;
begin
if FormPeach.CheckBoxShowVolatile.State=cbChecked then showvolatile:=1 else showvolatile:=0;
setshowvolatile;
end;

procedure on_CheckBoxForceOpenClick;
begin
if FormPeach.CheckBoxForceOpen.State=cbChecked then tryopenwerrors:=1 else tryopenwerrors:=0;
end;

procedure on_CheckBoxForceBrowseClick;
begin
if FormPeach.CheckBoxForceBrowse.State=cbChecked then forcebrowse:=1 else forcebrowse:=0;
end;

procedure on_CheckBoxForceConvertClick;
begin
if FormPeach.CheckBoxForceConvert.State=cbChecked then forceconvert:=1 else forceconvert:=0;
end;

procedure on_CheckBoxForceLayoutClick;
begin
if FormPeach.CheckBoxForceLayout.State=cbChecked then forcelayout:=1 else forcelayout:=0;
if forcelayout=0 then
   begin
   FormPeach.LabelForceLayout.Caption:='';
   end;
end;

procedure on_CheckBoxForceEditClick;
begin
if FormPeach.CheckBoxForceEdit.State=cbChecked then forcecanbechanged:=1 else forcecanbechanged:=0;
if forcecanbechanged=1 then FormPeach.cbforcetype.enabled:=true else FormPeach.cbforcetype.enabled:=false;
end;

procedure on_CheckBoxExcludeEFClick;
begin
if FormPeach.CheckBoxExcludeEF.State=cbChecked then excludeef:=1 else excludeef:=0;
end;

procedure on_checkboxutcclick;
begin
if FormPeach.CheckBoxUTC.State=cbChecked then tsutc:=1 else tsutc:=0;
end;

procedure on_CheckBoxNoConfClick;
begin
if FormPeach.CheckBoxNoConf.State=cbChecked then noconfdel:=1 else noconfdel:=0;
end;

procedure on_cbautoclosesingleextract_click;
begin
if FormPeach.cbautoclosesingleextract.State=cbChecked then closeonsingleextract:=1 else closeonsingleextract:=0;
end;

procedure on_cbtreechange;
begin
ptsync:=FormPeach.cbtree.ItemIndex;
end;

procedure on_cbdefaultactionchange;
begin
defaultactionst:=FormPeach.cbdefaultaction.ItemIndex;
end;

procedure on_cbsys7zlinchange;
begin
sys7zlin:=FormPeach.ComboBoxSysbin.ItemIndex;
end;

procedure on_cbqdupclick;
begin
if FormPeach.cbqdup.State=cbChecked then qdup:=1 else qdup:=0;
end;

procedure on_cbautobrowsetarChange;
begin
abt:=FormPeach.cbautobrowsetar.ItemIndex;
end;

procedure on_cbshowhiddenclick;
begin
if FormPeach.cbshowhidden.State=cbChecked then pshowh:=true else pshowh:=false;
FormPeach.mshowhidden.Checked:=pshowh;
list_utils.showhidden:=pshowh;
end;

procedure restorestatus_defaults;
begin
with FormPeach do
begin
EditDesk.Caption:=vopt1; local_desktop:=vopt1;
EditEncoding.Caption:=vopt1b;
Editalias.Caption:=vopt1c;
cbBinaries.ItemIndex:=vopt2; on_RadioGroup4Change;
cbBinariesStop.ItemIndex:=vopt3; on_RadioGroup6Change;
ComboBoxLibre.ItemIndex:=voptlibre; on_ComboBoxLibreChange;
ComboBoxPrivacy.ItemIndex:=voptprivacy; on_ComboBoxPrivacyChange;
if epfolder1=1 then CheckBoxSmartFolder.State:=cbchecked else CheckBoxSmartFolder.State:=cbunchecked; on_CheckBoxFolder1_click;
if vopt4g=1 then CheckBoxSkipenc.State:=cbchecked else CheckBoxSkipenc.State:=cbunchecked; FormPeach.CheckBoxSkipencClick(nil);
if v7z17c=1 then cbtimecreated.State:=cbchecked else cbtimecreated.State:=cbunchecked; cbtimecreated_onclick;
if vopt4c=1 then CheckBoxnameasparentfolder.State:=cbchecked
else CheckBoxnameasparentfolder.State:=cbunchecked;
on_CheckBoxnameasparentfolderclick;
if vopt4=1 then CheckBoxAutoOpen.State:=cbchecked
else CheckBoxAutoOpen.State:=cbunchecked;
on_CheckBoxAutoOpenClick;
if vopt4h=1 then CheckBoxAutoTest.State:=cbchecked
else CheckBoxAutoTest.State:=cbunchecked;
on_CheckBoxAutoTestClick;
if vopt4d=1 then CheckBoxClosePeaZip.State:=cbchecked
else CheckBoxClosePeaZip.State:=cbunchecked;
FormPeach.CheckBoxClosePeaZipClick(nil);
if vopt5=1 then CheckBoxJobEncoding.State:=cbchecked else CheckBoxJobEncoding.State:=cbunchecked; on_CheckBoxJobEncodingClick;
if vopt5b=1 then CheckBoxShowVolatile.State:=cbchecked else CheckBoxShowVolatile.State:=cbunchecked; on_CheckBoxShowVolatileClick;
if vopt5g=1 then CheckBoxAutoOpenTar.State:=cbchecked else CheckBoxAutoOpenTar.State:=cbunchecked; on_CheckBoxAutoOpenTarClick;
if vopt5dup=1 then cbqdup.State:=cbchecked else cbqdup.State:=cbunchecked; on_cbqdupClick;
if vopt5dsh=1 then cbshowhidden.State:=cbchecked else cbshowhidden.State:=cbunchecked; on_cbshowhiddenClick;
if vopt5gtar=1 then CheckBoxAutoExtTar.State:=cbchecked else CheckBoxAutoExtTar.State:=cbunchecked; on_CheckBoxAutoExtTarClick;
if vopt5gtar1=1 then CheckBoxAutoExtTarConvert.State:=cbchecked else CheckBoxAutoExtTarConvert.State:=cbunchecked; on_CheckBoxAutoExtTar1Click;
if vopt5h=1 then CheckBoxNoConf.State:=cbchecked else CheckBoxNoConf.State:=cbunchecked; on_CheckBoxNoConfClick;
if vopt5sw=1 then CheckBoxzipxswitch.State:=cbchecked else CheckBoxzipxswitch.State:=cbunchecked; CheckBoxzipxswitchClick(nil);
if vopt5ca=1 then CheckBoxAC.State:=cbchecked else CheckBoxAC.State:=cbunchecked; CheckBoxACClick(nil);
if vopt5c=1 then CheckBoxForceOpen.State:=cbchecked else CheckBoxForceOpen.State:=cbunchecked; on_CheckBoxForceOpenClick;
if vopt5d=1 then CheckBoxForceEdit.State:=cbchecked else CheckBoxForceEdit.State:=cbunchecked; on_CheckBoxForceEditClick;
cbforcetype.ItemIndex:=vopt5dt; on_cbforcetypeChange;
if vopt5d4=1 then CheckBoxExcludeEF.State:=cbchecked else CheckBoxExcludeEF.State:=cbunchecked; on_CheckBoxExcludeEFClick;
if vopt5utc=1 then CheckBoxUTC.State:=cbchecked else CheckBoxUTC.State:=cbunchecked; on_CheckBoxUTCClick;
if vopt5d3=1 then CheckBoxForceLayout.State:=cbchecked else CheckBoxForceLayout.State:=cbunchecked; on_CheckBoxForceLayoutClick;
LabelForceLayout.Caption:=vopt5d3t;
EditCSVsep.Caption:=vopt5csv;
if vopt5d1=1 then CheckBoxForceBrowse.State:=cbchecked else CheckBoxForceBrowse.State:=cbunchecked; on_CheckBoxForceBrowseClick;
if vopt5d2=1 then CheckBoxForceConvert.State:=cbchecked else CheckBoxForceConvert.State:=cbunchecked; on_CheckBoxForceConvertClick;
if vopt5e=1 then CheckBoxDragDrop.State:=cbchecked else CheckBoxDragDrop.State:=cbunchecked; on_CheckBoxDragDrop_Click;
if vopt5f=1 then CheckBoxEditArchives.State:=cbchecked else CheckBoxEditArchives.State:=cbunchecked; on_CheckBoxEditArchives_Click;
ComboBoxSysbin.ItemIndex:=vopt5f1; on_cbsys7zlinchange;
if vopt6=1 then CheckBoxEncoding.State:=cbchecked else CheckBoxEncoding.State:=cbunchecked; on_CheckBoxEncodingClick;
cbEncoding.ItemIndex:=vopt23; on_CBEncoding1Change;
ComboBoxSyntaxLevel.ItemIndex:=vopt23b; on_ComboBoxSyntaxLevelChange;
cbtree.ItemIndex:=vopt24; on_cbtreeChange;
cbautobrowsetar.ItemIndex:=vopt24c; on_cbautobrowsetarChange;
cbdefaultaction.ItemIndex:=vopt24b; on_cbdefaultactionchange;
ComboBoxConsoleEncoding.ItemIndex:=vopt7; on_ComboBox1Change;
ComboboxSD.ItemIndex:=vopt7b;
LabelcbSDcustom.Caption:=vopt7c;
if vopt7b<4 then on_ComboBoxSDChange else begin browsersd:=4; browsersdir:=vopt7c; end;
if vopt8=1 then CheckBoxParallelArchiving.State:=cbchecked else CheckBoxParallelArchiving.State:=cbunchecked; on_CheckBoxParallelArchivingClick;
if vopt9=1 then CheckBoxArchiveHistory.State:=cbchecked else CheckBoxArchiveHistory.State:=cbunchecked; on_CheckBoxArchiveHistory_click;
if vopt10=1 then CheckBoxShowHints.State:=cbchecked else CheckBoxShowHints.State:=cbunchecked; on_CheckBoxShowHintsClick;
if vopt11=1 then CheckBoxzcopy.State:=cbchecked else CheckBoxzcopy.State:=cbunchecked; on_CheckBoxzcopyClick;
ComboBoxWD.ItemIndex:=vopt12; on_ComboBoxWDChange;
LabelCustomWorkPath.Caption:=vopt12t;
custom_work_path:=vopt12t;
cbDefaultFormat.ItemIndex:=vopt13; on_RadioGroup0Change;
cbTimeStamp.ItemIndex:=voptts; on_RadioGroupTSClick;
if vopt15d=1 then CheckBoxBrowseNotVerbose.State:=cbchecked else CheckBoxBrowseNotVerbose.State:=cbunchecked; on_CheckBoxBrowseNotVerbose_click;
if vopt15i=1 then CheckBoxSkipDel.State:=cbchecked else CheckBoxSkipDel.State:=cbunchecked; on_CheckBoxSkipDel_click;
if vopt15e=1 then CheckBox7zunrar5.State:=cbchecked else CheckBox7zunrar5.State:=cbunchecked; on_CheckBox7zunrar5_click;
if vopt15e2=1 then CheckBoxExtrac32.State:=cbchecked else CheckBoxExtrac32.State:=cbunchecked; on_CheckBoxExtrac32_click;
ComboBoxBrowser.ItemIndex:=vopt15c; on_CheckBoxPrebrowse_click;
ComboBoxMaxArg.ItemIndex:=vopt15h; on_CheckBoxmaxarg_click;
ComboBoxVirtual.ItemIndex:=vopt15gg; on_comboboxvirtualchange;
ComboBoxPriority.ItemIndex:=vopt15g; on_comboboxprioritychange;
ComboBoxDrag.ItemIndex:=vopt15f; on_CheckBoxDrag_click;
RadioGrouppwrequest.ItemIndex:=vopt16; on_RadioGrouppwrequestChange;
if vopt17=1 then CheckBoxIgnoreDisp.State:=cbchecked else CheckBoxIgnoreDisp.State:=cbunchecked; on_CheckBoxIgnoreDisp_click;
if vopt25=1 then CheckBoxIntDir.State:=cbchecked else CheckBoxIntDir.State:=cbunchecked; on_CheckBoxIntDir_click;
if vopt18=1 then CheckBoxIgnoreSel.State:=cbchecked else CheckBoxIgnoreSel.State:=cbunchecked; on_CheckBoxIgnoreSel_click;
if vopt18b=1 then CheckBoxExtAnd.State:=cbchecked else CheckBoxExtAnd.State:=cbunchecked; on_CheckBoxExtAnd_click;
if vopt19=1 then CheckBoxIgnorePaths.State:=cbchecked else CheckBoxIgnorePaths.State:=cbunchecked; on_CheckBox4_click;
if vopt19b=1 then cbautoclosesingleextract.State:=cbchecked else cbautoclosesingleextract.State:=cbunchecked; on_cbautoclosesingleextract_click;
cbExtEvForWhen.ItemIndex:=vopt19c; on_cbExtEvForWhenChange;
ComboBoxsec.ItemIndex:=vopt19csec; on_ComboBoxsecChange;
cbExtEvForHow.ItemIndex:=vopt19d; on_cbExtEvForHowChange;
editExtEvForWhat.Caption:=vopt19e;
editExtEvForSec.Caption:=vopt19esec;
Editcommonalgo.Caption:=vopt19f;
cbHashFormat.ItemIndex:=vopt20; on_RadioGroup1Click;
cbBrowserHash.ItemIndex:=vopt20b; on_RadioGroup2Click;
cbHash.ItemIndex:=vopt21; on_cbcheckallClick;
Comboboxpasses.ItemIndex:=vopt22; on_ComboBoxPassesChange;
ComboboxKiB.ItemIndex:=vopt22b; on_ComboBoxKiBChange;
updateconf_modified;
activelabel_options:=LabelTitleOptions1;
clicklabel_options(LabelTitleoptions1,ShapeOptions1);
end;
end;

procedure on_checkboxseparateclick;
var
   s:ansistring;
begin
if FormPeach.CheckBoxSeparate.State=cbChecked then
   begin
   FormPeach.EditAddFilename.Enabled:=false;
   FormPeach.EditAddName.ReadOnly:=true;
   end
else
   begin
   FormPeach.EditAddFilename.Enabled:=true;
   FormPeach.EditAddName.ReadOnly:=false;
   suggest_outname(s,FormPeach.cbType.Text,FormPeach.StringGridAdd.Row);
   FormPeach.EditAddFilename.Text:=extractfilename(s);
   FormPeach.EditAddName.Text:=FormPeach.EditAddFilepath.Text+addext(FormPeach.EditAddFilename.Text);
   end;
end;

procedure checkmsched;
begin
with FormPeach do
begin
if (CheckGroupM1.Checked[0]=false) and
   (CheckGroupM1.Checked[1]=false) and
   (CheckGroupM1.Checked[2]=false) and
   (CheckGroupM1.Checked[3]=false) and
   (CheckGroupM1.Checked[4]=false) and
   (CheckGroupM1.Checked[5]=false) and
   (CheckGroupM1.Checked[6]=false) and
   (CheckGroupM1.Checked[7]=false) and
   (CheckGroupM1.Checked[8]=false) and
   (CheckGroupM1.Checked[9]=false) and
   (CheckGroupM1.Checked[10]=false) and
   (CheckGroupM1.Checked[11]=false)
   then Bschedule.Enabled:=false
else Bschedule.Enabled:=true;
end;
end;

procedure checkmschedext;
begin
with FormPeach do
begin
if (CheckGroupMExt.Checked[0]=false) and
   (CheckGroupMExt.Checked[1]=false) and
   (CheckGroupMExt.Checked[2]=false) and
   (CheckGroupMExt.Checked[3]=false) and
   (CheckGroupMExt.Checked[4]=false) and
   (CheckGroupMExt.Checked[5]=false) and
   (CheckGroupMExt.Checked[6]=false) and
   (CheckGroupMExt.Checked[7]=false) and
   (CheckGroupMExt.Checked[8]=false) and
   (CheckGroupMExt.Checked[9]=false) and
   (CheckGroupMExt.Checked[10]=false) and
   (CheckGroupMExt.Checked[11]=false)
   then Bschedule.Enabled:=false
else Bschedule.Enabled:=true;
end;
end;

procedure checkwsched;
begin
with FormPeach do
begin
if (CheckGroupW.Checked[0]=false) and
   (CheckGroupW.Checked[1]=false) and
   (CheckGroupW.Checked[2]=false) and
   (CheckGroupW.Checked[3]=false) and
   (CheckGroupW.Checked[4]=false) and
   (CheckGroupW.Checked[5]=false) and
   (CheckGroupW.Checked[6]=false)
   then Bschedule.Enabled:=false
else Bschedule.Enabled:=true;
end;
end;

procedure checkwschedext;
begin
with FormPeach do
begin
if (CheckGroupWExt.Checked[0]=false) and
   (CheckGroupWExt.Checked[1]=false) and
   (CheckGroupWExt.Checked[2]=false) and
   (CheckGroupWExt.Checked[3]=false) and
   (CheckGroupWExt.Checked[4]=false) and
   (CheckGroupWExt.Checked[5]=false) and
   (CheckGroupWExt.Checked[6]=false)
   then BScheduleExt.Enabled:=false
else BScheduleExt.Enabled:=true;
end;
end;

procedure on_cbActChange;
begin
if fun='7Z' then
   if (FormPeach.CheckBox7zSFX.State=cbChecked) then
      getarccaption(txt_sfx+' '+STR_7Z)
   else
      getarccaption(STR_7Z);
if (fun='CUSTOM') and (userar=1) and (havewinrar=true) then getarccaption(txt_custom+'/RAR');
end;

procedure on_cbLevelChange;
begin
case fun of
   'ARC':
   begin
   FormPeach.ComboBoxARCLevel.ItemIndex:=FormPeach.cbLevel.ItemIndex;
   on_ComboBoxARCChange;
   end;
   '7Z':
   begin
   FormPeach.ComboBox7zLevel.ItemIndex:=FormPeach.cbLevel.ItemIndex;
   on_ComboBoxArchiveCompressionLevelChange;
   end;
   'BROTLI':
   begin
   level_brotli:=FormPeach.cbLevel.ItemIndex;
   getarccaption(FormPeach.cbType.Text);
   end;
   'ZSTD':
   begin
   level_zstd:=FormPeach.cbLevel.ItemIndex;
   getarccaption(FormPeach.cbType.Text);
   end;
end;
if (fun='CUSTOM') and (userar=1) and (havewinrar=true) then
   begin
   level_rar:=FormPeach.cbLevel.ItemIndex;
   getarccaption(txt_custom+'/RAR');
   end;
end;

procedure draw_breadmenuicon(i:integer; var menudir:TMenuItem);
var
   Node: TTreeNode;
   s:ansistring;
begin
menudir.Caption:=FormPeach.ShellTreeViewTmp.Items[i].Text;
menudir.visible:=true;
Node := FormPeach.ShellTreeViewTmp.Items[i];
s:=FormPeach.ShellTreeViewTmp.GetPathFromNode(Node);
menudir.Bitmap:=drawmenuicon(s);
end;

procedure prepare_breadcrumbdir(inroot:ansistring);
begin
inbcnode:=-1;
if inroot='' then FormPeach.EditOpenInInteractive.Text;
imod:=0;
try
FormPeach.ShellTreeViewTmp.Root:=inroot;
except
FormPeach.ShellTreeViewTmp.Root:='';
{$IFDEF MSWINDOWS}if (FormPeach.EditOpenInInteractive.Text=txt_mypc) or (inroot=txt_mypc) then imod:=-1;{$ENDIF}
end;
if imod=0 then
begin
if FormPeach.ShellTreeViewTmp.Items.Count>1 then draw_breadmenuicon(1+imod,FormPeach.pmbcd1)
else FormPeach.pmbcd1.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>2 then draw_breadmenuicon(2+imod,FormPeach.pmbcd2)
else FormPeach.pmbcd2.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>3 then draw_breadmenuicon(3+imod,FormPeach.pmbcd3)
else FormPeach.pmbcd3.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>4 then draw_breadmenuicon(4+imod,FormPeach.pmbcd4)
else FormPeach.pmbcd4.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>5 then draw_breadmenuicon(5+imod,FormPeach.pmbcd5)
else FormPeach.pmbcd5.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>6 then draw_breadmenuicon(6+imod,FormPeach.pmbcd6)
else FormPeach.pmbcd6.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>7 then draw_breadmenuicon(7+imod,FormPeach.pmbcd7)
else FormPeach.pmbcd7.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>8 then draw_breadmenuicon(8+imod,FormPeach.pmbcd8)
else FormPeach.pmbcd8.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>9 then draw_breadmenuicon(9+imod,FormPeach.pmbcd9)
else FormPeach.pmbcd9.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>10 then draw_breadmenuicon(10+imod,FormPeach.pmbcd10)
else FormPeach.pmbcd10.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>11 then draw_breadmenuicon(11+imod,FormPeach.pmbcd11)
else FormPeach.pmbcd11.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>12 then draw_breadmenuicon(12+imod,FormPeach.pmbcd12)
else FormPeach.pmbcd12.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>13 then draw_breadmenuicon(13+imod,FormPeach.pmbcd13)
else FormPeach.pmbcd13.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>14 then draw_breadmenuicon(14+imod,FormPeach.pmbcd14)
else FormPeach.pmbcd14.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>15 then draw_breadmenuicon(15+imod,FormPeach.pmbcd15)
else FormPeach.pmbcd15.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>16 then draw_breadmenuicon(16+imod,FormPeach.pmbcd16)
else FormPeach.pmbcd16.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>17 then draw_breadmenuicon(17+imod,FormPeach.pmbcd17)
else FormPeach.pmbcd17.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>18 then draw_breadmenuicon(18+imod,FormPeach.pmbcd18)
else FormPeach.pmbcd18.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>19 then draw_breadmenuicon(19+imod,FormPeach.pmbcd19)
else FormPeach.pmbcd19.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>20 then FormPeach.pmbcd0.visible:=true
else FormPeach.pmbcd0.visible:=false;
if inroot<>DirectorySeparator then
   begin
   FormPeach.pmbcspacer.visible:=false;
   FormPeach.pmquickdesk.visible:=false;
   FormPeach.pmquickdownloads.visible:=false;
   FormPeach.pmquickhome.visible:=false;
   FormPeach.pmquickop.visible:=false;
   FormPeach.pmquickoa.visible:=false;
   FormPeach.pmquicksd.visible:=false;
   end
else
   begin
   FormPeach.pmbcspacer.visible:=true;
   FormPeach.pmquickdesk.visible:=true;
   FormPeach.pmquickdownloads.visible:=true;
   FormPeach.pmquickhome.visible:=true;
   FormPeach.pmquickop.visible:=true;
   FormPeach.pmquickoa.visible:=true;
   FormPeach.pmquicksd.visible:=true;
   end;
end
else //txt_mypc
begin
if FormPeach.pmjd1.visible=true then
   begin
   FormPeach.pmbcd1.bitmap:=FormPeach.pmjd1.bitmap;
   FormPeach.pmbcd1.caption:=FormPeach.pmjd1.caption
   end
else FormPeach.pmbcd1.visible:=false;
if FormPeach.pmjd2.visible=true then
   begin
   FormPeach.pmbcd2.bitmap:=FormPeach.pmjd2.bitmap;
   FormPeach.pmbcd2.caption:=FormPeach.pmjd2.caption
   end
else FormPeach.pmbcd2.visible:=false;
if FormPeach.pmjd3.visible=true then
   begin
   FormPeach.pmbcd3.bitmap:=FormPeach.pmjd3.bitmap;
   FormPeach.pmbcd3.caption:=FormPeach.pmjd3.caption
   end
else FormPeach.pmbcd3.visible:=false;
if FormPeach.pmjd4.visible=true then
   begin
   FormPeach.pmbcd4.bitmap:=FormPeach.pmjd4.bitmap;
   FormPeach.pmbcd4.caption:=FormPeach.pmjd4.caption
   end
else FormPeach.pmbcd4.visible:=false;
if FormPeach.pmjd5.visible=true then
   begin
   FormPeach.pmbcd5.bitmap:=FormPeach.pmjd5.bitmap;
   FormPeach.pmbcd5.caption:=FormPeach.pmjd5.caption
   end
else FormPeach.pmbcd5.visible:=false;
if FormPeach.pmjd6.visible=true then
   begin
   FormPeach.pmbcd6.bitmap:=FormPeach.pmjd6.bitmap;
   FormPeach.pmbcd6.caption:=FormPeach.pmjd6.caption
   end
else FormPeach.pmbcd6.visible:=false;
if FormPeach.pmjd7.visible=true then
   begin
   FormPeach.pmbcd7.bitmap:=FormPeach.pmjd7.bitmap;
   FormPeach.pmbcd7.caption:=FormPeach.pmjd7.caption
   end
else FormPeach.pmbcd7.visible:=false;
if FormPeach.pmjd8.visible=true then
   begin
   FormPeach.pmbcd8.bitmap:=FormPeach.pmjd8.bitmap;
   FormPeach.pmbcd8.caption:=FormPeach.pmjd8.caption
   end
else FormPeach.pmbcd8.visible:=false;
if FormPeach.pmjd9.visible=true then
   begin
   FormPeach.pmbcd9.bitmap:=FormPeach.pmjd9.bitmap;
   FormPeach.pmbcd9.caption:=FormPeach.pmjd9.caption
   end
else FormPeach.pmbcd9.visible:=false;
if FormPeach.pmjd10.visible=true then
   begin
   FormPeach.pmbcd10.bitmap:=FormPeach.pmjd10.bitmap;
   FormPeach.pmbcd10.caption:=FormPeach.pmjd10.caption
   end
else FormPeach.pmbcd10.visible:=false;
if FormPeach.pmjd11.visible=true then
   begin
   FormPeach.pmbcd11.bitmap:=FormPeach.pmjd11.bitmap;
   FormPeach.pmbcd11.caption:=FormPeach.pmjd11.caption
   end
else FormPeach.pmbcd11.visible:=false;
if FormPeach.pmjd12.visible=true then
   begin
   FormPeach.pmbcd12.bitmap:=FormPeach.pmjd12.bitmap;
   FormPeach.pmbcd12.caption:=FormPeach.pmjd12.caption
   end
else FormPeach.pmbcd12.visible:=false;
if FormPeach.pmjd13.visible=true then
   begin
   FormPeach.pmbcd13.bitmap:=FormPeach.pmjd13.bitmap;
   FormPeach.pmbcd13.caption:=FormPeach.pmjd13.caption
   end
else FormPeach.pmbcd13.visible:=false;
if FormPeach.pmjd14.visible=true then
   begin
   FormPeach.pmbcd14.bitmap:=FormPeach.pmjd14.bitmap;
   FormPeach.pmbcd14.caption:=FormPeach.pmjd14.caption
   end
else FormPeach.pmbcd14.visible:=false;
if FormPeach.pmjd15.visible=true then
   begin
   FormPeach.pmbcd15.bitmap:=FormPeach.pmjd15.bitmap;
   FormPeach.pmbcd15.caption:=FormPeach.pmjd15.caption
   end
else FormPeach.pmbcd15.visible:=false;
if FormPeach.pmjd16.visible=true then
   begin
   FormPeach.pmbcd16.bitmap:=FormPeach.pmjd16.bitmap;
   FormPeach.pmbcd16.caption:=FormPeach.pmjd16.caption
   end
else FormPeach.pmbcd16.visible:=false;
if FormPeach.pmjd17.visible=true then
   begin
   FormPeach.pmbcd17.bitmap:=FormPeach.pmjd17.bitmap;
   FormPeach.pmbcd17.caption:=FormPeach.pmjd17.caption
   end
else FormPeach.pmbcd17.visible:=false;
if FormPeach.pmjd18.visible=true then
   begin
   FormPeach.pmbcd18.bitmap:=FormPeach.pmjd18.bitmap;
   FormPeach.pmbcd18.caption:=FormPeach.pmjd18.caption
   end
else FormPeach.pmbcd18.visible:=false;
if FormPeach.pmjd19.visible=true then
   begin
   FormPeach.pmbcd19.bitmap:=FormPeach.pmjd19.bitmap;
   FormPeach.pmbcd19.caption:=FormPeach.pmjd19.caption
   end
else FormPeach.pmbcd19.visible:=false;
if FormPeach.ShellTreeViewTmp.Items.Count>20 then FormPeach.pmbcd0.visible:=true
else FormPeach.pmbcd0.visible:=false;
FormPeach.pmbcspacer.visible:=true;
FormPeach.pmquickdesk.visible:=true;
FormPeach.pmquickdownloads.visible:=true;
FormPeach.pmquickhome.visible:=true;
FormPeach.pmquickop.visible:=true;
FormPeach.pmquickoa.visible:=true;
FormPeach.pmquicksd.visible:=true;
end;
end;

procedure prepare_breadcrumbarchive(branode:integer);
var
   saddr,saddr2:ansistring;
   i:integer;
begin
inbcnode:=branode;
FormPeach.pmbcd1.visible:=false;
FormPeach.pmbcd2.visible:=false;
FormPeach.pmbcd3.visible:=false;
FormPeach.pmbcd4.visible:=false;
FormPeach.pmbcd5.visible:=false;
FormPeach.pmbcd6.visible:=false;
FormPeach.pmbcd7.visible:=false;
FormPeach.pmbcd8.visible:=false;
FormPeach.pmbcd9.visible:=false;
FormPeach.pmbcd10.visible:=false;
FormPeach.pmbcd11.visible:=false;
FormPeach.pmbcd12.visible:=false;
FormPeach.pmbcd13.visible:=false;
FormPeach.pmbcd14.visible:=false;
FormPeach.pmbcd15.visible:=false;
FormPeach.pmbcd16.visible:=false;
FormPeach.pmbcd17.visible:=false;
FormPeach.pmbcd18.visible:=false;
FormPeach.pmbcd19.visible:=false;
FormPeach.pmbcd0.visible:=false;

case branode of
0: saddr:='';
1: saddr:=abcrs[1];
2: saddr:=abcrs[2];
3: saddr:=abcrs[3];
end;

saddr2:=saddr+'*'+directoryseparator+'*';

for i:=1 to FormPeach.StringGridAddressAllFolders.RowCount-1 do
  begin
  if (pos(saddr,FormPeach.StringGridAddressAllFolders.Cells[12,i])=1) or (saddr='') then
     if not(MatchesMask(FormPeach.StringGridAddressAllFolders.Cells[12,i],saddr2,false)) then
        begin
        if FormPeach.pmbcd1.visible=false then
           begin
           FormPeach.pmbcd1.visible:=true;
           FormPeach.pmbcd1.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd1.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd2.visible=false then
           begin
           FormPeach.pmbcd2.visible:=true;
           FormPeach.pmbcd2.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd2.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd3.visible=false then
           begin
           FormPeach.pmbcd3.visible:=true;
           FormPeach.pmbcd3.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd3.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd4.visible=false then
           begin
           FormPeach.pmbcd4.visible:=true;
           FormPeach.pmbcd4.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd4.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd5.visible=false then
           begin
           FormPeach.pmbcd5.visible:=true;
           FormPeach.pmbcd5.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd5.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd6.visible=false then
           begin
           FormPeach.pmbcd6.visible:=true;
           FormPeach.pmbcd6.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd6.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd7.visible=false then
           begin
           FormPeach.pmbcd7.visible:=true;
           FormPeach.pmbcd7.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd7.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd8.visible=false then
           begin
           FormPeach.pmbcd8.visible:=true;
           FormPeach.pmbcd8.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd8.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd9.visible=false then
           begin
           FormPeach.pmbcd9.visible:=true;
           FormPeach.pmbcd9.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd9.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd10.visible=false then
           begin
           FormPeach.pmbcd10.visible:=true;
           FormPeach.pmbcd10.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd10.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd11.visible=false then
           begin
           FormPeach.pmbcd11.visible:=true;
           FormPeach.pmbcd11.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd11.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd12.visible=false then
           begin
           FormPeach.pmbcd12.visible:=true;
           FormPeach.pmbcd12.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd12.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd13.visible=false then
           begin
           FormPeach.pmbcd13.visible:=true;
           FormPeach.pmbcd13.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd13.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd14.visible=false then
           begin
           FormPeach.pmbcd14.visible:=true;
           FormPeach.pmbcd14.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd14.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd15.visible=false then
           begin
           FormPeach.pmbcd15.visible:=true;
           FormPeach.pmbcd15.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd15.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd16.visible=false then
           begin
           FormPeach.pmbcd16.visible:=true;
           FormPeach.pmbcd16.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd16.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd17.visible=false then
           begin
           FormPeach.pmbcd17.visible:=true;
           FormPeach.pmbcd17.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd17.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd18.visible=false then
           begin
           FormPeach.pmbcd18.visible:=true;
           FormPeach.pmbcd18.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd18.bitmap:=BFolder;
           end
        else
        if FormPeach.pmbcd19.visible=false then
           begin
           FormPeach.pmbcd19.visible:=true;
           FormPeach.pmbcd19.caption:=dirextractfilename(FormPeach.StringGridAddressAllFolders.Cells[12,i]);
           FormPeach.pmbcd19.bitmap:=BFolder;
           end
        else FormPeach.pmbcd0.visible:=true;
        end;
  end;
FormPeach.pmbcspacer.visible:=false;
FormPeach.pmquickdesk.visible:=false;
FormPeach.pmquickdownloads.visible:=false;
FormPeach.pmquickhome.visible:=false;
FormPeach.pmquickop.visible:=false;
FormPeach.pmquickoa.visible:=false;
FormPeach.pmquicksd.visible:=false;
end;

procedure exit_fromaddress(exitmode:integer);
begin
if usebreadcrumb=0 then exit;
FormPeach.PanelClickAddress.Visible:=true;
if FormPeach.ShapeListBar.Visible=false then FormPeach.ShapeListBar.Visible:=true;
FormPeach.EditOpenInInteractive.Enabled:=false;
if exitmode=1 then do_resetsearch;
end;

procedure reset_theme_btn;
begin
FormPeach.ComboBoxTheme.ItemIndex:=0;
ComboBoxTheme_onchange;
setwindowsopacity;
settabs;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI OTHER FORMS prepare secondary forms

///////////////////////////////////////////////////////////////////////////////}

procedure prepare_FormPW;
begin
FormPW.Caption:=txt_pw;
FormPW.LabelPWpass.Caption:=txt_pw;
FormPW.LabelPWconfirm.Caption:=txt_pw_confirm;
FormPW.LabelPWkeyfile.Caption:=txt_keyfile;
FormPW.LabelPWkeyfile.Hint:=txt_2_7_optional;
FormPW.EditPWkeyfile.Hint:=txt_keyfile+' '+txt_2_7_optional;
FormPW.ButtonPWkeyfile.Hint:=txt_keyfile+' '+txt_2_7_optional;
FormPW.OpenDialogKF.Title:=txt_keyfile;
FormPW.mpwmreset.Caption:=txt_reset+' ('+txt_pw+', '+txt_keyfile+')';
FormPW.mpwmreset.Bitmap:=Bdelete;
FormPW.mpwreset.Caption:=txt_reset+' ('+txt_keyfile+')';
FormPW.mpwexplore.Caption:=txt_explore_path;
FormPW.CheckBoxEncFn.Caption:=txt_2_7_encfn;
FormPW.CheckBoxIntPw.Caption:=txt_8_0_forcetyping;
FormPW.CheckBoxIntPw.Hint:=txt_8_0_forcetypinghelp;
FormPW.CheckBoxShowPWField.Caption:=txt_showpw;
FormPW.CheckBoxKeepPW.Caption:=txt_4_3_keeppw;
FormPW.mpwman.Caption:=txt_4_3_pwman;
FormPW.ButtonEditNamePw.Glyph:=bmenu;
FormPW.ButtonPanelPW.OKButton.Caption:=txt_2_7_ok;
FormPW.ButtonPanelPW.CancelButton.Caption:=txt_2_7_cancel;
if keeppw=1 then FormPW.CheckBoxKeepPW.State:=cbChecked else FormPW.CheckBoxKeepPW.State:=cbUnchecked;
UnitPW.validate_txt:=txt_2_7_validatecl;
UnitPW.txt_pw:=txt_pw;
setpwicons;
end;

procedure prepare_FormAbout;
begin
FormPeach.baboutup.Caption:=txt_4_5_update;
FormPeach.baboutup.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutup,16,true);
FormPeach.baboutup.Height:=barheight;
FormPeach.baboutplugins.Caption:=txt_5_5_plugin;
FormPeach.baboutplugins.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutplugins,16,true);
FormPeach.baboutplugins.Height:=barheight;
FormPeach.baboutthemes.Caption:=txt_3_5_td;
FormPeach.baboutthemes.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutthemes,16,true);
FormPeach.baboutthemes.Height:=barheight;
FormPeach.babouttranslations.Caption:=txt_9_2_tfaq;
FormPeach.babouttranslations.Glyph:=Bweb;
psetbuttonwidth(FormPeach.babouttranslations,16,true);
FormPeach.babouttranslations.Height:=barheight;
FormPeach.baboutweb.Caption:=txt_peazip_web;
FormPeach.baboutweb.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutweb,16,true);
FormPeach.baboutweb.Height:=barheight;
FormPeach.baboutchangelog.Caption:=txt_9_2_changelog;
FormPeach.baboutchangelog.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutchangelog,16,true);
FormPeach.baboutchangelog.Height:=barheight;
FormPeach.babouttos.Caption:=txt_9_2_tos;
FormPeach.babouttos.Glyph:=Bweb;
psetbuttonwidth(FormPeach.babouttos,16,true);
FormPeach.babouttos.Height:=barheight;
FormPeach.baboutsupport.Caption:=txt_peazip_help;
FormPeach.baboutfaq.Caption:='FAQ';
FormPeach.babouttracker.Caption:=txt_3_7_tracker;
FormPeach.baboutlocalhelp.Caption:=txt_2_5_offline_help+' (EN, .pdf)';
FormPeach.baboutsupport.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutsupport,16,true);
FormPeach.baboutsupport.Height:=barheight;
FormPeach.baboutfaq.Glyph:=Bweb;
psetbuttonwidth(FormPeach.baboutfaq,16,true);
FormPeach.baboutfaq.Height:=barheight;
FormPeach.babouttracker.Glyph:=Bweb;
psetbuttonwidth(FormPeach.babouttracker,16,true);
FormPeach.babouttracker.Height:=barheight;
FormPeach.baboutlocalhelp.Glyph:=Bpdf;
psetbuttonwidth(FormPeach.baboutlocalhelp,16,true);
FormPeach.baboutlocalhelp.Height:=barheight;
FormPeach.baboutplugindir.Glyph:=BFolder;
FormPeach.baboutplugindir.Caption:=txt_9_0_plugind;
psetbuttonwidth(FormPeach.baboutplugindir,16,true);
FormPeach.baboutplugindir.Height:=barheight;
FormPeach.baboutbin.Glyph:=BExesupported;
FormPeach.baboutbin.Caption:=txt_8_7_verifybin;
psetbuttonwidth(FormPeach.baboutbin,16,true);
FormPeach.baboutbin.Height:=barheight;
FormPeach.baboutremoveunace.Glyph:=Bdelete;
FormPeach.baboutremoveunace.Caption:=txt_2_5_remove+' UNACE Plugin';
psetbuttonwidth(FormPeach.baboutremoveunace,16,true);
FormPeach.baboutremoveunace.Height:=barheight;
FormPeach.baboutremoveunrar.Glyph:=Bdelete;
FormPeach.baboutremoveunrar.Caption:=txt_2_5_remove+' UNRAR Plugin';
psetbuttonwidth(FormPeach.baboutremoveunrar,16,true);
FormPeach.baboutremoveunrar.Height:=barheight;
end;

procedure prepare_FormSelect;
begin
FormSelect.Caption:=txt_5_5_select+'...';
FormSelect.Labelselectall.Caption:=txt_selectall;
FormSelect.Labelselectinvert.Caption:=txt_invertsel;
FormSelect.Labelselectsort.Caption:=txt_sortbysel;
FormSelect.ButtonPanelSelect.OKButton.Caption:=txt_2_7_ok;
FormSelect.ButtonPanelSelect.CancelButton.Caption:=txt_2_7_cancel;
FormSelect.ComboBoxSelect1.Clear;
FormSelect.ComboBoxSelect1.Items.Add(txt_all_type);
FormSelect.ComboBoxSelect1.Items.Add(txt_5_5_starting);
FormSelect.ComboBoxSelect1.Items.Add(txt_5_5_starting+' '+txt_5_5_case);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_attributes);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_dateyear);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datemonth);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_dateweek);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_dateday);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datehour);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datesameyear);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datesamemonth);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datesameweek);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datesameday);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_5_5_datesamehour);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_morerecent);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_eqorrecent);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_equal);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_eqorolder);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_date+' | '+txt_olderthan);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | 0 B');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | < 100 KB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | 100 KB .. 10 MB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | 10 MB .. 100 MB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | > 100 MB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_5_5_similar+' (10%)');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_5_5_similar+' (50%)');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_smaller);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_eqorsmaller);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_equal);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_eqorlarger);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_size+' | '+txt_larger);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | 0 B');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | < 100 KB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | 100 KB .. 10 MB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | 10 MB .. 100 MB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | > 100 MB');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_5_5_similar+' (10%)');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_5_5_similar+' (50%)');
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_smaller);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_eqorsmaller);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_equal);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_eqorlarger);
FormSelect.ComboBoxSelect1.Items.Add(txt_all_psize+' | '+txt_larger);
FormSelect.ComboBoxSelect1.ItemIndex:=0;
FormSelect.ComboBoxSelect2.Clear;
FormSelect.ComboBoxSelect2.Items.Add(txt_5_5_select);
FormSelect.ComboBoxSelect2.Items.Add(txt_5_5_addsel);
FormSelect.ComboBoxSelect2.Items.Add(txt_5_5_subtractsel);
FormSelect.ComboBoxSelect2.ItemIndex:=0;
end;

procedure prepare_Form_gwrap;
begin
UnitGwrap.executable_path:=executable_path;
UnitGwrap.confpath:=confpath;
UnitGwrap.binpath:=binpath;
UnitGwrap.sharepath:=sharepath;
UnitGwrap.lang_file:=lang_file;
UnitGwrap.autoopen:=autoopen;
UnitGwrap.graphicsfolder:=graphicsfolder;
UnitGwrap.color1:=color1;
UnitGwrap.color2:=color2;
UnitGwrap.color3:=color3;
UnitGwrap.color4:=color4;
UnitGwrap.color5:=color5;
UnitGwrap.temperature:=temperature;
UnitGwrap.contrast:=contrast;
UnitGwrap.filesizebase:=filesizebase;
UnitGwrap.pbackground:=txt_2_5_tray;
UnitGwrap.pfromnativedrag:=false;
UnitGwrap.Bp1:=TBitmap.Create;
UnitGwrap.Bp1.Assign(Bp1);
UnitGwrap.Bsuccess:=TBitmap.Create;
UnitGwrap.Bsuccess.Assign(Btestall);
UnitGwrap.Binfo:=TBitmap.Create;
UnitGwrap.Binfo.Assign(Binfo);
UnitGwrap.Berror:=TBitmap.Create;
UnitGwrap.Berror.Assign(Bstop);
FormGwrap.ButtonOptions.Glyph:=Bmenu;
FormGwrap.MenuItemRecycle.Bitmap:=Bclearlayout;
FormGwrap.MenuItemQuickdelete.Bitmap:=Bdelete;
FormGwrap.MenuItemZerodelete.Bitmap:=Bwipe;
FormGwrap.MenuItemSecuredelete.Bitmap:=Bstop;
FormGwrap.left:=ws_gw_left;
FormGwrap.top:=ws_gw_top;
FormGwrap.height:=ws_gw_height;
FormGwrap.width:=ws_gw_width;
UnitGwrap.ws_gw_left:=ws_gw_left;
UnitGwrap.ws_gw_top:=ws_gw_top;
UnitGwrap.ws_gw_height:=ws_gw_height;
UnitGwrap.ws_gw_width:=ws_gw_width;
FormGwrap.PanelTitle.Height:=tabheight;
FormGwrap.ShapeTitleb1.Height:=tablabelheight;
FormGwrap.ShapeTitleb2.Height:=tablabelheight;
FormGwrap.ShapeTitleb3.Height:=tablabelheight;
FormGwrap.ShapeTitleb4.Height:=tablabelheight;
FormGwrap.PanelAlignBottom.Height:=tabheightl;
FormGwrap.StringGridReport.DefaultRowHeight:=rowsize;
UnitGwrap.pbarh:=pbarh;
UnitGwrap.pbarhsmall:=pbarhsmall;
UnitGwrap.txt_7_4_recover:=txt_7_4_recover;
UnitGwrap.txt_rr:=txt_rr;
UnitGwrap.txt_7_8_dd:=txt_7_8_dd;
UnitGwrap.txt_8_2_keep:=txt_8_2_keep;
UnitGwrap.txt_10_7_keep:=txt_10_7_keep;
UnitGwrap.txt_delete:=txt_delete;
UnitGwrap.txt_2_5_delete:=txt_2_5_delete;
UnitGwrap.txt_10_4_moving:=txt_10_4_moving;
{$IFDEF MSWINDOWS}FormGwrap.MenuItemRecycle.Visible:=true;{$ENDIF}
{$IFDEF DARWIN}FormGwrap.MenuItemRecycle.Visible:=true;{$ENDIF}
FormGwrap.MenuItemRecycle.Caption:=txt_4_7_recycle;
FormGwrap.MenuItemQuickdelete.Caption:=txt_quickdelete;
FormGwrap.MenuItemZerodelete.Caption:=txt_5_2_zerofiles;
FormGwrap.MenuItemSecuredelete.Caption:=txt_securedelete;
FormGwrap.pmwintm.Caption:=txt_taskman;
FormGwrap.pmwintm.Visible:=false;
FormGwrap.pmmactm.Visible:=false;
FormGwrap.pmgnometm.Visible:=false;
FormGwrap.pmkdetm.Visible:=false;
FormGwrap.pmtop.Visible:=false;
{$IFDEF MSWINDOWS}
FormGwrap.pmwintm.Visible:=true;
{$ELSE}
{$IFDEF DARWIN}
FormGwrap.pmmactm.Visible:=true;
{$ELSE}
FormGwrap.pmgnometm.Visible:=true;
FormGwrap.pmkdetm.Visible:=true;
{$ENDIF}
FormGwrap.pmtop.Visible:=true;
{$ENDIF}
end;

procedure prepare_FormDlg;
begin
UnitDlg.txt_info:=txt_info;
UnitDlg.txt_6_5_warning:=txt_6_5_warning;
UnitDlg.txt_6_5_error:=txt_6_5_error;
UnitDlg.txt_2_7_ok:=txt_2_7_ok;
UnitDlg.txt_6_5_yesall:=txt_6_5_yesall;
UnitDlg.txt_6_5_yes:=txt_6_5_yes;
UnitDlg.txt_no:=txt_no;
UnitDlg.txt_2_7_cancel:=txt_2_7_cancel;
UnitDlg.txt_6_5_abort:=txt_6_5_abort;
UnitDlg.txt_clear:=txt_clear;
UnitDlg.txt_7_2_updateclear:=txt_7_2_updateclear;
UnitDlg.txt_8_6_noclear:=txt_8_6_noclear;
UnitDlg.txt_8_6_nosimple:=txt_8_6_nosimple;
UnitDlg.txt_8_6_yessimple:=txt_8_6_yessimple;
UnitDlg.txt_7_8_update:=txt_7_8_update;
FormDlg.Imagedlg.Height:=i32res;
FormDlg.Imagedlg.Width:=i32res;
UnitDlg.binfodlg:=TBitmap.Create;
UnitDlg.binfodlg.Assign(binfodlg);
UnitDlg.bwarningdlg:=TBitmap.Create;
UnitDlg.bwarningdlg.Assign(bwarningdlg);
UnitDlg.berrordlg:=TBitmap.Create;
UnitDlg.berrordlg.Assign(berrordlg);
end;

procedure prepare_FormPM;
begin
FormPM.Caption:=txt_4_3_pwman;
UnitPM.txt_edit:=txt_edit;
UnitPM.validate_txt:=txt_2_7_validatecl;
UnitPM.local_desktop:=local_desktop;
UnitPM.confpath:=confpath;
UnitPM.txt_clear:=txt_4_3_pwman+' / '+txt_clear+'?';
FormPM.mnew.Caption:=txt_add;
FormPM.mpw.Caption:=txt_pw;
FormPM.mnote.Caption:=txt_description;
FormPM.mremove.Caption:=txt_2_5_remove;
FormPM.mreset.Caption:=txt_clear;
FormPM.StringGridPM.Cells[1,0]:=txt_pw;
FormPM.StringGridPM.Cells[2,0]:=txt_description;
FormPM.StringGridPM.AutoSizeColumns;
FormPM.StringGridPM.ColWidths[0]:=rowsize;
FormPM.StringGridPM.ColWidths[3]:=0;
FormPM.lablelistPath1.Caption:=txt_pw;
FormPM.lablelistPath3.Caption:=txt_pw_confirm;
FormPM.lablelistPath2.Caption:=txt_keyfile;
FormPM.mpwreset.Caption:=txt_reset;
FormPM.mpwexplore.Caption:=txt_explore_path;
FormPM.buttonpanelPM.OKButton.Caption:=txt_2_7_ok;
FormPM.buttonpanelPM.CancelButton.Caption:=txt_2_7_cancel;
FormPM.LabelPMadd.Caption:=txt_add;
FormPM.LabelPMremove.Caption:=txt_2_5_remove;
FormPM.ImageInfoPM1.Picture.Bitmap:=Binfo;
FormPM.LablePMHint.Caption:=txt_4_3_pwmanpwhint;
FormPM.LabelTitlePM1.Caption:='      '+txt_4_3_pwmanlist+'      ';
FormPM.LabelTitlePM2.Caption:='      '+txt_4_3_pwmanmaster+'      ';
FormPM.ImageInfoPM1.Hint:=txt_4_3_pwmanhint;
FormPM.pmexp.Caption:=txt_4_3_exppl;
FormPM.pmexpenc.Caption:=txt_4_3_expple;
FormPM.pmexpplain.Caption:=txt_4_3_expplp;
FormPM.ctrlpm.Glyph:=bsettings;
loadpm;
end;

procedure prepare_FormComment;
begin
FormComment.Caption:=txt_7_4_comment;
FormComment.MemoComment.Hint:=txt_9_4_hintcomment;
FormComment.LabelResetComment.Caption:=txt_reset;
FormComment.LabelLoadfromfile.Caption:=txt_loadfile;
FormComment.ButtonSaveComment.Caption:=txt_9_4_savecomment;
FormComment.OpenDialogFC.Title:=txt_open_file;
FormComment.SaveDialogFC.Title:=txt_saveas;
UnitComment.pdesk:=local_desktop;
end;

procedure prepare_FormKF;
begin
with FormKF do
begin
FormKF.Caption:=txt_4_7_pk;
ImageInfoKF.Hint:=txt_ent_hint;
GroupBoxKF.Caption:=txt_ent_tools;
EditEnt.Text:=txt_random_keys;
EditEnt.Hint:=txt_random_keys_hint;
ProgressBarKF.Hint:=txt_ent;
EditSuggestPW.Hint:=txt_ramdompw_hint;
SpinEditSuggestPW.Hint:=txt_pwlength;
ButtonKFLoadFile.Caption:=txt_loadfile;
ButtonKF.Caption:=txt_create_keyfile;
ButtonPWfromhash.Caption:=txt_10_7_pwh;
ButtonSuggestPW.Caption:=txt_suggestpw;
ImageInfoKF.Picture.Bitmap:=Binfo;
ImageInfoKF.Transparent:=true;
ButtonPanelKF.Closebutton.Caption:=txt_3_6_close;
SaveDialogKF.Title:=txt_saveas;
OpenDialogKF.Title:=txt_open_file;
CheckBoxSuggestPW.Caption:=txt_4_7_spchar;
end;
UnitKF.persistent_source:=persistent_source;
UnitKF.txt_keyfile_notcreated:=txt_keyfile_notcreated;
UnitKF.txt_error_openfile:=txt_error_openfile;
end;

procedure prepare_FormAdvf;
begin
FormAdvf.Caption:=txt_adv_filters;
FormAdvf.CheckboxAdvFilters.Caption:=txt_advfilters;
FormAdvf.CheckBoxAdvRecurse.Caption:=txt_5_3_rec;
FormAdvf.CheckBoxAdvRecurseAlso.Caption:=txt_5_3_rec;
FormAdvf.CheckBoxAdvRecurse1.Caption:=txt_5_3_rec;
FormAdvf.LabelAdvInclude.Caption:=txt_5_3_io;
FormAdvf.LabelAdvIncludeAlso.Caption:=txt_5_3_ia+' - '+txt_4_2_arcabspath;
FormAdvf.MemoAdvIncludeAlso.Hint:=txt_4_2_arcabspath;
FormAdvf.LabelAdvExclude.Caption:=txt_exclusion;
FormAdvf.ButtonClearFilters.Caption:=txt_clear;
FormAdvf.ImageInfoAdvf.Hint:=txt_2_9_adv+char($0D)+char($0A)+txt_5_3_exc;
FormAdvf.ImageInfoAdvf.Picture.Bitmap:=Binfo;
FormAdvf.ImageInfoAdvf.Transparent:=true;
FormAdvf.ButtonPanelAdvf.OKButton.Caption:=txt_2_7_ok;
FormAdvf.ButtonPanelAdvf.CancelButton.Caption:=txt_2_7_cancel;
end;

procedure prepare_FormWeb;
begin
FormWeb.Caption:=txt_search_web;
FormWeb.CheckBoxMultiWeb.Caption:=txt_3_3_multi;
FormWeb.CheckGroupWeb.Caption:=txt_searchfor;
FormWeb.ButtonPanelWeb.OKButton.Caption:=txt_2_7_ok;
FormWeb.ButtonPanelWeb.CancelButton.Caption:=txt_2_7_cancel;
FormWeb.CheckGroupWeb.Checked[6]:=true;
end;

procedure prepare_FormImgViewer;
begin
UnitImgViewer.filesizebase:=filesizebase;
UnitImgViewer.desk_env:=desk_env;
{$IFDEF MSWINDOWS}FormImgViewer.mproperties.Visible:=true;{$ENDIF}
FormImgViewer.mfwd.Caption:=txt_10_7_next+' ->';
FormImgViewer.mback.Caption:=txt_10_7_prev+' <-';
FormImgViewer.mfirst.Caption:=txt_10_7_first;
FormImgViewer.mlast.Caption:=txt_5_1_last;
FormImgViewer.mexplorepath.Caption:=txt_explore_path;
FormImgViewer.mproperties.Caption:=txt_4_5_properties;
FormImgViewer.mrefresh.Caption:=txt_fefreshf5;
FormImgViewer.mupdate.Caption:=txt_7_8_update;
FormImgViewer.mzoom.Caption:=txt_7_9_zooming;
FormImgViewer.mzoomin.Caption:=txt_7_9_zooming+' +';
FormImgViewer.mzoomout.Caption:=txt_7_9_zooming+' -';
FormImgViewer.mzoomfit.Caption:=txt_10_7_fit;
FormImgViewer.mzoomfith.Caption:=txt_10_7_fith;
FormImgViewer.mzoomfitw.Caption:=txt_10_7_fitw;
UnitImgViewer.txt_10_7_errload:=txt_10_7_errload;
UnitImgViewer.txt_10_7_errfile:=txt_10_7_errfile;
UnitImgViewer.executable_path:=executable_path;
UnitImgViewer.erasepasses:=erasepasses;
UnitImgViewer.txt_2_7_validatecl:=txt_2_7_validatecl;
UnitImgViewer.txt_delete:=txt_delete;
UnitImgViewer.txt_wipe:=txt_wipe;
UnitImgViewer.txt_5_2_zerodelete:=txt_5_2_zerodelete;
UnitImgViewer.txt_4_7_recycle:=txt_4_7_recycle;
FormImgViewer.mdelete.Caption:=txt_2_5_delete;
FormImgViewer.mtrash.Caption:=txt_4_7_recycle;
FormImgViewer.mquickdelete.Caption:=txt_quickdelete;
FormImgViewer.mzerodelete.Caption:=txt_5_2_zerofiles;
FormImgViewer.msecuredelete.Caption:=txt_securedelete;
FormImgViewer.mrename.Caption:=txt_rename+' (Ctrl+R)';
UnitImgViewer.txt_rename:=txt_rename;
UnitImgViewer.txt_reset:=txt_reset;
UnitImgViewer.txt_5_5_lower:=txt_5_5_lower;
UnitImgViewer.txt_5_5_upper:=txt_5_5_upper;
UnitImgViewer.txt_timestamp:=txt_timestamp;
UnitImgViewer.txt_6_4_appdirn:=txt_6_4_appdirn;
UnitImgViewer.txt_6_4_prepdirn:=txt_6_4_prepdirn;
UnitImgViewer.txt_name_provide:=txt_name_provide;
UnitImgViewer.txt_checkname_failed:=txt_checkname_failed;
{$IFNDEF MSWINDOWS}
{$IFNDEF DARWIN}
FormImgViewer.mtrash.Visible:=false;
{$ENDIF}
{$ENDIF}
end;

{///////////////////////////////////////////////////////////////////////////////

subsection GUI PANELS set main form screens

///////////////////////////////////////////////////////////////////////////////}

procedure setpanel_add(ipanel:integer);
var
   cl,jobcode,outname:ansistring;
begin
with FormPeach do
begin
consolecl:=false;
OptionsAdd.Visible:=false;
OptionsAddAdv.Visible:=false;
ConsoleAdd.Visible:=false;
scheduleadd.Visible:=false;
cbtarpipe.enabled:=false;
case ipanel of
   1: OptionsAdd.Visible:=true;
   2: OptionsAddAdv.Visible:=true;
   3: ConsoleAdd.Visible:=true;
   4: scheduleadd.Visible:=true;
   end;
if ipanel<>3 then
   if imported_tarbeforejob=true then restorelistTB;
imported_tarbeforejob:=false;
if (ipanel = 3) or (ipanel = 4) then
   begin
   consolecl:=true;
   SpeedButtonAdd.Enabled:=false;
   ButtonArchiveOK.Enabled:=false;
   if ipanel = 3 then cbtarpipe.enabled:=true;
   if ipanel = 3 then importjobcl(cl,jobcode,outname);
   if ipanel = 4 then getscheduledtaskname(0);
   end
else
   begin
   {if CheckBoxConvert.checked=true then
      SpeedButtonAdd.Enabled:=false
   else}
      SpeedButtonAdd.Enabled:=true;
   ButtonArchiveOK.Enabled:=true;
   {$IFDEF MSWINDOWS}
   if FormPeach.Visible=true then
      if prevpanel='archive' then
         try ButtonArchiveOK.Setfocus; except end;
   {$ENDIF}
   end;
end;
end;

procedure setpanel_extract(ipanel:integer);
var
cl,jobcode,outname:ansistring;
begin
with FormPeach do
begin
consolecl:=false;
OptionsExtract.Visible:=false;
OptionsExtractAdv.Visible:=false;
ConsoleExtract.Visible:=false;
scheduleextract.Visible:=false;
cbuntarpipe.enabled:=false;
case ipanel of
   1: OptionsExtract.Visible:=true;
   2: OptionsExtractAdv.Visible:=true;
   3: ConsoleExtract.Visible:=true;
   4: scheduleextract.Visible:=true;
   end;
if (ipanel = 3) or (ipanel = 4) then
   begin
   consolecl:=true;
   ButtonExtOk.Enabled:=false;
   if ipanel = 3 then cbuntarpipe.enabled:=true;
   if ipanel = 3 then importjobcl_extract(cl,jobcode,outname);
   if ipanel = 4 then getscheduledtaskname(1);
   end
else
   begin
   ButtonExtOk.Enabled:=true;
   {$IFDEF MSWINDOWS}
   if FormPeach.Visible=true then
      if prevpanel='extract' then
         try ButtonExtOk.Setfocus; except end;
   {$ENDIF}
   end;
end;
end;

procedure showpanel(panelname:ansistring); //make all panels invisible (showpanel_prepare) then make visible the called panel
var
   s:ansistring;
begin
{$IFDEF MSWINDOWS}if FormPeach.PanelOptions.visible=true then{$ELSE}if FormPeach.PanelOptions.top=0 then{$ENDIF}
   begin
   save_conf;
   prepare_FormPW;
   prepare_FormKF;
   prepare_FormAdvf;
   end;//save configuration exiting from paneldefaults
showpanel_prepare;
with FormPeach do
begin
case panelname of
   'archive' :
   begin
   prevpanel:='archive';
   updateid:='';
   prevupdateid:='';
   titlestring:='';
   mConsoleCreate.Text:='';
   marcopt.enabled:=false;
   setrecenticons_extract_archive;
   if CheckBoxConvert.checked=true then LabelTitleAdd1.Caption:='      '+txt_2_8_convert+'      ' else LabelTitleAdd1.Caption:='      '+txt_archive+'      ';
   CheckBoxConvertPW.visible:=FormPeach.CheckBoxConvert.Checked;
   CheckBoxConvertVerbose.visible:=FormPeach.CheckBoxConvert.Checked;
   PanelArchive.Top:=0;
   PanelArchive.Visible:=true;
   if (alttabstyle<>1) and (alttabstyle<>4) then clicklabel_add(LabelTitleAdd1,ShapeTitleAddb1) else clicklabel_add(LabelTitleAdd1,Shapelinkadd1);
   if showmenu=true then
      begin
      //mLayout.Visible:=true;
      mLayout.Enabled:=true;
      end;
   mtogglenew.visible:=false;
   mgotype.visible:=true;
   MenuItem110.visible:=true;
   mgotypegz.visible:=true;
   mgotype7zsfx.visible:=true;
   mgotypetar.visible:=true;
   mgotypezip.visible:=true;
   mgotypebz2.visible:=true;
   mgotype7z.visible:=true;
   MenuItem121.visible:=true;
   msavecompsettings.visible:=true;
   mloadcompsettings.visible:=true;
   mextractarchive.Caption:=txt_archive;
   if archive_type_selected=-1 then
      if df<18 then archive_type_select(FormPeach.cbType.Items[df])
      else archive_type_select(FormPeach.cbType.Items[pf])
   else archive_type_select(FormPeach.cbType.Items[archive_type_selected]);
   status1:=inttostr(tdirs)+' '+txt_dirs+' '+inttostr(tfiles)+' '+txt_files+' '+nicenumber(inttostr(tsize),filesizebase);
   LabelStatusArDetails.Caption:=status1;
   FormPeach.LabelStatusAddUpdate.Caption:='';
   setpanel_add(1);
   ButtonOutAdd.Enabled:=true;
   EditAddName.enabled:=true;
   EditAddSame.Visible:=false;
   ButtonEditNameAdd.Enabled:=true;
   setupdatecontrols(true);
   {if CheckBoxConvert.checked=true then
      SpeedButtonAdd.Enabled:=false
   else}
      SpeedButtonAdd.Enabled:=true;
   pmbrowser.Enabled:=true;
   mgobrowser.Enabled:=true;
   needwaitupdating:=false;
   updatingarchive_inarchive:=false;
   ares:=-1;
   if skipapstatus=false then savestatus_archiver;
   if FormPeach.Visible=true then
      if FormPeach.ButtonArchiveOK.enabled=true then
         begin
         {$IFDEF MSWINDOWS}
         if FormPeach.Visible=true then
            try FormPeach.ButtonArchiveOK.Setfocus; except end;
         {$ENDIF}
         end;
   FormPeach.PanelProgressAdd.Color:=stringtocolor(color2);
   FormPeach.PanelProgressAdd.Height:=0;
   FormPeach.PanelProgressAdd.Width:=0;
   MenuItemEnumerate.visible:=true;
   setextpopupmenu('1');
   mdefaultarchive.visible:=true;
   mdefaultextract.visible:=false;
   FormPeach.PanelTitleAddTabAlign.Width:=FormPeach.LabelTitleAdd1.Width+
   FormPeach.LabelTitleAdd2.Width+
   FormPeach.LabelTitleAdd3.Width+
   FormPeach.LabelTitleAdd4.Width+
   FormPeach.LabelTitleAdd1.BorderSpacing.Left*5;
   end;
   'open' :
   begin
   prevpanel:='open';
   goarchiving:=false;
   if titlestring<>'' then Caption:=titlestring else Caption:='PeaZip';
   titlestring:='';
   status0:=txt_list_browsing;
   if EditOpenInInteractive.Caption<>txt_mypc then
      if currentfs='' then
         if currentcomp='' then status_curarchive:=''
         else
            if seemencrypted=true then status_curarchive:=currentcomp+', '+txt_encrypted
            else status_curarchive:=currentcomp;
   PanelOpen.Top:=0;
   PanelOpen.Visible:=true;
   if showmenu=true then
      begin
      {mEdit.Visible:=true;
      mBrowse.Visible:=true;
      mOrganize.Visible:=true;}
      mEdit.Enabled:=true;
      mBrowse.Enabled:=true;
      mOrganize.Enabled:=true;
      end;
   wasselected:=-1;
   end;
   'extract' :
   begin
   prevpanel:='extract';
   updateid:='';
   prevupdateid:='';
   mextopt.enabled:=false;
   pmbrowser.Enabled:=true;
   setrecenticons_extract_archive;
   titlestring:=Caption;
   savestatus_extractor;
   Caption:=getextcaption;
   mConsoleCreateExt.Text:='';
   PanelExtract.Top:=0;
   if (alttabstyle<>1) and (alttabstyle<>4) then clicklabel_extract(LabelTitleExtract1,ShapeTitleExtractb1) else clicklabel_extract(LabelTitleExtract1,Shapelinkextract1);
   PanelExtract.Visible:=true;
   if showmenu=true then
      begin
      //mLayout.Visible:=true;
      mLayout.Enabled:=true;
      end;
   mtogglenew.visible:=true;
   mgotype.visible:=false;
   MenuItem110.visible:=false;
   mgotypegz.visible:=false;
   mgotype7zsfx.visible:=false;
   mgotypetar.visible:=false;
   mgotypezip.visible:=false;
   mgotypebz2.visible:=false;
   mgotype7z.visible:=false;
   MenuItem121.visible:=false;
   msavecompsettings.visible:=false;
   mloadcompsettings.visible:=false;
   mextractarchive.Caption:=txt_caption_extract;
   if mdefaultextract.Checked=false then s:=EditOutExtract.Text
   else s:=defaultextractpath;
   if check7zvolume(s)=true then s:=local_desktop;
   if s='' then s:=local_desktop;
   //control_outpath(s); //deactivated control on showing extraction interface, keeping only control on actions consistently with archive creation routines
   EditOutExtract.Text:=s;
   if FormPeach.Visible=true then
      if FormPeach.ButtonExtOk.Enabled=true then
         begin
         {$IFDEF MSWINDOWS}
         if FormPeach.Visible=true then
            try ButtonExtOk.Setfocus; except end;
         {$ENDIF}
         end;
   FormPeach.PanelProgressExtract.Color:=stringtocolor(color2);
   FormPeach.PanelProgressExtract.Height:=0;
   FormPeach.PanelProgressExtract.Width:=0;
   MenuItemEnumerate.visible:=false;
   mdefaultarchive.visible:=false;
   mdefaultextract.visible:=true;
   FormPeach.PanelTitleExtractTabAlign.Width:=FormPeach.LabelTitleExtract1.Width+
   FormPeach.LabelTitleExtract2.Width+
   FormPeach.LabelTitleExtract3.Width+
   FormPeach.LabelTitleExtract4.Width+
   FormPeach.LabelTitleExtract1.BorderSpacing.Left*5;
   tempcheckoutpath_extract;
   checkoutpath_extract;
   end;
   'defaults' :
   begin
   //prevpanel left unchanged, to be able to return to previous panel when editing is done
   if Caption<>'PeaZip' then prevcaption:=Caption;
   titlestring:='';
   Caption:='PeaZip';
   PanelOptions.Top:=0;
   PanelOptions.Visible:=true;
   FormPeach.SplitterOptions.Left:=(splitter3size*qscale) div 100;
   FormPeach.PanelTitleAppsTabAlign.Width:=FormPeach.LabelTitleApps1.Width+
   FormPeach.LabelTitleApps2.Width+
   FormPeach.LabelTitleApps1.BorderSpacing.Left*3;
   ComboBoxLanguage.Caption:=lang_file;
   EditOptSearch.Caption:=txt_searchfor+'...';
   if work_dir=5 then
      FormPeach.CheckBoxrelative.enabled:=false
   else
      FormPeach.CheckBoxrelative.enabled:=true;
   updatepluginstatus;
   if savehistory=1 then FormPeach.LabelResetHistory.enabled:=true else FormPeach.LabelResetHistory.enabled:=false;
   savestatus_defaults;
   end;
   end;
end;
end;

procedure reloadandbrowse;
var
   carcpath:AnsiString;
begin
carcpath:='';
if abcrs[4]<>'' then carcpath:=abcrs[4]
else
   if abcrs[3]<>'' then carcpath:=abcrs[3]
   else
      if abcrs[2]<>'' then carcpath:=abcrs[2]
      else
         if abcrs[1]<>'' then carcpath:=abcrs[1];
FormPeach.OpenDialogArchive.Filename:=FormPeach.EditOpenIn.Text;
FormPeach.ListViewBrowser.beginupdate;
open_inputselect;
FormPeach.ListViewBrowser.endupdate;
if browsingmode7z=1 then exit;
carcpath:=carcpath+'*';
if (pspecbrowse<>'') and (carcpath='*') then carcpath:=pspecbrowse+'*';
FormPeach.EditUn7zaFilterInteractive.Caption:=carcpath;
kp_EditUn7zaFilterInteractive_nonrecursive;
end;

procedure tobrowser_fromarchiver;
begin
clearlist;
using_tarbefore:=false;
FormPeach.EditAddFilepath.Text:='';
FormPeach.EditAddFilename.Text:='';
FormPeach.EditAddName.Text:=FormPeach.EditAddFilepath.Text+addext(FormPeach.EditAddFilename.Text);
FormPeach.OpenDialogArchive.Filename:=FormPeach.EditOpenIn.Text;
showpanel('open');
case upcase(ExtractFileExt(FormPeach.EditOpenIn.Text)) of
   '.7Z','.RAR','.TAR','.WIM','.ZIP','.ZIPX': reloadandbrowse;
   else
      if forceopenasarchive=true then reloadandbrowse
      else open_inputselect;
   end;
if fun='FILEBROWSER' then
   begin
   if keeppw=0 then
      begin
      FormPW.EditPWpass.Text:='';
      FormPW.EditPWconfirm.Text:='';
      FormPW.EditPWkeyfile.Text:='';
      setpwicons;
      end;
   end;
end;

procedure tobrowser_fromextractor;
begin
clearlist_ext;
FormPeach.CheckBoxSameExt.State:=cbUnchecked; //consistently as similar switch is treated for archiving
on_checkboxsameextclick;
FormPeach.OpenDialogArchive.Filename:=FormPeach.EditOpenIn.Text;
showpanel('open');
case upcase(ExtractFileExt(FormPeach.EditOpenIn.Text)) of
   '.7Z','.RAR','.TAR','.WIM','.ZIP','.ZIPX': reloadandbrowse;
   else
      if forceopenasarchive=true then reloadandbrowse
      else open_inputselect;
   end;
if fun='FILEBROWSER' then
   begin
   //open_inputselect; //on extraction refresh only if browsing filesystem
   if keeppw=0 then
      begin
      FormPW.EditPWpass.Text:='';
      FormPW.EditPWconfirm.Text:='';
      FormPW.EditPWkeyfile.Text:='';
      setpwicons;
      end;
   end;
end;

procedure gocancelarchive;
begin
cancellingarchive:=true;
restorestatus_archiver;
if stayopen=false then exit_withsave
else tobrowser_fromarchiver;
cancellingarchive:=false;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection UPDATES and check for online resources

///////////////////////////////////////////////////////////////////////////////}

procedure checkupdates;
var
   dom,s:ansistring;
   sint,pver:integer;
begin
showpanel('defaults');
clicklabel_options(FormPeach.LabelTitleOptions8, FormPeach.ShapeOptions8);
checkdom(dom,s);
//if s='' then
cp_open(dom,desk_env);
{else
   begin
{$IFDEF MSWINDOWS}
try
sint:=strtoint(s[1]+s[3]+s[5]);
pver:=strtoint(PEAZIPVERSION[1]+PEAZIPVERSION[3]+PEAZIPREVISION[2]);
if sint<=pver then
   pMessageInfoOK(s+' - '+txt_4_5_noupdate)
else
   if pMessageInfoYesNo(s+' - '+txt_4_5_goupdate)=6 then
      cp_open(dom,desk_env);
except
pMessageWarningOK(txt_4_5_koupdate)
end;
{$ENDIF}
   end; }
end;

procedure checkplugins;
var dom,s:ansistring;
begin
showpanel('defaults');
clicklabel_options(FormPeach.LabelTitleOptions8, FormPeach.ShapeOptions8);
checkdom(dom,s);
cp_open(dom+'peazip-add-ons.html',desk_env);
end;

procedure checkthemes;
var dom,s:ansistring;
begin
showpanel('defaults');
clicklabel_options(FormPeach.LabelTitleOptions6, FormPeach.ShapeOptions6);
checkdom(dom,s);
cp_open(dom+'peazip-themes.html',desk_env);
end;

procedure checktranslations;
var dom,s:ansistring;
begin
showpanel('defaults');
clicklabel_options(FormPeach.LabelTitleOptions1, FormPeach.ShapeOptions1);
checkdom(dom,s);
cp_open(dom+'peazip-translations.html',desk_env);
end;

{///////////////////////////////////////////////////////////////////////////////

subsection SELF-CHECK binaries with known hash values

///////////////////////////////////////////////////////////////////////////////}

function checkchash(fname:ansistring; var s:ansistring; var fexe:integer):boolean;
var
   fs,hs:ansistring;
begin
result:=true;
hs:='';
if fname='' then exit;
fs:=stringundelim(fname);//remove quoting if needed
if fs='' then exit;
if not(FileExists(fs)) then exit;
fexe:=fexe+1;
result:=false; //only existing files raise errors
hs:=getchash(fs);
case hs of
H7ZSFX1,
H7ZSFX2,
H7ZSFX3,
HARCSFX1,
HARCSFX2,
HARCSFX3,
HARCSFX4,
HARCSFX5,
{$IFDEF MSWINDOWS}
HPEA_WIN64_X,
HWINCONFIGURE,
HDDDLL_WIN64_X,
H7Z_WIN64_X,
H7ZDLL_WIN64_X,
H7ZBROTLI_WIN64_X,
H7ZFLZMA2_WIN64_X,
H7ZLIZARD_WIN64_X,
H7ZLZ4_WIN64_X,
H7ZLZ5_WIN64_X,
H7ZZSTD_WIN64_X,
HBROTLI_WIN64_X,
HZPAQ_WIN64_X,
HZSTD_WIN64_X,
HARC_WIN64_X,
HARCDLL1_WIN64_X,
HARCDLL2_WIN64_X,
HBCM_WIN64_X,
HBALZ,
HLPAQ1,
HLPAQ5,
HLPAQ8,
HPAQ8F,
HPAQ8JD,
HPAQ8L,
HPAQ8O,
HQUAD,
HSTRIP,
HUPX_WIN64_X,
HUNACE,
HUNACEDLL,
HUNRAR
{$IFDEF WIN32}
,HPEA_WIN32_X,
HDDDLL_WIN32_X,
H7Z_WIN32_X,
H7ZDLL_WIN32_X,
HZPAQ_WIN32_X,
HUPX_WIN32_X
{$ENDIF}
{$ELSE}
{$IFDEF DARWIN}
H7Z_MACOS,
H7ZALT_MACOS,
HPEA_MACOS_A,
HBROTLI_MACOS_A,
HZPAQ_MACOS_A,
HZSTD_MACOS_A,
HPEA_MACOS_X,
HBROTLI_MACOS_X,
HZPAQ_MACOS_X,
HZSTD_MACOS_X,
HZSTDLIB_MACOS_X,
{$ENDIF}
{$IFDEF FREEBSD}
HPEA_BSD_X_GTK2,
H7Z_BSD_X,
HBROTLI_BSD_X,
HZSTD_BSD_X,
{$ENDIF}
//x86_64
HPEA_LIN_X_GTK2,
HPEA_LIN_X_GTK3,
HPEA_LIN_X_QT6,
H7Z_LIN_X,
H7ZALT_LIN_X,
HBCM_LIN_X,
HBROTLI_LIN_X,
HUPX_LIN_X,
HZPAQ_LIN_X,
HZSTD_LIN_X,
H7ZRARSO_LIN_X,
HARC_LIN_X,
HLPAQ8_LIN_X,
HPAQ8O_LIN_X,
//aarch64
HPEA_LIN_A_GTK2,
H7Z_LIN_A,
HBROTLI_LIN_A,
HZSTD_LIN_A
{$ENDIF}
   : result:=true;
   end;
if result=false then s:=s+fname+' SHA256='+hs+char($0d)+char($0a)+char($0d)+char($0a);
end;

procedure internalbincheck;//check binaries invoked by peazip againsts list of known SHA256 hash values
var
   s,st,hs:ansistring;
   fexe:integer;
begin
s:='';
fexe:=0;
//executables
checkchash((escapefilename(executable_path,desk_env)+'pea'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'Configure PeaZip'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+alias7z+EXEEXT),s,fexe);//in case of alias, test the custom 7z binary against known hash values
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'arc'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'brotli'+DirectorySeparator+'brotli'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'unace'+DirectorySeparator+'unace'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'upx'+DirectorySeparator+'upx'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'quad'+DirectorySeparator+'bcm'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'lpaq'+DirectorySeparator+'lpaq8'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'paq'+DirectorySeparator+'paq8o'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'zpaq'+DirectorySeparator+'zpaq'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'zstd'+DirectorySeparator+'zstd'+EXEEXT),s,fexe);
{$IFDEF MSWINDOWS}
checkchash((escapefilename(binpath,desk_env)+'upx'+DirectorySeparator+'strip'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'quad'+DirectorySeparator+'balz'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'quad'+DirectorySeparator+'quad'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'lpaq'+DirectorySeparator+'lpaq1'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'lpaq'+DirectorySeparator+'lpaq5'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'paq'+DirectorySeparator+'paq8f'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'paq'+DirectorySeparator+'paq8jd'+EXEEXT),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'paq'+DirectorySeparator+'paq8l'+EXEEXT),s,fexe);
{$ENDIF}
//libraries
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'7z.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'7zCon.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'7zCon.linux.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'arc-tiny.linux.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'arc-tiny.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'freearc.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'freearc-installer.sfx'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'freearc-tiny.sfx'),s,fexe);
{$IFDEF MSWINDOWS}
checkchash((escapefilename(executable_path,desk_env)+'dragdropfilesdll.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'facompress.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'arc'+DirectorySeparator+'facompress_mt.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'unace'+DirectorySeparator+'UNACEV2.DLL'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'7z.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'Codecs'+DirectorySeparator+'brotli.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'Codecs'+DirectorySeparator+'flzma2.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'Codecs'+DirectorySeparator+'lizard.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'Codecs'+DirectorySeparator+'lz4.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'Codecs'+DirectorySeparator+'lz5.dll'),s,fexe);
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'Codecs'+DirectorySeparator+'zstd.dll'),s,fexe);
{$ELSE}
{$IFDEF DARWIN}
checkchash((escapefilename(binpath,desk_env)+'lib'+DirectorySeparator+'libzstd.1.dylib'),s,fexe);
{$ENDIF}
checkchash((escapefilename(binpath,desk_env)+'7z'+DirectorySeparator+'codecs'+DirectorySeparator+'Rar.so'),s,fexe);
{$ENDIF}
//results
if s<>'' then pMessageWarningOK(inttostr(fexe)+' '+txt_8_7_bintest+char($0d)+char($0a)+char($0d)+char($0a)+txt_8_7_hnotok+char($0d)+char($0a)+char($0d)+char($0a)+s)
else pMessageInfoOK(inttostr(fexe)+' '+txt_8_7_bintest+char($0d)+char($0a)+char($0d)+char($0a)+txt_8_7_hok);
end;

procedure internaldllcheck;//check dragdropfilesdll.dll (sole dll belonging to the project loaded at application startup, even if unused until drag and drop events) againsts list of known SHA256 hash values
var
   st,hs:ansistring;
begin
{$IFDEF MSWINDOWS}
st:=(escapefilename(executable_path,desk_env)+'dragdropfilesdll.dll');
hs:=getchash(st);
{$IFDEF WIN32}if hs<>HDDDLL_WIN32_X then begin pMessageErrorOK(txt_6_5_error+' / dragdropfilesdll.dll SHA256 hash'); halt; end;{$ENDIF}
{$IFDEF WIN64}if hs<>HDDDLL_WIN64_X then begin pMessageErrorOK(txt_6_5_error+' / dragdropfilesdll.dll SHA256 hash'); halt; end;{$ENDIF}
{$ENDIF}
end;

{///////////////////////////////////////////////////////////////////////////////

subsection LOCAL RESOURCES paths and filesystem information

///////////////////////////////////////////////////////////////////////////////}

procedure testwinrar;
begin
if libre_directive=2 then
   begin
   havewinrar:=false;
   exit;
   end;
if setrarmanual=1 then
   begin
   havewinrar:=true;
   FormPeach.EditNameCustom.Caption:=FormPeach.pcustom1.caption;
   end
else
   begin
   {$IFDEF MSWINDOWS}
   havewinrar:=true;
   if fileexists(GetEnvironmentVariable('ProgramFiles')+'\WinRAR\Rar.exe') then FormPeach.EditNameCustom.Caption:=GetEnvironmentVariable('ProgramFiles')+'\WinRAR\Rar.exe'
   else
      if fileexists(GetEnvironmentVariable('ProgramW6432')+'\WinRAR\Rar.exe') then FormPeach.EditNameCustom.Caption:=GetEnvironmentVariable('ProgramW6432')+'\WinRAR\Rar.exe'
      else
         if fileexists(executable_path+'Rar.exe') then FormPeach.EditNameCustom.Caption:=executable_path+'Rar.exe'
         else
            if fileexists(binpath+'Rar.exe') then FormPeach.EditNameCustom.Caption:=binpath+'Rar.exe'
            else
               if fileexists(binpath+'rar\Rar.exe') then FormPeach.EditNameCustom.Caption:=binpath+'rar\Rar.exe'
               else
                  if fileexists(binpath+'unrar\Rar.exe') then FormPeach.EditNameCustom.Caption:=binpath+'unrar\Rar.exe'
                  else
                     havewinrar:=false;
   {$ELSE}
   havewinrar:=true;
   if fileexists('/usr/local/bin/rar') then FormPeach.EditNameCustom.Caption:='/usr/local/bin/rar'
   else
      if fileexists('/usr/bin/rar') then FormPeach.EditNameCustom.Caption:='/usr/bin/rar'
      else
         if fileexists('/usr/sbin/rar') then FormPeach.EditNameCustom.Caption:='/usr/sbin/rar'
         else
            havewinrar:=false;
   {$ENDIF}
   end;
if (havewinrar=false) or (userar<>1) then
   begin
   FormPeach.cbType.Items[4]:=txt_custom;
   FormPeach.mprofilerar.visible:=false;
   FormPeach.pmmorerecover.Caption:=txt_7_4_recover+' (ARC)';
   FormPeach.po_recover.Caption:=txt_7_4_recover+' (ARC)';
   FormPeach.mcomment.Caption:=txt_7_4_comment+' (RAR '+txt_9_4_r+', ZIP, ZIPX)';
   FormPeach.po_commentzip.Caption:=txt_7_4_comment+' (RAR '+txt_9_4_r+', ZIP, ZIPX)';
   FormPeach.pmmorecommentzip.Caption:=txt_7_4_comment+' (RAR '+txt_9_4_r+', ZIP, ZIPX)';
   FormPeach.pmscomment.Caption:=txt_7_4_comment+' (RAR '+txt_9_4_r+', ZIP, ZIPX)';
   end
else
   begin
   FormPeach.cbType.Items[4]:=txt_custom+'/RAR';
   FormPeach.mprofilerar.visible:=true;
   FormPeach.pmmorerecover.Caption:=txt_7_4_recover+' (ARC, RAR)';
   FormPeach.po_recover.Caption:=txt_7_4_recover+' (ARC, RAR)';
   FormPeach.mcomment.Caption:=txt_7_4_comment+' (RAR, ZIP, ZIPX)';
   FormPeach.po_commentzip.Caption:=txt_7_4_comment+' (RAR, ZIP, ZIPX)';
   FormPeach.pmmorecommentzip.Caption:=txt_7_4_comment+' (RAR, ZIP, ZIPX)';
   FormPeach.pmscomment.Caption:=txt_7_4_comment+' (RAR, ZIP, ZIPX)';
   FormPeach.EditExtensionCustom.Caption:='rar';
   FormPeach.cbRARmanual.Hint:=FormPeach.EditNameCustom.Caption;
   end;
end;

function wingetprogramsfolder:integer;
begin
Result:=-1;
{$IFDEF MSWINDOWS}
winpfolder:='';
winpfolder32:='';
winpfolder:=(GetEnvironmentVariable('ProgramW6432'));
if winpfolder='' then //XP and older
   begin
   winpfolder:=(GetEnvironmentVariable('ProgramFiles'));
   winpfolder32:=winpfolder;
   end
else //Vista and newer
   begin
   winpfolder:=(GetEnvironmentVariable('ProgramFiles'));
   winpfolder32:=(GetEnvironmentVariable('ProgramFiles(x86)'));
   if winpfolder=winpfolder32 then winpfolder:=(GetEnvironmentVariable('ProgramW6432'));
   end;
Result:=0;
setendingdirseparator(winpfolder);
setendingdirseparator(winpfolder32);
if not(checkdirexists(winpfolder)) then
   begin
   winpfolder:='';
   Result:=1;
   end;
if not(checkdirexists(winpfolder32)) then
   begin
   winpfolder32:='';
   Result:=1;
   end;
{$ENDIF}
end;

function wingetsystemfolder:integer;
begin
Result:=-1;
{$IFDEF MSWINDOWS}
winsysfolder:='';
winsysfolder:=(GetEnvironmentVariable('SystemRoot'));
Result:=0;
setendingdirseparator(winsysfolder);
if not(checkdirexists(winsysfolder)) then
   begin
   winsysfolder:='';
   Result:=1;
   end;
{$ENDIF}
end;

function wingetdesk:integer;
begin
wingetdesk:=-1;
{$IFDEF MSWINDOWS}
desktop_path:=GetWindowsSpecialDir(CSIDL_DESKTOPDIRECTORY);
if not(checkdirexists(desktop_path)) then desktop_path:=(GetEnvironmentVariable('USERPROFILE'))+'\Desktop\'; //try from environment variable
if not(checkdirexists(desktop_path)) then desktop_path:=GetWindowsSpecialDir(CSIDL_COMMON_DESKTOPDIRECTORY);//fallback on common desktop
if not(checkdirexists(desktop_path)) then desktop_path:=GetWindowsSpecialDir(CSIDL_PROFILE);//fallback on profile
if not(checkdirexists(desktop_path)) then
   begin
   desktop_path:='C:\';//fallback on C:\ rather than casting error on desktop (default initial dir)
   Result:=0;
   end
else Result:=0;
setendingdirseparator(desktop_path);
{$ENDIF}
end;

function wingetuserprofile:integer;
begin
wingetuserprofile:=-1;
{$IFDEF MSWINDOWS}
home_path:=GetWindowsSpecialDir(CSIDL_PROFILE);
if not(checkdirexists(home_path)) then home_path:=(GetEnvironmentVariable('USERPROFILE'))+directoryseparator;
setendingdirseparator(home_path);
if not(checkdirexists(home_path)) then
   begin
   home_path:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetappdatafolder:integer;
begin
wingetappdatafolder:=-1;
{$IFDEF MSWINDOWS}
winappdatafolder:=GetWindowsSpecialDir(CSIDL_APPDATA);
if not(checkdirexists(winappdatafolder)) then winappdatafolder:=(GetEnvironmentVariable('APPDATA'))+directoryseparator;
setendingdirseparator(winappdatafolder);
if not(checkdirexists(winappdatafolder)) then
   begin
   winappdatafolder:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetappdata(var s:ansistring):integer;
begin
wingetappdata:=-1;
{$IFDEF MSWINDOWS}
wingetappdatafolder;
s:=winappdatafolder+'PeaZip\';
wingetappdata:=0;
{$ENDIF}
end;

function wingetdocuments:integer;
begin
wingetdocuments:=-1;
{$IFDEF MSWINDOWS}
usr_documents:=GetWindowsSpecialDir(CSIDL_PERSONAL);
setendingdirseparator(usr_documents);
if not(checkdirexists(usr_documents)) then
   begin
   usr_documents:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetmusic:integer;
begin
wingetmusic:=-1;
{$IFDEF MSWINDOWS}
usr_music:=GetWindowsSpecialDir(CSIDL_MYMUSIC);
setendingdirseparator(usr_music);
if not(checkdirexists(usr_music)) then
   begin
   usr_music:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetpictures:integer;
begin
wingetpictures:=-1;
{$IFDEF MSWINDOWS}
usr_pictures:=GetWindowsSpecialDir(CSIDL_MYPICTURES);
setendingdirseparator(usr_pictures);
if not(checkdirexists(usr_pictures)) then
   begin
   usr_pictures:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetvideos:integer;
begin
wingetvideos:=-1;
{$IFDEF MSWINDOWS}
usr_videos:=GetWindowsSpecialDir(CSIDL_MYVIDEO);
setendingdirseparator(usr_videos);
if not(checkdirexists(usr_videos)) then
   begin
   usr_videos:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetsendto:integer;
begin
wingetsendto:=-1;
{$IFDEF MSWINDOWS}
usr_sendto:=GetWindowsSpecialDir(CSIDL_SENDTO);
setendingdirseparator(usr_sendto);
if not(checkdirexists(usr_sendto)) then
   begin
   usr_sendto:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetpublicdocuments:integer;
begin
wingetpublicdocuments:=-1;
{$IFDEF MSWINDOWS}
public_documents:=GetWindowsSpecialDir(CSIDL_COMMON_DOCUMENTS);
setendingdirseparator(public_documents);
if not(checkdirexists(public_documents)) then
   begin
   public_documents:='';
   FormPeach.pmJumppubdoc.Visible:=false;
   FormPeach.MenuItemArchive_pubdoc.Visible:=false;
   FormPeach.MenuItemOpen_pubdoc.Visible:=false;
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetpublichome:integer;
begin
wingetpublichome:=-1;
{$IFDEF MSWINDOWS}
try
public_home:=(GetEnvironmentVariable('PUBLIC'));
if public_home='' then
else
   if public_home[length(public_home)]<>directoryseparator then public_home:=public_home+directoryseparator;
except
end;
if not(checkdirexists(public_home)) then
   begin
   public_home:='';
   FormPeach.pmJumppubhome.Visible:=false;
   FormPeach.MenuItemArchive_pubhome.Visible:=false;
   FormPeach.MenuItemOpen_pubhome.Visible:=false;
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetrecent:integer;
begin
wingetrecent:=-1;
{$IFDEF MSWINDOWS}
usr_recent:=GetWindowsSpecialDir(CSIDL_RECENT);
setendingdirseparator(usr_recent);
if not(checkdirexists(usr_recent)) then
   begin
   usr_recent:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetdownloads:integer;
begin
wingetdownloads:=-1;
{$IFDEF MSWINDOWS}
usr_downloads:='';
if winver<>'nt6+' then
   begin
   FormPeach.pmJumpdownloads.Visible:=false;
   exit;
   end;
usr_downloads:=home_path+'Downloads\';
if not(checkdirexists(usr_downloads)) then
   begin
   usr_downloads:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetsearches:integer;
begin
wingetsearches:=-1;
{$IFDEF MSWINDOWS}
usr_searches:='';
if winver<>'nt6+' then
   begin
   FormPeach.pmJumpsearches.Visible:=false;
   exit;
   end;
usr_searches:=home_path+'Searches\';
if not(checkdirexists(usr_searches)) then
   begin
   usr_searches:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function wingetlibraries:integer;
begin
wingetlibraries:=-1;
{$IFDEF MSWINDOWS}
usr_libraries:='';
usr_libraries:=home_path+'AppData\Roaming\Microsoft\Windows\Libraries\';
if not checkdirexists(usr_libraries) then
   begin
   usr_libraries:='';
   FormPeach.pmJumplibraries.Visible:=false;
   exit;
   end;
if not(checkdirexists(usr_libraries)) then
   begin
   usr_libraries:='';
   Result:=1;
   end
else Result:=0;
{$ENDIF}
end;

function sysgetshared:integer;
begin
sysgetshared:=-1;
shared_dropbox:='';
shared_myboxfiles:='';
shared_googledrive:='';
shared_onedrive:='';
shared_skydrive:='';
shared_ubuntuone:='';
FormPeach.pmqjdropbox.visible:=false;
FormPeach.pmqjmyboxfiles.visible:=false;
FormPeach.pmqjgoogledrive.visible:=false;
FormPeach.pmqjonedrive.visible:=false;
FormPeach.pmqjskydrive.visible:=false;
FormPeach.pmqjubuntuone.visible:=false;
{$IFDEF MSWINDOWS}
if checkdirexists(home_path+'Dropbox') then
   begin
   shared_dropbox:=home_path+'Dropbox\';
   FormPeach.pmqjdropbox.visible:=true;
   end;
if checkdirexists(usr_documents+'My Box Files') then
   begin
   shared_myboxfiles:=usr_documents+'My Box Files\';
   FormPeach.pmqjmyboxfiles.visible:=true;
   end;
if checkdirexists(home_path+'Google Drive') then
   begin
   shared_googledrive:=home_path+'Google Drive\';
   FormPeach.pmqjgoogledrive.visible:=true;
   end;
if checkdirexists(home_path+'OneDrive') then
   begin
   shared_onedrive:=home_path+'OneDrive\';
   FormPeach.pmqjonedrive.visible:=true;
   end;
if checkdirexists(home_path+'Workspaces') then
   begin
   shared_skydrive:=home_path+'Workspaces\';
   FormPeach.pmqjskydrive.visible:=true;
   end;
if checkdirexists(home_path+'YandexDisk') then
   begin
   shared_ubuntuone:=home_path+'YandexDisk\';
   FormPeach.pmqjubuntuone.visible:=true;
   end;
{$ENDIF}
{$IFDEF LINUX}
{$ENDIF}
FormPeach.MenuItemArchive_dropbox.visible:=FormPeach.pmqjdropbox.visible;
FormPeach.MenuItemArchive_myboxfiles.visible:=FormPeach.pmqjmyboxfiles.visible;
FormPeach.MenuItemArchive_googledrive.visible:=FormPeach.pmqjgoogledrive.visible;
FormPeach.MenuItemArchive_onedrive.visible:=FormPeach.pmqjonedrive.visible;
FormPeach.MenuItemArchive_skydrive.visible:=FormPeach.pmqjskydrive.visible;
FormPeach.MenuItemArchive_ubuntuone.visible:=FormPeach.pmqjubuntuone.visible;
FormPeach.MenuItemOpen_dropbox.visible:=FormPeach.pmqjdropbox.visible;
FormPeach.MenuItemOpen_myboxfiles.visible:=FormPeach.pmqjmyboxfiles.visible;
FormPeach.MenuItemOpen_googledrive.visible:=FormPeach.pmqjgoogledrive.visible;
FormPeach.MenuItemOpen_onedrive.visible:=FormPeach.pmqjonedrive.visible;
FormPeach.MenuItemOpen_skydrive.visible:=FormPeach.pmqjskydrive.visible;
FormPeach.MenuItemOpen_ubuntuone.visible:=FormPeach.pmqjubuntuone.visible;
sysgetshared:=0;
end;

procedure set_win_antivirus;
var
  avgver,istr:integer;
  mbampath,esetdir:ansistring;
  astr,bstr,cstr,dstr:array [1..8] of ansistring;
begin
{$IFDEF MSWINDOWS}
istr:=0;
//Windows defender with or without GUI
if fileexists(winpfolder32+'Windows Defender\MSASCui.exe') or fileexists(winpfolder32+'Windows Defender\MpCmdRun.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Microsoft Windows Defender';
   bstr[istr]:=wincomspec+' /k ""'+winpfolder32+'Windows Defender\MpCmdRun.exe" -Scan -ScanType 3 -File ';
   cstr[istr]:='"';
   if fileexists(winpfolder32+'Windows Defender\MSASCui.exe') then dstr[istr]:=winpfolder32+'Windows Defender\MSASCui.exe'
   else dstr[istr]:=winpfolder32+'Windows Defender\MpCmdRun.exe';
   end;
if fileexists(winpfolder+'Windows Defender\MSASCui.exe') or fileexists(winpfolder+'Windows Defender\MpCmdRun.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Microsoft Windows Defender';
   bstr[istr]:=wincomspec+' /k ""'+winpfolder+'Windows Defender\MpCmdRun.exe" -Scan -ScanType 3 -File ';
   cstr[istr]:='"';
   if fileexists(winpfolder+'Windows Defender\MSASCui.exe') then dstr[istr]:=winpfolder+'Windows Defender\MSASCui.exe'
   else dstr[istr]:=winpfolder+'Windows Defender\MpCmdRun.exe';
   end;
//Avira
if fileexists(winpfolder32+'Avira\AntiVir Desktop\avscan.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Avira AntiVir Personal';
   bstr[istr]:='"'+winpfolder32+'Avira\AntiVir Desktop\avscan.exe" /GUIMODE=1 /PATH=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'Avira\AntiVir Desktop\avcenter.exe';
   end;
if fileexists(winpfolder+'Avira\AntiVir Desktop\avscan.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Avira AntiVir Personal';
   bstr[istr]:='"'+winpfolder+'Avira\AntiVir Desktop\avscan.exe" /GUIMODE=1 /PATH=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'Avira\AntiVir Desktop\avcenter.exe';
   end;
//ClamWin
if fileexists(winpfolder32+'ClamWin\Bin\ClamWin.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='ClamWin';
   bstr[istr]:='"'+winpfolder32+'ClamWin\Bin\ClamWin.exe" --mode="scanner" --path=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'ClamWin\Bin\ClamWin.exe';
   end;
if fileexists(winpfolder+'ClamWin\Bin\ClamWin.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='ClamWin';
   bstr[istr]:='"'+winpfolder+'ClamWin\Bin\ClamWin.exe" --mode="scanner" --path=';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'ClamWin\Bin\ClamWin.exe';
   end;
//ESET
esetdir:='';
if fileexists(winpfolder32+'ESET\ESET Smart Security\ecls.exe') then esetdir:=winpfolder32+'ESET\ESET Smart Security\';
if fileexists(winpfolder32+'ESET\ESET NOD32 Antivirus\ecls.exe') then esetdir:=winpfolder32+'ESET\ESET NOD32 Antivirus\';
if fileexists(winpfolder+'ESET\ESET Smart Security\ecls.exe') then esetdir:=winpfolder+'ESET\ESET Smart Security\';
if fileexists(winpfolder+'ESET\ESET NOD32 Antivirus\ecls.exe') then esetdir:=winpfolder+'ESET\ESET NOD32 Antivirus\';
if esetdir<>'' then
   begin
   istr:=istr+1;
   astr[istr]:='ESET/NOD32';
   bstr[istr]:='"'+esetdir+'ecls.exe" ';
   cstr[istr]:='';
   dstr[istr]:='"'+esetdir+'egui.exe"';
   end;
//MBAM
mbampath:='';
if fileexists(winpfolder32+'Malwarebytes'' Anti-Malware\mbam.exe') then mbampath:=winpfolder32+'Malwarebytes'' Anti-Malware\mbam.exe';
if fileexists(winpfolder+'Malwarebytes'' Anti-Malware\mbam.exe') then mbampath:=winpfolder+'Malwarebytes'' Anti-Malware\mbam.exe';
if fileexists(winpfolder32+'MALWAREBYTES ANTI-MALWARE\mbam.exe') then mbampath:=winpfolder32+'MALWAREBYTES ANTI-MALWARE\mbam.exe';
if fileexists(winpfolder+'MALWAREBYTES ANTI-MALWARE\mbam.exe') then mbampath:=winpfolder+'MALWAREBYTES ANTI-MALWARE\mbam.exe';
if fileexists(winpfolder32+'Malwarebytes\Anti-Malware\mbam.exe') then mbampath:=winpfolder32+'Malwarebytes\Anti-Malware\mbam.exe';
if fileexists(winpfolder+'Malwarebytes\Anti-Malware\mbam.exe') then mbampath:=winpfolder+'Malwarebytes\Anti-Malware\mbam.exe';
if mbampath<>'' then
   begin
   istr:=istr+1;
   astr[istr]:='Malwarebyte''s Anti-Malware';
   bstr[istr]:='"'+mbampath+'" ';  //MBAM free version does not support scripting the scan
   cstr[istr]:='';
   dstr[istr]:='"'+mbampath+'"';
   end;
//SpybotSD
if fileexists(winpfolder32+'Spybot - Search & Destroy\SDFiles.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Spybot - Search and Destroy';
   bstr[istr]:='"'+winpfolder32+'Spybot - Search & Destroy\SDFiles.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'Spybot - Search & Destroy\SpybotSD.exe';
   end;
if fileexists(winpfolder+'Spybot - Search & Destroy\SDFiles.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='Spybot - Search and Destroy';
   bstr[istr]:='"'+winpfolder+'Spybot - Search & Destroy\SDFiles.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'Spybot - Search & Destroy\SpybotSD.exe';
   end;
//VirusTotal Uploader
if fileexists(winpfolder32+'VirusTotalUploader2\VirusTotalUpload2.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='VirusTotal';
   bstr[istr]:='"'+winpfolder32+'VirusTotalUploader2\VirusTotalUpload2.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder32+'VirusTotalUploader2\VirusTotalUpload2.exe';
   end;
if fileexists(winpfolder+'VirusTotalUploader2\VirusTotalUpload2.exe') then
   begin
   istr:=istr+1;
   astr[istr]:='VirusTotal';
   bstr[istr]:='"'+winpfolder+'VirusTotalUploader2\VirusTotalUpload2.exe" ';
   cstr[istr]:='';
   dstr[istr]:=winpfolder+'VirusTotalUploader2\VirusTotalUpload2.exe';
   end;

with FormPeach do
begin
StringGridCustEditAdv.Cells[1,1]:=astr[1];
advedit1before:=bstr[1];
advedit1after:=cstr[1];
advedit1alt:=dstr[1];
StringGridCustEditAdv.Cells[1,2]:=astr[2];
advedit2before:=bstr[2];
advedit2after:=cstr[2];
advedit2alt:=dstr[2];
StringGridCustEditAdv.Cells[1,3]:=astr[3];
advedit3before:=bstr[3];
advedit3after:=cstr[3];
advedit3alt:=dstr[3];
StringGridCustEditAdv.Cells[1,4]:=astr[4];
advedit4before:=bstr[4];
advedit4after:=cstr[4];
advedit4alt:=dstr[4];
StringGridCustEditAdv.Cells[1,5]:=astr[5];
advedit5before:=bstr[5];
advedit5after:=cstr[5];
advedit5alt:=dstr[5];
StringGridCustEditAdv.Cells[1,6]:=astr[6];
advedit6before:=bstr[6];
advedit6after:=cstr[6];
advedit6alt:=dstr[6];
StringGridCustEditAdv.Cells[1,7]:=astr[7];
advedit7before:=bstr[7];
advedit7after:=cstr[7];
advedit7alt:=dstr[7];
StringGridCustEditAdv.Cells[1,8]:=astr[8];
advedit8before:=bstr[8];
advedit8after:=cstr[8];
advedit8alt:=dstr[8];
end;
{$ENDIF}
end;

procedure getcurrentfs(var s,sfs:ansistring);
var
   sdrive:ansistring;
   bufVolumeName, bufFSName: array[0..255] of Char;
   sn,mc,flags:dword;
begin
{$IFDEF MSWINDOWS}
sdrive:=extractfiledrive(s)+'\';
GetVolumeInformation(Pchar(sdrive),
@bufVolumeName, sizeof(bufVolumeName),
@sn, mc, flags,
@bufFSName, sizeof(bufFSName));
sfs:=bufFSName;
{$ELSE}
sfs:=txt_fs;
{$ENDIF}
end;

{///////////////////////////////////////////////////////////////////////////////

subsection PATH CHECKING routines

///////////////////////////////////////////////////////////////////////////////}

function pathistmp(s:ansistring):boolean;
begin
result:=false;
if (pos(STR_TMP,s)) or
   (pos(STR_PZWORKTMP,s)) or
   (pos(STR_STMP,s)) or
   (pos(STR_TMPEXT,s)) or
   (pos(STR_TMPDD,s)) or
   (pos(STR_PEAZIPTMP,s))<>0 then result:=true;
end;

procedure checkoutpath_archive;
begin
if FormPeach.visible=true then
   if pathistmp(FormPeach.EditAddName.Text)=true then
      FormPeach.EditAddName.Color:=PLYELLOW
   else
      FormPeach.EditAddName.Color:=stringtocolor(color2);
end;

procedure tempcheckoutpath_extract;
begin
if FormPeach.visible=true then
   if pos(STR_TMP,FormPeach.EditOutExtract.Text)<>0 then
      if (checkdirexists(FormPeach.pnha1.Caption)=true) and (pos(STR_TMP,FormPeach.pnha1.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha1.Caption
      else
         if (checkdirexists(FormPeach.pnha2.Caption)=true) and (pos(STR_TMP,FormPeach.pnha2.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha2.Caption
         else
            if (checkdirexists(FormPeach.pnha3.Caption)=true) and (pos(STR_TMP,FormPeach.pnha3.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha3.Caption
            else
               if (checkdirexists(FormPeach.pnha4.Caption)=true) and (pos(STR_TMP,FormPeach.pnha4.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha4.Caption
               else
                  if (checkdirexists(FormPeach.pnha5.Caption)=true) and (pos(STR_TMP,FormPeach.pnha5.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha5.Caption
                  else
                     if (checkdirexists(FormPeach.pnha6.Caption)=true) and (pos(STR_TMP,FormPeach.pnha6.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha6.Caption
                     else
                        if (checkdirexists(FormPeach.pnha7.Caption)=true) and (pos(STR_TMP,FormPeach.pnha7.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha7.Caption
                        else
                           if (checkdirexists(FormPeach.pnha8.Caption)=true) and (pos(STR_TMP,FormPeach.pnha8.Caption)=0) then FormPeach.EditOutExtract.Text:=FormPeach.pnha8.Caption;
end;

procedure checkoutpath_extract;
begin
if FormPeach.visible=true then
   if pathistmp(FormPeach.EditOutExtract.Text)=true then
      begin
      FormPeach.EditOutExtract.Color:=PLYELLOW;
      if pos(STR_TMP,FormPeach.EditOutExtract.Text)<>0 then FormPeach.EditOutExtract.Hint:=txt_7_0_exttmppath+char($0D)+char($0A)+copy(FormPeach.EditOutExtract.Caption,0,pos(STR_TMP,FormPeach.EditOutExtract.Caption)-1);
      end
   else
      begin
      FormPeach.EditOutExtract.Color:=stringtocolor(color2);
      FormPeach.EditOutExtract.Hint:='';
      end;
updatecontent_ext;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection LOCALIZATION text and translations related routines

///////////////////////////////////////////////////////////////////////////////}

function valorize_text:integer;
var
   s:ansistring;
begin
valorize_text:=-1;
try
readln(t,s);
readln(t,s); txt_10_7_errload:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_errfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_first:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_fit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_fith:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_fitw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_keep:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_next:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_prev:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_pwh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_images:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_7_thumbnails:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_6_virtual:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_fr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_sectype:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_checkmotw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_sectypewarning:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_pathlock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_type_description_rar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_sh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_5_ntfsalt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_4_moving:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_3_classic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_3_ascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_3_minimal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_3_m:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_3_pm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_3_aw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_2_savecopy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_1_full:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_1_kdfw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_1_under:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_exptrash:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_ptarzst:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_ptarxz:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_ptargz:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_comp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_save:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_10_0_tp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_9_uac:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); TXT_9_9_kdf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_9_utc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_8_alwaysflat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_8_fnew:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_8_fsmart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_7_tarpipe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_7_smartsorting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_centered:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_cside:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_loadpconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_loadp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_saveppw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_savepoverwrite:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_savep:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_6_scside:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_precond:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_largea:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_mediuma:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_smalla:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_reopentab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_savetabs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_5_sb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_4_r:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_4_rw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_4_savecomment:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_4_hintcomment:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_continue:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_contrast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_fsd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_fsw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_mrar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_canedit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_canforce:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_3_cannotedit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_7za:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_changelog:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_tfaq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_compact:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_swt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_tos:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_doc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_2_updates:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_7zs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_ac:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_closeall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_enlargeicons:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_ef:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_nw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_1_qdup:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_autoexttar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_accesstime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_mem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_showmainmenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_navmenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_plugind:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_df:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_hl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_sl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_9_0_tnav:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_empty:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_parsing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_stoptest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_9_ttb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_ca:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_btn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_cb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_centered:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_light:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_lnk:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_intnote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_snz:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_sm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_solcol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_snoi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_snon:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_tab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_altt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_autotest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_8_cw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_csvhelp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_after:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_bintest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_csv:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_hok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_mo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_showhm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_showsearchbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_showsm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_hnotok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_7_verifybin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_clear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_noclear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_nosimple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_immediate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_6_yessimple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_advbrowser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_detailslarge:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_intext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_listlarge:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_loadlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_5_samplescripts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_4_keepopenerrorslist:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_mbubin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_cw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_temperature:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_mbudec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_htab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_maxarg:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_mbu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_prefalgo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_skipdel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_lw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_3_noupx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_slower:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_df:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_vreport:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_ta:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_tc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_keep:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_tm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_skipet:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_alltimes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_2_supportedby:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_preparse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_bo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_bop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_nopreparse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_ed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_togglearc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_preparsehint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_slow:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_vslow:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_1_volumes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_altcol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forcebrowse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_commonalgo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forceconvert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_defaultactionhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_defaultaction:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_enableextand:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forcetyping:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_setpwopt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_8_0_forcetypinghelp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_9_spacing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_9_zooming:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_changelocalization:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_custext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_destexistfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_dd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_priorityhigh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_priorityidle:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_rel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_prioritynormal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_priorityrealtime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_requirerestart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_tpriority:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_8_update:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_noneall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_nonetemp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_outtemp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_sys7zreq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_tw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_7_sys7z:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_zipenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_color:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_custenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_dark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tno:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_forcelocalenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_forceutf8enc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_cpnote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_defaultenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_dim:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_setcurdef:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_setdef:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tadvanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tsimple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_6_tacolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_always:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_ask:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_autoclosesingle:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_cutlen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_cutlenw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_dragnone:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_specialbrowse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_ee:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_draghide:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_draglh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_draglock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_never:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_5_repnascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_comment:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_7zfbrotlicomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_7zfzstandardcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_presetrar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_tkeep:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_lock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_locked:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_lockconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_recover:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_tcurr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_setarc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_setext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_4_swzipx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_archiveerrors:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_archiveerrorshint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_clickextall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_noconfdel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_profile7zfastest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_maxbr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_maxzstd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_profile7zfast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_3_stl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_altcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_clearnoupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_autoclosepeazip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_zpaqall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_extcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_extcompultra:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_fbrotlicomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_fzstandardcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_loadcompsettings:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_savecompsettings:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_source:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_2_updateclear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_type_description_brotli:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_smart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_profileintermediate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_renfilesonly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_typetosearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_1_type_description_zstd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_0_af:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_0_autoopentar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7_0_exttmppath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_autou:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_forceu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_opuns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_overarch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_9_uconf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_8_ndrop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_7_nop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_pdupfound:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_rsh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_pdupfind:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_6_forcemodify:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_mandatory:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_abort:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_askp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_chp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_def:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_nop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_seqerr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_sni:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_sns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_privacy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_showvolatile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_force:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_warning:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_yes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_yesall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_5_np:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_absolute:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_appdirn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_closeallother:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_closeright:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_collapse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_expand:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_full:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_openintab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_paths:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_prepdirn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_relative:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_4_tabbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_autoadjust:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_cinfo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_syn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_3_uar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_2_encext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_2_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_2_container:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_1_ec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_6_0_msq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_9_lff:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_9_pff:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_9_start:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_l0:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_l1:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_l2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_ascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_cp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_fs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_utf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_8_fsr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_7_pinstalled:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_7_pmissing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_7_plugin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_basic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_exarc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_tab:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_rc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_layouts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_upexisting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_6_verbose:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_case:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_add:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_addsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_plugin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_copypath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_delete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_halt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_positionw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_positionwd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_replaceneww:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_lower:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_replaceoldw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_newext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_n:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_old:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_position:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_intdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_replacestr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesameday:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesamehour:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesamemonth:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesameweek:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datesameyear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_scan:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_select:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_similar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_starting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_string:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_subtractsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datehour:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_datemonth:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_dateweek:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_dateyear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_dateday:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_upper:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_5_extw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_da:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletearchives:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletefiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deleteoriginal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_lv:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletearchivesconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_deletefilesconfirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_4_used:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilebest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profileadvanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilenormal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profileveryfast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilepassword:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profile10mb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_profilesfx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_cml:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_cmlmessage:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_exc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_ia:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_io:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_rec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_3_resetsi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_oadd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zerodelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zfree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_sdfree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_oext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_securedeletefree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_free:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zerofiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_2_zerofree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedadd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schederr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_daily:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_day:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_days:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_enddate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_every:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w6:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_hourly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_hours:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_last:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedmanage:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_scriptmanage:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_monthly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_months:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_onlogin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_onstart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_once:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w7:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedule:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedexplain:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedscripts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_startdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_starttime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w1:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_schedname:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_ts:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w5:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w3:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_w4:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_weekly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_1_weeks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_bc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_resetpm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_enum:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_music:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_ps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_perf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_pictures:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_removeall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_resetbookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_sh:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_skip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_5_0_videos:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_frame:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_listth:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_shadow:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_9_style:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_attach25:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_crop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_detailsno:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_details:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fitl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_flip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fullscreen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_fun:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_h:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_keeparchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_noresize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_iconl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_iconm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_imagemanager:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_immersive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_listno:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_aspect:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_mirror:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_presets:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_replace:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_resize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_rl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_rr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_stop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_t:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_8_w:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_pk:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_spchar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_recycleask:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_recycle:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_7_pcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_6_am:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_6_fm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_6_users:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_goupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_b:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_koupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_update:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_dock:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_l:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_noupdate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_properties:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_r:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_pj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shaddress:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shnav:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shstatus:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_shtool:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_upxpj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_5_t:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_4_confremoveall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_4_confremove:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_exppl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_expple:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_keeppw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanpwhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanmaster:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmanlist:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwman:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_pwmancorr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_expplp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_recsrc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_resetpm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_3_breadcrumb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_2_arcabspath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_duplicateshint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_adminhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_selected:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_duplicatesfound:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_duplicatesfind:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_runasadmin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_1_simplesearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_4_0_thim:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_8_type_description_wim:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_8_type_description_xz:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_donations:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_nameasparent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_tracker:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_sort:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_swapbars:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_7_themedbars:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_ignoredd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_close:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_resetapps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_6_ethemes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_5_td:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_5_managecustomthemes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_4_nopaths:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_4_smallicons:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_skipunits:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_stralt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_apps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_multi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_runexp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_apppath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_3_run:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_7zutf8nonascii:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_alltasks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_conf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_2_donations:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_sccenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_downloads:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_lib:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_more:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_openasarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_sendto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_pathexc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_recent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_plsmartmin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_src:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_systmp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_languagetools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_1_workingdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_nonreadableorpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_readablepw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_configure:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_3_0_resettmp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_address:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_adv:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_columns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_copyhere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_noscan:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_extconsole:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_thl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_home:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_lt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_mt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_movehere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_nav:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_navbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_none:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_organize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_public:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_rec:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_selected:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_setapps:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_showmenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_st:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_test_pw2G:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_vst:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_toolbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_tree:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_9_views:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_experimental:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_zcopy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_addvol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_uniterror:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_cannotconvert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertbegin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertexisting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertdelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_details:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_parallel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_convertnote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_unitrecommend:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_viewasarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_nounit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_rowselect:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_statusbar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_typeunit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_8_usedefaultoutpath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_experimental:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_optional:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_list_tryflatorpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_separate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwsupported:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_cancel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_encfn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_setpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_extfrom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_es:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_eu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_clipboard:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_goarclayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_goextlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_ok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_drag_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_oop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_validatefn:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_validatecl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_output:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwnotset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwarcset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_pwextset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_archivehint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_exthint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_setadvf:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_selpath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_separateerror:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_dirsize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_un7z_browse_flat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_7_updating:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_folders:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_advanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_plalways:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_6_plsmart:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_sessionio:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_advanced:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_basic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_cannotrun:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_custeditors:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_delete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_delete_fromarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_langflag:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_encpj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_execommand:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_langhint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_mini_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_offline_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_tray:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_remove:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_hintpaths:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_selectapp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_strafter:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_strbefore:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_encoding:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_5_nopw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_draghint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_tb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_adding:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_advclip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_yanswers:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_itemsheight:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_clearclipboard:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wcommons:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_copyfrom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_deletebookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_documents:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wenc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_extractfrom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_hexp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_operation:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_removefromclipboard:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_stdclip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_totalmem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_gvideo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wbook:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wnews:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wsrc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_4_wdict:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_pw_errorchar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_envstr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_never_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_home:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_on_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_test_pw100:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_2_3_test_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclude_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action_extopen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_passwordnotmatch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action_preview:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_preview_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_better:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_faster:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fastermem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tempdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_stream:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_slowermem:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_store:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_newfolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcodeunknown:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_isfolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s)); if txt_list_isfolder[1]<>' ' then txt_list_isfolder:=' '+txt_list_isfolder;
readln(t,s); txt_none:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode1:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attach10:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode255:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fat32:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dvd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attach5:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cd650:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode7:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cd700:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_7z:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dvddl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_7z_exitcode8:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_abort:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_about:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_action_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_existing_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_files:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_folder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_tolayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_toarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_tobookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_address_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_adv_filters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_algo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_default:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_type:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_date:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_psize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_attributes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_all_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_input_upx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_always_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ignore_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ignore_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ignore_sel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_key_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_timestamp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_appoptions:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_arc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_ok:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_interface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archivecreation:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tarbefore_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compressionratio_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archiving:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cl_long:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_overwrite_askbefore:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_associated:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attributes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_author:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ren_existing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ren_extracted:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_autofolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_back:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_backend:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_backupexe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_bettercompression:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_blogs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_blowfish:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_bookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_browse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_browser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_aborted_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_browsing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive_root:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_bzip2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pw_empty:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_add_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_failure:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_conf_cannotsave:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_check_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_check:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_check_select:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_clear:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_clearlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pj_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_autoclose:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compare:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compress:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compress_executable:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compress_openforwriting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compression:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compmanagement:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pw_confirm:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_console:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_console_interface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_content:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_controlpanel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_convert:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copyto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_title_create:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_keyfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_folder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_theme:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_rr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_create_sfx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cr_current:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_customapp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_custom_parameters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_customsize:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cut:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_datetime:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default_compression:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default_format:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_default:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_hard_reset_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_desktop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dictionary:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dirs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dis:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_disk_cleanup:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_disk_defrag:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_disk_management:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_dispaly:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_displayedmnu_obj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_displayedobjects:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nocompress:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_delete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_wipe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_done:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_edit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_elapsed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_emptycl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_encrypt:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_encrypted:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_encryption:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_note:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_random_keys:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_random_keys_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ent_tools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorlarger:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorrecent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_eqorsmaller:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_equal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_erase_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extraction_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclude_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclusion_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exclusion:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_overwrite_qry:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_confirm_overwrite:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_explore_outpath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_explore_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_extract:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_nopath:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_allhere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_allto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extopen_custom:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extopen_with:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_disp_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_disp_to:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_sel_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_sel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ext_sel_to:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extobj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_newfoldermenu:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_fast:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fastcompr:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fastopen:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_fastest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_favformats:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filebrowser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filetools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_files:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nfiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fs:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filters_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_flat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_flat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_floppy:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_foldername:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nfolders:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_input_multi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fwd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_free:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_free2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_name_full:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_function:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_general:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_multithreading:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_go_browser:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_go_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_guicl:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_guipealauncher:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_graphic:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_gridaltcolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_gridrowheight:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_gui:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_gzip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_here:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_history:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_homeroot:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_quickbrowse_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_backupexe_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_attach:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_images:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_include_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filters_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_inclusion_recourse:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_inclusion:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_function:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_info:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_infoall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_infodisp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_infosel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_inputinfo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_input_list:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_iop:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ipo:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_input:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_integrity:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_chunk_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_invertsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_exe:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_return_to_archive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_accessible:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_unsupported:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_checkname_failed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_accessible_list:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_create_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_exists:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_job_code:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_job_definition_saved:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_job_success:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_join:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_joinfiles:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile_not_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile_notcreated:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_larger:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_lastused:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_launch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_layout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_filelist_savedas:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_license:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_list:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_details:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_all:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_disp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_sel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toggle_warning:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_loadfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_loadlayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_hd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_localization:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_lpaqver:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_lpaq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_maininterface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_maxcomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_maximum:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_restartrequired:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_required_memory:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_method:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_misc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_modify:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_morecontrols:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_morerecent:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ent_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_moveto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_mypc:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_na:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_name:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_naming:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_remote:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_newarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cnewfolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_news:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_no:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nocompress_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_split_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_noinput:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_nomatch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_singlethread:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_none2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nonsolid:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_normal:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copy_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_description:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compare_second:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peaobj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_displayed_obj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_olderthan:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_on:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ondblclick:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_opacity:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_openarchive:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_title_open:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_bookmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cphere:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_files:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_open_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_opensource:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_openwith:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_aborted:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_cd:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_options:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_other:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_otherparams:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_oip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_opi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_output:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_overwrite:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_compressed_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_paqver:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_paq:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pio:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_poi:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_parameters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_partial:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_passes:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pwlength:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_pw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_browse_pw_other:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_paste:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_path:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pea_appcolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pea_textcolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_pea:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peazip_new:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peazip_help:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_peazip_web:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_performall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_name_provide:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_upxorstrip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_removable_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_not_removable:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_custom_executable_missing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_unsupported_select:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_no_theme_name:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_please_wait:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_copy_wait:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_previewwith:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_projectadmin:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_quad:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_quickdelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_quit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_ram:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_read:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_recentarchives:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_rr_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search_refine:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_fefreshf5:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_release:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_removable:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_remove_bookmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_remove_external_unit:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_removeselected:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_rename:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_repair:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_restartrequired2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_reset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_reset_archivename:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_hardreset:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_reset_theme:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_restore_att:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_run_as:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_run_as2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sample:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_saveas:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savehistory:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_save_infolder:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savejob:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savejobdefinition:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savejobdefinition_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_savelayout:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_save_winstate:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_searchanddrag:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_searchfor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_nrsearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_search_web:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_searching:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_securedelete:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_default_description:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selectall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selectdir:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selected_obj:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_selected_objects:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sfx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sendbymail:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_set_defaults:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_settings:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sfx_interface:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_showhints:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_show_messages:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_showpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_singlevol:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sizeb:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_skip_existing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_slowercomp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_smaller:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid_block:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid_auto:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_solid_extension:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_listtest:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sortbysel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_sorting:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_speed:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_split:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_split:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_split_file:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_list_nostats:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_status:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_store:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_stream_control:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_strip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_keyfile_created:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_suggestpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_noupx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_syntax:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_sysbenchmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_benchmark:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_systools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tarbefore:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_tar:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_taskman:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_caption_test:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testall:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testdisp:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testpw:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_testsel:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_col_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_bookmarks_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_archive_noinput_tolist:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_icons_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_themename:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_icons_not_found:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theme_create_success:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_theming:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_extand_error:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_threads:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_titlescolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_to:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toggle_browseflat:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toggle_historybookmarks:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_toolbarscolor:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_tools:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_best:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_level_ultra:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_error_openfile:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_cl_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ace_missing:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_units:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_unit_unknown:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_un7z_pw_untested:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_up:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_update:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_upx:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_advfilters:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_openfiles_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_usenet:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_user_name:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_using:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_volumepea:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_volume_size:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_ext_uns:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_websearch:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_websites:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_word:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_write:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_ramdompw_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_exe_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_pj_hint2:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_type_description_zip:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s); txt_zipcrypto_hint:=copy(s,pos(':',s)+2,length(s)-pos(':',s));
readln(t,s);
readln(t,s); if s<>'=== end PeaZip text group ===' then exit;
valorize_text:=0;
except
valorize_text:=-1;
end;
end;

procedure dosearchtext;
begin
FormPeach.EditOptSearch.Items.Clear;
FormPeach.EditOptSearch.Items.Add(txt_general);
FormPeach.EditOptSearch.Items.Add(txt_localization);
FormPeach.EditOptSearch.Items.Add(txt_9_2_tfaq);
FormPeach.EditOptSearch.Items.Add(txt_3_1_languagetools);
{$IFDEF MSWINDOWS}
FormPeach.EditOptSearch.Items.Add(txt_3_0_configure);
FormPeach.EditOptSearch.Items.Add(txt_6_8_ndrop);
FormPeach.EditOptSearch.Items.Add(txt_7_8_dd);
{$ENDIF}
FormPeach.EditOptSearch.Items.Add(txt_5_0_perf);
FormPeach.EditOptSearch.Items.Add(txt_8_1_bo);
FormPeach.EditOptSearch.Items.Add(txt_10_6_virtual);
FormPeach.EditOptSearch.Items.Add(txt_6_5_privacy);
FormPeach.EditOptSearch.Items.Add(txt_3_1_workingdir);
FormPeach.EditOptSearch.Items.Add(txt_reset);
FormPeach.EditOptSearch.Items.Add(txt_2_6_advanced);
FormPeach.EditOptSearch.Items.Add(txt_2_5_encoding);
FormPeach.EditOptSearch.Items.Add(txt_7_6_zipenc);
FormPeach.EditOptSearch.Items.Add(txt_3_1_sccenc);
FormPeach.EditOptSearch.Items.Add(txt_path);
FormPeach.EditOptSearch.Items.Add(txt_3_2_conf);
FormPeach.EditOptSearch.Items.Add(txt_3_3_apppath);
FormPeach.EditOptSearch.Items.Add(txt_5_9_start);
FormPeach.EditOptSearch.Items.Add(txt_backend);
FormPeach.EditOptSearch.Items.Add(txt_9_5_sb);
FormPeach.EditOptSearch.Items.Add(txt_9_1_7zs);
FormPeach.EditOptSearch.Items.Add(txt_9_2_7za);
{$IFNDEF MSWINDOWS}
FormPeach.EditOptSearch.Items.Add(txt_8_3_maxarg);
{$ENDIF}
FormPeach.EditOptSearch.Items.Add(txt_4_6_am);
FormPeach.EditOptSearch.Items.Add(txt_6_9_autou);
FormPeach.EditOptSearch.Items.Add(txt_8_0_forcebrowse);
FormPeach.EditOptSearch.Items.Add(txt_6_6_forcemodify);
FormPeach.EditOptSearch.Items.Add(txt_6_5_force);
FormPeach.EditOptSearch.Items.Add(txt_8_0_defaultaction);
FormPeach.EditOptSearch.Items.Add(txt_2_9_tree);
FormPeach.EditOptSearch.Items.Add(txt_8_0_setpwopt);
FormPeach.EditOptSearch.Items.Add(txt_pw);
FormPeach.EditOptSearch.Items.Add('TAR');
FormPeach.EditOptSearch.Items.Add(txt_7_0_autoopentar);
FormPeach.EditOptSearch.Items.Add(txt_9_0_autoexttar);
FormPeach.EditOptSearch.Items.Add(txt_8_7_after);
FormPeach.EditOptSearch.Items.Add(txt_7_3_noconfdel);
FormPeach.EditOptSearch.Items.Add(txt_2_7_oop);
FormPeach.EditOptSearch.Items.Add(txt_8_8_autotest);
FormPeach.EditOptSearch.Items.Add(txt_archive);
FormPeach.EditOptSearch.Items.Add(txt_default_format);
FormPeach.EditOptSearch.Items.Add(txt_7_4_setarc);
FormPeach.EditOptSearch.Items.Add(txt_caption_extract);
FormPeach.EditOptSearch.Items.Add(txt_5_5_intdir);
FormPeach.EditOptSearch.Items.Add(txt_7_5_ee);
FormPeach.EditOptSearch.Items.Add(txt_7_4_setext);
FormPeach.EditOptSearch.Items.Add(txt_4_6_fm);
FormPeach.EditOptSearch.Items.Add(txt_browser);
FormPeach.EditOptSearch.Items.Add(txt_filebrowser);
FormPeach.EditOptSearch.Items.Add(txt_10_5_sectype);
FormPeach.EditOptSearch.Items.Add(txt_filetools);
FormPeach.EditOptSearch.Items.Add(txt_check_select);
FormPeach.EditOptSearch.Items.Add(txt_securedelete);
FormPeach.EditOptSearch.Items.Add(txt_3_3_apps);
FormPeach.EditOptSearch.Items.Add(txt_theme);
FormPeach.EditOptSearch.Items.Add(txt_3_5_td);
FormPeach.EditOptSearch.Items.Add(txt_create_theme);
FormPeach.EditOptSearch.Items.Add(txt_7_9_zooming);
FormPeach.EditOptSearch.Items.Add(txt_2_5_help);
FormPeach.EditOptSearch.Items.Add(txt_2_5_help);
FormPeach.EditOptSearch.Items.Add(txt_peazip_help);
FormPeach.EditOptSearch.Items.Add('FAQ');
FormPeach.EditOptSearch.Items.Add(txt_3_7_tracker);
FormPeach.EditOptSearch.Items.Add(txt_9_2_changelog);
FormPeach.EditOptSearch.Items.Add(txt_2_5_offline_help);
FormPeach.EditOptSearch.Items.Add(txt_about);
FormPeach.EditOptSearch.Items.Add(txt_4_5_update);
FormPeach.EditOptSearch.Items.Add(txt_7_8_update);
FormPeach.EditOptSearch.Items.Add(txt_5_5_plugin);
FormPeach.EditOptSearch.Items.Add(txt_8_7_verifybin);
FormPeach.EditOptSearch.Items.Add(txt_4_3_pwman);
FormPeach.EditOptSearch.Items.Add(txt_keyfile);
FormPeach.EditOptSearch.Items.Add(txt_4_7_pk);
FormPeach.EditOptSearch.Items.Add(txt_8_5_samplescripts);
FormPeach.EditOptSearch.Items.Add(txt_4_5_pj);
end;

procedure assign_guitext; //set text
var
   i:integer;
begin
FormPeach.Caption:=APPMAIN;
with FormPeach do
begin
try
dosearchtext;
csbroot.Hint:=txt_mypc;
csbhome.Hint:=txt_2_9_home;
csbdesk.Hint:=txt_desktop;
csbdownloads.Hint:=txt_3_1_downloads;
csbdoc.Hint:=txt_2_4_documents;
csbmusic.Hint:=txt_5_0_music;
csbpic.Hint:=txt_5_0_pictures;
csbvid.Hint:=txt_5_0_videos;
cbRARmanual.Caption:=txt_9_3_mrar;
Labelsetwork.Caption:=txt_settings+' > '+txt_3_1_workingdir;
pmtoolsmall.Caption:=txt_2_9_st;
LabelAddressBar.Caption:=txt_2_9_address;
cbSolidAddress.Items.Clear;
cbSolidAddress.Items.Add(txt_8_8_cw);
cbSolidAddress.Items.Add(txt_8_8_cb+' / '+txt_8_8_light);
cbSolidAddress.Items.Add(txt_8_8_cb);
cbSolidAddress.Items.Add(txt_8_8_cb+' / '+txt_7_6_dim);
cbSolidAddress.Items.Add(txt_8_8_cb+' / '+txt_7_6_dark);
cbSolidAddress.Items.Add(txt_8_8_ca+' / '+txt_8_8_light);
cbSolidAddress.Items.Add(txt_8_8_ca);
cbSolidAddress.Items.Add(txt_8_8_ca+' / '+txt_7_6_dim);
cbSolidAddress.Items.Add(txt_8_8_ca+' / '+txt_7_6_dark);
CheckBoxCenteredToolbar.Caption:=txt_8_8_centered;
CheckBoxsnzExt.Caption:=txt_8_8_snz;
CheckBoxsnoi.Caption:=txt_8_8_snoi;
CheckBoxsnon.Caption:=txt_8_8_snon;
CheckBoxZstdErrPolicy.Caption:=txt_10_7_keep;
LabelColorAddressbar.Caption:=txt_8_8_solcol;
LabelTabsStyle.Caption:=txt_8_8_altt;
cbAltTabStyle.Items.Clear;
cbAltTabStyle.Items.Add(txt_8_8_btn);
cbAltTabStyle.Items.Add(txt_8_8_lnk);
cbAltTabStyle.Items.Add(txt_8_8_tab);
cbAltTabStyle.Items.Add(txt_8_8_btn+' / '+txt_9_6_centered);
cbAltTabStyle.Items.Add(txt_8_8_lnk+' / '+txt_9_6_centered);
cbAltTabStyle.Items.Add(txt_8_8_tab+' / '+txt_9_6_centered);
LabelColorToolBar.Caption:=txt_2_9_toolbar;
cbAltTabs.Items.Clear;
cbAltTabs.Items.Add(txt_8_8_cw+' + '+txt_8_8_cb);
cbAltTabs.Items.Add(txt_8_8_cw+' + '+txt_8_8_ca);
cbAltTabs.Items.Add(txt_8_8_cb);
cbAltTabs.Items.Add(txt_8_8_cb+' / '+txt_7_6_dim);
cbAltTabs.Items.Add(txt_8_8_ca);
cbAltTabs.Items.Add(txt_8_8_ca+' / '+txt_7_6_dim);
cbAccentToolBar.Items.Clear;
cbAccentToolBar.Items.Add(txt_8_8_cw);
cbAccentToolBar.Items.Add(txt_8_8_cb+' / '+txt_8_8_light);
cbAccentToolBar.Items.Add(txt_8_8_cb);
cbAccentToolBar.Items.Add(txt_8_8_cb+' / '+txt_7_6_dim);
cbAccentToolBar.Items.Add(txt_8_8_cb+' / '+txt_7_6_dark);
cbAccentToolBar.Items.Add(txt_8_8_ca+' / '+txt_8_8_light);
cbAccentToolBar.Items.Add(txt_8_8_ca);
cbAccentToolBar.Items.Add(txt_8_8_ca+' / '+txt_7_6_dim);
cbAccentToolBar.Items.Add(txt_8_8_ca+' / '+txt_7_6_dark);
cbAltBar.Items.Clear;
cbAltBar.Items.Add(txt_8_8_cw+' + '+txt_8_8_cb);
cbAltBar.Items.Add(txt_8_8_cw+' + '+txt_8_8_ca);
cbAltBar.Items.Add(txt_8_8_cb);
cbAltBar.Items.Add(txt_8_8_ca);
cbBoxAltBarStyle.Items.Clear;
cbBoxAltBarStyle.Items.Add(txt_2_9_none);
cbBoxAltBarStyle.Items.Add(txt_10_1_under);
cbBoxAltBarStyle.Items.Add(txt_10_1_full);
LabelmoreoptExt.Caption:=txt_8_7_mo;
LabelmoreoptAdd.Caption:=txt_8_7_mo;
LabelFileSize.Caption:=txt_all_size;
Labeloptsub8.Caption:=txt_filebrowser;
MenuItemOpen_run.Caption:=txt_3_3_run;
owrun.Caption:=txt_3_3_run;
eowrun.Caption:=txt_3_3_run;
powrun.Caption:=txt_3_3_run;
pmmorerr.Caption:=txt_rr;
po_rr.Caption:=txt_rr;
cbRARlock.Caption:=txt_7_4_lock;
CheckBoxNoConf.Caption:=txt_7_3_noconfdel;
CheckBoxzipxswitch.Caption:=txt_7_4_swzipx;
CheckBoxAC.Caption:=txt_9_1_ac;
CheckBoxBrotli.Caption:=txt_7_3_maxbr;
CheckBoxZstd.Caption:=txt_7_3_maxzstd;
CheckBoxstl.Caption:=txt_7_3_stl;
mdirbeforefiles.Caption:=txt_9_0_df;
CheckBoxssp.Caption:=txt_9_0_accesstime;
Label7zMemuse.Caption:=txt_9_0_mem;
CheckBoxsnh.Caption:=txt_9_0_hl;
CheckBoxsnl.Caption:=txt_9_0_sl;
cbtimecreated.Caption:=txt_8_2_alltimes;
cbtimecreated.Hint:=txt_8_2_supportedby+' 7Z, RAR, TAR/pax, ZIP';
CheckBoxsni.Caption:=txt_6_5_sni+' (WIM)';
CheckBoxsniExt.Caption:=txt_6_5_sni+' (WIM)';
CheckBoxsns.Caption:=txt_6_5_sns+' (WIM)';
CheckBoxsnsExt.Caption:=txt_6_5_sns+' (WIM)';
ComboBoxprivacy.Items.Clear;
ComboBoxprivacy.Items.Add(txt_6_5_nop);
ComboBoxprivacy.Items.Add(txt_6_5_askp);
ComboBoxprivacy.Items.Add(txt_6_5_askp+' '+txt_6_5_mandatory);
mtabs.Caption:=txt_6_4_tabbar;
pmhtabs.Caption:=txt_6_4_tabbar;
pmhnewtab.Caption:=txt_6_4_openintab;
pmbcnw.Caption:=txt_9_1_nw;
MenuItemInfo.Caption:=txt_path+' / '+txt_info;
MenuItemInfomenu.Caption:=txt_path+' / '+txt_info;
MenuItemToggleNav.Caption:=txt_9_0_tnav+' (Alt+4)';
MenuItemToggleStatus.Caption:=txt_toggle_historybookmarks+' (Alt+8)';
pmtabsm.Caption:=txt_6_4_tabbar;
pmtabsnew.Caption:=txt_6_4_openintab;
pmtabsclose.Caption:=txt_3_6_close;
pmtabscloseother.Caption:=txt_6_4_closeallother;
pmtabscloseright.Caption:=txt_6_4_closeright;
pmtabscloseall.Caption:=txt_9_1_closeall;
pmtabscollapse.Caption:=txt_6_4_collapse;
pmtabsexpand.Caption:=txt_6_4_expand;
po_tabsopen.Caption:=txt_6_4_openintab;
po_windowopen.Caption:=txt_9_1_nw;
pmtabsnewwindow.Caption:=txt_9_1_nw;
pmtabsreopen.Caption:=txt_9_5_reopentab;
pmtabsbook.Caption:=txt_bookmarks;
pmtabsbookmarkadd.Caption:=txt_add_tobookmarks;
pmtabsbookmarkorg.Caption:=txt_2_9_organize+' '+txt_bookmarks;
pmsaveas.Caption:=txt_path+' / '+txt_saveas;
MenuItemOpen_saveas.Caption:=txt_path+' / '+txt_saveas;
po_analyze.Caption:=txt_5_9_lff;
MenuItemToolAnalyze.Caption:=txt_5_9_lff;
pmmoreanalysis.Caption:=txt_5_9_lff;
pmfilebrowser.caption:=txt_filebrowser;
ComboBoxLibre.Items.Clear;
ComboBoxLibre.Items.Add(txt_5_8_l0);
ComboBoxLibre.Items.Add(txt_5_8_l1);
ComboBoxLibre.Items.Add(txt_5_8_l2);
po_selectadv.Caption:=txt_5_5_select+'...';
pmrselect.Caption:=txt_5_5_select+'...';
pmselectadv.Caption:=txt_5_5_select+'...';
mselectadv.Caption:=txt_5_5_select+'...';
po_copypath.Caption:=txt_5_5_copypath;
pmhcopypath.Caption:=txt_5_5_copypath;
org_autoadjust.Caption:=txt_6_3_autoadjust+' (Ctrl+Alt+A)';
mautoadjust.Caption:=txt_6_3_autoadjust;
msmartsort.Caption:=txt_9_7_smartsorting;
pmcname.Caption:=txt_name;
pmctype.Caption:=txt_type;
pmcsize.Caption:=txt_size;
pmcpacked.Caption:=txt_info+' / '+txt_compressed_size;
pmcdate.Caption:=txt_8_2_tm;
pmcatt.Caption:=txt_attributes;
pmccrc.Caption:='CRC32';
pmcfree.Caption:=txt_free;
pmcpypath.caption:=txt_5_5_copypath;
pmcopypath.caption:=txt_5_5_copypath;
mDateYear.Caption:=txt_5_5_dateyear;
mDateMonth.Caption:=txt_5_5_datemonth;
mDateWeek.Caption:=txt_5_5_dateweek;
mDateDay.Caption:=txt_5_5_dateday;
mDateHour.Caption:=txt_5_5_datehour;
msameyear.Caption:=txt_5_5_datesameyear;
msamemonth.Caption:=txt_5_5_datesamemonth;
msameweek.Caption:=txt_5_5_datesameweek;
msameday.Caption:=txt_5_5_datesameday;
msamehour.Caption:=txt_5_5_datesamehour;
po_rename_delete.Caption:=txt_5_5_delete;
po_rename_add.Caption:=txt_5_5_add;
po_rename_cutlen.Caption:=txt_7_5_cutlen;
po_rename_ascii.Caption:=txt_7_5_repnascii;
po_rename_lowercase.Caption:=txt_5_5_lower;
po_rename_filesonly.Caption:=txt_7_1_renfilesonly;
pmr_files.Caption:=txt_7_1_renfilesonly;
po_rename_uppercase.Caption:=txt_5_5_upper;
po_rename_timestamp.Caption:=txt_timestamp;
po_rename_appenddir.Caption:=txt_6_4_appdirn;
po_rename_prependdir.Caption:=txt_6_4_prepdirn;
po_rename_replace.Caption:=txt_5_5_replacestr;
po_rename_replace_case.Caption:=txt_5_5_replacestr+' '+txt_5_5_case;
po_rename_ext.Caption:=txt_5_5_ext;
pmr_delete.Caption:=txt_5_5_delete;
pmr_add.Caption:=txt_5_5_add;
pmr_lowercase.Caption:=txt_5_5_lower;
pmr_uppercase.Caption:=txt_5_5_upper;
pmr_replace.Caption:=txt_5_5_replacestr;
pmr_replacecase.Caption:=txt_5_5_replacestr+' '+txt_5_5_case;
pmr_ext.Caption:=txt_5_5_ext;
pmr_appendts.Caption:=txt_timestamp;
pmr_appenddirname.Caption:=txt_6_4_appdirn;
pmr_prependdirname.Caption:=txt_6_4_prepdirn;
pmr_cut.Caption:=txt_7_5_cutlen;
pmr_ascii.Caption:=txt_7_5_repnascii;
CheckBoxAutoHaltA.Caption:=txt_5_5_halt;
CheckBoxAutoHaltE.Caption:=txt_5_5_halt;
po_zerofile.Caption:=txt_5_2_zerofiles+' (Alt+Del)';
pmzerofile.Caption:=txt_5_2_zerofiles+' (Alt+Del)';
po_zerofree.Caption:=txt_5_2_zerofree;
pmzerofree.Caption:=txt_5_2_zerofree;
po_securedeletefree.Caption:=txt_5_2_securedeletefree;
pmsecuredeletefree.Caption:=txt_5_2_securedeletefree;
mscheduledscripts.Caption:=txt_5_1_schedscripts;
mtaskscheduler.Caption:=txt_5_1_ts;
po_task.Caption:=txt_5_1_ts;
schedulepasswordext.Caption:=txt_pw;
scheduleuserext.Caption:=txt_run_as2;
BScheduleExt.Caption:=txt_5_1_schedadd;
scheduleendext.Caption:=txt_5_1_enddate;
LabelEveryExt.Caption:=txt_5_1_every;
LmanagescheduleExt2.Caption:=txt_5_1_schedmanage;
LmanagescheduleExt1.Caption:=txt_5_1_scriptmanage;
CheckGroupMExt.Caption:=txt_5_1_months;
lse2.Caption:=txt_5_1_schedule;
lse3.Caption:=txt_5_1_starttime;
PanelClickAddress.Hint:=txt_7_1_typetosearch;
ImageInfoSchedExt.Hint:=txt_5_1_schedexplain;
schedulestartext.Caption:=txt_5_1_startdate;
lse1.Caption:=txt_5_1_schedname;
CheckGroupMExt.Checked[0]:=true;
CheckGroupMExt.Checked[1]:=true;
CheckGroupMExt.Checked[2]:=true;
CheckGroupMExt.Checked[3]:=true;
CheckGroupMExt.Checked[4]:=true;
CheckGroupMExt.Checked[5]:=true;
CheckGroupMExt.Checked[6]:=true;
CheckGroupMExt.Checked[7]:=true;
CheckGroupMExt.Checked[8]:=true;
CheckGroupMExt.Checked[9]:=true;
CheckGroupMExt.Checked[10]:=true;
CheckGroupMExt.Checked[11]:=true;
lsadayExt.Caption:=txt_5_1_day;
ComboBoxMExt.Items.Clear;
for i:=1 to 31 do ComboBoxMExt.Items.Add(inttostr(i));
ComboBoxMExt.Items.Add(txt_5_1_last);
CheckGroupWExt.Caption:=txt_5_1_days;
CheckGroupWExt.Items.Clear;
CheckGroupWExt.Items.Add(txt_5_1_w1);
CheckGroupWExt.Items.Add(txt_5_1_w2);
CheckGroupWExt.Items.Add(txt_5_1_w3);
CheckGroupWExt.Items.Add(txt_5_1_w4);
CheckGroupWExt.Items.Add(txt_5_1_w5);
CheckGroupWExt.Items.Add(txt_5_1_w6);
CheckGroupWExt.Items.Add(txt_5_1_w7);
CheckGroupWExt.Checked[1]:=true;
CheckGroupWExt.Checked[2]:=true;
CheckGroupWExt.Checked[3]:=true;
CheckGroupWExt.Checked[4]:=true;
CheckGroupWExt.Checked[5]:=true;
SchedAddscheduleExt.Items.Clear;
SchedAddscheduleExt.Items.Add(txt_5_1_hourly);
SchedAddscheduleExt.Items.Add(txt_5_1_daily);
SchedAddscheduleExt.Items.Add(txt_5_1_weekly);
SchedAddscheduleExt.Items.Add(txt_5_1_monthly);
SchedAddscheduleExt.Items.Add(txt_5_1_once);
{schedaddschedule.Items.Add(txt_5_1_onstart);
schedaddschedule.Items.Add(txt_5_1_onlogin);}//works only as admin
schedulepassword.Caption:=txt_pw;
scheduleuser.Caption:=txt_run_as2;
Bschedule.Caption:=txt_5_1_schedadd;
scheduleend.Caption:=txt_5_1_enddate;
labelevery.Caption:=txt_5_1_every;
Lmanageschedule2.Caption:=txt_5_1_schedmanage;
Lmanageschedule1.Caption:=txt_5_1_scriptmanage;
CheckGroupM1.Caption:=txt_5_1_months;
lsa2.Caption:=txt_5_1_schedule;
lsa3.Caption:=txt_5_1_starttime;
ImageInfoSchedAdd.Hint:=txt_5_1_schedexplain;
schedulestart.Caption:=txt_5_1_startdate;
lsa1.Caption:=txt_5_1_schedname;
CheckGroupM1.Checked[0]:=true;
CheckGroupM1.Checked[1]:=true;
CheckGroupM1.Checked[2]:=true;
CheckGroupM1.Checked[3]:=true;
CheckGroupM1.Checked[4]:=true;
CheckGroupM1.Checked[5]:=true;
CheckGroupM1.Checked[6]:=true;
CheckGroupM1.Checked[7]:=true;
CheckGroupM1.Checked[8]:=true;
CheckGroupM1.Checked[9]:=true;
CheckGroupM1.Checked[10]:=true;
CheckGroupM1.Checked[11]:=true;
lsaday.Caption:=txt_5_1_day;
ComboBoxM2.Items.Clear;
for i:=1 to 31 do ComboBoxM2.Items.Add(inttostr(i));
ComboBoxM2.Items.Add(txt_5_1_last);
CheckGroupW.Caption:=txt_5_1_days;
CheckGroupW.Items.Clear;
CheckGroupW.Items.Add(txt_5_1_w1);
CheckGroupW.Items.Add(txt_5_1_w2);
CheckGroupW.Items.Add(txt_5_1_w3);
CheckGroupW.Items.Add(txt_5_1_w4);
CheckGroupW.Items.Add(txt_5_1_w5);
CheckGroupW.Items.Add(txt_5_1_w6);
CheckGroupW.Items.Add(txt_5_1_w7);
CheckGroupW.Checked[1]:=true;
CheckGroupW.Checked[2]:=true;
CheckGroupW.Checked[3]:=true;
CheckGroupW.Checked[4]:=true;
CheckGroupW.Checked[5]:=true;
schedaddschedule.Items.Clear;
schedaddschedule.Items.Add(txt_5_1_hourly);
schedaddschedule.Items.Add(txt_5_1_daily);
schedaddschedule.Items.Add(txt_5_1_weekly);
schedaddschedule.Items.Add(txt_5_1_monthly);
schedaddschedule.Items.Add(txt_5_1_once);
{schedaddschedule.Items.Add(txt_5_1_onstart);
schedaddschedule.Items.Add(txt_5_1_onlogin);}//works only as admin
ButtonUn7zaTo.Hint:=txt_ext_sel;
ButtonUn7zaTest.Hint:=txt_caption_test;
ButtonUn7zaConvert.Hint:=txt_2_8_convert;
pmjumpmusic.caption:=txt_5_0_music;
pmjumppictures.caption:=txt_5_0_pictures;
pmjumpvideos.caption:=txt_5_0_videos;
MenuItemArchive_music.caption:=txt_5_0_music;
MenuItemArchive_pictures.caption:=txt_5_0_pictures;
MenuItemArchive_videos.caption:=txt_5_0_videos;
MenuItemOpen_music.caption:=txt_5_0_music;
MenuItemOpen_pictures.caption:=txt_5_0_pictures;
MenuItemOpen_videos.caption:=txt_5_0_videos;
pmbc.caption:=txt_list_history;
pmhbc0.caption:=txt_5_0_bc;
pmnavbc0.caption:=txt_5_0_bc;
mbc0.caption:=txt_5_0_bc;
pnbc0.caption:=txt_5_0_bc;
pnabc0.caption:=txt_5_0_bc;
mhistory0s.Caption:=txt_5_0_sh;
pmh0s.Caption:=txt_5_0_sh;
pnh0s.Caption:=txt_5_0_sh;
pnha0s.Caption:=txt_5_0_sh;
mrecent0.Caption:=txt_list_history;
pmhr0.Caption:=txt_list_history;
pnr0.Caption:=txt_list_history;
pnra0.Caption:=txt_list_history;
mrecent0.visible:=false;
pmhr0.visible:=false;
pnr0.visible:=false;
pnra0.visible:=false;
po_more.Caption:=txt_algo;
po_sysmore.Caption:=txt_3_1_more;
menuitemopen_powershell.Caption:=txt_5_0_ps;
MenuItemPowerShell.Caption:=txt_5_0_ps;
pmpowershell.Caption:=txt_5_0_ps;
mb0.Caption:=txt_add_tobookmarks;
mb24.Caption:=txt_2_9_organize+' '+txt_bookmarks;
mwebs.Caption:=txt_search_web;
po_im.Caption:=txt_4_8_imagemanager;
MenuItemForceThumbnails.Caption:=txt_10_7_thumbnails;
MenuItemViewImage.Caption:=txt_10_7_images;
po_im_rl.Caption:=txt_4_8_rl;
po_im_rr.Caption:=txt_4_8_rr;
po_im_crop.Caption:=txt_4_8_crop;
po_im_modify.Caption:=txt_4_8_t;
pmstylepresets.Caption:=txt_4_9_style;
pmspminimal.Caption:=txt_10_3_minimal;
pmspclassic.Caption:=txt_10_3_classic;
pmspmodern.Caption:=txt_10_3_m;
pmsppostmodern.Caption:=txt_10_3_pm;
msamplescripts.Caption:=txt_8_5_samplescripts;
imagesp.Hint:=txt_2_9_navbar;
pmsizesmall.Caption:='(16 / 48) '+txt_2_9_st;
pmsizemedium.Caption:='(24 / 64) '+txt_2_9_mt;
mfilebrowser.Caption:=txt_filebrowser;
pmsizelarge.Caption:='(32 / 72) '+txt_2_9_lt;
pmsizelargep.Caption:='(48 / 96) '+txt_2_9_lt+' +';
pmsizelargepp.Caption:='(64 / 128) '+txt_2_9_lt+' ++';
pmsizelargeppp.Caption:='(72 / 144) '+txt_2_9_lt+' +++';
pmsizelargepppp.Caption:='(96 / 192) '+txt_2_9_lt+' ++++';
pmif1.Caption:=txt_4_8_fit+' 1024 x 768 (4:3) XGA, iPad';
po_im_1024.Caption:=txt_4_8_fit+' 1024 x 768 (4:3) XGA, iPad';
pmif2.Caption:=txt_4_8_fit+' 1280 x 800 (16:10) WXGA, Nexus';
pmif3.Caption:=txt_4_8_fit+' 1920 x 1080 (16:9) FullHD';
po_im_hd.Caption:=txt_4_8_fit+' 1920 x 1080 (16:9) FullHD';
pmif4.Caption:=txt_4_8_fit+' 1920 x 1200 (16:10) WUXGA';
po_im_wuxga.Caption:=txt_4_8_fit+' 1920 x 1200 (16:10) WUXGA';
pmif5.Caption:=txt_4_8_fit+' 2048 x 1536 (4:3) iPad Retina';
pmif6.Caption:=txt_4_8_fit+' 4K UHD 3840 x 2160 (16:9) 8.3MP';
po_im_4ktv.Caption:=txt_4_8_fit+' 4K UHD 3840 x 2160 (16:9) 8.3MP';
pmif7.Caption:=txt_4_8_fit+' 4K DCI 4096 x 2160 (19:10) 8.8MP';
po_im_4kcinema.Caption:=txt_4_8_fit+' 4K DCI 4096 x 2160 (19:10) 8.8MP';
pmif8.Caption:=txt_4_8_fit+' 8K FUHD 7680 x 4320 (16:9) 33.2MP';
pmirflip.Caption:=txt_4_8_flip;
pmirmirror.Caption:=txt_4_8_mirror;
modock.Caption:=txt_4_5_dock;
pmstyle1.Caption:=txt_4_8_detailsno;
pmstyle3.Caption:=txt_4_8_listno;
pmstyle5.Caption:=txt_3_4_smallicons;
pmshowmainmenu.Caption:=txt_9_0_showmainmenu;
pmshowstylemenu.Caption:=txt_8_7_showsm;
po_showquicknavmenu.Caption:=txt_9_0_navmenu;
MenuItemShowColMenu.Caption:=txt_8_7_showhm;
pmtool1.Caption:=txt_4_6_am;
pmtool2.Caption:=txt_4_6_fm;
pmtool3.Caption:=txt_4_8_imagemanager;
pmsnav.Caption:=txt_2_9_nav;
pmstree.Caption:=txt_2_9_tree;
pmscompact.Caption:=txt_9_2_compact;
MenuItemTB.Caption:=txt_2_9_toolbar;
pmtoollarge.Caption:=txt_2_9_lt;
pmtoolmedium.Caption:=txt_2_9_mt;
pmtoolnone.Caption:=txt_2_9_none;
pmsnone.Caption:=txt_2_9_none;
pmstatusnone.Caption:=txt_2_9_none;
pmsno.Caption:=txt_2_9_none;
pmtab.Caption:=txt_6_4_tabbar;
mtab.Caption:=txt_6_4_tabbar;
pmrow.Caption:=txt_2_8_rowselect;
pmthemes.Caption:=txt_settings;
mzoom.Caption:=txt_7_9_zooming;
motl.Caption:=txt_4_5_t+'-'+txt_4_5_l;
mot.Caption:=txt_4_5_t;
motr.Caption:=txt_4_5_t+'-'+txt_4_5_r;
mor.Caption:=txt_4_5_r;
mobr.Caption:=txt_4_5_b+'-'+txt_4_5_r;
mob.Caption:=txt_4_5_b;
mobl.Caption:=txt_4_5_b+'-'+txt_4_5_l;
mol.Caption:=txt_4_5_l;
modefault.Caption:=txt_level_normal;
mfullscreen.Caption:=txt_4_8_fullscreen;
mimmersive.Caption:=txt_4_8_immersive;
po_flat.caption:=txt_toggle_browseflat;
mdownloadthemes.caption:=txt_3_5_td;
pmopenout.caption:=txt_2_7_oop;
mtoggleop.caption:=txt_2_7_oop;
pmqenopath.caption:=txt_3_4_nopaths;
pmqen1.caption:=txt_skip_existing;
pmqen2.caption:=txt_ren_extracted;
pmqen3.caption:=txt_ren_existing;
pmqen4.caption:=txt_overwrite;
pmqen5.caption:=txt_overwrite_askbefore;
pmqenewfolder.caption:=txt_newfoldermenu+' (Ctrl+N)';
pmqnointdir.caption:=txt_5_5_intdir;
CheckBoxSmartFolder.caption:=txt_5_5_intdir;
MenuItemExtAllTo.caption:=txt_extto;
mextto.caption:=txt_extto;
mexttohistory.caption:=txt_list_history;
mexttos0.caption:=txt_5_0_sh;
mexttoc0.caption:=txt_5_0_bc;
pmextherehere.caption:=txt_ext_here;
pmextheresmart.caption:=txt_9_8_fsmart;
pmextherenew.caption:=txt_9_8_fnew;
MenuItemExtAllHere.caption:=txt_ext_here;
LabelExtHere.Caption:=txt_ext_here;
MenuItemExtAllHereSmart.caption:=txt_9_8_fsmart;
MenuItemExtAllHereNew.caption:=txt_9_8_fnew;
pmintddhere.Caption:=txt_ext_here;
pmintddsmart.caption:=txt_9_8_fsmart;
pmintddnew.caption:=txt_9_8_fnew;
po_addsep.caption:=txt_2_7_separate;
mmore.Caption:=txt_3_1_more;
pmqeto.caption:=txt_ext_allto+'... (Ctrl+Alt+E / F12)';
pmqehere.caption:=txt_ext_allhere+' (Ctrl+Shift+Alt+E)';
pmqeheresmart.caption:=txt_7_1_smart+' (Ctrl+Shift+Alt+S)';
pmqeherenew.caption:=txt_7_1_new+' (Ctrl+Shift+Alt+N)';
pmqedesk.caption:=txt_ext_allto+' '+txt_desktop+' (Ctrl+Alt+D)';
pmqedocuments.caption:=txt_ext_allto+' '+txt_2_4_documents+' (Ctrl+Shift+Alt+D)';
mSystemIntegration.caption:=txt_3_0_configure;
mbreset.caption:=txt_5_0_removeall;
LabelTitleOptions5.Caption:=txt_3_3_apps+'   ';
LabelTitleOptions5.Hint:=txt_openwith+' / '+txt_previewwith;
LabelTitleOptions6.Caption:=txt_theme+'   ';
BtnStyle.hint:=txt_4_9_style;
imageflat.hint:=txt_4_9_style;
morganize.Caption:=txt_2_9_organize;
mlayout.Caption:=txt_layout;
pmmstatus_status.Caption:=txt_2_8_statusbar;
pmsstatus.Caption:=txt_2_8_statusbar;
pmmstatus_bookmarks.Caption:=txt_bookmarks;
pmmstatus_ra.Caption:=txt_list_history;
pmmstatus_r.Caption:=txt_5_0_sh;
pmmstatus_clipboard.Caption:=txt_2_7_clipboard;
pmclip.Caption:=txt_2_7_clipboard;
po_clip.Caption:=txt_2_7_clipboard;
pmsbookmarks.Caption:=txt_bookmarks;
pmshistory.Caption:=txt_list_history;
pmssession.Caption:=txt_5_0_sh;
pmsclipboard.Caption:=txt_2_7_clipboard;
pms2a_add.Caption:=txt_add_toarchive;
pms2a_ext.Caption:=txt_caption_extract;
pms2a_copy.Caption:=txt_2_9_copyhere;
pms2a_move.Caption:=txt_2_9_movehere;
pms2a_open.Caption:=txt_openarchive;
pms2a_cancel.Caption:=txt_2_7_cancel;
pma2s_copy.Caption:=txt_2_9_copyhere;
pma2s_move.Caption:=txt_2_9_movehere;
pma2s_extract.Caption:=txt_ext_here;
pma2s_extnew.Caption:=txt_ext_here+' '+txt_newfolder;
pma2s_cancel.Caption:=txt_2_7_cancel;
pma2s_extract1.Caption:=txt_ext_sel_here;
pma2s_extractall1.Caption:=txt_ext_allhere;
pma2s_extnew1.Caption:=txt_ext_sel_here+' '+txt_newfolder;
pma2s_extallnew1.Caption:=txt_ext_allhere+' '+txt_newfolder;
pma2s_cancel1.Caption:=txt_2_7_cancel;
mopenasarchive.Caption:=txt_2_8_viewasarchive+' '+txt_2_8_experimental;
po_openunitasarchivelin.Caption:=txt_2_8_viewasarchive+' '+txt_2_8_experimental;
mswapbars.Caption:=txt_3_7_swapbars+' '+txt_7_8_requirerestart;
mswaptab.Caption:=txt_9_2_swt+' '+txt_7_8_requirerestart;
pmjumpbreadcrumb.Caption:=txt_5_0_bc;
mrowselect.Caption:=txt_2_8_rowselect;
mthl.Caption:=txt_2_9_thl;
MenuItemPW.Caption:=txt_2_7_setpw;
mjob.Caption:=txt_savejob;
CheckBoxExtNotArchives.Caption:=txt_2_7_es;
CheckBoxExtUnsupported.Caption:=txt_2_7_eu;
pmjb24.Caption:=txt_bookmarks+'...';
mr9.Caption:=txt_list_history+'...';
pmhr9.Caption:=txt_list_history+'...';
smbookmarks1.Caption:=txt_bookmarks;
smbookmarksa1.Caption:=txt_bookmarks;
smHistory1.Caption:=txt_list_history;
pmExploremenu.Caption:=txt_open_path;
pmFoldersmenu.Caption:=txt_nfiles+' / '+txt_nfolders;
pmAdvanced.Caption:=txt_2_6_advanced;
pmemr0.Caption:=txt_list_history;
pmemrf0.Caption:=txt_list_history;
pnhf0.Caption:=txt_5_0_sh;
pnbcf0.Caption:=txt_5_0_bc;
pnhe0.Caption:=txt_5_0_sh;
pnbce0.Caption:=txt_5_0_bc;
smHistorya1.Caption:=txt_list_history;
smfs1.Caption:=txt_fs;
smfsa1.Caption:=txt_fs;
MenuItemOpen_Last.Caption:=txt_lastused;
mpathreset1.Caption:=txt_lastused;
MenuItemArchive_home1.Caption:=txt_2_9_home;
mpathdesk1.Caption:=txt_desktop;
MenuItemArchive_documents1.Caption:=txt_2_4_documents;
mpathexplore1.Caption:=txt_explore_path;
menuitemextexplore.Caption:=txt_explore_path;
mdefarcset.Caption:=txt_7_6_setcurdef;
mdefextset.Caption:=txt_7_6_setcurdef;
MenuItemOpen_here.Caption:=txt_2_7_selpath;
mpathself1.Caption:=txt_2_7_selpath;
pmjumpsbook.Caption:=txt_bookmarks;
pmbreadfs.Caption:=txt_fs;
pmbreadfun.Caption:=txt_open;
mrecent9.Caption:=txt_list_history+'...';
pmh9.Caption:=txt_list_history+'...';
mhistory.Caption:=txt_list_history;
mtray.Caption:=txt_2_5_tray;
tmquit.Caption:=txt_quit;
tmcreate.Caption:=txt_create_archive;
tmopenpath.Caption:=txt_open_path;
tmopenarchive.Caption:=txt_openarchive;
pmmorehex.Caption:=txt_2_4_hexp;
po_hexp.Caption:=txt_2_4_hexp;
pmmoretext.Caption:=txt_10_0_tp;
po_textp.Caption:=txt_10_0_tp;
pmmorecheck.Caption:=txt_check;
pmmorecksave.Caption:=txt_10_0_save+' CKSUM';
pmmoremd5save.Caption:=txt_10_0_save+' MD5SUM';
pmmoresha1save.Caption:=txt_10_0_save+' SHA1SUM';
pmmoreshasave.Caption:=txt_10_0_save+' SHA256SUM';
pmmoreblake2bsave.Caption:=txt_10_0_save+' B2SUM';
pmmoreshag.Caption:=txt_searchfor+' SHA256 / Google';
pmmoreshaj.Caption:=txt_searchfor+' SHA256 / Jotti VirusScan';
pmmoreshav.Caption:=txt_searchfor+' SHA256 / VirusTotal';
po_cksum.Caption:=txt_10_0_save+' CKSUM';
po_md5sum.Caption:=txt_10_0_save+' MD5SUM';
po_sha1sum.Caption:=txt_10_0_save+' SHA1SUM';
po_sha256sum.Caption:=txt_10_0_save+' SHA256SUM';
po_b2sum.Caption:=txt_10_0_save+' B2SUM';
po_s256g.Caption:=txt_searchfor+' SHA256 / Google';
po_s256j.Caption:=txt_searchfor+' SHA256 / Jotti VirusScan';
po_s256v.Caption:=txt_searchfor+' SHA256 / VirusTotal';
MenuItemToolCrc32.Caption:=txt_10_0_save+' CKSUM';
MenuItemToolMD5.Caption:=txt_10_0_save+' MD5SUM';
MenuItemToolSHA1.Caption:=txt_10_0_save+' SHA1SUM';
MenuItemToolSHA256.Caption:=txt_10_0_save+' SHA256SUM';
MenuItemToolBlake2s.Caption:=txt_10_0_save+' B2SUM';
MenuItemToolsg.Caption:=txt_searchfor+' SHA256 / Google';
MenuItemToolsj.Caption:=txt_searchfor+' SHA256 / Jotti VirusScan';
MenuItemToolsv.Caption:=txt_searchfor+' SHA256 / VirusTotal';
MenuItemToolhexp.Caption:=txt_2_4_hexp;
MenuItemOpen_documents1.Caption:=txt_2_4_documents;
pmJumpDocuments.Caption:=txt_2_4_documents;
pmquickhome.Caption:=txt_2_9_home;
pmquickdesk.Caption:=txt_desktop;
pmquickdownloads.Caption:=txt_3_1_downloads;
pmquickop.Caption:=txt_open_path;
pmquickoa.Caption:=txt_openarchive;
pmquicksd.Caption:=txt_searchanddrag;
pmJumppubhome.Caption:=txt_2_9_home+' - '+txt_2_9_public;
MenuItemArchive_pubhome.Caption:=txt_2_9_home+' - '+txt_2_9_public;
MenuItemOpen_pubhome.Caption:=txt_2_9_home+' - '+txt_2_9_public;
pmJumppubdoc.Caption:=txt_2_4_documents+' - '+txt_2_9_public;
pmjumprecent.Caption:=txt_list_history;
pmjumpdownloads.Caption:=txt_3_1_downloads;
pmjumpsearches.Caption:=txt_3_1_src;
pmjumplibraries.Caption:=txt_3_1_lib;
MenuItemOpen_downloads1.Caption:=txt_3_1_downloads;
MenuItemArchive_downloads.Caption:=txt_3_1_downloads;
MenuItemArchive_pubdoc.Caption:=txt_2_4_documents+' - '+txt_2_9_public;
MenuItemOpen_pubdoc.Caption:=txt_2_4_documents+' - '+txt_2_9_public;
pclip_removeitem.Caption:=txt_2_4_removefromclipboard;
pclip_clearclip.Caption:=txt_2_4_clearclipboard;
CheckBoxAltgridcol.Caption:=txt_8_0_altcol;
LabelColorTabs.Caption:=txt_8_3_htab;
po_sysinfo.Caption:=txt_info;
po_Envstr.Caption:=txt_2_3_envstr;
po_dispenvstrlin.Caption:=txt_2_3_envstr;
cbType.Items[0]:=STR_7Z;
cbType.Items[1]:=STR_ARC;
cbType.Items[2]:=STR_BROTLI;
cbType.Items[3]:=STR_BZIP2;
cbType.Items[5]:=STR_GZIP;
cbType.Items[6]:=STR_PEA;
cbType.Items[7]:=STR_QUAD;
cbType.Items[8]:=txt_sfx+' '+STR_7Z;
cbType.Items[9]:=txt_sfx+' '+STR_ARC;
cbType.Items[10]:=txt_split;
cbType.Items[11]:=STR_TAR;
cbType.Items[12]:=STR_UPX;
cbType.Items[13]:=STR_WIM;
cbType.Items[14]:=STR_XZ;
cbType.Items[15]:=STR_ZIP;
cbType.Items[16]:=STR_ZSTD;
cbType.Items[17]:=STR_ZPAQ;
cbDefaultFormat.Items[0]:=STR_7Z;
cbDefaultFormat.Items[1]:=STR_ARC;
cbDefaultFormat.Items[2]:=STR_BROTLI;
cbDefaultFormat.Items[3]:=STR_BZIP2;
cbDefaultFormat.Items[4]:=txt_custom;
cbDefaultFormat.Items[5]:=STR_GZIP;
cbDefaultFormat.Items[6]:=STR_PEA;
cbDefaultFormat.Items[7]:=STR_QUAD;
cbDefaultFormat.Items[8]:=txt_sfx+' '+STR_7Z;
cbDefaultFormat.Items[9]:=txt_sfx+' '+STR_ARC;
cbDefaultFormat.Items[10]:=txt_split;
cbDefaultFormat.Items[11]:=STR_TAR;
cbDefaultFormat.Items[12]:=STR_UPX;
cbDefaultFormat.Items[13]:=STR_WIM;
cbDefaultFormat.Items[14]:=STR_XZ;
cbDefaultFormat.Items[15]:=STR_ZIP;
cbDefaultFormat.Items[16]:=STR_ZSTD;
cbDefaultFormat.Items[17]:=STR_ZPAQ;
cbDefaultFormat.Items[18]:=txt_lastused;
status0:=APPMAIN+' '+PEAZIPVERSION+PEAZIPREVISION;
cbSplit.Items.Strings[0]:=txt_singlevol;
cbSplit.Items.Strings[1]:=txt_customsize;
cbSplit.Items.Strings[2]:=txt_fd;
cbSplit.Items.Strings[3]:=txt_attach10;
cbSplit.Items.Strings[4]:=txt_4_8_attach25;
cbSplit.Items.Strings[5]:=txt_cd650;
cbSplit.Items.Strings[6]:=txt_cd700;
cbSplit.Items.Strings[7]:=txt_fat32;
cbSplit.Items.Strings[8]:=txt_dvd;
cbSplit.Items.Strings[9]:=txt_dvddl;
cbSplit.Items.Strings[10]:='25 GB Blu-Ray';
cbSplit.Items.Strings[11]:='50 GB Blu-Ray DL';
cbSplit.Items.Strings[12]:='100 GB Blu-Ray XL3';
cbSplit.Items.Strings[13]:='128 GB Blu-Ray XL4';
CheckBoxTarBefore.Caption:=txt_tarbefore;
CheckBoxTarBefore.Hint:=txt_tarbefore_hint;
cbAdvfAdd.Caption:=txt_advfilters;
LabelPanelHintAdd.caption:=txt_2_7_archivehint;
LabelPanelHintExtract.caption:=txt_2_7_exthint;
CheckBoxSeparate.Caption:=txt_2_7_separate;
CheckBoxConvert.Caption:=txt_2_8_convertexisting;
CheckBoxConvertPW.Caption:=txt_6_5_chp;
CheckBoxConvertVerbose.Caption:=txt_5_6_verbose;
po_convertarchive.Caption:=txt_2_8_convert;
EditOParc.Hint:=txt_otherparams;
Edit7zOpt.Hint:=txt_otherparams;
EditOPcustom.Hint:=txt_otherparams;
LabelPAQLevel.Caption:=txt_level;
LabelPAQThreads.Caption:=txt_threads;
RadioGroupPaq.Caption:=txt_paqver;
LabelUPXLevel.Caption:=txt_level;
CheckBoxUPXStrip.Caption:=txt_strip;
CheckBoxUPXBackup.Caption:=txt_backupexe;
CheckBoxUPXBackup.Hint:=txt_backupexe_hint;
RadioGroupQuad.Caption:=txt_exe;
CheckBoxQuadMax.Caption:=txt_maxcomp;
CheckBoxQuadMax.Hint:=txt_slowercomp;
LabelPEALevel.Caption:=txt_level;
LabelPEAStream.Caption:=txt_encryption;
LabelPEAObj.Caption:=txt_peaobj;
LabelPEAVol.Caption:=txt_volumepea;
LabelPEAKDFw.Caption:=txt_10_1_kdfw;
LabelSplit.Caption:=txt_integrity;
LabelSplit.Hint:=txt_check_hint;
Subtitle7zOpt.Caption:=txt_options;
Label7zFun.Caption:=txt_function;
Label7zPath.Caption:=txt_6_4_paths;
ComboBox7zPaths.Items.Strings[0]:=txt_6_4_relative;
ComboBox7zPaths.Items.Strings[1]:=txt_6_4_full;
ComboBox7zPaths.Items.Strings[2]:=txt_6_4_absolute;
ComboBoxArchivePathsExt.Items.Strings[0]:=txt_6_4_relative;
ComboBoxArchivePathsExt.Items.Strings[1]:=txt_6_4_full;
ComboBoxArchivePathsExt.Items.Strings[2]:=txt_6_4_absolute;
Label7zThreads.Caption:=txt_threads;
Label7zOtherParams.Caption:=txt_other;
CheckBoxMailAdd.Caption:=txt_sendbymail;
CheckBoxMailAdd.Hint:=txt_attach;
CheckBoxMailKeep.Caption:=txt_4_8_keeparchive;
Subtitle7zEncOpt.Caption:=txt_encryption;
Label7zEnc.Caption:=txt_algo;
Subtitle7zCompOpt.Caption:=txt_compression;
Label7zMethod.Caption:=txt_method;
Label7zLevel.Caption:=txt_level;
Label7zDictionary.Caption:=txt_dictionary;
Label7zWord.Caption:=txt_word;
Label7zPasses.Caption:=txt_passes;
Label7zsolidblock.Caption:=txt_solid_block;
Labelbcmblock.Caption:=txt_solid_block;
CheckBox7zSFX.Caption:=txt_create_sfx;
RadioGroup7zSFX.Caption:=txt_sfx_interface;
CheckBox7zOF.Caption:=txt_compress_openforwriting;
CheckBoxSolidExtension.Caption:=txt_6_0_msq;
pmbcexpand.Caption:=txt_6_1_ec;
apmbcexpand.Caption:=txt_6_1_ec;
cbEncExtension.Caption:=txt_6_2_encext;
CheckBox7zOF.Hint:=txt_openfiles_hint;
LabelCustParams.Caption:=txt_parameters;
LabelCustom.Caption:=txt_exe_hint;
LabelCustSyntax.Caption:=txt_syntax;
LabelCustExe.Caption:=txt_exe;
LabelCustExtension.Caption:=txt_ext;
LabelArcSub1.Caption:=txt_compression;
LabelARCLevel.Caption:=txt_level;
LabelARCsolidblock.Caption:=txt_solid;
CheckBoxARCrr.Caption:=txt_rr;
CheckBoxARCrr.Hint:=txt_rr_hint;
CheckBoxARCabs.Caption:=txt_4_2_arcabspath;
CheckBoxARCsfx.Caption:=txt_create_sfx;
LabelArcSub2.Caption:=txt_options;
Subtitleschopt.Caption:=txt_6_5_def;
SubtitleschoptExt.Caption:=txt_6_5_def;
LabelARCFun.Caption:=txt_function;
LabelARCParams.Caption:=txt_other;
LabelArcSub3.Caption:=txt_encryption;
LabelARCEnc.Caption:=txt_algo;
CheckBoxDate.Caption:=txt_timestamp;
cbCustomExtension.Caption:=txt_7_8_custext;
iConsoleCreateImport.Hint:=txt_pj_hint;
ImageInfoConsole.hint:=txt_pj_hint2;
lConsoleCreate_jobcode.Caption:=txt_job_code;
lConsoleCreate_outname.Caption:='outname'; //overwritten, don't need to be translated
BtnPjSaveAdd.Caption:=txt_savejob;
BtnPjSaveAdd.Hint:=txt_savejobdefinition_hint;
BtnPjLaunchAdd.Caption:=txt_launch;
ButtonArchiveOK.Caption:=txt_2_7_ok;
ButtonArchiveOK.Hint:='Ctrl+Alt+Enter';
ButtonExtOk.Caption:=txt_2_7_ok;
ButtonExtOk.Hint:='Ctrl+Alt+Enter';
ButtonArchiveCancel.Caption:=txt_2_7_cancel;
ButtonExtCancel.Caption:=txt_2_7_cancel;
mkeyfile.Caption:=txt_4_7_pk;
mpm.caption:=txt_4_3_pwman;
mscripts.caption:=txt_4_5_pj;
TrayIconPZ.hint:='PeaZip | '+txt_5_6_rc;
mlayouts.caption:=txt_5_6_layouts;
ButtonUn7zaTo.Caption:=txt_caption_extract;
ButtonUn7zaTest.Caption:=txt_caption_test;
ButtonUn7zaAdd.Caption:=txt_add;
ButtonUn7zaConvert.Caption:=txt_2_8_convert;
cbUn7zaRecursive.Caption:=txt_filters_recourse;
cbUn7zaRecursiveExclude.Caption:=txt_exclude_recourse;
MenuItemHistoryBook.Caption:=txt_add_tobookmarks;
ButtonUn7zaAdd.Hint:=txt_add_tolayout;
EditUn7zaFilterInteractive.Hint:=txt_address_hint;
Imagelistsearch.Hint:=txt_searchfor;
ImageListResetSearch.Hint:=txt_reset;
pmireset.Caption:=txt_reset;
pmrsearch.Caption:=txt_searchfor+'...';
pmsrec.Caption:=txt_2_9_rec;
ctrlwarning.Hint:=txt_7_3_archiveerrors;
ctrlup.Hint:=txt_up;
ButtonOutAdd.Hint:=txt_browse;
ButtonOutUpdate.Hint:=txt_browse;
ButtonOutExtract.Hint:=txt_browse;
ComboBoxActionExtract.Caption:=txt_action;
CheckBoxUnPeaAttributes.Caption:=txt_restore_att;
LabelCustomParamExt.Caption:=txt_parameters;
ImageInfoCustomExt.hint:=txt_exe_hint;
LabelCustomSyntaxExt.Caption:=txt_syntax;
LabelCustomBinExt.Caption:=txt_exe;
pcustompathexplore.Caption:=txt_explore_path;
LabelOutExtract.Caption:=txt_2_7_output;
LabelFunctionExtract.Caption:=txt_function;
LabelNamingExtract.Caption:=txt_naming;
LabelStatusAddUpdate.Caption:='';
LabelOutAdd.Caption:=txt_2_7_output;
LabelTypeAdd.Caption:=txt_type;
LabelLevelAdd.Caption:=txt_level;
LabelActAdd.Caption:=txt_function;
LabelSpanAdd.Caption:=txt_split;
LabelOutUpdate.Caption:=txt_2_7_output;
LabelPathUpdate.Caption:=txt_path;
LabelActUpdate.Caption:=txt_function;
cbAdvfExt.Caption:=txt_advfilters;
LabelGoExtract.Caption:='['+txt_ext_all+']';
CheckBoxFolder.Caption:=txt_newfoldermenu;
CheckBoxDeleteInputExt.Caption:=txt_5_4_deletearchives;
CheckBoxDeleteInputAdd.Caption:=txt_5_4_deletefiles;
cbDeleteInputModeExt.Clear;
{$IFDEF MSWINDOWS}
cbDeleteInputModeExt.DropDownCount:=4;
cbDeleteInputModeExt.Items.Append(txt_4_7_recycle);
cbDeleteInputModeExt.Items.Append(txt_quickdelete);
cbDeleteInputModeExt.Items.Append(txt_5_2_zerofiles);
cbDeleteInputModeExt.Items.Append(txt_securedelete);
{$ELSE}
{$IFDEF DARWIN}
cbDeleteInputModeExt.DropDownCount:=4;
cbDeleteInputModeExt.Items.Append(txt_4_7_recycle);
cbDeleteInputModeExt.Items.Append(txt_quickdelete);
cbDeleteInputModeExt.Items.Append(txt_5_2_zerofiles);
cbDeleteInputModeExt.Items.Append(txt_securedelete);
{$ELSE}
cbDeleteInputModeExt.DropDownCount:=3;
cbDeleteInputModeExt.Items.Append(txt_quickdelete);
cbDeleteInputModeExt.Items.Append(txt_5_2_zerofiles);
cbDeleteInputModeExt.Items.Append(txt_securedelete);
{$ENDIF}
{$ENDIF}
cbDeleteInputModeExt.ItemIndex:=0;
cbDeleteInputModeAdd.Clear;
{$IFDEF MSWINDOWS}
cbDeleteInputModeAdd.DropDownCount:=4;
cbDeleteInputModeAdd.Items.Append(txt_4_7_recycle);
cbDeleteInputModeAdd.Items.Append(txt_quickdelete);
cbDeleteInputModeAdd.Items.Append(txt_5_2_zerofiles);
cbDeleteInputModeAdd.Items.Append(txt_securedelete);
{$ELSE}
{$IFDEF DARWIN}
cbDeleteInputModeAdd.DropDownCount:=4;
cbDeleteInputModeAdd.Items.Append(txt_4_7_recycle);
cbDeleteInputModeAdd.Items.Append(txt_quickdelete);
cbDeleteInputModeAdd.Items.Append(txt_5_2_zerofiles);
cbDeleteInputModeAdd.Items.Append(txt_securedelete);
{$ELSE}
cbDeleteInputModeAdd.DropDownCount:=3;
cbDeleteInputModeAdd.Items.Append(txt_quickdelete);
cbDeleteInputModeAdd.Items.Append(txt_5_2_zerofiles);
cbDeleteInputModeAdd.Items.Append(txt_securedelete);
{$ENDIF}
{$ENDIF}
cbDeleteInputModeAdd.ItemIndex:=0;
LabelTitleAdd1.Caption:='      '+txt_archive+'      ';
LabelTitleAdd2.Caption:='      '+txt_2_6_advanced+'      ';
LabelTitleAdd3.Caption:='      '+txt_console+'      ';
LabelTitleAdd4.Caption:='      '+txt_5_1_schedule+'      ';
labeltitleextract1.Caption:='      '+txt_caption_extract+'      ';
labeltitleextract2.Caption:='      '+txt_2_6_advanced+'      ';
labeltitleextract3.Caption:='      '+txt_console+'      ';
labeltitleextract4.Caption:='      '+txt_5_1_schedule+'      ';
CheckBoxClip.Caption:=txt_2_4_advclip;
BtnPjSaveExt.Caption:=txt_savejob;
BtnPjSaveExt.Hint:=txt_savejobdefinition_hint;
iConsoleCreateImportExt.Hint:=txt_pj_hint;
ImageInfoConsoleExt.Hint:=txt_pj_hint2+char($0D)+char($0A)+char($0D)+char($0A)+txt_8_8_intnote;
lConsoleCreate_jobcodeExt.Caption:=txt_job_code;
lConsoleCreate_outnameExt.Caption:='outname'; //overwritten, doesn't need translation
BtnPjLaunchExt.Caption:=txt_launch;
ImageInfoBinaries.Hint:=txt_cl_hint;
ImageInfoEncoding.Hint:=txt_2_5_langhint;
Labeloaui.Caption:=txt_backend;
LabelOpenDesktop.Caption:=txt_desktop;
LabelCustomDesktop.Caption:=txt_custom;
LabelcbSD.Caption:=txt_5_9_start;
ComboBoxSD.Items[0]:=txt_5_4_lv;
ComboBoxSD.Items[1]:=txt_mypc;
ComboBoxSD.Items[2]:=txt_desktop;
ComboBoxSD.Items[3]:=txt_2_9_home;
ComboBoxSD.Items[4]:=txt_custom;
Labeltitleoptions7.Caption:=txt_2_5_help;
Labeltitleoptions8.Caption:=txt_about;
Labelo8.Caption:=txt_about;
CheckBoxrelative.Caption:=txt_7_8_rel;
CheckBoxrelative.Hint:='(7z / p7zip) '+txt_8_5_intext;
CheckBoxAutoOpen.Caption:=txt_2_7_oop;
CheckBoxAutoTest.Caption:=txt_8_8_autotest;
CheckBoxSameArc.Caption:=txt_5_2_oadd;
CheckBoxSameExt.Caption:=txt_5_2_oext;
CheckBoxnameasparentfolder.Caption:=txt_3_7_nameasparent;
CheckBoxzpaqall.Caption:=txt_7_2_zpaqall;
CheckBoxzpaqfull.Caption:=txt_6_4_full;
CheckBoxzpaqabsolute.Caption:=txt_6_4_absolute;
CheckBoxzpaqforce.Caption:=txt_overwrite;
cbtarpipe.Caption:=txt_9_7_tarpipe+' TAR';
cbuntarpipe.Caption:=txt_9_7_tarpipe+' UNTAR';
pmapp.Caption:=txt_3_3_apps;
pmapprun.Caption:=txt_3_3_run;
Labelo1.Caption:=txt_general;
Labelo2.Caption:=txt_2_6_advanced;
Labelo3.Caption:=txt_4_6_am;
Labelo4.Caption:=txt_4_6_fm;
Labelo5.Caption:=txt_3_3_apps;
Labelo6.Caption:=txt_theme;
Labelo7.Caption:=txt_2_5_help;
Labelogperf.Caption:=txt_5_0_perf;
LabelResetOpenWith.Caption:=txt_reset+' '+txt_3_3_apps;
LabelTitleOptions1.Caption:=txt_general+'   ';
LabelTitleOptions1.Hint:=txt_misc+', '+txt_localization+{$IFDEF MSWINDOWS}', '+txt_7_8_dd+{$ENDIF}char($0D)+char($0A)+txt_5_0_perf+', '+txt_8_1_bo+char($0D)+char($0A)+txt_6_5_privacy+', '+txt_3_1_workingdir;
labelmaxarg.Caption:=txt_8_3_maxarg;
CheckBoxSkipDel.Caption:=txt_8_3_skipdel;
LabelTitleOptions2.Caption:=txt_2_6_advanced+'   ';
LabelTitleOptions2.Hint:=txt_2_5_encoding+char($0D)+char($0A)+txt_path+char($0D)+char($0A)+txt_backend;
Labeloaenc.Caption:=txt_2_5_encoding;
Labelconsoleencoding.Caption:=txt_3_1_sccenc;
cbEncoding.Caption:=txt_3_2_7zutf8nonascii;
CheckBoxJobEncoding.Caption:=txt_2_5_encpj;
CheckBoxDragDrop.Caption:=txt_6_8_ndrop;
CheckBoxEditArchives.Caption:=txt_6_9_autou;
pmtabsave.Caption:=txt_9_5_savetabs;
LabelSysBin.Caption:=txt_9_5_sb;
ComboBoxSysbin.Items[0]:=txt_no;
ComboBoxSysbin.Items[1]:='7z / p7zip';
ComboBoxSysbin.Items[2]:=txt_9_5_all;
mForceSyncedits.Caption:=txt_6_9_forceu;
mForceSynceditsClear.Caption:=txt_7_2_updateclear;
mForceClear.Caption:=txt_7_2_clearnoupdate;
CheckBoxClosePeaZip.Caption:=txt_7_2_autoclosepeazip;
CheckBoxSkipenc.Caption:=txt_8_2_skipet;
{$IFDEF MSWINDOWS}
labelmaxarg.visible:=false;
ComboBoxMaxArg.visible:=false;
{$ELSE}
CheckBoxDragDrop.visible:=false;
ComboBoxDrag.visible:=false;
CheckBoxzcopy.visible:=false;
CheckBoxnetworkinfo.visible:=false;
{$ENDIF}
mverifyself.Caption:=txt_8_7_verifybin;
pmshowsearch.Caption:=txt_8_7_showsearchbar;
csvsepchar.Caption:=txt_8_7_csv;
csvsepchar.Hint:=txt_8_7_csvhelp;
EditCSVsep.Hint:=txt_8_7_csvhelp;
mprofileimmediate.caption:=txt_8_6_immediate;
CheckBoxShowVolatile.Caption:=txt_6_5_showvolatile;
CheckBoxAutoOpenTar.Caption:=txt_7_0_autoopentar;
CheckBoxAutoExtTar.Caption:=txt_9_0_autoexttar+' / '+upcase(txt_caption_extract);
CheckBoxAutoExtTarConvert.Caption:=txt_9_0_autoexttar+' / '+upcase(txt_2_8_convert);
CheckBoxForceOpen.Caption:=txt_6_5_force;
CheckBoxForceLayout.Caption:=txt_8_5_loadlayout;
CheckBoxForceEdit.Caption:=txt_6_6_forcemodify;
CheckBoxExcludeEF.Caption:=txt_9_1_ef;
CheckBoxUTC.Caption:=txt_9_9_utc+' (7z / p7zip)';
Labelsyntaxlevel.Caption:=txt_9_1_7zs;
Labelalias.Caption:=txt_9_2_7za;
CheckBoxForceBrowse.Caption:=txt_8_0_forcebrowse;
CheckBoxForceConvert.Caption:=txt_8_0_forceconvert;
pmrsh.Caption:=txt_6_6_rsh;
CheckBoxEncoding.Caption:=txt_2_5_langflag;
CheckBoxWindowStatus.Caption:=txt_save_winstate;
CheckBoxArchiveHistory.Caption:=txt_savehistory;
CheckBoxArchiveHistory.Hint:=txt_7_8_requirerestart;
CheckBoxShowHints.Caption:=txt_showhints;
LabelTitleOptions3.Caption:=txt_4_6_am+'   ';
LabelTitleOptions3.Hint:=txt_browser+char($0D)+char($0A)+'TAR'+char($0D)+char($0A)+txt_8_7_after+char($0D)+char($0A)+txt_archive+char($0D)+char($0A)+txt_caption_extract;
MenuItemEnumerate.Caption:=txt_5_0_enum;
CheckboxEnumd.Caption:=txt_5_0_enum;
labelRARdict.Caption:=txt_dictionary+' (MB)';
cbRARsfx.Caption:=txt_sfx;
cbRARsolid.Caption:=txt_solid;
cbRARrr.Caption:=txt_rr;
cbRARsaveopen.Caption:=txt_compress_openforwriting;
cbRARsavesecurity.Caption:=txt_6_5_sni;
cbRARsavestreams.Caption:=txt_6_5_sns;
cbRARlastmodtime.Items[0]:=txt_7_4_tcurr;
cbRARlastmodtime.Items[1]:=txt_7_4_tkeep;
cbRARlastmodtime.Items[2]:=txt_7_3_stl;
Labelogreset.Caption:=txt_6_5_privacy;
Labelogpaths.Caption:=txt_path;
LabelDefaultFormat.Caption:=txt_default_format;
RadioGroupBrowser.Items.Strings[0]:=txt_browser;
RadioGroupBrowser.Items.Strings[1]:=txt_flat;
RadioGroupBrowser.Items.Strings[2]:=txt_lastused;
CheckBoxIgnorePaths.Caption:=txt_ignore_ext;
cbautoclosesingleextract.Caption:=txt_7_5_autoclosesingle;
Labelextevfor.Caption:=txt_7_5_ee;
cbExtEvForWhen.Items.Strings[0]:=txt_7_5_never;
cbExtEvForWhen.Items.Strings[1]:=txt_7_5_ask;
cbExtEvForWhen.Items.Strings[2]:=txt_7_5_always;
cbExtEvForHow.Items.Strings[0]:=txt_all_default;
cbExtEvForHow.Items.Strings[1]:=txt_displayedobjects;
ComboBoxsec.Items.Strings[0]:=txt_4_6_am;
ComboBoxsec.Items.Strings[1]:=txt_4_6_fm;
ComboBoxsec.Items.Strings[2]:=txt_7_5_always;
ComboBoxsec.Items.Strings[3]:=txt_7_5_never;
CheckBoxIgnoreSel.Caption:=txt_ignore_sel;
CheckBoxExtAnd.Caption:=txt_8_0_enableextand;
CheckBoxIgnoreDisp.Caption:=txt_ignore_disp;
CheckBoxIntDir.Caption:=txt_5_5_intdir;
LabelPrebrowse.Caption:=txt_browser;
LabelVirtual.Caption:=txt_10_6_virtual;
ComboBoxvirtual.Items[0]:=txt_default;
ComboBoxvirtual.Items[1]:=txt_7_5_always;
ComboBoxvirtual.Items[5]:=txt_no;
LabelPriority.Caption:=txt_7_8_tpriority;
ComboBoxPriority.Items[0]:=txt_7_8_priorityrealtime;
ComboBoxPriority.Items[1]:=txt_7_8_priorityhigh;
ComboBoxPriority.Items[2]:=txt_7_8_prioritynormal;
ComboBoxPriority.Items[3]:=txt_7_8_priorityidle;
CheckBoxBrowseNotVerbose.Caption:=txt_8_2_vreport+' '+txt_faster;
LabelPrebrowse.Hint:=txt_quickbrowse_hint;
Labelogmisc.Hint:=txt_misc;
Labeloambrowser.Caption:=txt_browser;
Labeloamext.Caption:=txt_caption_extract;
Labeloamext1.Caption:=txt_archive;
Labeloafter.Caption:=txt_8_7_after;
RadioGrouppwrequest.Items[0]:=txt_2_3_never_pw;
RadioGrouppwrequest.Items[1]:=txt_2_3_test_pw100;
RadioGrouppwrequest.Items[2]:=txt_2_9_test_pw2G;
RadioGrouppwrequest.Items[3]:=txt_2_3_test_pw;
RadioGrouppwrequest.Items[4]:=txt_always_pw;
LabelTitleOptions4.Caption:=txt_4_6_fm+'   ';
LabelTitleOptions4.Hint:=txt_filebrowser+char($0D)+char($0A)+txt_filetools;
Labeloptsubsec.Caption:=txt_10_5_sectype;
cbqdup.caption:=txt_9_1_qdup;
cbshowhidden.caption:=txt_10_5_sh;
mshowhidden.caption:=txt_10_5_sh;
LabelOptsub1.Caption:=txt_filetools;
LabelHashFormat.Caption:=txt_dispaly;
LabelBrowserHash.Caption:=txt_check_select;
LabelHash.Caption:=txt_check_select;
LabelCommonAlgo.Caption:=txt_8_3_prefalgo;
cbHash.Items.Strings[0]:=txt_8_3_prefalgo;
cbHash.Items.Strings[1]:=txt_performall;
ComboBoxKiB.Items[0]:=txt_8_3_mbubin;
ComboBoxKiB.Items[1]:=txt_8_3_mbudec;
ComboBoxKiB.Items[2]:=txt_2_9_none;
LabelSecureDelete.Caption:=txt_securedelete;
ComboBoxPasses.Items[0]:=txt_level_fastest;
ComboBoxPasses.Items[1]:=txt_level_fast;
ComboBoxPasses.Items[2]:=txt_level_normal;
ComboBoxPasses.Items[3]:=txt_8_1_slow;
ComboBoxPasses.Items[4]:=txt_8_1_vslow;
ThemeReset.Hint:=txt_reset_theme;
LabelAdvThemes.Caption:=txt_2_6_advanced;
LabelConfigurePeaZip.Caption:=txt_3_0_configure;
LabelConfigurePeaZip.Hint:=txt_3_0_configure+' '+txt_7_8_requirerestart;
LabelConfigurePw.Caption:=txt_8_0_setpwopt;
LabelOpenConf.Caption:=txt_3_2_conf;
LabelConfigureSendTo.Caption:=txt_3_1_sendto;
LabelAppPath.Caption:=txt_3_3_apppath;
LabelLang.Caption:=txt_localization;
LabelLang.Hint:=txt_7_8_changelocalization+' '+txt_7_8_requirerestart;
ComboBoxLanguage.Hint:=txt_7_8_changelocalization+' '+txt_7_8_requirerestart;
LabelOpacity.Hint:=txt_restartrequired;
LabelDefaultOpacity.Hint:=txt_restartrequired2;
CheckBoxParallelarchiving.Caption:=txt_2_8_parallel;
CheckBoxzcopy.Caption:=txt_2_8_zcopy;
CheckBoxnetworkinfo.Caption:=txt_3_3_skipunits;
LabelWD.Caption:=txt_3_1_workingdir;
ComboBoxBrowser.Items.Strings[0]:=txt_8_1_preparse;
ComboBoxBrowser.Items.Strings[1]:=txt_8_1_slow+' / '+txt_9_5_largea;
ComboBoxBrowser.Items.Strings[2]:=txt_level_normal+' / '+txt_9_5_mediuma;
ComboBoxBrowser.Items.Strings[3]:=txt_level_fast+' / '+txt_9_5_precond;
ComboBoxBrowser.Items.Strings[4]:=txt_8_1_nopreparse;
ComboBoxBrowser.Hint:=txt_8_1_preparsehint;
LabelPrebrowse.Caption:=txt_8_1_bo;
LabelPrebrowse.Hint:=txt_8_1_preparsehint;
ComboBoxDrag.Items.Strings[0]:=txt_7_5_dragnone;
ComboBoxDrag.Items.Strings[1]:=txt_7_5_draglock;
ComboBoxDrag.Items.Strings[2]:=txt_7_5_draghide;
ComboBoxDrag.Items.Strings[3]:=txt_7_5_draglh;
ComboBoxWD.Items.Strings[0]:=txt_2_7_output;
ComboBoxWD.Items.Strings[1]:=txt_7_7_outtemp;
ComboBoxWD.Items.Strings[2]:=txt_3_1_systmp;
ComboBoxWD.Items.Strings[3]:=txt_custom;
ComboBoxWD.Items.Strings[4]:=txt_7_7_nonetemp;
ComboBoxWD.Items.Strings[5]:=txt_7_7_noneall;
ComboBoxWD.Hint:=txt_7_7_tw+' '+txt_7_8_requirerestart;
cbBinaries.Items.Strings[0]:=txt_console_interface;
cbBinaries.Items.Strings[1]:=txt_guicl;
cbBinaries.Items.Strings[2]:=txt_guipealauncher;
cbBinariesStop.Items.Strings[0]:=txt_2_6_plalways;
cbBinariesStop.Items.Strings[1]:=txt_8_9_stoptest;
cbBinariesStop.Items.Strings[2]:=txt_2_6_plsmart;
cbBinariesStop.Items.Strings[3]:=txt_8_4_keepopenerrorslist;
cbBinariesStop.Items.Strings[4]:=txt_autoclose;
cbEncoding.Items.Strings[0]:=txt_7_6_defaultenc;
cbEncoding.Items.Strings[1]:=txt_7_6_forceutf8enc;
cbEncoding.Items.Strings[2]:=txt_7_6_forcelocalenc;
cbEncoding.Items.Strings[3]:=txt_7_6_custenc;
ComboBoxSyntaxLevel.Items.Strings[0]:=txt_5_1_last;
cbtree.Items.Strings[0]:=txt_7_6_tno;
cbtree.Items.Strings[1]:=txt_7_6_tsimple;
cbtree.Items.Strings[2]:=txt_7_6_tadvanced;
cbautobrowsetar.Items.Strings[3]:=txt_7_5_always;
LabelTree.Caption:=txt_2_9_tree;
LabelDefaultAction.Caption:=txt_8_0_defaultaction;
LabelDefaultAction.Hint:=txt_8_0_defaultactionhint;
cbdefaultaction.Items.Strings[0]:=txt_open;
cbdefaultaction.Items.Strings[1]:=txt_3_1_openasarchive;
cbdefaultaction.Items.Strings[2]:=txt_caption_extract+'...';
cbdefaultaction.Items.Strings[3]:=txt_ext_allhere;
cbdefaultaction.Items.Strings[4]:=txt_7_1_smart;
cbdefaultaction.Items.Strings[5]:=txt_7_1_new;
cbEncoding.Hint:=txt_7_6_cpnote;
LabelEncoding.Caption:=txt_7_6_zipenc;
LabelResetBookmarks.Hint:=txt_7_8_requirerestart;
LabelResetPM.Hint:=txt_7_8_requirerestart;
LabelTheme1.Caption:=txt_themename;
LabelTheme2.Caption:=txt_author;
LabelTheme3.Caption:=txt_license;
themesave_label.Caption:=txt_create_theme;
LabelColorTemperature.Caption:=txt_8_3_temperature;
LabelContrast.Caption:=txt_9_3_contrast;
LabelAppColor.Caption:=txt_pea_appcolor;
LabelFormColor.Caption:=txt_7_6_color;
tbtemperature.hint:=txt_8_3_temperature;
LabelTextAccentColor.Caption:=txt_7_6_tacolor;
Labelspacing.Caption:=txt_7_9_spacing;
Labelsmsize.Caption:=txt_8_8_sm;
Labelzooming.Caption:=txt_7_9_zooming;
cbspacing.Items.Strings[0]:=txt_2_9_st;
cbspacing.Items.Strings[1]:=txt_2_9_mt;
cbspacing.Items.Strings[2]:=txt_2_9_lt;
cbspacing.Items.Strings[3]:=txt_level_maximum;
cbspacing.Hint:=txt_7_9_spacing+' '+txt_7_8_requirerestart;
cbzooming.Hint:=txt_7_9_zooming+' '+txt_7_8_requirerestart;
cbSmallIconSize.Hint:=txt_8_8_sm+' '+txt_7_8_requirerestart;
Labellightpresets.Caption:=txt_4_8_presets;
Labellightpresets.Hint:=txt_7_6_dim+', '+txt_7_6_dark+',... '+txt_7_8_requirerestart;
lightdim.Caption:=txt_7_6_dim;
lightlow.Caption:=txt_7_6_dark;
LabelDefaultColor1.Caption:=txt_reset;
LabelDefaultColor2.Caption:=txt_reset;
LabelDefaultColor2.Hint:=txt_reset+' '+txt_7_8_requirerestart;
LabelDefaultColor3.Caption:=txt_reset;
LabelDefaultColor1.Caption:=txt_reset;
LabelColPresets.Caption:=txt_4_8_presets;
LabelTheme.Caption:=txt_theme;
LabelOpacity.Caption:=txt_opacity;
LabelDefaultOpacity.Caption:=txt_reset;
ButtonOptCancel.Caption:=txt_2_7_cancel;
ButtonOptOK.Caption:=txt_2_7_ok;
ButtonOptReset.Caption:=txt_reset;
LabelResetBookmarks.Caption:=txt_reset+' '+txt_bookmarks;
LabelResetPtmp.Caption:=txt_3_0_resettmp;
LabelResetPM.Caption:=txt_reset+' '+txt_4_3_pwman;
LabelPMpw.Caption:=txt_4_3_pwmanmaster;
LabelResetHistory.Caption:=txt_reset+' '+txt_list_history;
pmBrowser.Caption:=txt_go_browser;
mgobrowser.Caption:=txt_go_browser;
pmAddFile.Caption:=txt_add_files;
pmAddFolder.Caption:=txt_add_folder;
pmSearchAdd.Caption:=txt_searchanddrag;
munsearch.Caption:=txt_searchanddrag;
po_savecopy.Caption:=txt_10_2_savecopy;
munsavecopy.Caption:=txt_10_2_savecopy;
MenuItemOpen_search.Caption:=txt_searchanddrag;
pmLoadList.Caption:=txt_loadlayout;
pmSaveList.Caption:=txt_savelayout;
mLoadLayout.Caption:=txt_loadlayout;
mSaveLayout.Caption:=txt_savelayout;
MenuItem3.Caption:=txt_clearlayout;
MenuItem1.Caption:=txt_removeselected;
MenuItemNavigate.Caption:=txt_go_path;
MenuItem5b.Caption:=txt_openwith;
openwithpeazip.Caption:=txt_peazip_new;
openwithassociated.Caption:=txt_associated;
openwithcustom.Caption:=txt_customapp;
mMisc.Caption:=txt_misc;
MenuItemBookmarks.Caption:=txt_add_tobookmarks;
pmExplorepath.Caption:=txt_explore_path;
mcp.Caption:=txt_cphere;
MenuItemTools.Caption:=txt_filetools;
MenuItemToolCompare.Caption:=txt_compare;
MenuItemToolCheck.Caption:=txt_check;
MenuItemRefresh.Caption:=txt_fefreshf5;
MenuItemContextRefresh.Caption:=txt_fefreshf5;
pmhrefresh.Caption:=txt_fefreshf5+' (F5)';
mf3.caption:=txt_searchfor;
mf4up.caption:=txt_up;
mback.caption:=txt_back;
mFeatures.Caption:=txt_file;
mextract.Caption:=txt_caption_extract;
mPEA.Caption:=txt_create_archive;
maddexisting.Caption:=txt_5_6_upexisting;
maddconvert.Caption:=txt_2_8_convert;
mUnPEAextract.Caption:=txt_5_6_exarc;
tmupdate.Caption:=txt_5_6_upexisting;
tmconvert.Caption:=txt_2_8_convert;
tmextract.Caption:=txt_5_6_exarc;
mUnPEAbrowse.Caption:=txt_open_path;
mUnPEA.Caption:=txt_openarchive;
mBookmarks.Caption:=txt_bookmarks;
mQuit.Caption:=txt_quit;
mEdit.Caption:=txt_edit;
mSelectAll.Caption:=txt_selectall;
po_SelectAll.Caption:=txt_selectall+' (Ctrl+A)';
mInvertSelection.Caption:=txt_invertsel;
mType.Caption:=txt_all_type;
mChar.Caption:=txt_5_5_starting;
mCharCase.Caption:=txt_5_5_starting+' '+txt_5_5_case;
msizesimilar.Caption:=txt_5_5_similar+' (10%)';
msizesimilar50.Caption:=txt_5_5_similar+' (50%)';
mpackedsimilar.Caption:=txt_5_5_similar+' (10%)';
mpackedsimilar50.Caption:=txt_5_5_similar+' (50%)';
mAttributes.Caption:=txt_all_attributes;
mDate.Caption:=txt_all_date;
mDateRecent.Caption:=txt_morerecent;
mDateERecent.Caption:=txt_eqorrecent;
mDateEqual.Caption:=txt_equal;
mDateEOlder.Caption:=txt_eqorolder;
mDateOlder.Caption:=txt_olderthan;
mPackedSize.Caption:=txt_all_psize;
mPSSmaller.Caption:=txt_smaller;
mPSESmaller.Caption:=txt_eqorsmaller;
mPSEqual.Caption:=txt_equal;
mPSELarger.Caption:=txt_eqorlarger;
mPSLarger.Caption:=txt_larger;
mSize.Caption:=txt_all_size;
mSizeSmaller.Caption:=txt_smaller;
mSizeESmaller.Caption:=txt_eqorsmaller;
mSizeEqual.Caption:=txt_equal;
mSizeELarger.Caption:=txt_eqorlarger;
mSizeLarger.Caption:=txt_larger;
mSortBySelection.Caption:=txt_sortbysel;
mBrowse.Caption:=txt_browser;
mcolumns.Caption:=txt_2_9_columns;
mcname.Caption:=txt_name;
mctype.Caption:=txt_type;
mcsize.Caption:=txt_size;
mcpacked.Caption:=txt_info+' / '+txt_compressed_size;
mcdate.Caption:=txt_8_2_tm;
mcatt.Caption:=txt_attributes;
mccrc.Caption:=txt_check_select;
mcfree.Caption:=txt_free;
mcfs.Caption:=txt_fs;
mccreated.Caption:=txt_8_2_tc;
mcaccessed.Caption:=txt_8_2_ta;
mcmethod.Caption:=txt_method;
pmccreated.Caption:=txt_8_2_tc;
pmcaccessed.Caption:=txt_8_2_ta;
pmcmethod.Caption:=txt_method;
mbrowsersort.Caption:=txt_3_7_sort+' (Alt+5)';
mthumbimages.Caption:=txt_4_0_thim;
msimplesearch.Caption:=txt_4_1_simplesearch;
mrecsearch.Caption:=txt_4_3_recsrc;
mbtext.Caption:=txt_2_9_vst;
po_sortby.Caption:=txt_3_7_sort;
mbrowserccreated.Caption:=txt_8_2_tc;
mbrowsercaccessed.Caption:=txt_8_2_ta;
mbrowsercmethod.Caption:=txt_method;
mbrowserccomment.Caption:=txt_7_4_comment;
po_browserccomment.Caption:=txt_7_4_comment;
po_browserccreated.Caption:=txt_8_2_tc;
po_browsercaccessed.Caption:=txt_8_2_ta;
po_browsercmethod.Caption:=txt_method;
mbrowsercname.Caption:=txt_name;
mbrowserctype.Caption:=txt_type;
mbrowsercsize.Caption:=txt_size;
mbrowsercpacked.Caption:=txt_info+' / '+txt_compressed_size;
mbrowsercdate.Caption:=txt_datetime;
mbrowsercatt.Caption:=txt_attributes;
mbrowserccrc.Caption:=txt_check_select;
po_browsercname.Caption:=txt_name;
po_browserctype.Caption:=txt_type;
po_browsercsize.Caption:=txt_size;
po_browsercpacked.Caption:=txt_info+' / '+txt_compressed_size;
po_browsercdate.Caption:=txt_datetime;
po_browsercatt.Caption:=txt_attributes;
po_browserccrc.Caption:=txt_check_select;
mshowmenu.Caption:=txt_2_9_showmenu;
pmshowmenu.Caption:=txt_2_9_showmenu;
MenuItemOrganizeMbar.Caption:=txt_2_9_showmenu;
MenuItemOrganizeToolbar.Caption:=txt_4_5_shtool;
mshowtoolbar.Caption:=txt_4_5_shtool;
mtoggletool.Caption:=txt_8_9_ttb;
MenuItemOrganizeNavbar.Caption:=txt_4_5_shnav;
mshownavbar.Caption:=txt_4_5_shnav;
mshowsidebar.Caption:=txt_9_6_scside;
msidebar.Caption:=txt_9_6_cside;
MenuItemOrganizeStatusbar.Caption:=txt_4_5_shstatus;
mshowstatusbar.Caption:=txt_4_5_shstatus;
MenuItemProperties.Caption:=txt_4_5_properties;
pmproperties.Caption:=txt_4_5_properties;
mproperties.Caption:=txt_4_5_properties;
pmmorefun_properties.Caption:=txt_4_5_properties;
mgolayout.Caption:=txt_2_7_goarclayout;
mgoextlayout.Caption:=txt_2_7_goextlayout;
mFlat.Caption:=txt_toggle_browseflat;
mFlatArchives.Caption:=txt_9_8_alwaysflat;
pmFlatArchives.Caption:=txt_9_8_alwaysflat;
pmFlat.Caption:=txt_toggle_browseflat;
mRefresh.Caption:=txt_fefreshf5;
mOptionsMenu.Caption:=txt_tools;
mAdmin.Caption:=txt_4_1_runasadmin;
mUser.Caption:=txt_run_as2;
po_alltasks.Caption:=txt_3_2_alltasks;
mBenchpea.Caption:=txt_sysbenchmark+' (pea)';
mBench.Caption:=txt_sysbenchmark+' (7z / p7zip)';
mloadprofile.Caption:=txt_9_6_loadp;
msaveprofile.Caption:=txt_9_6_savep;
mLang.Caption:=txt_localization;
w7contextlang.Caption:=txt_5_3_cml;
mprofileultra7z.Caption:=txt_5_3_profilebest;
mprofilenormal7z.Caption:=txt_5_3_profileadvanced;
mprofiletarzst.Caption:=txt_7_1_profileintermediate;
mprofilenormalzip.Caption:=txt_5_3_profilenormal;
mprofilefastzip.Caption:=txt_5_3_profileveryfast;
mprofile7zfast.Caption:=txt_7_3_profile7zfast;
mprofile7zfastest.Caption:=txt_7_3_profile7zfastest;
mprofileencrypt7z.Caption:=txt_5_3_profilepassword;
mprofilesplitzip.Caption:=txt_5_3_profile10mb;
mprofileauto.Caption:=txt_5_3_profilesfx;
mprofileextremezpaq.Caption:=txt_7_2_extcompultra;
mprofiletarxz.Caption:=txt_7_2_extcomp;
mprofiletargz.Caption:=txt_7_2_altcomp;
mprofilerar.Caption:=txt_7_4_presetrar;
mprofilezstd.Caption:=txt_7_4_7zfzstandardcomp;
mprofilesave.Caption:=txt_7_2_savecompsettings;
mprofileload.Caption:=txt_7_2_loadcompsettings;
msavecompsettings.Caption:=txt_7_2_savecompsettings;
mloadcompsettings.Caption:=txt_7_2_loadcompsettings;
mDefaults.Caption:=txt_settings;
msettings.Caption:=txt_settings;
marcopt.Caption:=txt_7_4_setarc;
mextopt.Caption:=txt_7_4_setext;
LabelConfigurearc.Caption:=txt_7_4_setarc;
LabelConfigureext.Caption:=txt_7_4_setext;
mHelp.Caption:=txt_2_5_help;
mAbout.Caption:=txt_about+'...';
mupdate.caption:=txt_4_5_update;
pmtoolcompact.Caption:=txt_9_2_compact;
mtranslationsfaq.Caption:=txt_9_2_tfaq;
LabelUpdates.Caption:=txt_9_2_updates;
LabelDoc.Caption:=txt_9_2_doc;
mplugins.caption:=txt_5_5_plugin;
mPeaSiteMirror.Caption:=txt_peazip_web;
mPeaSupport.Caption:=txt_peazip_help;
mPeaFAQ.Caption:='FAQ';
mPeaTracker.Caption:=txt_3_7_tracker;
mpeachangelog.Caption:=txt_9_2_changelog;
mPeatos.Caption:=txt_9_2_tos;
MenuItemDonations.Caption:=txt_3_7_donations;
mpeahelpoffline.Caption:=txt_2_5_offline_help+' (EN, .pdf)';
mtutorial.Caption:=txt_2_5_offline_help;
po_addtoarchive.Caption:=txt_add;
MenuItemTextEncoding.Caption:=txt_7_6_zipenc;
pmtextenc.Caption:=txt_7_6_zipenc;
mtenc.Caption:=txt_7_6_zipenc;
zencmore.Caption:=txt_2_5_encoding+'...';
zenclocalutf8.Caption:=txt_7_6_defaultenc;
zencutf8.Caption:=txt_7_6_forceutf8enc;
zenclocal.Caption:=txt_7_6_forcelocalenc;
mzencmore.Caption:=txt_2_5_encoding+'...';
mzenclocalutf8.Caption:=txt_7_6_defaultenc;
mzencutf8.Caption:=txt_7_6_forceutf8enc;
mzenclocal.Caption:=txt_7_6_forcelocalenc;
azencmore.Caption:=txt_2_5_encoding+'...';
azenclocalutf8.Caption:=txt_7_6_defaultenc;
azencutf8.Caption:=txt_7_6_forceutf8enc;
azenclocal.Caption:=txt_7_6_forcelocalenc;
MenuItemOpen_ExtractHere.Caption:=txt_caption_extract;
MenuItemOpen_ext_all.Caption:=txt_ext_all;
MenuItemOpen_ext_displayed.Caption:=txt_ext_disp;
MenuItemOpen_ext_selected.Caption:=txt_ext_sel;
po_exthere.Caption:=txt_caption_extract;
po_checkmotw.Caption:=txt_10_5_checkmotw;
po_motwfull.Caption:=txt_10_5_checkmotw+' '+txt_10_5_fr;
pmmoremotw.Caption:=txt_10_5_checkmotw;
layoutmotw.Caption:=txt_10_5_checkmotw;
layoutmotwfull.Caption:=txt_10_5_checkmotw+' '+txt_10_5_fr;
MenuItemOpen_test.Caption:=txt_caption_test;
MenuItemOpen_test_all.Caption:=txt_testall;
MenuItemOpen_test_displayed.Caption:=txt_testdisp;
MenuItemOpen_test_selected.Caption:=txt_testsel;
po_test.Caption:=txt_caption_test;
MenuItemOpen_info.Caption:=txt_list_details;
MenuItemOpen_info_all.Caption:=txt_list_all;
MenuItemOpen_info_displayed.Caption:=txt_list_disp;
MenuItemOpen_info_selected.Caption:=txt_list_sel;
po_info.Caption:=txt_list_details;
pmmorefun_info.Caption:=txt_list_details;
pmmorefun_details.Caption:=txt_info;
pmmoretest.Caption:=txt_caption_test;
po_details.Caption:=txt_info;
pmsinfo.Caption:=txt_info;
pmcpyto.Caption:=txt_copyto;
pmmvto.Caption:=txt_moveto;
pmexplore.Caption:=txt_explore_path;
pmbookmarks.Caption:=txt_add_tobookmarks;
pmbcaddbookmark.Caption:=txt_add_tobookmarks+' (F7)';
pmbcorganizebookmarks.Caption:=txt_2_9_organize+' '+txt_bookmarks;
MenuItemOpen_organizebookmarks.Caption:=txt_2_9_organize+' '+txt_bookmarks;
pmorganizebookmarks.Caption:=txt_2_9_organize+' '+txt_bookmarks;
pmws.Caption:=txt_search_web;
pmcommand.Caption:=txt_cphere;
pmrecycle.Caption:=txt_4_7_recycle;
pmfunaz.Caption:=txt_4_8_fun;
pmcut.Caption:=txt_cut;
{$IFDEF MSWINDOWS}pmquickdelete.Caption:=txt_quickdelete+' (Shift+Del)';{$ELSE}pmquickdelete.Caption:=txt_quickdelete;{$ENDIF}
pmsecuredelete.Caption:=txt_securedelete+' (Ctrl+Del)';
MenuItemOpen_list.Caption:=txt_caption_list;
MenuItemOpen_list_all.Caption:=txt_list_all;
MenuItemOpen_list_displayed.Caption:=txt_list_disp;
MenuItemOpen_list_selected.Caption:=txt_list_sel;
po_list.Caption:=txt_caption_list;
pmmorefun_list.Caption:=txt_caption_list;
pmmoreadd.Caption:=txt_add;
pmmoreconvert.Caption:=txt_2_8_convert;
pmmoreextract.Caption:=txt_caption_extract;
ImageFlatadd.Hint:=txt_add;
ImageFlatconvert.Hint:=txt_2_8_convert;
ImageFlatext.Hint:=txt_caption_extract;
ImageFlatdup.Hint:=txt_4_1_duplicatesfind;
ImageFlatfolder.Hint:=txt_create_folder;
ImageFlatren.Hint:=txt_rename;
ImageFlattransform.Hint:=txt_4_8_t;
ImageFlatcrop.Hint:=txt_4_8_crop;
ImageFlattestmore.Hint:=txt_caption_test+', '+txt_caption_list+'...';
MenuItemOpen_preview.Caption:=txt_previewwith;
MenuItemPrePeaZip.Caption:=txt_peazip_new;
MenuItemPreAssociated.Caption:=txt_associated;
MenuItemPreCustom.Caption:=txt_customapp;
MenuItemOpen_extandopenwith.Caption:=txt_extopen_with;
MenuItemERPeaZip.Caption:=txt_peazip_new;
MenuItemERAssociated.Caption:=txt_associated;
MenuItemERCustom.Caption:=txt_customapp;
MenuItemPreBrowser.Caption:=txt_filebrowser;
MenuItemERBrowser.Caption:=txt_filebrowser;
po_open_browser.Caption:=txt_filebrowser;
po_open.Caption:=txt_openwith;
po_open_asarchive.Caption:=txt_3_1_openasarchive;
po_open_asarchivet.Caption:=txt_3_1_openasarchive;
po_open_peazip.Caption:=txt_peazip_new;
po_open_associated.Caption:=txt_associated;
po_open_custom.Caption:=txt_customapp;
MenuItemOpen_addtobookmarks.Caption:=txt_add_tobookmarks;
MenuItemOpen_explore.Caption:=txt_explore_path;
MenuItemOpen_commandprompt.Caption:=txt_cphere;
mbpea.Caption:=txt_go_path;
mbexplore.Caption:=txt_explore_path;
mbcl.Caption:=txt_cphere;
po_filetools.Caption:=txt_filetools;
po_functionsaz.Caption:=txt_4_8_fun;
po_split.Caption:=txt_split_file;
po_join.Caption:=txt_joinfiles;
po_compare.Caption:=txt_compare;
po_check.Caption:=txt_check;
po_checksum.Caption:=txt_check_select+' (CRC32)';
pmcheck.Caption:=txt_check_select+' (CRC32)';
po_pdup.Caption:=txt_4_1_duplicatesfind;
pmpdup.Caption:=txt_4_1_duplicatesfind;
po_dedup.Caption:=txt_4_1_duplicatesfind;
po_analyzefolders.Caption:=txt_7_0_af;
pmpanalyzefolders.Caption:=txt_7_0_af;
po_systemtools.Caption:=txt_systools;
po_linsystemtools.Caption:=txt_systools;
po_fm.Caption:=txt_4_6_fm;
po_diskclean.Caption:=txt_disk_cleanup;
po_defrag.Caption:=txt_disk_defrag;
po_manage.Caption:=txt_disk_management;
po_removeunits.Caption:=txt_remove_external_unit;
po_cpl.Caption:=txt_controlpanel;
po_computer.Caption:=txt_compmanagement;
po_taskman.Caption:=txt_taskman;
po_recycle.Caption:=txt_4_7_recycle;
mexploretrash.Caption:=txt_10_0_exptrash;
{$IFDEF MSWINDOWS}po_delete.Caption:=txt_quickdelete+' (Shift+Del)';{$ELSE}po_delete.Caption:=txt_quickdelete;{$ENDIF}
po_securedelete.Caption:=txt_securedelete+' (Ctrl+Del)';
po_newfolder.Caption:=txt_cnewfolder;
pmnewfolder.Caption:=txt_cnewfolder;
po_rename.Caption:=txt_rename+' (F2)';
pmr_ren.Caption:=txt_rename+' (F2)';
po_renmenu.Caption:=txt_rename;
pmrename.Caption:=txt_rename+' (F2)';
po_copyto.Caption:=txt_copyto;
po_moveto.Caption:=txt_moveto;
po_copy.Caption:=txt_copy+' (Ctrl+C)';
po_cut.Caption:=txt_cut+' (Ctrl+X)';;
po_paste.Caption:=txt_paste+' (Ctrl+V)';
po_setpw.Caption:=txt_2_7_setpw;
menupw.Caption:=txt_2_7_setpw;
msetpw.Caption:=txt_2_7_setpw;
pmqesetpw.Caption:=txt_2_7_setpw;
madvfilters.caption:=txt_advfilters;
pmadvf.caption:=txt_advfilters;
mfilterbrowser.caption:=txt_8_5_advbrowser;
mOptions.Caption:=txt_options;
sbBrowse.Caption:=txt_browse;
MenuItemOpen_up.Caption:=txt_up;
MenuItemOpen_back.Caption:=txt_back;
MenuItemOpen_fwd.Caption:=txt_fwd;
MenuItemOpen_root.Caption:=txt_mypc;
MenuItemopendesktop.Caption:=txt_desktop;
MenuItemopendownloads.Caption:=txt_3_1_downloads;
MenuItemopendocuments.Caption:=txt_2_4_documents;
MenuItemOpen_jump.Caption:=txt_go_path;
MenuItemOpen_Flat.Caption:=txt_toggle_browseflat;
MenuItemOpen_refresh.Caption:=txt_fefreshf5;
mnav.Caption:=txt_2_9_nav;
pmsearchdrag.Caption:=txt_searchanddrag;
pmsearchweb.Caption:=txt_search_web;
MenuItemOpenhome.Caption:=txt_2_9_home;
MenuItemOpen_home1.Caption:=txt_2_9_home;
MenuItemOpen_desktop1.Caption:=txt_desktop;
MenuItemOpen_path.Caption:=txt_open_path;
MenuItemOpen_archive.Caption:=txt_openarchive;
MenuItemOpenWeb.Caption:=txt_search_web;
mwebsearch.Caption:=txt_search_web;
pmOpenPJall.Caption:=txt_all;
pmOpenPJdisplayed.Caption:=txt_displayedobjects;
pmOpenPJselected.Caption:=txt_selected_objects;
pmextcontextall.Caption:=txt_ext_all;
pmextcontextdisplayed.Caption:=txt_ext_disp;
pmextcontextselected.Caption:=txt_ext_sel;
pmtestcontextall.Caption:=txt_testall;
pmtestcontextdisplayed.Caption:=txt_testdisp;
pmtestcontextselected.Caption:=txt_testsel;
pmqeall.Caption:=txt_ext_all+' (Ctrl+L)';
pmqedisplayed.Caption:=txt_ext_disp+' (Ctrl+S)';
pmqeselected.Caption:=txt_ext_sel+' (Ctrl+E)';
pmJump1.Caption:=txt_mypc;
MenuItemOpen_pc.Caption:=txt_mypc;
MenuItemArchive_pc.Caption:=txt_mypc;
pmJump3.Caption:=txt_2_9_home;
pmJump2.Caption:=txt_desktop;
pmsoppath.Caption:=txt_open_path;
pmsoparch.Caption:=txt_openarchive;
mbNotes.Caption:=txt_note;
mbDelete.Caption:=txt_remove_bookmark;
mbAddPath.Caption:=txt_add_path;
mbAddArchive.Caption:=txt_add_archive;
cbUn7zaRecursive.Hint:=txt_search_hint;
cbUn7zaRecursiveExclude.Hint:=txt_search_hint;
ComboBoxOverwrite.Hint:=txt_naming;
ComboBoxOverwriteARC.Hint:=txt_naming;
EditCustomParamExt.Hint:=txt_otherparams;
OpenDialogLang.Title:=txt_open_file;
OpenDialogList.Title:=txt_open_files;
OpenDialogArchive.Title:=txt_open_file;
OpenDialogTheme.Title:=txt_open_file;
OpenDialogProfile.Title:=txt_open_file;
OpenDialogApps1.Title:=txt_open_file;
SelectDirectoryDialog1.Title:=txt_selectdir;
SaveDialogPJ.Title:=txt_savejobdefinition;
SaveDialogAS.Title:=txt_saveas;
OpenDialogCustom.Title:=txt_open_file;
po_convert.Caption:=txt_convert;
mextractarchive.caption:=txt_archive;
mtogglenew.caption:=txt_newfoldermenu+' (Shift+Ctrl+N)';
mcancel.caption:=txt_2_7_cancel;
mgotype.caption:=txt_type;
ComboBoxTheme.Items.Strings[5]:=txt_custom;
ComboBoxPAQThreads.Items.Strings[0]:=txt_multithreading;
ComboBoxPAQLevel.Items.Strings[0]:=txt_level_fast;
ComboBoxPAQLevel.Items.Strings[1]:=txt_level_normal;
ComboBoxPAQLevel.Items.Strings[2]:=txt_level_maximum;
ComboBoxPAQLevel.Items.Strings[3]:=txt_level_ultra;
RadioGroupPaq.Items.Strings[2]:='ZPAQ';
ComboBoxUPX.Items.Strings[0]:=txt_nocompress;
ComboBoxUPX.Items.Strings[1]:='1 '+txt_faster;
ComboBoxUPX.Items.Strings[9]:='9 '+txt_better;
ComboBoxUPX.Items.Strings[10]:=txt_best;
ComboBoxPEALevel.Items.Strings[0]:=txt_bettercompression;
ComboBoxPEALevel.Items.Strings[1]:=txt_default_compression;
ComboBoxPEALevel.Items.Strings[2]:=txt_fastcompr;
ComboBoxPEALevel.Items.Strings[3]:=txt_nocompress_hint;
ComboBoxPEAObj.Items.Strings[13]:=txt_none2;
ComboBoxPEAVol.Items.Strings[13]:=txt_none2;
ComboBoxSplitAlgo.Items.Strings[13]:=txt_none2;
ComboBox7zFun.Items.Strings[0]:=txt_newarchive;
ComboBox7zFun.Items.Strings[1]:=txt_add_existing_archive;
ComboBox7zFun.Items.Strings[2]:=txt_update;
ComboBox7zFun.Items.Strings[3]:=txt_6_3_uar;
ComboBox7zFun.Items.Strings[4]:=txt_6_3_syn;
cbAct.Items.Strings[0]:=txt_newarchive;
cbAct.Items.Strings[1]:=txt_add_existing_archive;
cbAct.Items.Strings[2]:=txt_update;
cbAct.Items.Strings[3]:=txt_6_3_uar;
cbAct.Items.Strings[4]:=txt_6_3_syn;
ComboBoxArchiveActUpdate.Items.Strings[0]:=txt_newarchive;
ComboBoxArchiveActUpdate.Items.Strings[1]:=txt_add_existing_archive;
ComboBoxArchiveActUpdate.Items.Strings[2]:=txt_update;
ComboBoxArchiveActUpdate.Items.Strings[3]:=txt_6_3_uar;
ComboBoxArchiveActUpdate.Items.Strings[4]:=txt_6_3_syn;
ComboBox7zThreads.Items.Strings[0]:=txt_singlethread;
ComboBox7zThreads.Items.Strings[1]:=txt_multithreading;
ComboBox7zMemuse.Items.Strings[0]:=txt_default;
ComboBox7zLevel.Items.Strings[0]:=txt_level_store;
ComboBox7zLevel.Items.Strings[1]:=txt_level_fastest;
ComboBox7zLevel.Items.Strings[2]:=txt_level_fast;
ComboBox7zLevel.Items.Strings[3]:=txt_level_normal;
ComboBox7zLevel.Items.Strings[4]:=txt_level_maximum;
ComboBox7zLevel.Items.Strings[5]:=txt_level_ultra;
ComboBox7zSolid.Items.Strings[0]:=txt_nonsolid;
ComboBox7zSolid.Items.Strings[18]:=txt_solid;
ComboBox7zSolid.Items.Strings[19]:=txt_solid_extension;
RadioGroup7zSFX.Items.Strings[0]:=txt_console;
RadioGroup7zSFX.Items.Strings[1]:=txt_console+' (Linux)';
RadioGroup7zSFX.Items.Strings[2]:=txt_gui;
ComboBoxArchiveCustom.Items.Strings[0]:=txt_pio;
ComboBoxArchiveCustom.Items.Strings[1]:=txt_poi;
ComboBoxArchiveCustom.Items.Strings[2]:=txt_ipo;
ComboBoxArchiveCustom.Items.Strings[3]:=txt_iop;
ComboBoxArchiveCustom.Items.Strings[4]:=txt_opi;
ComboBoxArchiveCustom.Items.Strings[5]:=txt_oip;
ComboBoxARCLevel.Items.Strings[0]:='0 '+txt_store;
ComboBoxARCLevel.Items.Strings[1]:='1 '+txt_fastermem;
ComboBoxARCLevel.Items.Strings[4]:='4 '+txt_default2;
ComboBoxARCLevel.Items.Strings[9]:='9 '+txt_slowermem;
ComboBoxArcSolid.Items.Strings[0]:=txt_nonsolid;
ComboBoxArcSolid.Items.Strings[1]:=txt_solid_auto;
ComboBoxArcSolid.Items.Strings[2]:=txt_solid_extension;
ComboBoxARCFun.Items.Strings[0]:=txt_newarchive;
ComboBoxARCFun.Items.Strings[1]:=txt_add_existing_archive;
ComboBoxARCFun.Items.Strings[2]:=txt_update;
ComboBoxARCalgo.Items.Strings[3]:=txt_blowfish;
cbType.Items.Strings[8]:=txt_sfx+' '+STR_7Z;
cbType.Items.Strings[9]:=txt_sfx+' '+STR_ARC;
cbType.Items.Strings[10]:=txt_split;
ComboBoxOverwrite.Items.Strings[0]:=txt_skip_existing;
ComboBoxOverwrite.Items.Strings[1]:=txt_ren_extracted;
ComboBoxOverwrite.Items.Strings[2]:=txt_ren_existing;
ComboBoxOverwrite.Items.Strings[3]:=txt_overwrite;
ComboBoxOverwrite.Items.Strings[4]:=txt_overwrite_askbefore;
ComboBoxActionExtract.Items.Strings[0]:=txt_caption_extract;
ComboBoxActionExtract.Items.Strings[1]:=txt_ext_nopath;
ComboBoxActionExtract.Items.Strings[2]:=txt_caption_list;
ComboBoxActionExtract.Items.Strings[3]:=txt_list_details;
ComboBoxActionExtract.Items.Strings[4]:=txt_caption_test;
ComboBoxActionExtract.ItemIndex:=0;
CheckBoxExtActionAdv.Items.Strings[0]:=txt_caption_extract;
CheckBoxExtActionAdv.Items.Strings[1]:=txt_ext_nopath;
CheckBoxExtActionAdv.Items.Strings[2]:=txt_caption_list;
CheckBoxExtActionAdv.Items.Strings[3]:=txt_caption_test;
CheckBoxExtActionAdv.ItemIndex:=0;
ComboBoxOverwriteARC.Items.Strings[0]:=txt_overwrite_askbefore;
ComboBoxOverwriteARC.Items.Strings[1]:=txt_overwrite;
ComboBoxOverwriteARC.Items.Strings[2]:=txt_skip_existing;
ComboBoxActionArc.Items.Strings[0]:=txt_caption_extract;
ComboBoxActionArc.Items.Strings[1]:=txt_ext_nopath;
ComboBoxActionArc.Items.Strings[2]:=txt_caption_list;
ComboBoxActionArc.Items.Strings[3]:=txt_list_details;
ComboBoxActionArc.Items.Strings[4]:=txt_caption_test;
ComboBoxActionArc.Items.Strings[5]:=txt_caption_repair;
ComboBoxActionArc.ItemIndex:=0;
ComboBoxCustomSyntaxExt.Items.Strings[0]:=txt_pio;
ComboBoxCustomSyntaxExt.Items.Strings[1]:=txt_poi;
ComboBoxCustomSyntaxExt.Items.Strings[2]:=txt_ipo;
ComboBoxCustomSyntaxExt.Items.Strings[3]:=txt_iop;
ComboBoxCustomSyntaxExt.Items.Strings[4]:=txt_opi;
ComboBoxCustomSyntaxExt.Items.Strings[5]:=txt_oip;
cbDefaultFormat.Items.Strings[4]:=txt_custom;
cbDefaultFormat.Items[8]:=txt_sfx+' '+STR_7Z;
cbDefaultFormat.Items[9]:=txt_sfx+' '+STR_ARC;
cbDefaultFormat.Items.Strings[10]:=txt_split;
cbDefaultFormat.Items.Strings[18]:=txt_lastused;
ComboBoxPEALevel.Text:=txt_default_compression;
ComboBoxUPX.Text:=txt_best;
ComboBox7zThreads.Text:=txt_multithreading;
ComboBoxArchiveCustom.Text:=txt_pio;
ComboBoxArcSolid.Text:=txt_solid_auto;
ComboBoxARCFun.Text:=txt_newarchive;
EditOpenIn.Text:=txt_none;
ComboBoxOverwrite.Text:=txt_ren_extracted;
ComboBoxCustomSyntaxExt.Text:=txt_pio;
ComboBox7zFun.Text:=txt_newarchive;
except end;
end;
end;

function valorize_headers:integer;
var
   s:ansistring;
begin
valorize_headers:=-1;
readln(t,s);//translator(s)
langstrhint:=langstrhint+' - '+s;
readln(t,s);//last revision's translator(s)
langstrhint:=langstrhint+' - '+s;
readln(t,s);//last revision date
langstrhint:=langstrhint+' - '+s;
readln(t,s);
readln(t,s);//peazip text group
if s<>'=== PeaZip text group ===' then exit
else valorize_headers:=0;
end;

function load_texts(lang:ansistring):integer; //valorize localized text strings
var
   s:ansistring;
   i:integer;
begin
load_texts:=-1;
try
   assignfile(t,(sharepath+'lang'+directoryseparator+lang));
   filemode:=0;
   reset(t);
   read_header(t);
   readln(t,s); //declaration
   if (s<>'=== PeaZip language file ===') and (s<>'== PeaZip language file ===') then
      begin
      closefile(t);
      exit;
      end;
   readln(t,s);//language
   langstrhint:=s;
   readln(t,s); //version; PEAZIPREVISION is ignored since revisions are meant to share the same text
   langstrhint:=langstrhint+' - '+s;
   i:=-1;
      if valorize_headers=0 then i:=valorize_text;
   if i=0 then assign_guitext
   else
      begin
      closefile(t);
      exit;
      end;
   repeat //skip until about text group
      readln(t,s);
   until (eof(t)) or (s='=== about text group ===');
   if not eof(t) then
      begin
      readln(t,s);
      FormPeach.MemoAbout.Lines.Clear;
      FormPeach.MemoAbout.Lines.Append(APPMAIN+' '+PEAZIPVERSION+PEAZIPREVISION+' - '+caption_build);
      FormPeach.MemoAbout.Lines.Append('');
      FormPeach.MemoAbout.Lines.Append(txt_read+' '+READE_LIST);
      FormPeach.MemoAbout.Lines.Append('');
      FormPeach.MemoAbout.Lines.Append(txt_write+' '+WRITEE_LIST);
      FormPeach.MemoAbout.Lines.Append('');
      repeat
         readln(t,s);
         FormPeach.MemoAbout.Lines.Append(s);
      until eof(t);
      end;
   closefile(t);
   load_texts:=0;
except
   try
      closefile(t);
   except
   end;
   load_texts:=-1;
end;
end;

procedure load_default_texts;
begin
txt_10_7_errload:='Cannot display image';
txt_10_7_errfile:='File not found';
txt_10_7_first:='First';
txt_10_7_fit:='Fit to screen';
txt_10_7_fith:='Fit to screen height';
txt_10_7_fitw:='Fit to screen width';
txt_10_7_keep:='Keep output files if extraction ends in error or is cancelled';
txt_10_7_next:='Next';
txt_10_7_prev:='Previous';
txt_10_7_pwh:='Password from hash';
txt_10_7_images:='View images';
txt_10_7_thumbnails:='View thumbnails';
txt_10_6_virtual:='Dynamic virtual mode';
txt_10_5_fr:='(full report)';
txt_10_5_sectype:='Ask confirmation for running following file types';
txt_10_5_checkmotw:='Check Zone.Identifier (MoTW)';
txt_10_5_sectypewarning:='Do you want to run this file?';
txt_10_5_pathlock:='Items in this path of the archive cannot be edited';
txt_10_5_type_description_rar:='RAR: proprietary archive format, high compression ratio, supported through external compressor';
txt_10_5_sh:='Show hidden files (in the filesystem)';
txt_10_5_ntfsalt:='This format is able to store NTFS Alternate Data Stream, including Mark of The Web';
txt_10_4_moving:='(Moving)';
txt_10_3_classic:='Classic';
txt_10_3_ascii:='It is recommended to use only ASCII characters in passwords for the current archive format (mixed case letters, numbers, and special characters).';
txt_10_3_minimal:='Minimal';
txt_10_3_m:='Modern';
txt_10_3_pm:='Postmodern';
txt_10_3_aw:='Workaround: check "Force typing password interactively" in the password prompt, or set Console mode for backend binaries.';
txt_10_2_savecopy:='Save a copy';
txt_10_1_full:='Full';
txt_10_1_kdfw:='KDF work load';
txt_10_1_under:='Underlined';
txt_10_0_exptrash:='Explore Trash';
txt_10_0_ptarzst:='Fastest compression, TAR.ZST';
txt_10_0_ptarxz:='High compression, TAR.XZ';
txt_10_0_ptargz:='Medium compression, TAR.GZ';
txt_10_0_comp:='Pure compression formats only accept a single file as input. Archive conversion towards those formats will fail if the source contains multiple files or folders, which cannot be determined in advance.';
txt_10_0_save:='Save';
txt_10_0_tp:='Text preview';
txt_9_9_uac:='Current user cannot write to this output path. Do you want to run PeaZip with UAC elevation?';
TXT_9_9_kdf:='KDF rounds';
txt_9_9_utc:='Show timestamps as UTC';
txt_9_8_alwaysflat:='Always open archives in flat view';
txt_9_8_fnew:='Extract here (in new folder)';
txt_9_8_fsmart:='Extract here (smart new folder)';
txt_9_7_tarpipe:='7z / p7zip use pipe';
txt_9_7_smartsorting:='Smart file name sorting';
txt_9_6_centered:='Centered';
txt_9_6_cside:='Compact side bar';
txt_9_6_loadpconfirm:='Do you want to load this profile? All the data of current profile will be overwritten, including saved scripts and Password Manager.';
txt_9_6_loadp:='Load profile';
txt_9_6_saveppw:='OPTIONAL: protect this profile with password / keyfile?';
txt_9_6_savepoverwrite:='Overwrite existing profile? All the data of the existing profile will be overwritten, including saved scripts and Password Manager.';
txt_9_6_savep:='Save profile';
txt_9_6_scside:='Show Compact side bar';
txt_9_5_all:='All';
txt_9_5_precond:='Pre-parse if errors are detected';
txt_9_5_largea:='Pre-parse large archives';
txt_9_5_mediuma:='Pre-parse medium archives';
txt_9_5_smalla:='Pre-parse small archives';
txt_9_5_reopentab:='Reopen last tab';
txt_9_5_savetabs:='Save tabs';
txt_9_5_sb:='Use binaries in system paths';
txt_9_4_r:='read';
txt_9_4_rw:='read/write';
txt_9_4_savecomment:='Save comment';
txt_9_4_hintcomment:='Type or paste comment, load or drag here comment file.';
txt_9_3_continue:='Continue anyway?';
txt_9_3_contrast:='Contrast';
txt_9_3_fsd:='Free space on destination may not be enough';
txt_9_3_fsw:='Free space on temporary work path may not be enough';
txt_9_3_mrar:='Manually set RAR binary';
txt_9_3_canedit:='This archive type can be edited';
txt_9_3_canforce:='This archive type can be edited (forced)';
txt_9_3_cannotedit:='This archive type cannot be edited';
txt_9_2_7za:='7z / p7zip alias';
txt_9_2_changelog:='Change log';
txt_9_2_tfaq:='Check for Translations';
txt_9_2_compact:='Compact';
txt_9_2_swt:='Swap Tool / Address bar';
txt_9_2_tos:='TOS, Privacy';
txt_9_2_doc:='Verify documentation, Issue Tracker...';
txt_9_2_updates:='Verify updates, binaries, Plugins...';
txt_9_1_7zs:='7z / p7zip syntax level';
txt_9_1_ac:='Archive conversion scripts allow user''s interaction';
txt_9_1_closeall:='Close all';
txt_9_1_enlargeicons:='Enlarge file browser icons';
txt_9_1_ef:='Exclude empty folders form archiving and extraction operations (7z / p7zip)';
txt_9_1_nw:='Open in a new window';
txt_9_1_qdup:='Use quick deduplication routine';
txt_9_0_autoexttar:='Auto extract TAR archive from compressed TAR.* files';
txt_9_0_accesstime:='Do not change last access time';
txt_9_0_mem:='Maximum memory usage';
txt_9_0_showmainmenu:='Open Main menu';
txt_9_0_navmenu:='Open Navigation menu';
txt_9_0_plugind:='Open plugin directory';
txt_9_0_df:='Sort dirs before files';
txt_9_0_hl:='Store hard links as links';
txt_9_0_sl:='Store symbolic links as links';
txt_9_0_tnav:='Toggle side bar';
txt_8_9_empty:='Archive seems empty';
txt_8_9_disp:='Displaying archive content';
txt_8_9_parsing:='Parsing archive content';
txt_8_9_stoptest:='Stop to inspect report for error, list, test, auto-test';
txt_8_9_ttb:='Toggle tool bar';
txt_8_8_ca:='Accent color';
txt_8_8_btn:='Button';
txt_8_8_cb:='Button color';
txt_8_8_centered:='Centered buttons';
txt_8_8_light:='Light';
txt_8_8_lnk:='Link';
txt_8_8_intnote:='Please note that "Extract then move" option (in Options > Settings > Archive manager) is ignored for composing the command line in Console tab.';
txt_8_8_snz:='Propagate Zone.Identifier stream (Windows)';
txt_8_8_sm:='Small icons size';
txt_8_8_solcol:='Breadcrumb bar';
txt_8_8_snoi:='Store owner/group ids (TAR, Linux)';
txt_8_8_snon:='Store owner/group names (TAR, Linux)';
txt_8_8_tab:='Tab';
txt_8_8_altt:='Tabs style';
txt_8_8_autotest:='Test archives after creation, if supported by the format';
txt_8_8_cw:='Window color';
txt_8_7_csvhelp:='"," international standard, ";" common in Latin locales';
txt_8_7_after:='After archiving / extraction';
txt_8_7_bintest:='binaries tested.';
txt_8_7_csv:='CSV separator';
txt_8_7_hok:='Hash of binaries used by PeaZip match with expected ones';
txt_8_7_mo:='Set archive manager options';
txt_8_7_showhm:='Open Browser header menu';
txt_8_7_showsearchbar:='Show search bar';
txt_8_7_showsm:='Open Style menu';
txt_8_7_hnotok:='Some hash of binaries used by PeaZip do not match with expected ones:';
txt_8_7_verifybin:='Verify hash of binaries';
txt_8_6_clear:='"Clear" option removes temp edited files, otherwise available for further editing.';
txt_8_6_noclear:='Discard all changes without updating the archive';
txt_8_6_nosimple:='Do not update archive, keep temp edited files for further editing';
txt_8_6_immediate:='Immediate execution';
txt_8_6_yessimple:='Update archive, keep temp edited files for further editing';
txt_8_5_advbrowser:='Apply filters to archive browser';
txt_8_5_detailslarge:='Details, large';
txt_8_5_intext:='Extract to temporary working directory then move to output destination, interactively ask before overwriting';
txt_8_5_listlarge:='List, large';
txt_8_5_loadlayout:='Load layout at startup';
txt_8_5_samplescripts:='Sample scripts';
txt_8_4_keepopenerrorslist:='Stop to inspect report for error, list';
txt_8_3_mbubin:='Binary';
txt_8_3_cw:='Change working directory? This will reset temporary work files and restart the application.';
txt_8_3_temperature:='Color temperature';
txt_8_3_mbudec:='Decimal';
txt_8_3_htab:='Highlight tabs';
txt_8_3_maxarg:='Maximum length of arguments';
txt_8_3_mbu:='Multiple-byte unit';
txt_8_3_prefalgo:='Preferred algorithms';
txt_8_3_skipdel:='Skip deletion of locked temp files (use reset to delete on demand)';
txt_8_3_lw:='Some files in working directory are locked and cannot be removed automatically';
txt_8_3_noupx:='This binary cannot be compressed (may be already compressed)';
txt_8_2_slower:='(slower)';
txt_8_2_df:='7z / p7zip display content of folders';
txt_8_2_vreport:='7z / p7zip non-verbose report';
txt_8_2_ta:='Accessed';
txt_8_2_tc:='Created';
txt_8_2_keep:='Keep files';
txt_8_2_tm:='Modified';
txt_8_2_skipet:='Skip testing for encryption';
txt_8_2_alltimes:='Store all timestamps';
txt_8_2_supportedby:='Supported by';
txt_8_1_preparse:='Always pre-parse archives';
txt_8_1_bo:='Browser optimization';
txt_8_1_bop:='Browser optimization options can be set from Options > Settings, General tab';
txt_8_1_nopreparse:='Do not pre-parse archives';
txt_8_1_ed:='error(s) detected.';
txt_8_1_togglearc:='Listing flat view of archive content may take long time, continue anyway?';
txt_8_1_preparsehint:='Optimize performances limiting pre-parsing of large archives. Pre-parsing is meant to detect in advance possible issues in archive content.';
txt_8_1_slow:='Slow';
txt_8_1_vslow:='Very slow';
txt_8_1_volumes:='volumes';
txt_8_0_altcol:='Alternate grid color';
txt_8_0_forcebrowse:='Browse non-canonical archive types (containers, disk images, installers,...)';
txt_8_0_commonalgo:='Common algorithms';
txt_8_0_forceconvert:='Convert non-canonical archive types';
txt_8_0_defaultactionhint:='Default action double-clicking a file associated with PeaZip from the system';
txt_8_0_defaultaction:='Default action on input (open, auto-extract...';
txt_8_0_enableextand:='Enable "Extract and open with" submenu';
txt_8_0_forcetyping:='Force typing passwords interactively';
txt_8_0_setpwopt:='Set password / keyfile options';
txt_8_0_forcetypinghelp:='If supported by the backend, the task will prompt interactively for password. LIMITATIONS: task will run in console, will not run unattended, and cannot browse archives with encrypted filenames.';
txt_7_9_spacing:='Spacing';
txt_7_9_zooming:='Zoom';
txt_7_8_changelocalization:='Change PeaZip language';
txt_7_8_custext:='Custom extension';
txt_7_8_destexistfile:='Destination already contains processed files. Replace files with same name?';
txt_7_8_dd:='Drag and Drop';
txt_7_8_priorityhigh:='High';
txt_7_8_priorityidle:='Idle';
txt_7_8_rel:='Extract then move to destination';
txt_7_8_prioritynormal:='Normal';
txt_7_8_priorityrealtime:='Real time';
txt_7_8_requirerestart:='[REQUIRES RESTARTING PEAZIP]';
txt_7_8_tpriority:='Tasks priority';
txt_7_8_update:='Update';
txt_7_7_noneall:='None (no preview, no Drag And Drop extraction)';
txt_7_7_nonetemp:='None, preview in User''s temp';
txt_7_7_outtemp:='Output, preview in User''s temp';
txt_7_7_sys7zreq:='Requires 7z, 7-Zip, or p7zip, or equivalent package to be installed';
txt_7_7_tw:='Temporary work folder for archive creation, editing, preview and drag and drop extraction.';
txt_7_7_sys7z:='Use system 7z if available';
txt_7_6_zipenc:='ZIP filenames encoding';
txt_7_6_color:='Color';
txt_7_6_custenc:='Custom code page';
txt_7_6_dark:='Darker';
txt_7_6_tno:='Do not sync archive tree';
txt_7_6_forcelocalenc:='Force local';
txt_7_6_forceutf8enc:='Force UTF-8';
txt_7_6_cpnote:='If the chosen custom code page is unsupported, tasks will always end in error (most likely memory allocation error). In case that happens, change code page or reset the application.';
txt_7_6_defaultenc:='Local, UTF-8 for extra symbols';
txt_7_6_dim:='Dark';
txt_7_6_setcurdef:='Set current path as default output path';
txt_7_6_setdef:='Set default output path';
txt_7_6_tadvanced:='Sync archive tree, keep visited nodes';
txt_7_6_tsimple:='Sync archive tree, simple';
txt_7_6_tacolor:='Text accent color';
txt_7_5_always:='Always';
txt_7_5_ask:='Ask';
txt_7_5_autoclosesingle:='Auto close after extraction if no browsing actions took place';
txt_7_5_cutlen:='Cut name at specified length';
txt_7_5_cutlenw:='Cut name at specified length (4..255) naming conflicts can be fixed manually later';
txt_7_5_dragnone:='Do not lock target';
txt_7_5_specialbrowse:='Do you want to extract everything in order to provide the file with the extra data it may need?';
txt_7_5_ee:='Extract everything for special file types';
txt_7_5_draghide:='Hide drop target';
txt_7_5_repnascii:='Replace/remove non-ASCII characters';
txt_7_5_draglh:='Lock and hide target';
txt_7_5_draglock:='Lock drop target';
txt_7_5_never:='Never';
txt_7_4_comment:='Comment';
txt_7_4_7zfbrotlicomp:='Fastest compression, 7Z Brotli';
txt_7_4_7zfzstandardcomp:='Fastest compression, 7Z Zstandard';
txt_7_4_presetrar:='High compression, RAR';
txt_7_4_tkeep:='Keep original archive timestamp';
txt_7_4_lock:='Lock archive';
txt_7_4_locked:='locked';
txt_7_4_lockconfirm:='Locked archives cannot be further modified, proceed locking this archive?';
txt_7_4_recover:='Recover archive';
txt_7_4_tcurr:='Set archive timestamp from current system time';
txt_7_4_setarc:='Set advanced archiving options';
txt_7_4_setext:='Set advanced extraction options';
txt_7_4_swzipx:='Switch to zipx extension for non-Deflate zip archives';
txt_7_3_archiveerrors:='[archive may contain errors]';
txt_7_3_archiveerrorshint:='Archive may not be valid (due missing, corrupted, or out of standard data), it is possible to run Test for detailed information. If archive''s table of content is encrypted, password is needed before browsing it.';
txt_7_3_clickextall:='Click "Extract all" to enable';
txt_7_3_noconfdel:='Do not ask confirmation for delete after archiving / extraction';
txt_7_3_profile7zfastest:='Fast compression, 7Z fastest';
txt_7_3_maxbr:='Maximize Brotli compression using more memory (may be incompatible with some other Brotli extractors)';
txt_7_3_maxzstd:='Maximize Zstandard compression using more memory';
txt_7_3_profile7zfast:='Medium compression, 7Z fast';
txt_7_3_stl:='Set archive timestamp from most recent file';
txt_7_2_altcomp:='High compression, ARC';
txt_7_2_clearnoupdate:='Clear edited files';
txt_7_2_autoclosepeazip:='Close PeaZip when task completes';
txt_7_2_zpaqall:='Extract all revisions';
txt_7_2_extcomp:='Extreme compression, ZPAQ';
txt_7_2_extcompultra:='Extreme compression, ZPAQ ultra';
txt_7_2_fbrotlicomp:='Fastest compression, Brotli';
txt_7_2_fzstandardcomp:='Fastest compression, Zstandard';
txt_7_2_loadcompsettings:='Load compression settings';
txt_7_2_savecompsettings:='Save compression settings';
txt_7_2_source:='Source';
txt_7_2_updateclear:='Update archive, clear edited files';
txt_7_1_type_description_brotli:='Brotli: fast compressor from Google, very fast decompression';
txt_7_1_new:='Extract all here (in new folder)';
txt_7_1_smart:='Extract all here (smart new folder)';
txt_7_1_profileintermediate:='Medium compression, ZIP/BZip2 fast';
txt_7_1_renfilesonly:='Rename only files';
txt_7_1_typetosearch:='Type to search in current path';
txt_7_1_type_description_zstd:='Zstandard: fast compressor from Facebook, very fast decompression';
txt_7_0_af:='Analyze content of folders';
txt_7_0_autoopentar:='Auto open single tar archive inside tar.* files';
txt_7_0_exttmppath:='Content will be extracted outside the temporary work path, in ';
txt_6_9_autou:='Auto update modified files in archives';
txt_6_9_forceu:='Update edited files in archive';
txt_6_9_opuns:='Operation not supported for current archive type';
txt_6_9_overarch:='Overwrite file(s) with same name already existing inside the archive?';
txt_6_9_uconf:='Previewed file has been modified. Update the current archive?';
txt_6_8_ndrop:='Use native Drag and Drop on Windows';
txt_6_7_nop:='(no preview)';
txt_6_6_pdupfound:='possible duplicates found (quick approximate test)';
txt_6_6_rsh:='Reset search history';
txt_6_6_pdupfind:='Suggest duplicates';
txt_6_6_forcemodify:='Edit non-canonical archive types as';
txt_6_5_mandatory:='(mandatory)';
txt_6_5_abort:='Abort';
txt_6_5_askp:='Ask to set password at startup';
txt_6_5_chp:='Change password';
txt_6_5_def:='Definition';
txt_6_5_nop:='Don''t ask to set password at startup';
txt_6_5_error:='Error';
txt_6_5_seqerr:='Error(s) detected, original files will not be deleted';
txt_6_5_sni:='Include NT security information';
txt_6_5_sns:='Include NTFS Alternate Data Stream';
txt_6_5_privacy:='Privacy and Security';
txt_6_5_showvolatile:='Show which options are volative / context depentent';
txt_6_5_force:='Try to open archives containing errors';
txt_6_5_warning:='Warning';
txt_6_5_yes:='Yes';
txt_6_5_yesall:='Yes to all';
txt_6_5_np:='You can now change password of converted archive(s) to a new one, or blank the password to skip encryption';
txt_6_4_absolute:='Absolute paths';
txt_6_4_appdirn:='Append directory name';
txt_6_4_closeallother:='Close all other tabs';
txt_6_4_closeright:='Close tabs on the right';
txt_6_4_collapse:='Collapse tabs';
txt_6_4_expand:='Expand tabs';
txt_6_4_full:='Full paths';
txt_6_4_new:='New';
txt_6_4_openintab:='Open in a new tab';
txt_6_4_paths:='Paths';
txt_6_4_prepdirn:='Prepend directory name';
txt_6_4_relative:='Relative paths';
txt_6_4_tabbar:='Tab bar';
txt_6_3_autoadjust:='Auto adjust columns';
txt_6_3_cinfo:='Info and comments';
txt_6_3_syn:='Synchronize archive with disk';
txt_6_3_uar:='Update only files already in archive';
txt_6_2_encext:='Add ".enc" suffix to encrypted archives';
txt_6_2_archive:='Archive file type';
txt_6_2_container:='Container file type';
txt_6_1_ec:='Expand / collapse archive tree';
txt_6_0_msq:='Sort by file type for solid compression';
txt_5_9_lff:='Analyze files and folders';
txt_5_9_pff:='Analyze, show files header/EOF';
txt_5_9_start:='Start from';
txt_5_8_l0:='Allow any supported component/format';
txt_5_8_l1:='Allow only Free Software components';
txt_5_8_l2:='Allow only open archive formats';
txt_5_8_ascii:='ASCII safe, scripts are safe on legacy environments';
txt_5_8_cp:='Code Page safe, scripts may trigger problems on legacy environments with different Code Pages';
txt_5_8_fs:='Free Software compliance';
txt_5_8_utf:='Scripts need full UTF-8 / Unicode environment';
txt_5_8_fsr:='This format is not supported due Free Software compliance restrictions (Options > Advanced)';
txt_5_7_pinstalled:='INSTALLED';
txt_5_7_pmissing:='MISSING';
txt_5_7_plugin:='Plugin missing, can be installed from Help > Check for Plugins';
txt_5_6_basic:='Basic';
txt_5_6_exarc:='Extract archive';
txt_5_6_tab:='Open in new tab';
txt_5_6_rc:='Right click for options';
txt_5_6_layouts:='Saved layouts';
txt_5_6_upexisting:='Update existing archive';
txt_5_6_verbose:='Verbose';
txt_5_5_case:='(case sensitive)';
txt_5_5_add:='Add string at specified position';
txt_5_5_addsel:='Add to current selection';
txt_5_5_ext:='Change files extension';
txt_5_5_plugin:='Check for Plugins';
txt_5_5_copypath:='Copy path';
txt_5_5_delete:='Delete characters at specified position';
txt_5_5_halt:='Halt system when task completes';
txt_5_5_positionw:='Hint: 1 add before first char, 2 second, etc... "z" for end of file name';
txt_5_5_positionwd:='Hint: 1 delete from first char included, 2 second, ... "z" for end of file name';
txt_5_5_replaceneww:='Hint: provide an empty new string to simply remove the old string';
txt_5_5_lower:='Lowercase';
txt_5_5_replaceoldw:='Modify all occurrences of this string or character in the file name';
txt_5_5_newext:='New extension';
txt_5_5_new:='New string';
txt_5_5_n:='Number of characters to delete';
txt_5_5_old:='Old string';
txt_5_5_position:='Position (number or "z" for end)';
txt_5_5_intdir:='Smart new folder';
txt_5_5_replacestr:='Replace/remove string';
txt_5_5_datesameday:='Same day of selected object';
txt_5_5_datesamehour:='Same hour of selected object';
txt_5_5_datesamemonth:='Same month of selected object';
txt_5_5_datesameweek:='Same week of selected object';
txt_5_5_datesameyear:='Same year of selected object';
txt_5_5_scan:='Scan';
txt_5_5_select:='Select';
txt_5_5_similar:='Similar to selected object';
txt_5_5_starting:='Starting with same character';
txt_5_5_string:='String to add';
txt_5_5_subtractsel:='Subtract from current selection';
txt_5_5_datehour:='This hour';
txt_5_5_datemonth:='This month';
txt_5_5_dateweek:='This week';
txt_5_5_dateyear:='This year';
txt_5_5_dateday:='Today';
txt_5_5_upper:='Uppercase';
txt_5_5_extw:='Warning: changing file extension the file may become unusable';
txt_5_4_da:='Date added';
txt_5_4_deletearchives:='Delete archives after extraction';
txt_5_4_deletefiles:='Delete files after archiving';
txt_5_4_deleteoriginal:='Deletion procedure, as set in main screen, will be appended to the script.';
txt_5_4_lv:='Last visited';
txt_5_4_deletearchivesconfirm:='Confirm deletion of original archives?';
txt_5_4_deletefilesconfirm:='Confirm deletion of original files?';
txt_5_4_used:='Used';
txt_5_3_profilebest:='Extreme compression, 7Z ultra';
txt_5_3_profileadvanced:='High compression, 7Z';
txt_5_3_profilenormal:='Medium compression, ZIP (compatible with most extractors)';
txt_5_3_profileveryfast:='Fast compression, ZIP fast (compatible with most extractors)';
txt_5_3_profilepassword:='Protect with password, 7Z format';
txt_5_3_profile10mb:='Keep output under 10 MB, for mail attachment limitations';
txt_5_3_profilesfx:='Auto extracting, recipient will not need an extraction software';
txt_5_3_cml:='System context menu language';
txt_5_3_cmlmessage:='Double click on desired context menu language and confirm registry merging. This setting needs to be re-applied when the application is installed/updated or after System integration wizard is used.';
txt_5_3_exc:='Exclusion filters prevail on inclusion filters';
txt_5_3_ia:='Include also';
txt_5_3_io:='Include only';
txt_5_3_rec:='Recurse subdirs';
txt_5_3_resetsi:='Re-configure system integration (context menu, SendTo, file associations)?';
txt_5_2_oadd:='Archive to original path';
txt_5_2_zerodelete:='Do you want to delete and overwrite with all 0 selected file(s)? The operation can''t be undone and files will be not recoverable';
txt_5_2_zfree:='Do you want to overwrite with all 0 free space on this drive?';
txt_5_2_sdfree:='Do you want to securely delete free space on this drive?';
txt_5_2_oext:='Extract to original path';
txt_5_2_securedeletefree:='Secure delete free space';
txt_5_2_free:='This operation can take some minutes and, if performed often, it can quickly wear flash-based disks';
txt_5_2_zerofiles:='Zero delete';
txt_5_2_zerofree:='Zero delete free space';
txt_5_1_schedadd:='Add schedule';
txt_5_1_schederr:='Cannot create schedule';
txt_5_1_daily:='Daily';
txt_5_1_day:='Day';
txt_5_1_days:='Days';
txt_5_1_enddate:='End date';
txt_5_1_every:='Every';
txt_5_1_w6:='Friday';
txt_5_1_hourly:='Hourly';
txt_5_1_hours:='Hours';
txt_5_1_last:='Last';
txt_5_1_schedmanage:='Task Scheduler, manage tasks saved in PeaZip branch';
txt_5_1_scriptmanage:='Manage saved scheduled scripts';
txt_5_1_w2:='Monday';
txt_5_1_monthly:='Monthly';
txt_5_1_months:='Months';
txt_5_1_onlogin:='On login';
txt_5_1_onstart:='On start';
txt_5_1_once:='Once';
txt_5_1_w7:='Saturday';
txt_5_1_schedule:='Schedule';
txt_5_1_schedexplain:='Creates a plain text script from GUI task definition and schedule it. Scheduled tasks'' scripts are saved in "Scheduled scripts" folder. To edit or delete scheduled tasks you can use system''s Task Scheduler, all scheduled tasks created by PeaZip are collected in "PeaZip" branch of the tasks library.';
txt_5_1_schedok:='Schedule created successfully';
txt_5_1_schedscripts:='Saved scheduled scripts';
txt_5_1_startdate:='Start date';
txt_5_1_starttime:='Start time';
txt_5_1_w1:='Sunday';
txt_5_1_schedname:='Task name, identify both the saved scheduled script and the system''s scheduled task';
txt_5_1_ts:='Task Scheduler';
txt_5_1_w5:='Thursday';
txt_5_1_w3:='Tuesday';
txt_5_1_w4:='Wednesday';
txt_5_1_weekly:='Weekly';
txt_5_1_weeks:='Weeks';
txt_5_0_bc:='Breadcrumb';
txt_5_0_resetpm:='Do you confirm resetting Password Manager? All passwords stored in PeaZip''s Password Manager will be lost if confirmed.';
txt_5_0_enum:='Enumerate folder content';
txt_5_0_music:='Music';
txt_5_0_ps:='Open PowerShell here';
txt_5_0_perf:='Performances';
txt_5_0_pictures:='Pictures';
txt_5_0_removeall:='Remove all';
txt_5_0_resetbookmarks:='Reset Bookmarks to default? (Bookmarks can then be customized with Bookmarks > Organize)';
txt_5_0_sh:='Session history';
txt_5_0_skip:='Skip enumerating directories'' content in layout';
txt_5_0_videos:='Videos';
txt_4_9_frame:='Frame';
txt_4_9_listth:='List and thumbnails';
txt_4_9_shadow:='Shadow';
txt_4_9_style:='Style';
txt_4_8_attach25:='25 MB attachment';
txt_4_8_crop:='Crop';
txt_4_8_detailsno:='Details';
txt_4_8_details:='Details and thumbnails';
txt_4_8_fit:='Fit to';
txt_4_8_fitl:='Fit to largest';
txt_4_8_flip:='Flip';
txt_4_8_fullscreen:='Full screen';
txt_4_8_fun:='Functions';
txt_4_8_h:='Height';
txt_4_8_keeparchive:='Keep archive';
txt_4_8_noresize:='Keep original size';
txt_4_8_iconl:='Large images';
txt_4_8_iconm:='Icons and images';
txt_4_8_imagemanager:='Image manager';
txt_4_8_immersive:='Immersive';
txt_4_8_listno:='List';
txt_4_8_aspect:='Maintain aspect ratio';
txt_4_8_mirror:='Mirror';
txt_4_8_presets:='Presets';
txt_4_8_replace:='Replace original image(s)? "No" apply the transformation in new file(s).';
txt_4_8_resize:='Resize';
txt_4_8_rl:='Rotate left';
txt_4_8_rr:='Rotate right';
txt_4_8_stop:='Stop';
txt_4_8_t:='Transform';
txt_4_8_w:='Width';
txt_4_7_pk:='Create random password / keyfile';
txt_4_7_spchar:='Limit characters to letters and numbers';
txt_4_7_recycleask:='Move selected file(s) to Trash?';
txt_4_7_recycle:='Move to Trash';
txt_4_7_pcomp:='Potential compression';
txt_4_6_am:='Archive manager';
txt_4_6_fm:='File manager';
txt_4_6_users:='Users';
txt_4_5_goupdate:='A new version is available. Open PeaZip''s official website to download the update?';
txt_4_5_b:='Bottom';
txt_4_5_koupdate:='Cannot check for updates, no connection with update server';
txt_4_5_update:='Check for updates';
txt_4_5_dock:='Dock';
txt_4_5_l:='Left';
txt_4_5_noupdate:='PeaZip is up to date';
txt_4_5_properties:='Properties';
txt_4_5_r:='Right';
txt_4_5_pj:='Saved scripts';
txt_4_5_shaddress:='Show Address bar';
txt_4_5_shnav:='Show Side bar';
txt_4_5_shstatus:='Show Status bar';
txt_4_5_shtool:='Show Tool bar';
txt_4_5_upxpj:='Sorry, cannot export task definition since this action or option requires performing multiple distinct commands';
txt_4_5_t:='Top';
txt_4_4_confremoveall:='Remove all PeaZip customization files (Applications, Bookmarks)?';
txt_4_4_confremove:='Remove PeaZip configuration?';
txt_4_3_pwmanhint:='Double click to edit items in password list, rightclick for options, Ctrl+C to copy passwords';
txt_4_3_exppl:='Export password list';
txt_4_3_expple:='Encrypted (backup Password Manager)';
txt_4_3_keeppw:='Keep password/keyfile for current session';
txt_4_3_pwmanpwhint:='Setting a password/keyfile (optional) to encrypt password list is recommended, in this way authentication will be required to access to the Password Manager. Password/keyfile can be changed at any time from this form.';
txt_4_3_pwmanmaster:='Set/change PM master password';
txt_4_3_pwmanlist:='Password list';
txt_4_3_pwman:='Password Manager';
txt_4_3_pwmancorr:='Password Manager seems tampered or corrupted. Keep Password Manager anyway and try to recover current password list, if you trust it? (No will reset Password Manager, recommended)';
txt_4_3_expplp:='Plain text (all uses)';
txt_4_3_recsrc:='Recursive search by default';
txt_4_3_resetpm:='Reset Password Manager? All saved passwords will be deleted';
txt_4_3_breadcrumb:='Show Address as breadcrumb';
txt_4_2_arcabspath:='Use absolute paths';
txt_4_1_duplicateshint:='"size"/"checksum" string is reported in CRC column for all duplicate candidates found in current directory or search filter';
txt_4_1_adminhint:='(HINT: alternatively, you can request UAC elevation to work in protected paths, Alt+F10 or Options > Run as administrator)';
txt_4_1_selected:='(selected)';
txt_4_1_duplicatesfound:='duplicates found';
txt_4_1_duplicatesfind:='Find duplicates';
txt_4_1_runasadmin:='Run as administrator';
txt_4_1_simplesearch:='Simple search';
txt_4_0_thim:='Show picture thumbnails';
txt_3_8_type_description_wim:='WIM: Microsoft''s disk image format';
txt_3_8_type_description_xz:='XZ: powerful file compression based on LZMA2';
txt_3_7_donations:='Donations';
txt_3_7_nameasparent:='Name archive as selected item''s parent folder, if multiple items are added';
txt_3_7_tracker:='Issue Tracker';
txt_3_7_sort:='Sort by';
txt_3_7_swapbars:='Swap Tool bar / Address bar';
txt_3_7_themedbars:='Themed bars';
txt_3_6_ignoredd:='Always ignore paths for drag and drop extraction';
txt_3_6_close:='Close';
txt_3_6_resetapps:='Do you want to reset Applications (customizable group of programs and scripts to open files with, overriding file associations)?';
txt_3_6_ethemes:='Existing Themes';
txt_3_5_td:='Check for Themes';
txt_3_5_managecustomthemes:='Manage Themes';
txt_3_4_nopaths:='No paths';
txt_3_4_smallicons:='Icons';
txt_3_3_skipunits:='(Windows) Get volume information for network units, slower startup';
txt_3_3_stralt:='Alternative command, when no parameter is passed';
txt_3_3_apps:='Applications';
txt_3_3_multi:='Multiple selection';
txt_3_3_runexp:='Open a program, file, folder or website';
txt_3_3_apppath:='PeaZip''s folder';
txt_3_3_run:='Run';
txt_3_2_7zutf8nonascii:='7z / p7zip -mcu use UTF8 for file names containing non-ASCII symbols inside .zip files';
txt_3_2_alltasks:='All tasks';
txt_3_2_conf:='Configuration';
txt_3_2_donations:='Donate to charitable organizations';
txt_3_1_sccenc:='7z / p7zip -scc console character encoding';
txt_3_1_downloads:='Downloads';
txt_3_1_lib:='Libraries';
txt_3_1_more:='More';
txt_3_1_openasarchive:='Open as archive';
txt_3_1_sendto:='User''s SendTo menu folder';
txt_3_1_pathexc:='Path exceeding maximum allowed size';
txt_3_1_recent:='Recent';
txt_3_1_plsmartmin:='Run minimized, show/keep open only if needed';
txt_3_1_src:='Searches';
txt_3_1_systmp:='User''s temp';
txt_3_1_languagetools:='Translate';
txt_3_1_workingdir:='Working directory';
txt_3_0_nonreadableorpw:='Archive is not readable. The archive may not be valid, or its table of content could be encrypted. Would you like to try a password?';
txt_3_0_readablepw:='Archive is unreadable, may be password protected';
txt_3_0_configure:='File associations and system menu integration';
txt_3_0_resettmp:='Reset temporary work files';
txt_2_9_address:='Address bar';
txt_2_9_adv:='Advanced filters are applied when managing any file supported through 7z or FreeArc backends, see documentation, and overrides basic filters (that are used for search functions and are displayed in Bookmarks and History panels)';
txt_2_9_columns:='Columns';
txt_2_9_copyhere:='Copy here';
txt_2_9_noscan:='Don''t scan files being added to layout';
txt_2_9_extconsole:='Extraction console is available only while browsing archives';
txt_2_9_thl:='Highlight buttons';
txt_2_9_home:='Home';
txt_2_9_lt:='Large';
txt_2_9_mt:='Medium';
txt_2_9_movehere:='Move here';
txt_2_9_nav:='Navigation';
txt_2_9_navbar:='Side bar';
txt_2_9_none:='None';
txt_2_9_organize:='Organize';
txt_2_9_public:='Public';
txt_2_9_rec:='Recursive: search in subdirectories, may take some time';
txt_2_9_selected:='Selected';
txt_2_9_setapps:='Organize Applications';
txt_2_9_showmenu:='Show Menu bar';
txt_2_9_st:='Small';
txt_2_9_test_pw2G:='Test for encryption <2GB archives';
txt_2_9_vst:='Text only';
txt_2_9_toolbar:='Tool bar';
txt_2_9_tree:='Tree';
txt_2_9_views:='Views';
txt_2_8_experimental:='(experimental)';
txt_2_8_zcopy:='(Windows) Copy files in restartable mode, slower copy';
txt_2_8_addvol:='Adding entire volume(s) to archive may take long time, continue anyway?';
txt_2_8_uniterror:='Cannot access the unit';
txt_2_8_cannotconvert:='Cannot convert selected archives';
txt_2_8_convertbegin:='Continue with compression stage to finalize the conversion?';
txt_2_8_convert:='Convert';
txt_2_8_convertexisting:='Convert existing archives';
txt_2_8_convertdelete:='Delete files and folders created temporarily for conversion?';
txt_2_8_details:='Details';
txt_2_8_parallel:='Execute tasks in parallel when possible';
txt_2_8_convertnote:='In any case original archives were not modified, to let the user in control about keeping or removing them';
txt_2_8_custom:='is not directly supported by PeaZip, but in extraction stage you can set PeaZip to handle custom file types in "Advanced" tab. Proceed opening this file?';
txt_2_8_unitrecommend:='It is recommended either to extract (rightclick > extract selected) or to open filesystems from computer''s root (system tools > Open unit as archive)';
txt_2_8_viewasarchive:='Open unit as archive';
txt_2_8_nounit:='No unit selected';
txt_2_8_rowselect:='Row select';
txt_2_8_statusbar:='Status bar';
txt_2_8_typeunit:='Type logical or physical unit name';
txt_2_8_usedefaultoutpath:='Always use default output path';
txt_2_7_experimental:='(experimental, see documentation)';
txt_2_7_optional:='(optional)';
txt_2_7_list_tryflatorpw:=', possible solutions: try flat view (F6), provide password (F9), get a fresh copy of the archive';
txt_2_7_separate:='Add to separate archives';
txt_2_7_pwsupported:='archiving with password';
txt_2_7_cancel:='Cancel';
txt_2_7_encfn:='Encrypt also file names (if supported by the format)';
txt_2_7_setpw:='Set password / keyfile';
txt_2_7_ext:='Extracting:';
txt_2_7_extfrom:='Extracting from archive:';
txt_2_7_es:='Extract supported non-archive file types, i.e. executables, MS Office and OOo files';
txt_2_7_eu:='Extract unsupported file types, specifying custom extraction utility';
txt_2_7_clipboard:='Clipboard';
txt_2_7_goarclayout:='Go to archiving layout';
txt_2_7_goextlayout:='Go to extraction layout';
txt_2_7_ok:='OK';
txt_2_7_drag_archive:='open file as new archive? ("No" to add file to current archiving layout)';
txt_2_7_oop:='Open output path when task completes';
txt_2_7_validatefn:='Operation stopped, invalid file name detected:';
txt_2_7_validatecl:='Operation stopped, potentially dangerous command detected (i.e. command concatenation not allowed within the program):';
txt_2_7_output:='Output';
txt_2_7_pwnotset:='Password is not set ';
txt_2_7_pwarcset:='Password is set';
txt_2_7_pwextset:='Password is set, it is possible to extract/list/test encrypted archives';
txt_2_7_archivehint:='Drag here files and folders to archive, or right-click for more options';
txt_2_7_exthint:='Drag here archives to extract, or right-click for more options';
txt_2_7_setadvf:='Set advanced filters';
txt_2_7_selpath:='Selected item''s path';
txt_2_7_separateerror:='Sorry, cannot import task definition''s command line while using "Add each object to a separate archive" switch, since the task is performed as multiple distinct commands';
txt_2_7_noinput:='The layout is empty: please use Add file(s) or Load Layout to populate the list of archives to be extracted';
txt_2_7_dirsize:='The size of the content of folders is not checked for calculating the total size';
txt_2_7_un7z_browse_flat:='try flat view (F6)';
txt_2_7_updating:='[Updating existing archive]';
txt_2_6_folders:='(folders)';
txt_2_6_advanced:='Advanced';
txt_2_6_plalways:='Always stop to inspect task report';
txt_2_6_plsmart:='Stop to inspect report for error, list, test';
txt_2_5_sessionio:='(this session)';
txt_2_5_advanced:='Advanced edit: place spaces between parameter strings and filename if needed';
txt_2_5_basic:='Basic edit: application and parameters before input name';
txt_2_5_cannotrun:='Cannot run';
txt_2_5_custeditors:='Custom editors, players, antivirus scanners etc... (override system''s file associations)';
txt_2_5_delete:='Delete';
txt_2_5_delete_fromarchive:='Delete from archive';
txt_2_5_langflag:='Display archived object''s name as UTF-8 text; uncheck to replace extended characters with "?"';
txt_2_5_encpj:='Encode task definition as UTF-8 text';
txt_2_5_execommand:='Executable or command';
txt_2_5_help:='Help';
txt_2_5_langhint:='Hint: replacing extended characters with "?" jolly character can improve syntax if archive''s character set cannot be successfully converted on the current machine';
txt_2_5_mini_help:='Localized Tutorial';
txt_2_5_offline_help:='PeaZip help';
txt_2_5_tray:='Reduce to tray';
txt_2_5_remove:='Remove';
txt_2_5_hintpaths:='Rightclick to open system''s and user''s paths';
txt_2_5_selectapp:='Select application';
txt_2_5_strafter:='String after input name';
txt_2_5_strbefore:='String before input name';
txt_2_5_encoding:='Text encoding';
txt_2_5_nopw:='this type of archives does not support encryption';
txt_2_4_draghint:='[drag to Explorer with enabled Address bar]';
txt_2_4_tb:='Adapt toolbar buttons (restarts PeaZip)';
txt_2_4_adding:='Adding';
txt_2_4_advclip:='Clipboard keeps multiple selections';
txt_2_4_yanswers:='Answers';
txt_2_4_itemsheight:='Auto-size items height';
txt_2_4_clearclipboard:='Clear clipboard (Esc)';
txt_2_4_wcommons:='Commons';
txt_2_4_copyfrom:='Copy from';
txt_2_4_deletebookmarks:='Do you want to delete the list of bookmarked files and folders?';
txt_2_4_documents:='Documents';
txt_2_4_wenc:='Encyclopedia';
txt_2_4_extractfrom:='Extract from';
txt_2_4_hexp:='Hex preview';
txt_2_4_operation:='Operation';
txt_2_4_path:='path is not writeable (i.e. full, or read-only). Do you want to select a writeable output path?';
txt_2_4_removefromclipboard:='Remove from clipboard';
txt_2_4_stdclip:='Standard: keep a single selection in clipboard, clear cut operations on paste';
txt_2_4_totalmem:='total memory';
txt_2_4_gvideo:='Video';
txt_2_4_wbook:='Wikibook';
txt_2_4_wnews:='Wikinews';
txt_2_4_wsrc:='Wikisource';
txt_2_4_wdict:='Wiktionary';
txt_2_3_pw_errorchar:='quote character is not recommended to be used in passwords (for PeaZip and scripts). If you need to create or extract an archive with this password you can dismiss the message and you will be asked to enter the password interactively in console.';
txt_2_3_envstr:='Display environment variables';
txt_2_3_never_pw:='Don''t ask for password';
txt_2_3_home:='User''s home';
txt_2_3_on_pw:='On extract/list/test operations from system''s menus:';
txt_2_3_test_pw100:='Test for encryption <100MB archives';
txt_2_3_test_pw:='Test for encryption (may be slow)';
txt_exclude_recourse:='"exclude" recurse subdirs';
txt_action_extopen:='"Extract and open with associated application" action';
txt_error_passwordnotmatch:='"Password" and "Confirm" fields doesn''t match, please correct them';
txt_action_preview:='"Preview with associated application" action';
txt_preview_hint:='"Preview" action perform the same task as "Extract and open" but to a temporary path in output directory, automathically removed when the archive is closed.';
txt_better:='(better)';
txt_default2:='(default)';
txt_faster:='(faster)';
txt_fastermem:='(faster, less memory)';
txt_tempdir:='(PeaZip''s temporary work folder)';
txt_stream:='(set by "Stream control")';
txt_slowermem:='(slower, more memory)';
txt_store:='(store, fastest)';
txt_newfolder:='(in new folder)';
txt_7z_exitcodeunknown:=': Unknown error in task';
txt_list_isfolder:=' [folder]';
txt_none:='<none>';
txt_fd:='1.44 MB Floppy Disk';
txt_7z_exitcode1:='1: Warning: non fatal error(s); i.e. some files missing or locked';
txt_attach10:='10 MB attachment';
txt_7z_exitcode2:='2: Fatal error occurred';
txt_7z_exitcode255:='255: Task halted by the user';
txt_fat32:='4 GB FAT32 file';
txt_dvd:='4.7 GB DVD';
txt_attach5:='5 MB attachment';
txt_cd650:='650 MB CD';
txt_7z_exitcode7:='7: Error: got incorrect command line';
txt_cd700:='700 MB CD';
txt_type_description_7z:='7Z: feature rich archive format with high compression ratio';
txt_dvddl:='8.5 GB DVD DL';
txt_7z_exitcode8:='8: Error: not enough memory for requested operation';
txt_abort:='Abort scheduled file copy/move operations?';
txt_about:='About';
txt_action:='Action';
txt_action_hint:='Action on open or preview with associated application';
txt_add:='Add';
txt_add_existing_archive:='add (if archive exists)';
txt_add_archive:='Add archive';
txt_add_files:='Add files';
txt_add_folder:='Add folder';
txt_add_path:='Add path';
txt_add_tolayout:='Add selected files and folders to archive''s layout';
txt_add_toarchive:='Add to archive';
txt_add_tobookmarks:='Add to Bookmarks';
txt_address_hint:='Filter: accepts * and ? wildcards';
txt_adv_filters:='Advanced filters';
txt_algo:='Algorithm';
txt_all:='all';
txt_all_default:='All (default)';
txt_all_type:='Same type';
txt_all_date:='Date';
txt_all_psize:='Packed file size';
txt_all_attributes:='Same attributes';
txt_all_size:='File size';
txt_error_input_upx:='allows a single executable file as input';
txt_always_pw:='Always ask for password';
txt_ignore_ext:='Always ignore paths for "Extract and..."';
txt_ignore_disp:='Always ignore paths for "Extract displayed..."';
txt_ignore_sel:='Always ignore paths for "Extract selected..."';
txt_key_hint:='Append keyfile''s hash to password; the archive can be decrypted by PeaZip and other applications following the same standard, or entering the hash as part of the password';
txt_timestamp:='Append timestamp to name';
txt_appoptions:='Application options';
txt_type_description_arc:='ARC: experimental archiver, powerful, efficient and feature-rich';
txt_archive:='Archive';
txt_un7z_browse_ok:='archive browsed successfully';
txt_interface:='Archive browser interface';
txt_archivecreation:='Archive creation';
txt_tarbefore_hint:='Archive data in TAR format before than in specified type.';
txt_archive_hint:='Archive, compress, split and keep private files, folders and volumes';
txt_compressionratio_hint:='Archive''s compression ratio';
txt_archiving:='Archiving:';
txt_cl_long:='Arguments seem exceeding the maximum size that can be passed by PeaZip frontend, please select less input files (i.e. select dirs instead of single files)';
txt_overwrite_askbefore:='Ask before overwriting (in console)';
txt_associated:='Associated application';
txt_attributes:='Attributes';
txt_author:='Author';
txt_ren_existing:='Auto rename existing files';
txt_ren_extracted:='Auto rename extracted files';
txt_autofolder:='Automatically create new folder to extract the archive in?';
txt_back:='Back';
txt_backend:='Backend binaries';
txt_backupexe:='Backup executable (recommended)';
txt_bettercompression:='better compression';
txt_blogs:='Blogs';
txt_blowfish:='Blowfish448 (64 bit blocks)';
txt_bookmarks:='Bookmarks';
txt_browse:='Browse';
txt_browser:='Browser';
txt_aborted_error:='Browsing archive stopped, it would take too much time. You can narrow the selection using search (F3) or exiting Flat view mode (F6); extract/list/test operations are not affected by this issue.';
txt_list_browsing:='Browsing';
txt_archive_root:='Browsing: archive''s root';
txt_type_description_bzip2:='BZip2: quite powerful compression, average speed';
txt_pw_empty:='Please provide a password (or a keyfile)';
txt_add_error:='Cannot add/update or delete object(s); probably the archive type has browse/extract only support, or cannot support that particular operation (i.e. it''s multi-volume or solid), or PeaZip cannot fully handle the archive name';
txt_un7z_browse_failure:='cannot browse archive';
txt_list_error:='Cannot list archive''s content, please check if the archive is password protected or corrupted.';
txt_conf_cannotsave:='Cannot save configuration file, check if the path is writeable and with some free space';
txt_check_hint:='Check for casual data corruption; hash algorithms are suitable to detect even malicious data tampering (see the documentation)';
txt_check:='Checksum/hash file(s)';
txt_check_select:='Checksum/hash';
txt_clear:='Clear';
txt_clearlayout:='Clear layout';
txt_pj_hint:='Click to import task, reset changes and load up to date task definition from GUI';
txt_autoclose:='Never stop to inspect task report';
txt_cl:='command line:';
txt_compare:='Compare files';
txt_compress:='Compress';
txt_compress_executable:='Compress executable';
txt_compress_openforwriting:='Compress files open for writing';
txt_compression:='Compression';
txt_compmanagement:='Computer management';
txt_pw_confirm:='Confirm';
txt_console:='Console';
txt_console_interface:='Console';
txt_content:='Content';
txt_controlpanel:='Control panel';
txt_convert:='Convert disk to NTFS';
txt_copy:='Copy';
txt_copyto:='Copy to...';
txt_create:='Create';
txt_create_archive:='Create new archive';
txt_title_create:='Create archive, compress, encrypt, split...';
txt_create_keyfile:='Create keyfile';
txt_create_folder:='Create new folder';
txt_create_theme:='Create Theme from current settings';
txt_rr:='Create recovery records';
txt_create_sfx:='Create self-extracting archive';
txt_cr_current:='Current path or filter compression ratio';
txt_custom:='Custom';
txt_type_description_custom:='Custom (advanced users): enter executable name and parameters';
txt_customapp:='Custom application';
txt_custom_parameters:='Custom parameters';
txt_customsize:='Custom size';
txt_cut:='Cut';
txt_datetime:='Date/time';
txt_default:='Default';
txt_default_compression:='default compression';
txt_default_format:='Default format';
txt_theme_default:='Default theme';
txt_hard_reset_hint:='Delete bookmarks file';
txt_desktop:='Desktop';
txt_dictionary:='Dictionary';
txt_dirs:='dir(s),';
txt_dis:='Disambiguation:';
txt_disk_cleanup:='Disk cleanup';
txt_disk_defrag:='Disk defrag';
txt_disk_management:='Disk management';
txt_dispaly:='Display results as';
txt_displayedmnu_obj:='displayed';
txt_displayedobjects:='Displayed items';
txt_nocompress:='do not compress';
txt_delete:='Do you want to delete selected file(s)? The operation can''t be undone and files will be not recoverable from Trash';
txt_wipe:='Do you want to securely delete selected file(s)? The operation can''t be undone and files will be not recoverable';
txt_done:='Done';
txt_edit:='Edit';
txt_elapsed:='elapsed:';
txt_error_emptycl:='Empty command line!';
txt_encrypt:='Encrypt';
txt_encrypted:='encrypted';
txt_encryption:='Encryption';
txt_note:='Enter note / description';
txt_random_keys:='Enter random keys';
txt_random_keys_hint:='Enter random keys (you not have to remember)';
txt_ent:='Entropy evaluation';
txt_ent_tools:='Move the mouse or use additional entropy sampling tools';
txt_eqorlarger:='Same or larger than selected object';
txt_eqorrecent:='Same or more recent than selected object';
txt_eqorolder:='Same or older than selected object';
txt_eqorsmaller:='Same or smaller than selected object';
txt_equal:='Same of selected object';
txt_erase_hint:='Secure delete: overwrite with random data, mask size, rename, finally delete';
txt_extraction_error:='Error extracting the selected object. If the archive is password protected please provide it';
txt_exclude_hint:='Exclude file(s), one per line; use * and ? wildcards; " and '' delimiters are not needed';
txt_exclusion_recourse:='Exclusion filters recurse subdirs';
txt_exclusion:='Exclude';
txt_exe:='Executable';
txt_overwrite_qry:='exists in destination path; overwrite with file(s) with same name from source path? (Cancel: skip copying this objecy)';
txt_confirm_overwrite:='exists; overwrite it? (no to skip)';
txt_explore_outpath:='Explore output path';
txt_explore_path:='Explore path';
txt_ext:='Ext:';
txt_caption_extract:='Extract';
txt_ext_nopath:='Extract (without path)';
txt_ext_all:='Extract all';
txt_ext_allhere:='Extract all here';
txt_ext_allto:='Extract all to';
txt_extopen_custom:='Extract and open with custom application';
txt_extopen_with:='Extract and open with...';
txt_ext_disp_here:='Extract displayed here';
txt_ext_disp:='Extract displayed object(s)';
txt_ext_disp_to:='Extract displayed object(s) to...';
txt_ext_here:='Extract here';
txt_ext_sel_here:='Extract selected here';
txt_ext_sel:='Extract selected object(s)';
txt_ext_sel_to:='Extract selected object(s) to...';
txt_extobj:='Extract the object';
txt_newfoldermenu:='Extract in new folder';
txt_extto:='Extract to...';
txt_level_fast:='Fast';
txt_fastcompr:='fast compression';
txt_fastopen:='Fast open routine, stop browsing extremely large archives, use filters instead';
txt_level_fastest:='Fastest';
txt_favformats:='Favorite formats';
txt_file:='File';
txt_filebrowser:='File browser';
txt_filetools:='File tools';
txt_files:='file(s),';
txt_nfiles:='Files';
txt_fs:='Filesystem';
txt_filters_recourse:='filter(s) recurse subdirs';
txt_filters:='Filters';
txt_flat:='Flat (show all)';
txt_list_flat:='Flat view';
txt_unit_floppy:='Floppy disk';
txt_foldername:='Folder name';
txt_nfolders:='Folders';
txt_error_input_multi:='format allows a single file as input; you can use "TAR before" switch to save input in a .TAR archive before, otherwise you can chose another format. HINT: chose archive format after had selected input data: "TAR before" switch will be automatically set';
txt_fwd:='Forward';
txt_list_found:='Found';
txt_free:='Free';
txt_free2:='free';
txt_name_full:='Full name';
txt_function:='Function';
txt_general:='General';
txt_multithreading:='Generic multithreading';
txt_go_browser:='Go to file browser';
txt_go_path:='Explore path (PeaZip)';
txt_guicl:='GUI + Console';
txt_guipealauncher:='GUI';
txt_graphic:='Graphic''s folder';
txt_gridaltcolor:='Grids alternate color';
txt_gridrowheight:='Grids row height';
txt_gui:='GUI';
txt_type_description_gzip:='GZip: fast compression';
txt_here:='here';
txt_list_history:='History';
txt_homeroot:='Computer/archive''s root level';
txt_quickbrowse_hint:='If browsing is stopped the user can narrow the selection using search or filter functions; extract/list/test functions are not affected in any way.';
txt_backupexe_hint:='If something goes wrong and lead to a non functional result, you may recover the original executable from the authomatic backup copy';
txt_attach:='If the mail client supports that command, the archive will be attached to a new mail';
txt_images:='Images';
txt_include_hint:='Include file(s), one per line; use * and ? wildcards; " and '' delimiters are not needed';
txt_filters_hint:='Inclusion and exclusion filters for 7z binary, please carefully read 7-Zip documentation to understand how those filters works';
txt_inclusion_recourse:='Inclusion filters recurse subdirs';
txt_inclusion:='Include';
txt_error_function:='Incorrect function requested';
txt_info:='Info';
txt_infoall:='Info on all';
txt_infodisp:='Info on displayed object(s)';
txt_infosel:='Info on selected object(s)';
txt_inputinfo:='Input information';
txt_input_list:='Input list:';
txt_iop:='input, output, parameters';
txt_ipo:='input, parameters, output';
txt_input:='Input';
txt_integrity:='Integrity check';
txt_chunk_size:='Invalid custom size, please correct it in a numerical value';
txt_invertsel:='Invert selection';
txt_type_exe:='is a Windows executable, do you want to run it? ("No" to try open it as archive) HINT: some executables may not properly run unless the whole archive is extracted before';
txt_return_to_archive:='is currently open; do you want to browse it?';
txt_not_accessible:='is no longer accessible';
txt_type_unsupported:='is not a supported archive type';
txt_checkname_failed:='is not a valid name.';
txt_not_accessible_list:='is not accessible, please check if the file list provided is correct and up to date';
txt_theme_create_error:='It was not possible to create the theme, try to use a name valid for a folder as theme name and to chose a writeable path';
txt_theme_exists:='yet exists, please provide a different path';
txt_job_code:='task code:';
txt_job_definition_saved:='Task definition successfully saved in';
txt_job_success:='Task successfully completed!';
txt_join:='Join';
txt_joinfiles:='Join files';
txt_keyfile:='Keyfile';
txt_keyfile_not_found:='Keyfile cannot be found or read. Please chose a different Keyfile.';
txt_keyfile_notcreated:='KeyFile not created';
txt_larger:='Larger than selected object';
txt_lastused:='Last used';
txt_launch:='Launch task';
txt_layout:='Layout';
txt_filelist_savedas:='Layout saved as';
txt_level:='Level';
txt_license:='License';
txt_caption_list:='List';
txt_list_details:='List (with details)';
txt_list_all:='List all';
txt_list_disp:='List displayed object(s)';
txt_list_sel:='List selected object(s)';
txt_toggle_warning:='Listing flat view of path''s content may take long time, continue anyway?';
txt_loadfile:='Load file';
txt_loadlayout:='Load layout';
txt_unit_hd:='Local disk';
txt_localization:='Localization';
txt_lpaqver:='LPAQ version';
txt_type_description_lpaq:='LPAQ: faster version of PAQ, very good compression';
txt_maininterface:='Main interface';
txt_maxcomp:='Max compression mode';
txt_level_maximum:='Maximum';
txt_restartrequired:='May require restarting the application to be applied';
txt_required_memory:='MB of memory required';
txt_method:='Method';
txt_misc:='Misc';
txt_modify:='Modify';
txt_morecontrols:='More controls (history, bookmarks, ...)';
txt_morerecent:='More recent than selected object';
txt_ent_hint:='Move the mouse, enter keys in the edit field, load files to collect entropy from the system...';
txt_moveto:='Move to...';
txt_mypc:='Computer''s root';
txt_list_na:='n/a';
txt_name:='Name';
txt_naming:='Naming';
txt_unit_remote:='Network drive';
txt_newarchive:='new archive';
txt_cnewfolder:='New folder';
txt_news:='News';
txt_no:='No';
txt_noinput:='No accessible input received';
txt_nocompress_hint:='no compression (faster)';
txt_split_noinput:='No input selected; please select a file to split';
txt_open_noinput:='No input selected; please select an archive (first archive''s volume for multi-volume archives)';
txt_list_nomatch:='no match';
txt_singlethread:='No multithreading';
txt_none2:='none';
txt_nonsolid:='Non-solid';
txt_level_normal:='Normal';
txt_copy_error:='not successfully copied or moved, error code:';
txt_description:='Notes';
txt_compare_second:='Now select file to be compared with';
txt_peaobj:='Object control';
txt_displayed_obj:='object(s)';
txt_olderthan:='Older than selected object';
txt_on:='on';
txt_ondblclick:='On doubleclick';
txt_opacity:='Opacity';
txt_open:='Open';
txt_openarchive:='Open archive';
txt_title_open:='Open archive, decrypt, join...';
txt_open_bookmark:='Open bookmark';
txt_cphere:='Open command prompt here';
txt_open_file:='Open file';
txt_open_files:='Open file(s)';
txt_open_path:='Open path';
txt_opensource:='Open source portable archiver';
txt_openwith:='Open with...';
txt_aborted:='Operation aborted';
txt_unit_cd:='Optical drive';
txt_options:='Options';
txt_other:='Other';
txt_otherparams:='Other parameters (free editing)';
txt_oip:='output, input, parameters';
txt_opi:='output, parameters, input';
txt_output:='output:';
txt_overwrite:='Overwrite existing files';
txt_compressed_size:='Packed';
txt_paqver:='PAQ version';
txt_type_description_paq:='PAQ: slow but extremely powerful compressor';
txt_pio:='parameters, input, output';
txt_poi:='parameters, output, input';
txt_parameters:='Parameters:';
txt_error_partial:='Partial extraction not implemented for current archive type';
txt_passes:='Passes';
txt_pw:='Password';
txt_pwlength:='Password length in characters (4..64)';
txt_un7z_browse_pw:='password may be required';
txt_un7z_browse_pw_other:='password may be wrong';
txt_paste:='Paste';
txt_path:='Path';
txt_pea_appcolor:='Application accent color';
txt_pea_textcolor:='Pea text color';
txt_type_description_pea:='PEA: security oriented archive format with fast compression';
txt_peazip_new:='PeaZip (new instance)';
txt_peazip_help:='Online support';
txt_peazip_web:='PeaZip Website';
txt_performall:='Perform all supported algorithms';
txt_name_provide:='\ / : * ? '' " < > | characters are not allowed in file names';
txt_upxorstrip:='Please chose Strip and/or UPX on the binary';
txt_not_removable_file:='Please close file in use, in order to allow PeaZip to remove it:';
txt_not_removable:='Please close files in use, in order to allow PeaZip to remove the folder:';
txt_custom_executable_missing:='Please provide the custom executable''s name';
txt_type_unsupported_select:='Please select a supported archive type:';
txt_no_theme_name:='Please specify a theme name';
txt_please_wait:='Please wait';
txt_copy_wait:='Please wait currently scheduled file copy/move operations to complete before scheduling other operations of the same type';
txt_previewwith:='Preview with...';
txt_projectadmin:='Project administrator:';
txt_type_description_quad:='BALZ/QUAD: high-performance ROLZ-based file compressors';
txt_quickdelete:='Quick delete';
txt_quit:='Quit';
txt_unit_ram:='RAM disk';
txt_read:='Read:';
txt_recentarchives:='Recent archives';
txt_rr_hint:='Recovery records allows to try to correct archives in case of data corruption';
txt_search_refine:='Refine search filter, accepts ? and * wildcards';
txt_fefreshf5:='Refresh';
txt_release:='release:';
txt_unit_removable:='Removable unit';
txt_remove_bookmark:='Remove bookmark';
txt_remove_external_unit:='Remove external device(s)';
txt_removeselected:='Remove selected object(s)';
txt_rename:='Rename';
txt_caption_repair:='Repair';
txt_restartrequired2:='requires restarting the application to apply';
txt_reset:='Reset';
txt_reset_archivename:='Reset archive name';
txt_hardreset:='Reset bookmarks';
txt_reset_theme:='Reset to embedded theme';
txt_restore_att:='restore original attributes';
txt_run_as:='Run as (cannot switch to users with blank password)';
txt_run_as2:='Run as different user';
txt_sample:='Sample: ';
txt_saveas:='Save as';
txt_savehistory:='Save history data';
txt_save_infolder:='Save in folder (auto)';
txt_savejob:='Save task definition as script';
txt_savejobdefinition:='Save task definition as script';
txt_savejobdefinition_hint:='Save task definition as plain text; you can use it from your scripts';
txt_savelayout:='Save layout';
txt_save_winstate:='Save main window state';
txt_search:='Search (recursive, may take some time)';
txt_searchanddrag:='Search and drag here';
txt_searchfor:='Search';
txt_nrsearch:='Search here (non recursive)';
txt_search_hint:='Search in archive''s subdirectories for matches with filter(s)';
txt_search_web:='Web search';
txt_list_searching:='Searching...';
txt_securedelete:='Secure delete';
txt_default_description:='Select a function or drag files here';
txt_selectall:='Select all';
txt_selectdir:='Select directory';
txt_selected_obj:='selected';
txt_selected_objects:='Selected items';
txt_sfx:='Self-extracting';
txt_sendbymail:='Send by mail';
txt_set_defaults:='Set application''s default parameters';
txt_settings:='Settings';
txt_sfx_interface:='sfx interface';
txt_showhints:='Show hints and tooltips';
txt_show_messages:='Show information messages';
txt_showpw:='Show password field content';
txt_singlevol:='Single volume, do not split';
txt_size:='Size';
txt_sizeb:='Size (B)';
txt_skip_existing:='Skip existing files';
txt_slowercomp:='slower compression but equally fast decompression';
txt_smaller:='Smaller than selected object';
txt_solid:='Solid';
txt_solid_block:='Block size';
txt_solid_auto:='Solid, auto-adjust';
txt_solid_extension:='Solid, group by extension';
txt_listtest:='sorry, list/test operation is not yet implemented for this format';
txt_sortbysel:='Sort by selection status';
txt_list_sorting:='Sorting...';
txt_speed:='speed';
txt_split:='Split';
txt_type_description_split:='Split a file with optional integrity check';
txt_split_file:='Split file';
txt_list_nostats:='stats not available';
txt_status:='Status';
txt_level_store:='Store';
txt_stream_control:='Stream control';
txt_strip:='Strip before UPX (recommended)';
txt_keyfile_created:='Successfully created KeyFile as:';
txt_suggestpw:='Create random password';
txt_noupx:='Symbols stripped, UPX compression omitted';
txt_syntax:='Syntax:';
txt_sysbenchmark:='System benchmark';
txt_benchmark:='System benchmark will take some minutes and will use all available CPU and memory resource. The system may not respond during the benchmark; run it anyway?';
txt_systools:='System tools';
txt_tarbefore:='TAR before';
txt_type_description_tar:='TAR: archiving format mainstream on UNIX systems';
txt_taskman:='Task Manager';
txt_caption_test:='Test';
txt_testall:='Test all';
txt_testdisp:='Test displayed object(s)';
txt_testpw:='Test password / keyfile';
txt_testsel:='Test selected object(s)';
txt_col_hint:='The color should be chosen in order to integrate well with icon colors and to other GUI''s elements';
txt_bookmarks_hint:='The complete and editable list of bookmarks is available in the file browser interface, clicking on the "More controls" icon and on "Toggle history/bookmarks"';
txt_archive_noinput_tolist:='The layout is empty: please use Add file(s), Add folder(s) or Load Layout to populate the archive''s layout';
txt_theme:='Theme';
txt_icons_found:='Theme loaded successfully.';
txt_themename:='Theme name';
txt_icons_not_found:='Theme not loaded correctly. Try to switch to the default theme, or to a known working one.';
txt_theme_create_success:='theme successfully created in';
txt_theming:='Theming';
txt_extand_error:='This function can be performed on a single object at time';
txt_threads:='Threads';
txt_titlescolor:='Titles color';
txt_to:='to';
txt_toggle_browseflat:='Toggle browse / flat view (show all)';
txt_toggle_historybookmarks:='Toggle status bar';
txt_toolbarscolor:='Bars color';
txt_tools:='Tools';
txt_best:='try best settings (slow)';
txt_type:='Type';
txt_level_ultra:='Ultra';
txt_error_openfile:='Unable to open the specified file';
txt_cl_hint:='UNACE and UPX always run using console mode; list, test and benchmark tasks always run using GUI mode';
txt_ace_missing:='UNACE plugin is missing; for handling ACE archives you can download the plugin form PeaZip''s website (being UNACE closed source, the plugin is not featured in base package)';
txt_units:='units';
txt_unit_unknown:='Unknown drive type';
txt_un7z_pw_untested:='Untested';
txt_up:='Up';
txt_update:='update (if archive exists)';
txt_type_description_upx:='UPX: compress executable files only';
txt_advfilters:='Use advanced filters';
txt_openfiles_hint:='Use this option to include in the archive files open for writing by other applications (useful in backup tasks)';
txt_usenet:='Usenet';
txt_user_name:='User name; use user@DOMAIN or DOMAIN\user form if needed.';
txt_using:='Using:';
txt_volumepea:='Volume control';
txt_volume_size:='Volume size';
txt_type_ext_uns:='was successfully extracted';
txt_websearch:='Web search';
txt_websites:='Websites';
txt_word:='Word';
txt_write:='Write:';
txt_ramdompw_hint:='You can copy the random generated password from here';
txt_exe_hint:='You can freely enter executable name and parameters for custom compression, and chose syntax''s construction. Please note that you can also manually change command''s syntax in "Console" tab.';
txt_pj_hint2:='You can import the task''s definition from the GUI frontend in the memo field above. Then, you can edit, launch or save it without changing or losing the task defined for the GUI frontend.';
txt_type_description_zip:='ZIP: fast archiving/compression format, mainstream on Windows systems';
txt_zipcrypto_hint:='ZipCrypto (legacy)';
end;

function texts(lang:ansistring):integer;
begin
load_default_texts;
if lang='volatile' then begin assign_guitext; texts:=0; exit; end;
if load_texts(lang)<>0 then //try to load language file sequentially; fallback to a slower recoursive procedure to valorize each known variable from lang file strings if the language file version doesn't match with PeaZip's version
   begin
   load_default_texts;
   assign_guitext;
   texts:=0;
   end
else texts:=0;
end;

procedure changelanguage;
begin
FormPeach.OpenDialogLang.InitialDir:=sharepath+'lang'+directoryseparator;
if FormPeach.OpenDialogLang.execute then
   if FormPeach.OpenDialogLang.FileName<>'' then
      begin
      {$IFDEF MSWINDOWS}
      peaziplanguage(extractfilename(FormPeach.OpenDialogLang.FileName));
      restartclosepeaapp;
      {$ELSE}
      lang_file:=extractfilename(FormPeach.OpenDialogLang.FileName);
      saverestartclosepeaapp;
      {$ENDIF}
      end
   else exit
else exit;
end;

procedure peaziplanguagenc(s: ansistring);
{$IFDEF MSWINDOWS} var exepath,langreg,forcereg:widestring;{$ENDIF}
begin
if s='*nochange' then s:=lang_file;
if s='' then s:='default.txt';
if ExtractFileExt(s)<>'.txt' then s:='default.txt';
lang_file:=s;
{$IFDEF MSWINDOWS}
if (winver='nt6+') and (majmin<>'6.0') then
   if not(FileExists(resource_path+'portable')) then //if Windows instalable version
   begin
   exepath:=utf8decode(sharepath);
   cutextension(s);
   langreg:=utf8decode(s)+'.reg';
   forcereg:='';
   if FileExists(sharepath+'lang-wincontext\'+s+'.reg') then
      begin
      {$IFDEF WIN32} try if IsWindows64=true then forcereg:=' /reg:64'; except end; {$ENDIF}
      ShellExecuteW(FormPeach.Handle, PWideChar ('runas'), PWideChar('reg'), PWideChar ('import "'+exepath+'lang-wincontext\'+langreg+'"'+forcereg), PWideChar (''), SW_SHOWNORMAL);
      end;
   end;
{$ENDIF}
end;

procedure peaziplanguage(s: ansistring);
begin
peaziplanguagenc(s);
FormPeach.Close;
end;

{///////////////////////////////////////////////////////////////////////////////

subsection CONFIGURATION load and save conf and theming

///////////////////////////////////////////////////////////////////////////////}

procedure setbasevars;
begin
{$IFDEF MSWINDOWS}
max_cl:=32768;
{$ELSE}
max_cl:=131072;
{$ENDIF} //customized later in configuration
fthumbs:=false;
gofthumbs:=false;
navbarhidden:=false;
dolistupdate:=true;
piperar:=false;
intdd:=false;
frompc:=false;
prefixd:='1';
prefixf:='2';
prefixdaz:='a ';
prefixfaz:='b ';
prefixdza:='c ';
pdrop:=false;
tmpenumd:=false;
COL1D:=240;
COL2D:=80;
COL3D:=80;
COL4D:=80;
COL5D:=160;
COL6D:=60;
COL7D:=100;
imported_tarbeforejob:=false;
specialmoderar:=0;
bctemp:=0;
specialopen:=false;
singleextract:=true;
updatingarchive_sync:=false;
goarchiving:=false;
disdrag:=false;
threadextracting:=false;
launchwithsemaphore:=false;
keeppreview:=false;
beingpreviewed:='';
setbs:=false;
endflag:=false;
browserbusy:=false;
executable_path:=Programdirectory;//valorize application's paths
if executable_path='' then executable_path:=Application.location;
if executable_path='' then extractfilepath(paramstr(0));
if executable_path<>'' then
   if executable_path[length(executable_path)]<>directoryseparator then executable_path:=executable_path+directoryseparator;
setcurrentdir(executable_path);
{$IFDEF DARWIN}
resource_path:=executable_path+'../Resources/';
binpath:=executable_path+'bin'+directoryseparator;//binaries, architecture dependant
{$ELSE}
resource_path:=executable_path+'res'+directoryseparator;
binpath:=resource_path+'bin'+directoryseparator;//binaries, architecture dependant
{$ENDIF}
sharepath:=resource_path+'share'+directoryseparator;//non binaries resources, non-architecture dependant
confpath:=resource_path+'conf'+directoryseparator;//configuration files, non-architecture dependant
if HBINPATH<>'' then binpath:=HBINPATH;
if HCONFPATH<>'' then confpath:=HCONFPATH;
if HSHAREPATH<>'' then sharepath:=HSHAREPATH;
archiveopened:=false;
browsinghistory:=false;
imgloaded:=false;
openstarted:=false;
done_quickfunctions:=false;
dragcancelled:=true;
popupclosed:=false;
listingdir:=false;
control_listingdir:=false;
done_listingexe:=false;
waitdrawok:=false;
listcol:=1;
prev_type:='';
prev_method:='';
prev_level:='';
archive_type_selected:=-1;
using_tarbefore:=false;
tarbeforenameexception:=false;
seemencrypted:=false;
settingvalues:=false;
subfun:='';
listsortcol1:=9;
listsortcol2:=9;
listsortbook:=0;
setlength(clipcontent,0);
setlength(clipcontent1,0);
filecopying:=false;
destdir:='';
prev_destdir:='';
getdesk_env(desk_env,caption_build,delimiter); //desktop environment: 0 unknown; 1 Gnome-like; 2 KDE-like; 10 Windows; 20; Darwin/OSX
desktop_path:='';
{$IFDEF MSWINDOWS}
wingetdesk;
wingetdocuments;
wingetpictures;
wingetmusic;
wingetvideos;
wingetpublichome;
wingetpublicdocuments;
wingetuserprofile;
wingetsendto;
wingetrecent;
wingetdownloads;
wingetsearches;
wingetlibraries;
sysgetshared;
{$ELSE}
sysgetshared;
get_desktop_path(desktop_path);
get_home_path(home_path);
get_home_subpaths(usr_documents,usr_downloads,usr_music,usr_pictures,usr_videos);
FormPeach.pmqjmore.Visible:=false;
FormPeach.MenuItemArchive_pubdoc.Visible:=false;
FormPeach.MenuItemOpen_pubdoc.Visible:=false;
FormPeach.MenuItemArchive_pubhome.Visible:=false;
FormPeach.MenuItemOpen_pubhome.Visible:=false;
{$ENDIF}
if checkdirexists(home_path) then
else home_path:=executable_path;
if checkdirexists(desktop_path) then
else desktop_path:=home_path;
caption_release:=APPMAIN+' '+PEAZIPVERSION+PEAZIPREVISION;
needwaitupdating:=false;
updatingarchive_inarchive:=false;
pcmenupopulated:=false;
updatinglistview:=false;
updatingsel:=false;
ares:=-1;
dontsavecustom7z:=false;
dontsavecustomzip:=false;
forceopenasarchive:=false;
skipapstatus:=false;
hidepwconf:=0;
prevrun:='';
fromtree:=false;
spinchanged:=false;
smalliconsize:=16;
largeiconsize:=96;
titlestring:='';
sync:=0;
contextconvert_switch:=false;
funflag:=false;
updateid:='';
prevupdateid:='';
prevarchive:='';
issearching:=0;
pmnotdecrypted:=0;
hnum:=0;
lasttoolbar:=1;
prevdrbutton:=-1;
cancellingarchive:=false;
uacneeded:=false;
nffromdrag:=false;
convertverbose:=0;
convertpw:=0;
libre_directive:=0;
privacy_mode:=0;
unrar5shown:=false;
unaceshown:=false;
restartingapp:=false;
needsave:=true;
updatingcontent:=0;
wasselected:=-1;
wasselectedp:=-1;
prevlistfilter:='';
ptabid:=1;
atabid:=1;
setsequenceerror:=false;
forcecanbechanged:=0;
forcetype:=0;
forcelayout:=0;
forcebrowse:=1;
forceconvert:=0;
settmpextnf:=false;
tmpextnf:=false;
psize:=0;
starttaberror:=false;
loadadvdefaults:=true;
end;

procedure getthemepath(var thpath:ansistring);
var
   s:ansistring;
begin
if theme_name='' then
   begin
   s:=extractfilepath(theme_path);
   if s<>'' then setlength(s,length(s)-1);
   theme_name:=extractfilename(s);
   end;
//default and no graphic themes are in application's path, custom themes are in configuration path (application's path for portable versions, user's home/application data for installable versions)
if ((theme_name)<>(DEFAULT_THEME)) then thpath:=confpath
else thpath:=sharepath;
end;

procedure setsyntaxstring7z;
begin
case syntaxlevel7z of
   0: syntaxstring7z:='last';
   1: syntaxstring7z:='23';
   2: syntaxstring7z:='21';
   3: syntaxstring7z:='17';
   4: syntaxstring7z:='16';
end;
end;

procedure default_defaults;
begin
lang_file:='default.txt';//lang file
autoclosegwrap:=2; //close pealauncher when job completes if no error happens
enc7zscc:=0; //0 UTF-8 encoding 1 WIN 2 DOS
browsersd:=0; //0 start browsing from last visited directory (default) 1 computer's root 2 desktop 3 home 4 custom
browsersdir:='';
movetorelativepath:=1;//interactive two steps extraction: extract and then move to relative path after extraction completed
autoopen:=0; //don't open output dir by default when job completes
autotest:=0; //don't test archives after creation
convertverbose:=0; //no verbose confirmation for conversion steps
convertpw:=0; //change password during conversion - asks a new password in re-compression stage
libre_directive:=0; //0 off (default) 1 flexible 2 strict enable only calls to binaries released under OSI licenses
mailkeep:=0; //don't keep archives sent by mail
nameaspartent:=1;//by default name multiple items as selected item's folder
df:=18; //default format: last used
tsstyle:=0;//default timestamp style
pf:=15; //previous format, by default zip
pcompr:=1; //pea default Compression: average
pobj:=11; //pea default object control algorithm CRC32
pvol:=4; //pea default volume control algorithm SHA-3 256
pstream:=0; //pea default stream control algorithm AES+Twofish+Serpent 256 bit in EAX mode
nrkdf:=0;//KDF work load for PEA cascaded encryption
trkdf:=0;//0 scrypt, 1 Hybrid, 2 PBKDF2
salgo:=13; //file split default integrity check algorithm: none
zaout:=2; //Console binaries interface option: GUI, GUI+console, console (except for list/test/benchmark)
zaout1:=zaout;
clipmode:=0; //clipboard mode for cut/copy/paste: 0 standard mode, 1 advanced mode allowing multiple mixed cut and copy selection from various sources
showguihints:=1; //peazip shows hint popups: 1 yes (default) 0 no
showsearchbar:=0; //hide search bar by default
{$IFDEF MSWINDOWS}
wingetdesk;
local_desktop:=desktop_path;
indir:=txt_mypc;//local_desktop;
{$ELSE}
indir:='/';
//showguihints:=0; //show hint popups, now default on Linux as performance of the binary is improved
{$ENDIF} //initial directory (file/archive browser interface) (in case of conf failure at startup txt_my pc is empty, but this condition is checked in check_defaults_failure)
showpwfield:=0; //shows password fields: off (requires pw confirmation)
setencfn:=0; //default don't encrypt filenames (apply only to formats supporting this feature)
intpw:=0; //default don't force typing password interactively in backend console
extpw:=3; //UNUSED ask for password on Extract/list/test functions from system's meus entries
browserstyle:=0; //0:browser 1:f6flat 2*:last used ( *=0 browser, *=1 f6flat);
extopt7z:=0; //overwrite policy for extraction with 7z (skip existing files)
extaction7z:=0; //action for extraction, 7z frontend
extactionarc:=0; //action for extraction, arc frontend
extactionace:=0; //action for extraction, ace frontend
{$IFDEF MSWINDOWS}work_dir:=1;{$ELSE}work_dir:=0;{$ENDIF}
custom_work_path:='';
extoptarc:=2; //overwrite policy for extraction with arc (skip existing files)
closeonsingleextract:=0;//close after extraction if no browsing actions took place
whenspecialopen:=2;//always extract everything for special file types in archives
howspecialopen:=0;//extract entire archive for special file types in archives
seccond:=0;//do not run active content from 0 archives 1 filesystem 2 both 3 disable check
FormPeach.editExtEvForWhat.Caption:=SPECEXTCONST;
FormPeach.editExtEvForSec.Caption:=SECEXTCONST;
FormPeach.Editcommonalgo.Caption:=PREFALGOCONST;
FormPeach.pcustom1.Caption:='';
FormPeach.pcustom2.Caption:='';
FormPeach.pcustom3.Caption:='';
FormPeach.pcustom4.Caption:='';
FormPeach.pcustom5.Caption:='';
FormPeach.pcustom6.Caption:='';
FormPeach.pcustom7.Caption:='';
FormPeach.pcustom8.Caption:='';
FormPeach.EditOPcustom.Caption:='';
FormPeach.EditCustomParamExt.Caption:='';
FormPeach.EditCustomExtension.Caption:='';
FormPeach.LabelForceLayout.Caption:='';
FormPeach.EditCSVsep.Caption:=',';
csvsep:=',';
FormPeach.Editalias.Caption:='7z';
ignorepathextand:=0; //extract and... extracts to current path ignoring internal archive's path: off (all ignore paths directives are ignored if the content is a directory, as it would lose information about content's tree)
ignorepathdisp:=0; //ignore path extracting displayed objects: off
ignorepathsel:=0; //ignore path extracting selected objects: off
enableextand:=0; //do not enable extract and open with menu, only preview
removeintdir:=1;//remove intermediate dir on extract to new folder: on
//Performance parameter for 7z / p7zip -slt listing, stop time consuming operations (dramatically faster on archives containing many files):
prebrowse:=3;
maxargsize:=2;
//listview virtual over number of items items
virtualopt:=0;
taskpriority:=2; //launch tasks with normal priority
dragtargetprotect:=1; //lock drag and drop target window during operation
skipdel:=1;//skip deletion if temp work files are locked
disableintscript:=1;
nonverboselog:=1;//non-verbose output for 7z / p7zip (v15.x onward), faster when many small files are involved
use7zunrar5:=1;//use 7z / p7zip UNRAR5 implementation (v15.06+)
useextrac32:=0;//(Windows) use system's Extrac32 to unpack CAB files
enumd:=1; //enumerate content of directories added for archiving operations
userar:=1;//use winrar's rar.exe for rar compression if installed
userar5:=1;//create rar5 instead of rar4
userardict:=5;//(rar5 only) user dictionary size of 1..1024 MB, not implemented for legacy RAR4 format
userarblake2:=0;//(rar5 only) use BLAKE2 hash instead of CRC
setrarmanual:=0;
restoretabbar:=0;
userarsfx:=0;
userarsolid:=0;
userarrr:=0;
puserarrr:=3;
userarsaveopen:=0;
userarsavesecurity:=0;
userarsavestreams:=1;
userarlastmodtime:=0;
userarlock:=0;
scripttarpipe:=0;
scriptuntarpipe:=0;
addencext:=0; //1 add ".enc" suffix (before extension) when creating encrypted archives
privacy_mode:=0; //ask for password when application starts 1 skippable 2 ask until a non empty password (or keyfile) is provided (so no operation can be done forgetting to provide the password)
addtstext:=0; //add timestamp suffix when creating archives
repcustext:=0; //replace archive extension with custom one
defaulttabsmenu:=2;//address bar menu 1 bookmarks 2 filesystem (default) 3 history 4 functions
multi_option:=1; //generic multithreading
memuse_option:=0;//default, implicit
{$IFDEF MSWINDOWS}
favdelete:=0; //default delete mode for delete option concatenated with archive/extract operations 0 Recycle (Windows) 1 Quick 2 Zero 3 Secure
{$ELSE}
{$IFDEF DARWIN}
favdelete:=0;
{$ELSE}
favdelete:=1;
{$ENDIF}
{$ENDIF}
doptadd:=0;// do not delete originals after archiving by default
doptext:=0;// do not delete originals after extraction by default
prebrowsesize:=192; //max M blocks of memory allowed to list archive content in the browser
savehistory:=1; //save usage history - last archives, last directories, last searches, access data about bookmarks to ease bookmarks management
customsyntax:=1; //syntax type for custom executable, creation
customsyntax1:=1; //syntax type for custom executable, extraction
ws:=1; //save window status: on
ws_status:=0; //ws maximized: off
ws_left:=DLEFT;
ws_top:=DTOP;
ws_width:=DWIDTH;
ws_height:=DHEIGTH;
ws_gw_left:=DGWLEFT;
ws_gw_top:=DGWTOP;
ws_gw_width:=DGWWIDTH;
ws_gw_height:=DGWHEIGTH;
fav7z:=1;//archive types to be added to favourite popup
favARC:=0;
favbz:=1;
favcustom:=0;
favgz:=1;
favpea:=0;
favquad:=0;
favsfx:=1;
favsfxarc:=0;
favsplit:=0;
favtar:=0;
favupx:=0;
favzip:=1;
favzpaq:=0;
favwim:=0;
favxz:=0;
favbrotli:=1;
favzstandard:=1;
maxbrotli:=0;
maxzstd:=0;
level_7z:=2;  //default Compression level for .7z: average
level_xz:=2;
method_7z:='LZMA2'; //default method for .7z: LZMA2
level_arc:=4; //default Compression level for ARC
solid_arc:=1; //default solid mode for ARC 0 non-solid 1 solid, auto-adjust
rr_arc:=1; //default recovery records for ARC: ON
algo_arc:=0; //default encryption algorithm for ARC: 0 AES 1 Serpent 2 Twofish 3 Blowfish (always max keysize)
algo_zipenc:=0; //default encryption algorithm for ZIP: 0 AES 1 ZipCrypto
level_bzip2:=2; //default Compression level for bzip2: average
level_gz:=2; //default Compression level for gzip: average
level_paq:=1; //default Compression level for zpaq: normal
threads_zpaq:=0;//default generic multithreading
paqver:=2;//default ZPAQ
level_quad:=0; //default Compression level for quad: normal (high off)
level_upx:=10; //default Compression level for upx: best
level_zip:=2; //default Compression level for zip: fast
method_zip:='Deflate'; //default method for .zip: deflate
sort7zbytype:=1; //default sort files by type for 7z solid compression: on
openw_all7z:=0; //default archive files open for writing for 7z binary: off
snoi7z:=0;
snon7z:=0;
tartype:=0;//0 gnu (default), 1 pax
tartime:=0;//0 windows 100 ns (default), 1 unix 1 sec, 2 linux 1 ns mapped to 3 due to 7z syntax
sni7z:=0; //manage NT security information default off
sns7z:=1; //manage NTFS alternate streams default on
snh7z:=0; //do not follow hard links
snl7z:=1; //do not follow sym links
snz7z:=1; //propagate zone.identifier default on
zstderr:=0;//by default do not extract zstd files if errors are detected
stl7z:=0;//set 7z / p7zip archive time from most recent file time
ssp7z:=0;
storecreated:=1;//store complete timestamps in archives
algodisp:=0; //default way to display checksum/hash
algoall:=13; //default SAH256; 0 common algorithms (defined below); 1 all algorithms
algoadler:=0;
algocrc16:=0;
algocrc24:=0;
algocrc32:=1;
algocrc64:=1;
algoed2k:=0;
algomd4:=0;
algomd5:=1;
algoripemd160:=1;
algosha1:=1;
algosha3_256:=1;
algosha256:=1;
algosha3_512:=0;
algosha512:=0;
algowhirl:=0;
erasepasses:=0;
filesizebase:=0;
jobdefenc:=0;//legacy, encoding for job definition is now always utf8
archivenameenc:=1; //encoding for filenames in archives 0 replace extended chars with ?; 1 utf8
mcuzip:=1; //encode non ascii chars as utf8 in 7z77zip for ZIP filenames
syntaxlevel7z:=2; //for generic OS use the syntax level 7z 21.07
{$IFDEF MSWINDOWS}syntaxlevel7z:=0;{$ENDIF}
{$IFDEF LINUX}syntaxlevel7z:=0;{$ENDIF}
{$IFDEF DARWIN}syntaxlevel7z:=0;{$ENDIF}
setsyntaxstring7z;
ptsync:=2; //sync archive tree in navigation panel
abt:=1; //auto browse tar up to size
defaultactionst:=0;//by default open input file
mappeddrivesinfo:=0; //(Windows) 0 skip, 1 get volume information for mapped network units
lastoutpath:=''; //last output path, saved only if save history feature is on (default)
splittersize:=220; FormPeach.SplitterBottom.Cursor:=crSizeNS;
splitter2size:=180; FormPeach.SplitterSide.Cursor:=crSizeWE;
splitter3size:=180; FormPeach.SplitterOptions.Cursor:=crSizeWE;
splitsearchsize:=800; FormPeach.splitsearch.Cursor:=crSizeWE;
lastbar:=0;//status bar
esna:=0;
euns:=0;
euns1:=1;
checkver:='unchecked';//it make configuration fall back to defaults if conf is not read correctly, i.e. because of I/O errors or because it is found incompatible version's configuration (different number of lines)
browsertype:=0;
browsersize:=0;
listsortcol:=13;
az:=true;
col1size:=COL1D;
col2size:=COL2D;
col3size:=COL3D;
col4size:=COL4D;
col5size:=COL5D;
col6size:=COL6D;
col7size:=COL7D;
colmethodsize:=COL7D;
colcommentsize:=COL7D;
tonewfolder:=0;
immediate_execution:=0;
parallelarchive:=0;
defaultextractpath:='';
defaultarchivepath:='';
rowselect:=false;
smartsortenabled:=true;
dirbeforefiles:=1;
thighlight:=false;
ccreated:=false;
caccessed:=false;
cmethod:=true;
ccomment:=false;
ctype:=true;
csize:=true;
cpacked:=true;
cdate:=true;
catt:=true;
ccrc:=true;
cfree:=true;
cfs:=true;
toolsize:=0;
lsize:=0;
ptoolsize:=0;
ntoolstyle:=2;
swapbars:=false;
swaptab:=false;
showmenu:=true;
navbar:=0;
addressbar:=1;
ptabbar:=0;
psidebar:=0;
filterbrowser:=0;
showthumbnails:=0;
pimmersive:=0;
simplesearch:=1;
recsearch:=1;
usebreadcrumb:=1;
keeppw:=0;
browserch:=4;
zcopy:=0;
expandfs:=0;
expandroot:=0;
expandbook:=1;
expandhistory:=0;
expandmore:=0;
expandrun:=0;
expandapps:=0;
expandfun:=0;
lastextractionpath:='';
arcabspath:=0;
lasttoolbar:=1;
spchar:=1;
tpreset:=1;
simgfun:=1;
simgw:=1024;
simgh:=768;
simgper:=0;
simgasp:=1;
simgconv:=0;
simgj:=90;
simgt:=10;
simgb:=10;
simgl:=10;
simgr:=10;
simgpercent:=1;
deco_style:=0;
set_archivetree:=false;
showvolatile:=0;
autoopentar:=1;
tar_atomic:=1;
tar_atomic_convert:=0;
qdup:=1;
pshowh:=true;
noconfdel:=0;
swzipx:=0;
convint:=1;
tryopenwerrors:=1;
forcecanbechanged:=0;
forcetype:=0;
excludeef:=0;
tsutc:=0;
forcelayout:=0;
forcebrowse:=1;
forceconvert:=0;
nativedrag:=1;
autosync:=1;
sys7zlin:=0;
ignorepathdd:=0;
level_brotli:=3;
level_rar:=3;
level_zstd:=2;
renselonly:=1;//fixed to 1, 0 would to allow rename all displayed items regardless selection
renfilesonly:=0;
defaultspanning:=0;//single volume, do not split output
spansize:=100;
spanunit:=2;
autoclosepeazip:=0;
skipenctest:=0;
zpaqall:=0;
zpaqfull:=0;
{$IFDEF MSWINDOWS}zpaqabsolute:=0;{$ELSE}zpaqabsolute:=1;{$ENDIF}
zpaqforce:=0;
advopdictionary:=0;
advopword:=4;
advoppasses:=0;
advopblocksize:=0;
FormPeach.EditEncoding.Caption:='1252';
selnode:=0;
end;

procedure check_theme_failure;
begin
if graphicsfolderd<>'' then
   if graphicsfolderd[length(graphicsfolderd)]<>directoryseparator then graphicsfolderd:=graphicsfolderd+directoryseparator;
//if opacityd<0 then opacityd:=0;
if opacityd>100 then opacityd:=100;
if opacityd=0 then opacityd:=100;
if color1d='' then color1d:=ColorToString(PAPPCOL);
if (usealtcolord<0) or (usealtcolord>1) then usealtcolord:=0;
if (highlighttabsd<0) or (highlighttabsd>5) then highlighttabsd:=0;
if (accenttoolbard<0) or (accenttoolbard>8) then accenttoolbard:=0;
if (altaddressstyle<0) or (altaddressstyle>3) then altaddressstyle:=1;
if (decostyle<0) or (decostyle>2) then decostyle:=0;
if (solidaddressstyle<0) or (solidaddressstyle>8) then solidaddressstyle:=0;
if (toolcentered<0) or (toolcentered>1) then toolcentered:=0;
if (alttabstyle<0) or (alttabstyle>5) then alttabstyle:=2;
end;

procedure check_defaults_failure;
begin
//no control on lang_file name
if (autoclosegwrap>4) then autoclosegwrap:=2;
if (enc7zscc>2) then enc7zscc:=0;
if (browsersd>4) then browsersd:=0;
if (movetorelativepath>1) then movetorelativepath:=1;
if (autoopen>1) then autoopen:=0;
if (autotest>1) then autotest:=0;
if (convertpw<0) or (convertpw>1) then convertpw:=0;
if (convertverbose<0) or (convertverbose>1) then convertverbose:=0;
if (libre_directive<0) or (libre_directive>2) then libre_directive:=0;
if (mailkeep>1) then mailkeep:=0;
if (nameaspartent>1) then nameaspartent:=1;
if (df>18) then df:=18;
if (tsstyle<0) or (tsstyle>3) then tsstyle:=0;
if (pf>17) then pf:=15;
if (pcompr>3) then pcompr:=1;
if (pobj>13) then pobj:=11;
if (pvol>13) then pvol:=4;
if (pstream>9) then pstream:=0;
if (nrkdf>7) then nrkdf:=0;
if (trkdf>2) then trkdf:=0;
if (salgo>13) then salgo:=13;
if (zaout>2) then zaout:=2;
zaout1:=zaout;
if (clipmode>1) then clipmode:=0;
case browsersd of
   1: begin
      {$IFDEF MSWINDOWS}
      indir:=txt_mypc;//local_desktop;
      {$ELSE}
      indir:='/';
      {$ENDIF}
      end;
   2: begin
      {$IFDEF MSWINDOWS}
      indir:=local_desktop;
      {$ELSE}
      indir:=local_desktop;
      if indir<>'' then
         if indir[length(indir)]<>directoryseparator then indir:=indir+directoryseparator;
      {$ENDIF}
      end;
   3: begin
      {$IFDEF MSWINDOWS}
      indir:=home_path;
      {$ELSE}
      indir:=home_path;
      if indir<>'' then
         if indir[length(indir)]<>directoryseparator then indir:=indir+directoryseparator;
      {$ENDIF}
      end;
   4: if checkdirexists(browsersdir) then indir:=browsersdir;
   end;
if indir='' then
   begin
   {$IFDEF MSWINDOWS}
   indir:=txt_mypc;//local_desktop;
   {$ELSE}
   indir:='/';
   {$ENDIF}
   end;
if indir<>txt_mypc then
   if not(checkdirexists(indir)) then
      begin
      {$IFDEF MSWINDOWS}
      indir:=txt_mypc;
      {$ELSE}
      indir:='/';
      {$ENDIF}
      end;
if (showguihints>1) then showguihints:=1;
if (showsearchbar>1) then showsearchbar:=0;
if (showpwfield>1) then showpwfield:=0;
if (setencfn>1) then setencfn:=0;
if (intpw>1) then intpw:=0;
if (extpw>4) then extpw:=3;
if (extopt7z>4) then extopt7z:=0;
if (extaction7z>4) then extaction7z:=0;
if (extactionarc>5) then extactionarc:=0;
if (extactionace>3) then extactionace:=0;
if (work_dir<0) or (work_dir>5) then {$IFDEF MSWINDOWS}work_dir:=1;{$ELSE}work_dir:=0;{$ENDIF}
if (extoptarc>2) then extoptarc:=0;
if (closeonsingleextract>1) then closeonsingleextract:=0;
if (whenspecialopen<0) or (whenspecialopen>2) then whenspecialopen:=2;
if (seccond<0) or (seccond>3) then seccond:=0;
if (howspecialopen<0) or (howspecialopen>1) then howspecialopen:=0;
if (length(FormPeach.editExtEvForWhat.Caption)<1) or (length(FormPeach.editExtEvForWhat.Caption)>1000) then FormPeach.editExtEvForWhat.Caption:=SPECEXTCONST;
if (length(FormPeach.editExtEvForSec.Caption)<1) or (length(FormPeach.editExtEvForSec.Caption)>1000) then FormPeach.editExtEvForSec.Caption:=SECEXTCONST;
if (length(FormPeach.Editcommonalgo.Caption)<1) or (length(FormPeach.Editcommonalgo.Caption)>1000) then FormPeach.Editcommonalgo.Caption:=PREFALGOCONST;
if (ignorepathextand>1) then ignorepathextand:=0;
if (ignorepathdisp>1) then ignorepathdisp:=0;
if (ignorepathsel>1) then ignorepathsel:=0;
if (enableextand>1) then enableextand:=0;
if (nativedrag<0) or (nativedrag>1) then nativedrag:=1;
if (autosync<0) or (autosync>1) then autosync:=1;
if nativedrag=1 then ignorepathdd:=0 else ignorepathdd:=1;
if (removeintdir>1) then removeintdir:=1;
if (prebrowse>5) then prebrowse:=3;
if (maxargsize<0) or (maxargsize>7) then maxargsize:=2;
if (virtualopt>5) then virtualopt:=0;
if (taskpriority>3) then taskpriority:=2;
if (dragtargetprotect>3) then dragtargetprotect:=1;
if (skipdel>1) then skipdel:=1;
if (disableintscript>1) then disableintscript:=1;
if (nonverboselog>1) then nonverboselog:=1;
if (use7zunrar5>1) then use7zunrar5:=1;
if (useextrac32>1) then useextrac32:=0;
if (enumd>1) then enumd:=1;
if (userar>1) then userar:=1;
if (userar5>1) then userar5:=1;
if (userardict<0) or (userardict>10) then userardict:=5;
if (userarblake2>1) then userarblake2:=0;
if (setrarmanual>1) then setrarmanual:=0;
if (userarsfx>1) then userarsfx:=0;
if (userarsolid>1) then userarsolid:=0;
if (userarrr>1) then userarrr:=0;
if (puserarrr<1) or (puserarrr>100) then puserarrr:=3;
if (userarsaveopen>1) then userarsaveopen:=0;
if (userarsavesecurity>1) then userarsavesecurity:=0;
if (userarsavestreams>1) then userarsavestreams:=1;
if (userarlastmodtime>2) then userarlastmodtime:=0;
if (userarlock>1) then userarlock:=0;
if (addencext>1) then addencext:=0;
if (privacy_mode<0) or (privacy_mode>2) then privacy_mode:=0;
if (addtstext>1) then addtstext:=0;
if (scripttarpipe>1) then scripttarpipe:=0;
if (scriptuntarpipe>1) then scriptuntarpipe:=0;
if (repcustext>1) then repcustext:=0;
if (length(FormPeach.EditCustomExtension.Caption)>100) then FormPeach.EditCustomExtension.Caption:='';
if (defaulttabsmenu<1) or (defaulttabsmenu>4) then defaulttabsmenu:=2;
if (multi_option>9) then multi_option:=1;
if (memuse_option>9) then memuse_option:=0;
{$IFDEF MSWINDOWS}
if (favdelete<0) or (favdelete>3) then favdelete:=0;
{$ELSE}
{$IFDEF DARWIN}
if (favdelete<0) or (favdelete>3) then favdelete:=0;
{$ELSE}
if (favdelete<1) or (favdelete>3) then favdelete:=1;
{$ENDIF}
{$ENDIF}
if (prebrowsesize<4) or (prebrowsesize>512) then prebrowsesize:=192; //unused
if (savehistory>1) then savehistory:=1;
if (customsyntax>5) then customsyntax:=1;
if (customsyntax1>5) then customsyntax:=1;
if (ws>1) then ws:=1;
if (ws_status>1) then ws_status:=0; //default wsNormal
if (ws_left<0) or (ws_left>Screen.Width) then ws_left:=DLEFT; //don't allow to save the window position more than 1024*768 from lef-top corner of the screen
if (ws_top<0) or (ws_top>Screen.Height) then ws_top:=DTOP; //allow to use any window size, so don't check ws size
if (ws_gw_left<0) or (ws_gw_left>Screen.Width) then ws_gw_left:=DGWLEFT;
if (ws_gw_top<0) or (ws_gw_top>Screen.Height) then ws_gw_top:=DGWTOP;
if (fav7z>1) then fav7z:=1;
if (favARC>1) then favARC:=0;
if (favbz>1) then favbz:=1;
if (favcustom>1) then favcustom:=0;
if (favgz>1) then favgz:=1;
if (favpea>1) then favpea:=0;
if (favquad>1) then favquad:=0;
if (favsplit>1) then favsplit:=0;
if (favtar>1) then favtar:=0;
if (favsfx>1) then favsfx:=1;
if (favsfxarc>1) then favsfxarc:=0;
if (favupx>1) then favupx:=0;
if (favzip>1) then favzip:=1;
if (favwim>1) then favwim:=0;
if (favxz>1) then favxz:=0;
if (favbrotli>1) then favbrotli:=1;
if (favzstandard>1) then favzstandard:=1;
if (favzpaq>1) then favzpaq:=0;
if (level_7z>5) then level_7z:=3;
if (level_xz>4) then level_xz:=2;
if (method_7z<>'LZMA') and (method_7z<>'LZMA2') and (method_7z<>'PPMd') and (method_7z<>'BZip2') and
   (method_7z<>'Brotli') and (method_7z<>'FLZMA2') and (method_7z<>'Lizard_fastLZ4') and (method_7z<>'Lizard_LIZv1') and
   (method_7z<>'Lizard_fastLZ4+Huffman') and (method_7z<>'Lizard_LIZv1+Huffman') and (method_7z<>'LZ4') and (method_7z<>'LZ5') and
   (method_7z<>'Zstd') and (method_7z<>'Deflate') and (method_7z<>'Deflate64') then method_7z:='LZMA2';
if (level_arc>9) then level_arc:=4;
if (solid_arc>2) then solid_arc:=1;
if (rr_arc>1) then rr_arc:=1;
if (algo_arc>3) then algo_arc:=0;
if (algo_zipenc>1) then algo_arc:=1;
if (level_bzip2>4) then level_bzip2:=2;
if (level_gz>4) then level_gz:=2;
if (level_paq>3) then level_paq:=1;
if (threads_zpaq>9) then threads_zpaq:=0;
if (paqver>2) then paqver:=2;
if (level_quad>1) then level_quad:=0;
if (level_upx>10) then level_upx:=10;
if (level_zip>5) then level_zip:=3;
if (method_zip<>'Deflate') and (method_zip<>'Deflate64') and (method_zip<>'BZip2') and (method_zip<>'LZMA') and (method_zip<>'PPMd') and (method_zip<>'XZ')
   {$IFNDEF MSWINDOWS}
   and (method_zip<>'Zstd')
   {$ENDIF}
   then method_zip:='Deflate';
if (openw_all7z>1) then openw_all7z:=0;
if (snoi7z>1) then snoi7z:=0;
if (snon7z>1) then snon7z:=0;
if (tartype>1) then tartype:=0;
if (tartime>2) then tartime:=0;
if (sni7z>1) then sni7z:=0;
if (sns7z>1) then sns7z:=1;
if (snh7z>1) then snh7z:=0;
if (snl7z>1) then snl7z:=1;
if (snz7z>1) then snz7z:=1;
if (zstderr>1) then zstderr:=0;
if (stl7z>1) then stl7z:=0;
if (ssp7z>1) then ssp7z:=0;
if (storecreated>1) then storecreated:=1;
if (maxbrotli>1) then maxbrotli:=0;
if (maxzstd>1) then maxzstd:=0;
if (sort7zbytype>1) then sort7zbytype:=1;
if (algodisp>2) then algodisp:=0;
if (algoall>18) then algoall:=13;
if (algoadler>1) then algoadler:=0;
if (algocrc16>1) then algocrc16:=0;
if (algocrc24>1) then algocrc24:=0;
if (algocrc32>1) then algocrc32:=1;
if (algocrc64>1) then algocrc64:=0;
if (algoed2k>1) then algoed2k:=0;
if (algomd4>1) then algomd4:=0;
if (algomd5>1) then algomd5:=1;
if (algoripemd160>1) then algoripemd160:=1;
if (algosha1>1) then algosha1:=1;
if (algosha3_256>1) then algosha3_256:=1;
if (algosha256>1) then algosha256:=1;
if (algosha3_512>1) then algosha3_512:=0;
if (algosha512>1) then algosha512:=0;
if (algowhirl>1) then algowhirl:=0;
if (erasepasses>4) then erasepasses:=0;
if (filesizebase>2) then filesizebase:=0;
if (jobdefenc>1) then jobdefenc:=0;
if (showvolatile<0) or (showvolatile>1) then showvolatile:=0;
if (archivenameenc>1) then archivenameenc:=1;
if (mcuzip>3) then mcuzip:=1;
if (syntaxlevel7z>4) then
   begin
   syntaxlevel7z:=2;
   {$IFDEF MSWINDOWS}syntaxlevel7z:=0;{$ENDIF}
   {$IFDEF LINUX}syntaxlevel7z:=0;{$ENDIF}
   {$IFDEF DARWIN}syntaxlevel7z:=0;{$ENDIF}
   end;
setsyntaxstring7z;
if (ptsync>2) then ptsync:=2;
if abt>3 then abt:=1;
if (defaultactionst>5) then defaultactionst:=0;
if (mappeddrivesinfo<0) or (mappeddrivesinfo>1) then mappeddrivesinfo:=0;
if (local_desktop='') or (not(checkdirexists(local_desktop))) then local_desktop:=desktop_path;
if local_desktop<>'' then
   if local_desktop[length(local_desktop)]<>directoryseparator then local_desktop:=local_desktop+directoryseparator;
if (splittersize<0) then splittersize:=220;
if (splitter2size<0) then splitter2size:=180;
if (splitter3size<1) then splitter3size:=180;
if (splitsearchsize<0) then splitsearchsize:=800;
if (lastbar<0) or (lastbar>5) then lastbar:=0;
if (esna<0) or (esna>1) then esna:=0;
if (euns<0) or (euns>1) then euns:=0;
if (euns1<0) or (euns1>1) then euns1:=1;
if (browsertype<0) or (browsertype>2) then browsertype:=0;
if (browsersize<0) or (browsersize>6) then browsersize:=0;
if (listsortcol<1) or (listsortcol>17) then listsortcol:=13;
if (col1size<26) or (col1size>1024) then col1size:=COL1D; //on Windows listview column size is currently fixed to 25 in Lazarus 0.9.26.2
if (col2size<26) or (col2size>1024) then col2size:=COL2D;
if (col3size<26) or (col3size>1024) then col3size:=COL3D;
if (col4size<26) or (col4size>1024) then col4size:=COL4D;
if (col5size<26) or (col5size>1024) then col5size:=COL5D;
if (col6size<26) or (col6size>1024) then col6size:=COL6D;
if (col7size<26) or (col7size>1024) then col7size:=COL7D;
if (colmethodsize<26) or (colmethodsize>1024) then colmethodsize:=COL7D;
if (colcommentsize<26) or (colcommentsize>1024) then colcommentsize:=COL7D;
if (tonewfolder>1) then tonewfolder:=0;
if (immediate_execution>1) then immediate_execution:=0;
if (parallelarchive>1) then parallelarchive:=1;
if not(checkdirexists(defaultextractpath)) then defaultextractpath:='';
if not(checkdirexists(defaultarchivepath)) then defaultarchivepath:='';
if (zcopy>1) then zcopy:=0;
if (expandfs<0) or (expandfs>1) then expandfs:=0;
if (expandroot<0) or (expandroot>1) then expandroot:=0;
if (expandbook<0) or (expandbook>1) then expandbook:=1;
if (expandhistory<0) or (expandhistory>1) then expandhistory:=0;
if (expandmore<0) or (expandmore>1) then expandmore:=0;
if (expandrun<0) or (expandrun>1) then expandrun:=1;
if (expandapps<0) or (expandapps>1) then expandapps:=0;
if (expandfun<0) or (expandfun>1) then expandfun:=0;
if (toolsize<0) or (toolsize>7) then toolsize:=0; ptoolsize:=toolsize;
if (ntoolstyle<1) or (ntoolstyle>5) then ntoolstyle:=2;
if (lsize<0) or (lsize>1) then lsize:=0;
if (navbar<0) or (navbar>3) then navbar:=0;
if (addressbar<0) or (addressbar>1) then addressbar:=1;
if (ptabbar<0) or (ptabbar>1) then ptabbar:=0;
if (psidebar<0) or (psidebar>1) then psidebar:=0;
if (filterbrowser>1) then filterbrowser:=0;
if (showthumbnails<0) or (showthumbnails>1) then showthumbnails:=0;
if (pimmersive<0) or (pimmersive>1) then pimmersive:=0;
if (simplesearch<0) or (simplesearch>1) then simplesearch:=1;
if (recsearch<0) or (recsearch>1) then recsearch:=1;
if (renfilesonly<0) or (renfilesonly>1) then renfilesonly:=0;
if (browserch<1) or (browserch>17) then browserch:=4;
if (arcabspath<0) or (arcabspath>1) then arcabspath:=0;
if (keeppw<0) or (keeppw>1) then keeppw:=0;
if (usebreadcrumb<0) or (usebreadcrumb>4) then usebreadcrumb:=1;
if (lasttoolbar<1) or (lasttoolbar>3) then lasttoolbar:=1;
if (spchar>1) then spchar:=1;
if (tpreset<1) or (tpreset>3) then tpreset:=1;
if (simgfun<0) or (simgfun>3) then simgfun:=1;
if (simgw<1) or (simgw>40000) then simgw:=1024;
if (simgh<1) or (simgh>30000) then simgh:=768;
if (simgper<0) or (simgper>1) then simgper:=0;
if (simgasp<0) or (simgasp>1) then simgasp:=1;
if (simgconv<0) or (simgconv>7) then simgconv:=0;
if (simgj<0) or (simgj>100) then simgj:=90;
if (simgt<0) or (simgt>40000) then simgt:=10;
if (simgb<0) or (simgb>40000) then simgb:=10;
if (simgl<0) or (simgl>40000) then simgl:=10;
if (simgr<0) or (simgr>40000) then simgr:=10;
if (simgpercent<0) or (simgpercent>1) then simgpercent:=1;
if (deco_style<0) or (deco_style>2) then deco_style:=0;
if (doptadd<0) or (doptadd>1) then doptadd:=0;
if (doptext<0) or (doptext>1) then doptext:=0;
if (autoopentar<0) or (autoopentar>1) then autoopentar:=1;
if (tar_atomic<0) or (tar_atomic>1) then tar_atomic:=1;
if (tar_atomic_convert<0) or (tar_atomic_convert>1) then tar_atomic_convert:=0;
if (qdup<0) or (qdup>1) then qdup:=1;
if (noconfdel<0) or (noconfdel>1) then noconfdel:=0;
if swzipx>1 then swzipx:=0;
if convint>1 then convint:=1;
if (tryopenwerrors<0) or (tryopenwerrors>1) then tryopenwerrors:=1;
if (forcecanbechanged<0) or (forcecanbechanged>1) then forcecanbechanged:=0;
if (forcetype<0) or (forcetype>3) then forcetype:=0;
if (excludeef<0) or (excludeef>1) then excludeef:=0;
if (tsutc<0) or (tsutc>1) then tsutc:=0;
if (forcelayout<0) or (forcelayout>1) then forcelayout:=0;
if (forcebrowse<0) or (forcebrowse>1) then forcebrowse:=1;
if (forceconvert<0) or (forceconvert>1) then forceconvert:=0;
if (level_brotli>=7) then level_brotli:=3;
if (level_rar>5) then level_rar:=3;
if (level_zstd>=9) then level_zstd:=2;
if (defaultspanning<0) or (defaultspanning>10) then defaultspanning:=0;
if (spansize<1) or (spansize>1000000000) then spansize:=100;
if (spanunit<0) or (spanunit>10) then spanunit:=2;
if (autoclosepeazip>1) then autoclosepeazip:=0;
if (skipenctest>1) then skipenctest:=0;
if (zpaqall>1) then zpaqall:=0;
if (zpaqfull>1) then zpaqfull:=0;
if (zpaqabsolute>1) then zpaqabsolute:=1;
if (zpaqforce>1) then zpaqforce:=0;
if (sys7zlin<0) or (sys7zlin>2) then sys7zlin:=0;
end;

procedure settabsstyled;
begin
FormPeach.ShapeTitleAddb1.Height:=tablabelheight;
FormPeach.ShapeTitleAddb2.Height:=tablabelheight;
FormPeach.ShapeTitleAddb3.Height:=tablabelheight;
FormPeach.ShapeTitleAddb4.Height:=tablabelheight;
FormPeach.ShapeTitleExtractb1.Height:=tablabelheight;
FormPeach.ShapeTitleExtractb2.Height:=tablabelheight;
FormPeach.ShapeTitleExtractb3.Height:=tablabelheight;
FormPeach.ShapeTitleExtractb4.Height:=tablabelheight;
FormPeach.ShapeTitleAppsb1.Height:=tablabelheight;
FormPeach.ShapeTitleAppsb2.Height:=tablabelheight;
FormPM.ShapeTitlePMb1.Height:=tablabelheight;
FormPM.ShapeTitlePMb2.Height:=tablabelheight;
FormGwrap.ShapeTitleb1.Height:=tablabelheight;
FormGwrap.ShapeTitleb2.Height:=tablabelheight;
FormGwrap.ShapeTitleb3.Height:=tablabelheight;
FormGwrap.ShapeTitleb4.Height:=tablabelheight;
if (alttabstyle=1) or (alttabstyle=4) then
begin
FormPeach.Shapelinkextract1.visible:=true;
FormPeach.Shapelinkextract2.visible:=true;
FormPeach.Shapelinkextract3.visible:=true;
FormPeach.Shapelinkextract4.visible:=true;
FormPeach.Shapelinkadd1.visible:=true;
FormPeach.Shapelinkadd2.visible:=true;
FormPeach.Shapelinkadd3.visible:=true;
FormPeach.Shapelinkadd4.visible:=true;
FormPeach.Shapelinkapps1.visible:=true;
FormPeach.Shapelinkapps2.visible:=true;
FormPeach.LabelTitleExtract1.AnchorSideTop.Control:=FormPeach.PanelTitleExtract;
FormPeach.LabelTitleExtract2.AnchorSideTop.Control:=FormPeach.PanelTitleExtract;
FormPeach.LabelTitleExtract3.AnchorSideTop.Control:=FormPeach.PanelTitleExtract;
FormPeach.LabelTitleExtract4.AnchorSideTop.Control:=FormPeach.PanelTitleExtract;
FormPeach.ShapeTitleExtractb1.visible:=false;
FormPeach.ShapeTitleExtractb2.visible:=false;
FormPeach.ShapeTitleExtractb3.visible:=false;
FormPeach.ShapeTitleExtractb4.visible:=false;
FormPeach.LabelTitleAdd1.AnchorSideTop.Control:=FormPeach.PanelTitleAdd;
FormPeach.LabelTitleAdd2.AnchorSideTop.Control:=FormPeach.PanelTitleAdd;
FormPeach.LabelTitleAdd3.AnchorSideTop.Control:=FormPeach.PanelTitleAdd;
FormPeach.LabelTitleAdd4.AnchorSideTop.Control:=FormPeach.PanelTitleAdd;
FormPeach.ShapeTitleAddb1.visible:=false;
FormPeach.ShapeTitleAddb2.visible:=false;
FormPeach.ShapeTitleAddb3.visible:=false;
FormPeach.ShapeTitleAddb4.visible:=false;
FormPeach.LabelTitleApps1.AnchorSideTop.Control:=FormPeach.PanelTitleApps;
FormPeach.LabelTitleApps2.AnchorSideTop.Control:=FormPeach.PanelTitleApps;
FormPeach.ShapeTitleAppsb1.visible:=false;
FormPeach.ShapeTitleAppsb2.visible:=false;
FormPM.LabelTitlepm1.AnchorSideTop.Control:=FormPM.PanelTitlePM;
FormPM.LabelTitlepm2.AnchorSideTop.Control:=FormPM.PanelTitlePM;
FormPM.ShapeTitlePMb1.visible:=false;
FormPM.ShapeTitlePMb2.visible:=false;
FormPM.ShapelinkPM1.visible:=true;
FormPM.ShapelinkPM2.visible:=true;
FormGwrap.Shapelink1.visible:=true;
FormGwrap.Shapelink2.visible:=true;
FormGwrap.Shapelink3.visible:=true;
FormGwrap.Shapelink4.visible:=true;
FormGwrap.LabelTitle1.AnchorSideTop.Control:=FormGwrap.PanelTitle;
FormGwrap.LabelTitle2.AnchorSideTop.Control:=FormGwrap.PanelTitle;
FormGwrap.LabelTitle3.AnchorSideTop.Control:=FormGwrap.PanelTitle;
FormGwrap.LabelTitle4.AnchorSideTop.Control:=FormGwrap.PanelTitle;
FormGwrap.ShapeTitleb1.visible:=false;
FormGwrap.ShapeTitleb2.visible:=false;
FormGwrap.ShapeTitleb3.visible:=false;
FormGwrap.ShapeTitleb4.visible:=false;
end
else
begin
FormPeach.Shapelinkextract1.visible:=false;
FormPeach.Shapelinkextract2.visible:=false;
FormPeach.Shapelinkextract3.visible:=false;
FormPeach.Shapelinkextract4.visible:=false;
FormPeach.Shapelinkadd1.visible:=false;
FormPeach.Shapelinkadd2.visible:=false;
FormPeach.Shapelinkadd3.visible:=false;
FormPeach.Shapelinkadd4.visible:=false;
FormPeach.Shapelinkapps1.visible:=false;
FormPeach.Shapelinkapps2.visible:=false;
FormPeach.LabelTitleExtract1.AnchorSideTop.Control:=FormPeach.ShapeTitleExtractb1;
FormPeach.LabelTitleExtract2.AnchorSideTop.Control:=FormPeach.ShapeTitleExtractb1;
FormPeach.LabelTitleExtract3.AnchorSideTop.Control:=FormPeach.ShapeTitleExtractb1;
FormPeach.LabelTitleExtract4.AnchorSideTop.Control:=FormPeach.ShapeTitleExtractb1;
FormPeach.ShapeTitleExtractb1.visible:=true;
FormPeach.ShapeTitleExtractb2.visible:=true;
FormPeach.ShapeTitleExtractb3.visible:=true;
FormPeach.ShapeTitleExtractb4.visible:=true;
FormPeach.LabelTitleAdd1.AnchorSideTop.Control:=FormPeach.ShapeTitleAddb1;
FormPeach.LabelTitleAdd2.AnchorSideTop.Control:=FormPeach.ShapeTitleAddb1;
FormPeach.LabelTitleAdd3.AnchorSideTop.Control:=FormPeach.ShapeTitleAddb1;
FormPeach.LabelTitleAdd4.AnchorSideTop.Control:=FormPeach.ShapeTitleAddb1;
FormPeach.ShapeTitleAddb1.visible:=true;
FormPeach.ShapeTitleAddb2.visible:=true;
FormPeach.ShapeTitleAddb3.visible:=true;
FormPeach.ShapeTitleAddb4.visible:=true;
FormPeach.LabelTitleApps1.AnchorSideTop.Control:=FormPeach.ShapeTitleAppsb1;
FormPeach.LabelTitleApps2.AnchorSideTop.Control:=FormPeach.ShapeTitleAppsb1;
FormPeach.ShapeTitleAppsb1.visible:=true;
FormPeach.ShapeTitleAppsb2.visible:=true;
FormPM.LabelTitlepm1.AnchorSideTop.Control:=FormPM.ShapeTitlePMb1;
FormPM.LabelTitlepm2.AnchorSideTop.Control:=FormPM.ShapeTitlePMb1;
FormPM.ShapeTitlePMb1.visible:=true;
FormPM.ShapeTitlePMb2.visible:=true;
FormPM.ShapelinkPM1.visible:=false;
FormPM.ShapelinkPM2.visible:=false;
FormGwrap.Shapelink1.visible:=false;
FormGwrap.Shapelink2.visible:=false;
FormGwrap.Shapelink3.visible:=false;
FormGwrap.Shapelink4.visible:=false;
FormGwrap.LabelTitle1.AnchorSideTop.Control:=FormGwrap.ShapeTitleb1;
FormGwrap.LabelTitle2.AnchorSideTop.Control:=FormGwrap.ShapeTitleb1;
FormGwrap.LabelTitle3.AnchorSideTop.Control:=FormGwrap.ShapeTitleb1;
FormGwrap.LabelTitle4.AnchorSideTop.Control:=FormGwrap.ShapeTitleb1;
FormGwrap.ShapeTitleb1.visible:=true;
FormGwrap.ShapeTitleb2.visible:=true;
FormGwrap.ShapeTitleb3.visible:=true;
FormGwrap.ShapeTitleb4.visible:=true;
end;
UnitPM.alttabstyle:=alttabstyle;
UnitGwrap.alttabstyle:=alttabstyle;
UnitPM.highlighttabs:=highlighttabs;
UnitGwrap.highlighttabs:=highlighttabs;
end;

procedure set_items_height;
var
   refsize,addressbuttonsize,laddressbuttonsize,saddressbuttonsize:integer;
begin
with FormPeach do
begin
//get ratio between autosized button height at runtime and design time, to resize graphics and items with custom heights set at runtime
refsize:=ButtonRefSize.Height;
get_pformscaling(refsize,qscale,qscaleimages);
//qscale:=(qscale*pzoom) div 100;
qscaleimages:=(qscaleimages*pzoom) div 100;
//colums sizes (width)
COL1D:=(240*qscale) div 100;
COL2D:=(72*qscale) div 100;
COL3D:=(72*qscale) div 100;
COL4D:=(72*qscale) div 100;
COL5D:=(144*qscale) div 100;
COL6D:=(48*qscale) div 100;
COL7D:=(100*qscale) div 100;
//bars
pbarh:=(8*qscale) div 100;
pbarhsmall:=(4*qscale) div 100;
PanelProgress.Height:=pbarh;
barheight:=(40*qscale) div 100;
mbarheight:=(48*qscale) div 100;
mmbarheight:=(44*qscale) div 100;
PanelListBar.Height:=barheight;
ShapeListBar.Height:=((32+ensmall)*qscale) div 100;
BevelTitleOptions1.Height:=barheight;
BevelTitleOptions2.Height:=barheight;
BevelTitleOptions3.Height:=barheight;
BevelTitleOptions4.Height:=barheight;
BevelTitleOptions5.Height:=barheight;
BevelTitleOptions6.Height:=barheight;
BevelTitleOptions7.Height:=barheight;
BevelTitleOptions8.Height:=barheight;
PanelInfoGeneral.Height:=barheight;
Shapelinkextract1.Height:=pbarhsmall+2;
Shapelinkextract2.Height:=pbarhsmall+2;
Shapelinkextract3.Height:=pbarhsmall+2;
Shapelinkextract4.Height:=pbarhsmall+2;
Shapelinkadd1.Height:=pbarhsmall+2;
Shapelinkadd2.Height:=pbarhsmall+2;
Shapelinkadd3.Height:=pbarhsmall+2;
Shapelinkadd4.Height:=pbarhsmall+2;
Shapelinkapps1.Height:=pbarhsmall+2;
Shapelinkapps2.Height:=pbarhsmall+2;
FormPM.ShapelinkPM1.Height:=pbarhsmall+2;
FormPM.ShapelinkPM2.Height:=pbarhsmall+2;
FormGwrap.Shapelink1.Height:=pbarhsmall+2;
FormGwrap.Shapelink2.Height:=pbarhsmall+2;
FormGwrap.Shapelink3.Height:=pbarhsmall+2;
FormGwrap.Shapelink4.Height:=pbarhsmall+2;
//file manager bars items (width)
saddressbuttonsize:=((16+ensmall)*qscale) div 100;
addressbuttonsize:=((32+ensmall)*qscale) div 100;
laddressbuttonsize:=((48+ensmall)*qscale) div 100;
ctrlback.Width:=addressbuttonsize;
ctrlfwd.Width:=addressbuttonsize;
ctrlup.Width:=addressbuttonsize;
ctrlwarning.Width:=addressbuttonsize;
PanelListRoot.Width:=addressbuttonsize-2;
PanelAddress0.Width:=addressbuttonsize-2;
PanelAddress1.Width:=addressbuttonsize-2;
PanelAddress2.Width:=addressbuttonsize-2;
PanelAddress3.Width:=addressbuttonsize-2;
PanelAddress4.Width:=addressbuttonsize-2;
PanelAddress5.Width:=addressbuttonsize-2;
PanelAddress6.Width:=addressbuttonsize-2;
PanelAddress7.Width:=addressbuttonsize-2;
PanelAdArchive0.Width:=addressbuttonsize-2;
PanelAdArchive1.Width:=addressbuttonsize-2;
PanelAdArchive2.Width:=addressbuttonsize-2;
PanelAdArchive3.Width:=addressbuttonsize-2;
PanelAdArchive4.Width:=PanelListRoot.Width;
PanelListResetSearch.Width:=addressbuttonsize-2;
PanelListSearch.Width:=addressbuttonsize-2;
ImageFlat.Width:=addressbuttonsize;
ImageFlatadd.Width:=addressbuttonsize;
ImageFlatconvert.Width:=addressbuttonsize;
ImageFlatext.Width:=addressbuttonsize;
ImageFlatdup.Width:=addressbuttonsize;
ImageFlatfolder.Width:=addressbuttonsize;
ImageFlatren.Width:=addressbuttonsize;
ImageFlattransform.Width:=addressbuttonsize;
ImageFlatcrop.Width:=addressbuttonsize;
ImageFlattestmore.Width:=addressbuttonsize;
BtnPassword.Width:=laddressbuttonsize;
csbroot.Height:=addressbuttonsize;
csbhome.Height:=addressbuttonsize;
csbdesk.Height:=addressbuttonsize;
csbdownloads.Height:=addressbuttonsize;
csbdoc.Height:=addressbuttonsize;
csbmusic.Height:=addressbuttonsize;
csbpic.Height:=addressbuttonsize;
csbvid.Height:=addressbuttonsize;
//tabs
tabheight:=(36*qscale) div 100;
if (alttabstyle=2) or (alttabstyle=5) then tablabelheight:=30
else tablabelheight:=24;
tablabelheight:=(tablabelheight*qscale) div 100;
tabheightl:=(48*qscale) div 100;
PanelBottom.Height:=tabheight;
PanelTitleAdd.Height:=tabheight;
PanelTitleExtract.Height:=tabheight;
PanelTitleApps.Height:=tabheight;
PanelActAdd.Height:=tabheightl;
PanelActExt.Height:=tabheightl;
PanelActOptions.Height:=tabheightl;
FormPM.PanelTitlePM.Height:=tabheight;
settabsstyled;
//grid
case ensmall of
   0: rowsize:=((16+2+pspacing) * qscale) div 100;
   1: rowsize:=((18+2+pspacing) * qscale) div 100;
   2: rowsize:=((20+2+pspacing) * qscale) div 100;
   3: rowsize:=((24+2+pspacing) * qscale) div 100;
   4: rowsize:=((28+2+pspacing) * qscale) div 100;
   5: rowsize:=((32+2+pspacing) * qscale) div 100;
   end;
intcellhw:=((1+(pspacing div 2)) * qscale) div 100;
StringGridAdd.DefaultRowHeight:=rowsize;
StringGridExtract.DefaultRowHeight:=rowsize;
StringGridSessionHistory.DefaultRowHeight:=rowsize;
StringGridBookmarks.DefaultRowHeight:=rowsize;
StringGridClipboard.DefaultRowHeight:=rowsize;
StringGridCustEdit.DefaultRowHeight:=rowsize;
StringGridCustEditAdv.DefaultRowHeight:=rowsize;
StringGridRecent.DefaultRowHeight:=rowsize;
FormPM.StringGridPM.DefaultRowHeight:=rowsize;
FormPM.StringGridPM1.DefaultRowHeight:=rowsize;
//panels
BtnStyle.Width:=(48*qscale) div 100;//48
//graphics
case ensmall of
   0: icon_sizeplus:=((16+pspacing) * qscaleimages) div 100;
   1: icon_sizeplus:=((18+pspacing) * qscaleimages) div 100;
   2: icon_sizeplus:=((20+pspacing) * qscaleimages) div 100;
   3: icon_sizeplus:=((24+pspacing) * qscaleimages) div 100;
   4: icon_sizeplus:=((28+pspacing) * qscaleimages) div 100;
   5: icon_sizeplus:=((32+pspacing) * qscaleimages) div 100;
   end;
il16 := TimageList.Create(owner);
il16.Height:=icon_sizeplus;
il16.Width:=icon_sizeplus;
ListViewBrowser.SmallImages:=il16;
ilsmall := TimageList.Create(owner);
ilsmall.Height:=icon_sizeplus;
ilsmall.Width:=icon_sizeplus;
ShellTreeViewTmp.Images:=ilsmall;
ShellTreeViewNav.Images:=ilsmall;
TreeViewNav.Images:=ilsmall;
TabBar.Images:=ilsmall;
il96 := TimageList.Create(owner);
il96.Height:=((96+pspacing*2)*qscaleimages) div 100;
il96.Width:=((96+pspacing*2)*qscaleimages) div 100;
end;
end;

procedure setgridaltcolor;
begin
if usealtcolor=1 then
   begin
   FormPeach.StringGridAdd.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridExtract.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridCustEdit.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridCustEditAdv.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridRecent.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridSessionHistory.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridBookmarks.AlternateColor:=StringToColor(collow);
   FormPeach.StringGridClipboard.AlternateColor:=StringToColor(collow);
   end
else
   begin
   FormPeach.StringGridAdd.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridExtract.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridCustEdit.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridCustEditAdv.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridRecent.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridSessionHistory.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridBookmarks.AlternateColor:=StringToColor(color2);
   FormPeach.StringGridClipboard.AlternateColor:=StringToColor(color2);
   end;
end;

procedure settabaltcolor;
var tabcol,tabcol2:tcolor;
begin
case highlighttabs of
   0: begin
      tabcol:=StringToColor(color2);
      tabcol2:=StringToColor(color2);
      tabpencol:=StringToColor(color2);
      tabbrushcol:=StringToColor(colmid);
      tablowcol:=psilver;
      tabbrushhighcol:=StringToColor(colvlow);
      end;
   1: begin
      tabcol:=StringToColor(color2);
      tabcol2:=StringToColor(color2);
      tabpencol:=StringToColor(color2);
      tabbrushcol:=pvvlblue;
      tablowcol:=plblue;
      tabbrushhighcol:=pvvvlblue;
      end;
   2: begin
      tabcol:=StringToColor(collow);
      tabcol2:=StringToColor(colvlow);
      tabpencol:=StringToColor(collow);
      tabbrushcol:=StringToColor(colmid);
      tablowcol:=psilver;
      tabbrushhighcol:=StringToColor(colvlow);
      end;
   3: begin
      tabcol:=StringToColor(colmid);
      tabcol2:=StringToColor(collow);
      tabpencol:=StringToColor(colmid);
      tabbrushcol:=StringToColor(colhigh);
      tablowcol:=psilver;
      tabbrushhighcol:=StringToColor(collow);
      end;
   4: begin
      tabcol:=pvvvlblue;
      tabcol2:=pvvvvlblue;
      tabpencol:=pvvvlblue;
      tabbrushcol:=pvvlblue;
      tablowcol:=plblue;
      tabbrushhighcol:=pvvvvlblue;
      end;
   5: begin
      tabcol:=pvvlblue;
      tabcol2:=pvvvlblue;
      tabpencol:=pvvlblue;
      tabbrushcol:=pvlblue;
      tablowcol:=plblue;
      tabbrushhighcol:=pvvvlblue;
      end;
   end;
FormPeach.PanelTitleOptions.Color:=tabcol;
FormPeach.PanelTitleAdd.Color:=tabcol;
FormPeach.PanelTitleExtract.Color:=tabcol;
FormPeach.PanelTitleApps.Color:=tabcol;
FormGwrap.PanelTitle.Color:=tabcol;
UnitGwrap.tabpencol:=tabpencol;
UnitGwrap.tablowcol:=tablowcol;
UnitGwrap.tabbrushcol:=tabbrushcol;
UnitGwrap.tabbrushhighcol:=tabbrushhighcol;
FormPM.PanelTitlePM.Color:=tabcol;
UnitPM.tabpencol:=tabpencol;
UnitPM.tablowcol:=tablowcol;
UnitPM.tabbrushcol:=tabbrushcol;
UnitPM.tabbrushhighcol:=tabbrushhighcol;
end;

procedure setfontsbreadcrumb;
begin
if FormPeach.LabelClickAddress1.Caption<>' '+txt_mypc+' ' then FormPeach.LabelClickAddress1.Font.Style:=[];
FormPeach.LabelClickAddress2.Font.Style:=[];
FormPeach.LabelClickAddress3.Font.Style:=[];
FormPeach.LabelClickAddress4.Font.Style:=[];
FormPeach.LabelClickAddress5.Font.Style:=[];
FormPeach.LabelClickAddress6.Font.Style:=[];
FormPeach.LabelClickAddress7.Font.Style:=[];
FormPeach.LabelClickAddress8.Font.Style:=[];
FormPeach.LabelClickAdArchive1.Font.Style:=[];
FormPeach.LabelClickAdArchive2.Font.Style:=[];
FormPeach.LabelClickAdArchive3.Font.Style:=[];
FormPeach.LabelClickAdArchive4.Font.Style:=[];
if FormPeach.LabelClickAdArchive4.caption<>'' then
   begin
   FormPeach.LabelClickAdArchive4.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAdArchive4;
   end
else
if FormPeach.LabelClickAdArchive3.caption<>'' then
   begin
   FormPeach.LabelClickAdArchive3.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAdArchive3;
   end
else
if FormPeach.LabelClickAdArchive2.caption<>'' then
   begin
   FormPeach.LabelClickAdArchive2.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAdArchive2;
   end
else
if FormPeach.LabelClickAdArchive1.caption<>'' then
   begin
   FormPeach.LabelClickAdArchive1.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAdArchive1;
   end
else
if FormPeach.LabelClickAddress8.visible=true then
   begin
   FormPeach.LabelClickAddress8.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress8;
   end
else
if FormPeach.LabelClickAddress7.visible=true then
   begin
   FormPeach.LabelClickAddress7.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress7;
   end
else
if FormPeach.LabelClickAddress6.visible=true then
   begin
   FormPeach.LabelClickAddress6.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress6;
   end
else
if FormPeach.LabelClickAddress5.visible=true then
   begin
   FormPeach.LabelClickAddress5.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress5;
   end
else
if FormPeach.LabelClickAddress4.visible=true then
   begin
   FormPeach.LabelClickAddress4.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress4;
   end
else
if FormPeach.LabelClickAddress3.visible=true then
   begin
   FormPeach.LabelClickAddress3.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress3;
   end
else
if FormPeach.LabelClickAddress2.visible=true then
   begin
   FormPeach.LabelClickAddress2.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress2;
   end
else
if FormPeach.LabelClickAddress1.visible=true then
   begin
   FormPeach.LabelClickAddress1.Font.Style:=[fsBold];
   FormPeach.PanelAdArchive4.AnchorSideLeft.Control:=FormPeach.LabelClickAddress1;
   end;
FormPeach.PanelClickAddress.Width:=FormPeach.PanelAdArchive4.left+FormPeach.PanelAdArchive4.Width;
FormPeach.ShapeListBar.Width:=FormPeach.PanelClickAddress.Width+FormPeach.PanelListRoot.Width+8;
end;

procedure apply_theme; //apply colors but not opacity
var sepcol:TColor;
begin
if color3='clForm' then color3:=ColorToString(PTACOL);
getpcolors(stringtocolor(color1),stringtocolor(color2),stringtocolor(color3),temperature,contrast);
img_utils.relwindowcolor:=stringtocolor(color2);
FormPeach.Color:=stringtocolor(color2);
//FormPeach.Font.Color:=stringtocolor(color5);
FormPeach.StringGridClipboard.Color:=FormPeach.Color;
FormAdvf.Color:=FormPeach.Color;
FormImgCrop.Color:=FormPeach.Color;
FormImgViewer.Color:=FormPeach.Color;
FormDlg.Color:=FormPeach.Color;
FormImgRes.Color:=FormPeach.Color;
FormInput.Color:=FormPeach.Color;
FormKF.Color:=FormPeach.Color;
FormPaths.Color:=FormPeach.Color;
FormPM.Color:=FormPeach.Color;
FormPW.Color:=FormPeach.Color;
FormSelect.Color:=FormPeach.Color;
FormWeb.Color:=FormPeach.Color;
FormComment.Color:=FormPeach.Color;
FormGwrap.Color:=FormPeach.Color;
FormPeach.PanelInfoGeneral.Color:=StringToColor(colbtnhigh);
FormPeach.SplitterSide.Color:=StringToColor(colmid);
FormPeach.shapecsb.Pen.Color:=StringToColor(colmid);
FormPeach.PanelClipboard.Color:=StringToColor(collow);
FormPeach.ShapeThemes.Brush.Color:=StringToColor(collow);
FormPeach.ShapeThemes1.Brush.Color:=StringToColor(collow);
FormPeach.ShapeThemes2.Brush.Color:=StringToColor(collow);
case accenttoolbar of
0: begin
   FormPeach.PanelBarOpen.Color:=FormPeach.Color;
   FormPeach.BtnStyle.Color:=FormPeach.PanelBarOpen.Color;
   FormPeach.Bevel13.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel16.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel12.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel14.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel18.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel11.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel15.Pen.Color:=StringToColor(colmid);
   end;
1: begin
   FormPeach.PanelBarOpen.Color:=StringToColor(colvlow);
   FormPeach.BtnStyle.Color:=FormPeach.PanelBarOpen.Color;
   FormPeach.Bevel13.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel16.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel12.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel14.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel18.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel11.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel15.Pen.Color:=StringToColor(colmid);
   end;
2: begin
   FormPeach.PanelBarOpen.Color:=StringToColor(collow);
   FormPeach.BtnStyle.Color:=FormPeach.PanelBarOpen.Color;
   FormPeach.Bevel13.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel16.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel12.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel14.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel18.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel11.Pen.Color:=StringToColor(colmid);
   FormPeach.Bevel15.Pen.Color:=StringToColor(colmid);
   end;
3: begin
   FormPeach.PanelBarOpen.Color:=StringToColor(colmid);
   FormPeach.BtnStyle.Color:=FormPeach.PanelBarOpen.Color;
   FormPeach.Bevel13.Pen.Color:=StringToColor(colhigh);
   FormPeach.Bevel16.Pen.Color:=StringToColor(colhigh);
   FormPeach.Bevel12.Pen.Color:=StringToColor(colhigh);
   FormPeach.Bevel14.Pen.Color:=StringToColor(colhigh);
   FormPeach.Bevel18.Pen.Color:=StringToColor(colhigh);
   FormPeach.Bevel11.Pen.Color:=StringToColor(colhigh);
   FormPeach.Bevel15.Pen.Color:=StringToColor(colhigh);
   end;
4: begin
   FormPeach.PanelBarOpen.Color:=StringToColor(colhigh);
   FormPeach.BtnStyle.Color:=FormPeach.PanelBarOpen.Color;
   FormPeach.Bevel13.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.Bevel16.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.Bevel12.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.Bevel14.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.Bevel18.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.Bevel11.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.Bevel15.Pen.Color:=StringToColor(colbtnhigh);
   end;
5: begin
   FormPeach.PanelBarOpen.Color:=pvvvvlblue;
   FormPeach.BtnStyle.Color:=pvvvvlblue;
   FormPeach.Bevel13.Pen.Color:=pvvlblue;
   FormPeach.Bevel16.Pen.Color:=pvvlblue;
   FormPeach.Bevel12.Pen.Color:=pvvlblue;
   FormPeach.Bevel14.Pen.Color:=pvvlblue;
   FormPeach.Bevel18.Pen.Color:=pvvlblue;
   FormPeach.Bevel11.Pen.Color:=pvvlblue;
   FormPeach.Bevel15.Pen.Color:=pvvlblue;
   end;
6: begin
   FormPeach.PanelBarOpen.Color:=pvvvlblue;
   FormPeach.BtnStyle.Color:=pvvvlblue;
   FormPeach.Bevel13.Pen.Color:=pvvlblue;
   FormPeach.Bevel16.Pen.Color:=pvvlblue;
   FormPeach.Bevel12.Pen.Color:=pvvlblue;
   FormPeach.Bevel14.Pen.Color:=pvvlblue;
   FormPeach.Bevel18.Pen.Color:=pvvlblue;
   FormPeach.Bevel11.Pen.Color:=pvvlblue;
   FormPeach.Bevel15.Pen.Color:=pvvlblue;
   end;
7: begin
   FormPeach.PanelBarOpen.Color:=pvvlblue;
   FormPeach.BtnStyle.Color:=pvvlblue;
   FormPeach.Bevel13.Pen.Color:=pvlblue;
   FormPeach.Bevel16.Pen.Color:=pvlblue;
   FormPeach.Bevel12.Pen.Color:=pvlblue;
   FormPeach.Bevel14.Pen.Color:=pvlblue;
   FormPeach.Bevel18.Pen.Color:=pvlblue;
   FormPeach.Bevel11.Pen.Color:=pvlblue;
   FormPeach.Bevel15.Pen.Color:=pvlblue;
   end;
8: begin
   FormPeach.PanelBarOpen.Color:=pvlblue;
   FormPeach.BtnStyle.Color:=pvlblue;
   FormPeach.Bevel13.Pen.Color:=plblue;
   FormPeach.Bevel16.Pen.Color:=plblue;
   FormPeach.Bevel12.Pen.Color:=plblue;
   FormPeach.Bevel14.Pen.Color:=plblue;
   FormPeach.Bevel18.Pen.Color:=plblue;
   FormPeach.Bevel11.Pen.Color:=plblue;
   FormPeach.Bevel15.Pen.Color:=plblue;
   end;
end;

case solidaddressstyle of
   0: FormPeach.PanelListbar.Color:=FormPeach.Color;
   1: FormPeach.PanelListbar.Color:=StringToColor(colvlow);
   2: FormPeach.PanelListbar.Color:=StringToColor(collow);
   3: FormPeach.PanelListbar.Color:=StringToColor(colmid);
   4: FormPeach.PanelListbar.Color:=StringToColor(colhigh);
   5: FormPeach.PanelListbar.Color:=pvvvvlblue;
   6: FormPeach.PanelListbar.Color:=pvvvlblue;
   7: FormPeach.PanelListbar.Color:=pvvlblue;
   8: FormPeach.PanelListbar.Color:=pvlblue;
   end;

FormPeach.PanelBottom.Color:=FormPeach.Color;
FormPeach.SplitterBottom.Color:=FormPeach.Color;

if decostyle>0 then FormPeach.Bevel21.Visible:=true else FormPeach.Bevel21.Visible:=false;

case altaddressstyle of
3: begin
   FormPeach.ShapeListBar.Brush.Color:=FormPeach.Color;
   FormPeach.PanelAddress.Brush.Color:=FormPeach.Color;
   if decostyle<2 then FormPeach.ShapeListBar.Pen.Color:=FormPeach.Color else FormPeach.ShapeListBar.Pen.Color:=pvvvlblue;
   if decostyle>0 then FormPeach.Bevel21.Pen.Color:=pvlblue;
   FormPeach.splitsearch.Color:=pvlblue;
   if (altbread>0) and (macbread=0) then abactivecol:=pvvlblue else abactivecol:=pvvvmlblue;
   abarchivecol:=pvvvvlblue;
   sepcol:=pvvlblue;
   colalertp:=colalertb;
   end;
0: begin
   FormPeach.ShapeListBar.Brush.Color:=FormPeach.Color;
   FormPeach.PanelAddress.Brush.Color:=FormPeach.Color;
   if decostyle<2 then FormPeach.ShapeListBar.Pen.Color:=FormPeach.Color else FormPeach.ShapeListBar.Pen.Color:=StringToColor(colmid);
   if decostyle>0 then FormPeach.Bevel21.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.splitsearch.Color:=StringToColor(colmid);
   if (altbread>0) and (macbread=0) then abactivecol:=StringToColor(colmid) else abactivecol:=StringToColor(collow);
   abarchivecol:=StringToColor(colvlow);
   sepcol:=StringToColor(colmid);
   colalertp:=colalert;
   end;
1: begin
   FormPeach.ShapeListBar.Brush.Color:=StringToColor(collow);
   FormPeach.PanelAddress.Brush.Color:=StringToColor(collow);
   if decostyle<2 then FormPeach.ShapeListBar.Pen.Color:=StringToColor(collow) else FormPeach.ShapeListBar.Pen.Color:=StringToColor(colmid);
   if decostyle>0 then FormPeach.Bevel21.Pen.Color:=StringToColor(colbtnhigh);
   FormPeach.splitsearch.Color:=StringToColor(colbtnhigh);
   if (altbread>0) and (macbread=0) then abactivecol:=StringToColor(colbtnhigh) else abactivecol:=StringToColor(colhigh);
   abarchivecol:=StringToColor(colmid);
   sepcol:=StringToColor(colbtnhigh);
   colalertp:=colalert;
   end;
2: begin
   FormPeach.ShapeListBar.Brush.Color:=pvvvlblue;
   FormPeach.PanelAddress.Brush.Color:=pvvvlblue;
   if decostyle<2 then FormPeach.ShapeListBar.Pen.Color:=pvvvlblue else FormPeach.ShapeListBar.Pen.Color:=pvvlblue;
   if decostyle>0 then FormPeach.Bevel21.Pen.Color:=pvlblue;
   FormPeach.splitsearch.Color:=pvlblue;
   if (altbread>0) and (macbread=0) then abactivecol:=pvmlblue else abactivecol:=pvvlblue;
   abarchivecol:=pvvmlblue;
   sepcol:=pvlblue;
   colalertp:=colalertb;
   end;
end;

if macbread=1 then
   begin
   FormPeach.ImageAddress.Visible:=false;
   FormPeach.PanelAddress0.Visible:=false;
   end;

case altbread of
   0:
   begin
   FormPeach.shapeaddress0.visible:=false;
   FormPeach.shapeaddress1.visible:=false;
   FormPeach.shapeaddress2.visible:=false;
   FormPeach.shapeaddress3.visible:=false;
   FormPeach.shapeaddress4.visible:=false;
   FormPeach.shapeaddress5.visible:=false;
   FormPeach.shapeaddress6.visible:=false;
   FormPeach.shapeaddress7.visible:=false;
   FormPeach.shapeaddress8.visible:=false;
   FormPeach.shapeaddress9.visible:=false;
   FormPeach.shapeaddress10.visible:=false;
   FormPeach.shapeaddress11.visible:=false;
   FormPeach.PanelAdArchive4.visible:=false;
   FormPeach.PanelLCA1.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA2.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA3.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA4.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA5.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA6.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA7.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCA8.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCAa1.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCAa2.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCAa3.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelLCAa4.Height:=FormPeach.PanelListRoot.Height;
   FormPeach.PanelClickAddress.AnchorSideRight.Control:=FormPeach.PanelListSearch;
   FormPeach.ShapeListBar.AnchorSideRight.Control:=FormPeach.PanelSPaddress;
   end;
   1:
   begin
   FormPeach.imageaddress0.visible:=false;
   FormPeach.imageaddress1.visible:=false;
   FormPeach.imageaddress2.visible:=false;
   FormPeach.imageaddress3.visible:=false;
   FormPeach.imageaddress4.visible:=false;
   FormPeach.imageaddress5.visible:=false;
   FormPeach.imageaddress6.visible:=false;
   FormPeach.imageaddress7.visible:=false;
   FormPeach.shapeaddress0.visible:=true;
   FormPeach.shapeaddress1.visible:=true;
   FormPeach.shapeaddress2.visible:=true;
   FormPeach.shapeaddress3.visible:=true;
   FormPeach.shapeaddress4.visible:=true;
   FormPeach.shapeaddress5.visible:=true;
   FormPeach.shapeaddress6.visible:=true;
   FormPeach.shapeaddress7.visible:=true;
   FormPeach.shapeaddress8.visible:=true;
   FormPeach.shapeaddress9.visible:=true;
   FormPeach.shapeaddress10.visible:=true;
   FormPeach.shapeaddress11.visible:=true;
   FormPeach.PanelAdArchive4.visible:=true;
   FormPeach.shapeaddress0.pen.color:=sepcol;
   FormPeach.shapeaddress1.pen.color:=sepcol;
   FormPeach.shapeaddress2.pen.color:=sepcol;
   FormPeach.shapeaddress3.pen.color:=sepcol;
   FormPeach.shapeaddress4.pen.color:=sepcol;
   FormPeach.shapeaddress5.pen.color:=sepcol;
   FormPeach.shapeaddress6.pen.color:=sepcol;
   FormPeach.shapeaddress7.pen.color:=sepcol;
   FormPeach.shapeaddress8.pen.color:=sepcol;
   FormPeach.shapeaddress9.pen.color:=sepcol;
   FormPeach.shapeaddress10.pen.color:=sepcol;
   FormPeach.shapeaddress11.pen.color:=sepcol;
   if macbread=0 then
      begin
      FormPeach.PanelLCA1.Height:=pbarhsmall;
      FormPeach.PanelLCA2.Height:=pbarhsmall;
      FormPeach.PanelLCA3.Height:=pbarhsmall;
      FormPeach.PanelLCA4.Height:=pbarhsmall;
      FormPeach.PanelLCA5.Height:=pbarhsmall;
      FormPeach.PanelLCA6.Height:=pbarhsmall;
      FormPeach.PanelLCA7.Height:=pbarhsmall;
      FormPeach.PanelLCA8.Height:=pbarhsmall;
      FormPeach.PanelLCAa1.Height:=pbarhsmall;
      FormPeach.PanelLCAa2.Height:=pbarhsmall;
      FormPeach.PanelLCAa3.Height:=pbarhsmall;
      FormPeach.PanelLCAa4.Height:=pbarhsmall;
      end;
   FormPeach.PanelClickAddress.AnchorSideRight.Control:=nil;
   FormPeach.ShapeListBar.AnchorSideRight.Control:=nil;
   setfontsbreadcrumb;
   update_addressbar(FormPeach.EditOpenInInteractive.Text);
   end;
   2:
   begin
   FormPeach.imageaddress0.visible:=false;
   FormPeach.imageaddress1.visible:=false;
   FormPeach.imageaddress2.visible:=false;
   FormPeach.imageaddress3.visible:=false;
   FormPeach.imageaddress4.visible:=false;
   FormPeach.imageaddress5.visible:=false;
   FormPeach.imageaddress6.visible:=false;
   FormPeach.imageaddress7.visible:=false;
   FormPeach.shapeaddress0.visible:=false;
   FormPeach.shapeaddress1.visible:=false;
   FormPeach.shapeaddress2.visible:=false;
   FormPeach.shapeaddress3.visible:=false;
   FormPeach.shapeaddress4.visible:=false;
   FormPeach.shapeaddress5.visible:=false;
   FormPeach.shapeaddress6.visible:=false;
   FormPeach.shapeaddress7.visible:=false;
   FormPeach.shapeaddress8.visible:=false;
   FormPeach.shapeaddress9.visible:=false;
   FormPeach.shapeaddress10.visible:=false;
   FormPeach.shapeaddress11.visible:=false;
   FormPeach.PanelAdArchive4.visible:=false;
   FormPeach.PanelLCA1.Height:=pbarhsmall;
   FormPeach.PanelLCA2.Height:=pbarhsmall;
   FormPeach.PanelLCA3.Height:=pbarhsmall;
   FormPeach.PanelLCA4.Height:=pbarhsmall;
   FormPeach.PanelLCA5.Height:=pbarhsmall;
   FormPeach.PanelLCA6.Height:=pbarhsmall;
   FormPeach.PanelLCA7.Height:=pbarhsmall;
   FormPeach.PanelLCA8.Height:=pbarhsmall;
   FormPeach.PanelLCAa1.Height:=pbarhsmall;
   FormPeach.PanelLCAa2.Height:=pbarhsmall;
   FormPeach.PanelLCAa3.Height:=pbarhsmall;
   FormPeach.PanelLCAa4.Height:=pbarhsmall;
   FormPeach.PanelAddress0.Caption:=DirectorySeparator;
   FormPeach.PanelAddress1.Caption:=DirectorySeparator;
   FormPeach.PanelAddress2.Caption:=DirectorySeparator;
   FormPeach.PanelAddress3.Caption:=DirectorySeparator;
   FormPeach.PanelAddress4.Caption:=DirectorySeparator;
   FormPeach.PanelAddress5.Caption:=DirectorySeparator;
   FormPeach.PanelAddress6.Caption:=DirectorySeparator;
   FormPeach.PanelAddress7.Caption:=DirectorySeparator;
   FormPeach.PanelAdArchive0.Caption:=DirectorySeparator;
   FormPeach.PanelAdArchive1.Caption:=DirectorySeparator;
   FormPeach.PanelAdArchive2.Caption:=DirectorySeparator;
   FormPeach.PanelAdArchive3.Caption:=DirectorySeparator;
   FormPeach.PanelClickAddress.AnchorSideRight.Control:=FormPeach.PanelListSearch;
   FormPeach.ShapeListBar.AnchorSideRight.Control:=FormPeach.PanelSPaddress;
   setfontsbreadcrumb;
   end;
end;
{FormPeach.ShapeListBar.Shape:=stRectangle; //the old squared look of the address bar
FormPeach.ShapeListBar.BorderSpacing.Right:=0;
FormPeach.PanelAddress.BorderSpacing.Left:=2;
FormPeach.PanelAddress.BorderSpacing.Right:=2;}
case alttabstyle of
   0,1,2:
   begin
   FormPeach.PanelTitleExtractTabAlign.AnchorSideLeft.Side:=asrleft;
   FormPeach.PanelTitleAddTabAlign.AnchorSideLeft.Side:=asrleft;
   FormPeach.PanelTitleAppsTabAlign.AnchorSideLeft.Side:=asrleft;
   FormPM.PanelTitlePMTabAlign.AnchorSideLeft.Side:=asrleft;
   FormGwrap.PanelTitlePLTabAlign.AnchorSideLeft.Side:=asrleft;
   end
   else
   begin
   FormPeach.PanelTitleExtractTabAlign.AnchorSideLeft.Side:=asrCenter;
   FormPeach.PanelTitleAddTabAlign.AnchorSideLeft.Side:=asrCenter;
   FormPeach.PanelTitleAppsTabAlign.AnchorSideLeft.Side:=asrCenter;
   FormPM.PanelTitlePMTabAlign.AnchorSideLeft.Side:=asrCenter;
   FormGwrap.PanelTitlePLTabAlign.AnchorSideLeft.Side:=asrCenter;
   end;
end;
case alttabstyle of
   0,3:
   begin
   FormPeach.ShapeOptions1.Shape:=stRoundRect;
   FormPeach.ShapeOptions2.Shape:=stRoundRect;
   FormPeach.ShapeOptions3.Shape:=stRoundRect;
   FormPeach.ShapeOptions4.Shape:=stRoundRect;
   FormPeach.ShapeOptions5.Shape:=stRoundRect;
   FormPeach.ShapeOptions6.Shape:=stRoundRect;
   FormPeach.ShapeOptions7.Shape:=stRoundRect;
   FormPeach.ShapeOptions8.Shape:=stRoundRect;
   FormPeach.ShapeOptions1.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions2.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions3.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions4.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions5.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions6.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions7.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions8.BorderSpacing.Around:=6;
   FormPeach.ShapeOptions1.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions2.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions3.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions4.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions5.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions6.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions7.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeOptions8.Anchors := [akLeft, akRight, akTop, akBottom];
   FormPeach.ShapeTitleAddb1.Shape:=stRoundRect;
   FormPeach.ShapeTitleAddb2.Shape:=stRoundRect;
   FormPeach.ShapeTitleAddb3.Shape:=stRoundRect;
   FormPeach.ShapeTitleAddb4.Shape:=stRoundRect;
   FormPeach.ShapeTitleExtractb1.Shape:=stRoundRect;
   FormPeach.ShapeTitleExtractb2.Shape:=stRoundRect;
   FormPeach.ShapeTitleExtractb3.Shape:=stRoundRect;
   FormPeach.ShapeTitleExtractb4.Shape:=stRoundRect;
   FormPeach.ShapeTitleAppsb1.Shape:=stRoundRect;
   FormPeach.ShapeTitleAppsb2.Shape:=stRoundRect;
   FormPM.ShapeTitlePMb1.Shape:=stRoundRect;
   FormPM.ShapeTitlePMb2.Shape:=stRoundRect;
   FormGwrap.ShapeTitleb1.Shape:=stRoundRect;
   FormGwrap.ShapeTitleb2.Shape:=stRoundRect;
   FormGwrap.ShapeTitleb3.Shape:=stRoundRect;
   FormGwrap.ShapeTitleb4.Shape:=stRoundRect;
   FormPeach.LabelTitleAdd1.BorderSpacing.Left:=6;
   FormPeach.LabelTitleAdd2.BorderSpacing.Left:=6;
   FormPeach.LabelTitleAdd3.BorderSpacing.Left:=6;
   FormPeach.LabelTitleAdd4.BorderSpacing.Left:=6;
   FormPeach.LabelTitleExtract1.BorderSpacing.Left:=6;
   FormPeach.LabelTitleExtract2.BorderSpacing.Left:=6;
   FormPeach.LabelTitleExtract3.BorderSpacing.Left:=6;
   FormPeach.LabelTitleExtract4.BorderSpacing.Left:=6;
   FormPeach.LabelTitleApps1.BorderSpacing.Left:=6;
   FormPeach.LabelTitleApps2.BorderSpacing.Left:=6;
   FormPM.LabelTitlePM1.BorderSpacing.Left:=6;
   FormPM.LabelTitlePM2.BorderSpacing.Left:=6;
   FormGwrap.LabelTitle1.BorderSpacing.Left:=6;
   FormGwrap.LabelTitle2.BorderSpacing.Left:=6;
   FormGwrap.LabelTitle3.BorderSpacing.Left:=6;
   FormGwrap.LabelTitle4.BorderSpacing.Left:=6;
   end
   else
   begin
   FormPeach.ShapeOptions1.Shape:=stRectangle;
   FormPeach.ShapeOptions2.Shape:=stRectangle;
   FormPeach.ShapeOptions3.Shape:=stRectangle;
   FormPeach.ShapeOptions4.Shape:=stRectangle;
   FormPeach.ShapeOptions5.Shape:=stRectangle;
   FormPeach.ShapeOptions6.Shape:=stRectangle;
   FormPeach.ShapeOptions7.Shape:=stRectangle;
   FormPeach.ShapeOptions8.Shape:=stRectangle;
   FormPeach.ShapeOptions1.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions2.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions3.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions4.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions5.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions6.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions7.BorderSpacing.Around:=0;
   FormPeach.ShapeOptions8.BorderSpacing.Around:=0;
   case alttabstyle of
      1,4:
      begin
      FormPeach.ShapeOptions1.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions2.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions3.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions4.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions5.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions6.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions7.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions8.Anchors := [akLeft, akTop, akBottom];
      FormPeach.ShapeOptions1.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions2.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions3.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions4.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions5.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions6.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions7.Width:=pbarhsmall+2;
      FormPeach.ShapeOptions8.Width:=pbarhsmall+2;
      end
      else
      begin
      FormPeach.ShapeOptions1.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions2.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions3.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions4.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions5.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions6.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions7.Anchors := [akLeft, akRight, akTop, akBottom];
      FormPeach.ShapeOptions8.Anchors := [akLeft, akRight, akTop, akBottom];
      end;
   end;

   FormPeach.ShapeTitleAddb1.Shape:=stRectangle;
   FormPeach.ShapeTitleAddb2.Shape:=stRectangle;
   FormPeach.ShapeTitleAddb3.Shape:=stRectangle;
   FormPeach.ShapeTitleAddb4.Shape:=stRectangle;
   FormPeach.ShapeTitleExtractb1.Shape:=stRectangle;
   FormPeach.ShapeTitleExtractb2.Shape:=stRectangle;
   FormPeach.ShapeTitleExtractb3.Shape:=stRectangle;
   FormPeach.ShapeTitleExtractb4.Shape:=stRectangle;
   FormPeach.ShapeTitleAppsb1.Shape:=stRectangle;
   FormPeach.ShapeTitleAppsb2.Shape:=stRectangle;
   FormPM.ShapeTitlePMb1.Shape:=stRectangle;
   FormPM.ShapeTitlePMb2.Shape:=stRectangle;
   FormGwrap.ShapeTitleb1.Shape:=stRectangle;
   FormGwrap.ShapeTitleb2.Shape:=stRectangle;
   FormGwrap.ShapeTitleb3.Shape:=stRectangle;
   FormGwrap.ShapeTitleb4.Shape:=stRectangle;
   FormPeach.LabelTitleAdd1.BorderSpacing.Left:=0;
   FormPeach.LabelTitleAdd2.BorderSpacing.Left:=0;
   FormPeach.LabelTitleAdd3.BorderSpacing.Left:=0;
   FormPeach.LabelTitleAdd4.BorderSpacing.Left:=0;
   FormPeach.LabelTitleExtract1.BorderSpacing.Left:=0;
   FormPeach.LabelTitleExtract2.BorderSpacing.Left:=0;
   FormPeach.LabelTitleExtract3.BorderSpacing.Left:=0;
   FormPeach.LabelTitleExtract4.BorderSpacing.Left:=0;
   FormPeach.LabelTitleApps1.BorderSpacing.Left:=0;
   FormPeach.LabelTitleApps2.BorderSpacing.Left:=0;
   FormPM.LabelTitlePM1.BorderSpacing.Left:=0;
   FormPM.LabelTitlePM2.BorderSpacing.Left:=0;
   FormGwrap.LabelTitle1.BorderSpacing.Left:=0;
   FormGwrap.LabelTitle2.BorderSpacing.Left:=0;
   FormGwrap.LabelTitle3.BorderSpacing.Left:=0;
   FormGwrap.LabelTitle4.BorderSpacing.Left:=0;
   end;
   end;
FormPeach.ShapeTitleAddb1.Brush.Color:=StringToColor(collow);
FormPeach.ShapeTitleAddb2.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleAddb3.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleAddb4.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleExtractb1.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleExtractb2.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleExtractb3.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleExtractb4.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleAppsb1.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPeach.ShapeTitleAppsb2.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPM.ShapeTitlePMb1.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;
FormPM.ShapeTitlePMb2.Brush.Color:=FormPeach.ShapeTitleAddb1.Brush.Color;

FormPeach.Shapelinkadd1.Brush.Color:=StringToColor(collow);
FormPeach.Shapelinkadd2.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkadd3.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkadd4.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkextract1.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkextract2.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkextract3.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkextract4.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkapps1.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPeach.Shapelinkapps2.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPM.ShapelinkPM1.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormPM.ShapelinkPM2.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormGwrap.Shapelink1.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormGwrap.Shapelink2.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormGwrap.Shapelink3.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
FormGwrap.Shapelink4.Brush.Color:=FormPeach.Shapelinkadd1.Brush.Color;
UnitPM.highlighttabs:=highlighttabs;
UnitGwrap.highlighttabs:=highlighttabs;
UnitPM.color2:=color2;
UnitGwrap.color2:=color2;

FormPeach.SplitterOptions.Color:=StringToColor(colmid);
FormPeach.BevelTitleOpt1.Color:=StringToColor(colmid);
FormPeach.BevelTitleOpt2.Color:=StringToColor(colmid);
FormPeach.BevelTitleOpt3.Color:=StringToColor(colmid);
FormPeach.BevelTitleOpt4.Color:=StringToColor(colmid);
FormPeach.BevelTitleOpt5.Color:=StringToColor(colmid);
FormPeach.BevelTitleOpt6.Color:=StringToColor(colmid);
FormPeach.BevelTitle