/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.geo.renderer;

import ancestris.modules.geo.GeoMapTopComponent;
import ancestris.modules.geo.GeoPoint;
import java.awt.Color;
import org.jxmapviewer.viewer.DefaultWaypointRenderer;
import org.jxmapviewer.viewer.Waypoint;

public class AncestrisWaypointRenderer
extends DefaultWaypointRenderer {
    protected int markersSize;
    protected Color markersColor;
    protected final GeoMapTopComponent gtmc;

    public AncestrisWaypointRenderer(int size, Color couleur, GeoMapTopComponent theGtmc) {
        this.markersSize = size;
        this.markersColor = couleur;
        this.gtmc = theGtmc;
    }

    public AncestrisWaypointRenderer() {
        this(10, Color.BLUE, null);
    }

    protected Color adjustGenerationColor(Waypoint wp) {
        String maxYear;
        if (this.gtmc == null || !this.gtmc.isGenerationColor()) {
            return this.markersColor;
        }
        String[] infos = ((GeoPoint)wp).getGeoNodeObject().getEventsInfo(this.gtmc.getFilter());
        int year = this.gtmc.getReferenceYear();
        String string = maxYear = this.gtmc.isGenerationUpperLimit() ? infos[8] : infos[7];
        if (maxYear == null || "".equals(maxYear) || "-".equals(maxYear)) {
            return this.markersColor;
        }
        int backInTime = (year -= Integer.valueOf(maxYear).intValue()) / (this.gtmc.getGenerationYear() == 0 ? 25 : this.gtmc.getGenerationYear());
        int red = this.markersColor.getRed();
        int green = this.markersColor.getGreen();
        int blue = this.markersColor.getBlue();
        if ((red = (int)((double)red * (1.0 - (double)backInTime * 0.05))) < 0) {
            red = 0;
        }
        if (red > 255) {
            red = 255;
        }
        if ((green = (int)((double)green * (1.0 - (double)backInTime * 0.05))) < 0) {
            green = 0;
        }
        if (green > 255) {
            green = 255;
        }
        if ((blue = (int)((double)blue * (1.0 - (double)backInTime * 0.05))) < 0) {
            blue = 0;
        }
        if (blue > 255) {
            blue = 255;
        }
        return new Color(red, green, blue);
    }
}

