/*
 * Decompiled with CFR 0.152.
 */
package ancestris.app;

import ancestris.api.editor.AncestrisEditor;
import ancestris.app.OptionDataOptionsPanelController;
import ancestris.core.CoreOptions;
import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.util.Lifecycle;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

final class OptionDataPanel
extends JPanel {
    private GedcomOptions gedcomOptions = GedcomOptions.getInstance();
    private DefaultComboBoxModel comboModel = null;
    private List<AncestrisEditor> editors = new ArrayList<AncestrisEditor>();
    private JPanel IDPanel;
    private JCheckBox cbAddAge;
    private JCheckBox cbAutoCommit;
    private JCheckBox cbCreateSpouse;
    private JCheckBox cbDuplicateEachTime;
    private JCheckBox cbForceRelative;
    private JCheckBox cbNamesInUppercase;
    private JCheckBox cbNullLast;
    private JCheckBox cbReuseIDs;
    private JCheckBox cbSameSpouseName;
    private JCheckBox cbSplitJuridictions;
    private JCheckBox cbUseSpace;
    private JCheckBox cbValidate;
    private JComboBox cboxDefaultEditor;
    private JComboBox<GedcomConstants.Encodings> cboxEncoding;
    private JCheckBox checkRemote;
    private JPanel editingPanel;
    private JPanel encodingPanel;
    private JSpinner idLength;
    private JScrollPane jScrollPane1;
    private JLabel lCancellations;
    private JLabel lDefaultEditor;
    private JLabel lDefaultIDLength;
    private JLabel lFileEncoding;
    private JPanel mainPanel;
    private JPanel mediaPanel;
    private JPanel namesPanel;
    private JSpinner nbCancellations;
    private JSpinner nbTimeoutSpinner;
    private JPanel placePanel;
    private JLabel timeoutLabel;

    OptionDataPanel(OptionDataOptionsPanelController controller) {
        Indi indi = new Indi();
        for (AncestrisEditor edt : AncestrisEditor.findEditors()) {
            if (!edt.canEdit((Property)indi)) continue;
            this.editors.add(edt);
        }
        AncestrisEditor[] arrayEditors = (AncestrisEditor[])this.editors.toArray(AncestrisEditor[]::new);
        this.comboModel = new DefaultComboBoxModel<AncestrisEditor>(arrayEditors);
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.namesPanel = new JPanel();
        this.cbNamesInUppercase = new JCheckBox();
        this.cbSameSpouseName = new JCheckBox();
        this.IDPanel = new JPanel();
        this.cbReuseIDs = new JCheckBox();
        this.lDefaultIDLength = new JLabel();
        this.idLength = new JSpinner();
        this.placePanel = new JPanel();
        this.cbUseSpace = new JCheckBox();
        this.cbSplitJuridictions = new JCheckBox();
        this.encodingPanel = new JPanel();
        this.lFileEncoding = new JLabel();
        this.cboxEncoding = new JComboBox<GedcomConstants.Encodings>(GedcomConstants.Encodings.values());
        this.editingPanel = new JPanel();
        this.lDefaultEditor = new JLabel();
        this.cboxDefaultEditor = new JComboBox();
        this.cbAutoCommit = new JCheckBox();
        this.nbCancellations = new JSpinner(new SpinnerNumberModel(10, 10, 300, 5));
        this.lCancellations = new JLabel();
        this.cbCreateSpouse = new JCheckBox();
        this.cbDuplicateEachTime = new JCheckBox();
        this.cbAddAge = new JCheckBox();
        this.cbNullLast = new JCheckBox();
        this.cbValidate = new JCheckBox();
        this.mediaPanel = new JPanel();
        this.cbForceRelative = new JCheckBox();
        this.nbTimeoutSpinner = new JSpinner();
        this.timeoutLabel = new JLabel();
        this.checkRemote = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setRequestFocusEnabled(false);
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.namesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.namesPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbNamesInUppercase, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbNamesInUppercase.text"));
        this.cbNamesInUppercase.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbNamesInUppercase.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSameSpouseName, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSameSpouseName.text"));
        this.cbSameSpouseName.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSameSpouseName.toolTipText"));
        GroupLayout namesPanelLayout = new GroupLayout(this.namesPanel);
        this.namesPanel.setLayout(namesPanelLayout);
        namesPanelLayout.setHorizontalGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(namesPanelLayout.createSequentialGroup().addContainerGap().addGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbNamesInUppercase).addComponent(this.cbSameSpouseName)).addContainerGap(-1, Short.MAX_VALUE)));
        namesPanelLayout.setVerticalGroup(namesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(namesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbNamesInUppercase).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSameSpouseName).addContainerGap(16, Short.MAX_VALUE)));
        this.IDPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.IDPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbReuseIDs, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbReuseIDs.text"));
        this.cbReuseIDs.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbReuseIDs.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lDefaultIDLength, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultIDLength.text"));
        this.lDefaultIDLength.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultIDLength.toolTipText"));
        this.idLength.setModel(new SpinnerNumberModel(0, 0, 10, 1));
        this.idLength.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.idLength.toolTipText"));
        GroupLayout IDPanelLayout = new GroupLayout(this.IDPanel);
        this.IDPanel.setLayout(IDPanelLayout);
        IDPanelLayout.setHorizontalGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(IDPanelLayout.createSequentialGroup().addContainerGap().addGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(IDPanelLayout.createSequentialGroup().addComponent(this.cbReuseIDs).addGap(0, 79, Short.MAX_VALUE)).addGroup(IDPanelLayout.createSequentialGroup().addComponent(this.lDefaultIDLength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.idLength))).addContainerGap()));
        IDPanelLayout.setVerticalGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(IDPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbReuseIDs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(IDPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lDefaultIDLength).addComponent(this.idLength, -2, -1, -2)).addContainerGap()));
        this.placePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.placePanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUseSpace, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbUseSpace.text"));
        this.cbUseSpace.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbUseSpace.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbSplitJuridictions, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSplitJuridictions.text"));
        this.cbSplitJuridictions.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbSplitJuridictions.toolTipText"));
        GroupLayout placePanelLayout = new GroupLayout(this.placePanel);
        this.placePanel.setLayout(placePanelLayout);
        placePanelLayout.setHorizontalGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(placePanelLayout.createSequentialGroup().addContainerGap().addGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbUseSpace, -1, 296, Short.MAX_VALUE).addComponent(this.cbSplitJuridictions, -1, -1, Short.MAX_VALUE))));
        placePanelLayout.setVerticalGroup(placePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(placePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cbUseSpace).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSplitJuridictions).addContainerGap(-1, Short.MAX_VALUE)));
        this.encodingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.encodingPanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.lFileEncoding, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lFileEncoding.text"));
        this.lFileEncoding.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lFileEncoding.toolTipText"));
        this.cboxEncoding.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cboxEncoding.toolTipText"));
        GroupLayout encodingPanelLayout = new GroupLayout(this.encodingPanel);
        this.encodingPanel.setLayout(encodingPanelLayout);
        encodingPanelLayout.setHorizontalGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lFileEncoding).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboxEncoding, 0, 205, Short.MAX_VALUE).addContainerGap()));
        encodingPanelLayout.setVerticalGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(encodingPanelLayout.createSequentialGroup().addContainerGap().addGroup(encodingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lFileEncoding).addComponent(this.cboxEncoding, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.editingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.editingPanel.border.title")));
        Mnemonics.setLocalizedText((JLabel)this.lDefaultEditor, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultEditor.text"));
        this.lDefaultEditor.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lDefaultEditor.toolTipText"));
        this.cboxDefaultEditor.setModel(this.comboModel);
        this.cboxDefaultEditor.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cboxDefaultEditor.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAutoCommit, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAutoCommit.text"));
        this.cbAutoCommit.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAutoCommit.toolTipText"));
        this.nbCancellations.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.nbCancellations.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.lCancellations, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lCancellations.text"));
        this.lCancellations.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.lCancellations.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCreateSpouse, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbCreateSpouse.text_1"));
        this.cbCreateSpouse.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbCreateSpouse.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDuplicateEachTime, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbDuplicateEachTime.text"));
        this.cbDuplicateEachTime.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbDuplicateEachTime.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbAddAge, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAddAge.text"));
        this.cbAddAge.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbAddAge.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbNullLast, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbNullLast.text"));
        this.cbNullLast.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbNullLast.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbValidate, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbValidate.text"));
        this.cbValidate.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbValidate.toolTipText"));
        this.cbValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionDataPanel.this.cbValidateActionPerformed(evt);
            }
        });
        GroupLayout editingPanelLayout = new GroupLayout(this.editingPanel);
        this.editingPanel.setLayout(editingPanelLayout);
        editingPanelLayout.setHorizontalGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingPanelLayout.createSequentialGroup().addContainerGap().addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingPanelLayout.createSequentialGroup().addComponent(this.lDefaultEditor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboxDefaultEditor, 0, -1, Short.MAX_VALUE)).addGroup(editingPanelLayout.createSequentialGroup().addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbAutoCommit, -1, -1, Short.MAX_VALUE).addGroup(editingPanelLayout.createSequentialGroup().addComponent(this.nbCancellations, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lCancellations)).addComponent(this.cbCreateSpouse).addComponent(this.cbDuplicateEachTime).addComponent(this.cbAddAge).addComponent(this.cbNullLast, -1, -1, Short.MAX_VALUE).addComponent(this.cbValidate, -1, -1, Short.MAX_VALUE)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        editingPanelLayout.setVerticalGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editingPanelLayout.createSequentialGroup().addContainerGap().addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lDefaultEditor).addComponent(this.cboxDefaultEditor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAutoCommit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(editingPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nbCancellations, -2, 24, -2).addComponent(this.lCancellations)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCreateSpouse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAddAge).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDuplicateEachTime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbNullLast).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbValidate).addContainerGap(-1, Short.MAX_VALUE)));
        this.mediaPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.mediaPanel.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.cbForceRelative, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbForceRelative.text"));
        this.cbForceRelative.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.cbForceRelative.toolTipText"));
        this.nbTimeoutSpinner.setModel(new SpinnerNumberModel(2, 1, 60, 1));
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.timeoutLabel.text"));
        this.timeoutLabel.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.timeoutLabel.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.checkRemote, (String)NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.checkRemote.text"));
        this.checkRemote.setToolTipText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.checkRemote.toolTipText"));
        GroupLayout mediaPanelLayout = new GroupLayout(this.mediaPanel);
        this.mediaPanel.setLayout(mediaPanelLayout);
        mediaPanelLayout.setHorizontalGroup(mediaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediaPanelLayout.createSequentialGroup().addContainerGap().addGroup(mediaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbForceRelative).addGroup(mediaPanelLayout.createSequentialGroup().addComponent(this.checkRemote, -2, 257, -2).addGap(18, 18, 18).addComponent(this.nbTimeoutSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeoutLabel))).addContainerGap(69, Short.MAX_VALUE)));
        mediaPanelLayout.setVerticalGroup(mediaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mediaPanelLayout.createSequentialGroup().addComponent(this.cbForceRelative).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(mediaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nbTimeoutSpinner, -2, 24, -2).addComponent(this.timeoutLabel).addComponent(this.checkRemote)).addContainerGap()));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editingPanel, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.namesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.placePanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encodingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.IDPanel, -1, -1, Short.MAX_VALUE))).addComponent(this.mediaPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.namesPanel, -2, -1, -2).addComponent(this.IDPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.placePanel, -1, -1, Short.MAX_VALUE).addComponent(this.encodingPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mediaPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editingPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.namesPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.namesPanel.AccessibleContext.accessibleName"));
        this.IDPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.IDPanel.AccessibleContext.accessibleName"));
        this.placePanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.placePanel.AccessibleContext.accessibleName"));
        this.encodingPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionDataPanel.encodingPanel.AccessibleContext.accessibleName"));
        this.jScrollPane1.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 639, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 539, Short.MAX_VALUE));
    }

    private void cbValidateActionPerformed(ActionEvent evt) {
    }

    void load() {
        this.cbNamesInUppercase.setSelected(this.gedcomOptions.isUpperCaseNames());
        this.cbSameSpouseName.setSelected(this.gedcomOptions.isSetWifeLastname());
        this.cbReuseIDs.setSelected(this.gedcomOptions.isFillGapsInIDs());
        this.idLength.setValue(this.gedcomOptions.getEntityIdLength());
        this.cbUseSpace.setSelected(this.gedcomOptions.isUseSpacedPlaces());
        this.cbSplitJuridictions.setSelected(CoreOptions.getInstance().isSplitJurisdictions());
        this.cboxEncoding.setSelectedIndex(this.gedcomOptions.getDefaultEncoding());
        this.cbForceRelative.setSelected(this.gedcomOptions.isForceRelative());
        this.nbTimeoutSpinner.setValue(this.gedcomOptions.getURLTimeout());
        this.checkRemote.setSelected(this.gedcomOptions.isCheckRemote());
        this.cboxDefaultEditor.setSelectedItem(this.getEditorFromCanonicalName(this.gedcomOptions.getDefaultEditor()));
        this.cbAutoCommit.setSelected(ConfirmChangeWidget.getAutoCommit());
        this.nbCancellations.setValue(this.gedcomOptions.getNumberOfUndos());
        this.cbCreateSpouse.setSelected(this.gedcomOptions.getCreateSpouse());
        this.cbAddAge.setSelected(this.gedcomOptions.isAddAge());
        this.cbDuplicateEachTime.setSelected(this.gedcomOptions.getDuplicateAnyTime());
        this.cbNullLast.setSelected(this.gedcomOptions.getSortNullLast());
        this.cbValidate.setSelected(this.gedcomOptions.getAutoCheck());
    }

    void store() {
        this.gedcomOptions.setUpperCaseNames(this.cbNamesInUppercase.isSelected());
        this.gedcomOptions.setSetWifeLastname(this.cbSameSpouseName.isSelected());
        this.gedcomOptions.setFillGapsInIDs(this.cbReuseIDs.isSelected());
        this.gedcomOptions.setEntityIdLength(Integer.parseInt(this.idLength.getValue().toString()));
        if (this.cbUseSpace.isSelected() != this.gedcomOptions.isUseSpacedPlaces()) {
            Lifecycle.askForRestart();
            this.gedcomOptions.setUseSpacedPlaces(this.cbUseSpace.isSelected());
        }
        CoreOptions.getInstance().setSplitJurisdictions(this.cbSplitJuridictions.isSelected());
        this.gedcomOptions.setDefaultEncoding(this.cboxEncoding.getSelectedIndex());
        this.gedcomOptions.setForceRelative(this.cbForceRelative.isSelected());
        this.gedcomOptions.setURLTimeout(((Integer)this.nbTimeoutSpinner.getValue()).intValue());
        this.gedcomOptions.setCheckRemote(this.checkRemote.isSelected());
        this.gedcomOptions.setDefaultEditor(((AncestrisEditor)this.cboxDefaultEditor.getSelectedItem()).getName(true));
        ConfirmChangeWidget.setAutoCommit((boolean)this.cbAutoCommit.isSelected());
        this.gedcomOptions.setNumberOfUndos(((Integer)this.nbCancellations.getValue()).intValue());
        this.gedcomOptions.setCreateSpouse(this.cbCreateSpouse.isSelected());
        this.gedcomOptions.setAddAge(this.cbAddAge.isSelected());
        this.gedcomOptions.setDuplicateAnyTime(this.cbDuplicateEachTime.isSelected());
        this.gedcomOptions.setSortNullLast(this.cbNullLast.isSelected());
        this.gedcomOptions.setAutoCheck(this.cbValidate.isSelected());
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionDataPanel.class, (String)"OptionPanel.saved.statustext"));
    }

    public boolean valid() {
        return true;
    }

    private AncestrisEditor getEditorFromCanonicalName(String defaultEditor) {
        for (AncestrisEditor edt : this.editors) {
            if (!edt.getName(true).startsWith(defaultEditor)) continue;
            return edt;
        }
        return this.editors != null ? this.editors.get(0) : null;
    }
}

