/*
 * Decompiled with CFR 0.152.
 */
package ancestris.renderer.velocity;

import ancestris.core.TextOptions;
import ancestris.renderer.velocity.FamWrapper;
import ancestris.renderer.velocity.IndiWrapper;
import ancestris.renderer.velocity.PropertyAgeWrapper;
import ancestris.renderer.velocity.PropertyFileWrapper;
import ancestris.renderer.velocity.PropertyNameWrapper;
import ancestris.renderer.velocity.PropertyPlaceWrapper;
import ancestris.renderer.velocity.PropertyXRefWrapper;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyAge;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;

public class PropertyWrapper
implements Comparable<PropertyWrapper> {
    Property property;
    static final TextOptions OPTIONS = TextOptions.getInstance();

    PropertyWrapper(Property prop) {
        this.property = prop;
    }

    static PropertyWrapper create(Property p) {
        if (p == null) {
            return null;
        }
        if (p instanceof Indi) {
            return new IndiWrapper((Indi)p);
        }
        if (p instanceof Fam) {
            return new FamWrapper((Fam)p);
        }
        if (p instanceof PropertyAge) {
            return new PropertyAgeWrapper((PropertyAge)p);
        }
        if (p instanceof PropertyXRef) {
            return new PropertyXRefWrapper((PropertyXRef)p);
        }
        if (p instanceof PropertyPlace) {
            return new PropertyPlaceWrapper((PropertyPlace)p);
        }
        if (p instanceof PropertyFile) {
            return new PropertyFileWrapper((PropertyFile)p);
        }
        if (p instanceof PropertyName) {
            return new PropertyNameWrapper((PropertyName)p);
        }
        return new PropertyWrapper(p);
    }

    @Override
    public int compareTo(PropertyWrapper o) {
        return this.property.compareTo(o.property);
    }

    public PropertyWrapper getProperty(String tagPath) {
        if (this.property == null) {
            return null;
        }
        Property subProp = this.property.getPropertyByPath(this.property.getTag() + ":" + tagPath);
        return PropertyWrapper.create(subProp);
    }

    public PropertyWrapper getParent() {
        if (this.property == null) {
            return null;
        }
        return PropertyWrapper.create(this.property.getParent());
    }

    public Object get(String tag) {
        return this.getProperty(tag.toUpperCase());
    }

    public PropertyWrapper[] getProperties(String tagPath) {
        Property[] props = this.property.getProperties(new TagPath(this.property.getTag() + ":" + tagPath));
        if (props.length == 0) {
            return null;
        }
        PropertyWrapper[] reportProps = new PropertyWrapper[props.length];
        for (int i = 0; i < props.length; ++i) {
            reportProps[i] = PropertyWrapper.create(props[i]);
        }
        return reportProps;
    }

    public String getPath() {
        return this.property.getPath().toString();
    }

    public String getDate() {
        return this.format("{$D}");
    }

    public String getValue() {
        return this.property == null ? "" : this.property.getDisplayValue();
    }

    public String getName() {
        String str = this.property.getPropertyName();
        int i = str.indexOf(32);
        if (i > 0) {
            return str.substring(0, i);
        }
        return str;
    }

    public String getPlace() {
        return this.format("{$P}");
    }

    public String toString() {
        return this.getValue();
    }

    public String format(String fmtstr) {
        return this.property == null ? "" : this.property.format(fmtstr);
    }
}

