/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet.utils;

import ancestris.modules.exports.geneanet.GeneanetSynchronizePanel;
import ancestris.modules.exports.geneanet.entity.GeneanetMedia;
import ancestris.modules.exports.geneanet.entity.GeneanetMediaTypeEnum;
import ancestris.modules.exports.geneanet.entity.GenenaetIndiId;
import ancestris.modules.exports.geneanet.utils.GeneanetQueueManager;
import ancestris.modules.exports.geneanet.utils.GeneanetUtil;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyForeignXRef;
import genj.io.InputSource;
import genj.io.input.ByteInput;
import genj.io.input.FileInput;
import genj.io.input.URLInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.http.entity.ContentType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.openide.util.NbBundle;

public class GeneanetMediaProducer
implements Runnable {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);
    private final GeneanetQueueManager queueManager;
    private final Set<String> mediaAlreadySentList;
    private final List<GeneanetMedia> okMediaList;
    private final Gedcom currentGedcom;
    private final int nbWorker;

    public GeneanetMediaProducer(GeneanetQueueManager queueManager, Set<String> mediaAlreadySentList, List<GeneanetMedia> okMediaList, Gedcom currentGedcom, int nbWorker) {
        this.queueManager = queueManager;
        this.mediaAlreadySentList = mediaAlreadySentList;
        this.okMediaList = okMediaList;
        this.currentGedcom = currentGedcom;
        this.nbWorker = nbWorker;
    }

    @Override
    public void run() {
        List props = this.currentGedcom.getPropertiesByClass(PropertyFile.class);
        HashMap<String, Property> mapMedia = new HashMap<String, Property>(props.size());
        for (Property prop : props) {
            mapMedia.put(prop.getValue(), prop);
        }
        for (GeneanetMedia okMedia : this.okMediaList) {
            this.updateIds(okMedia);
            try {
                block26: {
                    Property parent;
                    if (this.mediaAlreadySentList.contains(okMedia.getPathName())) continue;
                    Property media = (Property)mapMedia.get(okMedia.getPathName());
                    if (!(media instanceof PropertyFile)) {
                        this.queueManager.putUpdate(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.deposit.error") + " " + okMedia.getPathName());
                        LOG.log(Level.INFO, "Unable to send this media :{0}", media.toString());
                        continue;
                    }
                    Property titles = media.getProperty("TITL");
                    if (titles == null && (parent = media.getParent()) != null) {
                        titles = parent.getProperty("TITL");
                    }
                    if (titles != null) {
                        String titre = titles.getValue();
                        if (titre.length() > 70) {
                            okMedia.setTitle(titre.substring(0, 69));
                        } else {
                            okMedia.setTitle(titre);
                        }
                    }
                    Property types = media.getProperty("_GENEANET_TYPE");
                    Property prim = media.getProperty("_PRIM");
                    if (types != null) {
                        okMedia.setType(GeneanetMediaTypeEnum.getValue(types.getValue()));
                    } else if (prim != null) {
                        okMedia.setType(GeneanetMediaTypeEnum.PORTRAITS);
                    } else {
                        okMedia.setType(this.getType(media));
                    }
                    Property form = media.getProperty("FORM");
                    ContentType ct = form != null ? GeneanetUtil.getContentType(form.getValue()) : ContentType.APPLICATION_OCTET_STREAM;
                    okMedia.setCt(ct);
                    PropertyFile pFile = (PropertyFile)media;
                    Optional input = pFile.getInput();
                    if (!input.isPresent()) {
                        this.queueManager.putUpdate(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.deposit.error") + " " + okMedia.getPathName());
                        LOG.log(Level.INFO, "No input detected for media :{0}", okMedia.getPathName());
                        continue;
                    }
                    InputSource source = (InputSource)input.get();
                    if (source instanceof FileInput) {
                        FileInput fileInput = (FileInput)source;
                        okMedia.setFichier(fileInput.getFile());
                        okMedia.setForm(form.getValue());
                    } else {
                        if (source instanceof URLInput || source instanceof ByteInput) {
                            try {
                                if (ContentType.APPLICATION_OCTET_STREAM.equals(ct)) {
                                    okMedia.setForm(".tmp");
                                } else {
                                    MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
                                    MimeType theMime = allTypes.forName(ct.getMimeType());
                                    okMedia.setForm(theMime.getExtension());
                                }
                                File localTempFile = File.createTempFile("AncTemp", okMedia.getForm());
                                FileUtils.copyInputStreamToFile((InputStream)source.open(), (File)localTempFile);
                                localTempFile.deleteOnExit();
                                okMedia.setFichier(localTempFile);
                                break block26;
                            }
                            catch (IOException | NullPointerException | MimeTypeException e) {
                                this.queueManager.putUpdate(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.deposit.error") + " " + okMedia.getPathName());
                                LOG.log(Level.INFO, "Unable to download remote file : " + okMedia.getPathName(), e);
                                continue;
                            }
                        }
                        this.queueManager.putUpdate(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.deposit.error") + " " + okMedia.getPathName());
                        LOG.log(Level.INFO, "Unable to get file : {0}", okMedia.getPathName());
                        continue;
                    }
                }
                try {
                    this.queueManager.putMedia(okMedia);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.INFO, "Error with media : " + okMedia.getPathName(), e);
                    this.queueManager.putUpdate(NbBundle.getMessage(GeneanetSynchronizePanel.class, (String)"media.deposit.error") + " " + okMedia.getPathName());
                }
            }
            catch (InterruptedException | MissingResourceException t) {
                LOG.log(Level.INFO, "throwable with media : " + okMedia.getPathName(), t);
            }
        }
        try {
            GeneanetMedia poison = new GeneanetMedia("", new ArrayList<GenenaetIndiId>());
            poison.setType(GeneanetMediaTypeEnum.STOP);
            for (int i = 0; i < this.nbWorker; ++i) {
                this.queueManager.putMedia(poison);
            }
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, "throwable with poison ", e);
        }
        LOG.log(Level.INFO, "Media list completed");
    }

    private void updateIds(GeneanetMedia okMedia) {
        for (GenenaetIndiId id : okMedia.getIds()) {
            Entity e = this.currentGedcom.getEntity("INDI", id.getId().replace("@", ""));
            if (e == null || !(e instanceof Indi)) continue;
            Indi indi = (Indi)e;
            id.setFirstName(indi.getFirstName());
            id.setLastName(indi.getLastName());
        }
    }

    private GeneanetMediaTypeEnum getType(Property media) {
        Entity entity = media.getEntity();
        if (entity instanceof Media) {
            Media obje = (Media)entity;
            if (obje.isConnected()) {
                for (PropertyForeignXRef p : obje.getProperties(PropertyForeignXRef.class)) {
                    if (p.getTarget() == null || p.getTarget().getParent() == null || !"INDI".equals(p.getTarget().getParent().getTag())) continue;
                    return GeneanetMediaTypeEnum.PORTRAITS;
                }
            }
        } else {
            Property gParent;
            Property parent = media.getParent();
            if (parent != null && "OBJE".equals(parent.getTag()) && "INDI".equals((gParent = parent.getParent()).getTag())) {
                return GeneanetMediaTypeEnum.PORTRAITS;
            }
        }
        return GeneanetMediaTypeEnum.ETAT_CIVIL;
    }
}

