/*
 * Decompiled with CFR 0.152.
 */
package genj.report;

import genj.util.swing.ImageIcon;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.ImageView;

public class ClassLoaderImageView
extends ImageView {
    private Image image;
    private int width;
    private int height;

    public ClassLoaderImageView(Element elem, Class<?> from) {
        block2: {
            super(elem);
            String src = (String)this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
            try {
                this.image = new ImageIcon(from, src).getImage();
                this.width = this.image.getWidth(null);
                this.height = this.image.getHeight(null);
            }
            catch (Exception e) {
                this.image = null;
                Icon icon = this.getNoImageIcon();
                if (icon == null) break block2;
                this.width = this.getNoImageIcon().getIconWidth();
                this.height = this.getNoImageIcon().getIconHeight();
            }
        }
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        Rectangle clip = g.getClipBounds();
        if (clip != null) {
            g.clipRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.image != null) {
            g.drawImage(this.image, rect.x, rect.y, this.width, this.height, null);
        } else {
            Icon icon = this.getNoImageIcon();
            if (icon != null) {
                icon.paintIcon(this.getContainer(), g, rect.x, rect.y);
            }
        }
        if (clip != null) {
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (axis == 0) {
            return this.width;
        }
        return this.height;
    }

    @Override
    public void setSize(float width, float height) {
    }
}

