/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.console;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class Console
implements OutputListener {
    private InputOutput io = null;
    private OutputWriter out = null;
    private OutputWriter error = null;
    private boolean displayIDELog = NbPreferences.forModule(Console.class).getBoolean("DisplayConsole", false);

    public Console(String tabName) {
        this.io = IOProvider.getDefault().getIO(tabName, true);
        this.out = this.io.getOut();
        this.error = this.io.getErr();
        if (this.displayIDELog) {
            this.io.select();
        }
    }

    public void show() {
        this.io.select();
    }

    public void reset() {
        this.close();
        try {
            this.out.reset();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void println(String s) {
        this.println(s, false);
    }

    public void println(String s, boolean time) {
        if (time) {
            s = this.getTime() + " " + (String)s;
        }
        try {
            this.out.println((String)s, null);
        }
        catch (IOException ex) {
            Logger.getLogger(Console.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void printError(String s) {
        this.printError(s, false);
    }

    public void printError(String s, boolean time) {
        if (time) {
            s = this.getTime() + " " + (String)s;
        }
        this.error.println((String)s);
    }

    public void close() {
        this.out.close();
        this.io.getErr().close();
    }

    private String getTime() {
        return DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss").format(LocalDateTime.now());
    }

    public void outputLineSelected(OutputEvent oe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void outputLineAction(OutputEvent oe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void outputLineCleared(OutputEvent oe) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

