/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.sosa;

import ancestris.core.TextOptions;
import ancestris.gedcom.privacy.PrivacyPolicy;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import ancestris.util.EventUsage;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.TagPath;
import genj.report.Report;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.openide.util.NbBundle;

public class ReportSosa
extends Report {
    public FormatOptions formatOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public DisplayElements display = new DisplayElements();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    private final SimpleColorsOptions defaultColors = new SimpleColorsOptions();
    public Colors colors = new Colors();
    private static final int SOSA_REPORT = 0;
    private static final int TABLE_REPORT = 1;
    private static final int LINEAGE_REPORT = 2;
    private static final int AGNATIC_REPORT = 3;
    private static final int ONE_LINE = 0;
    private static final int ONE_EVT_PER_LINE = 1;
    private static final int SRC_NO = 0;
    private static final int SRC_TITLE_NO_TEXT = 1;
    private static final int SRC_TITLE_GEN_NO_TEXT = 2;
    private static final int SRC_TITLE_END_NO_TEXT = 3;
    private static final int SRC_TITLE_TEXT = 4;
    private static final int SRC_TITLE_TEXT_GEN = 5;
    private static final int SRC_TITLE_TEXT_END = 6;
    private static final int SRC_TITLE_GEN_TEXT_GEN = 7;
    private static final int SRC_TITLE_END_TEXT_END = 8;
    private static String format_one_line = "";
    private static String format_multi_lines = "";
    private static String source_title_color = "";
    private static String source_text_color = "";
    private static final String FG_SRC_TITLE_COLOR = "#009799";
    private static final String FG_SRC_TEXT_COLOR = "#777777";
    private static final SortedSet<Source> GLOBAL_SRC_LIST = new TreeSet<Source>();
    private static final Map<Source, List<String>> GLOBAL_SRC_NOTES = new TreeMap<Source, List<String>>();
    private static final String NOTE = ".:NOTE";
    private static final String DATATEXT = ".:DATA:TEXT";
    private static final String DATADATE = ".:DATA:DATE";
    private static final String PAGEREF = "PAGE";
    private boolean srcLinkSrc = false;
    private boolean srcLinkGenSrc = false;
    private boolean srcTitle = false;
    private boolean srcAtGen = false;
    private boolean srcAtEnd = false;
    private boolean srcTextAtEvent = false;
    private boolean srcTextAtGen = false;
    private boolean srcTextAtEnd = false;
    private boolean srcDisplay = false;
    private static final String EVENTS_DELIMITER = ", ";
    private static final String BITS_DELIMITER = "$#@";
    private static final String LOCAL_DELIMITER = "#localproperty#";
    private static boolean firstEventsDelimiter = true;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.main(indi) : null;
    }

    public Document start(Indi indi) {
        return indi != null ? this.main(indi) : null;
    }

    public Document main(Indi indi) {
        String textColor = ColorUtils.color2string(this.colors.fgText);
        String backColor = ColorUtils.color2string(this.colors.bgColor);
        source_title_color = ColorUtils.color2string(this.colors.srcTitleColor);
        source_text_color = ColorUtils.color2string(this.colors.srcTextColor);
        format_one_line = "font-style=italic,color=" + source_title_color;
        format_multi_lines = "margin-left=0px,font-style=italic,color=" + source_title_color;
        this.InitVariables();
        PrivacyPolicy policy = PrivacyPolicy.getDefault();
        if (this.display.startSosa.equals(BigInteger.ZERO)) {
            this.display.startSosa = BigInteger.ONE;
        }
        Recursion recursion = switch (this.formatOptions.reportType) {
            case 3 -> new Agnatic();
            case 0 -> new Sosa();
            case 2 -> new Lineage();
            case 1 -> new Table();
            default -> throw new IllegalArgumentException("no such report type");
        };
        String title = recursion.getTitle(indi);
        Document doc = this.formatOptions.common.createDocument(this.translate("name"), textColor, backColor);
        doc.startSection(title, 2);
        recursion.start(indi, policy, doc);
        return doc;
    }

    void InitVariables() {
        if (this.formatOptions.reportType == 1) {
            this.formatOptions.displayBullet = true;
            if (this.display.displaySource == 2) {
                this.display.displaySource = 3;
            }
            if (this.display.displaySource == 5) {
                this.display.displaySource = 6;
            }
            if (this.display.displaySource == 7) {
                this.display.displaySource = 8;
            }
        }
        this.srcLinkSrc = false;
        this.srcLinkGenSrc = false;
        this.srcTitle = false;
        this.srcAtGen = false;
        this.srcAtEnd = false;
        this.srcTextAtEvent = false;
        this.srcTextAtGen = false;
        this.srcTextAtEnd = false;
        this.srcDisplay = false;
        switch (this.display.displaySource) {
            case 0: {
                break;
            }
            case 1: {
                this.srcTitle = true;
                this.srcDisplay = true;
                break;
            }
            case 2: {
                this.srcLinkGenSrc = true;
                this.srcAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 4: {
                this.srcLinkGenSrc = true;
                this.srcTitle = true;
                this.srcTextAtEvent = true;
                this.srcDisplay = true;
                break;
            }
            case 5: {
                this.srcLinkGenSrc = true;
                this.srcTitle = true;
                this.srcTextAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 7: {
                this.srcLinkGenSrc = true;
                this.srcAtGen = true;
                this.srcTextAtGen = true;
                this.srcDisplay = true;
                break;
            }
            case 3: {
                this.srcLinkSrc = true;
                this.srcAtEnd = true;
                this.srcDisplay = true;
                break;
            }
            case 6: {
                this.srcLinkSrc = true;
                this.srcTitle = true;
                this.srcTextAtEnd = true;
                this.srcDisplay = true;
                break;
            }
            case 8: {
                this.srcLinkSrc = true;
                this.srcAtEnd = true;
                this.srcTextAtEnd = true;
                this.srcDisplay = true;
                break;
            }
        }
    }

    void writeEvents(Document doc, int gen, List<EventWrapper> events, boolean isIndented, String format) {
        Object indent = "";
        if (isIndented) {
            indent = "start-indent=" + (gen * 20 + 10) + "pt";
        }
        firstEventsDelimiter = true;
        if (this.formatOptions.reportFormat == 1 && this.formatOptions.displayBullet && this.formatOptions.reportType != 1) {
            doc.startList(format + EVENTS_DELIMITER + (String)indent);
        }
        for (EventWrapper event : events) {
            String description = event.description;
            List<Source> sources = event.sources;
            boolean noSrc = false;
            String preSrc = " ";
            if (sources == null || sources.isEmpty()) {
                noSrc = true;
            }
            if (this.display.prefixEvent) {
                preSrc = event.tag.isBlank() ? "" : " (" + event.tag + ") ";
            }
            this.writeStartNextItem(doc, this.formatOptions.reportFormat, this.formatOptions.displayBullet, !description.isEmpty(), (String)indent);
            this.writeDescription(doc, description);
            if (!noSrc && this.srcDisplay) {
                for (Source source : sources) {
                    String sId = source.getId();
                    if (this.srcTitle) {
                        if (!this.isValidText(source)) {
                            sId = "none";
                        }
                        this.writeStartNextParagraph(doc, this.formatOptions.reportFormat, (String)indent);
                        this.writeSourceWithEvent(doc, this.formatOptions.reportFormat, noSrc, this.display.prefixSource, preSrc + source.getTitle() + " (" + source.getId() + ")", gen, sId);
                    } else {
                        this.writeSourceWithEvent(doc, this.formatOptions.reportFormat, noSrc, " (" + this.display.prefixSource + preSrc + " " + source.getId() + ")", "", gen, sId);
                    }
                    if (!this.srcTextAtEvent || !this.isValidText(source) || event.property == null) continue;
                    this.writeSourceNotes(doc, source, format, event.property.getPath(true).toString());
                }
            }
            if (!noSrc || !this.srcDisplay || !this.display.displayEmpty) continue;
            if (this.formatOptions.displayBullet && description.length() == 0 && this.formatOptions.reportType != 1) {
                this.writeStartNextItem(doc, this.formatOptions.reportFormat, this.formatOptions.displayBullet, true, (String)indent);
            } else if (this.formatOptions.displayBullet) {
                this.writeStartNextParagraph(doc, this.formatOptions.reportFormat, "");
            } else {
                this.writeStartNextParagraph(doc, this.formatOptions.reportFormat, (String)indent);
            }
            this.writeSourceWithEvent(doc, this.formatOptions.reportFormat, noSrc, this.display.prefixSource, preSrc + this.translate("noSource"), 0, "");
        }
        if (this.formatOptions.reportFormat == 1 && this.formatOptions.displayBullet && this.formatOptions.reportType != 1) {
            doc.endList();
        }
    }

    void writeStartNextItem(Document doc, int format, boolean bullet, boolean isDescription, String style) {
        if (this.formatOptions.reportType == 1) {
            doc.nextTableCell();
            return;
        }
        if (!isDescription) {
            return;
        }
        if (format == 1) {
            if (bullet) {
                doc.nextListItem();
            } else {
                doc.nextParagraph(style);
            }
        } else if (firstEventsDelimiter) {
            firstEventsDelimiter = false;
            doc.addText("");
        } else {
            doc.addText(EVENTS_DELIMITER);
        }
    }

    void writeStartNextParagraph(Document doc, int format, String style) {
        if (format == 1) {
            doc.nextParagraph(style);
        } else if (firstEventsDelimiter) {
            firstEventsDelimiter = false;
            doc.addText("");
        } else {
            doc.addText(EVENTS_DELIMITER);
        }
    }

    void writeDescription(Document doc, String text) {
        if (!text.isEmpty()) {
            String end = text;
            int i = text.indexOf(BITS_DELIMITER);
            boolean normal = true;
            while (i != -1) {
                if (i != -1) {
                    normal = !normal;
                    String beg = end.substring(0, i);
                    end = end.substring(i + BITS_DELIMITER.length());
                    doc.addText(beg, normal ? "font-style=normal, color=#000000" : "font-weight=bold, font-style=normal, color=#000000");
                }
                i = end.indexOf(BITS_DELIMITER);
            }
            doc.addText(end, "font-style=normal, color=#000000");
        }
    }

    void writeSourceWithEvent(Document doc, int format, boolean noSrcFound, String linkToSourceText, String sourceTitle, int gen, String id) {
        String formatText = format == 1 ? format_multi_lines : format_one_line;
        if (noSrcFound) {
            doc.addText(linkToSourceText + sourceTitle, formatText);
            return;
        }
        if (this.srcTitle) {
            linkToSourceText = sourceTitle;
        }
        if (this.srcLinkSrc) {
            doc.addLink(linkToSourceText, "0-" + id, formatText);
        } else if (this.srcLinkGenSrc) {
            doc.addLink(linkToSourceText, gen + 1 + "-" + id, formatText);
        } else {
            doc.addText(linkToSourceText, formatText);
        }
    }

    boolean isValidText(Source source) {
        List<String> listOfNotes = GLOBAL_SRC_NOTES.get(source);
        return !listOfNotes.isEmpty();
    }

    boolean isAlreadyIn(List<String> listOfStr, String strNote) {
        return listOfStr.stream().anyMatch(str -> str.contains(strNote));
    }

    void writeSourceNotes(Document doc, Source source, String format, String tag) {
        List<String> listOfNotes = GLOBAL_SRC_NOTES.get(source);
        format = (String)format + ",margin-left=8px,font-style=italic,color=" + source_text_color;
        for (String strNote : listOfNotes) {
            if (this.srcTextAtEvent && !strNote.contains(LOCAL_DELIMITER + tag + LOCAL_DELIMITER)) continue;
            strNote = strNote.replaceAll("#localproperty#.*#localproperty#", "");
            doc.nextParagraph((String)format);
            int i = strNote.indexOf(BITS_DELIMITER);
            if (i != -1) {
                String end = strNote.substring(i + BITS_DELIMITER.length());
                doc.addText(end, "font-style=normal, color=" + source_text_color);
                continue;
            }
            doc.addText(strNote);
        }
    }

    void writeSourceList(Document doc, int gen, boolean isTitle, boolean isText) {
        if (GLOBAL_SRC_LIST.isEmpty()) {
            return;
        }
        ArrayList<String> noTextSources = new ArrayList<String>();
        String format = "space-after=6pt";
        if (this.formatOptions.reportType == 0) {
            if (gen == -1) {
                doc.nextPage();
            }
            doc.nextParagraph("margin-left=0px,text-decoration=underline,space-before=20pt");
            if (gen == -1) {
                doc.addText("________________________________________________");
                doc.nextParagraph();
            }
            doc.addText(this.translate("sourceList"));
            doc.nextParagraph();
        }
        if (this.formatOptions.reportType == 2 || this.formatOptions.reportType == 3 || this.formatOptions.reportType == 1) {
            doc.nextPage();
            doc.nextParagraph("space-before=10pt");
            doc.addText("________________________________________________");
            doc.nextParagraph("space-after=10pt,space-before=10pt,text-decoration=underline");
            doc.addText(this.translate("sourceList"));
            doc.nextParagraph(format);
        }
        for (Source source : GLOBAL_SRC_LIST) {
            String sId = source.getId();
            String sTitle = source.getTitle();
            if (isTitle || isText) {
                doc.nextParagraph(format);
                doc.addAnchor(gen + 1 + "-" + sId);
                doc.addText(sTitle + " (" + sId + ")", "color=" + source_title_color);
                if (!isText || !this.isValidText(source)) continue;
                this.writeSourceNotes(doc, source, format, "");
                continue;
            }
            noTextSources.add(sId);
        }
        if (!noTextSources.isEmpty()) {
            doc.nextParagraph("space-after=0pt");
            doc.addAnchor(gen + 1 + "-none");
            for (String n : noTextSources) {
                doc.addText("(" + n + ") ");
            }
            doc.nextParagraph(format);
            doc.addText(this.translate("noText"));
            doc.nextParagraph(format);
        }
        GLOBAL_SRC_LIST.clear();
        GLOBAL_SRC_NOTES.clear();
    }

    public class FormatOptions {
        public FormattingOptions common = new FormattingOptions();
        public int reportType = 0;
        public String[] reportTypes = new String[]{ReportSosa.this.translate("SosaReport"), ReportSosa.this.translate("TableReport"), ReportSosa.this.translate("LineageReport"), ReportSosa.this.translate("AgnaticReport")};
        public int reportFormat = 1;
        public String[] reportFormats = new String[]{ReportSosa.this.translate("IndiPerLine"), ReportSosa.this.translate("EventPerLine")};
        public boolean displayBullet = true;
    }

    public class DisplayElements {
        public BigInteger startSosa = BigInteger.ONE;
        public int privateGen = 0;
        public int reportMinGenerations = 1;
        public int reportMaxGenerations = 999;
        public int displaySource = 4;
        public String[] displaySources = new String[]{ReportSosa.this.translate("src_no"), ReportSosa.this.translate("src_title_no_text"), ReportSosa.this.translate("src_title_gen_no_text"), ReportSosa.this.translate("src_title_end_no_text"), ReportSosa.this.translate("src_title_text"), ReportSosa.this.translate("src_title_text_gen"), ReportSosa.this.translate("src_title_text_end"), ReportSosa.this.translate("src_title_gen_text_gen"), ReportSosa.this.translate("src_title_end_text_end")};
        public boolean displayEmpty = false;
        public boolean prefixEvent = false;
        public String prefixSource = "Src:";
    }

    public class MyDataFormatOptions {
        public boolean showEventName = true;
        public FormatIDOptions id = new FormatIDOptions();
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
    }

    public class Colors {
        public Color fgText;
        public Color srcTitleColor;
        public Color srcTextColor;
        public Color bgColor;

        public Colors() {
            this.fgText = ReportSosa.this.defaultColors.fgText;
            this.srcTitleColor = ColorUtils.string2color(ReportSosa.FG_SRC_TITLE_COLOR);
            this.srcTextColor = ColorUtils.string2color(ReportSosa.FG_SRC_TEXT_COLOR);
            this.bgColor = ReportSosa.this.defaultColors.bgColor;
        }
    }

    class Agnatic
    extends DepthFirst {
        Agnatic() {
        }

        @Override
        void recursion(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.display.reportMaxGenerations) {
                return;
            }
            this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.display.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : PrivacyPolicy.getDefault().getAllPublic(), doc);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            if (father != null) {
                this.recursion(father, famc, gen + 1, sosa.shiftLeft(1), policy, doc);
            }
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.agnatic", new Object[]{root.getReportName()});
        }

        @Override
        void formatStart(Indi indi, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.display.reportMinGenerations - 1) {
                return;
            }
            if (gen > 1 && fam != null && fam.getHusband() != indi) {
                return;
            }
            doc.nextParagraph("space-after=10pt,space-before=10pt,start-indent=" + gen * 20 + "pt");
            doc.addText(this.getName(indi, sosa, policy) + " ", "font-weight=bold");
            doc.nextParagraph("start-indent=" + (gen * 20 + 10) + "pt");
            List<EventWrapper> events = this.getEvents(indi, fam, policy, true, false);
            if (!events.isEmpty()) {
                ReportSosa.this.writeEvents(doc, gen, events, true, "");
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Sosa
    extends BreadthFirst {
        Sosa() {
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.sosa", new Object[]{root.getReportName()});
        }

        @Override
        void formatStart(Indi root, Document doc) {
        }

        @Override
        void formatGeneration(int gen, Document doc) {
            if (gen < ReportSosa.this.display.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("color=#ffffff");
            doc.addText(".");
            doc.nextParagraph("font-size=18pt,background-color=#f0f0f0,border-after-width=0.5pt");
            doc.addText(ReportSosa.this.translate("Generation") + " " + (gen + 1));
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.display.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("font-weight=bold, space-after=3pt,space-before=15pt");
            doc.addText(this.getName(indi, sosa, policy));
            List<EventWrapper> events = this.getEvents(indi, fam, policy, true, false);
            if (!events.isEmpty()) {
                doc.nextParagraph("margin-left=15px");
                ReportSosa.this.writeEvents(doc, gen, events, false, "margin-left=15px");
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Lineage
    extends DepthFirst {
        Lineage() {
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.lineage", new Object[]{root.getReportName()});
        }

        @Override
        void formatStart(Indi indi, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.display.reportMinGenerations - 1) {
                return;
            }
            doc.nextParagraph("space-after=10pt,space-before=10pt,start-indent=" + gen * 20 + "pt");
            doc.addText(this.getName(indi, sosa, policy) + " ", "font-weight=bold");
            doc.nextParagraph("start-indent=" + (gen * 20 + 10) + "pt");
            List<EventWrapper> events = this.getEvents(indi, fam, policy, true, false);
            if (!events.isEmpty()) {
                ReportSosa.this.writeEvents(doc, gen, events, true, "");
            }
        }

        @Override
        void formatEnd(Document doc) {
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    class Table
    extends BreadthFirst {
        String[] header;
        int[] widths;

        Table() {
            this.header = new String[]{"#", Gedcom.getReportName((String)"NAME"), Gedcom.getReportName((String)"BIRT"), Gedcom.getReportName((String)"BAPM"), Gedcom.getReportName((String)"MARR"), Gedcom.getReportName((String)"DEAT"), Gedcom.getReportName((String)"BURI"), Gedcom.getReportName((String)"OCCU"), Gedcom.getReportName((String)"RESI")};
            this.widths = new int[]{3, 22, 12, 10, 10, 10, 10, 10, 10};
        }

        @Override
        String getTitle(Indi root) {
            return ReportSosa.this.translate("title.sosa", new Object[]{root.getReportName()});
        }

        @Override
        void formatStart(Indi root, Document doc) {
            int i;
            doc.startTable("genj:csv=true, width=100%, border-style=none, border-color=black, border=0");
            for (i = 0; i < this.header.length; ++i) {
                doc.addTableColumn("column-width=" + this.widths[i] + "%");
            }
            doc.nextTableRow("background-color=#f0f0f0");
            for (i = 0; i < this.header.length; ++i) {
                if (i > 0) {
                    doc.nextTableCell("background-color=#f0f0f0");
                }
                doc.addText(this.header[i], "font-weight=bold");
            }
        }

        @Override
        void formatGeneration(int gen, Document doc) {
        }

        @Override
        void formatIndi(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen < ReportSosa.this.display.reportMinGenerations - 1) {
                return;
            }
            List<EventWrapper> events = this.getEvents(indi, fam, policy, false, true);
            HashMap<String, ArrayList<EventWrapper>> eventMap = new HashMap<String, ArrayList<EventWrapper>>();
            for (EventWrapper event : events) {
                ArrayList<EventWrapper> tagList = (ArrayList<EventWrapper>)eventMap.get(event.tag);
                if (tagList == null) {
                    tagList = new ArrayList<EventWrapper>();
                    eventMap.put(event.tag, tagList);
                }
                tagList.add(event);
            }
            events.clear();
            HashMap eventUsages = new HashMap();
            EventUsage.init(eventUsages);
            List birtList = (List)eventMap.get("BIRT");
            if (birtList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("BIRT")).getOrder());
                newEvent.tag = "BIRT";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(birtList));
            }
            List bapmList = (List)eventMap.get("BAPM");
            List chrList = (List)eventMap.get("CHR");
            if (bapmList == null && chrList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("BAPM")).getOrder());
                newEvent.tag = "BAPM";
                events.add(newEvent);
            } else {
                ArrayList<EventWrapper> bapmEvents = new ArrayList<EventWrapper>();
                if (bapmList != null) {
                    bapmEvents.addAll(bapmList);
                }
                if (chrList != null) {
                    bapmEvents.addAll(chrList);
                }
                events.add(this.mergeEvents(bapmEvents));
            }
            List marrList = (List)eventMap.get("MARR");
            if (marrList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("MARR")).getOrder());
                newEvent.tag = "MARR";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(marrList));
            }
            List deathList = (List)eventMap.get("DEAT");
            if (deathList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("DEAT")).getOrder());
                newEvent.tag = "DEAT";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(deathList));
            }
            List buriList = (List)eventMap.get("BURI");
            if (buriList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("BURI")).getOrder());
                newEvent.tag = "BURI";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(buriList));
            }
            List occuList = (List)eventMap.get("OCCU");
            if (occuList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("OCCU")).getOrder());
                newEvent.tag = "OCCU";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(occuList));
            }
            List resiList = (List)eventMap.get("RESI");
            if (resiList == null) {
                EventWrapper newEvent = new EventWrapper(null, "", null, ((EventUsage)eventUsages.get("RESI")).getOrder());
                newEvent.tag = "RESI";
                events.add(newEvent);
            } else {
                events.add(this.mergeEvents(resiList));
            }
            doc.nextTableRow();
            doc.addText("" + sosa);
            doc.nextTableCell();
            doc.addText(this.getName(indi, BigInteger.ZERO, policy));
            if (!events.isEmpty()) {
                ReportSosa.this.writeEvents(doc, gen, events, false, "margin-left=15px");
            }
        }

        private EventWrapper mergeEvents(List<EventWrapper> eventList) {
            EventWrapper result = eventList.get(0);
            for (EventWrapper event : eventList) {
                if (result.equals(event)) continue;
                result.description = result.description + ", $#@" + event.description;
            }
            return result;
        }

        @Override
        void formatEnd(Document doc) {
            doc.endTable();
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtEnd || ReportSosa.this.srcTextAtEnd)) {
                ReportSosa.this.writeSourceList(doc, -1, ReportSosa.this.srcAtEnd, ReportSosa.this.srcTextAtEnd);
            }
        }
    }

    abstract class Recursion {
        Recursion() {
        }

        abstract void start(Indi var1, PrivacyPolicy var2, Document var3);

        abstract String getTitle(Indi var1);

        abstract void formatStart(Indi var1, Document var2);

        abstract void formatIndi(Indi var1, Fam var2, int var3, BigInteger var4, PrivacyPolicy var5, Document var6);

        abstract void formatEnd(Document var1);

        String getProperty(Property prop, String prefix, boolean showDate, boolean showPlace, PrivacyPolicy policy) {
            Object value = prop.getValue().trim();
            Property pType = prop.getProperty("TYPE");
            if (pType != null && !pType.getValue().trim().isEmpty()) {
                if (!((String)value).isEmpty()) {
                    value = (String)value + " - ";
                }
                value = (String)value + pType.getValue().trim();
            }
            value = " " + (String)value;
            StringBuilder format = new StringBuilder();
            format.append(ReportSosa.this.dataFormatOptions.showEventName ? Gedcom.getReportName((String)prop.getTag()) : prefix);
            format.append(ReportSosa.BITS_DELIMITER);
            format.append((String)value);
            format.append(" ");
            format.append(showDate ? ReportSosa.this.dataFormatOptions.date.getDate(prop.getProperty("DATE")) : "");
            format.append(" ");
            format.append(showPlace ? ReportSosa.this.dataFormatOptions.place.getPlace(prop.getProperty("PLAC")) : "");
            return prop.format(format.toString(), policy, true, true).trim();
        }

        List<Source> getSources(Entity entity, String tagPath) {
            ArrayList<Source> src = new ArrayList<Source>();
            for (Property p : entity.getProperties(new TagPath(tagPath))) {
                String sNote;
                Property sProp;
                String sourceText;
                String sText;
                String pageRef;
                if (p == null || p.toString().trim().isEmpty() || !(p instanceof PropertySource) || !p.isValid()) continue;
                PropertySource propSrc = (PropertySource)p;
                Source source = (Source)propSrc.getTargetEntity().get();
                src.add(source);
                GLOBAL_SRC_LIST.add(source);
                List<String> listOfNotes = GLOBAL_SRC_NOTES.get(source);
                ArrayList<CallSite> listTmp = new ArrayList<CallSite>();
                if (listOfNotes == null) {
                    listOfNotes = new ArrayList<String>();
                    GLOBAL_SRC_NOTES.put(source, listOfNotes);
                }
                if (listOfNotes.contains(entity.getDisplayTitle())) continue;
                Property pageProp = propSrc.getProperty(ReportSosa.PAGEREF);
                String string = pageRef = pageProp != null ? pageProp.getValue() : "";
                if (!pageRef.isBlank()) {
                    listTmp.add((CallSite)((Object)("$#@#localproperty#" + propSrc.getParent().getPath(true).toString() + ReportSosa.LOCAL_DELIMITER + NbBundle.getMessage(this.getClass(), (String)"pageRef") + ": " + pageRef)));
                }
                if ((sText = source.getText()) != null && !sText.trim().isEmpty() && !listOfNotes.contains(sourceText = "$#@#localproperty#" + propSrc.getParent().getPath(true).toString() + "#localproperty# " + sText)) {
                    listTmp.add((CallSite)((Object)sourceText));
                }
                if ((sProp = source.getPropertyByPath(ReportSosa.NOTE)) != null && (sNote = sProp.getValue()) != null && !sNote.trim().isEmpty()) {
                    listTmp.add((CallSite)((Object)(ReportSosa.BITS_DELIMITER + NbBundle.getMessage(this.getClass(), (String)"noteEntity") + ": " + sNote)));
                }
                sNote = "";
                Property sProp2 = propSrc.getPropertyByPath(ReportSosa.NOTE);
                if (sProp2 != null) {
                    sNote = sProp2.getValue();
                }
                if (sNote != null && !sNote.trim().isEmpty() && !ReportSosa.this.isAlreadyIn(listOfNotes, sNote)) {
                    Object pName = "";
                    if (!ReportSosa.this.srcTextAtEvent) {
                        pName = " (" + propSrc.getParent().getPropertyName() + ")";
                    }
                    listTmp.add((CallSite)((Object)("$#@#localproperty#" + propSrc.getParent().getPath(true).toString() + ReportSosa.LOCAL_DELIMITER + NbBundle.getMessage(this.getClass(), (String)"noteCitation") + (String)pName + ": " + sNote)));
                }
                sNote = "";
                Object sDate = "";
                sProp2 = propSrc.getPropertyByPath(ReportSosa.DATATEXT);
                if (sProp2 != null) {
                    sNote = sProp2.getValue();
                }
                if ((sProp2 = propSrc.getPropertyByPath(ReportSosa.DATADATE)) != null && !sProp2.getValue().isEmpty()) {
                    sDate = " " + sProp2.getValue();
                }
                if (sNote != null && !sNote.trim().isEmpty() && !ReportSosa.this.isAlreadyIn(listOfNotes, sNote)) {
                    Object text = ((String)sDate).isEmpty() ? sNote : NbBundle.getMessage(this.getClass(), (String)"dataCitation") + (String)sDate + ": " + sNote;
                    Object pName = "";
                    if (!ReportSosa.this.srcTextAtEvent) {
                        pName = "(" + propSrc.getParent().getPropertyName() + ")";
                    }
                    listTmp.add((CallSite)((Object)("$#@#localproperty#" + propSrc.getParent().getPath(true).toString() + ReportSosa.LOCAL_DELIMITER + (String)pName + " " + (String)text)));
                }
                if (listTmp.isEmpty()) continue;
                if (ReportSosa.this.srcTextAtGen || ReportSosa.this.srcTextAtEnd) {
                    listOfNotes.add(entity.getDisplayTitle());
                }
                listOfNotes.addAll(listTmp);
            }
            return src;
        }

        String getName(Indi indi, BigInteger sosa, PrivacyPolicy privacy) {
            Object id = ReportSosa.this.dataFormatOptions.id.getId(indi);
            if (!((String)id).isBlank()) {
                id = " (" + (String)id + ")";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(privacy.getReportValue((Property)indi, "NAME"));
            sb.append((String)id);
            sb.append((String)(sosa.compareTo(BigInteger.ZERO) > 0 ? " - " + sosa : ""));
            return sb.toString();
        }

        protected List<EventWrapper> getEvents(Indi indi, Fam fams, PrivacyPolicy privacy, boolean usePrefixes, boolean returnEmpties) {
            Fam[] families;
            String description;
            List<Source> sources;
            ArrayList<EventWrapper> ret = new ArrayList<EventWrapper>();
            HashMap eventUsages = new HashMap();
            EventUsage.init(eventUsages);
            if (ReportSosa.this.srcDisplay) {
                sources = this.getSources((Entity)indi, "INDI:SOUR");
                if (ReportSosa.this.display.displayEmpty || !sources.isEmpty()) {
                    ret.add(new EventWrapper(null, "", sources, 0));
                }
            }
            for (String tag : EventUsage.getTags(eventUsages, (String)"INDI")) {
                Property[] eventProps;
                for (Property property : eventProps = indi.getProperties(tag, false)) {
                    description = this.getProperty(property, usePrefixes ? this.getSymbol(tag, "") : "", true, true, privacy);
                    if (ReportSosa.this.srcDisplay) {
                        String path = property.getPath(true).toString();
                        sources = this.getSources((Entity)indi, path + ":SOUR");
                    } else {
                        sources = null;
                    }
                    ret.add(new EventWrapper(property, description, sources, ((EventUsage)eventUsages.get(tag)).getOrder()));
                }
            }
            for (Fam fam : families = indi.getFamiliesWhereSpouse()) {
                for (String string : EventUsage.getTags(eventUsages, (String)"FAM")) {
                    Property[] eventProps;
                    for (Property prop : eventProps = fam.getProperties(string)) {
                        String spouseName = "";
                        description = this.getProperty(prop, usePrefixes ? this.getSymbol(string, "MARR") : "", true, true, privacy);
                        Indi otherSpouse = fam.getOtherSpouse(indi);
                        if (otherSpouse != null) {
                            spouseName = privacy.getReportValue((Property)otherSpouse);
                        }
                        String prefix = (String)(usePrefixes ? this.getSymbol(string, "MARR") + " " : "") + spouseName;
                        if (ReportSosa.this.srcDisplay) {
                            String path = prop.getPath(true).toString();
                            sources = this.getSources((Entity)fam, path + ":SOUR");
                        } else {
                            sources = null;
                        }
                        ret.add(new EventWrapper(prop, description + " " + prefix, sources, ((EventUsage)eventUsages.get(string)).getOrder()));
                    }
                }
            }
            ret.sort((e1, e2) -> e1.compareTo((EventWrapper)e2));
            return ret;
        }

        private String getSymbol(String tag, String altTag) {
            altTag = altTag.isEmpty() ? "-" : TextOptions.getInstance().getSymbol(altTag, "");
            return TextOptions.getInstance().getSymbol(tag, altTag);
        }
    }

    protected class EventWrapper {
        public Integer julianday = 0;
        public Integer order = 0;
        public Property property = null;
        public String tag = "";
        public String description = "";
        List<Source> sources = null;

        public EventWrapper(Property property, String description, List<Source> sources, int order) {
            this.property = property;
            if (property != null) {
                this.tag = property.getTag();
                try {
                    this.julianday = ((PropertyDate)property.getProperty("DATE")).getStart().getJulianDay();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (description == null) {
                description = "";
            }
            this.description = description;
            this.sources = sources;
            this.order = order;
        }

        private int compareTo(EventWrapper e2) {
            int ret = this.julianday.compareTo(e2.julianday);
            if (ret == 0) {
                return this.order.compareTo(e2.order);
            }
            return ret;
        }
    }

    abstract class BreadthFirst
    extends Recursion {
        BreadthFirst() {
        }

        @Override
        void start(Indi indi, PrivacyPolicy policy, Document doc) {
            this.formatStart(indi, doc);
            ArrayList<Object> list = new ArrayList<Object>(3);
            list.add(ReportSosa.this.display.startSosa);
            list.add(indi);
            list.add(null);
            this.recursion(list, 0, policy, doc);
            this.formatEnd(doc);
        }

        void recursion(List<Object> generation, int gen, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.display.reportMaxGenerations) {
                return;
            }
            this.formatGeneration(gen, doc);
            ArrayList<Object> nextGeneration = new ArrayList<Object>();
            int i = 0;
            while (i < generation.size()) {
                BigInteger sosa = (BigInteger)generation.get(i++);
                Indi indi = (Indi)generation.get(i++);
                Fam fam = (Fam)generation.get(i++);
                Fam famc = indi.getFamilyWhereBiologicalChild();
                if (famc != null) {
                    Indi mother;
                    Indi father = famc.getHusband();
                    if (father != null) {
                        nextGeneration.add(sosa.shiftLeft(1));
                        nextGeneration.add(father);
                        nextGeneration.add(famc);
                    }
                    if ((mother = famc.getWife()) != null) {
                        nextGeneration.add(sosa.shiftLeft(1).add(BigInteger.ONE));
                        nextGeneration.add(mother);
                        nextGeneration.add(famc);
                    }
                }
                this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.display.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : PrivacyPolicy.getDefault().getAllPublic(), doc);
                if (!ReportSosa.this.srcTextAtEvent) continue;
                GLOBAL_SRC_LIST.clear();
                GLOBAL_SRC_NOTES.clear();
            }
            if (ReportSosa.this.srcDisplay && (ReportSosa.this.srcAtGen || ReportSosa.this.srcTextAtGen)) {
                if (gen >= ReportSosa.this.display.reportMinGenerations - 1) {
                    ReportSosa.this.writeSourceList(doc, gen, ReportSosa.this.srcAtGen, ReportSosa.this.srcTextAtGen);
                } else {
                    GLOBAL_SRC_LIST.clear();
                }
            }
            if (!nextGeneration.isEmpty()) {
                this.recursion(nextGeneration, gen + 1, policy, doc);
            }
        }

        abstract void formatGeneration(int var1, Document var2);
    }

    abstract class DepthFirst
    extends Recursion {
        DepthFirst() {
        }

        @Override
        void start(Indi indi, PrivacyPolicy policy, Document doc) {
            this.formatStart(indi, doc);
            this.recursion(indi, null, 0, ReportSosa.this.display.startSosa, policy, doc);
            this.formatEnd(doc);
        }

        void recursion(Indi indi, Fam fam, int gen, BigInteger sosa, PrivacyPolicy policy, Document doc) {
            if (gen > ReportSosa.this.display.reportMaxGenerations) {
                return;
            }
            this.formatIndi(indi, fam, gen, sosa, gen < ReportSosa.this.display.privateGen ? PrivacyPolicy.getDefault().getAllPrivate() : PrivacyPolicy.getDefault().getAllPublic(), doc);
            Fam famc = indi.getFamilyWhereBiologicalChild();
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            Indi mother = famc.getWife();
            if (father == null && mother == null) {
                return;
            }
            if (father != null) {
                this.recursion(father, famc, gen + 1, sosa.shiftLeft(1), policy, doc);
            }
            if (mother != null) {
                this.recursion(mother, famc, gen + 1, sosa.shiftLeft(1).add(BigInteger.ONE), policy, doc);
            }
        }
    }
}

