/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.gedart;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GedartResources {
    private static final Logger LOG = Logger.getLogger("ancestris.util");
    private static final String DEFAULT_LANG = Locale.getDefault().getLanguage();
    private static final String BUNDLE_NAME = "Bundle";
    private static final String BUNDLE_EXTENSION = ".properties";
    private ResourceBundle defaultResource;
    private ResourceBundle localizedResource;

    public GedartResources(String path, String lang) {
        String langue = lang != null ? lang : DEFAULT_LANG;
        try (FileInputStream fisDefault = new FileInputStream(new File(path + "/Bundle.properties"));){
            this.defaultResource = new PropertyResourceBundle(fisDefault);
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "Unable to find resources.", e);
            this.defaultResource = null;
        }
        try (FileInputStream fisLocalized = new FileInputStream(new File(path + "/Bundle_" + langue + BUNDLE_EXTENSION));){
            this.localizedResource = new PropertyResourceBundle(fisLocalized);
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "Unable to find resources.", e);
            this.localizedResource = null;
        }
    }

    public final String translate(String key) {
        return this.translate(key, null);
    }

    public final String translate(String key, int value) {
        return this.translate(key, (Object)value);
    }

    public final String translate(String key, Object value) {
        return this.translate(key, new Object[]{value});
    }

    public String translate(String key, Object[] values) {
        return this.translate(key, values, true);
    }

    public String translate(String key, Object[] values, boolean notnull) {
        if (this.defaultResource == null && this.localizedResource == null) {
            return notnull ? key : "";
        }
        String result = null;
        if (this.localizedResource != null && this.localizedResource.containsKey(key)) {
            result = this.localizedResource.getString(key);
        }
        if (result == null && this.defaultResource != null && this.defaultResource.containsKey(key)) {
            result = this.defaultResource.getString(key);
        }
        if (result != null) {
            result = MessageFormat.format(result, values);
        }
        if (result == null && notnull) {
            result = key;
        }
        return result;
    }
}

