/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.util.Registry;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class ScopeOptions {
    public static final int SCOPE_GEDCOM = 0;
    public static final int SCOPE_CURRENT = 1;
    public static final int SCOPE_DESCENDANTS = 2;
    public static final int SCOPE_ASCENDANTS = 3;
    public static final int SCOPE_TREE = 4;
    public static final int SCOPE_RELATIVES = 5;
    public static final int SCOPE_CONTEMPORARIES = 6;
    public static final int SCOPE_SEARCH = 7;
    public static final int SCOPE_ALIVE = 8;
    public static final int CHOSEN_INDI_CURRENT = 0;
    public static final int CHOSEN_INDI_ON_DEMAND = 1;
    public static final int CHOSEN_INDI_FIXED = 2;
    protected Gedcom gedcom = null;
    private int scope = 0;
    private Entity rootEntity = null;
    private int year = 0;
    private final String[] scopes = new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"scope.allGedcom"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.current"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.descendants"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.ascendants"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.tree"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.relatives"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.contemporaries"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.search"), NbBundle.getMessage(ScopeOptions.class, (String)"scope.aliveInGivenYear")};
    private final boolean[] hasReference = new boolean[]{false, true, true, true, true, true, true, false, false};
    private final String[] references = new String[]{NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.current"), NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.on_demand"), NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.fixed")};

    public String[] getScopes() {
        return this.scopes;
    }

    public boolean hasReference() {
        return this.hasReference[this.scope];
    }

    public String[] getReferences() {
        return this.references;
    }

    public boolean isLimited() {
        return this.scope != 0;
    }

    protected void setRootEntity(Entity entity) {
        this.rootEntity = entity;
    }

    public Entity getRootEntity() {
        return this.rootEntity;
    }

    protected void setScope(int scope) {
        this.scope = scope;
    }

    protected void setYear(int year) {
        this.year = year;
    }

    protected Object setRootEntity(Object context, String entityTag, Report report, int chosenIndi, int scopeType, int livingInYear) {
        if (context == null) {
            return null;
        }
        Entity entity = null;
        if (context instanceof Gedcom) {
            this.gedcom = (Gedcom)context;
        } else if (context instanceof Entity) {
            entity = (Entity)context;
            this.gedcom = entity.getGedcom();
        }
        if (this.gedcom == null) {
            return null;
        }
        if (entity != null && !this.hasReference()) {
            scopeType = 1;
        }
        if (entity != null && this.hasReference()) {
            chosenIndi = 0;
        }
        this.setScope(scopeType);
        this.setYear(livingInYear);
        if (scopeType == 0) {
            return new ArrayList(this.gedcom.getEntities(entityTag));
        }
        if (entity == null && this.hasReference()) {
            entity = this.getEntity(entityTag, report, chosenIndi);
        }
        this.setRootEntity(entity);
        return true;
    }

    protected Object setRootEntity(Object context, String entityTag, Report report, int chosenIndi) {
        Entity entity;
        if (context instanceof Gedcom) {
            this.gedcom = (Gedcom)context;
        } else if (context instanceof Entity) {
            entity = (Entity)context;
            this.gedcom = entity.getGedcom();
            chosenIndi = 0;
        }
        if (this.gedcom == null) {
            return null;
        }
        entity = this.getEntity(entityTag, report, chosenIndi);
        if (entity == null) {
            return null;
        }
        this.setRootEntity(entity);
        return true;
    }

    private Entity getEntity(String entityTag, Report report, int chosenIndi) {
        Entity entity = null;
        Registry registry = this.gedcom.getRegistry();
        String key = report.getClass().getName() + ".chosen.entity";
        String id = registry.get(key, "");
        switch (chosenIndi) {
            case 0: {
                entity = report.getActiveEntity(this.gedcom);
                if (!(entity instanceof Indi) && !(entity instanceof Fam) && (entity = report.getEntityFromUser(NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.current.msg"), this.gedcom, entityTag, report.getActiveEntity(this.gedcom))) == null) {
                    return null;
                }
                registry.put(key, "");
                break;
            }
            case 1: {
                entity = report.getEntityFromUser(NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.on_demand.msg"), this.gedcom, entityTag, report.getActiveEntity(this.gedcom));
                if (entity == null) {
                    return null;
                }
                registry.put(key, "");
                break;
            }
            case 2: {
                if (!id.isEmpty()) {
                    entity = this.gedcom.getEntity(id);
                }
                if (entity != null) break;
                entity = report.getEntityFromUser(NbBundle.getMessage(ScopeOptions.class, (String)"chosen.indi.fixed.msg"), this.gedcom, entityTag, report.getActiveEntity(this.gedcom));
                if (entity == null) {
                    return null;
                }
                registry.put(key, entity.getId());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return entity;
    }

    public String getMainMessage() {
        return NbBundle.getMessage(ScopeOptions.class, (String)"scope.mainMsg");
    }

    public List<String[]> getMessages() {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        String msg = "";
        switch (this.scope) {
            case 0: {
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                msg = this.rootEntity.getDisplayTitle(true);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                msg = String.valueOf(this.year);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                msg = this.rootEntity.getDisplayTitle(true);
                break;
            }
            default: {
                msg = "";
            }
        }
        ret.add(new String[]{this.scopes[this.scope], msg});
        return ret;
    }

    protected boolean areContemporaries(Entity entity, Indi refIndi) {
        if (entity instanceof Indi) {
            Indi indi = (Indi)entity;
            return this.areContemporaries(indi, refIndi);
        }
        if (entity instanceof Fam) {
            Fam fam = (Fam)entity;
            boolean areContemporariesHusb = false;
            Indi husb = fam.getHusband();
            if (husb != null) {
                areContemporariesHusb = this.areContemporaries(husb, refIndi);
            }
            boolean areContemporariesWife = false;
            Indi wife = fam.getWife();
            if (wife != null) {
                areContemporariesWife = this.areContemporaries(wife, refIndi);
            }
            return areContemporariesHusb || areContemporariesWife;
        }
        return false;
    }

    private boolean areContemporaries(Indi indi1, Indi indi2) {
        LifeSpan lifeSpan1 = new LifeSpan(indi1);
        LifeSpan lifeSpan2 = new LifeSpan(indi2);
        return lifeSpan1.yearStart <= lifeSpan2.yearStart && lifeSpan1.yearEnd >= lifeSpan2.yearStart || lifeSpan2.yearStart <= lifeSpan1.yearStart && lifeSpan2.yearEnd >= lifeSpan1.yearStart;
    }

    protected boolean isAliveIn(Entity entity, int livingInYear) {
        if (entity instanceof Indi) {
            Indi indi = (Indi)entity;
            return this.isAliveIn(indi, livingInYear);
        }
        if (entity instanceof Fam) {
            Fam fam = (Fam)entity;
            boolean aliveHusb = false;
            Indi husb = fam.getHusband();
            if (husb != null) {
                aliveHusb = this.isAliveIn(husb, livingInYear);
            }
            boolean aliveWife = false;
            Indi wife = fam.getWife();
            if (wife != null) {
                aliveWife = this.isAliveIn(wife, livingInYear);
            }
            return aliveHusb || aliveWife;
        }
        return false;
    }

    private boolean isAliveIn(Indi indi, int livingInYear) {
        LifeSpan lifeSpan = new LifeSpan(indi);
        return lifeSpan.yearStart <= livingInYear && livingInYear <= lifeSpan.yearEnd;
    }

    protected int getGenCount(Indi descendant, Indi ancestor) {
        if (descendant == null) {
            return 0;
        }
        List lines = ancestor.getAncestorLinesWith(descendant);
        int minGen = Integer.MAX_VALUE;
        for (List line : lines) {
            if (line.size() >= minGen) continue;
            minGen = line.size();
        }
        return minGen;
    }

    private class LifeSpan {
        int yearStart = Integer.MAX_VALUE;
        int yearEnd = Integer.MIN_VALUE;
        int defaultLifeSpan = GedcomOptions.getInstance().getYearsIndiCanBeAlive();

        public LifeSpan(Indi indi) {
            PropertyDate deat;
            PropertyDate birt = indi.getBirthDateOption();
            if (birt != null) {
                try {
                    this.yearStart = birt.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if ((deat = indi.getDeathDateOption()) != null) {
                try {
                    this.yearEnd = deat.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (deat.isRange()) {
                    try {
                        this.yearEnd = deat.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN).getYear();
                    }
                    catch (GedcomException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            if (this.yearStart == Integer.MAX_VALUE && this.yearEnd != Integer.MIN_VALUE) {
                this.yearStart = this.yearEnd - this.defaultLifeSpan;
            }
            if (this.yearEnd == Integer.MIN_VALUE && this.yearStart != Integer.MAX_VALUE) {
                this.yearEnd = this.yearStart + this.defaultLifeSpan;
            }
        }
    }
}

