/*
 * Decompiled with CFR 0.152.
 */
package genj.edit;

import ancestris.api.editor.Editor;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.beans.ConfirmChangeWidget;
import ancestris.core.resources.Images;
import ancestris.swing.ToolBar;
import ancestris.view.SelectionDispatcher;
import genj.edit.AdvancedEditor;
import genj.edit.TitlePanel;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.util.Registry;
import genj.util.Resources;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeListener;

public class EditView
extends View
implements ConfirmChangeWidget.ConfirmChangeCallBack {
    private static final Logger LOG = Logger.getLogger("ancestris.edit");
    private static final Registry REGISTRY = Registry.get(EditView.class);
    static final Resources RESOURCES = Resources.get(EditView.class);
    private final Mode mode = new Mode();
    private final Sticky sticky = new Sticky();
    private final Focus focus = new Focus();
    private final Callback callback = new Callback();
    private boolean isIgnoreSetContext = false;
    private boolean isChangeSource = false;
    private Editor editor;
    private final ConfirmChangeWidget confirmPanel = new ConfirmChangeWidget((ConfirmChangeWidget.ConfirmChangeCallBack)this);
    private ToolBar toolbar;
    private Gedcom gedcom;
    private TitlePanel titlePanel;

    public EditView() {
        super((LayoutManager)new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add("South", (Component)this.confirmPanel);
        this.mode.setSelected(true);
        this.focus.setSelected(REGISTRY.get("focus", false));
        this.setPrintableArea((JComponent)((Object)this));
    }

    private void setEditor(Editor set) {
        ViewContext old = null;
        if (set != null) {
            old = this.editor != null ? this.editor.getContext() : null;
            this.commit();
        }
        if (this.editor != null) {
            this.editor.removeChangeListener((ChangeListener)this.confirmPanel);
            this.editor.setContext(new Context());
            this.remove((Component)this.editor);
            this.editor.getExplorerHelper().setPopupAllowed(false);
            this.editor = null;
        }
        this.editor = set;
        if (this.editor != null) {
            this.add((Component)this.editor, "Center");
            this.setExplorerHelper(this.editor.getExplorerHelper());
            if (old != null) {
                this.editor.setContext((Context)old);
            }
            this.editor.addChangeListener((ChangeListener)this.confirmPanel);
            this.editor.getExplorerHelper().setPopupAllowed(true);
        }
        this.revalidate();
        this.repaint();
    }

    boolean isGrabFocus() {
        return this.focus.isSelected();
    }

    private ViewContext getContext() {
        return this.editor != null ? this.editor.getContext() : null;
    }

    public void commit() {
        this.commit(true);
    }

    public void commit(boolean ask) {
        if (!this.confirmPanel.hasChanged()) {
            return;
        }
        if (this.getTopLevelAncestor() == null || !this.getTopLevelAncestor().isVisible()) {
            return;
        }
        if (ask && !this.confirmPanel.isCommitChanges()) {
            this.confirmPanel.setChanged(false);
            return;
        }
        try {
            this.isChangeSource = true;
            this.isIgnoreSetContext = true;
            if (this.gedcom.isWriteLocked()) {
                this.editor.commit();
            } else {
                this.gedcom.doUnitOfWork(gedcom1 -> this.editor.commit());
            }
        }
        catch (GedcomException t) {
            LOG.log(Level.WARNING, "error committing editor", t);
        }
        finally {
            this.isChangeSource = false;
            this.isIgnoreSetContext = false;
            this.confirmPanel.setChanged(false);
        }
    }

    public void setContext(Context context) {
        if (this.isIgnoreSetContext) {
            return;
        }
        if (context.getGedcom() != this.gedcom && this.gedcom != null) {
            this.gedcom.removeGedcomListener((GedcomListener)this.callback);
            this.gedcom = null;
        }
        if (context.getGedcom() == null) {
            this.sticky.setSelected(false);
            this.setEditor(null);
            this.populate(this.toolbar);
            this.confirmPanel.setChanged(false);
            return;
        }
        if (context.getGedcom() != this.gedcom) {
            this.gedcom = context.getGedcom();
            this.gedcom.addGedcomListener((GedcomListener)this.callback);
        }
        this.commit();
        if (context.getEntities().size() > 0) {
            if (this.editor == null) {
                this.sticky.setSelected(false);
                this.setEditor(new AdvancedEditor(context.getGedcom(), this));
            }
            if (!this.sticky.isSelected()) {
                if (context.getEntities().size() == 1) {
                    this.editor.setContext(context);
                } else {
                    this.editor.setContext(new Context((Entity)context.getEntities().get(0)));
                }
            }
        } else if (this.editor != null) {
            this.editor.setContext(new Context(context.getGedcom()));
        }
        this.confirmPanel.setChanged(false);
        this.populate(this.toolbar);
    }

    public void populate(ToolBar toolbar) {
        this.toolbar = toolbar;
        if (toolbar == null) {
            return;
        }
        toolbar.beginUpdate();
        if (this.editor != null) {
            for (Action a : this.editor.getActions()) {
                toolbar.add(a);
            }
            if (!this.editor.getActions().isEmpty()) {
                toolbar.addSeparator();
            }
        }
        toolbar.add((JComponent)new JToggleButton((Action)((Object)this.sticky)));
        toolbar.add((JComponent)new JToggleButton((Action)((Object)this.focus)));
        toolbar.addSeparator();
        this.titlePanel = new TitlePanel();
        toolbar.addPropertyChangeListener(evt -> {
            if ("orientation".equals(evt.getPropertyName())) {
                this.setTitleBar();
            }
        });
        if (this.editor != null) {
            this.editor.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    EditView.this.setTitleBar();
                }
            });
        }
        toolbar.add((JComponent)this.titlePanel);
        this.setTitleBar();
        toolbar.endUpdate();
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 480);
    }

    public void setTitleBar() {
        if (this.toolbar.getOrientation() == 0) {
            Entity ent = this.getEntity();
            if (ent == null) {
                return;
            }
            this.titlePanel.setTitle("<html>" + ent.getDisplayTitle() + "</html>");
            this.titlePanel.setPreferredSize(new Dimension(Math.max(this.editor.getSize().width, 2000), 17));
            this.titlePanel.setVisible(true);
        } else {
            this.titlePanel.setTitle(" ");
            this.titlePanel.setPreferredSize(new Dimension(10, 0));
            this.titlePanel.setVisible(false);
        }
    }

    public Entity getEntity() {
        if (this.editor != null && this.editor.getContext() != null) {
            return this.editor.getContext().getEntity();
        }
        return null;
    }

    public void okCallBack(ActionEvent event) {
        this.commit(false);
    }

    public void cancelCallBack(ActionEvent event) {
        ViewContext ctx = this.editor.getContext();
        this.editor.setContext(new Context());
        this.editor.setContext((Context)ctx);
        this.populate(this.toolbar);
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    private class Mode
    extends AbstractAncestrisAction {
        private Mode() {
            this.setImage((Icon)Images.imgView);
            this.setTip(RESOURCES.getString("action.mode"));
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean selected) {
            REGISTRY.put("advanced", Boolean.valueOf(selected));
            if (EditView.this.getContext() != null) {
                EditView.this.setEditor(new AdvancedEditor(EditView.this.getContext().getGedcom(), EditView.this));
            }
            EditView.this.populate(EditView.this.toolbar);
            return super.setSelected(selected);
        }
    }

    private static class Sticky
    extends AbstractAncestrisAction {
        protected Sticky() {
            super.setImage((Icon)Images.imgStickOff);
            super.setTip(RESOURCES.getString("action.stick.tip"));
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.isSelected());
        }

        public boolean setSelected(boolean selected) {
            super.setImage((Icon)(selected ? Images.imgStickOn : Images.imgStickOff));
            return super.setSelected(selected);
        }
    }

    private static class Focus
    extends AbstractAncestrisAction {
        protected Focus() {
            super.setImage((Icon)Images.imgFocus);
            super.setTip(RESOURCES.getString("action.focus.tip"));
            super.setSelected(false);
        }

        public void actionPerformed(ActionEvent event) {
            this.setSelected(this.isSelected());
            REGISTRY.put("focus", Boolean.valueOf(this.isSelected()));
        }
    }

    private class Callback
    extends GedcomListenerAdapter {
        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            if (!EditView.this.isChangeSource) {
                EditView.this.commit(false);
            }
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (EditView.this.editor != null && !EditView.this.isChangeSource) {
                ViewContext ctx = EditView.this.editor.getContext();
                SelectionDispatcher.fireSelection((Context)ctx);
                EditView.this.populate(EditView.this.toolbar);
            }
        }
    }
}

