/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.PropertyChild;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.openide.util.NbBundle;

public class FamiliesTreeTableModel
extends AbstractTreeTableModel {
    public static int FAMILY_CHILD = 1;
    public static int FAMILY_SPOUSE = 2;
    private int mFamilyTableType = FAMILY_CHILD;
    private static String[] familyChildColumnsName = new String[]{NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familyChild.column.ID.title"), NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familyChild.column.husband.title"), NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familyChild.column.wife.title"), NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familyChild.column.date.title")};
    private static String[] familySpouseColumnsName = new String[]{NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familySpouse.column.ID.title"), NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familySpouse.column.husband.title"), NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familySpouse.column.wife.title"), NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familySpouse.column.date.title")};
    private String[] familyColumnsName = familyChildColumnsName;
    private String mFemale = "";
    private String mMale = "";

    public FamiliesTreeTableModel() {
        this(FAMILY_CHILD);
    }

    public FamiliesTreeTableModel(int familyType) {
        super((Object)new DefaultMutableTreeNode());
        this.mFamilyTableType = familyType;
        if (this.mFamilyTableType == FAMILY_CHILD) {
            this.familyColumnsName = familyChildColumnsName;
            this.mFemale = NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familyChild.female.title");
            this.mMale = NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familyChild.male.title");
        } else if (this.mFamilyTableType == FAMILY_SPOUSE) {
            this.familyColumnsName = familySpouseColumnsName;
            this.mFemale = NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familySpouse.female.title");
            this.mMale = NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.familySpouse.male.title");
        }
    }

    public int getColumnCount() {
        return this.familyColumnsName.length;
    }

    public String getColumnName(int column) {
        if (column < this.familyColumnsName.length) {
            return this.familyColumnsName[column];
        }
        return "";
    }

    public Object getValueAt(Object object, int index) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)object;
            if (dataNode.getUserObject() instanceof Fam) {
                Fam family = (Fam)dataNode.getUserObject();
                switch (index) {
                    case 0: {
                        return family.getId();
                    }
                    case 1: {
                        return family.getHusband() != null ? family.getHusband().getName() : "";
                    }
                    case 2: {
                        return family.getWife() != null ? family.getWife().getName() : "";
                    }
                    case 3: {
                        return family.getMarriageDate() != null ? NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.family.wedding") + " " + family.getMarriageDate().getDisplayValue() : "";
                    }
                }
                return "";
            }
            if (dataNode.getUserObject() instanceof PropertyChild && ((PropertyChild)dataNode.getUserObject()).isValid()) {
                Indi child = ((PropertyChild)dataNode.getUserObject()).getChild();
                switch (index) {
                    case 0: {
                        switch (child.getSex()) {
                            case 1: {
                                return this.mMale + " (" + child.getId() + ")";
                            }
                            case 2: {
                                return this.mFemale + " (" + child.getId() + ")";
                            }
                        }
                        return child.getId();
                    }
                    case 1: {
                        return child.getFirstName();
                    }
                    case 2: {
                        return child.getLastName();
                    }
                    case 3: {
                        return child.getBirthDate() != null ? NbBundle.getMessage(FamiliesTreeTableModel.class, (String)"FamiliesTreeTableModel.child.birth") + " " + child.getBirthDate().getDisplayValue() : "";
                    }
                }
                return "";
            }
            return "";
        }
        return object.getClass().getCanonicalName();
    }

    public Object getChild(Object object, int index) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode nodes = (DefaultMutableTreeNode)object;
            return nodes.getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode nodes = (DefaultMutableTreeNode)object;
            return nodes.getChildCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object o, Object o1) {
        return 0;
    }

    public void add(Fam family) {
        DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(family);
        for (PropertyChild childRef : family.getProperties(PropertyChild.class)) {
            familyNode.add(new DefaultMutableTreeNode(childRef));
        }
        ((DefaultMutableTreeNode)this.getRoot()).add(familyNode);
        this.modelSupport.fireNewRoot();
    }

    public void addAll(List<Fam> familiesList) {
        for (Fam family : familiesList) {
            DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(family);
            for (PropertyChild childRef : family.getProperties(PropertyChild.class)) {
                familyNode.add(new DefaultMutableTreeNode(childRef));
            }
            ((DefaultMutableTreeNode)this.getRoot()).add(familyNode);
        }
        this.modelSupport.fireNewRoot();
    }

    public void remove(DefaultMutableTreeNode dataNode) {
        TreeNode parent = dataNode.getParent();
        if (parent instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)parent).remove(dataNode);
        }
        this.modelSupport.fireNewRoot();
    }

    public void clear() {
        Object localRoot = this.getRoot();
        if (localRoot instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)localRoot).removeAllChildren();
        }
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }
}

