/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.view.ViewContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openide.util.NbBundle;

public class TestFamilyClone
extends Test {
    private final Set<Fam> reportedFams = new HashSet<Fam>();

    public TestFamilyClone() {
        super("FAM", Property.class);
    }

    @Override
    void test(Property prop, TagPath path, List<ViewContext> issues, GedcomValidate report) {
        Fam fam = (Fam)prop;
        if (this.reportedFams.contains(fam)) {
            return;
        }
        Indi husband = fam.getHusband();
        Indi wife = fam.getWife();
        if (husband != null) {
            this.test(fam, husband.getFamiliesWhereSpouse(), issues);
        } else if (wife != null) {
            this.test(fam, wife.getFamiliesWhereSpouse(), issues);
        }
    }

    private void test(Fam fam, Fam[] others, List<ViewContext> issues) {
        for (Fam other : others) {
            if (fam == other || !this.isClone(fam, other)) continue;
            if (!this.reportedFams.contains(fam)) {
                issues.add(new ViewContext((Entity)fam).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"warn.fam.cloned", (Object)fam.getId())));
                this.reportedFams.add(fam);
            }
            issues.add(new ViewContext((Entity)other).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)"warn.fam.clone", (Object)other.getId(), (Object)fam.getId())));
            this.reportedFams.add(other);
        }
    }

    private boolean isClone(Fam fam, Fam other) {
        if (fam.getHusband() != other.getHusband()) {
            return false;
        }
        if (fam.getWife() != other.getWife()) {
            return false;
        }
        return fam.getProperty("DIV") == null && other.getProperty("DIV") == null;
    }

    @Override
    String getCode() {
        return "07";
    }
}

