/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeRecord;
import ancestris.modules.releve.merge.ProposalHelper;
import ancestris.util.Utilities;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.util.swing.ChoiceWidget;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WitnessChooser
extends JPanel {
    private boolean isBusy = true;
    private ButtonGroup buttonGroup1;
    private JRadioButton existingWitnessRadioButton;
    private JLabel message;
    private JRadioButton newWitnessRadioButton;
    private JTextField witnessTitleTextField;
    private ChoiceWidget witnessesChoiceWidget;

    public WitnessChooser(MergeRecord.RecordWitness recordWitness, Indi selectedWitness, Gedcom gedcom) {
        this.initComponents();
        this.witnessTitleTextField.setText(recordWitness.getDisplayValue());
        if (gedcom != null) {
            ArrayList<Indi> witnesses = new ArrayList<Indi>();
            String wln = Utilities.removeDiacriticsLower((String)recordWitness.getLastName());
            String wfn = Utilities.removeDiacriticsLower((String)recordWitness.getFirstName());
            for (Indi indi : gedcom.getIndis()) {
                String ln = Utilities.removeDiacriticsLower((String)indi.getLastName());
                String fn = Utilities.removeDiacriticsLower((String)indi.getFirstName());
                if (!ln.contains(wln) && !fn.contains(wfn)) continue;
                witnesses.add(indi);
            }
            this.witnessesChoiceWidget.setIgnoreCase(true);
            this.witnessesChoiceWidget.setEditable(true);
            this.witnessesChoiceWidget.setValues(witnesses);
            this.witnessesChoiceWidget.setAutoFilter(true);
            this.witnessesChoiceWidget.setDefaultUpdater();
            if (selectedWitness == null) {
                selectedWitness = ProposalHelper.findWitnessInGedcom(recordWitness, gedcom);
            }
            if (selectedWitness != null) {
                this.witnessesChoiceWidget.setSelectedItem((Object)selectedWitness);
                this.existingWitnessRadioButton.setSelected(true);
            } else {
                this.newWitnessRadioButton.setSelected(true);
                if (!witnesses.isEmpty()) {
                    this.witnessesChoiceWidget.setSelectedIndex(0);
                }
            }
        }
        this.isBusy = false;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.message = new JLabel();
        this.newWitnessRadioButton = new JRadioButton();
        this.existingWitnessRadioButton = new JRadioButton();
        this.witnessTitleTextField = new JTextField();
        this.witnessesChoiceWidget = new ChoiceWidget();
        Mnemonics.setLocalizedText((JLabel)this.message, (String)NbBundle.getMessage(WitnessChooser.class, (String)"WitnessChooser.message.text"));
        this.buttonGroup1.add(this.newWitnessRadioButton);
        this.newWitnessRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.newWitnessRadioButton, (String)NbBundle.getMessage(WitnessChooser.class, (String)"WitnessChooser.newWitnessRadioButton.text"));
        this.buttonGroup1.add(this.existingWitnessRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.existingWitnessRadioButton, (String)NbBundle.getMessage(WitnessChooser.class, (String)"WitnessChooser.existingWitnessRadioButton.text"));
        this.witnessTitleTextField.setEditable(false);
        this.witnessTitleTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                WitnessChooser.this.witnessTitleTextFieldFocusGained(evt);
            }
        });
        this.witnessesChoiceWidget.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WitnessChooser.this.witnessesChoiceWidgetItemStateChanged(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.message, -1, 394, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.newWitnessRadioButton).addComponent(this.existingWitnessRadioButton)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.witnessesChoiceWidget, -1, -1, Short.MAX_VALUE).addComponent(this.witnessTitleTextField)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.message, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.newWitnessRadioButton).addComponent(this.witnessTitleTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.existingWitnessRadioButton).addComponent((Component)this.witnessesChoiceWidget, -2, -1, -2)).addContainerGap()));
    }

    private void witnessTitleTextFieldFocusGained(FocusEvent evt) {
        if (!this.isBusy) {
            this.newWitnessRadioButton.setSelected(true);
        }
    }

    private void witnessesChoiceWidgetItemStateChanged(ItemEvent evt) {
        if (!this.isBusy && evt.getStateChange() == 1) {
            this.existingWitnessRadioButton.setSelected(true);
        }
    }

    public boolean isNew() {
        return this.newWitnessRadioButton.isSelected();
    }

    public String getNewWitnessTitle() {
        return this.witnessTitleTextField.getText();
    }

    public Indi getWitness() {
        return (Indi)this.witnessesChoiceWidget.getSelectedItem();
    }
}

