/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeInfo;
import genj.gedcom.Entity;
import genj.gedcom.PropertyDate;
import genj.io.FileAssociation;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

class MergeLogger {
    private static File logFile;
    private static FileHandler fileHandler;
    static final Logger LOG;
    static final Level ACCEPT;
    static final Level REFUSE;
    static MergeInfo.InfoFormatter infoFormater;

    MergeLogger() {
    }

    static void enable() {
        try {
            if (fileHandler == null) {
                LOG.setUseParentHandlers(false);
                logFile = new File(System.getProperty("java.io.tmpdir"), "relevelog.txt");
                logFile.delete();
                fileHandler = new FileHandler(logFile.getCanonicalPath());
                fileHandler.setEncoding("UTF-8");
                LOG.addHandler(fileHandler);
            } else {
                fileHandler.close();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        LOG.setLevel(Level.FINEST);
    }

    static void disable() {
        if (fileHandler != null) {
            fileHandler.flush();
            fileHandler.close();
        }
        LOG.removeHandler(fileHandler);
        fileHandler = null;
        LOG.setLevel(Level.OFF);
    }

    static LogRecord getAccept(String logFormat, Object ... logArgs) {
        return new LogRecord(ACCEPT, "ACCEPT " + new MergeInfo(logFormat, logArgs).toString(infoFormater));
    }

    static LogRecord getAccept(MergeInfo mergeInfo) {
        return new LogRecord(ACCEPT, "ACCEPT " + mergeInfo.toString(infoFormater));
    }

    static LogRecord getRefuse(String logFormat, Object ... logArgs) {
        return new LogRecord(REFUSE, "REFUSE " + new MergeInfo(logFormat, logArgs).toString(infoFormater));
    }

    static LogRecord getRefuse(MergeInfo mergeInfo) {
        return new LogRecord(REFUSE, "REFUSE " + mergeInfo.toString(infoFormater));
    }

    static void copyFileNameToClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection sel = new StringSelection(logFile.getPath());
        clipboard.setContents(sel, sel);
    }

    static void showLog() throws Exception {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            FileAssociation.getDefault().execute(logFile.getAbsolutePath());
        } else {
            FileAssociation.getDefault().execute(new File(new URI("file://" + logFile.getPath()).getPath()).getAbsolutePath());
        }
    }

    static {
        fileHandler = null;
        LOG = Logger.getLogger("releve");
        LOG.setLevel(Level.OFF);
        ACCEPT = Level.FINE;
        REFUSE = Level.FINEST;
        infoFormater = new MergeInfo.InfoFormatter(){

            @Override
            public Object format(Object arg) {
                if (arg == null) {
                    return "null";
                }
                if (arg instanceof Entity) {
                    return ((Entity)arg).getId();
                }
                if (arg instanceof PropertyDate) {
                    return ((PropertyDate)arg).getValue();
                }
                return arg;
            }
        };
    }
}

