/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import java.util.ArrayList;

public class MergeInfo {
    private final InfoFormatter defaultFormatter;
    private final ArrayList<InfoItem> m_infos = new ArrayList();

    MergeInfo() {
        this.defaultFormatter = new InfoFormatter(){

            @Override
            public Object format(Object arg) {
                if (arg == null) {
                    return "";
                }
                return arg;
            }
        };
    }

    MergeInfo(String format, Object ... args) {
        this.defaultFormatter = new InfoFormatter(){

            @Override
            public Object format(Object arg) {
                if (arg == null) {
                    return "";
                }
                return arg;
            }
        };
        InfoItem infoItem = new InfoItem(format, args);
        this.m_infos.add(infoItem);
    }

    void add(String format, Object ... args) {
        this.m_infos.add(new InfoItem(format, args));
    }

    void addSeparator() {
        this.m_infos.add(null);
    }

    ArrayList<InfoItem> getArgs() {
        return this.m_infos;
    }

    public String toString() {
        return this.toString(this.defaultFormatter);
    }

    public String toString(InfoFormatter infoFormater) {
        StringBuilder format = new StringBuilder();
        ArrayList<Object> arrayArgs = new ArrayList<Object>();
        for (InfoItem item : this.m_infos) {
            if (item != null) {
                format.append(item.format);
                for (Object arg : item.args) {
                    arrayArgs.add(infoFormater.format(arg));
                }
                continue;
            }
            format.append(infoFormater.getSeparator());
        }
        return String.format(format.toString(), arrayArgs.toArray());
    }

    public static abstract class InfoFormatter {
        public abstract Object format(Object var1);

        public String getSeparator() {
            return " ";
        }
    }

    private static class InfoItem {
        String format;
        Object[] args;

        InfoItem(String format, Object ... args) {
            this.format = format;
            this.args = args;
        }
    }
}

