/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.AncestrisActionProvider;
import ancestris.gedcom.PropertyNode;
import ancestris.modules.releve.imageBrowser.BrowserFrame;
import ancestris.modules.releve.imageBrowser.BrowserOptionsPanel;
import ancestris.modules.releve.merge.MergeOption;
import ancestris.modules.releve.merge.ProposalHelper;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertySource;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ImageViewActionProvider
implements AncestrisActionProvider {
    static ImageIcon actionIcon = new ImageIcon(ImageViewActionProvider.class.getResource("/ancestris/modules/releve/images/Camera.png"));

    public List<Action> getActions(boolean hasFocus, Node[] nodes) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (BrowserOptionsPanel.getViewMenuVisible() && nodes.length == 1 && nodes[0] instanceof PropertyNode) {
            PropertyNode node = (PropertyNode)nodes[0];
            for (Property property = node.getProperty(); property != null; property = property.getParent()) {
                if (property instanceof Entity) {
                    this.createAction((Entity)property, actions);
                    break;
                }
                if (!(property instanceof PropertyEvent)) continue;
                this.createAction((PropertyEvent)property, actions);
                break;
            }
        }
        return actions;
    }

    private void createAction(Entity entity, List<Action> actionList) {
        List propertyEventList = entity.getProperties(PropertyEvent.class);
        for (PropertyEvent propertyEvent : propertyEventList) {
            this.createAction(propertyEvent, actionList);
        }
    }

    private void createAction(PropertyEvent propertyEvent, List<Action> actionList) {
        PropertyPlace propertyPlace = (PropertyPlace)propertyEvent.getProperty("PLAC");
        if (propertyPlace != null && propertyPlace.isValid()) {
            Property[] sourceProperties;
            String city = propertyPlace.getCity();
            for (Property sourcePropertie : sourceProperties = propertyEvent.getProperties("SOUR")) {
                List list;
                if (!(sourcePropertie instanceof PropertySource)) continue;
                PropertySource pSource = (PropertySource)sourcePropertie;
                String filepath = "";
                if (MergeOption.getSourceScopeCity()) {
                    list = pSource.getProperties(PropertyMedia.class);
                    if (list.isEmpty()) {
                        source = (Entity)pSource.getTargetEntity().get();
                        list = source != null ? source.getProperties(PropertyMedia.class) : null;
                    }
                } else {
                    source = (Entity)pSource.getTargetEntity().get();
                    List list2 = list = source != null ? source.getProperties(PropertyMedia.class) : null;
                    if (list.isEmpty()) {
                        list = pSource.getProperties(PropertyMedia.class);
                    }
                }
                for (PropertyMedia pMedia : list) {
                    PropertyFile pFile = ProposalHelper.getFileProperty(pMedia);
                    if (pFile == null) continue;
                    filepath = pFile.getValue();
                    File file = pFile.getFile();
                    if (file != null) {
                        filepath = file.getAbsolutePath();
                    }
                    if (filepath.isBlank()) continue;
                    break;
                }
                Property pageProperty = sourcePropertie.getProperty("PAGE");
                String cote = "";
                String page = "";
                if (pageProperty != null && !pageProperty.getValue().isEmpty()) {
                    String[] pageSplit = pageProperty.getValue().split(",");
                    if (pageSplit.length == 1) {
                        cote = "";
                        page = pageSplit[0].trim();
                    } else {
                        cote = pageSplit[0].trim();
                        page = pageSplit[1].trim();
                    }
                }
                if (filepath.isBlank() && city.isBlank() && cote.isBlank() && page.isBlank()) continue;
                Action action = this.createAction(propertyEvent.getTag(), filepath, city, "", cote, page);
                actionList.add(action);
            }
        }
    }

    private Action createAction(String tag, final String filepath, final String city, final String notary, final String cote, final String page) {
        AbstractAncestrisAction action = new AbstractAncestrisAction(){

            public void actionPerformed(ActionEvent e) {
                BrowserFrame.showEventImage(filepath, city, notary, cote, page);
            }
        };
        action.setText(NbBundle.getMessage(BrowserOptionsPanel.class, (String)"ImageViewActionProvider.actionLabel") + ": " + Gedcom.getName((String)tag));
        action.setImage((Icon)actionIcon);
        return action;
    }
}

