/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import ancestris.util.TimingUtility;
import java.io.File;
import java.io.FileFilter;

public class ImageFinder
implements Runnable {
    private static final String INDEX_NAME = "000-";
    private File[] directories;
    DirectoryCityFilter directoryCityFilter;
    DirectoryNotaryFilter directoryNotayFilter;
    DirectoryCoteFilter directoryCoteFilter;
    FileNameFilter fileNameFilter;
    ImageFinderListener listener;
    Thread findThread = null;

    public void findImage(File[] directories, String filepath, String city, String notary, String cote, String page, ImageFinderListener listener) {
        if (this.findThread != null && this.findThread.isAlive()) {
            System.out.println("interrupt !!!");
            this.findThread.interrupt();
        }
        this.directories = directories;
        this.directoryCityFilter = new DirectoryCityFilter(city);
        this.directoryNotayFilter = new DirectoryNotaryFilter(notary);
        this.directoryCoteFilter = new DirectoryCoteFilter(cote);
        this.fileNameFilter = new FileNameFilter(filepath, cote, page);
        this.listener = listener;
        this.findThread = new Thread(this);
        this.findThread.start();
    }

    @Override
    public void run() {
        File directory;
        TimingUtility tu = new TimingUtility();
        File imageFile = null;
        File[] fileArray = this.directories;
        int n = fileArray.length;
        for (int i = 0; i < n && (imageFile = this.findImage(directory = fileArray[i], this.directoryCityFilter, this.directoryNotayFilter, this.directoryCoteFilter, this.fileNameFilter)) == null; ++i) {
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.logResult(null, this.directoryCityFilter.toString(), this.directoryNotayFilter.toString(), this.directoryCoteFilter.toString(), this.fileNameFilter.toString(), tu, imageFile);
            this.listener.onFindResult(imageFile);
        } else {
            System.out.println("findThread isInterrupted");
        }
    }

    private File findImage(File directory, DirectoryCityFilter cityFilter, DirectoryNotaryFilter notaryFilter, DirectoryCoteFilter coteFilter, FileNameFilter fileNameFilter) {
        File imageFile = null;
        if (directory.isDirectory() && !Thread.currentThread().isInterrupted()) {
            int n;
            int n2;
            File[] fileArray;
            File[] files;
            if (imageFile == null && (files = directory.listFiles(fileNameFilter)) != null && files.length > 0) {
                imageFile = files[0];
            }
            if (imageFile == null) {
                File citySubDir;
                File[] cityDirectories;
                fileArray = cityDirectories = directory.listFiles(cityFilter);
                n2 = fileArray.length;
                for (n = 0; n < n2 && (imageFile = this.findImage(citySubDir = fileArray[n], notaryFilter, coteFilter, fileNameFilter)) == null; ++n) {
                }
            }
            if (imageFile == null) {
                File otherSubDir;
                File[] otherDirectories;
                fileArray = otherDirectories = directory.listFiles(new DirectoryFilter());
                n2 = fileArray.length;
                for (n = 0; n < n2 && (imageFile = this.findImage(otherSubDir = fileArray[n], cityFilter, notaryFilter, coteFilter, fileNameFilter)) == null; ++n) {
                }
            }
            if (imageFile == null) {
                imageFile = this.findImage(directory, notaryFilter, coteFilter, fileNameFilter);
            }
        }
        return imageFile;
    }

    private File findImage(File directory, DirectoryNotaryFilter notaryFilter, DirectoryCoteFilter coteFilter, FileNameFilter fileNameFilter) {
        File imageFile = null;
        if (directory.isDirectory() && !Thread.currentThread().isInterrupted()) {
            int n;
            int n2;
            File[] fileArray;
            File[] files;
            if (imageFile == null && (files = directory.listFiles(fileNameFilter)) != null && files.length > 0) {
                imageFile = files[0];
            }
            if (imageFile == null) {
                File notarySubDir;
                File[] notaryDirectories;
                fileArray = notaryDirectories = directory.listFiles(notaryFilter);
                n2 = fileArray.length;
                for (n = 0; n < n2 && (imageFile = this.findImage(notarySubDir = fileArray[n], coteFilter, fileNameFilter)) == null; ++n) {
                }
            }
            if (imageFile == null) {
                File otherSubDir;
                File[] otherDirectories;
                fileArray = otherDirectories = directory.listFiles(new DirectoryFilter());
                n2 = fileArray.length;
                for (n = 0; n < n2 && (imageFile = this.findImage(otherSubDir = fileArray[n], coteFilter, fileNameFilter)) == null; ++n) {
                }
            }
            if (imageFile == null && (files = directory.listFiles(fileNameFilter)) != null && files.length > 0) {
                imageFile = files[0];
            }
        }
        return imageFile;
    }

    private File findImage(File directory, DirectoryCoteFilter coteFilter, FileNameFilter fileNameFilter) {
        File imageFile = null;
        if (directory.isDirectory() && !Thread.currentThread().isInterrupted()) {
            File[] files;
            File coteSubDir;
            int n;
            File[] coteDirectories;
            File[] fileArray = coteDirectories = directory.listFiles(coteFilter);
            int n2 = fileArray.length;
            for (n = 0; n < n2 && (imageFile = this.findImage(coteSubDir = fileArray[n], fileNameFilter)) == null; ++n) {
            }
            if (imageFile == null) {
                File otherSubDir;
                File[] otherDirectories;
                File[] fileArray2 = otherDirectories = directory.listFiles(new DirectoryFilter());
                n = fileArray2.length;
                for (int i = 0; i < n && (imageFile = this.findImage(otherSubDir = fileArray2[i], coteFilter, fileNameFilter)) == null; ++i) {
                }
            }
            if (imageFile == null && (files = directory.listFiles(fileNameFilter)) != null && files.length > 0) {
                imageFile = files[0];
            }
        }
        return imageFile;
    }

    private File findImage(File directory, FileNameFilter fileNameFilter) {
        File imageFile = null;
        if (!directory.isDirectory()) {
            File[] files = directory.listFiles(fileNameFilter);
            if (files != null && files.length > 0) {
                imageFile = files[0];
            }
            if (imageFile == null) {
                File subDir;
                File[] cityDirectories;
                File[] fileArray = cityDirectories = directory.listFiles(new DirectoryFilter());
                int n = fileArray.length;
                for (int i = 0; i < n && (imageFile = this.findImage(subDir = fileArray[i], fileNameFilter)) == null; ++i) {
                }
            }
        }
        return imageFile;
    }

    private static int parsePageInFreeComment(String freeComment) {
        int i;
        int page = -1;
        for (i = freeComment.length() - 1; i >= 0 && freeComment.charAt(i) >= '0' && freeComment.charAt(i) <= '9'; --i) {
        }
        if (++i < freeComment.length()) {
            try {
                page = Integer.parseInt(freeComment.substring(i, freeComment.length()));
            }
            catch (NumberFormatException ex) {
                page = -1;
            }
        }
        return page;
    }

    private static int parsePageInFileName(String name) {
        int i;
        int page = -1;
        for (i = name.length() - 1; i >= 0 && name.charAt(i) >= '0' && name.charAt(i) <= '9'; --i) {
        }
        if (++i < name.length()) {
            try {
                page = Integer.parseInt(name.substring(i, name.length()));
            }
            catch (NumberFormatException ex) {
                page = -1;
            }
        }
        return page;
    }

    private void logResult(File directory, String city, String notary, String cote, String page, TimingUtility tu, File image) {
        System.out.format("Dir=%s, filter=%s, delay=%s ms, found=%s\n", directory != null ? directory.getName() : "All directories", city + "|" + notary + "|" + cote + "|" + page, tu.getDelay(), image != null);
    }

    private static class DirectoryCityFilter
    implements FileFilter {
        String city;

        public DirectoryCityFilter(String reference) {
            this.city = reference.toLowerCase();
        }

        @Override
        public boolean accept(File dir) {
            return dir.isDirectory() && dir.getName().toLowerCase().contains(this.city);
        }

        public String toString() {
            return this.city;
        }
    }

    private static class DirectoryNotaryFilter
    implements FileFilter {
        final String notary;

        public DirectoryNotaryFilter(String reference) {
            this.notary = reference.toLowerCase();
        }

        @Override
        public boolean accept(File dir) {
            if (this.notary.isEmpty()) {
                return false;
            }
            return dir.isDirectory() && dir.getName().toLowerCase().contains(this.notary);
        }

        public String toString() {
            return this.notary;
        }
    }

    private static class DirectoryCoteFilter
    implements FileFilter {
        String cote;

        public DirectoryCoteFilter(String reference) {
            this.cote = reference.toLowerCase();
        }

        @Override
        public boolean accept(File dir) {
            return dir.isDirectory() && dir.getName().toLowerCase().contains(this.cote);
        }

        public String toString() {
            return this.cote;
        }
    }

    private static class FileNameFilter
    implements FileFilter {
        static final String[] EXTENSIONS = new String[]{"jpg", "png", "pdf", "jpeg", "gif", "bmp", "tiff", "tif"};
        String filepath;
        String cote;
        String pageName;
        int pageNumber;

        public FileNameFilter(String filepath, String cote, String page) {
            this.filepath = filepath;
            this.cote = cote.toLowerCase();
            this.pageName = page.toLowerCase();
            this.pageNumber = ImageFinder.parsePageInFreeComment(page);
        }

        @Override
        public boolean accept(File dir) {
            int secondSeparatorPos;
            int firstSeparatorPos;
            int lastSeparatorPos;
            int page;
            if (!dir.isFile()) {
                return false;
            }
            if (this.filepath != null && !this.filepath.isBlank()) {
                return this.filepath.equals(dir.getAbsolutePath());
            }
            String name = dir.getName().toLowerCase();
            boolean extension = false;
            for (String ext : EXTENSIONS) {
                if (!name.endsWith("." + ext)) continue;
                extension = true;
                break;
            }
            if (!extension) {
                return false;
            }
            if (name.contains(ImageFinder.INDEX_NAME)) {
                return false;
            }
            if (!name.contains(this.cote)) {
                return false;
            }
            if (name.contains(this.pageName)) {
                return true;
            }
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex > 0) {
                name = name.substring(0, dotIndex);
            }
            if ((page = ImageFinder.parsePageInFileName(name)) != this.pageNumber && (lastSeparatorPos = name.lastIndexOf(45)) != -1) {
                page = ImageFinder.parsePageInFileName(name.substring(0, lastSeparatorPos));
            }
            if (page != this.pageNumber && (firstSeparatorPos = name.indexOf(45)) != -1 && (secondSeparatorPos = name.indexOf(45, firstSeparatorPos + 1)) != -1) {
                page = ImageFinder.parsePageInFileName(name.substring(firstSeparatorPos + 1, secondSeparatorPos));
            }
            return page == this.pageNumber;
        }

        public String toString() {
            return this.pageName;
        }
    }

    public static interface ImageFinderListener {
        public void onFindResult(File var1);
    }

    private static class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(File dir) {
            return dir.isDirectory();
        }
    }
}

