/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.MainPanelRegister;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.openide.util.NbPreferences;

public class EditorBeanGroup {
    private static final int MY_KEY_C_CEDILLA = KeyEvent.getExtendedKeyCodeForChar(231);
    private static final int MY_KEY_E_ACUTE = KeyEvent.getExtendedKeyCodeForChar(233);
    private static final int MY_KEY_E_GRAVE = KeyEvent.getExtendedKeyCodeForChar(232);
    private static final int MY_KEY_L_PARRENTHESIS = KeyEvent.getExtendedKeyCodeForChar(40);
    static final KeyStroke[] ks1 = new KeyStroke[]{KeyStroke.getKeyStroke(49, 512), KeyStroke.getKeyStroke(150, 512), KeyStroke.getKeyStroke(150, 576), KeyStroke.getKeyStroke(97, 512)};
    static final KeyStroke[] ks2 = new KeyStroke[]{KeyStroke.getKeyStroke(50, 512), KeyStroke.getKeyStroke(MY_KEY_E_ACUTE, 512), KeyStroke.getKeyStroke(MY_KEY_E_ACUTE, 576), KeyStroke.getKeyStroke(98, 512)};
    static final KeyStroke[] ks3 = new KeyStroke[]{KeyStroke.getKeyStroke(51, 512), KeyStroke.getKeyStroke(152, 512), KeyStroke.getKeyStroke(152, 576), KeyStroke.getKeyStroke(99, 512)};
    static final KeyStroke[] ks4 = new KeyStroke[]{KeyStroke.getKeyStroke(52, 512), KeyStroke.getKeyStroke(222, 512), KeyStroke.getKeyStroke(222, 576), KeyStroke.getKeyStroke(100, 512)};
    static final KeyStroke[] ks5 = new KeyStroke[]{KeyStroke.getKeyStroke(53, 512), KeyStroke.getKeyStroke(519, 512), KeyStroke.getKeyStroke(MY_KEY_L_PARRENTHESIS, 512), KeyStroke.getKeyStroke(MY_KEY_L_PARRENTHESIS, 576), KeyStroke.getKeyStroke(101, 512)};
    static final KeyStroke[] ks6 = new KeyStroke[]{KeyStroke.getKeyStroke(54, 512), KeyStroke.getKeyStroke(45, 512), KeyStroke.getKeyStroke(45, 576), KeyStroke.getKeyStroke(102, 512)};
    static final KeyStroke[] ks7 = new KeyStroke[]{KeyStroke.getKeyStroke(55, 512), KeyStroke.getKeyStroke(MY_KEY_E_GRAVE, 512), KeyStroke.getKeyStroke(MY_KEY_E_GRAVE, 576), KeyStroke.getKeyStroke(103, 512)};
    static final KeyStroke[] ks8 = new KeyStroke[]{KeyStroke.getKeyStroke(56, 512), KeyStroke.getKeyStroke(523, 512), KeyStroke.getKeyStroke(523, 576), KeyStroke.getKeyStroke(104, 512)};
    static final KeyStroke[] ks9 = new KeyStroke[]{KeyStroke.getKeyStroke(57, 512), KeyStroke.getKeyStroke(MY_KEY_C_CEDILLA, 512), KeyStroke.getKeyStroke(MY_KEY_C_CEDILLA, 576), KeyStroke.getKeyStroke(105, 512)};

    public static void loadPreferences() {
        for (AbstractRecord.RecordType recordType : AbstractRecord.RecordType.values()) {
            for (BeanGroup group : BeanGroup.getGroups(recordType)) {
                for (BeanField field : group.getFields()) {
                    String preferenceKey = "Editor." + group.getId().name() + "." + field.getFieldType().name() + "." + recordType.name();
                    String defaultValue = field.isUsed() + ";" + field.isVisible();
                    String preferenceValue = NbPreferences.forModule(MainPanelRegister.class).get(preferenceKey, defaultValue);
                    try {
                        StringTokenizer tokens = new StringTokenizer(preferenceValue, ";");
                        if (tokens.countTokens() != 2) continue;
                        tokens.nextToken();
                        field.setVisible(Boolean.valueOf(tokens.nextToken()));
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    public static void savePreferences() {
        for (AbstractRecord.RecordType recordType : AbstractRecord.RecordType.values()) {
            for (BeanGroup group : BeanGroup.getGroups(recordType)) {
                for (BeanField field : group.getFields()) {
                    String preferenceKey = "Editor." + group.getId().name() + "." + field.getFieldType().name() + "." + recordType.name();
                    String preferenceValue = field.isUsed() + ";" + field.isVisible();
                    NbPreferences.forModule(EditorBeanGroup.class).put(preferenceKey, preferenceValue);
                }
            }
        }
    }

    public static KeyStroke[] getGroupKeystrokes(BeanGroup.GroupId groupId) {
        switch (groupId) {
            case general: {
                return ks1;
            }
            case indi: {
                return ks2;
            }
            case indiMarried: {
                return null;
            }
            case indiFather: {
                return ks3;
            }
            case indiMother: {
                return ks4;
            }
            case wife: {
                return ks5;
            }
            case wifeMarried: {
                return null;
            }
            case wifeFather: {
                return ks6;
            }
            case wifeMother: {
                return ks7;
            }
            case witness1: {
                return ks8;
            }
            case witness2: {
                return null;
            }
            case witness3: {
                return null;
            }
            case witness4: {
                return null;
            }
            case generalComment: {
                return ks9;
            }
        }
        return null;
    }

    static {
        EditorBeanGroup.loadPreferences();
    }
}

