/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.editor;

import ancestris.modules.releve.editor.Bean;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldDate;
import genj.gedcom.GedcomException;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.swing.DateWidget;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

public class BeanDate
extends Bean {
    private static final NestedBlockLayout H = new NestedBlockLayout("<row><choose/><date1/><label2/><date2/><phrase/></row>");
    private static final NestedBlockLayout V = new NestedBlockLayout("<table><row><choose/><date1/></row><row><label2/><date2/></row><row><phrase cols=\"2\"/></row></table>");
    private DateWidget dateWidget;
    private Calendar preferedCalendar = PointInTime.GREGORIAN;

    public BeanDate() {
        this.setLayout((LayoutManager)V.copy());
        this.setAlignmentX(0.0f);
        this.dateWidget = new DateWidget();
        this.dateWidget.addChangeListener((ChangeListener)this.changeSupport);
        this.add((Component)this.dateWidget);
        this.setPreferedCalendar((Calendar)PointInTime.GREGORIAN, (Calendar)PointInTime.FRENCHR);
        this.defaultFocus = this.dateWidget;
        int pos = 1;
        switch (new SimpleDateFormat().toPattern().toLowerCase().charAt(0)) {
            case 'm': {
                pos = 2;
                break;
            }
            case 'd': {
                pos = 1;
                break;
            }
            default: {
                pos = 1;
            }
        }
        Component component = this.dateWidget.getComponent(pos);
        if (component instanceof JTextField) {
            JTextField jTextFieldDay = (JTextField)component;
            jTextFieldDay.getInputMap(0).remove(KeyStroke.getKeyStroke(38, 0));
            jTextFieldDay.getInputMap(0).remove(KeyStroke.getKeyStroke(40, 0));
            jTextFieldDay.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), "Increase");
            jTextFieldDay.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), "Decrease");
            jTextFieldDay.getActionMap().put("Increase", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BeanDate.this.dateWidget.setValue(BeanDate.this.dateWidget.getValue().add(1, 0, 0));
                }
            });
            jTextFieldDay.getActionMap().put("Decrease", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BeanDate.this.dateWidget.setValue(BeanDate.this.dateWidget.getValue().add(-1, 0, 0));
                }
            });
            this.defaultFocus = jTextFieldDay;
        }
    }

    public final void setPreferedCalendar(Calendar prefered, Calendar alternate) {
        this.preferedCalendar = prefered;
        this.dateWidget.setPreferedCalendar(prefered, alternate);
    }

    @Override
    public void setFieldImpl() {
        PointInTime pit;
        FieldDate fieldDate = (FieldDate)this.getField();
        PropertyDate prop = null;
        if (fieldDate != null) {
            prop = fieldDate.getPropertyDate();
        }
        if (prop == null) {
            pit = new PointInTime();
        } else {
            pit = prop.getStart();
            if (pit.getCalendar() != this.preferedCalendar) {
                try {
                    pit = pit.getPointInTime(this.preferedCalendar);
                }
                catch (GedcomException gedcomException) {
                    // empty catch block
                }
            }
        }
        this.dateWidget.setValue(pit);
    }

    @Override
    protected void replaceValueImpl(Field field) {
        PointInTime pit;
        FieldDate fieldDate = (FieldDate)field;
        PropertyDate prop = null;
        if (fieldDate != null) {
            prop = fieldDate.getPropertyDate();
        }
        if (prop == null) {
            pit = new PointInTime();
        } else {
            pit = prop.getStart();
            if (pit.getCalendar() != this.preferedCalendar) {
                try {
                    pit = pit.getPointInTime(this.preferedCalendar);
                }
                catch (GedcomException gedcomException) {
                    // empty catch block
                }
            }
        }
        this.dateWidget.setValue(pit);
        if (this.dateWidget.getComponent(0) != null && this.dateWidget.getComponent(0) instanceof JTextField) {
            ((JTextField)this.dateWidget.getComponent(0)).selectAll();
        }
    }

    @Override
    protected void commitImpl() {
        String result;
        PointInTime pit = this.dateWidget.getValue();
        if (pit != null) {
            if (this.dateWidget.getCalendar() != PointInTime.GREGORIAN) {
                try {
                    pit = pit.getPointInTime((Calendar)PointInTime.GREGORIAN);
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return;
                }
            }
            int day2 = pit.getDay();
            int month2 = pit.getMonth();
            int year2 = pit.getYear();
            result = year2 == Integer.MAX_VALUE ? "" : (month2 == Integer.MAX_VALUE ? String.format("%04d", year2) : (day2 == Integer.MAX_VALUE ? String.format("%02d/%04d", month2 + 1, year2) : String.format("%02d/%02d/%04d", day2 + 1, month2 + 1, year2)));
        } else {
            result = "";
        }
        this.setFieldValue(result);
    }
}

