/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.dnd;

import ancestris.modules.releve.merge.MergeDialog;
import ancestris.view.AncestrisTopComponent;
import ancestris.view.DelegatedTransferable;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.TransferHandler;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class TransferableRecord
implements DelegatedTransferable {
    public static final DataFlavor recordFlavor = new DataFlavor(TransferableData.class, "MergeRecord");
    protected static DataFlavor[] supportedFlavors = new DataFlavor[]{DELEGATED_FLAVOR, recordFlavor};
    TransferableData data = new TransferableData();

    public TransferableRecord(TransferableData data) {
        this.data = data;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return supportedFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor df : supportedFlavors) {
            if (!df.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == recordFlavor) {
            return this.data;
        }
        if (flavor == DELEGATED_FLAVOR) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public boolean runDelegation(TopComponent tc, Gedcom targetGedcom, Entity targetEntiry, TransferHandler.TransferSupport support) {
        if (tc instanceof AncestrisTopComponent && targetGedcom != null) {
            block6: {
                try {
                    TransferableData transferableData = (TransferableData)support.getTransferable().getTransferData(recordFlavor);
                    try {
                        MergeDialog.show((Component)tc, targetGedcom, targetEntiry, transferableData);
                    }
                    catch (Exception throwable) {
                        Toolkit.getDefaultToolkit().beep();
                        String title = NbBundle.getMessage(MergeDialog.class, (String)"error.title.MergeDialog");
                        String msg = NbBundle.getMessage(MergeDialog.class, (String)"error.msg.MergeDialog");
                        if (throwable.getMessage() == null) {
                            JOptionPane.showMessageDialog(null, throwable.getClass().getName() + " " + msg, title, 0);
                            break block6;
                        }
                        JOptionPane.showMessageDialog(null, throwable.getMessage(), title, 0);
                    }
                }
                catch (UnsupportedFlavorException | IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return true;
        }
        return false;
    }

    public static class TransferableData {
        public Component sourceComponent;
        public String fileName = "";
        public String cityName = "";
        public String cityCode = "";
        public String countyName = "";
        public String stateName = "";
        public String countryName = "";
        public String recordType = "";
        public String eventTag = "";
        public String eventType = "";
        public String eventPlace;
        public String cote = "";
        public String freeComment = "";
        public String eventDate;
        public String secondDate;
        public String notary = "";
        public String parish = "";
        public Participant participant1 = new Participant();
        public Participant participant2 = new Participant();
        public Witness witness1 = new Witness();
        public Witness witness2 = new Witness();
        public Witness witness3 = new Witness();
        public Witness witness4 = new Witness();
        public String generalComment = "";
        public String deedText = "";
        public String eventMedia = "";

        public class Participant {
            public String firstName = "";
            public String lastName = "";
            public String sex = "";
            public String age = "";
            public String birthDate;
            public String birthPlace = "";
            public String birthAddress = "";
            public String deathDate;
            public String deathPlace = "";
            public String deathAddress = "";
            public String occupation = "";
            public String residence = "";
            public String address = "";
            public String comment = "";
            public String marriedFirstName = "";
            public String marriedLastName = "";
            public String marriedComment = "";
            public String marriedOccupation = "";
            public String marriedResidence = "";
            public String marriedAddress = "";
            public String marriedDead = "";
            public String fatherFirstName = "";
            public String fatherLastName = "";
            public String fatherOccupation = "";
            public String fatherResidence = "";
            public String fatherAddress = "";
            public String fatherAge = "";
            public String fatherDead = "";
            public String fatherComment = "";
            public String motherFirstName = "";
            public String motherLastName = "";
            public String motherOccupation = "";
            public String motherResidence = "";
            public String motherAddress = "";
            public String motherAge = "";
            public String motherDead = "";
            public String motherComment = "";
        }

        public class Witness {
            public String firstName = "";
            public String lastName = "";
            public String occupation = "";
            public String comment = "";
        }
    }
}

