/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard.tools;

import ancestris.modules.editors.standard.tools.Utils;
import ancestris.modules.viewers.media.MediaWrapper;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertyRepository;
import genj.gedcom.PropertySource;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.io.InputSource;
import genj.renderer.MediaUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.util.Exceptions;

public class SourceWrapper {
    private static int ENTITY_MOUNT = 0;
    private static int CITATION_MOUNT = 1;
    private static Map<String, Integer> mounts;
    public static Icon[] qualityIcons;
    private Property hostingProperty = null;
    private boolean recordType = true;
    private Entity targetSource = null;
    private String title = "";
    private String text = "";
    private Repository targetRepo = null;
    private String repoName = "";
    private String caln = "";
    public List<MediaWrapper> sourceMediaSet = null;
    public List<MediaWrapper> sourceMediaRemovedSet = null;
    public int sourceMediaIndex = 0;
    private String page = "";
    private int quality = -1;

    public SourceWrapper(Property hostingProperty) {
        if (hostingProperty instanceof PropertySource) {
            PropertySource propertySource = (PropertySource)hostingProperty;
            this.hostingProperty = hostingProperty;
            this.setSourceFromEntity(propertySource.getTargetEntity().orElse(null));
            this.setSourcePropertiesFromCitation(hostingProperty);
        } else if (hostingProperty instanceof Source || hostingProperty == null) {
            this.setSourceFromEntity((Source)hostingProperty);
        } else {
            this.hostingProperty = hostingProperty;
            this.targetSource = null;
            this.resetMediaSet();
            this.setInfoFromCitation(hostingProperty);
            this.getMediaFromProperty(hostingProperty);
        }
    }

    public final void setSourceFromEntity(Source source) {
        this.targetSource = source;
        this.resetMediaSet();
        this.setInfoFromRecord((Property)source);
        this.getMediaFromProperty((Property)source);
        if (this.hostingProperty != null) {
            this.getMediaFromProperty(this.hostingProperty);
        }
    }

    public SourceWrapper(String title) {
        this.setTitle(title);
    }

    public SourceWrapper(Repository repo) {
        this.setRepo(repo);
    }

    public SourceWrapper(MediaWrapper media) {
        this.resetMediaSet();
        this.sourceMediaSet.add(media);
    }

    public SourceWrapper(InputSource f) {
        this.setMediaFile(f, false);
    }

    public Property getHostingProperty() {
        return this.hostingProperty;
    }

    public void setHostingProperty(Property property) {
        this.hostingProperty = property;
    }

    private void resetMediaSet() {
        if (this.sourceMediaSet != null) {
            this.sourceMediaSet.clear();
            this.sourceMediaSet = null;
        }
        if (this.sourceMediaRemovedSet != null) {
            this.sourceMediaRemovedSet.clear();
            this.sourceMediaRemovedSet = null;
        }
        this.sourceMediaSet = new ArrayList<MediaWrapper>();
        this.sourceMediaRemovedSet = new ArrayList<MediaWrapper>();
        this.sourceMediaIndex = 0;
    }

    public final void getMediaFromProperty(Property property) {
        Property[] mediaProps;
        if (this.sourceMediaSet == null || property == null) {
            return;
        }
        for (Property prop : mediaProps = property.getProperties("OBJE", true)) {
            this.sourceMediaSet.add(new MediaWrapper(prop));
        }
    }

    public boolean isRecord() {
        return this.recordType;
    }

    public Entity getTargetSource() {
        return this.targetSource;
    }

    public String getTitle() {
        return this.title;
    }

    public final void setTitle(String str) {
        this.title = str;
    }

    public String getText() {
        return this.text;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public void setMedia(MediaWrapper media, boolean addMedia) {
        if (this.sourceMediaSet == null) {
            this.resetMediaSet();
        }
        if (this.sourceMediaSet.isEmpty() || addMedia) {
            this.sourceMediaSet.add(media);
        } else {
            this.sourceMediaSet.set(this.sourceMediaIndex, media);
        }
    }

    public boolean deleteMedia() {
        if (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty() || this.sourceMediaRemovedSet == null) {
            return false;
        }
        this.sourceMediaRemovedSet.add(this.sourceMediaSet.get(this.sourceMediaIndex));
        this.sourceMediaSet.remove(this.sourceMediaIndex);
        --this.sourceMediaIndex;
        if (this.sourceMediaIndex < 0) {
            this.sourceMediaIndex = 0;
        }
        return true;
    }

    public String getMediaTitle() {
        if (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty()) {
            return "";
        }
        return this.sourceMediaSet.get(this.sourceMediaIndex).getTitle();
    }

    public void setMediaTitle(String title) {
        if (this.sourceMediaSet == null) {
            this.resetMediaSet();
        }
        if (this.sourceMediaSet.isEmpty()) {
            this.sourceMediaSet.add(new MediaWrapper(title));
        } else {
            MediaWrapper mediaW = this.sourceMediaSet.get(this.sourceMediaIndex);
            if (title.isEmpty() && mediaW.getHostingProperty() == null && mediaW.getInputSource() == null && mediaW.getTargetMedia() == null) {
                this.sourceMediaSet.remove(mediaW);
            } else {
                this.sourceMediaSet.get(this.sourceMediaIndex).setTitle(title);
            }
        }
    }

    public final void setMediaFile(InputSource f, boolean addMedia) {
        if (this.sourceMediaSet == null) {
            this.resetMediaSet();
        }
        if (this.sourceMediaSet.isEmpty() || addMedia && this.sourceMediaSet.get(this.sourceMediaIndex).getInputSource() != null) {
            this.sourceMediaSet.add(new MediaWrapper(f));
        } else {
            this.sourceMediaSet.get(this.sourceMediaIndex).setInputSource(f);
        }
    }

    public InputSource getMediaFile() {
        if (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty()) {
            return null;
        }
        return this.sourceMediaSet.get(this.sourceMediaIndex).getInputSource();
    }

    public String getRepoName() {
        return this.repoName + (String)(this.caln.isEmpty() ? "" : " (" + this.caln + ")");
    }

    public void setRepoName(String name) {
        this.repoName = name;
    }

    public final void setRepo(Repository repo) {
        this.targetRepo = repo;
        this.repoName = repo == null ? "" : this.targetRepo.getRepositoryName();
    }

    public Repository getRepo() {
        return this.targetRepo;
    }

    private void setInfoFromRecord(Property property) {
        this.recordType = true;
        if (property == null) {
            return;
        }
        Property propTitle = property.getProperty("TITL", true);
        this.title = propTitle != null ? propTitle.getDisplayValue() : "";
        Property propText = property.getProperty("TEXT", true);
        this.text = propText != null ? propText.getDisplayValue() : "";
        Property propRepository = property.getProperty("REPO", true);
        if (propRepository != null && propRepository.isValid() && propRepository instanceof PropertyRepository) {
            PropertyRepository pr = (PropertyRepository)propRepository;
            this.targetRepo = (Repository)pr.getTargetEntity().get();
            this.repoName = this.targetRepo.getRepositoryName();
            Property calnProp = pr.getProperty("CALN");
            if (calnProp != null) {
                this.caln = calnProp.getValue();
            }
        } else {
            this.targetRepo = null;
            this.repoName = "";
        }
    }

    private void setInfoFromCitation(Property property) {
        this.recordType = false;
        if (property == null) {
            return;
        }
        this.title = property.getDisplayValue().trim();
        Property propText = property.getProperty("TEXT");
        if (propText != null) {
            this.text = propText.getDisplayValue();
        }
    }

    private void setSourcePropertiesFromCitation(Property property) {
        if (property == null || !(property instanceof PropertySource)) {
            return;
        }
        this.page = property.getPropertyValue("PAGE");
        Property prop = property.getProperty("QUAY");
        if (prop != null && prop instanceof PropertyQuality) {
            PropertyQuality qualityProp = (PropertyQuality)prop;
            this.quality = qualityProp.getQuality();
        }
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public Icon getQualityIcon() {
        return qualityIcons[this.quality + 1];
    }

    public void setQuality(int quality) {
        this.quality = quality;
    }

    public int getQuality() {
        return this.quality;
    }

    public static Icon getDefaultQualityIcon() {
        return qualityIcons[0];
    }

    public void update(Property mainProp) {
        if (this.hostingProperty == null) {
            if (this.title.isEmpty() && this.text.isEmpty() && this.targetRepo == null && (this.sourceMediaSet == null || this.sourceMediaSet.isEmpty())) {
                return;
            }
            try {
                Property p;
                if (this.targetSource == null) {
                    this.targetSource = mainProp.getGedcom().createEntity("SOUR");
                }
                int posTo = (p = mainProp.getProperty("SOUR")) == null ? 0 : mainProp.getPropertyPosition(p) + 1;
                this.hostingProperty = mainProp.addSource((Source)this.targetSource);
                this.putSourceProperties(this.hostingProperty);
                int posFrom = mainProp.getPropertyPosition(this.hostingProperty);
                if (posFrom < posTo) {
                    this.hostingProperty.getParent().moveProperty(this.hostingProperty, posTo);
                }
                this.putSourceRecord((Property)((Source)this.targetSource));
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (!this.recordType) {
            this.putSourceCitation(this.hostingProperty);
        } else {
            try {
                if (this.targetSource == null) {
                    this.targetSource = mainProp.getGedcom().createEntity("SOUR");
                }
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.recordType && this.hostingProperty instanceof PropertySource) {
                this.putSourceRecord((Property)this.targetSource);
                this.putSourceProperties(this.hostingProperty);
                PropertySource ps = (PropertySource)this.hostingProperty;
                Entity tse = ps.getTargetEntity().orElse(null);
                if (!this.targetSource.equals(tse)) {
                    MediaUtils.replaceRef((PropertyXRef)ps, (Entity)tse, (Entity)this.targetSource);
                }
            } else if (this.recordType && !(this.hostingProperty instanceof PropertySource)) {
                this.hostingProperty.getParent().delProperty(this.hostingProperty);
                Property p = mainProp.getProperty("SOUR");
                int posTo = p == null ? 0 : mainProp.getPropertyPosition(p) + 1;
                this.hostingProperty = mainProp.addSource((Source)this.targetSource);
                this.putSourceProperties(this.hostingProperty);
                int posFrom = mainProp.getPropertyPosition(this.hostingProperty);
                if (posFrom < posTo) {
                    this.hostingProperty.getParent().moveProperty(this.hostingProperty, posTo);
                }
                this.putSourceRecord((Property)this.targetSource);
            }
        }
    }

    public void reposition(int index) {
        if (this.hostingProperty != null && this.hostingProperty.getParent() != null) {
            Property p = this.hostingProperty.getParent().getProperty("SOUR");
            int startingPos = this.hostingProperty.getParent().getPropertyPosition(p);
            int currentPos = this.hostingProperty.getParent().getPropertyPosition(this.hostingProperty);
            if (currentPos != startingPos + index) {
                this.hostingProperty.getParent().moveProperty(this.hostingProperty, startingPos + index);
            }
        }
    }

    private void putSourceRecord(Property property) {
        Property propRepository;
        if (property == null) {
            return;
        }
        this.putProperty(property, "TITL", this.title);
        this.putProperty(property, "TEXT", this.text);
        Property host = this.getDefaultHost(property);
        this.putMediaItems(host);
        if (this.repoName.isEmpty() && this.targetRepo == null) {
            PropertyRepository pr;
            Repository tmpRepo;
            Property propRepository2 = property.getProperty("REPO", true);
            if (propRepository2 != null && propRepository2.isValid() && propRepository2 instanceof PropertyRepository && (tmpRepo = (Repository)(pr = (PropertyRepository)propRepository2).getTargetEntity().get()) != null) {
                property.delProperty(propRepository2);
            }
            return;
        }
        if (this.targetRepo == null) {
            try {
                this.targetRepo = (Repository)property.getGedcom().createEntity("REPO");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (!this.targetRepo.getRepositoryName().equals(this.repoName)) {
            this.targetRepo.setRepositoryName(this.repoName);
        }
        if ((propRepository = property.getProperty("REPO", true)) != null && propRepository.isValid() && propRepository instanceof PropertyRepository) {
            PropertyRepository pr = (PropertyRepository)propRepository;
            Repository tmpRepo = (Repository)pr.getTargetEntity().get();
            if (tmpRepo != this.targetRepo) {
                property.delProperty(propRepository);
                property.addRepository(this.targetRepo);
            }
        } else {
            property.addRepository(this.targetRepo);
        }
    }

    private void putSourceProperties(Property host) {
        PropertyQuality quay;
        if (host == null || !(host instanceof PropertySource)) {
            return;
        }
        Property pageProp = host.getProperty("PAGE");
        if (pageProp == null && !this.page.isEmpty()) {
            pageProp = host.addProperty("PAGE", this.page);
        } else if (pageProp != null && this.page.isEmpty()) {
            host.delProperty(pageProp);
        } else if (pageProp != null && !this.page.isEmpty()) {
            Utils.setDistinctValue(pageProp, this.page);
        }
        Property quayProp = host.getProperty("QUAY");
        if (quayProp == null && this.quality != -1) {
            quayProp = host.addProperty("QUAY", "");
            PropertyQuality quay2 = (PropertyQuality)quayProp;
            quay2.setQuality(this.quality);
        } else if (quayProp != null && this.quality == -1) {
            host.delProperty(quayProp);
        } else if (quayProp != null && this.quality != -1 && (quay = (PropertyQuality)quayProp).getQuality() != this.quality) {
            quay.setQuality(this.quality);
        }
    }

    private void putSourceCitation(Property property) {
        Utils.setDistinctValue(property, this.title);
        this.putProperty(property, "TEXT", this.text);
        if (property.getMetaProperty().allows("OBJE")) {
            this.putMediaItems(property);
        }
        if (this.title.trim().isEmpty()) {
            property.delProperties("TITL");
        }
        if (this.text.trim().isEmpty()) {
            property.delProperties("TEXT");
        }
    }

    public void remove() {
        if (this.hostingProperty == null) {
            return;
        }
        this.hostingProperty.getParent().delProperty(this.hostingProperty);
    }

    private void putProperty(Property property, String tag, String value) {
        Property prop = property.getProperty(tag, true);
        if (prop != null) {
            Utils.setDistinctValue(prop, value);
        } else if (!value.isEmpty()) {
            property.addProperty(tag, value);
        }
    }

    private void putMediaItems(Property property) {
        if ((this.sourceMediaSet == null || this.sourceMediaSet.isEmpty()) && (this.sourceMediaRemovedSet == null || this.sourceMediaRemovedSet.isEmpty())) {
            return;
        }
        for (MediaWrapper media2 : this.sourceMediaSet) {
            media2.update(property);
        }
        if (this.sourceMediaSet.size() > 1) {
            int index = 0;
            Property oldHostParent = null;
            for (MediaWrapper media3 : this.sourceMediaSet) {
                if (media3.getHostingProperty() == null) continue;
                Property newHostParent = media3.getHostingProperty().getParent();
                if (newHostParent != oldHostParent) {
                    index = 0;
                    oldHostParent = newHostParent;
                }
                media3.reposition(index);
                ++index;
            }
        }
        this.sourceMediaRemovedSet.forEach(media -> media.remove());
    }

    private Property getDefaultHost(Property property) {
        String gedcomName;
        Integer type;
        if (mounts == null) {
            mounts = new HashMap<String, Integer>();
        }
        if ((type = mounts.get(gedcomName = property.getGedcom().getOrigin().getFile().getAbsolutePath())) == null) {
            type = this.getMountType(property.getGedcom());
            mounts.put(gedcomName, type);
        }
        return type == ENTITY_MOUNT ? property : this.hostingProperty;
    }

    private Integer getMountType(Gedcom gedcom) {
        String[] ENTITIES;
        double count = 0.0;
        double total = 0.0;
        for (String type : ENTITIES = new String[]{"INDI", "FAM"}) {
            Collection entities = gedcom.getEntities(type);
            for (Entity entity : entities) {
                List properties = entity.getProperties(PropertySource.class);
                total += (double)properties.size();
                for (PropertySource prop : properties) {
                    count += (double)prop.getProperties("OBJE", false).length;
                }
            }
        }
        if (total == 0.0 || count == 0.0) {
            return ENTITY_MOUNT;
        }
        double ratio = count / total;
        if (ratio > 0.5) {
            return CITATION_MOUNT;
        }
        return ENTITY_MOUNT;
    }

    static {
        qualityIcons = new Icon[5];
        for (int i = 0; i < qualityIcons.length; ++i) {
            SourceWrapper.qualityIcons[i] = new ImageIcon(SourceWrapper.class.getResource("/ancestris/modules/editors/standard/images/Quay" + i + ".png"));
        }
    }
}

