/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.geoplace.format;

import ancestris.modules.editors.geoplace.format.PlaceFormatConverterPanel;
import genj.gedcom.Gedcom;
import genj.gedcom.PropertyPlace;
import java.util.List;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GedcomPlacesAligner {
    private final Gedcom gedcom;
    private Exception error = null;
    private int nbOfAlignedPlaces = 0;
    private int nbOfPlaces = 0;

    public GedcomPlacesAligner(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public boolean convert() {
        this.error = null;
        this.nbOfAlignedPlaces = 0;
        this.nbOfPlaces = 0;
        try {
            String[] locs = null;
            List places = this.gedcom.getPropertiesByClass(PropertyPlace.class);
            for (PropertyPlace place : places) {
                if (!place.setJurisdictions(this.gedcom, locs = place.getJurisdictions())) {
                    ++this.nbOfAlignedPlaces;
                }
                ++this.nbOfPlaces;
            }
        }
        catch (Exception e) {
            String msg = new Exception(e).getLocalizedMessage();
            this.error = new Exception(NbBundle.getMessage(PlaceFormatConverterPanel.class, (String)"ERR_Exception") + " " + msg + "!");
            Exceptions.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    public int getNbOfPlacesAligned() {
        return this.nbOfAlignedPlaces;
    }

    public Object getNbOfPlaces() {
        return this.nbOfPlaces;
    }

    public Exception getError() {
        if (this.error == null) {
            this.error = new Exception(NbBundle.getMessage(GedcomPlacesAligner.class, (String)"ERR_Unknown"));
        }
        return this.error;
    }
}

