/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.time.GregorianCalendar;
import genj.gedcom.time.PointInTime;

public class JulianCalendar
extends GregorianCalendar {
    protected JulianCalendar() {
        super("@#DJULIAN@", "JULIAN", "julian", "images/Julian");
    }

    @Override
    protected boolean isLeap(int year) {
        return year % 4 == 0;
    }

    @Override
    protected int toJulianDay(int day, int month, int year) {
        if (year < 0) {
            ++year;
        }
        int a = (14 - (month + 1)) / 12;
        int y = year + 4800 - a;
        int m = month + 1 + 12 * a - 3;
        return day + 1 + (153 * m + 2) / 5 + 365 * y + y / 4 - 32083;
    }

    @Override
    protected PointInTime toPointInTime(int julianDay) {
        int Z = julianDay;
        int B = Z + 1524;
        int C = (int)(((double)B - 122.1) / 365.25);
        int D = (int)(365.25 * (double)C);
        int E = (int)((double)(B - D) / 30.6001);
        int F = (int)(30.6001 * (double)E);
        int d = B - D - F;
        int m = E - 1 <= 12 ? E - 1 : E - 13;
        int y = C - (m < 3 ? 4715 : 4716);
        return new PointInTime(d - 1, m - 1, y <= 0 ? y - 1 : y, this);
    }
}

